import { ColorProperty } from 'csstype';
import { CsxColorStop, StringType, CSSAngle, CSSSideOrCorner, CSSGradient } from './types';
/**
 * Helper for the linear-gradient function in CSS
 * https://drafts.csswg.org/css-images-3/#funcdef-linear-gradient
 */
export declare function linearGradient(position: CSSAngle | CSSSideOrCorner, ...colors: (ColorProperty | StringType<ColorProperty> | CsxColorStop)[]): CSSGradient;
/**
 * Helper for the repeating-linear-gradient function in CSS
 * https://drafts.csswg.org/css-images-3/#funcdef-repeating-linear-gradient
 */
export declare function repeatingLinearGradient(position: CSSAngle | CSSSideOrCorner, ...colors: (ColorProperty | StringType<ColorProperty> | CsxColorStop)[]): CSSGradient;
