"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNode = exports.getLineType = exports.getMultiLinePhrase = exports.getLineState = exports.Charts = void 0;
var types_1 = require("./types");
exports.Charts = {
    space: ' ',
    equal: '=',
    commentHash: '#',
    commentDash: '//',
    multilineCommentStart: '/*',
    multilineCommentEnd: '*/',
    multilinePhrase: '<<',
    openBracketsObject: '{',
    closeBracketsObject: '}',
    openBracketsArray: '[',
    closeBracketsArray: ']',
    openFunction: '(',
    closeFunction: ')',
};
function getLineState(line, isMultiLineComment, multiLinePhrase) {
    var multiCommentLine = isMultiLineComment;
    var ignoredLine = false;
    if (line.content.startsWith(exports.Charts.multilineCommentStart)) {
        ignoredLine = true;
        multiCommentLine = true;
    }
    if (line.content.includes(exports.Charts.multilineCommentEnd)) {
        // Multiline comment ended - this is still a commented line
        ignoredLine = true;
        multiCommentLine = false;
    }
    if (line.content.startsWith(exports.Charts.commentHash) ||
        line.content.startsWith(exports.Charts.commentDash) ||
        line.content.length === 0 //Empty Line
    ) {
        ignoredLine = true;
    }
    // Inside a multiline comment
    if (isMultiLineComment && !ignoredLine) {
        ignoredLine = true;
    }
    // Inside a multiline phrase
    if (multiLinePhrase.phrase &&
        !line.content.includes(multiLinePhrase.phrase)) {
        ignoredLine = true;
    }
    return {
        ignoredLine: ignoredLine,
        multiCommentLine: multiCommentLine,
    };
}
exports.getLineState = getLineState;
function getMultiLinePhrase(line) {
    var phrase = line.content
        .split(exports.Charts.multilinePhrase)[1]
        .trim()
        .split(exports.Charts.space)[0];
    return { phrase: phrase };
}
exports.getMultiLinePhrase = getMultiLinePhrase;
function getLineType(line, currentObjectType) {
    if (!currentObjectType) {
        if (line.content.includes(exports.Charts.openBracketsObject)) {
            if (line.content.includes(exports.Charts.closeBracketsObject)) {
                return types_1.TFLineTypes.TYPE_START_AND_END;
            }
            return types_1.TFLineTypes.TYPE_START;
        }
        throw new SyntaxError('Invalid TF input - TF Object without parent Type');
    }
    if (line.content.includes(exports.Charts.openBracketsArray)) {
        if (line.content.includes(exports.Charts.closeBracketsArray)) {
            return types_1.TFLineTypes.ARRAY_START_AND_END;
        }
        return types_1.TFLineTypes.ARRAY_START;
    }
    if (line.content.includes(exports.Charts.closeBracketsArray)) {
        return types_1.TFLineTypes.ARRAY_END;
    }
    if (line.content.includes(exports.Charts.multilinePhrase)) {
        return types_1.TFLineTypes.MULTILINE_STRING;
    }
    if (line.content.includes(exports.Charts.openFunction)) {
        if (line.content.includes(exports.Charts.closeFunction)) {
            return types_1.TFLineTypes.FUNCTION_START_AND_END;
        }
        return types_1.TFLineTypes.FUNCTION_START;
    }
    if (line.content.includes(exports.Charts.openBracketsObject)) {
        if (line.content.includes(exports.Charts.closeBracketsObject)) {
            if (line.content.includes(exports.Charts.equal)) {
                return types_1.TFLineTypes.STRING;
            }
            return types_1.TFLineTypes.OBJECT_START_AND_END;
        }
        return types_1.TFLineTypes.OBJECT_START;
    }
    if (line.content.includes(exports.Charts.closeFunction)) {
        if (currentObjectType != types_1.TFLineTypes.FUNCTION_START) {
            throw new SyntaxError('Invalid TF input - Close function sign without open function');
        }
        return types_1.TFLineTypes.FUNCTION_END;
    }
    if (currentObjectType === types_1.TFLineTypes.FUNCTION_START) {
        if (line.content.split(exports.Charts.space).length === 1) {
            return types_1.TFLineTypes.IGNORE;
        }
        return types_1.TFLineTypes.STRING;
    }
    if (line.content.includes(exports.Charts.equal)) {
        return types_1.TFLineTypes.STRING;
    }
    if (line.content.includes(exports.Charts.closeBracketsObject)) {
        if (currentObjectType === types_1.TFLineTypes.SUB_TYPE) {
            return types_1.TFLineTypes.TYPE_END;
        }
        return types_1.TFLineTypes.OBJECT_END;
    }
    if (line.content.startsWith(exports.Charts.multilinePhrase)) {
        return types_1.TFLineTypes.MULTILINE_STRING;
    }
    if (currentObjectType === types_1.TFLineTypes.ARRAY_START) {
        // Handling case of multi-line array object where the content is not yet finished.
        // Those lines will be skipped as part of
        // https://github.com/snyk/cloud-config-parser/blob/b5f5bdd8dd60cb3ad9c110bb6c640f08db0e108b/lib/issue-to-line/tf/parser.ts#L44
        return types_1.TFLineTypes.STRING;
    }
    throw new SyntaxError("Invalid TF input - Unknown line type - " + line.content);
}
exports.getLineType = getLineType;
function getNode(key, line, values) {
    var node = {
        key: key,
        lineLocation: {
            line: line.number + 1,
            columnStart: 0,
            columnEnd: line.content.length,
        },
        values: values ? values : [],
    };
    return node;
}
exports.getNode = getNode;
//# sourceMappingURL=utils.js.map