"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNonHexVersion = void 0;
const PATH_OPTION_PROPS = ['path', 'in_umbrella'];
const GIT_OPTION_PROPS = [
    'git',
    'github',
    'ref',
    'branch',
    'tag',
    'submodules',
    'sparse',
];
function getNonHexVersion(options) {
    if (hasPathOptionProps(options))
        return generatePathDepVersion(options);
    else if (hasGitOptionProps(options))
        return generateGitDepVersion(options);
}
exports.getNonHexVersion = getNonHexVersion;
function hasPathOptionProps(options) {
    return PATH_OPTION_PROPS.some((key) => options === null || options === void 0 ? void 0 : options[key]);
}
function generatePathDepVersion(options) {
    if (options.in_umbrella)
        return { title: 'in_umbrella', labels: {} };
    else if (options.path)
        return { title: 'path', labels: { path: options.path } };
}
function hasGitOptionProps(options) {
    return GIT_OPTION_PROPS.some((key) => options === null || options === void 0 ? void 0 : options[key]);
}
function generateGitDepVersion(options) {
    const gitAddress = options.github
        ? `https://github.com/${options.github}.git`
        : options.git;
    const ref = options.branch || options.tag || options.ref || 'HEAD';
    const title = `${gitAddress}@${ref}`;
    const labels = {};
    for (const prop of GIT_OPTION_PROPS) {
        if (!options[prop])
            continue;
        labels[prop] = options[prop];
    }
    return { title, labels };
}
//# sourceMappingURL=get-non-hex-version.js.map