"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.partitionByFixable = exports.isSupported = exports.projectTypeSupported = void 0;
function projectTypeSupported(res) {
    return !('reason' in res);
}
exports.projectTypeSupported = projectTypeSupported;
async function isSupported(entity) {
    const remediationData = entity.testResult.remediation;
    if (!remediationData) {
        return { supported: false, reason: 'No remediation data available' };
    }
    if (!remediationData.pin || Object.keys(remediationData.pin).length === 0) {
        return {
            supported: false,
            reason: 'There is no actionable remediation to apply',
        };
    }
    return { supported: true };
}
exports.isSupported = isSupported;
async function partitionByFixable(entities) {
    const fixable = [];
    const skipped = [];
    for (const entity of entities) {
        const isSupportedResponse = await isSupported(entity);
        if (projectTypeSupported(isSupportedResponse)) {
            fixable.push(entity);
            continue;
        }
        skipped.push({
            original: entity,
            userMessage: isSupportedResponse.reason,
        });
    }
    return { fixable, skipped };
}
exports.partitionByFixable = partitionByFixable;
//# sourceMappingURL=is-supported.js.map