"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractProvenance = void 0;
const path = require("path");
const debugLib = require("debug");
const requirements_file_parser_1 = require("./update-dependencies/requirements-file-parser");
const contains_require_directive_1 = require("./contains-require-directive");
const debug = debugLib('snyk-fix:python:extract-version-provenance');
async function extractProvenance(workspace, dir, fileName, provenance = {}) {
    const requirementsFileName = path.join(dir, fileName);
    const requirementsTxt = await workspace.readFile(requirementsFileName);
    provenance = Object.assign(Object.assign({}, provenance), { [fileName]: requirements_file_parser_1.parseRequirementsFile(requirementsTxt) });
    const { containsRequire, matches } = await contains_require_directive_1.containsRequireDirective(requirementsTxt);
    if (containsRequire) {
        for (const match of matches) {
            const requiredFilePath = match[2];
            if (provenance[requiredFilePath]) {
                debug('Detected recursive require directive, skipping');
                continue;
            }
            provenance = Object.assign(Object.assign({}, provenance), (await extractProvenance(workspace, dir, requiredFilePath, provenance)));
        }
    }
    return provenance;
}
exports.extractProvenance = extractProvenance;
//# sourceMappingURL=extract-version-provenance.js.map