declare type VersionComparator = '<' | '<=' | '!=' | '==' | '>=' | '>' | '~=';
export interface Requirement {
    originalText: string;
    line: number;
    name?: string;
    originalName?: string;
    versionComparator?: VersionComparator;
    version?: string;
    extras?: string;
}
/**
 * Converts a requirements file into an array of parsed requirements, with data
 * such as name, version, etc.
 * @param requirementsFile A requirements.txt file as a string
 */
export interface ParsedRequirements {
    requirements: Requirement[];
    endsWithNewLine: boolean;
}
export declare function parseRequirementsFile(requirementsFile: string): ParsedRequirements;
export {};
