import "core-js/modules/es.array.reduce.js";
import "core-js/modules/es.function.name.js";
import "core-js/modules/es.object.assign.js";
import { extractProps } from './extractProps';
export var extractArgTypes = function extractArgTypes(component) {
  if (component) {
    var _extractProps = extractProps(component),
        rows = _extractProps.rows;

    if (rows) {
      return rows.reduce(function (acc, row) {
        var name = row.name,
            type = row.type,
            sbType = row.sbType,
            defaultSummary = row.defaultValue,
            jsDocTags = row.jsDocTags,
            required = row.required;
        var defaultValue;

        if (component.defaultProps) {
          defaultValue = component.defaultProps[name];
        } else {
          var defaultValueString = defaultSummary && (defaultSummary.detail || defaultSummary.summary);

          try {
            if (defaultValueString) {
              // eslint-disable-next-line no-new-func
              defaultValue = Function("\"use strict\";return (".concat(defaultValueString, ")"))();
            } // eslint-disable-next-line no-empty

          } catch (_unused) {}
        }

        acc[row.name] = Object.assign({}, row, {
          defaultValue: defaultValue,
          type: Object.assign({
            required: required
          }, sbType),
          table: {
            type: type,
            jsDocTags: jsDocTags,
            defaultValue: defaultSummary
          }
        });
        return acc;
      }, {});
    }
  }

  return null;
};