"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setDefaultTestOptions = void 0;
const config = require("../../../lib/config");
function setDefaultTestOptions(options) {
    const svpSupplied = (options['show-vulnerable-paths'] || '')
        .toString()
        .toLowerCase();
    delete options['show-vulnerable-paths'];
    return Object.assign(Object.assign({}, options), { 
        // org fallback to config unless specified
        org: options.org || config.org, 
        // making `show-vulnerable-paths` 'some' by default.
        showVulnPaths: showVulnPathsMapping[svpSupplied] || 'some' });
}
exports.setDefaultTestOptions = setDefaultTestOptions;
const showVulnPathsMapping = {
    false: 'none',
    none: 'none',
    true: 'some',
    some: 'some',
    all: 'all',
};
//# sourceMappingURL=set-default-test-options.js.map