"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotSupportedIacAllProjects = exports.IllegalTerraformFileError = exports.InvalidK8SFileError = exports.IllegalIacCustomError = exports.NotSupportedIacFileError = exports.IllegalIacFileErrorMsg = exports.NotSupportedIacFileErrorMsg = void 0;
const chalk_1 = require("chalk");
const custom_error_1 = require("./custom-error");
function NotSupportedIacFileErrorMsg(fileName) {
    return ('Not supported infrastructure as code target files in ' +
        fileName +
        '.\nPlease see our documentation for supported target files: ' +
        chalk_1.default.underline('https://support.snyk.io/hc/en-us/articles/360006368877-Scan-and-fix-security-issues-in-your-Kubernetes-configuration-files') +
        ' and make sure you are in the right directory.');
}
exports.NotSupportedIacFileErrorMsg = NotSupportedIacFileErrorMsg;
function IllegalIacFileErrorMsg(fileName) {
    return ('Illegal infrastructure as code target file ' +
        fileName +
        '.\nPlease see our documentation for supported target files: ' +
        chalk_1.default.underline('https://support.snyk.io/hc/en-us/articles/360006368877-Scan-and-fix-security-issues-in-your-Kubernetes-configuration-files') +
        ' and make sure you are in the right directory.');
}
exports.IllegalIacFileErrorMsg = IllegalIacFileErrorMsg;
function NotSupportedIacFileError(fileName) {
    const errorMsg = NotSupportedIacFileErrorMsg(fileName);
    const error = new custom_error_1.CustomError(errorMsg);
    error.code = 422;
    error.userMessage = errorMsg;
    return error;
}
exports.NotSupportedIacFileError = NotSupportedIacFileError;
function IllegalIacCustomError(fileName) {
    const errorMsg = IllegalIacFileErrorMsg(fileName);
    const error = new custom_error_1.CustomError(errorMsg);
    error.code = 422;
    error.userMessage = errorMsg;
    return error;
}
exports.IllegalIacCustomError = IllegalIacCustomError;
function InvalidK8SFileError(errorMsg) {
    const error = new custom_error_1.CustomError(errorMsg);
    error.code = 422;
    error.userMessage = errorMsg;
    return error;
}
exports.InvalidK8SFileError = InvalidK8SFileError;
function IllegalTerraformFileError(atLocations, reason) {
    const locationsStr = atLocations.join(', ');
    const errorMsg = `Illegal Terraform target file ${locationsStr} \nValidation Error Reason: ${reason}` +
        '.\nPlease see our documentation for supported target files: ' +
        chalk_1.default.underline('https://support.snyk.io/hc/en-us/articles/360013723877-Test-your-Terraform-files-with-our-CLI-tool') +
        ' and make sure you are in the right directory.';
    const error = new custom_error_1.CustomError(errorMsg);
    error.code = 422;
    error.userMessage = errorMsg;
    return error;
}
exports.IllegalTerraformFileError = IllegalTerraformFileError;
function NotSupportedIacAllProjects(path) {
    const errorMsg = `Infrastructure as Code test does not support the "--all-projects" flag.\n` +
        `Directories with multiple IaC files can be tested using "snyk iac test ${path}" command.`;
    const error = new custom_error_1.CustomError(errorMsg);
    error.code = 422;
    error.userMessage = errorMsg;
    return error;
}
exports.NotSupportedIacAllProjects = NotSupportedIacAllProjects;
//# sourceMappingURL=invalid-iac-file.js.map