"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analysisProgressUpdate = void 0;
const code_client_1 = require("@snyk/code-client");
const spinner = require("../../../spinner");
function analysisProgressUpdate(currentLabel) {
    code_client_1.emitter.on('scanFilesProgress', async (processed) => {
        const spinnerLbl = `Prepare ${processed} files to upload`;
        spinner.clear(currentLabel)();
        currentLabel = spinnerLbl;
        await spinner(spinnerLbl);
    });
    code_client_1.emitter.on('uploadBundleProgress', async (processed, total) => {
        const spinnerLbl = `Upload progress: ${processed}/${total}`;
        spinner.clear(currentLabel)();
        currentLabel = spinnerLbl;
        await spinner(spinnerLbl);
    });
    code_client_1.emitter.on('analyseProgress', async (data) => {
        const spinnerLbl = `Analysis: ${Math.round(data.progress * 100)}%`;
        spinner.clear(currentLabel)();
        currentLabel = spinnerLbl;
        await spinner(spinnerLbl);
    });
    code_client_1.emitter.on('sendError', (error) => {
        throw error;
    });
    return currentLabel;
}
exports.analysisProgressUpdate = analysisProgressUpdate;
//# sourceMappingURL=testEmitter.js.map