"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateCodeTest = void 0;
const config = require("../../config");
const errors_1 = require("../../errors");
async function validateCodeTest(options) {
    const org = options.org || config.org;
    // This is an unexpected path, code plugin executed for non-code command.
    if (!options.code) {
        throw new errors_1.FeatureNotSupportedForOrgError(org);
    }
    // TODO: We would need to remove this once we fix circular import issue
    const { getSastSettingsForOrg } = require('./settings');
    const sastSettingsResponse = await getSastSettingsForOrg(org);
    if (sastSettingsResponse.code === 401 || sastSettingsResponse.code === 403) {
        throw errors_1.AuthFailedError(sastSettingsResponse.error, sastSettingsResponse.code);
    }
    if (!sastSettingsResponse.sastEnabled) {
        throw new errors_1.FeatureNotSupportedForOrgError(org, 'Snyk Code');
    }
}
exports.validateCodeTest = validateCodeTest;
//# sourceMappingURL=validate.js.map