"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableTextCell = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _TextInput = require("@patternfly/react-core/dist/js/components/TextInput");

var _inlineEdit = _interopRequireDefault(require("@patternfly/react-styles/css/components/InlineEdit/inline-edit"));

var _form = _interopRequireDefault(require("@patternfly/react-styles/css/components/Form/form"));

var _classnames = _interopRequireDefault(require("classnames"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var EditableTextCell = function EditableTextCell(_ref) {
  var value = _ref.value,
      rowIndex = _ref.rowIndex,
      cellIndex = _ref.cellIndex,
      props = _ref.props,
      handleTextInputChange = _ref.handleTextInputChange,
      inputAriaLabel = _ref.inputAriaLabel,
      isDisabled = _ref.isDisabled;
  return React.createElement(React.Fragment, null, React.createElement("div", {
    className: _inlineEdit["default"].inlineEditValue
  }, value), React.createElement("div", {
    className: _inlineEdit["default"].inlineEditInput
  }, React.createElement(_TextInput.TextInput, {
    isDisabled: isDisabled,
    value: props.editableValue !== undefined ? props.editableValue : value,
    isValid: props.isValid,
    type: "text",
    onChange: function onChange(newValue, event) {
      handleTextInputChange(newValue, event, rowIndex, cellIndex);
    },
    "aria-label": inputAriaLabel
  }), React.createElement("div", {
    className: (0, _classnames["default"])(_form["default"].formHelperText, _form["default"].modifiers.error),
    "aria-live": "polite"
  }, props.errorText)));
};

exports.EditableTextCell = EditableTextCell;
EditableTextCell.propTypes = {
  value: _propTypes["default"].string.isRequired,
  rowIndex: _propTypes["default"].number.isRequired,
  cellIndex: _propTypes["default"].number.isRequired,
  props: _propTypes["default"].any.isRequired,
  handleTextInputChange: _propTypes["default"].func.isRequired,
  inputAriaLabel: _propTypes["default"].string.isRequired,
  isDisabled: _propTypes["default"].bool
};
//# sourceMappingURL=EditableTextCell.js.map