"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyCellEdits = exports.validateCellEdits = exports.cancelCellEdits = exports.getErrorTextByValidator = exports.isRowExpanded = void 0;

var hasCompoundParentsExpanded = function hasCompoundParentsExpanded(parentId, compoundParent, rows) {
  // max rows.length parents
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = rows[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var i = _step.value;

      if (rows[parentId].hasOwnProperty('parent')) {
        parentId = rows[parentId].parent;
      } else {
        return rows[parentId].cells[compoundParent].props.isOpen;
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator["return"] != null) {
        _iterator["return"]();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return false;
};

var hasParentsExpanded = function hasParentsExpanded(parentId, rows) {
  // max rows.length parents
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = rows[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var i = _step2.value;

      if (rows[parentId].hasOwnProperty('parent')) {
        parentId = rows[parentId].parent;
      } else {
        return rows[parentId].isOpen;
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
        _iterator2["return"]();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  return false;
};

var isRowExpanded = function isRowExpanded(row, rows) {
  if (row.parent !== undefined) {
    if (row.hasOwnProperty('compoundParent')) {
      return hasCompoundParentsExpanded(row.parent, row.compoundParent, rows);
    }

    return hasParentsExpanded(row.parent, rows) && rows[row.parent].isOpen;
  }

  return undefined;
};

exports.isRowExpanded = isRowExpanded;

var getErrorTextByValidator = function getErrorTextByValidator(validatorName, validators) {
  var result = validators.filter(function (validator) {
    return validator.name === validatorName;
  });
  return result[0].errorText;
};

exports.getErrorTextByValidator = getErrorTextByValidator;

var cancelCellEdits = function cancelCellEdits(row) {
  row.cells.forEach(function (cell) {
    delete cell.props.errorText;
    delete cell.props.editableValue;
    cell.props.isValid = true;
  });
  row.isEditable = !row.isEditable;
  row.isValid = true;
  return row;
};

exports.cancelCellEdits = cancelCellEdits;

var validateCellEdits = function validateCellEdits(row, type, validationErrors) {
  var missingPropErrorTxt = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'Validation requires unique name property for row cells';
  row.isValid = Object.keys(validationErrors).length ? false : true;
  row.cells.forEach(function (cell) {
    delete cell.props.errorText;
    var hasValue = cell.props.value !== undefined && cell.props.value !== null;
    var hasEditableValue = cell.props.editableValue !== undefined && cell.props.editableValue !== null;

    if (cell.props && hasValue && hasEditableValue) {
      if (type === 'save') {
        var errorMsg = Object.keys(validationErrors).filter(function (validatorName) {
          return validationErrors[validatorName].includes(cell.props.name);
        }).map(function (validatorName) {
          return getErrorTextByValidator(validatorName, row.rowEditValidationRules);
        });

        if (errorMsg.length) {
          cell.props.errorText = cell.props.name ? errorMsg.join(', ') : missingPropErrorTxt;

          if (cell.props.name === undefined) {
            // eslint-disable-next-line no-console
            console.warn('Row edit validation reporting requires cell definitions to have a unique name property.');
          }
        } else {
          delete cell.props.errorText;
          cell.props.isValid = true;
        }
      }
    }
  });
  return row;
};

exports.validateCellEdits = validateCellEdits;

var applyCellEdits = function applyCellEdits(row, type) {
  row.cells.forEach(function (cell) {
    delete cell.props.errorText;
    var hasValue = cell.props.value !== undefined && cell.props.value !== null;
    var hasEditableValue = cell.props.editableValue !== undefined && cell.props.editableValue !== null;

    if (cell.props && hasValue && hasEditableValue) {
      if (type === 'save') {
        cell.props.value = cell.props.editableValue;
        cell.props.isValid = true;
        delete cell.props.errorText;
      }

      delete cell.props.editableValue;
    }
  });
  row.isEditable = !row.isEditable;
  row.isValid = true;
  return row;
};

exports.applyCellEdits = applyCellEdits;
//# sourceMappingURL=utils.js.map