(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "hoist-non-react-statics", "lodash", "victory", "../ChartLine", "../ChartUtils"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("hoist-non-react-statics"), require("lodash"), require("victory"), require("../ChartLine"), require("../ChartUtils"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.hoistNonReactStatics, global.lodash, global.victory, global.ChartLine, global.ChartUtils);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _hoistNonReactStatics, _lodash, _victory, _ChartLine, _ChartUtils) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.ChartThreshold = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  /**
   * See https://github.com/DefinitelyTyped/DefinitelyTyped/blob/master/types/victory/index.d.ts
   */
  const ChartThreshold = exports.ChartThreshold = _ref => {
    let {
      style = {},
      themeColor,
      themeVariant,
      // destructure last
      theme = (0, _ChartUtils.getThresholdTheme)(themeColor, themeVariant)
    } = _ref,
        rest = _objectWithoutProperties(_ref, ["style", "themeColor", "themeVariant", "theme"]); // Returned style prop takes precedence over default theme


    const getStrokeDasharray = () => {
      if (style && style.data && style.data.strokeDasharray) {
        return style.data.strokeDasharray;
      }

      return (0, _ChartUtils.getThresholdTheme)(themeColor, themeVariant).line.style.data.strokeDasharray;
    };

    const getStrokeWidth = () => {
      if (style && style.data && style.data.strokeWidth) {
        return style.data.strokeWidth;
      }

      return (0, _ChartUtils.getThresholdTheme)(themeColor, themeVariant).line.style.data.strokeWidth;
    }; // Clone style and apply strokeDasharray prop


    const thresholdStyle = (0, _lodash.cloneDeep)(style);

    if (thresholdStyle.data) {
      thresholdStyle.data.strokeDasharray = getStrokeDasharray();
      thresholdStyle.data.strokeWidth = getStrokeWidth();
    } else {
      thresholdStyle.data = {
        strokeDasharray: getStrokeDasharray(),
        strokeWidth: getStrokeWidth()
      };
    }

    return React.createElement(_ChartLine.ChartLine, _extends({
      style: thresholdStyle,
      theme: theme
    }, rest));
  }; // Note: VictoryLine.role must be hoisted


  ChartThreshold.propTypes = {
    animate: _propTypes2.default.any,
    categories: _propTypes2.default.any,
    containerComponent: _propTypes2.default.element,
    data: _propTypes2.default.arrayOf(_propTypes2.default.any),
    dataComponent: _propTypes2.default.element,
    domain: _propTypes2.default.any,
    domainPadding: _propTypes2.default.any,
    eventKey: _propTypes2.default.any,
    events: _propTypes2.default.arrayOf(_propTypes2.default.any),
    externalEventMutations: _propTypes2.default.arrayOf(_propTypes2.default.any),
    groupComponent: _propTypes2.default.element,
    height: _propTypes2.default.number,
    horizontal: _propTypes2.default.bool,
    interpolation: _propTypes2.default.any,
    labelComponent: _propTypes2.default.element,
    labels: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.arrayOf(_propTypes2.default.string), _propTypes2.default.arrayOf(_propTypes2.default.number)]),
    maxDomain: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.shape({
      x: _propTypes2.default.number,
      y: _propTypes2.default.number
    })]),
    minDomain: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.shape({
      x: _propTypes2.default.number,
      y: _propTypes2.default.number
    })]),
    name: _propTypes2.default.string,
    origin: _propTypes2.default.shape({
      x: _propTypes2.default.number.isRequired,
      y: _propTypes2.default.number.isRequired
    }),
    padding: _propTypes2.default.any,
    polar: _propTypes2.default.bool,
    range: _propTypes2.default.oneOfType([_propTypes2.default.shape({})]),
    samples: _propTypes2.default.number,
    scale: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.any, _propTypes2.default.shape({
      x: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.any]),
      y: _propTypes2.default.oneOfType([_propTypes2.default.any, _propTypes2.default.any])
    })])
  };
  (0, _hoistNonReactStatics2.default)(ChartThreshold, _victory.VictoryLine);
});
//# sourceMappingURL=ChartThreshold.js.map