"use strict";
exports.__esModule = true;
/**
 * @module Layers essentially allow you to create a new surface for layouts
 */
var typestyle_1 = require("typestyle");
/**
 * New layer parent
 */
exports.layerParent = {
    position: 'relative'
};
/**
 * Use this to attach to any parent layer
 * and then you can use `left`/`top` etc to position yourself
 */
exports.attachToLayerParent = {
    position: 'absolute'
};
/**
 * This new layer will attach itself to the nearest parent with `position:relative` or `position:absolute`
 * And will become the new `layerParent`
 */
exports.newLayer = typestyle_1.extend(exports.attachToLayerParent, {
    left: 0,
    right: 0,
    top: 0,
    bottom: 0
});
exports.attachToTop = typestyle_1.extend(exports.attachToLayerParent, {
    top: 0,
    left: 0,
    right: 0
});
exports.attachToRight = typestyle_1.extend(exports.attachToLayerParent, {
    top: 0,
    right: 0,
    bottom: 0
});
exports.attachToBottom = typestyle_1.extend(exports.attachToLayerParent, {
    right: 0,
    bottom: 0,
    left: 0
});
exports.attachToLeft = typestyle_1.extend(exports.attachToLayerParent, {
    top: 0,
    bottom: 0,
    left: 0
});
/**
 * Helps fixing to page
 */
var fixed = {
    position: 'fixed'
};
exports.pageTop = typestyle_1.extend(fixed, {
    top: 0,
    left: 0,
    right: 0
});
exports.pageRight = typestyle_1.extend(fixed, {
    top: 0,
    right: 0,
    bottom: 0
});
exports.pageBottom = typestyle_1.extend(fixed, {
    right: 0,
    bottom: 0,
    left: 0
});
exports.pageLeft = typestyle_1.extend(fixed, {
    top: 0,
    bottom: 0,
    left: 0
});
