"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LockFileNotValid = exports.packageSpecsFrom = void 0;
const toml = require("toml");
function packageSpecsFrom(lockFileContents) {
    const lockFile = toml.parse(lockFileContents);
    if (!lockFile.package) {
        throw new LockFileNotValid();
    }
    return lockFile.package.map((pkg) => {
        return {
            name: pkg.name,
            version: pkg.version,
            dependencies: Object.keys(pkg.dependencies || []),
        };
    });
}
exports.packageSpecsFrom = packageSpecsFrom;
class LockFileNotValid extends Error {
    constructor() {
        super("The poetry.lock file contains no package stanza'");
        this.name = 'LockFileNotValid';
    }
}
exports.LockFileNotValid = LockFileNotValid;
//# sourceMappingURL=lock-file-parser.js.map