import { List } from '../types';
export declare const formatUnit: <T>(unit: string) => (val: number) => T;
export declare const toFloat: typeof parseFloat;
export declare function ensurePercent(value: string | number): number;
export declare function formatPercent(value: number): string;
/**
 * Returns a number formatted to a max number of 5 decimal places
 */
export declare function formatFloat(n: number): string;
export declare function ensureLength(value: number | string | undefined): string | undefined;
export declare function parseCSSFunction(stringValue: string): string[] | undefined;
export declare function cssFunction(functionName: string, params: List<string | number>): string;
export declare function createFunction<T>(name: string): T;
