"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutOfSyncError = void 0;
class OutOfSyncError extends Error {
    constructor(dependencyName) {
        super(`Dependency ${dependencyName} was not found in ` +
            `mix.lock. Your mix.exs and ` +
            `mix.lock are probably out of sync. Please run ` +
            `"mix deps.get" and try again.`);
        this.name = 'OutOfSyncError';
        this.dependencyName = dependencyName;
        Error.captureStackTrace(this, OutOfSyncError);
    }
}
exports.OutOfSyncError = OutOfSyncError;
//# sourceMappingURL=out-of-sync-error.js.map