"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getData = exports.getDomain = exports.getBaseProps = void 0;

var _isNil2 = _interopRequireDefault(require("lodash/isNil"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getErrors = function (props, datum, axis) {
  /**
   * check if it is asymmetric error or symmetric error, asymmetric error should be an array
   * and the first value is the positive error, the second is the negative error
   * @param  {Boolean} isArray(errorX)
   * @return {String or Array}
   */
  var errorNames = {
    x: "_errorX",
    y: "_errorY"
  };
  var errors = datum[errorNames[axis]];

  if (errors === 0) {
    return false;
  }

  var scale = props.scale[axis];
  return Array.isArray(errors) ? [errors[0] === 0 ? false : scale(errors[0] + datum["_".concat(axis)]), errors[1] === 0 ? false : scale(datum["_".concat(axis)] - errors[1])] : [scale(errors + datum["_".concat(axis)]), scale(datum["_".concat(axis)] - errors)];
};

var getData = function (props) {
  var accessorTypes = ["x", "y", "errorX", "errorY"];

  if (props.data) {
    return _victoryCore.Data.formatData(props.data, props, accessorTypes);
  } else {
    var generatedData = props.errorX || props.errorY ? _victoryCore.Data.generateData(props) : [];
    return _victoryCore.Data.formatData(generatedData, props, accessorTypes);
  }
};

exports.getData = getData;

var getDomainFromData = function (props, axis) {
  var minDomain = _victoryCore.Domain.getMinFromProps(props, axis);

  var maxDomain = _victoryCore.Domain.getMaxFromProps(props, axis);

  var dataset = getData(props);

  if (dataset.length < 1) {
    return minDomain !== undefined && maxDomain !== undefined ? _victoryCore.Domain.getDomainFromMinMax(minDomain, maxDomain) : undefined;
  }

  var error = axis === "x" ? "_errorX" : "_errorY";

  var reduceErrorData = function (type) {
    var baseCondition = type === "min" ? Infinity : -Infinity;
    var errorIndex = type === "min" ? 1 : 0;
    var sign = type === "min" ? -1 : 1;
    return dataset.reduce(function (memo, datum) {
      var currentError = Array.isArray(datum[error]) ? datum[error][errorIndex] : datum[error];
      var current = datum["_".concat(axis)] + sign * (currentError || 0);
      return memo < current && type === "min" || memo > current && type === "max" ? memo : current;
    }, baseCondition);
  };

  var min = minDomain !== undefined ? minDomain : reduceErrorData("min");
  var max = maxDomain !== undefined ? maxDomain : reduceErrorData("max");
  return _victoryCore.Domain.getDomainFromMinMax(min, max);
};

var getDomain = function (props, axis) {
  return _victoryCore.Domain.createDomainFunction(getDomainFromData)(props, axis);
};

exports.getDomain = getDomain;

var getCalculatedValues = function (props) {
  var defaultStyles = props.theme && props.theme.errorbar && props.theme.errorbar.style ? props.theme.errorbar.style : {};
  var style = _victoryCore.Helpers.getStyles(props.style, defaultStyles) || {};
  var data = getData(props);
  var range = {
    x: _victoryCore.Helpers.getRange(props, "x"),
    y: _victoryCore.Helpers.getRange(props, "y")
  };
  var domain = {
    x: getDomain(props, "x"),
    y: getDomain(props, "y")
  };
  var scale = {
    x: _victoryCore.Scale.getBaseScale(props, "x").domain(domain.x).range(props.horizontal ? range.y : range.x),
    y: _victoryCore.Scale.getBaseScale(props, "y").domain(domain.y).range(props.horizontal ? range.x : range.y)
  };
  var origin = props.polar ? props.origin || _victoryCore.Helpers.getPolarOrigin(props) : undefined;
  return {
    domain: domain,
    data: data,
    scale: scale,
    style: style,
    origin: origin
  };
};

var getLabelProps = function (dataProps, text, style) {
  var x = dataProps.x,
      y = dataProps.y,
      index = dataProps.index,
      scale = dataProps.scale,
      errorY = dataProps.errorY,
      errorX = dataProps.errorX,
      horizontal = dataProps.horizontal;

  var getError = function () {
    var type = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : "x";
    var baseError = type === "y" ? errorY : errorX;
    var error = baseError && Array.isArray(baseError) ? baseError[0] : baseError;
    return error || dataProps[type];
  };

  var labelStyle = style.labels || {};
  var padding = labelStyle.padding || 0;
  var textAnchor = horizontal ? "start" : "middle";
  var verticalAnchor = horizontal ? "middle" : "end";
  return {
    style: labelStyle,
    y: horizontal ? y : getError("y"),
    x: horizontal ? getError("x") : x,
    dy: horizontal ? 0 : -padding,
    dx: horizontal ? padding : 0,
    text: text,
    index: index,
    scale: scale,
    datum: dataProps.datum,
    data: dataProps.data,
    textAnchor: labelStyle.textAnchor || textAnchor,
    verticalAnchor: labelStyle.verticalAnchor || verticalAnchor,
    angle: labelStyle.angle,
    horizontal: horizontal
  };
};

var getBaseProps = function (props, fallbackProps) {
  var modifiedProps = _victoryCore.Helpers.modifyProps(props, fallbackProps, "errorbar");

  props = (0, _assign2.default)({}, modifiedProps, getCalculatedValues(modifiedProps));
  var _props = props,
      borderWidth = _props.borderWidth,
      data = _props.data,
      domain = _props.domain,
      events = _props.events,
      groupComponent = _props.groupComponent,
      height = _props.height,
      horizontal = _props.horizontal,
      labels = _props.labels,
      name = _props.name,
      origin = _props.origin,
      padding = _props.padding,
      polar = _props.polar,
      scale = _props.scale,
      sharedEvents = _props.sharedEvents,
      standalone = _props.standalone,
      style = _props.style,
      theme = _props.theme,
      width = _props.width;
  var initialChildProps = {
    parent: {
      data: data,
      domain: domain,
      height: height,
      horizontal: horizontal,
      name: name,
      origin: origin,
      padding: padding,
      polar: polar,
      scale: scale,
      standalone: standalone,
      style: style.parent,
      theme: theme,
      width: width
    }
  };
  return data.reduce(function (childProps, datum, index) {
    var eventKey = !(0, _isNil2.default)(datum.eventKey) ? datum.eventKey : index;

    var _Helpers$scalePoint = _victoryCore.Helpers.scalePoint((0, _assign2.default)({}, props, {
      scale: scale
    }), datum),
        x = _Helpers$scalePoint.x,
        y = _Helpers$scalePoint.y;

    var errorX = getErrors(props, datum, "x");
    var errorY = getErrors(props, datum, "y");
    var dataProps = {
      borderWidth: borderWidth,
      data: data,
      datum: datum,
      errorX: horizontal ? errorY : errorX,
      errorY: horizontal ? errorX : errorY,
      groupComponent: groupComponent,
      horizontal: horizontal,
      index: index,
      scale: scale,
      style: style.data,
      x: x,
      y: y
    };
    childProps[eventKey] = {
      data: dataProps
    };

    var text = _victoryCore.LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      childProps[eventKey].labels = getLabelProps(dataProps, text, style);
    }

    return childProps;
  }, initialChildProps);
};

exports.getBaseProps = getBaseProps;