(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-icons/dist/js/icons/angle-right-icon", "@patternfly/react-styles", "@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer", "../Badge"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-icons/dist/js/icons/angle-right-icon"), require("@patternfly/react-styles"), require("@patternfly/react-styles/css/components/NotificationDrawer/notification-drawer"), require("../Badge"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.angleRightIcon, global.reactStyles, global.notificationDrawer, global.Badge);
    global.undefined = mod.exports;
  }
})(this, function (exports, _propTypes, _react, _angleRightIcon, _reactStyles, _notificationDrawer, _Badge) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.NotificationDrawerGroup = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _angleRightIcon2 = _interopRequireDefault(_angleRightIcon);

  var _notificationDrawer2 = _interopRequireDefault(_notificationDrawer);

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;
    var cache = new WeakMap();

    _getRequireWildcardCache = function () {
      return cache;
    };

    return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }

    var cache = _getRequireWildcardCache();

    if (cache && cache.has(obj)) {
      return cache.get(obj);
    }

    var newObj = {};

    if (obj != null) {
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;

      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;

          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
    }

    newObj.default = obj;

    if (cache) {
      cache.set(obj, newObj);
    }

    return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  const NotificationDrawerGroup = exports.NotificationDrawerGroup = _ref => {
    let {
      children,
      className = '',
      count,
      isExpanded,
      isRead = false,
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      onExpand = (event, expanded) => undefined,
      title
    } = _ref,
        props = _objectWithoutProperties(_ref, ["children", "className", "count", "isExpanded", "isRead", "onExpand", "title"]);

    return React.createElement("section", _extends({}, props, {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerGroup, isExpanded && _notificationDrawer2.default.modifiers.expanded, className)
    }), React.createElement("h1", null, React.createElement("button", {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerGroupToggle),
      "aria-expanded": isExpanded,
      onClick: e => onExpand(e, !isExpanded)
    }, React.createElement("div", null, title), React.createElement("div", {
      className: (0, _reactStyles.css)(_notificationDrawer2.default.notificationDrawerGroupToggleCount)
    }, React.createElement(_Badge.Badge, {
      isRead: isRead
    }, count)), React.createElement("span", {
      className: "pf-c-notification-drawer__group-toggle-icon"
    }, React.createElement(_angleRightIcon2.default, null)))), children);
  };

  NotificationDrawerGroup.propTypes = {
    children: _propTypes2.default.node,
    className: _propTypes2.default.string,
    count: _propTypes2.default.number.isRequired,
    isExpanded: _propTypes2.default.bool.isRequired,
    isRead: _propTypes2.default.bool,
    onExpand: _propTypes2.default.func,
    title: _propTypes2.default.string.isRequired
  };
});
//# sourceMappingURL=NotificationDrawerGroup.js.map