import 'source-map-support/register';
import { PkgTree, DepType, PropsLookup } from './parsers';
export { buildDepTreeFromPackagesConfig, buildDepTreeFromProjectFile, buildDepTreeFromProjectJson, buildDepTreeFromProjectAssetsJson, buildDepTreeFromFiles, extractTargetFrameworksFromFiles, extractTargetFrameworksFromProjectFile, extractTargetFrameworksFromProjectConfig, containsPackageReference, extractTargetFrameworksFromProjectJson, extractTargetFrameworksFromProjectAssetsJson, extractProps, PkgTree, DepType, };
declare function buildDepTreeFromProjectJson(manifestFileContents: string, includeDev?: boolean): PkgTree;
declare function buildDepTreeFromProjectAssetsJson(manifestFileContents: string, targetFramework?: string): PkgTree;
declare function buildDepTreeFromPackagesConfig(manifestFileContents: string, includeDev?: boolean): Promise<PkgTree>;
declare function buildDepTreeFromProjectFile(manifestFileContents: string, includeDev?: boolean, propsMap?: PropsLookup): Promise<PkgTree>;
declare function buildDepTreeFromFiles(root: string, manifestFilePath: string, includeDev?: boolean, targetFramework?: string): PkgTree | Promise<PkgTree>;
declare function extractTargetFrameworksFromFiles(root: string, manifestFilePath: string, includeDev?: boolean): Promise<string[]>;
declare function extractTargetFrameworksFromProjectFile(manifestFileContents: string): Promise<string[]>;
declare function extractTargetFrameworksFromProjectConfig(manifestFileContents: string): Promise<string[]>;
declare function containsPackageReference(manifestFileContents: string): Promise<boolean>;
declare function extractTargetFrameworksFromProjectJson(manifestFileContents: string): Promise<string[]>;
declare function extractTargetFrameworksFromProjectAssetsJson(manifestFileContents: string): Promise<string[]>;
declare function extractProps(propsFileContents: string): Promise<PropsLookup>;
