"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.issuePathToLineNumber = void 0;
var types = require("../types");
var utils_1 = require("./utils");
function issuePathToLineNumber(fileContent, fileType, path) {
    if (!Object.values(types.CloudConfigFileTypes).includes(fileType)) {
        throw new Error('Unknown format');
    }
    var trees = utils_1.buildTreeForTypeMap[fileType](fileContent);
    if (Object.keys(trees).length === 0) {
        throw new Error('failed to create trees');
    }
    var pathDetails = utils_1.getPathDetails(path.slice(), fileType);
    var treeNodes = trees[pathDetails.docId].nodes;
    return utils_1.findLineNumberOfGivenPath(treeNodes, pathDetails);
}
exports.issuePathToLineNumber = issuePathToLineNumber;
//# sourceMappingURL=index.js.map