"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getImageIdFromManifest = exports.getManifestLayers = exports.extractArchive = void 0;
var layer_1 = require("./layer");
Object.defineProperty(exports, "extractArchive", { enumerable: true, get: function () { return layer_1.extractArchive; } });
function getManifestLayers(manifest) {
    return manifest.layers.map((layer) => layer.digest);
}
exports.getManifestLayers = getManifestLayers;
function getImageIdFromManifest(manifest) {
    try {
        return manifest.config.digest;
    }
    catch (err) {
        throw new Error("Failed to extract image ID from archive manifest");
    }
}
exports.getImageIdFromManifest = getImageIdFromManifest;
//# sourceMappingURL=index.js.map