"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElfFileContent = exports.getFileContent = void 0;
function getFileContent(extractedLayers, searchedAction) {
    const foundAppFiles = {};
    for (const filePath of Object.keys(extractedLayers)) {
        for (const actionName of Object.keys(extractedLayers[filePath])) {
            if (actionName !== searchedAction) {
                continue;
            }
            if (!(typeof extractedLayers[filePath][actionName] === "string")) {
                throw new Error("expected string");
            }
            foundAppFiles[filePath] = extractedLayers[filePath][actionName];
        }
    }
    return foundAppFiles;
}
exports.getFileContent = getFileContent;
function isElfType(type) {
    const elf = type;
    return !!(elf.body && elf.body.programs && elf.body.sections);
}
function getElfFileContent(extractedLayers, searchedAction) {
    const foundAppFiles = {};
    for (const filePath of Object.keys(extractedLayers)) {
        for (const actionName of Object.keys(extractedLayers[filePath])) {
            if (actionName !== searchedAction) {
                continue;
            }
            if (!isElfType(extractedLayers[filePath][actionName])) {
                throw new Error("elf file expected to contain programs and sections");
            }
            foundAppFiles[filePath] = extractedLayers[filePath][actionName];
        }
    }
    return foundAppFiles;
}
exports.getElfFileContent = getElfFileContent;
//# sourceMappingURL=index.js.map