"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIssueCountBySeverity = void 0;
function getIssueCountBySeverity(issueData) {
    const total = {
        low: [],
        medium: [],
        high: [],
        critical: [],
    };
    for (const entry of issueData) {
        for (const issue of Object.values(entry)) {
            const { severity, id } = issue;
            total[severity.toLowerCase()].push(id);
        }
    }
    return total;
}
exports.getIssueCountBySeverity = getIssueCountBySeverity;
//# sourceMappingURL=issues-by-severity.js.map