"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPipfileManifest = exports.isRequirementsTxtManifest = exports.getHandlerType = void 0;
const pathLib = require("path");
const supported_handler_types_1 = require("./supported-handler-types");
function getHandlerType(entity) {
    const targetFile = entity.scanResult.identity.targetFile;
    if (!targetFile) {
        return null;
    }
    const path = pathLib.parse(targetFile);
    if (isRequirementsTxtManifest(targetFile)) {
        return supported_handler_types_1.SUPPORTED_HANDLER_TYPES.REQUIREMENTS;
    }
    else if (['Pipfile'].includes(path.base)) {
        return supported_handler_types_1.SUPPORTED_HANDLER_TYPES.PIPFILE;
    }
    return null;
}
exports.getHandlerType = getHandlerType;
function isRequirementsTxtManifest(targetFile) {
    return targetFile.endsWith('.txt');
}
exports.isRequirementsTxtManifest = isRequirementsTxtManifest;
function isPipfileManifest(targetFile) {
    return targetFile.endsWith('Pipfile') || targetFile.endsWith('Pipfile.lock');
}
exports.isPipfileManifest = isPipfileManifest;
//# sourceMappingURL=get-handler-type.js.map