"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FailedToParseTerraformFileError = exports.tryParsingTerraformFile = void 0;
const hcl_to_json_1 = require("./hcl-to-json");
const types_1 = require("../types");
const errors_1 = require("../../../../../lib/errors");
const error_utils_1 = require("../error-utils");
const constants_1 = require("../../../../../lib/iac/constants");
function tryParsingTerraformFile(fileData) {
    try {
        return [
            Object.assign(Object.assign({}, fileData), { jsonContent: hcl_to_json_1.default(fileData.fileContent), projectType: constants_1.IacProjectType.TERRAFORM, engineType: types_1.EngineType.Terraform }),
        ];
    }
    catch (err) {
        throw new FailedToParseTerraformFileError(fileData.filePath);
    }
}
exports.tryParsingTerraformFile = tryParsingTerraformFile;
class FailedToParseTerraformFileError extends errors_1.CustomError {
    constructor(filename) {
        super('Failed to parse Terraform file');
        this.code = types_1.IaCErrorCodes.FailedToParseTerraformFileError;
        this.strCode = error_utils_1.getErrorStringCode(this.code);
        this.userMessage = `We were unable to parse the Terraform file "${filename}", please ensure it is valid HCL2. This can be done by running it through the 'terraform validate' command.`;
    }
}
exports.FailedToParseTerraformFileError = FailedToParseTerraformFileError;
//# sourceMappingURL=terraform-file-parser.js.map