"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.assembleEcosystemPayloads = void 0;
const path = require("path");
const config = require("../config");
const is_ci_1 = require("../is-ci");
const ecosystems_1 = require("../ecosystems");
const common_1 = require("./common");
const spinner = require("../spinner");
const policy_1 = require("../ecosystems/policy");
const api_token_1 = require("../../lib/api-token");
async function assembleEcosystemPayloads(ecosystem, options) {
    // For --all-projects packageManager is yet undefined here. Use 'all'
    let analysisTypeText = 'all dependencies for ';
    if (options.docker) {
        analysisTypeText = 'container dependencies for ';
    }
    else if (options.iac) {
        analysisTypeText = 'Infrastructure as code configurations for ';
    }
    else if (options.packageManager) {
        analysisTypeText = options.packageManager + ' dependencies for ';
    }
    const spinnerLbl = 'Analyzing ' +
        analysisTypeText +
        (path.relative('.', path.join(options.path, options.file || '')) ||
            path.relative('..', '.') + ' project dir');
    spinner.clear(spinnerLbl)();
    if (!options.quiet) {
        await spinner(spinnerLbl);
    }
    try {
        const plugin = ecosystems_1.getPlugin(ecosystem);
        const pluginResponse = await plugin.scan(options);
        const payloads = [];
        // TODO: This is a temporary workaround until the plugins themselves can read policy files and set names!
        for (const scanResult of pluginResponse.scanResults) {
            // WARNING! This mutates the payload. Policy logic should be in the plugin.
            const policy = await policy_1.findAndLoadPolicyForScanResult(scanResult, options);
            if (policy !== undefined) {
                scanResult.policy = policy.toString();
            }
            // WARNING! This mutates the payload. The project name logic should be handled in the plugin.
            scanResult.name =
                options['project-name'] || config.PROJECT_NAME || scanResult.name;
            payloads.push({
                method: 'POST',
                url: `${config.API}${options.testDepGraphDockerEndpoint ||
                    '/test-dependencies'}`,
                json: true,
                headers: {
                    'x-is-ci': is_ci_1.isCI(),
                    authorization: api_token_1.getAuthHeader(),
                },
                body: {
                    scanResult,
                },
                qs: common_1.assembleQueryString(options),
            });
        }
        return payloads;
    }
    finally {
        spinner.clear(spinnerLbl)();
    }
}
exports.assembleEcosystemPayloads = assembleEcosystemPayloads;
//# sourceMappingURL=assemble-payloads.js.map