Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class, _temp;

var _react = require("react");

var _propTypes = require("prop-types");

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require("react-dom");

var _reactDom2 = _interopRequireDefault(_reactDom);

var _invariant = require("fbjs/lib/invariant");

var _invariant2 = _interopRequireDefault(_invariant);

var _warning = require("fbjs/lib/warning");

var _warning2 = _interopRequireDefault(_warning);

var _PropTypes = require("./PropTypes");

var _PropTypes2 = _interopRequireDefault(_PropTypes);

var _useTrackBindingPlugin = require("../core/useTrackBindingPlugin");

var _useTrackBindingPlugin2 = _interopRequireDefault(_useTrackBindingPlugin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MetricsElement = (_temp = _class = function (_Component) {
    _inherits(MetricsElement, _Component);

    function MetricsElement() {
        _classCallCheck(this, MetricsElement);

        return _possibleConstructorReturn(this, (MetricsElement.__proto__ || Object.getPrototypeOf(MetricsElement)).apply(this, arguments));
    }

    _createClass(MetricsElement, [{
        key: "componentDidMount",
        value: function componentDidMount() {
            var _context = this.context,
                metrics = _context.metrics,
                _metricsConfig = _context._metricsConfig;


            (0, _invariant2.default)(metrics, "MetricsElement requires metrics HOC to exist in the parent tree.");

            var useTrackBinding = _metricsConfig.useTrackBinding,
                attributePrefix = _metricsConfig.attributePrefix,
                suppressTrackBindingWarning = _metricsConfig.suppressTrackBindingWarning;


            if (!suppressTrackBindingWarning) {
                (0, _warning2.default)(!useTrackBinding, "You are using 'MetricsElement' while default track binding is turned on. " + "It is recommended that you stick with either one to avoid double tracking accidentally. " + "If you intentionally use both and want to suppress this warning, pass 'suppressTrackBindingWarning=true' to the metrics options.");
            }

            this._trackBindingListener = (0, _useTrackBindingPlugin2.default)({
                callback: this._handleClick.bind(this),
                rootElement: _reactDom2.default.findDOMNode(this),
                attributePrefix: attributePrefix,
                traverseParent: true
            });
        }
    }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
            if (this._trackBindingListener) {
                this._trackBindingListener.remove();
                this._trackBindingListener = null;
            }
        }
    }, {
        key: "_handleClick",
        value: function _handleClick() {
            var _context$metrics;

            (_context$metrics = this.context.metrics).track.apply(_context$metrics, arguments);
        }
    }, {
        key: "render",
        value: function render() {
            var _props = this.props,
                element = _props.element,
                children = _props.children,
                rest = _objectWithoutProperties(_props, ["element", "children"]);

            if (!element) {
                return _react.Children.only(children);
            }

            return (0, _react.isValidElement)(element) ? (0, _react.cloneElement)(element, rest) : (0, _react.createElement)(element, rest, children);
        }
    }]);

    return MetricsElement;
}(_react.Component), _class.contextTypes = {
    metrics: _PropTypes2.default.metrics,
    _metrics: _propTypes2.default.object,
    _metricsConfig: _propTypes2.default.object
}, _class.propTypes = {
    children: _propTypes2.default.node,
    element: _propTypes2.default.any
}, _temp);
exports.default = MetricsElement;