<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->


# is-ssh

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Version](https://img.shields.io/npm/v/is-ssh.svg)](https://www.npmjs.com/package/is-ssh) [![Downloads](https://img.shields.io/npm/dt/is-ssh.svg)](https://www.npmjs.com/package/is-ssh) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>

> Check if an input value is a ssh url or not.

## :cloud: Installation

```sh
# Using npm
npm install --save is-ssh

# Using yarn
yarn add is-ssh
```


## :clipboard: Example



```js
// Dependencies
const isSsh = require("is-ssh");

// Secure Shell Transport Protocol (SSH)
console.log(isSsh("ssh://user@host.xz:port/path/to/repo.git/"));
// true

console.log(isSsh("ssh://user@host.xz/path/to/repo.git/"));
// true

console.log(isSsh("ssh://host.xz:port/path/to/repo.git/"));
// true

console.log(isSsh("ssh://host.xz/path/to/repo.git/"));
// true

console.log(isSsh("ssh://user@host.xz/path/to/repo.git/"));
// true

console.log(isSsh("ssh://host.xz/path/to/repo.git/"));
// true

console.log(isSsh("ssh://user@host.xz/~user/path/to/repo.git/"));
// true

console.log(isSsh("ssh://host.xz/~user/path/to/repo.git/"));
// true

console.log(isSsh("ssh://user@host.xz/~/path/to/repo.git"));
// true

console.log(isSsh("ssh://host.xz/~/path/to/repo.git"));
// true


console.log(isSsh("user@host.xz:/path/to/repo.git/"));
// true

console.log(isSsh("user@host.xz:~user/path/to/repo.git/"));
// true

console.log(isSsh("user@host.xz:path/to/repo.git"));
// true


console.log(isSsh("host.xz:/path/to/repo.git/"));
// true

console.log(isSsh("host.xz:path/to/repo.git"));
// true

console.log(isSsh("host.xz:~user/path/to/repo.git/"));
// true


console.log(isSsh("rsync://host.xz/path/to/repo.git/"));
// true


// Git Transport Protocol
console.log(isSsh("git://host.xz/path/to/repo.git/"));
// false

console.log(isSsh("git://host.xz/~user/path/to/repo.git/"));
// false

// HTTP/S Transport Protocol
console.log(isSsh("http://host.xz/path/to/repo.git/"));
// false

console.log(isSsh("https://host.xz/path/to/repo.git/"));
// false

// Local (Filesystem) Transport Protocol
console.log(isSsh("/path/to/repo.git/"));
// false

console.log(isSsh("path/to/repo.git/"));
// false

console.log(isSsh("~/path/to/repo.git"));
// false

console.log(isSsh("file:///path/to/repo.git/"));
// false

console.log(isSsh("file://~/path/to/repo.git/"));
// false
```



## :question: Get Help

There are few ways to get help:

 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:

 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:



## :memo: Documentation


### `isSsh(input)`
Checks if an input value is a ssh url or not.

#### Params

- **String|Array** `input`: The input url or an array of protocols.

#### Return
- **Boolean** `true` if the input is a ssh url, `false` otherwise.



## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects

I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:


## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:


 - [`bb-git-up`](https://github.com/IonicaBizau/git-up)—A low level git url parser.
 - [`bb-parse-url`](https://github.com/IonicaBizau/parse-url)—An advanced url parser supporting git urls too.
 - [`git-up`](https://github.com/IonicaBizau/git-up)—A low level git url parser.
 - [`miguelcostero-ng2-toasty`](https://github.com/akserg/ng2-toasty) (by Sergey Akopkokhyants)—Angular2 Toasty component shows growl-style alerts and messages for your web app
 - [`nodegit-clone`](https://github.com/blond/nodegit-clone#readme) (by Andrew Abramov)—Clone git repository with nodegit
 - [`normalize-ssh`](https://github.com/zkochan/normalize-ssh#readme) (by Zoltan Kochan)—Normalize a SSH URL
 - [`parse-path`](https://github.com/IonicaBizau/parse-path)—Parse paths (local paths, urls: ssh/git/etc)
 - [`parse-url`](https://github.com/IonicaBizau/parse-url)—An advanced url parser supporting git urls too.

## :scroll: License

[MIT][license] © [Ionică Bizău][website]


[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg

[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW

[license]: http://showalicense.com/?fullname=Ionic%C4%83%20Biz%C4%83u%20%3Cbizauionica%40gmail.com%3E%20(http%3A%2F%2Fionicabizau.net)&year=2015#license-mit
[website]: http://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
