'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _classnames3 = require('classnames');

var _classnames4 = _interopRequireDefault(_classnames3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var scrollTo = function scrollTo(element, to, duration) {
  var requestAnimationFrame = window.requestAnimationFrame || function requestAnimationFrameTimeout() {
    return setTimeout(arguments[0], 10);
  };
  // jump to target if duration zero
  if (duration <= 0) {
    element.scrollTop = to;
    return;
  }
  var difference = to - element.scrollTop;
  var perTick = difference / duration * 10;

  requestAnimationFrame(function () {
    element.scrollTop = element.scrollTop + perTick;
    if (element.scrollTop === to) return;
    scrollTo(element, to, duration - 10);
  });
};

var Select = function (_Component) {
  (0, _inherits3['default'])(Select, _Component);

  function Select() {
    var _ref;

    var _temp, _this, _ret;

    (0, _classCallCheck3['default'])(this, Select);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = (0, _possibleConstructorReturn3['default'])(this, (_ref = Select.__proto__ || Object.getPrototypeOf(Select)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      active: false
    }, _this.onSelect = function (value) {
      var _this$props = _this.props,
          onSelect = _this$props.onSelect,
          type = _this$props.type;

      onSelect(type, value);
    }, _this.handleMouseEnter = function (e) {
      _this.setState({ active: true });
      _this.props.onMouseEnter(e);
    }, _this.handleMouseLeave = function () {
      _this.setState({ active: false });
    }, _this.saveList = function (node) {
      _this.list = node;
    }, _temp), (0, _possibleConstructorReturn3['default'])(_this, _ret);
  }

  (0, _createClass3['default'])(Select, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      // jump to selected option
      this.scrollToSelected(0);
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate(prevProps) {
      // smooth scroll to selected option
      if (prevProps.selectedIndex !== this.props.selectedIndex) {
        this.scrollToSelected(120);
      }
    }
  }, {
    key: 'getOptions',
    value: function getOptions() {
      var _this2 = this;

      var _props = this.props,
          options = _props.options,
          selectedIndex = _props.selectedIndex,
          prefixCls = _props.prefixCls;

      return options.map(function (item, index) {
        var _classnames;

        var cls = (0, _classnames4['default'])((_classnames = {}, (0, _defineProperty3['default'])(_classnames, prefixCls + '-select-option-selected', selectedIndex === index), (0, _defineProperty3['default'])(_classnames, prefixCls + '-select-option-disabled', item.disabled), _classnames));
        var onclick = null;
        if (!item.disabled) {
          onclick = _this2.onSelect.bind(_this2, item.value);
        }
        return _react2['default'].createElement(
          'li',
          {
            className: cls,
            key: index,
            onClick: onclick,
            disabled: item.disabled
          },
          item.value
        );
      });
    }
  }, {
    key: 'scrollToSelected',
    value: function scrollToSelected(duration) {
      // move to selected item
      var select = _reactDom2['default'].findDOMNode(this);
      var list = _reactDom2['default'].findDOMNode(this.list);
      if (!list) {
        return;
      }
      var index = this.props.selectedIndex;
      if (index < 0) {
        index = 0;
      }
      var topOption = list.children[index];
      var to = topOption.offsetTop;
      scrollTo(select, to, duration);
    }
  }, {
    key: 'render',
    value: function render() {
      var _classnames2;

      if (this.props.options.length === 0) {
        return null;
      }

      var prefixCls = this.props.prefixCls;

      var cls = (0, _classnames4['default'])((_classnames2 = {}, (0, _defineProperty3['default'])(_classnames2, prefixCls + '-select', 1), (0, _defineProperty3['default'])(_classnames2, prefixCls + '-select-active', this.state.active), _classnames2));

      return _react2['default'].createElement(
        'div',
        {
          className: cls,
          onMouseEnter: this.handleMouseEnter,
          onMouseLeave: this.handleMouseLeave
        },
        _react2['default'].createElement(
          'ul',
          { ref: this.saveList },
          this.getOptions()
        )
      );
    }
  }]);
  return Select;
}(_react.Component);

Select.propTypes = {
  prefixCls: _propTypes2['default'].string,
  options: _propTypes2['default'].array,
  selectedIndex: _propTypes2['default'].number,
  type: _propTypes2['default'].string,
  onSelect: _propTypes2['default'].func,
  onMouseEnter: _propTypes2['default'].func
};
exports['default'] = Select;
module.exports = exports['default'];