Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = metrics;

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

var _propTypes = require("prop-types");

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDom = require("react-dom");

var _reactDom2 = _interopRequireDefault(_reactDom);

var _invariant = require("fbjs/lib/invariant");

var _invariant2 = _interopRequireDefault(_invariant);

var _ExecutionEnvironment = require("fbjs/lib/ExecutionEnvironment");

var _PropTypes = require("./PropTypes");

var _createMetrics = require("../core/createMetrics");

var _createMetrics2 = _interopRequireDefault(_createMetrics);

var _getRouteState = require("./getRouteState");

var _getRouteState2 = _interopRequireDefault(_getRouteState);

var _findRouteComponent = require("./findRouteComponent");

var _findRouteComponent2 = _interopRequireDefault(_findRouteComponent);

var _hoistNonReactStatics = require("hoist-non-react-statics");

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function getDisplayName(Comp) {
    return Comp.displayName || Comp.name || "Component";
}

var mountedInstances = void 0;

function metrics(metricsOrConfig) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var autoTrackPageView = options.autoTrackPageView !== false;
    var useTrackBinding = options.useTrackBinding !== false;
    var attributePrefix = options.attributePrefix;
    var suppressTrackBindingWarning = !!options.suppressTrackBindingWarning;
    var getNewRouteState = options.getRouteState || _getRouteState2.default;
    var findNewRouteComponent = options.findRouteComponent || _findRouteComponent2.default;
    var metricsInstance = (0, _createMetrics.isMetrics)(metricsOrConfig) ? metricsOrConfig : (0, _createMetrics2.default)(metricsOrConfig);

    return function wrap(ComposedComponent) {
        var _class, _temp;

        var MetricsContainer = (_temp = _class = function (_Component) {
            _inherits(MetricsContainer, _Component);

            function MetricsContainer() {
                _classCallCheck(this, MetricsContainer);

                return _possibleConstructorReturn(this, (MetricsContainer.__proto__ || Object.getPrototypeOf(MetricsContainer)).apply(this, arguments));
            }

            _createClass(MetricsContainer, [{
                key: "componentWillMount",
                value: function componentWillMount() {
                    if (!_ExecutionEnvironment.canUseDOM) {
                        return;
                    }

                    var instances = this.constructor.getMountedMetricsInstances();
                    instances.push(ComposedComponent);

                    this._newRouteState = getNewRouteState(this.props);
                    if (this._newRouteState) {
                        this._getMetrics().setRouteState(this._newRouteState);
                    }
                }
            }, {
                key: "componentDidMount",
                value: function componentDidMount() {
                    if (useTrackBinding) {
                        var rootElement = _reactDom2.default.findDOMNode(this);
                        // TODO: is this invariant check still valid after react >= 0.14.0?
                        (0, _invariant2.default)(rootElement, "`metrics` should be added to the root most component which renders node element for declarative tracking to work.");
                        this._getMetrics().useTrackBinding(rootElement, attributePrefix);
                    }

                    if (this._newRouteState) {
                        this._handleRouteStateChange(this._newRouteState);
                        this._newRouteState = null;
                    }
                }
            }, {
                key: "componentWillReceiveProps",
                value: function componentWillReceiveProps(newProps) {
                    this._newRouteState = getNewRouteState(newProps, this.props);
                    if (this._newRouteState) {
                        this._getMetrics().setRouteState(this._newRouteState);
                    }
                }
            }, {
                key: "componentDidUpdate",
                value: function componentDidUpdate() {
                    if (this._newRouteState) {
                        this._handleRouteStateChange(this._newRouteState);
                        this._newRouteState = null;
                    }
                }
            }, {
                key: "componentWillUnmount",
                value: function componentWillUnmount() {
                    var instances = this.constructor.getMountedMetricsInstances();
                    var index = instances.indexOf(ComposedComponent);
                    instances.splice(index, 1);

                    this._getMetrics().destroy();
                }
            }, {
                key: "getChildContext",
                value: function getChildContext() {
                    return {
                        metrics: this._getMetrics().api,
                        _metricsConfig: {
                            autoTrackPageView: autoTrackPageView,
                            useTrackBinding: useTrackBinding,
                            attributePrefix: attributePrefix,
                            suppressTrackBindingWarning: suppressTrackBindingWarning,
                            getNewRouteState: getNewRouteState,
                            findNewRouteComponent: findNewRouteComponent
                        }
                    };
                }
            }, {
                key: "_getMetrics",
                value: function _getMetrics() {
                    return metricsInstance;
                }
                /**
                 * Triggered when the route changes and fires page view tracking.
                 *
                 * @method _handleRouteStateChange
                 * @param {Object} props
                 * @private
                 */

            }, {
                key: "_handleRouteStateChange",
                value: function _handleRouteStateChange(routeState) {
                    var component = findNewRouteComponent();
                    var metricsInst = this._getMetrics();
                    var pageViewParams = void 0;
                    var shouldSuppress = false;

                    if (component) {
                        var ret = component.willTrackPageView && component.willTrackPageView(routeState);
                        if (ret === false) {
                            shouldSuppress = true;
                        } else if (ret) {
                            pageViewParams = ret;
                        }
                    }

                    if (metricsInst.enabled && autoTrackPageView && !shouldSuppress) {
                        (0, _invariant2.default)(typeof metricsInst.api.pageView === "function", "react-metrics: 'pageView' api needs to be defined for automatic page view tracking.");
                        metricsInst.api.pageView(pageViewParams);
                    }
                }
                /**
                 * Renders composed component.
                 *
                 * @method render
                 * @returns {ReactElement}
                 */

            }, {
                key: "render",
                value: function render() {
                    return _react2.default.createElement(ComposedComponent, _extends({}, this.props, this.getChildContext()));
                }
            }], [{
                key: "getMountedMetricsInstances",
                value: function getMountedMetricsInstances() {
                    // eslint-disable-line react/sort-comp
                    if (!mountedInstances) {
                        mountedInstances = [];
                    }
                    return mountedInstances;
                }
            }]);

            return MetricsContainer;
        }(_react.Component), _class.displayName = "MetricsContainer", _class.childContextTypes = {
            metrics: _PropTypes.metrics.isRequired,
            _metricsConfig: _propTypes2.default.object
        }, _class.propTypes = {
            location: _PropTypes.location,
            params: _propTypes2.default.object
        }, _temp);


        return (0, _hoistNonReactStatics2.default)(MetricsContainer, ComposedComponent);
    };
}