"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var process = require("process");
var IncrementalChecker_1 = require("./IncrementalChecker");
var CancellationToken_1 = require("./CancellationToken");
var OperationCanceledException_1 = require("./OperationCanceledException");
var checker = new IncrementalChecker_1.IncrementalChecker(process.env.TYPESCRIPT_PATH, process.env.TSCONFIG, JSON.parse(process.env.COMPILER_OPTIONS), process.env.TSLINT === '' ? false : process.env.TSLINT, process.env.WATCH === '' ? [] : process.env.WATCH.split('|'), parseInt(process.env.WORK_NUMBER, 10), parseInt(process.env.WORK_DIVISION, 10), process.env.CHECK_SYNTACTIC_ERRORS === 'true', process.env.VUE === 'true');
function run(cancellationToken) {
    var diagnostics = [];
    var lints = [];
    checker.nextIteration();
    try {
        diagnostics = checker.getDiagnostics(cancellationToken);
        if (checker.hasLinter()) {
            lints = checker.getLints(cancellationToken);
        }
    }
    catch (error) {
        if (error instanceof OperationCanceledException_1.OperationCanceledException) {
            return;
        }
        throw error;
    }
    if (!cancellationToken.isCancellationRequested()) {
        try {
            process.send({
                diagnostics: diagnostics,
                lints: lints
            });
        }
        catch (e) {
            // channel closed...
            process.exit();
        }
    }
}
process.on('message', function (message) {
    run(CancellationToken_1.CancellationToken.createFromJSON(message));
});
process.on('SIGINT', function () {
    process.exit();
});
