Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.filterKeysByType = filterKeysByType;
exports.aggregateApisByType = aggregateApisByType;
exports.default = extractApis;

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var EXCLUDES = ["constructor"].concat(Object.getOwnPropertyNames(Object.getPrototypeOf({})));

function filterKeysByType(obj) {
    var total = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "function";

    return Object.getOwnPropertyNames(obj).filter(function (key) {
        return total.indexOf(key) === -1 && EXCLUDES.indexOf(key) === -1 && key.indexOf("_") !== 0 && // consider it's private
        obj.hasOwnProperty(key) && _typeof(obj[key]) === type;
    });
}

function aggregateApisByType(obj) {
    var total = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    var keys = [];
    while (obj !== null) {
        // eslint-disable-line no-eq-null
        var arr = filterKeysByType(obj, total);
        keys.push.apply(keys, _toConsumableArray(arr));
        obj = Object.getPrototypeOf(obj);
    }
    return keys;
}

// extracts lists of methods from each service object.
function extractApis(services) {
    services = Array.isArray(services) ? services : [services];
    var apis = services.reduce(function (total, service) {
        var obj = service.constructor === Object ? service : Object.getPrototypeOf(service);
        var keys = aggregateApisByType(obj, total);
        total.push.apply(total, _toConsumableArray(keys));
        return total;
    }, []);

    return apis;
}