var split = require('split');
var through = require('through');
var Readable = require('stream').Readable;
var PassThrough = require('stream').PassThrough;
var logfmt   = require('../logfmt');

exports = module.exports = function(options){
  if(options == null) options = {};
  var mime = options.contentType || "application/logplex-1";

  return function(req, res, next) {

    //honor already parsed bodies
    if (req._body) return next();

    //mime-type check
    var is_mime = req.header('content-type') === mime;
    if (!is_mime) return next();
    req._body = true;
    req.body = new PassThrough({objectMode: true});
    req.pipe(logfmt.streamParser()).pipe(req.body);

    return next();
  }
}

