package frontdoor

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Action enumerates the values for action.
type Action string

const (
	// Allow ...
	Allow Action = "Allow"
	// Block ...
	Block Action = "Block"
	// Log ...
	Log Action = "Log"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Allow, Block, Log}
}

// Availability enumerates the values for availability.
type Availability string

const (
	// Available ...
	Available Availability = "Available"
	// Unavailable ...
	Unavailable Availability = "Unavailable"
)

// PossibleAvailabilityValues returns an array of possible values for the Availability const type.
func PossibleAvailabilityValues() []Availability {
	return []Availability{Available, Unavailable}
}

// CertificateSource enumerates the values for certificate source.
type CertificateSource string

const (
	// CertificateSourceAzureKeyVault ...
	CertificateSourceAzureKeyVault CertificateSource = "AzureKeyVault"
	// CertificateSourceFrontDoor ...
	CertificateSourceFrontDoor CertificateSource = "FrontDoor"
)

// PossibleCertificateSourceValues returns an array of possible values for the CertificateSource const type.
func PossibleCertificateSourceValues() []CertificateSource {
	return []CertificateSource{CertificateSourceAzureKeyVault, CertificateSourceFrontDoor}
}

// CertificateType enumerates the values for certificate type.
type CertificateType string

const (
	// Dedicated ...
	Dedicated CertificateType = "Dedicated"
)

// PossibleCertificateTypeValues returns an array of possible values for the CertificateType const type.
func PossibleCertificateTypeValues() []CertificateType {
	return []CertificateType{Dedicated}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{Disabled, Disabling, Enabled, Enabling, Failed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// DynamicCompressionEnabled enumerates the values for dynamic compression enabled.
type DynamicCompressionEnabled string

const (
	// DynamicCompressionEnabledDisabled ...
	DynamicCompressionEnabledDisabled DynamicCompressionEnabled = "Disabled"
	// DynamicCompressionEnabledEnabled ...
	DynamicCompressionEnabledEnabled DynamicCompressionEnabled = "Enabled"
)

// PossibleDynamicCompressionEnabledValues returns an array of possible values for the DynamicCompressionEnabled const type.
func PossibleDynamicCompressionEnabledValues() []DynamicCompressionEnabled {
	return []DynamicCompressionEnabled{DynamicCompressionEnabledDisabled, DynamicCompressionEnabledEnabled}
}

// EnabledState enumerates the values for enabled state.
type EnabledState string

const (
	// EnabledStateDisabled ...
	EnabledStateDisabled EnabledState = "Disabled"
	// EnabledStateEnabled ...
	EnabledStateEnabled EnabledState = "Enabled"
)

// PossibleEnabledStateValues returns an array of possible values for the EnabledState const type.
func PossibleEnabledStateValues() []EnabledState {
	return []EnabledState{EnabledStateDisabled, EnabledStateEnabled}
}

// EnabledStateEnum enumerates the values for enabled state enum.
type EnabledStateEnum string

const (
	// EnabledStateEnumDisabled ...
	EnabledStateEnumDisabled EnabledStateEnum = "Disabled"
	// EnabledStateEnumEnabled ...
	EnabledStateEnumEnabled EnabledStateEnum = "Enabled"
)

// PossibleEnabledStateEnumValues returns an array of possible values for the EnabledStateEnum const type.
func PossibleEnabledStateEnumValues() []EnabledStateEnum {
	return []EnabledStateEnum{EnabledStateEnumDisabled, EnabledStateEnumEnabled}
}

// ForwardingProtocol enumerates the values for forwarding protocol.
type ForwardingProtocol string

const (
	// HTTPOnly ...
	HTTPOnly ForwardingProtocol = "HttpOnly"
	// HTTPSOnly ...
	HTTPSOnly ForwardingProtocol = "HttpsOnly"
	// MatchRequest ...
	MatchRequest ForwardingProtocol = "MatchRequest"
)

// PossibleForwardingProtocolValues returns an array of possible values for the ForwardingProtocol const type.
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return []ForwardingProtocol{HTTPOnly, HTTPSOnly, MatchRequest}
}

// MatchCondition enumerates the values for match condition.
type MatchCondition string

const (
	// PostArgs ...
	PostArgs MatchCondition = "PostArgs"
	// QueryString ...
	QueryString MatchCondition = "QueryString"
	// RemoteAddr ...
	RemoteAddr MatchCondition = "RemoteAddr"
	// RequestBody ...
	RequestBody MatchCondition = "RequestBody"
	// RequestHeader ...
	RequestHeader MatchCondition = "RequestHeader"
	// RequestMethod ...
	RequestMethod MatchCondition = "RequestMethod"
	// RequestURI ...
	RequestURI MatchCondition = "RequestUri"
)

// PossibleMatchConditionValues returns an array of possible values for the MatchCondition const type.
func PossibleMatchConditionValues() []MatchCondition {
	return []MatchCondition{PostArgs, QueryString, RemoteAddr, RequestBody, RequestHeader, RequestMethod, RequestURI}
}

// Mode enumerates the values for mode.
type Mode string

const (
	// Detection ...
	Detection Mode = "Detection"
	// Prevention ...
	Prevention Mode = "Prevention"
)

// PossibleModeValues returns an array of possible values for the Mode const type.
func PossibleModeValues() []Mode {
	return []Mode{Detection, Prevention}
}

// NetworkOperationStatus enumerates the values for network operation status.
type NetworkOperationStatus string

const (
	// NetworkOperationStatusFailed ...
	NetworkOperationStatusFailed NetworkOperationStatus = "Failed"
	// NetworkOperationStatusInProgress ...
	NetworkOperationStatusInProgress NetworkOperationStatus = "InProgress"
	// NetworkOperationStatusSucceeded ...
	NetworkOperationStatusSucceeded NetworkOperationStatus = "Succeeded"
)

// PossibleNetworkOperationStatusValues returns an array of possible values for the NetworkOperationStatus const type.
func PossibleNetworkOperationStatusValues() []NetworkOperationStatus {
	return []NetworkOperationStatus{NetworkOperationStatusFailed, NetworkOperationStatusInProgress, NetworkOperationStatusSucceeded}
}

// Operator enumerates the values for operator.
type Operator string

const (
	// Any ...
	Any Operator = "Any"
	// BeginsWith ...
	BeginsWith Operator = "BeginsWith"
	// Contains ...
	Contains Operator = "Contains"
	// EndsWith ...
	EndsWith Operator = "EndsWith"
	// Equal ...
	Equal Operator = "Equal"
	// GeoMatch ...
	GeoMatch Operator = "GeoMatch"
	// GreaterThan ...
	GreaterThan Operator = "GreaterThan"
	// GreaterThanOrEqual ...
	GreaterThanOrEqual Operator = "GreaterThanOrEqual"
	// IPMatch ...
	IPMatch Operator = "IPMatch"
	// LessThan ...
	LessThan Operator = "LessThan"
	// LessThanOrEqual ...
	LessThanOrEqual Operator = "LessThanOrEqual"
)

// PossibleOperatorValues returns an array of possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{Any, BeginsWith, Contains, EndsWith, Equal, GeoMatch, GreaterThan, GreaterThanOrEqual, IPMatch, LessThan, LessThanOrEqual}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// HTTP ...
	HTTP Protocol = "Http"
	// HTTPS ...
	HTTPS Protocol = "Https"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{HTTP, HTTPS}
}

// Query enumerates the values for query.
type Query string

const (
	// StripAll ...
	StripAll Query = "StripAll"
	// StripNone ...
	StripNone Query = "StripNone"
)

// PossibleQueryValues returns an array of possible values for the Query const type.
func PossibleQueryValues() []Query {
	return []Query{StripAll, StripNone}
}

// ResourceState enumerates the values for resource state.
type ResourceState string

const (
	// ResourceStateCreating ...
	ResourceStateCreating ResourceState = "Creating"
	// ResourceStateDeleting ...
	ResourceStateDeleting ResourceState = "Deleting"
	// ResourceStateDisabled ...
	ResourceStateDisabled ResourceState = "Disabled"
	// ResourceStateDisabling ...
	ResourceStateDisabling ResourceState = "Disabling"
	// ResourceStateEnabled ...
	ResourceStateEnabled ResourceState = "Enabled"
	// ResourceStateEnabling ...
	ResourceStateEnabling ResourceState = "Enabling"
)

// PossibleResourceStateValues returns an array of possible values for the ResourceState const type.
func PossibleResourceStateValues() []ResourceState {
	return []ResourceState{ResourceStateCreating, ResourceStateDeleting, ResourceStateDisabled, ResourceStateDisabling, ResourceStateEnabled, ResourceStateEnabling}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftNetworkfrontDoors ...
	MicrosoftNetworkfrontDoors ResourceType = "Microsoft.Network/frontDoors"
	// MicrosoftNetworkfrontDoorsfrontendEndpoints ...
	MicrosoftNetworkfrontDoorsfrontendEndpoints ResourceType = "Microsoft.Network/frontDoors/frontendEndpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftNetworkfrontDoors, MicrosoftNetworkfrontDoorsfrontendEndpoints}
}

// RuleGroupOverride enumerates the values for rule group override.
type RuleGroupOverride string

const (
	// SQLInjection ...
	SQLInjection RuleGroupOverride = "SqlInjection"
	// XSS ...
	XSS RuleGroupOverride = "XSS"
)

// PossibleRuleGroupOverrideValues returns an array of possible values for the RuleGroupOverride const type.
func PossibleRuleGroupOverrideValues() []RuleGroupOverride {
	return []RuleGroupOverride{SQLInjection, XSS}
}

// RuleSetType enumerates the values for rule set type.
type RuleSetType string

const (
	// RuleSetTypeAzureManagedRuleSet ...
	RuleSetTypeAzureManagedRuleSet RuleSetType = "AzureManagedRuleSet"
	// RuleSetTypeUnknown ...
	RuleSetTypeUnknown RuleSetType = "Unknown"
)

// PossibleRuleSetTypeValues returns an array of possible values for the RuleSetType const type.
func PossibleRuleSetTypeValues() []RuleSetType {
	return []RuleSetType{RuleSetTypeAzureManagedRuleSet, RuleSetTypeUnknown}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// MatchRule ...
	MatchRule RuleType = "MatchRule"
	// RateLimitRule ...
	RateLimitRule RuleType = "RateLimitRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{MatchRule, RateLimitRule}
}

// SessionAffinityEnabledState enumerates the values for session affinity enabled state.
type SessionAffinityEnabledState string

const (
	// SessionAffinityEnabledStateDisabled ...
	SessionAffinityEnabledStateDisabled SessionAffinityEnabledState = "Disabled"
	// SessionAffinityEnabledStateEnabled ...
	SessionAffinityEnabledStateEnabled SessionAffinityEnabledState = "Enabled"
)

// PossibleSessionAffinityEnabledStateValues returns an array of possible values for the SessionAffinityEnabledState const type.
func PossibleSessionAffinityEnabledStateValues() []SessionAffinityEnabledState {
	return []SessionAffinityEnabledState{SessionAffinityEnabledStateDisabled, SessionAffinityEnabledStateEnabled}
}

// TLSProtocolType enumerates the values for tls protocol type.
type TLSProtocolType string

const (
	// ServerNameIndication ...
	ServerNameIndication TLSProtocolType = "ServerNameIndication"
)

// PossibleTLSProtocolTypeValues returns an array of possible values for the TLSProtocolType const type.
func PossibleTLSProtocolTypeValues() []TLSProtocolType {
	return []TLSProtocolType{ServerNameIndication}
}

// Transform enumerates the values for transform.
type Transform string

const (
	// HTMLEntityDecode ...
	HTMLEntityDecode Transform = "HtmlEntityDecode"
	// Lowercase ...
	Lowercase Transform = "Lowercase"
	// RemoveNulls ...
	RemoveNulls Transform = "RemoveNulls"
	// Trim ...
	Trim Transform = "Trim"
	// Uppercase ...
	Uppercase Transform = "Uppercase"
	// URLDecode ...
	URLDecode Transform = "UrlDecode"
	// URLEncode ...
	URLEncode Transform = "UrlEncode"
)

// PossibleTransformValues returns an array of possible values for the Transform const type.
func PossibleTransformValues() []Transform {
	return []Transform{HTMLEntityDecode, Lowercase, RemoveNulls, Trim, Uppercase, URLDecode, URLEncode}
}

// WebApplicationFirewallPolicy enumerates the values for web application firewall policy.
type WebApplicationFirewallPolicy string

const (
	// WebApplicationFirewallPolicyCreating ...
	WebApplicationFirewallPolicyCreating WebApplicationFirewallPolicy = "Creating"
	// WebApplicationFirewallPolicyDeleting ...
	WebApplicationFirewallPolicyDeleting WebApplicationFirewallPolicy = "Deleting"
	// WebApplicationFirewallPolicyDisabled ...
	WebApplicationFirewallPolicyDisabled WebApplicationFirewallPolicy = "Disabled"
	// WebApplicationFirewallPolicyDisabling ...
	WebApplicationFirewallPolicyDisabling WebApplicationFirewallPolicy = "Disabling"
	// WebApplicationFirewallPolicyEnabled ...
	WebApplicationFirewallPolicyEnabled WebApplicationFirewallPolicy = "Enabled"
	// WebApplicationFirewallPolicyEnabling ...
	WebApplicationFirewallPolicyEnabling WebApplicationFirewallPolicy = "Enabling"
)

// PossibleWebApplicationFirewallPolicyValues returns an array of possible values for the WebApplicationFirewallPolicy const type.
func PossibleWebApplicationFirewallPolicyValues() []WebApplicationFirewallPolicy {
	return []WebApplicationFirewallPolicy{WebApplicationFirewallPolicyCreating, WebApplicationFirewallPolicyDeleting, WebApplicationFirewallPolicyDisabled, WebApplicationFirewallPolicyDisabling, WebApplicationFirewallPolicyEnabled, WebApplicationFirewallPolicyEnabling}
}
