// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: pkg/logqlmodel/stats/stats.proto

package stats

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Result contains LogQL query statistics.
type Result struct {
	Summary  Summary  `protobuf:"bytes,1,opt,name=summary,proto3" json:"summary"`
	Store    Store    `protobuf:"bytes,2,opt,name=store,proto3" json:"store"`
	Ingester Ingester `protobuf:"bytes,3,opt,name=ingester,proto3" json:"ingester"`
}

func (m *Result) Reset()      { *m = Result{} }
func (*Result) ProtoMessage() {}
func (*Result) Descriptor() ([]byte, []int) {
	return fileDescriptor_6cdfe5d2aea33ebb, []int{0}
}
func (m *Result) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Result) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Result.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Result) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Result.Merge(m, src)
}
func (m *Result) XXX_Size() int {
	return m.Size()
}
func (m *Result) XXX_DiscardUnknown() {
	xxx_messageInfo_Result.DiscardUnknown(m)
}

var xxx_messageInfo_Result proto.InternalMessageInfo

func (m *Result) GetSummary() Summary {
	if m != nil {
		return m.Summary
	}
	return Summary{}
}

func (m *Result) GetStore() Store {
	if m != nil {
		return m.Store
	}
	return Store{}
}

func (m *Result) GetIngester() Ingester {
	if m != nil {
		return m.Ingester
	}
	return Ingester{}
}

// Summary is the summary of a query statistics.
type Summary struct {
	// Total bytes processed per second.
	BytesProcessedPerSecond int64 `protobuf:"varint,1,opt,name=bytesProcessedPerSecond,proto3" json:"bytesProcessedPerSecond"`
	// Total lines processed per second.
	LinesProcessedPerSecond int64 `protobuf:"varint,2,opt,name=linesProcessedPerSecond,proto3" json:"linesProcessedPerSecond"`
	// Total bytes processed.
	TotalBytesProcessed int64 `protobuf:"varint,3,opt,name=totalBytesProcessed,proto3" json:"totalBytesProcessed"`
	// Total lines processed.
	TotalLinesProcessed int64 `protobuf:"varint,4,opt,name=totalLinesProcessed,proto3" json:"totalLinesProcessed"`
	// Execution time in seconds.
	ExecTime float64 `protobuf:"fixed64,5,opt,name=execTime,proto3" json:"execTime"`
}

func (m *Summary) Reset()      { *m = Summary{} }
func (*Summary) ProtoMessage() {}
func (*Summary) Descriptor() ([]byte, []int) {
	return fileDescriptor_6cdfe5d2aea33ebb, []int{1}
}
func (m *Summary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Summary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Summary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Summary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Summary.Merge(m, src)
}
func (m *Summary) XXX_Size() int {
	return m.Size()
}
func (m *Summary) XXX_DiscardUnknown() {
	xxx_messageInfo_Summary.DiscardUnknown(m)
}

var xxx_messageInfo_Summary proto.InternalMessageInfo

func (m *Summary) GetBytesProcessedPerSecond() int64 {
	if m != nil {
		return m.BytesProcessedPerSecond
	}
	return 0
}

func (m *Summary) GetLinesProcessedPerSecond() int64 {
	if m != nil {
		return m.LinesProcessedPerSecond
	}
	return 0
}

func (m *Summary) GetTotalBytesProcessed() int64 {
	if m != nil {
		return m.TotalBytesProcessed
	}
	return 0
}

func (m *Summary) GetTotalLinesProcessed() int64 {
	if m != nil {
		return m.TotalLinesProcessed
	}
	return 0
}

func (m *Summary) GetExecTime() float64 {
	if m != nil {
		return m.ExecTime
	}
	return 0
}

type Store struct {
	// The total of chunk reference fetched from index.
	TotalChunksRef int64 `protobuf:"varint,1,opt,name=totalChunksRef,proto3" json:"totalChunksRef"`
	// Total number of chunks fetched.
	TotalChunksDownloaded int64 `protobuf:"varint,2,opt,name=totalChunksDownloaded,proto3" json:"totalChunksDownloaded"`
	// Time spent fetching chunks in nanoseconds.
	ChunksDownloadTime float64 `protobuf:"fixed64,3,opt,name=chunksDownloadTime,proto3" json:"chunksDownloadTime"`
	// Total bytes processed but was already in memory. (found in the headchunk)
	HeadChunkBytes int64 `protobuf:"varint,4,opt,name=headChunkBytes,proto3" json:"headChunkBytes"`
	// Total lines processed but was already in memory. (found in the headchunk)
	HeadChunkLines int64 `protobuf:"varint,5,opt,name=headChunkLines,proto3" json:"headChunkLines"`
	// Total bytes decompressed and processed from chunks.
	DecompressedBytes int64 `protobuf:"varint,6,opt,name=decompressedBytes,proto3" json:"decompressedBytes"`
	// Total lines decompressed and processed from chunks.
	DecompressedLines int64 `protobuf:"varint,7,opt,name=decompressedLines,proto3" json:"decompressedLines"`
	// Total bytes of compressed chunks (blocks) processed.
	CompressedBytes int64 `protobuf:"varint,8,opt,name=compressedBytes,proto3" json:"compressedBytes"`
	// Total duplicates found while processing.
	TotalDuplicates int64 `protobuf:"varint,9,opt,name=totalDuplicates,proto3" json:"totalDuplicates"`
}

func (m *Store) Reset()      { *m = Store{} }
func (*Store) ProtoMessage() {}
func (*Store) Descriptor() ([]byte, []int) {
	return fileDescriptor_6cdfe5d2aea33ebb, []int{2}
}
func (m *Store) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Store) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Store.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Store) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Store.Merge(m, src)
}
func (m *Store) XXX_Size() int {
	return m.Size()
}
func (m *Store) XXX_DiscardUnknown() {
	xxx_messageInfo_Store.DiscardUnknown(m)
}

var xxx_messageInfo_Store proto.InternalMessageInfo

func (m *Store) GetTotalChunksRef() int64 {
	if m != nil {
		return m.TotalChunksRef
	}
	return 0
}

func (m *Store) GetTotalChunksDownloaded() int64 {
	if m != nil {
		return m.TotalChunksDownloaded
	}
	return 0
}

func (m *Store) GetChunksDownloadTime() float64 {
	if m != nil {
		return m.ChunksDownloadTime
	}
	return 0
}

func (m *Store) GetHeadChunkBytes() int64 {
	if m != nil {
		return m.HeadChunkBytes
	}
	return 0
}

func (m *Store) GetHeadChunkLines() int64 {
	if m != nil {
		return m.HeadChunkLines
	}
	return 0
}

func (m *Store) GetDecompressedBytes() int64 {
	if m != nil {
		return m.DecompressedBytes
	}
	return 0
}

func (m *Store) GetDecompressedLines() int64 {
	if m != nil {
		return m.DecompressedLines
	}
	return 0
}

func (m *Store) GetCompressedBytes() int64 {
	if m != nil {
		return m.CompressedBytes
	}
	return 0
}

func (m *Store) GetTotalDuplicates() int64 {
	if m != nil {
		return m.TotalDuplicates
	}
	return 0
}

type Ingester struct {
	// Total ingester reached for this query.
	TotalReached int32 `protobuf:"varint,1,opt,name=totalReached,proto3" json:"totalReached"`
	// Total of chunks matched by the query from ingesters
	TotalChunksMatched int64 `protobuf:"varint,2,opt,name=totalChunksMatched,proto3" json:"totalChunksMatched"`
	// Total of batches sent from ingesters.
	TotalBatches int64 `protobuf:"varint,3,opt,name=totalBatches,proto3" json:"totalBatches"`
	// Total lines sent by ingesters.
	TotalLinesSent int64 `protobuf:"varint,4,opt,name=totalLinesSent,proto3" json:"totalLinesSent"`
	// Total bytes processed but was already in memory. (found in the headchunk)
	HeadChunkBytes int64 `protobuf:"varint,5,opt,name=headChunkBytes,proto3" json:"headChunkBytes"`
	// Total lines processed but was already in memory. (found in the headchunk)
	HeadChunkLines int64 `protobuf:"varint,6,opt,name=headChunkLines,proto3" json:"headChunkLines"`
	// Total bytes decompressed and processed from chunks.
	DecompressedBytes int64 `protobuf:"varint,7,opt,name=decompressedBytes,proto3" json:"decompressedBytes"`
	// Total lines decompressed and processed from chunks.
	DecompressedLines int64 `protobuf:"varint,8,opt,name=decompressedLines,proto3" json:"decompressedLines"`
	// Total bytes of compressed chunks (blocks) processed.
	CompressedBytes int64 `protobuf:"varint,9,opt,name=compressedBytes,proto3" json:"compressedBytes"`
	// Total duplicates found while processing.
	TotalDuplicates int64 `protobuf:"varint,10,opt,name=totalDuplicates,proto3" json:"totalDuplicates"`
}

func (m *Ingester) Reset()      { *m = Ingester{} }
func (*Ingester) ProtoMessage() {}
func (*Ingester) Descriptor() ([]byte, []int) {
	return fileDescriptor_6cdfe5d2aea33ebb, []int{3}
}
func (m *Ingester) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Ingester) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Ingester.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Ingester) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Ingester.Merge(m, src)
}
func (m *Ingester) XXX_Size() int {
	return m.Size()
}
func (m *Ingester) XXX_DiscardUnknown() {
	xxx_messageInfo_Ingester.DiscardUnknown(m)
}

var xxx_messageInfo_Ingester proto.InternalMessageInfo

func (m *Ingester) GetTotalReached() int32 {
	if m != nil {
		return m.TotalReached
	}
	return 0
}

func (m *Ingester) GetTotalChunksMatched() int64 {
	if m != nil {
		return m.TotalChunksMatched
	}
	return 0
}

func (m *Ingester) GetTotalBatches() int64 {
	if m != nil {
		return m.TotalBatches
	}
	return 0
}

func (m *Ingester) GetTotalLinesSent() int64 {
	if m != nil {
		return m.TotalLinesSent
	}
	return 0
}

func (m *Ingester) GetHeadChunkBytes() int64 {
	if m != nil {
		return m.HeadChunkBytes
	}
	return 0
}

func (m *Ingester) GetHeadChunkLines() int64 {
	if m != nil {
		return m.HeadChunkLines
	}
	return 0
}

func (m *Ingester) GetDecompressedBytes() int64 {
	if m != nil {
		return m.DecompressedBytes
	}
	return 0
}

func (m *Ingester) GetDecompressedLines() int64 {
	if m != nil {
		return m.DecompressedLines
	}
	return 0
}

func (m *Ingester) GetCompressedBytes() int64 {
	if m != nil {
		return m.CompressedBytes
	}
	return 0
}

func (m *Ingester) GetTotalDuplicates() int64 {
	if m != nil {
		return m.TotalDuplicates
	}
	return 0
}

func init() {
	proto.RegisterType((*Result)(nil), "stats.Result")
	proto.RegisterType((*Summary)(nil), "stats.Summary")
	proto.RegisterType((*Store)(nil), "stats.Store")
	proto.RegisterType((*Ingester)(nil), "stats.Ingester")
}

func init() { proto.RegisterFile("pkg/logqlmodel/stats/stats.proto", fileDescriptor_6cdfe5d2aea33ebb) }

var fileDescriptor_6cdfe5d2aea33ebb = []byte{
	// 677 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xcd, 0x6e, 0x13, 0x3d,
	0x14, 0x1d, 0x37, 0xcd, 0x4f, 0xfd, 0xf5, 0x6b, 0x8b, 0xab, 0xd2, 0x00, 0x92, 0xa7, 0xca, 0xaa,
	0x0b, 0x68, 0xc4, 0xcf, 0x06, 0xa4, 0x6e, 0xa6, 0x15, 0x52, 0x25, 0x10, 0x95, 0x0b, 0x1b, 0x76,
	0x93, 0x89, 0x9b, 0x44, 0x9d, 0x8c, 0xc3, 0x8c, 0x23, 0xe8, 0x8e, 0x47, 0xe0, 0x31, 0x78, 0x01,
	0xde, 0xa1, 0xcb, 0x2e, 0xbb, 0x40, 0x23, 0x3a, 0xdd, 0xa0, 0x59, 0x75, 0x87, 0xc4, 0x0a, 0xcd,
	0x9d, 0x9f, 0x64, 0x1c, 0x47, 0x42, 0x0a, 0x9b, 0xc4, 0xf7, 0x9c, 0x7b, 0xae, 0xed, 0xeb, 0xe3,
	0x31, 0xde, 0x19, 0x9d, 0xf5, 0xda, 0xae, 0xe8, 0x7d, 0x70, 0x87, 0xa2, 0xcb, 0xdd, 0x76, 0x20,
	0x6d, 0x19, 0xa4, 0xbf, 0x7b, 0x23, 0x5f, 0x48, 0x41, 0xaa, 0x10, 0xdc, 0x7f, 0xd4, 0x1b, 0xc8,
	0xfe, 0xb8, 0xb3, 0xe7, 0x88, 0x61, 0xbb, 0x27, 0x7a, 0xa2, 0x0d, 0x6c, 0x67, 0x7c, 0x0a, 0x11,
	0x04, 0x30, 0x4a, 0x55, 0xad, 0x6f, 0x08, 0xd7, 0x18, 0x0f, 0xc6, 0xae, 0x24, 0xcf, 0x71, 0x3d,
	0x18, 0x0f, 0x87, 0xb6, 0x7f, 0xde, 0x44, 0x3b, 0x68, 0xf7, 0xbf, 0x27, 0x6b, 0x7b, 0x69, 0xfd,
	0x93, 0x14, 0xb5, 0xd6, 0x2f, 0x42, 0xd3, 0x88, 0x43, 0x33, 0x4f, 0x63, 0xf9, 0x80, 0x3c, 0xc6,
	0xd5, 0x40, 0x0a, 0x9f, 0x37, 0x97, 0x40, 0xb8, 0x9a, 0x0b, 0x13, 0xcc, 0xfa, 0x3f, 0x93, 0xa5,
	0x29, 0x2c, 0xfd, 0x23, 0xfb, 0xb8, 0x31, 0xf0, 0x7a, 0x3c, 0x90, 0xdc, 0x6f, 0x56, 0x40, 0xb5,
	0x9e, 0xa9, 0x8e, 0x32, 0xd8, 0xda, 0xc8, 0x84, 0x45, 0x22, 0x2b, 0x46, 0xad, 0x5f, 0x4b, 0xb8,
	0x9e, 0xad, 0x8b, 0xbc, 0xc3, 0xdb, 0x9d, 0x73, 0xc9, 0x83, 0x63, 0x5f, 0x38, 0x3c, 0x08, 0x78,
	0xf7, 0x98, 0xfb, 0x27, 0xdc, 0x11, 0x5e, 0x17, 0x36, 0x52, 0xb1, 0x1e, 0xc4, 0xa1, 0x39, 0x2f,
	0x85, 0xcd, 0x23, 0x92, 0xb2, 0xee, 0xc0, 0xd3, 0x96, 0x5d, 0x9a, 0x94, 0x9d, 0x93, 0xc2, 0xe6,
	0x11, 0xe4, 0x08, 0x6f, 0x4a, 0x21, 0x6d, 0xd7, 0x2a, 0x4d, 0x0b, 0x3d, 0xa8, 0x58, 0xdb, 0x71,
	0x68, 0xea, 0x68, 0xa6, 0x03, 0x8b, 0x52, 0xaf, 0x4a, 0x53, 0x35, 0x97, 0x95, 0x52, 0x65, 0x9a,
	0xe9, 0x40, 0xb2, 0x8b, 0x1b, 0xfc, 0x13, 0x77, 0xde, 0x0e, 0x86, 0xbc, 0x59, 0xdd, 0x41, 0xbb,
	0xc8, 0x5a, 0x4d, 0x3a, 0x9f, 0x63, 0xac, 0x18, 0xb5, 0xbe, 0x2f, 0xe3, 0x2a, 0x1c, 0x2c, 0x79,
	0x81, 0xd7, 0xa0, 0xd4, 0x41, 0x7f, 0xec, 0x9d, 0x05, 0x8c, 0x9f, 0x66, 0xed, 0x26, 0x71, 0x68,
	0x2a, 0x0c, 0x53, 0x62, 0xf2, 0x06, 0x6f, 0x4d, 0x21, 0x87, 0xe2, 0xa3, 0xe7, 0x0a, 0xbb, 0xcb,
	0xf3, 0xd6, 0xde, 0x8b, 0x43, 0x53, 0x9f, 0xc0, 0xf4, 0x30, 0x79, 0x89, 0x89, 0x53, 0xc2, 0x60,
	0x2b, 0x15, 0xd8, 0xca, 0xdd, 0x38, 0x34, 0x35, 0x2c, 0xd3, 0x60, 0xc9, 0xa6, 0xfa, 0xdc, 0xee,
	0x42, 0x7d, 0x68, 0x77, 0xd6, 0x4e, 0xd8, 0x54, 0x99, 0x61, 0x4a, 0x5c, 0xd2, 0x42, 0x7f, 0xa1,
	0x95, 0xaa, 0x16, 0x18, 0xa6, 0xc4, 0xe4, 0x00, 0xdf, 0xe9, 0x72, 0x47, 0x0c, 0x47, 0x3e, 0x1c,
	0x48, 0x3a, 0x75, 0x0d, 0xe4, 0x5b, 0x71, 0x68, 0xce, 0x92, 0x6c, 0x16, 0x52, 0x8b, 0xa4, 0x6b,
	0xa8, 0xeb, 0x8b, 0xa4, 0xcb, 0x98, 0x85, 0xc8, 0x3e, 0x5e, 0x57, 0xd7, 0xd1, 0x80, 0x12, 0x9b,
	0x71, 0x68, 0xaa, 0x14, 0x53, 0x81, 0x44, 0x0e, 0x27, 0x74, 0x38, 0x1e, 0xb9, 0x03, 0xc7, 0x4e,
	0xe4, 0x2b, 0x13, 0xb9, 0x42, 0x31, 0x15, 0x68, 0xfd, 0x5e, 0xc6, 0x8d, 0xfc, 0x0b, 0x40, 0x9e,
	0xe1, 0x55, 0xe0, 0x19, 0xb7, 0x9d, 0x3e, 0x4f, 0xaf, 0x73, 0xd5, 0xda, 0x88, 0x43, 0xb3, 0x84,
	0xb3, 0x52, 0x94, 0x58, 0x61, 0xca, 0x23, 0xaf, 0x6d, 0x09, 0xda, 0xd4, 0x58, 0x60, 0x85, 0x59,
	0x96, 0x69, 0xb0, 0x62, 0x76, 0x0b, 0xe2, 0x20, 0xbb, 0xa2, 0x93, 0xd9, 0x33, 0x9c, 0x95, 0xa2,
	0xe2, 0x56, 0x40, 0x33, 0x4f, 0xb8, 0x27, 0xa7, 0x0d, 0x54, 0x66, 0x98, 0x12, 0x6b, 0xcc, 0x57,
	0x5d, 0xc0, 0x7c, 0xb5, 0xc5, 0xcc, 0x57, 0xff, 0x17, 0xe6, 0x6b, 0x2c, 0x6e, 0xbe, 0x95, 0xc5,
	0xcc, 0x87, 0xff, 0xde, 0x7c, 0x56, 0xe7, 0xf2, 0x9a, 0x1a, 0x57, 0xd7, 0xd4, 0xb8, 0xbd, 0xa6,
	0xe8, 0x73, 0x44, 0xd1, 0xd7, 0x88, 0xa2, 0x8b, 0x88, 0xa2, 0xcb, 0x88, 0xa2, 0x1f, 0x11, 0x45,
	0x3f, 0x23, 0x6a, 0xdc, 0x46, 0x14, 0x7d, 0xb9, 0xa1, 0xc6, 0xe5, 0x0d, 0x35, 0xae, 0x6e, 0xa8,
	0xf1, 0xfe, 0xe1, 0xf4, 0x93, 0xeb, 0xdb, 0xa7, 0xb6, 0x67, 0xb7, 0x5d, 0x71, 0x36, 0x68, 0xeb,
	0xde, 0xec, 0x4e, 0x0d, 0x1e, 0xde, 0xa7, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x4f, 0x1f, 0x09,
	0x6a, 0xd2, 0x07, 0x00, 0x00,
}

func (this *Result) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Result)
	if !ok {
		that2, ok := that.(Result)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Summary.Equal(&that1.Summary) {
		return false
	}
	if !this.Store.Equal(&that1.Store) {
		return false
	}
	if !this.Ingester.Equal(&that1.Ingester) {
		return false
	}
	return true
}
func (this *Summary) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Summary)
	if !ok {
		that2, ok := that.(Summary)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.BytesProcessedPerSecond != that1.BytesProcessedPerSecond {
		return false
	}
	if this.LinesProcessedPerSecond != that1.LinesProcessedPerSecond {
		return false
	}
	if this.TotalBytesProcessed != that1.TotalBytesProcessed {
		return false
	}
	if this.TotalLinesProcessed != that1.TotalLinesProcessed {
		return false
	}
	if this.ExecTime != that1.ExecTime {
		return false
	}
	return true
}
func (this *Store) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Store)
	if !ok {
		that2, ok := that.(Store)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TotalChunksRef != that1.TotalChunksRef {
		return false
	}
	if this.TotalChunksDownloaded != that1.TotalChunksDownloaded {
		return false
	}
	if this.ChunksDownloadTime != that1.ChunksDownloadTime {
		return false
	}
	if this.HeadChunkBytes != that1.HeadChunkBytes {
		return false
	}
	if this.HeadChunkLines != that1.HeadChunkLines {
		return false
	}
	if this.DecompressedBytes != that1.DecompressedBytes {
		return false
	}
	if this.DecompressedLines != that1.DecompressedLines {
		return false
	}
	if this.CompressedBytes != that1.CompressedBytes {
		return false
	}
	if this.TotalDuplicates != that1.TotalDuplicates {
		return false
	}
	return true
}
func (this *Ingester) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Ingester)
	if !ok {
		that2, ok := that.(Ingester)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TotalReached != that1.TotalReached {
		return false
	}
	if this.TotalChunksMatched != that1.TotalChunksMatched {
		return false
	}
	if this.TotalBatches != that1.TotalBatches {
		return false
	}
	if this.TotalLinesSent != that1.TotalLinesSent {
		return false
	}
	if this.HeadChunkBytes != that1.HeadChunkBytes {
		return false
	}
	if this.HeadChunkLines != that1.HeadChunkLines {
		return false
	}
	if this.DecompressedBytes != that1.DecompressedBytes {
		return false
	}
	if this.DecompressedLines != that1.DecompressedLines {
		return false
	}
	if this.CompressedBytes != that1.CompressedBytes {
		return false
	}
	if this.TotalDuplicates != that1.TotalDuplicates {
		return false
	}
	return true
}
func (this *Result) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&stats.Result{")
	s = append(s, "Summary: "+strings.Replace(this.Summary.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Store: "+strings.Replace(this.Store.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "Ingester: "+strings.Replace(this.Ingester.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Summary) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&stats.Summary{")
	s = append(s, "BytesProcessedPerSecond: "+fmt.Sprintf("%#v", this.BytesProcessedPerSecond)+",\n")
	s = append(s, "LinesProcessedPerSecond: "+fmt.Sprintf("%#v", this.LinesProcessedPerSecond)+",\n")
	s = append(s, "TotalBytesProcessed: "+fmt.Sprintf("%#v", this.TotalBytesProcessed)+",\n")
	s = append(s, "TotalLinesProcessed: "+fmt.Sprintf("%#v", this.TotalLinesProcessed)+",\n")
	s = append(s, "ExecTime: "+fmt.Sprintf("%#v", this.ExecTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Store) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&stats.Store{")
	s = append(s, "TotalChunksRef: "+fmt.Sprintf("%#v", this.TotalChunksRef)+",\n")
	s = append(s, "TotalChunksDownloaded: "+fmt.Sprintf("%#v", this.TotalChunksDownloaded)+",\n")
	s = append(s, "ChunksDownloadTime: "+fmt.Sprintf("%#v", this.ChunksDownloadTime)+",\n")
	s = append(s, "HeadChunkBytes: "+fmt.Sprintf("%#v", this.HeadChunkBytes)+",\n")
	s = append(s, "HeadChunkLines: "+fmt.Sprintf("%#v", this.HeadChunkLines)+",\n")
	s = append(s, "DecompressedBytes: "+fmt.Sprintf("%#v", this.DecompressedBytes)+",\n")
	s = append(s, "DecompressedLines: "+fmt.Sprintf("%#v", this.DecompressedLines)+",\n")
	s = append(s, "CompressedBytes: "+fmt.Sprintf("%#v", this.CompressedBytes)+",\n")
	s = append(s, "TotalDuplicates: "+fmt.Sprintf("%#v", this.TotalDuplicates)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Ingester) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&stats.Ingester{")
	s = append(s, "TotalReached: "+fmt.Sprintf("%#v", this.TotalReached)+",\n")
	s = append(s, "TotalChunksMatched: "+fmt.Sprintf("%#v", this.TotalChunksMatched)+",\n")
	s = append(s, "TotalBatches: "+fmt.Sprintf("%#v", this.TotalBatches)+",\n")
	s = append(s, "TotalLinesSent: "+fmt.Sprintf("%#v", this.TotalLinesSent)+",\n")
	s = append(s, "HeadChunkBytes: "+fmt.Sprintf("%#v", this.HeadChunkBytes)+",\n")
	s = append(s, "HeadChunkLines: "+fmt.Sprintf("%#v", this.HeadChunkLines)+",\n")
	s = append(s, "DecompressedBytes: "+fmt.Sprintf("%#v", this.DecompressedBytes)+",\n")
	s = append(s, "DecompressedLines: "+fmt.Sprintf("%#v", this.DecompressedLines)+",\n")
	s = append(s, "CompressedBytes: "+fmt.Sprintf("%#v", this.CompressedBytes)+",\n")
	s = append(s, "TotalDuplicates: "+fmt.Sprintf("%#v", this.TotalDuplicates)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringStats(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Result) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStats(dAtA, i, uint64(m.Summary.Size()))
	n1, err := m.Summary.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintStats(dAtA, i, uint64(m.Store.Size()))
	n2, err := m.Store.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStats(dAtA, i, uint64(m.Ingester.Size()))
	n3, err := m.Ingester.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *Summary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Summary) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.BytesProcessedPerSecond != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.BytesProcessedPerSecond))
	}
	if m.LinesProcessedPerSecond != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.LinesProcessedPerSecond))
	}
	if m.TotalBytesProcessed != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalBytesProcessed))
	}
	if m.TotalLinesProcessed != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalLinesProcessed))
	}
	if m.ExecTime != 0 {
		dAtA[i] = 0x29
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.ExecTime))))
		i += 8
	}
	return i, nil
}

func (m *Store) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Store) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TotalChunksRef != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalChunksRef))
	}
	if m.TotalChunksDownloaded != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalChunksDownloaded))
	}
	if m.ChunksDownloadTime != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.ChunksDownloadTime))))
		i += 8
	}
	if m.HeadChunkBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.HeadChunkBytes))
	}
	if m.HeadChunkLines != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.HeadChunkLines))
	}
	if m.DecompressedBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.DecompressedBytes))
	}
	if m.DecompressedLines != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.DecompressedLines))
	}
	if m.CompressedBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.CompressedBytes))
	}
	if m.TotalDuplicates != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalDuplicates))
	}
	return i, nil
}

func (m *Ingester) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Ingester) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TotalReached != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalReached))
	}
	if m.TotalChunksMatched != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalChunksMatched))
	}
	if m.TotalBatches != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalBatches))
	}
	if m.TotalLinesSent != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalLinesSent))
	}
	if m.HeadChunkBytes != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.HeadChunkBytes))
	}
	if m.HeadChunkLines != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.HeadChunkLines))
	}
	if m.DecompressedBytes != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.DecompressedBytes))
	}
	if m.DecompressedLines != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.DecompressedLines))
	}
	if m.CompressedBytes != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.CompressedBytes))
	}
	if m.TotalDuplicates != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.TotalDuplicates))
	}
	return i, nil
}

func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Result) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Summary.Size()
	n += 1 + l + sovStats(uint64(l))
	l = m.Store.Size()
	n += 1 + l + sovStats(uint64(l))
	l = m.Ingester.Size()
	n += 1 + l + sovStats(uint64(l))
	return n
}

func (m *Summary) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.BytesProcessedPerSecond != 0 {
		n += 1 + sovStats(uint64(m.BytesProcessedPerSecond))
	}
	if m.LinesProcessedPerSecond != 0 {
		n += 1 + sovStats(uint64(m.LinesProcessedPerSecond))
	}
	if m.TotalBytesProcessed != 0 {
		n += 1 + sovStats(uint64(m.TotalBytesProcessed))
	}
	if m.TotalLinesProcessed != 0 {
		n += 1 + sovStats(uint64(m.TotalLinesProcessed))
	}
	if m.ExecTime != 0 {
		n += 9
	}
	return n
}

func (m *Store) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalChunksRef != 0 {
		n += 1 + sovStats(uint64(m.TotalChunksRef))
	}
	if m.TotalChunksDownloaded != 0 {
		n += 1 + sovStats(uint64(m.TotalChunksDownloaded))
	}
	if m.ChunksDownloadTime != 0 {
		n += 9
	}
	if m.HeadChunkBytes != 0 {
		n += 1 + sovStats(uint64(m.HeadChunkBytes))
	}
	if m.HeadChunkLines != 0 {
		n += 1 + sovStats(uint64(m.HeadChunkLines))
	}
	if m.DecompressedBytes != 0 {
		n += 1 + sovStats(uint64(m.DecompressedBytes))
	}
	if m.DecompressedLines != 0 {
		n += 1 + sovStats(uint64(m.DecompressedLines))
	}
	if m.CompressedBytes != 0 {
		n += 1 + sovStats(uint64(m.CompressedBytes))
	}
	if m.TotalDuplicates != 0 {
		n += 1 + sovStats(uint64(m.TotalDuplicates))
	}
	return n
}

func (m *Ingester) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalReached != 0 {
		n += 1 + sovStats(uint64(m.TotalReached))
	}
	if m.TotalChunksMatched != 0 {
		n += 1 + sovStats(uint64(m.TotalChunksMatched))
	}
	if m.TotalBatches != 0 {
		n += 1 + sovStats(uint64(m.TotalBatches))
	}
	if m.TotalLinesSent != 0 {
		n += 1 + sovStats(uint64(m.TotalLinesSent))
	}
	if m.HeadChunkBytes != 0 {
		n += 1 + sovStats(uint64(m.HeadChunkBytes))
	}
	if m.HeadChunkLines != 0 {
		n += 1 + sovStats(uint64(m.HeadChunkLines))
	}
	if m.DecompressedBytes != 0 {
		n += 1 + sovStats(uint64(m.DecompressedBytes))
	}
	if m.DecompressedLines != 0 {
		n += 1 + sovStats(uint64(m.DecompressedLines))
	}
	if m.CompressedBytes != 0 {
		n += 1 + sovStats(uint64(m.CompressedBytes))
	}
	if m.TotalDuplicates != 0 {
		n += 1 + sovStats(uint64(m.TotalDuplicates))
	}
	return n
}

func sovStats(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Result) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Result{`,
		`Summary:` + strings.Replace(strings.Replace(this.Summary.String(), "Summary", "Summary", 1), `&`, ``, 1) + `,`,
		`Store:` + strings.Replace(strings.Replace(this.Store.String(), "Store", "Store", 1), `&`, ``, 1) + `,`,
		`Ingester:` + strings.Replace(strings.Replace(this.Ingester.String(), "Ingester", "Ingester", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Summary) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Summary{`,
		`BytesProcessedPerSecond:` + fmt.Sprintf("%v", this.BytesProcessedPerSecond) + `,`,
		`LinesProcessedPerSecond:` + fmt.Sprintf("%v", this.LinesProcessedPerSecond) + `,`,
		`TotalBytesProcessed:` + fmt.Sprintf("%v", this.TotalBytesProcessed) + `,`,
		`TotalLinesProcessed:` + fmt.Sprintf("%v", this.TotalLinesProcessed) + `,`,
		`ExecTime:` + fmt.Sprintf("%v", this.ExecTime) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Store) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Store{`,
		`TotalChunksRef:` + fmt.Sprintf("%v", this.TotalChunksRef) + `,`,
		`TotalChunksDownloaded:` + fmt.Sprintf("%v", this.TotalChunksDownloaded) + `,`,
		`ChunksDownloadTime:` + fmt.Sprintf("%v", this.ChunksDownloadTime) + `,`,
		`HeadChunkBytes:` + fmt.Sprintf("%v", this.HeadChunkBytes) + `,`,
		`HeadChunkLines:` + fmt.Sprintf("%v", this.HeadChunkLines) + `,`,
		`DecompressedBytes:` + fmt.Sprintf("%v", this.DecompressedBytes) + `,`,
		`DecompressedLines:` + fmt.Sprintf("%v", this.DecompressedLines) + `,`,
		`CompressedBytes:` + fmt.Sprintf("%v", this.CompressedBytes) + `,`,
		`TotalDuplicates:` + fmt.Sprintf("%v", this.TotalDuplicates) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Ingester) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Ingester{`,
		`TotalReached:` + fmt.Sprintf("%v", this.TotalReached) + `,`,
		`TotalChunksMatched:` + fmt.Sprintf("%v", this.TotalChunksMatched) + `,`,
		`TotalBatches:` + fmt.Sprintf("%v", this.TotalBatches) + `,`,
		`TotalLinesSent:` + fmt.Sprintf("%v", this.TotalLinesSent) + `,`,
		`HeadChunkBytes:` + fmt.Sprintf("%v", this.HeadChunkBytes) + `,`,
		`HeadChunkLines:` + fmt.Sprintf("%v", this.HeadChunkLines) + `,`,
		`DecompressedBytes:` + fmt.Sprintf("%v", this.DecompressedBytes) + `,`,
		`DecompressedLines:` + fmt.Sprintf("%v", this.DecompressedLines) + `,`,
		`CompressedBytes:` + fmt.Sprintf("%v", this.CompressedBytes) + `,`,
		`TotalDuplicates:` + fmt.Sprintf("%v", this.TotalDuplicates) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringStats(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Summary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Summary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Store", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Store.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ingester", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthStats
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Ingester.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Summary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Summary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Summary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesProcessedPerSecond", wireType)
			}
			m.BytesProcessedPerSecond = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesProcessedPerSecond |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinesProcessedPerSecond", wireType)
			}
			m.LinesProcessedPerSecond = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LinesProcessedPerSecond |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytesProcessed", wireType)
			}
			m.TotalBytesProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytesProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalLinesProcessed", wireType)
			}
			m.TotalLinesProcessed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalLinesProcessed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecTime", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.ExecTime = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Store) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Store: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Store: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalChunksRef", wireType)
			}
			m.TotalChunksRef = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalChunksRef |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalChunksDownloaded", wireType)
			}
			m.TotalChunksDownloaded = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalChunksDownloaded |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChunksDownloadTime", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.ChunksDownloadTime = float64(math.Float64frombits(v))
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeadChunkBytes", wireType)
			}
			m.HeadChunkBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeadChunkBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeadChunkLines", wireType)
			}
			m.HeadChunkLines = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeadChunkLines |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecompressedBytes", wireType)
			}
			m.DecompressedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DecompressedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecompressedLines", wireType)
			}
			m.DecompressedLines = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DecompressedLines |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressedBytes", wireType)
			}
			m.CompressedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDuplicates", wireType)
			}
			m.TotalDuplicates = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalDuplicates |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Ingester) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ingester: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ingester: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalReached", wireType)
			}
			m.TotalReached = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalReached |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalChunksMatched", wireType)
			}
			m.TotalChunksMatched = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalChunksMatched |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBatches", wireType)
			}
			m.TotalBatches = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBatches |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalLinesSent", wireType)
			}
			m.TotalLinesSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalLinesSent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeadChunkBytes", wireType)
			}
			m.HeadChunkBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeadChunkBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeadChunkLines", wireType)
			}
			m.HeadChunkLines = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HeadChunkLines |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecompressedBytes", wireType)
			}
			m.DecompressedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DecompressedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DecompressedLines", wireType)
			}
			m.DecompressedLines = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DecompressedLines |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressedBytes", wireType)
			}
			m.CompressedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalDuplicates", wireType)
			}
			m.TotalDuplicates = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalDuplicates |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthStats
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)
