// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package appengine

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	"github.com/golang/protobuf/proto"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	appenginepb "google.golang.org/genproto/googleapis/appengine/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
)

var newDomainMappingsClientHook clientHook

// DomainMappingsCallOptions contains the retry settings for each method of DomainMappingsClient.
type DomainMappingsCallOptions struct {
	ListDomainMappings  []gax.CallOption
	GetDomainMapping    []gax.CallOption
	CreateDomainMapping []gax.CallOption
	UpdateDomainMapping []gax.CallOption
	DeleteDomainMapping []gax.CallOption
}

func defaultDomainMappingsGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("appengine.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("appengine.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://appengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		option.WithGRPCDialOption(grpc.WithDisableServiceConfig()),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultDomainMappingsCallOptions() *DomainMappingsCallOptions {
	return &DomainMappingsCallOptions{
		ListDomainMappings:  []gax.CallOption{},
		GetDomainMapping:    []gax.CallOption{},
		CreateDomainMapping: []gax.CallOption{},
		UpdateDomainMapping: []gax.CallOption{},
		DeleteDomainMapping: []gax.CallOption{},
	}
}

// internalDomainMappingsClient is an interface that defines the methods availaible from App Engine Admin API.
type internalDomainMappingsClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListDomainMappings(context.Context, *appenginepb.ListDomainMappingsRequest, ...gax.CallOption) *DomainMappingIterator
	GetDomainMapping(context.Context, *appenginepb.GetDomainMappingRequest, ...gax.CallOption) (*appenginepb.DomainMapping, error)
	CreateDomainMapping(context.Context, *appenginepb.CreateDomainMappingRequest, ...gax.CallOption) (*CreateDomainMappingOperation, error)
	CreateDomainMappingOperation(name string) *CreateDomainMappingOperation
	UpdateDomainMapping(context.Context, *appenginepb.UpdateDomainMappingRequest, ...gax.CallOption) (*UpdateDomainMappingOperation, error)
	UpdateDomainMappingOperation(name string) *UpdateDomainMappingOperation
	DeleteDomainMapping(context.Context, *appenginepb.DeleteDomainMappingRequest, ...gax.CallOption) (*DeleteDomainMappingOperation, error)
	DeleteDomainMappingOperation(name string) *DeleteDomainMappingOperation
}

// DomainMappingsClient is a client for interacting with App Engine Admin API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Manages domains serving an application.
type DomainMappingsClient struct {
	// The internal transport-dependent client.
	internalClient internalDomainMappingsClient

	// The call options for this service.
	CallOptions *DomainMappingsCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *DomainMappingsClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *DomainMappingsClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *DomainMappingsClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListDomainMappings lists the domain mappings on an application.
func (c *DomainMappingsClient) ListDomainMappings(ctx context.Context, req *appenginepb.ListDomainMappingsRequest, opts ...gax.CallOption) *DomainMappingIterator {
	return c.internalClient.ListDomainMappings(ctx, req, opts...)
}

// GetDomainMapping gets the specified domain mapping.
func (c *DomainMappingsClient) GetDomainMapping(ctx context.Context, req *appenginepb.GetDomainMappingRequest, opts ...gax.CallOption) (*appenginepb.DomainMapping, error) {
	return c.internalClient.GetDomainMapping(ctx, req, opts...)
}

// CreateDomainMapping maps a domain to an application. A user must be authorized to administer a
// domain in order to map it to an application. For a list of available
// authorized domains, see AuthorizedDomains.ListAuthorizedDomains (at ).
func (c *DomainMappingsClient) CreateDomainMapping(ctx context.Context, req *appenginepb.CreateDomainMappingRequest, opts ...gax.CallOption) (*CreateDomainMappingOperation, error) {
	return c.internalClient.CreateDomainMapping(ctx, req, opts...)
}

// CreateDomainMappingOperation returns a new CreateDomainMappingOperation from a given name.
// The name must be that of a previously created CreateDomainMappingOperation, possibly from a different process.
func (c *DomainMappingsClient) CreateDomainMappingOperation(name string) *CreateDomainMappingOperation {
	return c.internalClient.CreateDomainMappingOperation(name)
}

// UpdateDomainMapping updates the specified domain mapping. To map an SSL certificate to a
// domain mapping, update certificate_id to point to an AuthorizedCertificate
// resource. A user must be authorized to administer the associated domain
// in order to update a DomainMapping resource.
func (c *DomainMappingsClient) UpdateDomainMapping(ctx context.Context, req *appenginepb.UpdateDomainMappingRequest, opts ...gax.CallOption) (*UpdateDomainMappingOperation, error) {
	return c.internalClient.UpdateDomainMapping(ctx, req, opts...)
}

// UpdateDomainMappingOperation returns a new UpdateDomainMappingOperation from a given name.
// The name must be that of a previously created UpdateDomainMappingOperation, possibly from a different process.
func (c *DomainMappingsClient) UpdateDomainMappingOperation(name string) *UpdateDomainMappingOperation {
	return c.internalClient.UpdateDomainMappingOperation(name)
}

// DeleteDomainMapping deletes the specified domain mapping. A user must be authorized to
// administer the associated domain in order to delete a DomainMapping
// resource.
func (c *DomainMappingsClient) DeleteDomainMapping(ctx context.Context, req *appenginepb.DeleteDomainMappingRequest, opts ...gax.CallOption) (*DeleteDomainMappingOperation, error) {
	return c.internalClient.DeleteDomainMapping(ctx, req, opts...)
}

// DeleteDomainMappingOperation returns a new DeleteDomainMappingOperation from a given name.
// The name must be that of a previously created DeleteDomainMappingOperation, possibly from a different process.
func (c *DomainMappingsClient) DeleteDomainMappingOperation(name string) *DeleteDomainMappingOperation {
	return c.internalClient.DeleteDomainMappingOperation(name)
}

// domainMappingsGRPCClient is a client for interacting with App Engine Admin API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type domainMappingsGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing DomainMappingsClient
	CallOptions **DomainMappingsCallOptions

	// The gRPC API client.
	domainMappingsClient appenginepb.DomainMappingsClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewDomainMappingsClient creates a new domain mappings client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Manages domains serving an application.
func NewDomainMappingsClient(ctx context.Context, opts ...option.ClientOption) (*DomainMappingsClient, error) {
	clientOpts := defaultDomainMappingsGRPCClientOptions()
	if newDomainMappingsClientHook != nil {
		hookOpts, err := newDomainMappingsClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := DomainMappingsClient{CallOptions: defaultDomainMappingsCallOptions()}

	c := &domainMappingsGRPCClient{
		connPool:             connPool,
		disableDeadlines:     disableDeadlines,
		domainMappingsClient: appenginepb.NewDomainMappingsClient(connPool),
		CallOptions:          &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *domainMappingsGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *domainMappingsGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", versionClient, "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *domainMappingsGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *domainMappingsGRPCClient) ListDomainMappings(ctx context.Context, req *appenginepb.ListDomainMappingsRequest, opts ...gax.CallOption) *DomainMappingIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListDomainMappings[0:len((*c.CallOptions).ListDomainMappings):len((*c.CallOptions).ListDomainMappings)], opts...)
	it := &DomainMappingIterator{}
	req = proto.Clone(req).(*appenginepb.ListDomainMappingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*appenginepb.DomainMapping, string, error) {
		var resp *appenginepb.ListDomainMappingsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.domainMappingsClient.ListDomainMappings(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDomainMappings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

func (c *domainMappingsGRPCClient) GetDomainMapping(ctx context.Context, req *appenginepb.GetDomainMappingRequest, opts ...gax.CallOption) (*appenginepb.DomainMapping, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetDomainMapping[0:len((*c.CallOptions).GetDomainMapping):len((*c.CallOptions).GetDomainMapping)], opts...)
	var resp *appenginepb.DomainMapping
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.domainMappingsClient.GetDomainMapping(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *domainMappingsGRPCClient) CreateDomainMapping(ctx context.Context, req *appenginepb.CreateDomainMappingRequest, opts ...gax.CallOption) (*CreateDomainMappingOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateDomainMapping[0:len((*c.CallOptions).CreateDomainMapping):len((*c.CallOptions).CreateDomainMapping)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.domainMappingsClient.CreateDomainMapping(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDomainMappingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *domainMappingsGRPCClient) UpdateDomainMapping(ctx context.Context, req *appenginepb.UpdateDomainMappingRequest, opts ...gax.CallOption) (*UpdateDomainMappingOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateDomainMapping[0:len((*c.CallOptions).UpdateDomainMapping):len((*c.CallOptions).UpdateDomainMapping)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.domainMappingsClient.UpdateDomainMapping(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateDomainMappingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *domainMappingsGRPCClient) DeleteDomainMapping(ctx context.Context, req *appenginepb.DeleteDomainMappingRequest, opts ...gax.CallOption) (*DeleteDomainMappingOperation, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteDomainMapping[0:len((*c.CallOptions).DeleteDomainMapping):len((*c.CallOptions).DeleteDomainMapping)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.domainMappingsClient.DeleteDomainMapping(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDomainMappingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

// CreateDomainMappingOperation manages a long-running operation from CreateDomainMapping.
type CreateDomainMappingOperation struct {
	lro *longrunning.Operation
}

// CreateDomainMappingOperation returns a new CreateDomainMappingOperation from a given name.
// The name must be that of a previously created CreateDomainMappingOperation, possibly from a different process.
func (c *domainMappingsGRPCClient) CreateDomainMappingOperation(name string) *CreateDomainMappingOperation {
	return &CreateDomainMappingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateDomainMappingOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*appenginepb.DomainMapping, error) {
	var resp appenginepb.DomainMapping
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateDomainMappingOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*appenginepb.DomainMapping, error) {
	var resp appenginepb.DomainMapping
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateDomainMappingOperation) Metadata() (*appenginepb.OperationMetadataV1, error) {
	var meta appenginepb.OperationMetadataV1
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateDomainMappingOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateDomainMappingOperation) Name() string {
	return op.lro.Name()
}

// DeleteDomainMappingOperation manages a long-running operation from DeleteDomainMapping.
type DeleteDomainMappingOperation struct {
	lro *longrunning.Operation
}

// DeleteDomainMappingOperation returns a new DeleteDomainMappingOperation from a given name.
// The name must be that of a previously created DeleteDomainMappingOperation, possibly from a different process.
func (c *domainMappingsGRPCClient) DeleteDomainMappingOperation(name string) *DeleteDomainMappingOperation {
	return &DeleteDomainMappingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteDomainMappingOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteDomainMappingOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteDomainMappingOperation) Metadata() (*appenginepb.OperationMetadataV1, error) {
	var meta appenginepb.OperationMetadataV1
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteDomainMappingOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteDomainMappingOperation) Name() string {
	return op.lro.Name()
}

// UpdateDomainMappingOperation manages a long-running operation from UpdateDomainMapping.
type UpdateDomainMappingOperation struct {
	lro *longrunning.Operation
}

// UpdateDomainMappingOperation returns a new UpdateDomainMappingOperation from a given name.
// The name must be that of a previously created UpdateDomainMappingOperation, possibly from a different process.
func (c *domainMappingsGRPCClient) UpdateDomainMappingOperation(name string) *UpdateDomainMappingOperation {
	return &UpdateDomainMappingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateDomainMappingOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*appenginepb.DomainMapping, error) {
	var resp appenginepb.DomainMapping
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateDomainMappingOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*appenginepb.DomainMapping, error) {
	var resp appenginepb.DomainMapping
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateDomainMappingOperation) Metadata() (*appenginepb.OperationMetadataV1, error) {
	var meta appenginepb.OperationMetadataV1
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateDomainMappingOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateDomainMappingOperation) Name() string {
	return op.lro.Name()
}

// DomainMappingIterator manages a stream of *appenginepb.DomainMapping.
type DomainMappingIterator struct {
	items    []*appenginepb.DomainMapping
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*appenginepb.DomainMapping, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *DomainMappingIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *DomainMappingIterator) Next() (*appenginepb.DomainMapping, error) {
	var item *appenginepb.DomainMapping
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *DomainMappingIterator) bufLen() int {
	return len(it.items)
}

func (it *DomainMappingIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
