package peering

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ConnectionState enumerates the values for connection state.
type ConnectionState string

const (
	// Active ...
	Active ConnectionState = "Active"
	// Approved ...
	Approved ConnectionState = "Approved"
	// None ...
	None ConnectionState = "None"
	// PendingApproval ...
	PendingApproval ConnectionState = "PendingApproval"
	// ProvisioningCompleted ...
	ProvisioningCompleted ConnectionState = "ProvisioningCompleted"
	// ProvisioningFailed ...
	ProvisioningFailed ConnectionState = "ProvisioningFailed"
	// ProvisioningStarted ...
	ProvisioningStarted ConnectionState = "ProvisioningStarted"
	// Validating ...
	Validating ConnectionState = "Validating"
)

// PossibleConnectionStateValues returns an array of possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{Active, Approved, None, PendingApproval, ProvisioningCompleted, ProvisioningFailed, ProvisioningStarted, Validating}
}

// DirectPeeringType enumerates the values for direct peering type.
type DirectPeeringType string

const (
	// Cdn ...
	Cdn DirectPeeringType = "Cdn"
	// Edge ...
	Edge DirectPeeringType = "Edge"
	// Internal ...
	Internal DirectPeeringType = "Internal"
	// Transit ...
	Transit DirectPeeringType = "Transit"
)

// PossibleDirectPeeringTypeValues returns an array of possible values for the DirectPeeringType const type.
func PossibleDirectPeeringTypeValues() []DirectPeeringType {
	return []DirectPeeringType{Cdn, Edge, Internal, Transit}
}

// Family enumerates the values for family.
type Family string

const (
	// Direct ...
	Direct Family = "Direct"
	// Exchange ...
	Exchange Family = "Exchange"
)

// PossibleFamilyValues returns an array of possible values for the Family const type.
func PossibleFamilyValues() []Family {
	return []Family{Direct, Exchange}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindDirect ...
	KindDirect Kind = "Direct"
	// KindExchange ...
	KindExchange Kind = "Exchange"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindDirect, KindExchange}
}

// LearnedType enumerates the values for learned type.
type LearnedType string

const (
	// LearnedTypeNone ...
	LearnedTypeNone LearnedType = "None"
	// LearnedTypeViaServiceProvider ...
	LearnedTypeViaServiceProvider LearnedType = "ViaServiceProvider"
	// LearnedTypeViaSession ...
	LearnedTypeViaSession LearnedType = "ViaSession"
)

// PossibleLearnedTypeValues returns an array of possible values for the LearnedType const type.
func PossibleLearnedTypeValues() []LearnedType {
	return []LearnedType{LearnedTypeNone, LearnedTypeViaServiceProvider, LearnedTypeViaSession}
}

// Name enumerates the values for name.
type Name string

const (
	// BasicDirectFree ...
	BasicDirectFree Name = "Basic_Direct_Free"
	// BasicExchangeFree ...
	BasicExchangeFree Name = "Basic_Exchange_Free"
	// PremiumDirectFree ...
	PremiumDirectFree Name = "Premium_Direct_Free"
	// PremiumDirectMetered ...
	PremiumDirectMetered Name = "Premium_Direct_Metered"
	// PremiumDirectUnlimited ...
	PremiumDirectUnlimited Name = "Premium_Direct_Unlimited"
	// PremiumExchangeMetered ...
	PremiumExchangeMetered Name = "Premium_Exchange_Metered"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{BasicDirectFree, BasicExchangeFree, PremiumDirectFree, PremiumDirectMetered, PremiumDirectUnlimited, PremiumExchangeMetered}
}

// PrefixValidationState enumerates the values for prefix validation state.
type PrefixValidationState string

const (
	// PrefixValidationStateFailed ...
	PrefixValidationStateFailed PrefixValidationState = "Failed"
	// PrefixValidationStateInvalid ...
	PrefixValidationStateInvalid PrefixValidationState = "Invalid"
	// PrefixValidationStateNone ...
	PrefixValidationStateNone PrefixValidationState = "None"
	// PrefixValidationStatePending ...
	PrefixValidationStatePending PrefixValidationState = "Pending"
	// PrefixValidationStateUnknown ...
	PrefixValidationStateUnknown PrefixValidationState = "Unknown"
	// PrefixValidationStateVerified ...
	PrefixValidationStateVerified PrefixValidationState = "Verified"
	// PrefixValidationStateWarning ...
	PrefixValidationStateWarning PrefixValidationState = "Warning"
)

// PossiblePrefixValidationStateValues returns an array of possible values for the PrefixValidationState const type.
func PossiblePrefixValidationStateValues() []PrefixValidationState {
	return []PrefixValidationState{PrefixValidationStateFailed, PrefixValidationStateInvalid, PrefixValidationStateNone, PrefixValidationStatePending, PrefixValidationStateUnknown, PrefixValidationStateVerified, PrefixValidationStateWarning}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Deleting, Failed, Succeeded, Updating}
}

// SessionAddressProvider enumerates the values for session address provider.
type SessionAddressProvider string

const (
	// Microsoft ...
	Microsoft SessionAddressProvider = "Microsoft"
	// Peer ...
	Peer SessionAddressProvider = "Peer"
)

// PossibleSessionAddressProviderValues returns an array of possible values for the SessionAddressProvider const type.
func PossibleSessionAddressProviderValues() []SessionAddressProvider {
	return []SessionAddressProvider{Microsoft, Peer}
}

// SessionStateV4 enumerates the values for session state v4.
type SessionStateV4 string

const (
	// SessionStateV4Active ...
	SessionStateV4Active SessionStateV4 = "Active"
	// SessionStateV4Connect ...
	SessionStateV4Connect SessionStateV4 = "Connect"
	// SessionStateV4Established ...
	SessionStateV4Established SessionStateV4 = "Established"
	// SessionStateV4Idle ...
	SessionStateV4Idle SessionStateV4 = "Idle"
	// SessionStateV4None ...
	SessionStateV4None SessionStateV4 = "None"
	// SessionStateV4OpenConfirm ...
	SessionStateV4OpenConfirm SessionStateV4 = "OpenConfirm"
	// SessionStateV4OpenReceived ...
	SessionStateV4OpenReceived SessionStateV4 = "OpenReceived"
	// SessionStateV4OpenSent ...
	SessionStateV4OpenSent SessionStateV4 = "OpenSent"
	// SessionStateV4PendingAdd ...
	SessionStateV4PendingAdd SessionStateV4 = "PendingAdd"
	// SessionStateV4PendingRemove ...
	SessionStateV4PendingRemove SessionStateV4 = "PendingRemove"
	// SessionStateV4PendingUpdate ...
	SessionStateV4PendingUpdate SessionStateV4 = "PendingUpdate"
)

// PossibleSessionStateV4Values returns an array of possible values for the SessionStateV4 const type.
func PossibleSessionStateV4Values() []SessionStateV4 {
	return []SessionStateV4{SessionStateV4Active, SessionStateV4Connect, SessionStateV4Established, SessionStateV4Idle, SessionStateV4None, SessionStateV4OpenConfirm, SessionStateV4OpenReceived, SessionStateV4OpenSent, SessionStateV4PendingAdd, SessionStateV4PendingRemove, SessionStateV4PendingUpdate}
}

// SessionStateV6 enumerates the values for session state v6.
type SessionStateV6 string

const (
	// SessionStateV6Active ...
	SessionStateV6Active SessionStateV6 = "Active"
	// SessionStateV6Connect ...
	SessionStateV6Connect SessionStateV6 = "Connect"
	// SessionStateV6Established ...
	SessionStateV6Established SessionStateV6 = "Established"
	// SessionStateV6Idle ...
	SessionStateV6Idle SessionStateV6 = "Idle"
	// SessionStateV6None ...
	SessionStateV6None SessionStateV6 = "None"
	// SessionStateV6OpenConfirm ...
	SessionStateV6OpenConfirm SessionStateV6 = "OpenConfirm"
	// SessionStateV6OpenReceived ...
	SessionStateV6OpenReceived SessionStateV6 = "OpenReceived"
	// SessionStateV6OpenSent ...
	SessionStateV6OpenSent SessionStateV6 = "OpenSent"
	// SessionStateV6PendingAdd ...
	SessionStateV6PendingAdd SessionStateV6 = "PendingAdd"
	// SessionStateV6PendingRemove ...
	SessionStateV6PendingRemove SessionStateV6 = "PendingRemove"
	// SessionStateV6PendingUpdate ...
	SessionStateV6PendingUpdate SessionStateV6 = "PendingUpdate"
)

// PossibleSessionStateV6Values returns an array of possible values for the SessionStateV6 const type.
func PossibleSessionStateV6Values() []SessionStateV6 {
	return []SessionStateV6{SessionStateV6Active, SessionStateV6Connect, SessionStateV6Established, SessionStateV6Idle, SessionStateV6None, SessionStateV6OpenConfirm, SessionStateV6OpenReceived, SessionStateV6OpenSent, SessionStateV6PendingAdd, SessionStateV6PendingRemove, SessionStateV6PendingUpdate}
}

// Size enumerates the values for size.
type Size string

const (
	// Free ...
	Free Size = "Free"
	// Metered ...
	Metered Size = "Metered"
	// Unlimited ...
	Unlimited Size = "Unlimited"
)

// PossibleSizeValues returns an array of possible values for the Size const type.
func PossibleSizeValues() []Size {
	return []Size{Free, Metered, Unlimited}
}

// Tier enumerates the values for tier.
type Tier string

const (
	// Basic ...
	Basic Tier = "Basic"
	// Premium ...
	Premium Tier = "Premium"
)

// PossibleTierValues returns an array of possible values for the Tier const type.
func PossibleTierValues() []Tier {
	return []Tier{Basic, Premium}
}

// ValidationState enumerates the values for validation state.
type ValidationState string

const (
	// ValidationStateApproved ...
	ValidationStateApproved ValidationState = "Approved"
	// ValidationStateFailed ...
	ValidationStateFailed ValidationState = "Failed"
	// ValidationStateNone ...
	ValidationStateNone ValidationState = "None"
	// ValidationStatePending ...
	ValidationStatePending ValidationState = "Pending"
)

// PossibleValidationStateValues returns an array of possible values for the ValidationState const type.
func PossibleValidationStateValues() []ValidationState {
	return []ValidationState{ValidationStateApproved, ValidationStateFailed, ValidationStateNone, ValidationStatePending}
}
