// DO NOT EDIT: This file is autogenerated via the builtin command.

package statsmodels

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   44,
				},
				File:   "linearreg.flux",
				Source: "package statsmodels\n\nimport \"math\"\nimport \"generate\"\n\n// performs linear regression, calculates y_hat, and residuals squared (rse) \n\nlinearRegression = (tables=<-) => {\n  renameAndSum = tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))\n    |> cumulativeSum(columns: [\"x\"])\n\n  t = renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)\n    |> getRecord(idx: 0)\n\n  xbar = t.sx/t.N \n\n  ybar = t.sy/t.N\n\n  slope = (t.sxy - xbar*ybar*t.N)/(t.sxx - t.N*xbar*xbar)\n\n  intercept = (ybar - slope * xbar)\n\n  y_hat = (r) => ({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})\n\n  rse = (r) => ({r with errors: (r.y - r.y_hat)^2.0})\n\n  output = renameAndSum\n    |> map(fn: y_hat)\n    |> map(fn: rse)\n    \n  return output\n}",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "linearreg.flux",
					Source: "linearRegression = (tables=<-) => {\n  renameAndSum = tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))\n    |> cumulativeSum(columns: [\"x\"])\n\n  t = renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)\n    |> getRecord(idx: 0)\n\n  xbar = t.sx/t.N \n\n  ybar = t.sy/t.N\n\n  slope = (t.sxy - xbar*ybar*t.N)/(t.sxx - t.N*xbar*xbar)\n\n  intercept = (ybar - slope * xbar)\n\n  y_hat = (r) => ({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})\n\n  rse = (r) => ({r with errors: (r.y - r.y_hat)^2.0})\n\n  output = renameAndSum\n    |> map(fn: y_hat)\n    |> map(fn: rse)\n    \n  return output\n}",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// performs linear regression, calculates y_hat, and residuals squared (rse) \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   8,
						},
						File:   "linearreg.flux",
						Source: "linearRegression",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "linearRegression",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "linearreg.flux",
						Source: "(tables=<-) => {\n  renameAndSum = tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))\n    |> cumulativeSum(columns: [\"x\"])\n\n  t = renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)\n    |> getRecord(idx: 0)\n\n  xbar = t.sx/t.N \n\n  ybar = t.sy/t.N\n\n  slope = (t.sxy - xbar*ybar*t.N)/(t.sxx - t.N*xbar*xbar)\n\n  intercept = (ybar - slope * xbar)\n\n  y_hat = (r) => ({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})\n\n  rse = (r) => ({r with errors: (r.y - r.y_hat)^2.0})\n\n  output = renameAndSum\n    |> map(fn: y_hat)\n    |> map(fn: rse)\n    \n  return output\n}",
						Start: ast.Position{
							Column: 20,
							Line:   8,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   44,
							},
							File:   "linearreg.flux",
							Source: "{\n  renameAndSum = tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))\n    |> cumulativeSum(columns: [\"x\"])\n\n  t = renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)\n    |> getRecord(idx: 0)\n\n  xbar = t.sx/t.N \n\n  ybar = t.sy/t.N\n\n  slope = (t.sxy - xbar*ybar*t.N)/(t.sxx - t.N*xbar*xbar)\n\n  intercept = (ybar - slope * xbar)\n\n  y_hat = (r) => ({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})\n\n  rse = (r) => ({r with errors: (r.y - r.y_hat)^2.0})\n\n  output = renameAndSum\n    |> map(fn: y_hat)\n    |> map(fn: rse)\n    \n  return output\n}",
							Start: ast.Position{
								Column: 35,
								Line:   8,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   12,
								},
								File:   "linearreg.flux",
								Source: "renameAndSum = tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))\n    |> cumulativeSum(columns: [\"x\"])",
								Start: ast.Position{
									Column: 3,
									Line:   9,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   9,
									},
									File:   "linearreg.flux",
									Source: "renameAndSum",
									Start: ast.Position{
										Column: 3,
										Line:   9,
									},
								},
							},
							Name: "renameAndSum",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   9,
												},
												File:   "linearreg.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 18,
													Line:   9,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   10,
											},
											File:   "linearreg.flux",
											Source: "tables\n    |> rename(columns: {_value: \"y\"})",
											Start: ast.Position{
												Column: 18,
												Line:   9,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   10,
													},
													File:   "linearreg.flux",
													Source: "columns: {_value: \"y\"}",
													Start: ast.Position{
														Column: 15,
														Line:   10,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   10,
														},
														File:   "linearreg.flux",
														Source: "columns: {_value: \"y\"}",
														Start: ast.Position{
															Column: 15,
															Line:   10,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   10,
															},
															File:   "linearreg.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 15,
																Line:   10,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   10,
															},
															File:   "linearreg.flux",
															Source: "{_value: \"y\"}",
															Start: ast.Position{
																Column: 24,
																Line:   10,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   10,
																},
																File:   "linearreg.flux",
																Source: "_value: \"y\"",
																Start: ast.Position{
																	Column: 25,
																	Line:   10,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   10,
																	},
																	File:   "linearreg.flux",
																	Source: "_value",
																	Start: ast.Position{
																		Column: 25,
																		Line:   10,
																	},
																},
															},
															Name: "_value",
														},
														Separator: nil,
														Value: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   10,
																	},
																	File:   "linearreg.flux",
																	Source: "\"y\"",
																	Start: ast.Position{
																		Column: 33,
																		Line:   10,
																	},
																},
															},
															Value: "y",
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   10,
												},
												File:   "linearreg.flux",
												Source: "rename(columns: {_value: \"y\"})",
												Start: ast.Position{
													Column: 8,
													Line:   10,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   10,
													},
													File:   "linearreg.flux",
													Source: "rename",
													Start: ast.Position{
														Column: 8,
														Line:   10,
													},
												},
											},
											Name: "rename",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   11,
										},
										File:   "linearreg.flux",
										Source: "tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))",
										Start: ast.Position{
											Column: 18,
											Line:   9,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   11,
												},
												File:   "linearreg.flux",
												Source: "fn: (r) => ({r with x: 1.0})",
												Start: ast.Position{
													Column: 12,
													Line:   11,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   11,
													},
													File:   "linearreg.flux",
													Source: "fn: (r) => ({r with x: 1.0})",
													Start: ast.Position{
														Column: 12,
														Line:   11,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   11,
														},
														File:   "linearreg.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   11,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   11,
														},
														File:   "linearreg.flux",
														Source: "(r) => ({r with x: 1.0})",
														Start: ast.Position{
															Column: 16,
															Line:   11,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   11,
															},
															File:   "linearreg.flux",
															Source: "({r with x: 1.0})",
															Start: ast.Position{
																Column: 23,
																Line:   11,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   11,
																},
																File:   "linearreg.flux",
																Source: "{r with x: 1.0}",
																Start: ast.Position{
																	Column: 24,
																	Line:   11,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   11,
																	},
																	File:   "linearreg.flux",
																	Source: "x: 1.0",
																	Start: ast.Position{
																		Column: 32,
																		Line:   11,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   11,
																		},
																		File:   "linearreg.flux",
																		Source: "x",
																		Start: ast.Position{
																			Column: 32,
																			Line:   11,
																		},
																	},
																},
																Name: "x",
															},
															Separator: nil,
															Value: &ast.FloatLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 38,
																			Line:   11,
																		},
																		File:   "linearreg.flux",
																		Source: "1.0",
																		Start: ast.Position{
																			Column: 35,
																			Line:   11,
																		},
																	},
																},
																Value: 1.0,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   11,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   11,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   11,
															},
															File:   "linearreg.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   11,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   11,
																},
																File:   "linearreg.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   11,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   11,
											},
											File:   "linearreg.flux",
											Source: "map(fn: (r) => ({r with x: 1.0}))",
											Start: ast.Position{
												Column: 8,
												Line:   11,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   11,
												},
												File:   "linearreg.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   11,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   12,
									},
									File:   "linearreg.flux",
									Source: "tables\n    |> rename(columns: {_value: \"y\"})\n    |> map(fn: (r) => ({r with x: 1.0}))\n    |> cumulativeSum(columns: [\"x\"])",
									Start: ast.Position{
										Column: 18,
										Line:   9,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   12,
											},
											File:   "linearreg.flux",
											Source: "columns: [\"x\"]",
											Start: ast.Position{
												Column: 22,
												Line:   12,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   12,
												},
												File:   "linearreg.flux",
												Source: "columns: [\"x\"]",
												Start: ast.Position{
													Column: 22,
													Line:   12,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   12,
													},
													File:   "linearreg.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 22,
														Line:   12,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   12,
													},
													File:   "linearreg.flux",
													Source: "[\"x\"]",
													Start: ast.Position{
														Column: 31,
														Line:   12,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   12,
														},
														File:   "linearreg.flux",
														Source: "\"x\"",
														Start: ast.Position{
															Column: 32,
															Line:   12,
														},
													},
												},
												Value: "x",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   12,
										},
										File:   "linearreg.flux",
										Source: "cumulativeSum(columns: [\"x\"])",
										Start: ast.Position{
											Column: 8,
											Line:   12,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   12,
											},
											File:   "linearreg.flux",
											Source: "cumulativeSum",
											Start: ast.Position{
												Column: 8,
												Line:   12,
											},
										},
									},
									Name: "cumulativeSum",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   25,
								},
								File:   "linearreg.flux",
								Source: "t = renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)\n    |> getRecord(idx: 0)",
								Start: ast.Position{
									Column: 3,
									Line:   14,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   14,
									},
									File:   "linearreg.flux",
									Source: "t",
									Start: ast.Position{
										Column: 3,
										Line:   14,
									},
								},
							},
							Name: "t",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   14,
												},
												File:   "linearreg.flux",
												Source: "renameAndSum",
												Start: ast.Position{
													Column: 7,
													Line:   14,
												},
											},
										},
										Name: "renameAndSum",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   23,
											},
											File:   "linearreg.flux",
											Source: "renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})",
											Start: ast.Position{
												Column: 7,
												Line:   14,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   23,
													},
													File:   "linearreg.flux",
													Source: "fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0}",
													Start: ast.Position{
														Column: 7,
														Line:   16,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 9,
															Line:   22,
														},
														File:   "linearreg.flux",
														Source: "fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      })",
														Start: ast.Position{
															Column: 7,
															Line:   16,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 9,
																Line:   16,
															},
															File:   "linearreg.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 7,
																Line:   16,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 9,
																Line:   22,
															},
															File:   "linearreg.flux",
															Source: "(r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      })",
															Start: ast.Position{
																Column: 11,
																Line:   16,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 9,
																	Line:   22,
																},
																File:   "linearreg.flux",
																Source: "({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      })",
																Start: ast.Position{
																	Column: 31,
																	Line:   16,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 8,
																		Line:   22,
																	},
																	File:   "linearreg.flux",
																	Source: "{\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }",
																	Start: ast.Position{
																		Column: 32,
																		Line:   16,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   17,
																		},
																		File:   "linearreg.flux",
																		Source: "sx: r.x + accumulator.sx",
																		Start: ast.Position{
																			Column: 9,
																			Line:   17,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 11,
																				Line:   17,
																			},
																			File:   "linearreg.flux",
																			Source: "sx",
																			Start: ast.Position{
																				Column: 9,
																				Line:   17,
																			},
																		},
																	},
																	Name: "sx",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   17,
																			},
																			File:   "linearreg.flux",
																			Source: "r.x + accumulator.sx",
																			Start: ast.Position{
																				Column: 13,
																				Line:   17,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 16,
																					Line:   17,
																				},
																				File:   "linearreg.flux",
																				Source: "r.x",
																				Start: ast.Position{
																					Column: 13,
																					Line:   17,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 14,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 13,
																						Line:   17,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 16,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "x",
																					Start: ast.Position{
																						Column: 15,
																						Line:   17,
																					},
																				},
																			},
																			Name: "x",
																		},
																		Rbrack: nil,
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 33,
																					Line:   17,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sx",
																				Start: ast.Position{
																					Column: 19,
																					Line:   17,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 30,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 19,
																						Line:   17,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 33,
																						Line:   17,
																					},
																					File:   "linearreg.flux",
																					Source: "sx",
																					Start: ast.Position{
																						Column: 31,
																						Line:   17,
																					},
																				},
																			},
																			Name: "sx",
																		},
																		Rbrack: nil,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   18,
																		},
																		File:   "linearreg.flux",
																		Source: "sy: r.y + accumulator.sy",
																		Start: ast.Position{
																			Column: 9,
																			Line:   18,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 11,
																				Line:   18,
																			},
																			File:   "linearreg.flux",
																			Source: "sy",
																			Start: ast.Position{
																				Column: 9,
																				Line:   18,
																			},
																		},
																	},
																	Name: "sy",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   18,
																			},
																			File:   "linearreg.flux",
																			Source: "r.y + accumulator.sy",
																			Start: ast.Position{
																				Column: 13,
																				Line:   18,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 16,
																					Line:   18,
																				},
																				File:   "linearreg.flux",
																				Source: "r.y",
																				Start: ast.Position{
																					Column: 13,
																					Line:   18,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 14,
																						Line:   18,
																					},
																					File:   "linearreg.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 13,
																						Line:   18,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 16,
																						Line:   18,
																					},
																					File:   "linearreg.flux",
																					Source: "y",
																					Start: ast.Position{
																						Column: 15,
																						Line:   18,
																					},
																				},
																			},
																			Name: "y",
																		},
																		Rbrack: nil,
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 33,
																					Line:   18,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sy",
																				Start: ast.Position{
																					Column: 19,
																					Line:   18,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 30,
																						Line:   18,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 19,
																						Line:   18,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 33,
																						Line:   18,
																					},
																					File:   "linearreg.flux",
																					Source: "sy",
																					Start: ast.Position{
																						Column: 31,
																						Line:   18,
																					},
																				},
																			},
																			Name: "sy",
																		},
																		Rbrack: nil,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 31,
																			Line:   19,
																		},
																		File:   "linearreg.flux",
																		Source: "N: accumulator.N + 1.0",
																		Start: ast.Position{
																			Column: 9,
																			Line:   19,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 10,
																				Line:   19,
																			},
																			File:   "linearreg.flux",
																			Source: "N",
																			Start: ast.Position{
																				Column: 9,
																				Line:   19,
																			},
																		},
																	},
																	Name: "N",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 31,
																				Line:   19,
																			},
																			File:   "linearreg.flux",
																			Source: "accumulator.N + 1.0",
																			Start: ast.Position{
																				Column: 12,
																				Line:   19,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 25,
																					Line:   19,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.N",
																				Start: ast.Position{
																					Column: 12,
																					Line:   19,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 23,
																						Line:   19,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 12,
																						Line:   19,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 25,
																						Line:   19,
																					},
																					File:   "linearreg.flux",
																					Source: "N",
																					Start: ast.Position{
																						Column: 24,
																						Line:   19,
																					},
																				},
																			},
																			Name: "N",
																		},
																		Rbrack: nil,
																	},
																	Operator: 5,
																	Right: &ast.FloatLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 31,
																					Line:   19,
																				},
																				File:   "linearreg.flux",
																				Source: "1.0",
																				Start: ast.Position{
																					Column: 28,
																					Line:   19,
																				},
																			},
																		},
																		Value: 1.0,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   20,
																		},
																		File:   "linearreg.flux",
																		Source: "sxy: r.x * r.y + accumulator.sxy",
																		Start: ast.Position{
																			Column: 9,
																			Line:   20,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 12,
																				Line:   20,
																			},
																			File:   "linearreg.flux",
																			Source: "sxy",
																			Start: ast.Position{
																				Column: 9,
																				Line:   20,
																			},
																		},
																	},
																	Name: "sxy",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   20,
																			},
																			File:   "linearreg.flux",
																			Source: "r.x * r.y + accumulator.sxy",
																			Start: ast.Position{
																				Column: 14,
																				Line:   20,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 23,
																					Line:   20,
																				},
																				File:   "linearreg.flux",
																				Source: "r.x * r.y",
																				Start: ast.Position{
																					Column: 14,
																					Line:   20,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 17,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "r.x",
																					Start: ast.Position{
																						Column: 14,
																						Line:   20,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 15,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 14,
																							Line:   20,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 17,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "x",
																						Start: ast.Position{
																							Column: 16,
																							Line:   20,
																						},
																					},
																				},
																				Name: "x",
																			},
																			Rbrack: nil,
																		},
																		Operator: 1,
																		Right: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 23,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "r.y",
																					Start: ast.Position{
																						Column: 20,
																						Line:   20,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 21,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 20,
																							Line:   20,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 23,
																							Line:   20,
																						},
																						File:   "linearreg.flux",
																						Source: "y",
																						Start: ast.Position{
																							Column: 22,
																							Line:   20,
																						},
																					},
																				},
																				Name: "y",
																			},
																			Rbrack: nil,
																		},
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   20,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sxy",
																				Start: ast.Position{
																					Column: 26,
																					Line:   20,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 26,
																						Line:   20,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 41,
																						Line:   20,
																					},
																					File:   "linearreg.flux",
																					Source: "sxy",
																					Start: ast.Position{
																						Column: 38,
																						Line:   20,
																					},
																				},
																			},
																			Name: "sxy",
																		},
																		Rbrack: nil,
																	},
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   21,
																		},
																		File:   "linearreg.flux",
																		Source: "sxx: r.x * r.x + accumulator.sxx",
																		Start: ast.Position{
																			Column: 9,
																			Line:   21,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 12,
																				Line:   21,
																			},
																			File:   "linearreg.flux",
																			Source: "sxx",
																			Start: ast.Position{
																				Column: 9,
																				Line:   21,
																			},
																		},
																	},
																	Name: "sxx",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   21,
																			},
																			File:   "linearreg.flux",
																			Source: "r.x * r.x + accumulator.sxx",
																			Start: ast.Position{
																				Column: 14,
																				Line:   21,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 23,
																					Line:   21,
																				},
																				File:   "linearreg.flux",
																				Source: "r.x * r.x",
																				Start: ast.Position{
																					Column: 14,
																					Line:   21,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 17,
																						Line:   21,
																					},
																					File:   "linearreg.flux",
																					Source: "r.x",
																					Start: ast.Position{
																						Column: 14,
																						Line:   21,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 15,
																							Line:   21,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 14,
																							Line:   21,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 17,
																							Line:   21,
																						},
																						File:   "linearreg.flux",
																						Source: "x",
																						Start: ast.Position{
																							Column: 16,
																							Line:   21,
																						},
																					},
																				},
																				Name: "x",
																			},
																			Rbrack: nil,
																		},
																		Operator: 1,
																		Right: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 23,
																						Line:   21,
																					},
																					File:   "linearreg.flux",
																					Source: "r.x",
																					Start: ast.Position{
																						Column: 20,
																						Line:   21,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 21,
																							Line:   21,
																						},
																						File:   "linearreg.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 20,
																							Line:   21,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 23,
																							Line:   21,
																						},
																						File:   "linearreg.flux",
																						Source: "x",
																						Start: ast.Position{
																							Column: 22,
																							Line:   21,
																						},
																					},
																				},
																				Name: "x",
																			},
																			Rbrack: nil,
																		},
																	},
																	Operator: 5,
																	Right: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 41,
																					Line:   21,
																				},
																				File:   "linearreg.flux",
																				Source: "accumulator.sxx",
																				Start: ast.Position{
																					Column: 26,
																					Line:   21,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   21,
																					},
																					File:   "linearreg.flux",
																					Source: "accumulator",
																					Start: ast.Position{
																						Column: 26,
																						Line:   21,
																					},
																				},
																			},
																			Name: "accumulator",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 41,
																						Line:   21,
																					},
																					File:   "linearreg.flux",
																					Source: "sxx",
																					Start: ast.Position{
																						Column: 38,
																						Line:   21,
																					},
																				},
																			},
																			Name: "sxx",
																		},
																		Rbrack: nil,
																	},
																},
															}},
															Rbrace: nil,
															With:   nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 13,
																	Line:   16,
																},
																File:   "linearreg.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 12,
																	Line:   16,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 13,
																		Line:   16,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 12,
																		Line:   16,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   16,
																},
																File:   "linearreg.flux",
																Source: "accumulator",
																Start: ast.Position{
																	Column: 15,
																	Line:   16,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   16,
																	},
																	File:   "linearreg.flux",
																	Source: "accumulator",
																	Start: ast.Position{
																		Column: 15,
																		Line:   16,
																	},
																},
															},
															Name: "accumulator",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   23,
														},
														File:   "linearreg.flux",
														Source: "identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0}",
														Start: ast.Position{
															Column: 7,
															Line:   23,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   23,
															},
															File:   "linearreg.flux",
															Source: "identity",
															Start: ast.Position{
																Column: 7,
																Line:   23,
															},
														},
													},
													Name: "identity",
												},
												Separator: nil,
												Value: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   23,
															},
															File:   "linearreg.flux",
															Source: "{sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0}",
															Start: ast.Position{
																Column: 17,
																Line:   23,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   23,
																},
																File:   "linearreg.flux",
																Source: "sxy: 0.0",
																Start: ast.Position{
																	Column: 18,
																	Line:   23,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 21,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "sxy",
																	Start: ast.Position{
																		Column: 18,
																		Line:   23,
																	},
																},
															},
															Name: "sxy",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 23,
																		Line:   23,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   23,
																},
																File:   "linearreg.flux",
																Source: "sx:0.0",
																Start: ast.Position{
																	Column: 28,
																	Line:   23,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "sx",
																	Start: ast.Position{
																		Column: 28,
																		Line:   23,
																	},
																},
															},
															Name: "sx",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 31,
																		Line:   23,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   23,
																},
																File:   "linearreg.flux",
																Source: "sy:0.0",
																Start: ast.Position{
																	Column: 36,
																	Line:   23,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "sy",
																	Start: ast.Position{
																		Column: 36,
																		Line:   23,
																	},
																},
															},
															Name: "sy",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 39,
																		Line:   23,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   23,
																},
																File:   "linearreg.flux",
																Source: "sxx:0.0",
																Start: ast.Position{
																	Column: 44,
																	Line:   23,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "sxx",
																	Start: ast.Position{
																		Column: 44,
																		Line:   23,
																	},
																},
															},
															Name: "sxx",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 48,
																		Line:   23,
																	},
																},
															},
															Value: 0.0,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   23,
																},
																File:   "linearreg.flux",
																Source: "N:0.0",
																Start: ast.Position{
																	Column: 53,
																	Line:   23,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "N",
																	Start: ast.Position{
																		Column: 53,
																		Line:   23,
																	},
																},
															},
															Name: "N",
														},
														Separator: nil,
														Value: &ast.FloatLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   23,
																	},
																	File:   "linearreg.flux",
																	Source: "0.0",
																	Start: ast.Position{
																		Column: 55,
																		Line:   23,
																	},
																},
															},
															Value: 0.0,
														},
													}},
													Rbrace: nil,
													With:   nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   23,
												},
												File:   "linearreg.flux",
												Source: "reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})",
												Start: ast.Position{
													Column: 8,
													Line:   15,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   15,
													},
													File:   "linearreg.flux",
													Source: "reduce",
													Start: ast.Position{
														Column: 8,
														Line:   15,
													},
												},
											},
											Name: "reduce",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   24,
										},
										File:   "linearreg.flux",
										Source: "renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)",
										Start: ast.Position{
											Column: 7,
											Line:   14,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   24,
												},
												File:   "linearreg.flux",
												Source: "fn: (key) => true",
												Start: ast.Position{
													Column: 18,
													Line:   24,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   24,
													},
													File:   "linearreg.flux",
													Source: "fn: (key) => true",
													Start: ast.Position{
														Column: 18,
														Line:   24,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   24,
														},
														File:   "linearreg.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 18,
															Line:   24,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   24,
														},
														File:   "linearreg.flux",
														Source: "(key) => true",
														Start: ast.Position{
															Column: 22,
															Line:   24,
														},
													},
												},
												Body: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   24,
															},
															File:   "linearreg.flux",
															Source: "true",
															Start: ast.Position{
																Column: 31,
																Line:   24,
															},
														},
													},
													Name: "true",
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   24,
															},
															File:   "linearreg.flux",
															Source: "key",
															Start: ast.Position{
																Column: 23,
																Line:   24,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   24,
																},
																File:   "linearreg.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 23,
																	Line:   24,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   24,
											},
											File:   "linearreg.flux",
											Source: "tableFind(fn: (key) => true)",
											Start: ast.Position{
												Column: 8,
												Line:   24,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   24,
												},
												File:   "linearreg.flux",
												Source: "tableFind",
												Start: ast.Position{
													Column: 8,
													Line:   24,
												},
											},
										},
										Name: "tableFind",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   25,
									},
									File:   "linearreg.flux",
									Source: "renameAndSum \n    |> reduce(\n      fn: (r, accumulator) => ({\n        sx: r.x + accumulator.sx,\n        sy: r.y + accumulator.sy,\n        N: accumulator.N + 1.0,  \n        sxy: r.x * r.y + accumulator.sxy, \n        sxx: r.x * r.x + accumulator.sxx\n      }), \n      identity: {sxy: 0.0, sx:0.0, sy:0.0, sxx:0.0, N:0.0})\n    |> tableFind(fn: (key) => true)\n    |> getRecord(idx: 0)",
									Start: ast.Position{
										Column: 7,
										Line:   14,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   25,
											},
											File:   "linearreg.flux",
											Source: "idx: 0",
											Start: ast.Position{
												Column: 18,
												Line:   25,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   25,
												},
												File:   "linearreg.flux",
												Source: "idx: 0",
												Start: ast.Position{
													Column: 18,
													Line:   25,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   25,
													},
													File:   "linearreg.flux",
													Source: "idx",
													Start: ast.Position{
														Column: 18,
														Line:   25,
													},
												},
											},
											Name: "idx",
										},
										Separator: nil,
										Value: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   25,
													},
													File:   "linearreg.flux",
													Source: "0",
													Start: ast.Position{
														Column: 23,
														Line:   25,
													},
												},
											},
											Value: int64(0),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   25,
										},
										File:   "linearreg.flux",
										Source: "getRecord(idx: 0)",
										Start: ast.Position{
											Column: 8,
											Line:   25,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   25,
											},
											File:   "linearreg.flux",
											Source: "getRecord",
											Start: ast.Position{
												Column: 8,
												Line:   25,
											},
										},
									},
									Name: "getRecord",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   27,
								},
								File:   "linearreg.flux",
								Source: "xbar = t.sx/t.N",
								Start: ast.Position{
									Column: 3,
									Line:   27,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   27,
									},
									File:   "linearreg.flux",
									Source: "xbar",
									Start: ast.Position{
										Column: 3,
										Line:   27,
									},
								},
							},
							Name: "xbar",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   27,
									},
									File:   "linearreg.flux",
									Source: "t.sx/t.N",
									Start: ast.Position{
										Column: 10,
										Line:   27,
									},
								},
							},
							Left: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   27,
										},
										File:   "linearreg.flux",
										Source: "t.sx",
										Start: ast.Position{
											Column: 10,
											Line:   27,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   27,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 10,
												Line:   27,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   27,
											},
											File:   "linearreg.flux",
											Source: "sx",
											Start: ast.Position{
												Column: 12,
												Line:   27,
											},
										},
									},
									Name: "sx",
								},
								Rbrack: nil,
							},
							Operator: 2,
							Right: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   27,
										},
										File:   "linearreg.flux",
										Source: "t.N",
										Start: ast.Position{
											Column: 15,
											Line:   27,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   27,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 15,
												Line:   27,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   27,
											},
											File:   "linearreg.flux",
											Source: "N",
											Start: ast.Position{
												Column: 17,
												Line:   27,
											},
										},
									},
									Name: "N",
								},
								Rbrack: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   29,
								},
								File:   "linearreg.flux",
								Source: "ybar = t.sy/t.N",
								Start: ast.Position{
									Column: 3,
									Line:   29,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   29,
									},
									File:   "linearreg.flux",
									Source: "ybar",
									Start: ast.Position{
										Column: 3,
										Line:   29,
									},
								},
							},
							Name: "ybar",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   29,
									},
									File:   "linearreg.flux",
									Source: "t.sy/t.N",
									Start: ast.Position{
										Column: 10,
										Line:   29,
									},
								},
							},
							Left: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   29,
										},
										File:   "linearreg.flux",
										Source: "t.sy",
										Start: ast.Position{
											Column: 10,
											Line:   29,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   29,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 10,
												Line:   29,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   29,
											},
											File:   "linearreg.flux",
											Source: "sy",
											Start: ast.Position{
												Column: 12,
												Line:   29,
											},
										},
									},
									Name: "sy",
								},
								Rbrack: nil,
							},
							Operator: 2,
							Right: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   29,
										},
										File:   "linearreg.flux",
										Source: "t.N",
										Start: ast.Position{
											Column: 15,
											Line:   29,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   29,
											},
											File:   "linearreg.flux",
											Source: "t",
											Start: ast.Position{
												Column: 15,
												Line:   29,
											},
										},
									},
									Name: "t",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   29,
											},
											File:   "linearreg.flux",
											Source: "N",
											Start: ast.Position{
												Column: 17,
												Line:   29,
											},
										},
									},
									Name: "N",
								},
								Rbrack: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   31,
								},
								File:   "linearreg.flux",
								Source: "slope = (t.sxy - xbar*ybar*t.N)/(t.sxx - t.N*xbar*xbar)",
								Start: ast.Position{
									Column: 3,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   31,
									},
									File:   "linearreg.flux",
									Source: "slope",
									Start: ast.Position{
										Column: 3,
										Line:   31,
									},
								},
							},
							Name: "slope",
						},
						Init: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   31,
									},
									File:   "linearreg.flux",
									Source: "(t.sxy - xbar*ybar*t.N)/(t.sxx - t.N*xbar*xbar)",
									Start: ast.Position{
										Column: 11,
										Line:   31,
									},
								},
							},
							Left: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   31,
										},
										File:   "linearreg.flux",
										Source: "(t.sxy - xbar*ybar*t.N)",
										Start: ast.Position{
											Column: 11,
											Line:   31,
										},
									},
								},
								Expression: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   31,
											},
											File:   "linearreg.flux",
											Source: "t.sxy - xbar*ybar*t.N",
											Start: ast.Position{
												Column: 12,
												Line:   31,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   31,
												},
												File:   "linearreg.flux",
												Source: "t.sxy",
												Start: ast.Position{
													Column: 12,
													Line:   31,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "t",
													Start: ast.Position{
														Column: 12,
														Line:   31,
													},
												},
											},
											Name: "t",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "sxy",
													Start: ast.Position{
														Column: 14,
														Line:   31,
													},
												},
											},
											Name: "sxy",
										},
										Rbrack: nil,
									},
									Operator: 6,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   31,
												},
												File:   "linearreg.flux",
												Source: "xbar*ybar*t.N",
												Start: ast.Position{
													Column: 20,
													Line:   31,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "xbar*ybar",
													Start: ast.Position{
														Column: 20,
														Line:   31,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   31,
														},
														File:   "linearreg.flux",
														Source: "xbar",
														Start: ast.Position{
															Column: 20,
															Line:   31,
														},
													},
												},
												Name: "xbar",
											},
											Operator: 1,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   31,
														},
														File:   "linearreg.flux",
														Source: "ybar",
														Start: ast.Position{
															Column: 25,
															Line:   31,
														},
													},
												},
												Name: "ybar",
											},
										},
										Operator: 1,
										Right: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "t.N",
													Start: ast.Position{
														Column: 30,
														Line:   31,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   31,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 30,
															Line:   31,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   31,
														},
														File:   "linearreg.flux",
														Source: "N",
														Start: ast.Position{
															Column: 32,
															Line:   31,
														},
													},
												},
												Name: "N",
											},
											Rbrack: nil,
										},
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
							Operator: 2,
							Right: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   31,
										},
										File:   "linearreg.flux",
										Source: "(t.sxx - t.N*xbar*xbar)",
										Start: ast.Position{
											Column: 35,
											Line:   31,
										},
									},
								},
								Expression: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   31,
											},
											File:   "linearreg.flux",
											Source: "t.sxx - t.N*xbar*xbar",
											Start: ast.Position{
												Column: 36,
												Line:   31,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   31,
												},
												File:   "linearreg.flux",
												Source: "t.sxx",
												Start: ast.Position{
													Column: 36,
													Line:   31,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "t",
													Start: ast.Position{
														Column: 36,
														Line:   31,
													},
												},
											},
											Name: "t",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "sxx",
													Start: ast.Position{
														Column: 38,
														Line:   31,
													},
												},
											},
											Name: "sxx",
										},
										Rbrack: nil,
									},
									Operator: 6,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   31,
												},
												File:   "linearreg.flux",
												Source: "t.N*xbar*xbar",
												Start: ast.Position{
													Column: 44,
													Line:   31,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "t.N*xbar",
													Start: ast.Position{
														Column: 44,
														Line:   31,
													},
												},
											},
											Left: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   31,
														},
														File:   "linearreg.flux",
														Source: "t.N",
														Start: ast.Position{
															Column: 44,
															Line:   31,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   31,
															},
															File:   "linearreg.flux",
															Source: "t",
															Start: ast.Position{
																Column: 44,
																Line:   31,
															},
														},
													},
													Name: "t",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   31,
															},
															File:   "linearreg.flux",
															Source: "N",
															Start: ast.Position{
																Column: 46,
																Line:   31,
															},
														},
													},
													Name: "N",
												},
												Rbrack: nil,
											},
											Operator: 1,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   31,
														},
														File:   "linearreg.flux",
														Source: "xbar",
														Start: ast.Position{
															Column: 48,
															Line:   31,
														},
													},
												},
												Name: "xbar",
											},
										},
										Operator: 1,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   31,
													},
													File:   "linearreg.flux",
													Source: "xbar",
													Start: ast.Position{
														Column: 53,
														Line:   31,
													},
												},
											},
											Name: "xbar",
										},
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   33,
								},
								File:   "linearreg.flux",
								Source: "intercept = (ybar - slope * xbar)",
								Start: ast.Position{
									Column: 3,
									Line:   33,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   33,
									},
									File:   "linearreg.flux",
									Source: "intercept",
									Start: ast.Position{
										Column: 3,
										Line:   33,
									},
								},
							},
							Name: "intercept",
						},
						Init: &ast.ParenExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   33,
									},
									File:   "linearreg.flux",
									Source: "(ybar - slope * xbar)",
									Start: ast.Position{
										Column: 15,
										Line:   33,
									},
								},
							},
							Expression: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   33,
										},
										File:   "linearreg.flux",
										Source: "ybar - slope * xbar",
										Start: ast.Position{
											Column: 16,
											Line:   33,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   33,
											},
											File:   "linearreg.flux",
											Source: "ybar",
											Start: ast.Position{
												Column: 16,
												Line:   33,
											},
										},
									},
									Name: "ybar",
								},
								Operator: 6,
								Right: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   33,
											},
											File:   "linearreg.flux",
											Source: "slope * xbar",
											Start: ast.Position{
												Column: 23,
												Line:   33,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   33,
												},
												File:   "linearreg.flux",
												Source: "slope",
												Start: ast.Position{
													Column: 23,
													Line:   33,
												},
											},
										},
										Name: "slope",
									},
									Operator: 1,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   33,
												},
												File:   "linearreg.flux",
												Source: "xbar",
												Start: ast.Position{
													Column: 31,
													Line:   33,
												},
											},
										},
										Name: "xbar",
									},
								},
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   35,
								},
								File:   "linearreg.flux",
								Source: "y_hat = (r) => ({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})",
								Start: ast.Position{
									Column: 3,
									Line:   35,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   35,
									},
									File:   "linearreg.flux",
									Source: "y_hat",
									Start: ast.Position{
										Column: 3,
										Line:   35,
									},
								},
							},
							Name: "y_hat",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 124,
										Line:   35,
									},
									File:   "linearreg.flux",
									Source: "(r) => ({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})",
									Start: ast.Position{
										Column: 11,
										Line:   35,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 124,
											Line:   35,
										},
										File:   "linearreg.flux",
										Source: "({r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy})",
										Start: ast.Position{
											Column: 18,
											Line:   35,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   35,
											},
											File:   "linearreg.flux",
											Source: "{r with y_hat: slope * r.x + intercept, slope:slope, sx: t.sx, sxy: t.sxy, sxx: t.sxx, N: t.N, sy: t.sy}",
											Start: ast.Position{
												Column: 19,
												Line:   35,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "y_hat: slope * r.x + intercept",
												Start: ast.Position{
													Column: 27,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "y_hat",
													Start: ast.Position{
														Column: 27,
														Line:   35,
													},
												},
											},
											Name: "y_hat",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "slope * r.x + intercept",
													Start: ast.Position{
														Column: 34,
														Line:   35,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "slope * r.x",
														Start: ast.Position{
															Column: 34,
															Line:   35,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   35,
															},
															File:   "linearreg.flux",
															Source: "slope",
															Start: ast.Position{
																Column: 34,
																Line:   35,
															},
														},
													},
													Name: "slope",
												},
												Operator: 1,
												Right: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   35,
															},
															File:   "linearreg.flux",
															Source: "r.x",
															Start: ast.Position{
																Column: 42,
																Line:   35,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 43,
																	Line:   35,
																},
																File:   "linearreg.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 42,
																	Line:   35,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   35,
																},
																File:   "linearreg.flux",
																Source: "x",
																Start: ast.Position{
																	Column: 44,
																	Line:   35,
																},
															},
														},
														Name: "x",
													},
													Rbrack: nil,
												},
											},
											Operator: 5,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "intercept",
														Start: ast.Position{
															Column: 48,
															Line:   35,
														},
													},
												},
												Name: "intercept",
											},
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "slope:slope",
												Start: ast.Position{
													Column: 59,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "slope",
													Start: ast.Position{
														Column: 59,
														Line:   35,
													},
												},
											},
											Name: "slope",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "slope",
													Start: ast.Position{
														Column: 65,
														Line:   35,
													},
												},
											},
											Name: "slope",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "sx: t.sx",
												Start: ast.Position{
													Column: 72,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "sx",
													Start: ast.Position{
														Column: 72,
														Line:   35,
													},
												},
											},
											Name: "sx",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "t.sx",
													Start: ast.Position{
														Column: 76,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 76,
															Line:   35,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "sx",
														Start: ast.Position{
															Column: 78,
															Line:   35,
														},
													},
												},
												Name: "sx",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 92,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "sxy: t.sxy",
												Start: ast.Position{
													Column: 82,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "sxy",
													Start: ast.Position{
														Column: 82,
														Line:   35,
													},
												},
											},
											Name: "sxy",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "t.sxy",
													Start: ast.Position{
														Column: 87,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 87,
															Line:   35,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 92,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "sxy",
														Start: ast.Position{
															Column: 89,
															Line:   35,
														},
													},
												},
												Name: "sxy",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 104,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "sxx: t.sxx",
												Start: ast.Position{
													Column: 94,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "sxx",
													Start: ast.Position{
														Column: 94,
														Line:   35,
													},
												},
											},
											Name: "sxx",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 104,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "t.sxx",
													Start: ast.Position{
														Column: 99,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 99,
															Line:   35,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "sxx",
														Start: ast.Position{
															Column: 101,
															Line:   35,
														},
													},
												},
												Name: "sxx",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 112,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "N: t.N",
												Start: ast.Position{
													Column: 106,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "N",
													Start: ast.Position{
														Column: 106,
														Line:   35,
													},
												},
											},
											Name: "N",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 112,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "t.N",
													Start: ast.Position{
														Column: 109,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 110,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 109,
															Line:   35,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 112,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "N",
														Start: ast.Position{
															Column: 111,
															Line:   35,
														},
													},
												},
												Name: "N",
											},
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 122,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "sy: t.sy",
												Start: ast.Position{
													Column: 114,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 116,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "sy",
													Start: ast.Position{
														Column: 114,
														Line:   35,
													},
												},
											},
											Name: "sy",
										},
										Separator: nil,
										Value: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 122,
														Line:   35,
													},
													File:   "linearreg.flux",
													Source: "t.sy",
													Start: ast.Position{
														Column: 118,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 119,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "t",
														Start: ast.Position{
															Column: 118,
															Line:   35,
														},
													},
												},
												Name: "t",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 122,
															Line:   35,
														},
														File:   "linearreg.flux",
														Source: "sy",
														Start: ast.Position{
															Column: 120,
															Line:   35,
														},
													},
												},
												Name: "sy",
											},
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   35,
												},
												File:   "linearreg.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   35,
												},
											},
										},
										Name: "r",
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   35,
										},
										File:   "linearreg.flux",
										Source: "r",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   35,
											},
											File:   "linearreg.flux",
											Source: "r",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "r",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   37,
								},
								File:   "linearreg.flux",
								Source: "rse = (r) => ({r with errors: (r.y - r.y_hat)^2.0})",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   37,
									},
									File:   "linearreg.flux",
									Source: "rse",
									Start: ast.Position{
										Column: 3,
										Line:   37,
									},
								},
							},
							Name: "rse",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   37,
									},
									File:   "linearreg.flux",
									Source: "(r) => ({r with errors: (r.y - r.y_hat)^2.0})",
									Start: ast.Position{
										Column: 9,
										Line:   37,
									},
								},
							},
							Body: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   37,
										},
										File:   "linearreg.flux",
										Source: "({r with errors: (r.y - r.y_hat)^2.0})",
										Start: ast.Position{
											Column: 16,
											Line:   37,
										},
									},
								},
								Expression: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   37,
											},
											File:   "linearreg.flux",
											Source: "{r with errors: (r.y - r.y_hat)^2.0}",
											Start: ast.Position{
												Column: 17,
												Line:   37,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   37,
												},
												File:   "linearreg.flux",
												Source: "errors: (r.y - r.y_hat)^2.0",
												Start: ast.Position{
													Column: 25,
													Line:   37,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   37,
													},
													File:   "linearreg.flux",
													Source: "errors",
													Start: ast.Position{
														Column: 25,
														Line:   37,
													},
												},
											},
											Name: "errors",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   37,
													},
													File:   "linearreg.flux",
													Source: "(r.y - r.y_hat)^2.0",
													Start: ast.Position{
														Column: 33,
														Line:   37,
													},
												},
											},
											Left: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   37,
														},
														File:   "linearreg.flux",
														Source: "(r.y - r.y_hat)",
														Start: ast.Position{
															Column: 33,
															Line:   37,
														},
													},
												},
												Expression: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   37,
															},
															File:   "linearreg.flux",
															Source: "r.y - r.y_hat",
															Start: ast.Position{
																Column: 34,
																Line:   37,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   37,
																},
																File:   "linearreg.flux",
																Source: "r.y",
																Start: ast.Position{
																	Column: 34,
																	Line:   37,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   37,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 34,
																		Line:   37,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   37,
																	},
																	File:   "linearreg.flux",
																	Source: "y",
																	Start: ast.Position{
																		Column: 36,
																		Line:   37,
																	},
																},
															},
															Name: "y",
														},
														Rbrack: nil,
													},
													Operator: 6,
													Right: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   37,
																},
																File:   "linearreg.flux",
																Source: "r.y_hat",
																Start: ast.Position{
																	Column: 40,
																	Line:   37,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   37,
																	},
																	File:   "linearreg.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 40,
																		Line:   37,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   37,
																	},
																	File:   "linearreg.flux",
																	Source: "y_hat",
																	Start: ast.Position{
																		Column: 42,
																		Line:   37,
																	},
																},
															},
															Name: "y_hat",
														},
														Rbrack: nil,
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Operator: 4,
											Right: &ast.FloatLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   37,
														},
														File:   "linearreg.flux",
														Source: "2.0",
														Start: ast.Position{
															Column: 49,
															Line:   37,
														},
													},
												},
												Value: 2.0,
											},
										},
									}},
									Rbrace: nil,
									With: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   37,
												},
												File:   "linearreg.flux",
												Source: "r",
												Start: ast.Position{
													Column: 18,
													Line:   37,
												},
											},
										},
										Name: "r",
									},
								},
								Lparen: nil,
								Rparen: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   37,
										},
										File:   "linearreg.flux",
										Source: "r",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   37,
											},
											File:   "linearreg.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   37,
											},
										},
									},
									Name: "r",
								},
								Separator: nil,
								Value:     nil,
							}},
							Rparan: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   41,
								},
								File:   "linearreg.flux",
								Source: "output = renameAndSum\n    |> map(fn: y_hat)\n    |> map(fn: rse)",
								Start: ast.Position{
									Column: 3,
									Line:   39,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   39,
									},
									File:   "linearreg.flux",
									Source: "output",
									Start: ast.Position{
										Column: 3,
										Line:   39,
									},
								},
							},
							Name: "output",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   39,
											},
											File:   "linearreg.flux",
											Source: "renameAndSum",
											Start: ast.Position{
												Column: 12,
												Line:   39,
											},
										},
									},
									Name: "renameAndSum",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   40,
										},
										File:   "linearreg.flux",
										Source: "renameAndSum\n    |> map(fn: y_hat)",
										Start: ast.Position{
											Column: 12,
											Line:   39,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   40,
												},
												File:   "linearreg.flux",
												Source: "fn: y_hat",
												Start: ast.Position{
													Column: 12,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   40,
													},
													File:   "linearreg.flux",
													Source: "fn: y_hat",
													Start: ast.Position{
														Column: 12,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   40,
														},
														File:   "linearreg.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   40,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   40,
														},
														File:   "linearreg.flux",
														Source: "y_hat",
														Start: ast.Position{
															Column: 16,
															Line:   40,
														},
													},
												},
												Name: "y_hat",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   40,
											},
											File:   "linearreg.flux",
											Source: "map(fn: y_hat)",
											Start: ast.Position{
												Column: 8,
												Line:   40,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   40,
												},
												File:   "linearreg.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   40,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   41,
									},
									File:   "linearreg.flux",
									Source: "renameAndSum\n    |> map(fn: y_hat)\n    |> map(fn: rse)",
									Start: ast.Position{
										Column: 12,
										Line:   39,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   41,
											},
											File:   "linearreg.flux",
											Source: "fn: rse",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   41,
												},
												File:   "linearreg.flux",
												Source: "fn: rse",
												Start: ast.Position{
													Column: 12,
													Line:   41,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   41,
													},
													File:   "linearreg.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 12,
														Line:   41,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   41,
													},
													File:   "linearreg.flux",
													Source: "rse",
													Start: ast.Position{
														Column: 16,
														Line:   41,
													},
												},
											},
											Name: "rse",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   41,
										},
										File:   "linearreg.flux",
										Source: "map(fn: rse)",
										Start: ast.Position{
											Column: 8,
											Line:   41,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   41,
											},
											File:   "linearreg.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   41,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   43,
									},
									File:   "linearreg.flux",
									Source: "output",
									Start: ast.Position{
										Column: 10,
										Line:   43,
									},
								},
							},
							Name: "output",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   43,
								},
								File:   "linearreg.flux",
								Source: "return output",
								Start: ast.Position{
									Column: 3,
									Line:   43,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   8,
							},
							File:   "linearreg.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   8,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   8,
								},
								File:   "linearreg.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   8,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   8,
							},
							File:   "linearreg.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   8,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "linearreg.flux",
					Source: "import \"math\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "linearreg.flux",
						Source: "\"math\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "math",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   4,
					},
					File:   "linearreg.flux",
					Source: "import \"generate\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   4,
						},
						File:   "linearreg.flux",
						Source: "\"generate\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "generate",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "linearreg.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "linearreg.flux",
					Source: "package statsmodels",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "linearreg.flux",
						Source: "statsmodels",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "statsmodels",
			},
		},
	}},
	Package: "statsmodels",
	Path:    "contrib/anaisdg/statsmodels",
}
