// DO NOT EDIT: This file is autogenerated via the builtin command.

package tickscript

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	runtime "github.com/influxdata/flux/runtime"
	"regexp"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 71,
					Line:   158,
				},
				File:   "tickscript.flux",
				Source: "package tickscript\n\nimport \"experimental\"\nimport \"experimental/array\"\nimport \"influxdata/influxdb\"\nimport \"influxdata/influxdb/monitor\"\nimport \"influxdata/influxdb/schema\"\nimport \"universe\"\n\n// defineCheck creates custom check data required by alert() and deadman()\ndefineCheck = (id, name, type=\"custom\") => {\n    return {\n        _check_id:   id,\n        _check_name: name,\n        _type:       type,\n        tags:        {}\n    }\n}\n\n// alert is a helper function similar to TICKscript alert.\nalert = (\n    check,\n    id=(r)=>\"${r._check_id}\",\n    details=(r)=>\"\",\n    message=(r)=>\"Threshold Check: ${r._check_name} is: ${r._level}\",\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true,\n    topic=\"\",\n    tables=<-) => {\n\n  _addTopic =\n    if topic != \"\" then\n      (tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n      (tables=<-) => tables\n\n  return tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()\n    |> monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )\n}\n\n// deadman is a helper function similar to TICKscript deadman.\ndeadman = (\n    check,\n    measurement, threshold=0,\n    id=(r)=>\"${r._check_id}\",\n    message=(r)=>\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\"),\n    topic=\"\",\n    tables=<-) => {\n\n   // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n   // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n   // table is used as input for actual threshold check in order to get 0.\n\n  _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\") // required by monitor.check\n    |> schema.fieldsAsCols() // input tables are expected to be pivoted already\n\n  _counts = union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n\n  _tables =\n    if _counts[0] == 1 then // only dummy table is in the concatenated stream\n      _dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0) // need empty table\n    else\n      tables\n\n  return _tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])                              // drop dummy field\n    |> alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )\n}\n\n// select selects a column and optionally computes aggregated value.\n// It is meant to be a convenience function to be used for:\n//\n//   query(\"SELECT x AS y\")\n//   query(\"SELECT f(x) AS y\") without time grouping\n//\nselect = (column=\"_value\", fn=(column, tables=<-) => tables, as, tables=<-) => {\n  _column = column\n  _as = as\n  return\n    tables\n      |> fn(column: _column)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}\n\n// selectWindow selects a column with time grouping and computes aggregated values.\n// It is a convenience function to be used as\n//\n//   query(\"SELECT f(x) AS y\")\n//     .groupBy(time(t), ...)\n//\nselectWindow = (column=\"_value\", fn, as, every, defaultValue, tables=<-) => {\n  _column = column\n  _as = as\n  return\n    tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}\n\n// compute computes aggregated value of the input data.\n// It is a convenience function to be used as\n//\n//   |median('x)'\n//      .as(y)\n//\ncompute = select\n\n// groupBy groups by specified columns.\n// It is a convenience function, it adds _measurement column which is required by monitor.check().\ngroupBy = (columns, tables=<-) =>\n  tables\n    |> group(columns: columns)\n    |> experimental.group(columns: [\"_measurement\"], mode:\"extend\") // required by monitor.check\n\n// join merges two streams using standard join().\n// It is meant a convenience function, it ensures _measurement column exists and is in the group key.\njoin = (tables, on=[\"_time\"], measurement) =>\n    universe.join(tables: tables, on: on)\n      |> map(fn: (r) => ({ r with _measurement: measurement }))\n      |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   18,
					},
					File:   "tickscript.flux",
					Source: "defineCheck = (id, name, type=\"custom\") => {\n    return {\n        _check_id:   id,\n        _check_name: name,\n        _type:       type,\n        tags:        {}\n    }\n}",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// defineCheck creates custom check data required by alert() and deadman()\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   11,
						},
						File:   "tickscript.flux",
						Source: "defineCheck",
						Start: ast.Position{
							Column: 1,
							Line:   11,
						},
					},
				},
				Name: "defineCheck",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   18,
						},
						File:   "tickscript.flux",
						Source: "(id, name, type=\"custom\") => {\n    return {\n        _check_id:   id,\n        _check_name: name,\n        _type:       type,\n        tags:        {}\n    }\n}",
						Start: ast.Position{
							Column: 15,
							Line:   11,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   18,
							},
							File:   "tickscript.flux",
							Source: "{\n    return {\n        _check_id:   id,\n        _check_name: name,\n        _type:       type,\n        tags:        {}\n    }\n}",
							Start: ast.Position{
								Column: 44,
								Line:   11,
							},
						},
					},
					Body: []ast.Statement{&ast.ReturnStatement{
						Argument: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   17,
									},
									File:   "tickscript.flux",
									Source: "{\n        _check_id:   id,\n        _check_name: name,\n        _type:       type,\n        tags:        {}\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   12,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   13,
										},
										File:   "tickscript.flux",
										Source: "_check_id:   id",
										Start: ast.Position{
											Column: 9,
											Line:   13,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   13,
											},
											File:   "tickscript.flux",
											Source: "_check_id",
											Start: ast.Position{
												Column: 9,
												Line:   13,
											},
										},
									},
									Name: "_check_id",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   13,
											},
											File:   "tickscript.flux",
											Source: "id",
											Start: ast.Position{
												Column: 22,
												Line:   13,
											},
										},
									},
									Name: "id",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   14,
										},
										File:   "tickscript.flux",
										Source: "_check_name: name",
										Start: ast.Position{
											Column: 9,
											Line:   14,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   14,
											},
											File:   "tickscript.flux",
											Source: "_check_name",
											Start: ast.Position{
												Column: 9,
												Line:   14,
											},
										},
									},
									Name: "_check_name",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   14,
											},
											File:   "tickscript.flux",
											Source: "name",
											Start: ast.Position{
												Column: 22,
												Line:   14,
											},
										},
									},
									Name: "name",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   15,
										},
										File:   "tickscript.flux",
										Source: "_type:       type",
										Start: ast.Position{
											Column: 9,
											Line:   15,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   15,
											},
											File:   "tickscript.flux",
											Source: "_type",
											Start: ast.Position{
												Column: 9,
												Line:   15,
											},
										},
									},
									Name: "_type",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   15,
											},
											File:   "tickscript.flux",
											Source: "type",
											Start: ast.Position{
												Column: 22,
												Line:   15,
											},
										},
									},
									Name: "type",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   16,
										},
										File:   "tickscript.flux",
										Source: "tags:        {}",
										Start: ast.Position{
											Column: 9,
											Line:   16,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   16,
											},
											File:   "tickscript.flux",
											Source: "tags",
											Start: ast.Position{
												Column: 9,
												Line:   16,
											},
										},
									},
									Name: "tags",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   16,
											},
											File:   "tickscript.flux",
											Source: "{}",
											Start: ast.Position{
												Column: 22,
												Line:   16,
											},
										},
									},
									Lbrace:     nil,
									Properties: []*ast.Property{},
									Rbrace:     nil,
									With:       nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   17,
								},
								File:   "tickscript.flux",
								Source: "return {\n        _check_id:   id,\n        _check_name: name,\n        _type:       type,\n        tags:        {}\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   12,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   11,
							},
							File:   "tickscript.flux",
							Source: "id",
							Start: ast.Position{
								Column: 16,
								Line:   11,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   11,
								},
								File:   "tickscript.flux",
								Source: "id",
								Start: ast.Position{
									Column: 16,
									Line:   11,
								},
							},
						},
						Name: "id",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   11,
							},
							File:   "tickscript.flux",
							Source: "name",
							Start: ast.Position{
								Column: 20,
								Line:   11,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   11,
								},
								File:   "tickscript.flux",
								Source: "name",
								Start: ast.Position{
									Column: 20,
									Line:   11,
								},
							},
						},
						Name: "name",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   11,
							},
							File:   "tickscript.flux",
							Source: "type=\"custom\"",
							Start: ast.Position{
								Column: 26,
								Line:   11,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   11,
								},
								File:   "tickscript.flux",
								Source: "type",
								Start: ast.Position{
									Column: 26,
									Line:   11,
								},
							},
						},
						Name: "type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   11,
								},
								File:   "tickscript.flux",
								Source: "\"custom\"",
								Start: ast.Position{
									Column: 31,
									Line:   11,
								},
							},
						},
						Value: "custom",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   58,
					},
					File:   "tickscript.flux",
					Source: "alert = (\n    check,\n    id=(r)=>\"${r._check_id}\",\n    details=(r)=>\"\",\n    message=(r)=>\"Threshold Check: ${r._check_name} is: ${r._level}\",\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true,\n    topic=\"\",\n    tables=<-) => {\n\n  _addTopic =\n    if topic != \"\" then\n      (tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n      (tables=<-) => tables\n\n  return tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()\n    |> monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// alert is a helper function similar to TICKscript alert.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   21,
						},
						File:   "tickscript.flux",
						Source: "alert",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   58,
						},
						File:   "tickscript.flux",
						Source: "(\n    check,\n    id=(r)=>\"${r._check_id}\",\n    details=(r)=>\"\",\n    message=(r)=>\"Threshold Check: ${r._check_name} is: ${r._level}\",\n    crit=(r) => false,\n    warn=(r) => false,\n    info=(r) => false,\n    ok=(r) => true,\n    topic=\"\",\n    tables=<-) => {\n\n  _addTopic =\n    if topic != \"\" then\n      (tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n      (tables=<-) => tables\n\n  return tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()\n    |> monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )\n}",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   58,
							},
							File:   "tickscript.flux",
							Source: "{\n\n  _addTopic =\n    if topic != \"\" then\n      (tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n      (tables=<-) => tables\n\n  return tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()\n    |> monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )\n}",
							Start: ast.Position{
								Column: 19,
								Line:   31,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   39,
								},
								File:   "tickscript.flux",
								Source: "_addTopic =\n    if topic != \"\" then\n      (tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n      (tables=<-) => tables",
								Start: ast.Position{
									Column: 3,
									Line:   33,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   33,
									},
									File:   "tickscript.flux",
									Source: "_addTopic",
									Start: ast.Position{
										Column: 3,
										Line:   33,
									},
								},
							},
							Name: "_addTopic",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   39,
										},
										File:   "tickscript.flux",
										Source: "(tables=<-) => tables",
										Start: ast.Position{
											Column: 7,
											Line:   39,
										},
									},
								},
								Body: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   39,
											},
											File:   "tickscript.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 22,
												Line:   39,
											},
										},
									},
									Name: "tables",
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   39,
											},
											File:   "tickscript.flux",
											Source: "tables=<-",
											Start: ast.Position{
												Column: 8,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   39,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 8,
													Line:   39,
												},
											},
										},
										Name: "tables",
									},
									Separator: nil,
									Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   39,
											},
											File:   "tickscript.flux",
											Source: "<-",
											Start: ast.Position{
												Column: 15,
												Line:   39,
											},
										},
									}},
								}},
								Rparan: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   39,
									},
									File:   "tickscript.flux",
									Source: "if topic != \"\" then\n      (tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])\n    else\n      (tables=<-) => tables",
									Start: ast.Position{
										Column: 5,
										Line:   34,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   37,
										},
										File:   "tickscript.flux",
										Source: "(tables=<-) => tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])",
										Start: ast.Position{
											Column: 7,
											Line:   35,
										},
									},
								},
								Body: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   35,
													},
													File:   "tickscript.flux",
													Source: "tables",
													Start: ast.Position{
														Column: 22,
														Line:   35,
													},
												},
											},
											Name: "tables",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   36,
												},
												File:   "tickscript.flux",
												Source: "tables\n        |> set(key: \"_topic\", value: topic )",
												Start: ast.Position{
													Column: 22,
													Line:   35,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   36,
														},
														File:   "tickscript.flux",
														Source: "key: \"_topic\", value: topic",
														Start: ast.Position{
															Column: 16,
															Line:   36,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   36,
															},
															File:   "tickscript.flux",
															Source: "key: \"_topic\"",
															Start: ast.Position{
																Column: 16,
																Line:   36,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 16,
																	Line:   36,
																},
															},
														},
														Name: "key",
													},
													Separator: nil,
													Value: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "\"_topic\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   36,
																},
															},
														},
														Value: "_topic",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   36,
															},
															File:   "tickscript.flux",
															Source: "value: topic",
															Start: ast.Position{
																Column: 31,
																Line:   36,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "value",
																Start: ast.Position{
																	Column: 31,
																	Line:   36,
																},
															},
														},
														Name: "value",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 43,
																	Line:   36,
																},
																File:   "tickscript.flux",
																Source: "topic",
																Start: ast.Position{
																	Column: 38,
																	Line:   36,
																},
															},
														},
														Name: "topic",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   36,
													},
													File:   "tickscript.flux",
													Source: "set(key: \"_topic\", value: topic )",
													Start: ast.Position{
														Column: 12,
														Line:   36,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   36,
														},
														File:   "tickscript.flux",
														Source: "set",
														Start: ast.Position{
															Column: 12,
															Line:   36,
														},
													},
												},
												Name: "set",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   37,
											},
											File:   "tickscript.flux",
											Source: "tables\n        |> set(key: \"_topic\", value: topic )\n        |> experimental.group(mode: \"extend\", columns: [\"_topic\"])",
											Start: ast.Position{
												Column: 22,
												Line:   35,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   37,
													},
													File:   "tickscript.flux",
													Source: "mode: \"extend\", columns: [\"_topic\"]",
													Start: ast.Position{
														Column: 31,
														Line:   37,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "mode: \"extend\"",
														Start: ast.Position{
															Column: 31,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "mode",
															Start: ast.Position{
																Column: 31,
																Line:   37,
															},
														},
													},
													Name: "mode",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 45,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "\"extend\"",
															Start: ast.Position{
																Column: 37,
																Line:   37,
															},
														},
													},
													Value: "extend",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "columns: [\"_topic\"]",
														Start: ast.Position{
															Column: 47,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 47,
																Line:   37,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   37,
															},
															File:   "tickscript.flux",
															Source: "[\"_topic\"]",
															Start: ast.Position{
																Column: 56,
																Line:   37,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 65,
																	Line:   37,
																},
																File:   "tickscript.flux",
																Source: "\"_topic\"",
																Start: ast.Position{
																	Column: 57,
																	Line:   37,
																},
															},
														},
														Value: "_topic",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   37,
												},
												File:   "tickscript.flux",
												Source: "experimental.group(mode: \"extend\", columns: [\"_topic\"])",
												Start: ast.Position{
													Column: 12,
													Line:   37,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   37,
													},
													File:   "tickscript.flux",
													Source: "experimental.group",
													Start: ast.Position{
														Column: 12,
														Line:   37,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "experimental",
														Start: ast.Position{
															Column: 12,
															Line:   37,
														},
													},
												},
												Name: "experimental",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   37,
														},
														File:   "tickscript.flux",
														Source: "group",
														Start: ast.Position{
															Column: 25,
															Line:   37,
														},
													},
												},
												Name: "group",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   35,
											},
											File:   "tickscript.flux",
											Source: "tables=<-",
											Start: ast.Position{
												Column: 8,
												Line:   35,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   35,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 8,
													Line:   35,
												},
											},
										},
										Name: "tables",
									},
									Separator: nil,
									Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   35,
											},
											File:   "tickscript.flux",
											Source: "<-",
											Start: ast.Position{
												Column: 15,
												Line:   35,
											},
										},
									}},
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   34,
										},
										File:   "tickscript.flux",
										Source: "topic != \"\"",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   34,
											},
											File:   "tickscript.flux",
											Source: "topic",
											Start: ast.Position{
												Column: 8,
												Line:   34,
											},
										},
									},
									Name: "topic",
								},
								Operator: 18,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   34,
											},
											File:   "tickscript.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 17,
												Line:   34,
											},
										},
									},
									Value: "",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   41,
															},
															File:   "tickscript.flux",
															Source: "tables",
															Start: ast.Position{
																Column: 10,
																Line:   41,
															},
														},
													},
													Name: "tables",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   42,
														},
														File:   "tickscript.flux",
														Source: "tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)",
														Start: ast.Position{
															Column: 10,
															Line:   41,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   42,
																},
																File:   "tickscript.flux",
																Source: "fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/",
																Start: ast.Position{
																	Column: 13,
																	Line:   42,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   42,
																	},
																	File:   "tickscript.flux",
																	Source: "fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/",
																	Start: ast.Position{
																		Column: 13,
																		Line:   42,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 15,
																			Line:   42,
																		},
																		File:   "tickscript.flux",
																		Source: "fn",
																		Start: ast.Position{
																			Column: 13,
																			Line:   42,
																		},
																	},
																},
																Name: "fn",
															},
															Separator: nil,
															Value: &ast.FunctionExpression{
																Arrow: nil,
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   42,
																		},
																		File:   "tickscript.flux",
																		Source: "(column) => column =~ /_start.*/ or column =~ /_stop.*/",
																		Start: ast.Position{
																			Column: 17,
																			Line:   42,
																		},
																	},
																},
																Body: &ast.LogicalExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 72,
																				Line:   42,
																			},
																			File:   "tickscript.flux",
																			Source: "column =~ /_start.*/ or column =~ /_stop.*/",
																			Start: ast.Position{
																				Column: 29,
																				Line:   42,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   42,
																				},
																				File:   "tickscript.flux",
																				Source: "column =~ /_start.*/",
																				Start: ast.Position{
																					Column: 29,
																					Line:   42,
																				},
																			},
																		},
																		Left: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 35,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "column",
																					Start: ast.Position{
																						Column: 29,
																						Line:   42,
																					},
																				},
																			},
																			Name: "column",
																		},
																		Operator: 19,
																		Right: &ast.RegexpLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 49,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "/_start.*/",
																					Start: ast.Position{
																						Column: 39,
																						Line:   42,
																					},
																				},
																			},
																			Value: regexp.MustCompile("_start.*"),
																		},
																	},
																	Operator: 2,
																	Right: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 72,
																					Line:   42,
																				},
																				File:   "tickscript.flux",
																				Source: "column =~ /_stop.*/",
																				Start: ast.Position{
																					Column: 53,
																					Line:   42,
																				},
																			},
																		},
																		Left: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 59,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "column",
																					Start: ast.Position{
																						Column: 53,
																						Line:   42,
																					},
																				},
																			},
																			Name: "column",
																		},
																		Operator: 19,
																		Right: &ast.RegexpLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 72,
																						Line:   42,
																					},
																					File:   "tickscript.flux",
																					Source: "/_stop.*/",
																					Start: ast.Position{
																						Column: 63,
																						Line:   42,
																					},
																				},
																			},
																			Value: regexp.MustCompile("_stop.*"),
																		},
																	},
																},
																Lparen: nil,
																Params: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   42,
																			},
																			File:   "tickscript.flux",
																			Source: "column",
																			Start: ast.Position{
																				Column: 18,
																				Line:   42,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   42,
																				},
																				File:   "tickscript.flux",
																				Source: "column",
																				Start: ast.Position{
																					Column: 18,
																					Line:   42,
																				},
																			},
																		},
																		Name: "column",
																	},
																	Separator: nil,
																	Value:     nil,
																}},
																Rparan: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   42,
															},
															File:   "tickscript.flux",
															Source: "drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)",
															Start: ast.Position{
																Column: 8,
																Line:   42,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 12,
																	Line:   42,
																},
																File:   "tickscript.flux",
																Source: "drop",
																Start: ast.Position{
																	Column: 8,
																	Line:   42,
																},
															},
														},
														Name: "drop",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 8,
														Line:   46,
													},
													File:   "tickscript.flux",
													Source: "tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))",
													Start: ast.Position{
														Column: 10,
														Line:   41,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 7,
																Line:   46,
															},
															File:   "tickscript.flux",
															Source: "fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    })",
															Start: ast.Position{
																Column: 12,
																Line:   43,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 7,
																	Line:   46,
																},
																File:   "tickscript.flux",
																Source: "fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    })",
																Start: ast.Position{
																	Column: 12,
																	Line:   43,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   43,
																	},
																	File:   "tickscript.flux",
																	Source: "fn",
																	Start: ast.Position{
																		Column: 12,
																		Line:   43,
																	},
																},
															},
															Name: "fn",
														},
														Separator: nil,
														Value: &ast.FunctionExpression{
															Arrow: nil,
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 7,
																		Line:   46,
																	},
																	File:   "tickscript.flux",
																	Source: "(r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    })",
																	Start: ast.Position{
																		Column: 16,
																		Line:   43,
																	},
																},
															},
															Body: &ast.ParenExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 7,
																			Line:   46,
																		},
																		File:   "tickscript.flux",
																		Source: "({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    })",
																		Start: ast.Position{
																			Column: 23,
																			Line:   43,
																		},
																	},
																},
																Expression: &ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 6,
																				Line:   46,
																			},
																			File:   "tickscript.flux",
																			Source: "{r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }",
																			Start: ast.Position{
																				Column: 24,
																				Line:   43,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   44,
																				},
																				File:   "tickscript.flux",
																				Source: "_check_id: check._check_id",
																				Start: ast.Position{
																					Column: 9,
																					Line:   44,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 18,
																						Line:   44,
																					},
																					File:   "tickscript.flux",
																					Source: "_check_id",
																					Start: ast.Position{
																						Column: 9,
																						Line:   44,
																					},
																				},
																			},
																			Name: "_check_id",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 35,
																						Line:   44,
																					},
																					File:   "tickscript.flux",
																					Source: "check._check_id",
																					Start: ast.Position{
																						Column: 20,
																						Line:   44,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   44,
																						},
																						File:   "tickscript.flux",
																						Source: "check",
																						Start: ast.Position{
																							Column: 20,
																							Line:   44,
																						},
																					},
																				},
																				Name: "check",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 35,
																							Line:   44,
																						},
																						File:   "tickscript.flux",
																						Source: "_check_id",
																						Start: ast.Position{
																							Column: 26,
																							Line:   44,
																						},
																					},
																				},
																				Name: "_check_id",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 39,
																					Line:   45,
																				},
																				File:   "tickscript.flux",
																				Source: "_check_name: check._check_name",
																				Start: ast.Position{
																					Column: 9,
																					Line:   45,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 20,
																						Line:   45,
																					},
																					File:   "tickscript.flux",
																					Source: "_check_name",
																					Start: ast.Position{
																						Column: 9,
																						Line:   45,
																					},
																				},
																			},
																			Name: "_check_name",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 39,
																						Line:   45,
																					},
																					File:   "tickscript.flux",
																					Source: "check._check_name",
																					Start: ast.Position{
																						Column: 22,
																						Line:   45,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 27,
																							Line:   45,
																						},
																						File:   "tickscript.flux",
																						Source: "check",
																						Start: ast.Position{
																							Column: 22,
																							Line:   45,
																						},
																					},
																				},
																				Name: "check",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 39,
																							Line:   45,
																						},
																						File:   "tickscript.flux",
																						Source: "_check_name",
																						Start: ast.Position{
																							Column: 28,
																							Line:   45,
																						},
																					},
																				},
																				Name: "_check_name",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 26,
																					Line:   43,
																				},
																				File:   "tickscript.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 25,
																					Line:   43,
																				},
																			},
																		},
																		Name: "r",
																	},
																},
																Lparen: nil,
																Rparen: nil,
															},
															Lparen: nil,
															Params: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   43,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   43,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 18,
																				Line:   43,
																			},
																			File:   "tickscript.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 17,
																				Line:   43,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value:     nil,
															}},
															Rparan: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 8,
															Line:   46,
														},
														File:   "tickscript.flux",
														Source: "map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))",
														Start: ast.Position{
															Column: 8,
															Line:   43,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   43,
															},
															File:   "tickscript.flux",
															Source: "map",
															Start: ast.Position{
																Column: 8,
																Line:   43,
															},
														},
													},
													Name: "map",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   47,
												},
												File:   "tickscript.flux",
												Source: "tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))",
												Start: ast.Position{
													Column: 10,
													Line:   41,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   47,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({ r with id: id(r: r) })",
														Start: ast.Position{
															Column: 12,
															Line:   47,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   47,
															},
															File:   "tickscript.flux",
															Source: "fn: (r) => ({ r with id: id(r: r) })",
															Start: ast.Position{
																Column: 12,
																Line:   47,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   47,
																},
																File:   "tickscript.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   47,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   47,
																},
																File:   "tickscript.flux",
																Source: "(r) => ({ r with id: id(r: r) })",
																Start: ast.Position{
																	Column: 16,
																	Line:   47,
																},
															},
														},
														Body: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   47,
																	},
																	File:   "tickscript.flux",
																	Source: "({ r with id: id(r: r) })",
																	Start: ast.Position{
																		Column: 23,
																		Line:   47,
																	},
																},
															},
															Expression: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   47,
																		},
																		File:   "tickscript.flux",
																		Source: "{ r with id: id(r: r) }",
																		Start: ast.Position{
																			Column: 24,
																			Line:   47,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   47,
																			},
																			File:   "tickscript.flux",
																			Source: "id: id(r: r)",
																			Start: ast.Position{
																				Column: 33,
																				Line:   47,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 35,
																					Line:   47,
																				},
																				File:   "tickscript.flux",
																				Source: "id",
																				Start: ast.Position{
																					Column: 33,
																					Line:   47,
																				},
																			},
																		},
																		Name: "id",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 44,
																						Line:   47,
																					},
																					File:   "tickscript.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 40,
																						Line:   47,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 44,
																							Line:   47,
																						},
																						File:   "tickscript.flux",
																						Source: "r: r",
																						Start: ast.Position{
																							Column: 40,
																							Line:   47,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 41,
																								Line:   47,
																							},
																							File:   "tickscript.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 40,
																								Line:   47,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 44,
																								Line:   47,
																							},
																							File:   "tickscript.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 43,
																								Line:   47,
																							},
																						},
																					},
																					Name: "r",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 45,
																					Line:   47,
																				},
																				File:   "tickscript.flux",
																				Source: "id(r: r)",
																				Start: ast.Position{
																					Column: 37,
																					Line:   47,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 39,
																						Line:   47,
																					},
																					File:   "tickscript.flux",
																					Source: "id",
																					Start: ast.Position{
																						Column: 37,
																						Line:   47,
																					},
																				},
																			},
																			Name: "id",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 27,
																				Line:   47,
																			},
																			File:   "tickscript.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 26,
																				Line:   47,
																			},
																		},
																	},
																	Name: "r",
																},
															},
															Lparen: nil,
															Rparen: nil,
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   47,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   47,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   47,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   47,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   47,
													},
													File:   "tickscript.flux",
													Source: "map(fn: (r) => ({ r with id: id(r: r) }))",
													Start: ast.Position{
														Column: 8,
														Line:   47,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   47,
														},
														File:   "tickscript.flux",
														Source: "map",
														Start: ast.Position{
															Column: 8,
															Line:   47,
														},
													},
												},
												Name: "map",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   48,
											},
											File:   "tickscript.flux",
											Source: "tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))",
											Start: ast.Position{
												Column: 10,
												Line:   41,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   48,
													},
													File:   "tickscript.flux",
													Source: "fn: (r) => ({ r with details: details(r: r) })",
													Start: ast.Position{
														Column: 12,
														Line:   48,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   48,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({ r with details: details(r: r) })",
														Start: ast.Position{
															Column: 12,
															Line:   48,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   48,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   48,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   48,
															},
															File:   "tickscript.flux",
															Source: "(r) => ({ r with details: details(r: r) })",
															Start: ast.Position{
																Column: 16,
																Line:   48,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   48,
																},
																File:   "tickscript.flux",
																Source: "({ r with details: details(r: r) })",
																Start: ast.Position{
																	Column: 23,
																	Line:   48,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   48,
																	},
																	File:   "tickscript.flux",
																	Source: "{ r with details: details(r: r) }",
																	Start: ast.Position{
																		Column: 24,
																		Line:   48,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   48,
																		},
																		File:   "tickscript.flux",
																		Source: "details: details(r: r)",
																		Start: ast.Position{
																			Column: 33,
																			Line:   48,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   48,
																			},
																			File:   "tickscript.flux",
																			Source: "details",
																			Start: ast.Position{
																				Column: 33,
																				Line:   48,
																			},
																		},
																	},
																	Name: "details",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   48,
																				},
																				File:   "tickscript.flux",
																				Source: "r: r",
																				Start: ast.Position{
																					Column: 50,
																					Line:   48,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 54,
																						Line:   48,
																					},
																					File:   "tickscript.flux",
																					Source: "r: r",
																					Start: ast.Position{
																						Column: 50,
																						Line:   48,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 51,
																							Line:   48,
																						},
																						File:   "tickscript.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 50,
																							Line:   48,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Separator: nil,
																			Value: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 54,
																							Line:   48,
																						},
																						File:   "tickscript.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 53,
																							Line:   48,
																						},
																					},
																				},
																				Name: "r",
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   48,
																			},
																			File:   "tickscript.flux",
																			Source: "details(r: r)",
																			Start: ast.Position{
																				Column: 42,
																				Line:   48,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   48,
																				},
																				File:   "tickscript.flux",
																				Source: "details",
																				Start: ast.Position{
																					Column: 42,
																					Line:   48,
																				},
																			},
																		},
																		Name: "details",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 27,
																			Line:   48,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 26,
																			Line:   48,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   48,
																},
																File:   "tickscript.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   48,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   48,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   48,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   48,
												},
												File:   "tickscript.flux",
												Source: "map(fn: (r) => ({ r with details: details(r: r) }))",
												Start: ast.Position{
													Column: 8,
													Line:   48,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   48,
													},
													File:   "tickscript.flux",
													Source: "map",
													Start: ast.Position{
														Column: 8,
														Line:   48,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   49,
										},
										File:   "tickscript.flux",
										Source: "tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()",
										Start: ast.Position{
											Column: 10,
											Line:   41,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   49,
											},
											File:   "tickscript.flux",
											Source: "_addTopic()",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   49,
												},
												File:   "tickscript.flux",
												Source: "_addTopic",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Name: "_addTopic",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   57,
									},
									File:   "tickscript.flux",
									Source: "tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()\n    |> monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )",
									Start: ast.Position{
										Column: 10,
										Line:   41,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   56,
											},
											File:   "tickscript.flux",
											Source: "crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check",
											Start: ast.Position{
												Column: 9,
												Line:   51,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   51,
												},
												File:   "tickscript.flux",
												Source: "crit: crit",
												Start: ast.Position{
													Column: 9,
													Line:   51,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   51,
													},
													File:   "tickscript.flux",
													Source: "crit",
													Start: ast.Position{
														Column: 9,
														Line:   51,
													},
												},
											},
											Name: "crit",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   51,
													},
													File:   "tickscript.flux",
													Source: "crit",
													Start: ast.Position{
														Column: 15,
														Line:   51,
													},
												},
											},
											Name: "crit",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "tickscript.flux",
												Source: "warn: warn",
												Start: ast.Position{
													Column: 9,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   52,
													},
													File:   "tickscript.flux",
													Source: "warn",
													Start: ast.Position{
														Column: 9,
														Line:   52,
													},
												},
											},
											Name: "warn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   52,
													},
													File:   "tickscript.flux",
													Source: "warn",
													Start: ast.Position{
														Column: 15,
														Line:   52,
													},
												},
											},
											Name: "warn",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   53,
												},
												File:   "tickscript.flux",
												Source: "info: info",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   53,
													},
													File:   "tickscript.flux",
													Source: "info",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "info",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   53,
													},
													File:   "tickscript.flux",
													Source: "info",
													Start: ast.Position{
														Column: 15,
														Line:   53,
													},
												},
											},
											Name: "info",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   54,
												},
												File:   "tickscript.flux",
												Source: "ok: ok",
												Start: ast.Position{
													Column: 9,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   54,
													},
													File:   "tickscript.flux",
													Source: "ok",
													Start: ast.Position{
														Column: 9,
														Line:   54,
													},
												},
											},
											Name: "ok",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   54,
													},
													File:   "tickscript.flux",
													Source: "ok",
													Start: ast.Position{
														Column: 13,
														Line:   54,
													},
												},
											},
											Name: "ok",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   55,
												},
												File:   "tickscript.flux",
												Source: "messageFn: message",
												Start: ast.Position{
													Column: 9,
													Line:   55,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   55,
													},
													File:   "tickscript.flux",
													Source: "messageFn",
													Start: ast.Position{
														Column: 9,
														Line:   55,
													},
												},
											},
											Name: "messageFn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   55,
													},
													File:   "tickscript.flux",
													Source: "message",
													Start: ast.Position{
														Column: 20,
														Line:   55,
													},
												},
											},
											Name: "message",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   56,
												},
												File:   "tickscript.flux",
												Source: "data: check",
												Start: ast.Position{
													Column: 9,
													Line:   56,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   56,
													},
													File:   "tickscript.flux",
													Source: "data",
													Start: ast.Position{
														Column: 9,
														Line:   56,
													},
												},
											},
											Name: "data",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   56,
													},
													File:   "tickscript.flux",
													Source: "check",
													Start: ast.Position{
														Column: 15,
														Line:   56,
													},
												},
											},
											Name: "check",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   57,
										},
										File:   "tickscript.flux",
										Source: "monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   50,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   50,
											},
											File:   "tickscript.flux",
											Source: "monitor.check",
											Start: ast.Position{
												Column: 8,
												Line:   50,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   50,
												},
												File:   "tickscript.flux",
												Source: "monitor",
												Start: ast.Position{
													Column: 8,
													Line:   50,
												},
											},
										},
										Name: "monitor",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   50,
												},
												File:   "tickscript.flux",
												Source: "check",
												Start: ast.Position{
													Column: 16,
													Line:   50,
												},
											},
										},
										Name: "check",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   57,
								},
								File:   "tickscript.flux",
								Source: "return tables\n    |> drop(fn: (column) => column =~ /_start.*/ or column =~ /_stop.*/)\n    |> map(fn: (r) => ({r with\n        _check_id: check._check_id,\n        _check_name: check._check_name,\n    }))\n    |> map(fn: (r) => ({ r with id: id(r: r) }))\n    |> map(fn: (r) => ({ r with details: details(r: r) }))\n    |> _addTopic()\n    |> monitor.check(\n        crit: crit,\n        warn: warn,\n        info: info,\n        ok: ok,\n        messageFn: message,\n        data: check\n    )",
								Start: ast.Position{
									Column: 3,
									Line:   41,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   22,
							},
							File:   "tickscript.flux",
							Source: "check",
							Start: ast.Position{
								Column: 5,
								Line:   22,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   22,
								},
								File:   "tickscript.flux",
								Source: "check",
								Start: ast.Position{
									Column: 5,
									Line:   22,
								},
							},
						},
						Name: "check",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   23,
							},
							File:   "tickscript.flux",
							Source: "id=(r)=>\"${r._check_id}\"",
							Start: ast.Position{
								Column: 5,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   23,
								},
								File:   "tickscript.flux",
								Source: "id",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
						Name: "id",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   23,
								},
								File:   "tickscript.flux",
								Source: "(r)=>\"${r._check_id}\"",
								Start: ast.Position{
									Column: 8,
									Line:   23,
								},
							},
						},
						Body: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   23,
									},
									File:   "tickscript.flux",
									Source: "\"${r._check_id}\"",
									Start: ast.Position{
										Column: 13,
										Line:   23,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   23,
										},
										File:   "tickscript.flux",
										Source: "${r._check_id}",
										Start: ast.Position{
											Column: 14,
											Line:   23,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   23,
											},
											File:   "tickscript.flux",
											Source: "r._check_id",
											Start: ast.Position{
												Column: 16,
												Line:   23,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   23,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 16,
													Line:   23,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   23,
												},
												File:   "tickscript.flux",
												Source: "_check_id",
												Start: ast.Position{
													Column: 18,
													Line:   23,
												},
											},
										},
										Name: "_check_id",
									},
									Rbrack: nil,
								},
							}},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   23,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 9,
										Line:   23,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   23,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 9,
											Line:   23,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   24,
							},
							File:   "tickscript.flux",
							Source: "details=(r)=>\"\"",
							Start: ast.Position{
								Column: 5,
								Line:   24,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   24,
								},
								File:   "tickscript.flux",
								Source: "details",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						Name: "details",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   24,
								},
								File:   "tickscript.flux",
								Source: "(r)=>\"\"",
								Start: ast.Position{
									Column: 13,
									Line:   24,
								},
							},
						},
						Body: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   24,
									},
									File:   "tickscript.flux",
									Source: "\"\"",
									Start: ast.Position{
										Column: 18,
										Line:   24,
									},
								},
							},
							Value: "",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   24,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 14,
										Line:   24,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   24,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 14,
											Line:   24,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   25,
							},
							File:   "tickscript.flux",
							Source: "message=(r)=>\"Threshold Check: ${r._check_name} is: ${r._level}\"",
							Start: ast.Position{
								Column: 5,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   25,
								},
								File:   "tickscript.flux",
								Source: "message",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   25,
								},
								File:   "tickscript.flux",
								Source: "(r)=>\"Threshold Check: ${r._check_name} is: ${r._level}\"",
								Start: ast.Position{
									Column: 13,
									Line:   25,
								},
							},
						},
						Body: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   25,
									},
									File:   "tickscript.flux",
									Source: "\"Threshold Check: ${r._check_name} is: ${r._level}\"",
									Start: ast.Position{
										Column: 18,
										Line:   25,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   25,
										},
										File:   "tickscript.flux",
										Source: "Threshold Check: ",
										Start: ast.Position{
											Column: 19,
											Line:   25,
										},
									},
								},
								Value: "Threshold Check: ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   25,
										},
										File:   "tickscript.flux",
										Source: "${r._check_name}",
										Start: ast.Position{
											Column: 36,
											Line:   25,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   25,
											},
											File:   "tickscript.flux",
											Source: "r._check_name",
											Start: ast.Position{
												Column: 38,
												Line:   25,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   25,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 38,
													Line:   25,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   25,
												},
												File:   "tickscript.flux",
												Source: "_check_name",
												Start: ast.Position{
													Column: 40,
													Line:   25,
												},
											},
										},
										Name: "_check_name",
									},
									Rbrack: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   25,
										},
										File:   "tickscript.flux",
										Source: " is: ",
										Start: ast.Position{
											Column: 52,
											Line:   25,
										},
									},
								},
								Value: " is: ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   25,
										},
										File:   "tickscript.flux",
										Source: "${r._level}",
										Start: ast.Position{
											Column: 57,
											Line:   25,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   25,
											},
											File:   "tickscript.flux",
											Source: "r._level",
											Start: ast.Position{
												Column: 59,
												Line:   25,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   25,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 59,
													Line:   25,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   25,
												},
												File:   "tickscript.flux",
												Source: "_level",
												Start: ast.Position{
													Column: 61,
													Line:   25,
												},
											},
										},
										Name: "_level",
									},
									Rbrack: nil,
								},
							}},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   25,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 14,
										Line:   25,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   25,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 14,
											Line:   25,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   26,
							},
							File:   "tickscript.flux",
							Source: "crit=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   26,
								},
								File:   "tickscript.flux",
								Source: "crit",
								Start: ast.Position{
									Column: 5,
									Line:   26,
								},
							},
						},
						Name: "crit",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   26,
								},
								File:   "tickscript.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   26,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   26,
									},
									File:   "tickscript.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   26,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   26,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   26,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   26,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   26,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   27,
							},
							File:   "tickscript.flux",
							Source: "warn=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   27,
								},
								File:   "tickscript.flux",
								Source: "warn",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						Name: "warn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   27,
								},
								File:   "tickscript.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   27,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   27,
									},
									File:   "tickscript.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   27,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   27,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   27,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   27,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   27,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   28,
							},
							File:   "tickscript.flux",
							Source: "info=(r) => false",
							Start: ast.Position{
								Column: 5,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   28,
								},
								File:   "tickscript.flux",
								Source: "info",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						Name: "info",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   28,
								},
								File:   "tickscript.flux",
								Source: "(r) => false",
								Start: ast.Position{
									Column: 10,
									Line:   28,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   28,
									},
									File:   "tickscript.flux",
									Source: "false",
									Start: ast.Position{
										Column: 17,
										Line:   28,
									},
								},
							},
							Name: "false",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   28,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 11,
										Line:   28,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   28,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 11,
											Line:   28,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   29,
							},
							File:   "tickscript.flux",
							Source: "ok=(r) => true",
							Start: ast.Position{
								Column: 5,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   29,
								},
								File:   "tickscript.flux",
								Source: "ok",
								Start: ast.Position{
									Column: 5,
									Line:   29,
								},
							},
						},
						Name: "ok",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   29,
								},
								File:   "tickscript.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 8,
									Line:   29,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   29,
									},
									File:   "tickscript.flux",
									Source: "true",
									Start: ast.Position{
										Column: 15,
										Line:   29,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   29,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 9,
										Line:   29,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   29,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 9,
											Line:   29,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   30,
							},
							File:   "tickscript.flux",
							Source: "topic=\"\"",
							Start: ast.Position{
								Column: 5,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   30,
								},
								File:   "tickscript.flux",
								Source: "topic",
								Start: ast.Position{
									Column: 5,
									Line:   30,
								},
							},
						},
						Name: "topic",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   30,
								},
								File:   "tickscript.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 11,
									Line:   30,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   31,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 5,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   31,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   31,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   31,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 12,
								Line:   31,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   105,
					},
					File:   "tickscript.flux",
					Source: "deadman = (\n    check,\n    measurement, threshold=0,\n    id=(r)=>\"${r._check_id}\",\n    message=(r)=>\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\"),\n    topic=\"\",\n    tables=<-) => {\n\n   // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n   // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n   // table is used as input for actual threshold check in order to get 0.\n\n  _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\") // required by monitor.check\n    |> schema.fieldsAsCols() // input tables are expected to be pivoted already\n\n  _counts = union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n\n  _tables =\n    if _counts[0] == 1 then // only dummy table is in the concatenated stream\n      _dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0) // need empty table\n    else\n      tables\n\n  return _tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])                              // drop dummy field\n    |> alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )\n}",
					Start: ast.Position{
						Column: 1,
						Line:   61,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// deadman is a helper function similar to TICKscript deadman.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   61,
						},
						File:   "tickscript.flux",
						Source: "deadman",
						Start: ast.Position{
							Column: 1,
							Line:   61,
						},
					},
				},
				Name: "deadman",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   105,
						},
						File:   "tickscript.flux",
						Source: "(\n    check,\n    measurement, threshold=0,\n    id=(r)=>\"${r._check_id}\",\n    message=(r)=>\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\"),\n    topic=\"\",\n    tables=<-) => {\n\n   // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n   // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n   // table is used as input for actual threshold check in order to get 0.\n\n  _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\") // required by monitor.check\n    |> schema.fieldsAsCols() // input tables are expected to be pivoted already\n\n  _counts = union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n\n  _tables =\n    if _counts[0] == 1 then // only dummy table is in the concatenated stream\n      _dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0) // need empty table\n    else\n      tables\n\n  return _tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])                              // drop dummy field\n    |> alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )\n}",
						Start: ast.Position{
							Column: 11,
							Line:   61,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   105,
							},
							File:   "tickscript.flux",
							Source: "{\n\n   // In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n   // because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n   // table is used as input for actual threshold check in order to get 0.\n\n  _dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\") // required by monitor.check\n    |> schema.fieldsAsCols() // input tables are expected to be pivoted already\n\n  _counts = union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")\n\n  _tables =\n    if _counts[0] == 1 then // only dummy table is in the concatenated stream\n      _dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0) // need empty table\n    else\n      tables\n\n  return _tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])                              // drop dummy field\n    |> alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )\n}",
							Start: ast.Position{
								Column: 19,
								Line:   67,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   76,
								},
								File:   "tickscript.flux",
								Source: "_dummy = array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\") // required by monitor.check\n    |> schema.fieldsAsCols()",
								Start: ast.Position{
									Column: 3,
									Line:   73,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// In order to detect empty stream (without tables), we concatenate input with dummy stream and count the result,\n"}, ast.Comment{Text: "// because count() returns nothing for empty stream. If the input stream is empty, then dummy stream with empty\n"}, ast.Comment{Text: "// table is used as input for actual threshold check in order to get 0.\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   73,
									},
									File:   "tickscript.flux",
									Source: "_dummy",
									Start: ast.Position{
										Column: 3,
										Line:   73,
									},
								},
							},
							Name: "_dummy",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   73,
													},
													File:   "tickscript.flux",
													Source: "rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}]",
													Start: ast.Position{
														Column: 23,
														Line:   73,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 90,
															Line:   73,
														},
														File:   "tickscript.flux",
														Source: "rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}]",
														Start: ast.Position{
															Column: 23,
															Line:   73,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   73,
															},
															File:   "tickscript.flux",
															Source: "rows",
															Start: ast.Position{
																Column: 23,
																Line:   73,
															},
														},
													},
													Name: "rows",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 90,
																Line:   73,
															},
															File:   "tickscript.flux",
															Source: "[{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}]",
															Start: ast.Position{
																Column: 29,
																Line:   73,
															},
														},
													},
													Elements: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 89,
																	Line:   73,
																},
																File:   "tickscript.flux",
																Source: "{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}",
																Start: ast.Position{
																	Column: 30,
																	Line:   73,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   73,
																	},
																	File:   "tickscript.flux",
																	Source: "_time: 2000-01-01T00:00:00Z",
																	Start: ast.Position{
																		Column: 31,
																		Line:   73,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   73,
																		},
																		File:   "tickscript.flux",
																		Source: "_time",
																		Start: ast.Position{
																			Column: 31,
																			Line:   73,
																		},
																	},
																},
																Name: "_time",
															},
															Separator: nil,
															Value: &ast.DateTimeLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   73,
																		},
																		File:   "tickscript.flux",
																		Source: "2000-01-01T00:00:00Z",
																		Start: ast.Position{
																			Column: 38,
																			Line:   73,
																		},
																	},
																},
																Value: parser.MustParseTime("2000-01-01T00:00:00Z"),
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   73,
																	},
																	File:   "tickscript.flux",
																	Source: "_field: \"unknown\"",
																	Start: ast.Position{
																		Column: 60,
																		Line:   73,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   73,
																		},
																		File:   "tickscript.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 60,
																			Line:   73,
																		},
																	},
																},
																Name: "_field",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   73,
																		},
																		File:   "tickscript.flux",
																		Source: "\"unknown\"",
																		Start: ast.Position{
																			Column: 68,
																			Line:   73,
																		},
																	},
																},
																Value: "unknown",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 88,
																		Line:   73,
																	},
																	File:   "tickscript.flux",
																	Source: "_value: 0",
																	Start: ast.Position{
																		Column: 79,
																		Line:   73,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   73,
																		},
																		File:   "tickscript.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 79,
																			Line:   73,
																		},
																	},
																},
																Name: "_value",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 88,
																			Line:   73,
																		},
																		File:   "tickscript.flux",
																		Source: "0",
																		Start: ast.Position{
																			Column: 87,
																			Line:   73,
																		},
																	},
																},
																Value: int64(0),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   73,
												},
												File:   "tickscript.flux",
												Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])",
												Start: ast.Position{
													Column: 12,
													Line:   73,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   73,
													},
													File:   "tickscript.flux",
													Source: "array.from",
													Start: ast.Position{
														Column: 12,
														Line:   73,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   73,
														},
														File:   "tickscript.flux",
														Source: "array",
														Start: ast.Position{
															Column: 12,
															Line:   73,
														},
													},
												},
												Name: "array",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   73,
														},
														File:   "tickscript.flux",
														Source: "from",
														Start: ast.Position{
															Column: 18,
															Line:   73,
														},
													},
												},
												Name: "from",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   74,
											},
											File:   "tickscript.flux",
											Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)",
											Start: ast.Position{
												Column: 12,
												Line:   73,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   74,
													},
													File:   "tickscript.flux",
													Source: "key: \"_measurement\", value: measurement",
													Start: ast.Position{
														Column: 12,
														Line:   74,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   74,
														},
														File:   "tickscript.flux",
														Source: "key: \"_measurement\"",
														Start: ast.Position{
															Column: 12,
															Line:   74,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   74,
															},
															File:   "tickscript.flux",
															Source: "key",
															Start: ast.Position{
																Column: 12,
																Line:   74,
															},
														},
													},
													Name: "key",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   74,
															},
															File:   "tickscript.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 17,
																Line:   74,
															},
														},
													},
													Value: "_measurement",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   74,
														},
														File:   "tickscript.flux",
														Source: "value: measurement",
														Start: ast.Position{
															Column: 33,
															Line:   74,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   74,
															},
															File:   "tickscript.flux",
															Source: "value",
															Start: ast.Position{
																Column: 33,
																Line:   74,
															},
														},
													},
													Name: "value",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   74,
															},
															File:   "tickscript.flux",
															Source: "measurement",
															Start: ast.Position{
																Column: 40,
																Line:   74,
															},
														},
													},
													Name: "measurement",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   74,
												},
												File:   "tickscript.flux",
												Source: "set(key: \"_measurement\", value: measurement)",
												Start: ast.Position{
													Column: 8,
													Line:   74,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   74,
													},
													File:   "tickscript.flux",
													Source: "set",
													Start: ast.Position{
														Column: 8,
														Line:   74,
													},
												},
											},
											Name: "set",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   75,
										},
										File:   "tickscript.flux",
										Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
										Start: ast.Position{
											Column: 12,
											Line:   73,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   75,
												},
												File:   "tickscript.flux",
												Source: "columns: [\"_measurement\"], mode: \"extend\"",
												Start: ast.Position{
													Column: 27,
													Line:   75,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   75,
													},
													File:   "tickscript.flux",
													Source: "columns: [\"_measurement\"]",
													Start: ast.Position{
														Column: 27,
														Line:   75,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 27,
															Line:   75,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "[\"_measurement\"]",
														Start: ast.Position{
															Column: 36,
															Line:   75,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   75,
															},
															File:   "tickscript.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 37,
																Line:   75,
															},
														},
													},
													Value: "_measurement",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   75,
													},
													File:   "tickscript.flux",
													Source: "mode: \"extend\"",
													Start: ast.Position{
														Column: 54,
														Line:   75,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "mode",
														Start: ast.Position{
															Column: 54,
															Line:   75,
														},
													},
												},
												Name: "mode",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   75,
														},
														File:   "tickscript.flux",
														Source: "\"extend\"",
														Start: ast.Position{
															Column: 60,
															Line:   75,
														},
													},
												},
												Value: "extend",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   75,
											},
											File:   "tickscript.flux",
											Source: "experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
											Start: ast.Position{
												Column: 8,
												Line:   75,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   75,
												},
												File:   "tickscript.flux",
												Source: "experimental.group",
												Start: ast.Position{
													Column: 8,
													Line:   75,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   75,
													},
													File:   "tickscript.flux",
													Source: "experimental",
													Start: ast.Position{
														Column: 8,
														Line:   75,
													},
												},
											},
											Name: "experimental",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   75,
													},
													File:   "tickscript.flux",
													Source: "group",
													Start: ast.Position{
														Column: 21,
														Line:   75,
													},
												},
											},
											Name: "group",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// required by monitor.check\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   76,
									},
									File:   "tickscript.flux",
									Source: "array.from(rows: [{_time: 2000-01-01T00:00:00Z, _field: \"unknown\", _value: 0}])\n    |> set(key: \"_measurement\", value: measurement)\n    |> experimental.group(columns: [\"_measurement\"], mode: \"extend\") // required by monitor.check\n    |> schema.fieldsAsCols()",
									Start: ast.Position{
										Column: 12,
										Line:   73,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   76,
										},
										File:   "tickscript.flux",
										Source: "schema.fieldsAsCols()",
										Start: ast.Position{
											Column: 8,
											Line:   76,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   76,
											},
											File:   "tickscript.flux",
											Source: "schema.fieldsAsCols",
											Start: ast.Position{
												Column: 8,
												Line:   76,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   76,
												},
												File:   "tickscript.flux",
												Source: "schema",
												Start: ast.Position{
													Column: 8,
													Line:   76,
												},
											},
										},
										Name: "schema",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   76,
												},
												File:   "tickscript.flux",
												Source: "fieldsAsCols",
												Start: ast.Position{
													Column: 15,
													Line:   76,
												},
											},
										},
										Name: "fieldsAsCols",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   82,
								},
								File:   "tickscript.flux",
								Source: "_counts = union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")",
								Start: ast.Position{
									Column: 3,
									Line:   78,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// input tables are expected to be pivoted already\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   78,
									},
									File:   "tickscript.flux",
									Source: "_counts",
									Start: ast.Position{
										Column: 3,
										Line:   78,
									},
								},
							},
							Name: "_counts",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   78,
														},
														File:   "tickscript.flux",
														Source: "tables: [_dummy, tables]",
														Start: ast.Position{
															Column: 19,
															Line:   78,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   78,
															},
															File:   "tickscript.flux",
															Source: "tables: [_dummy, tables]",
															Start: ast.Position{
																Column: 19,
																Line:   78,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   78,
																},
																File:   "tickscript.flux",
																Source: "tables",
																Start: ast.Position{
																	Column: 19,
																	Line:   78,
																},
															},
														},
														Name: "tables",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 43,
																	Line:   78,
																},
																File:   "tickscript.flux",
																Source: "[_dummy, tables]",
																Start: ast.Position{
																	Column: 27,
																	Line:   78,
																},
															},
														},
														Elements: []ast.Expression{&ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   78,
																	},
																	File:   "tickscript.flux",
																	Source: "_dummy",
																	Start: ast.Position{
																		Column: 28,
																		Line:   78,
																	},
																},
															},
															Name: "_dummy",
														}, &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   78,
																	},
																	File:   "tickscript.flux",
																	Source: "tables",
																	Start: ast.Position{
																		Column: 36,
																		Line:   78,
																	},
																},
															},
															Name: "tables",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   78,
													},
													File:   "tickscript.flux",
													Source: "union(tables: [_dummy, tables])",
													Start: ast.Position{
														Column: 13,
														Line:   78,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   78,
														},
														File:   "tickscript.flux",
														Source: "union",
														Start: ast.Position{
															Column: 13,
															Line:   78,
														},
													},
												},
												Name: "union",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   79,
												},
												File:   "tickscript.flux",
												Source: "union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])",
												Start: ast.Position{
													Column: 13,
													Line:   78,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   79,
														},
														File:   "tickscript.flux",
														Source: "columns: [\"_measurement\", \"_time\"]",
														Start: ast.Position{
															Column: 13,
															Line:   79,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   79,
															},
															File:   "tickscript.flux",
															Source: "columns: [\"_measurement\", \"_time\"]",
															Start: ast.Position{
																Column: 13,
																Line:   79,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   79,
																},
																File:   "tickscript.flux",
																Source: "columns",
																Start: ast.Position{
																	Column: 13,
																	Line:   79,
																},
															},
														},
														Name: "columns",
													},
													Separator: nil,
													Value: &ast.ArrayExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   79,
																},
																File:   "tickscript.flux",
																Source: "[\"_measurement\", \"_time\"]",
																Start: ast.Position{
																	Column: 22,
																	Line:   79,
																},
															},
														},
														Elements: []ast.Expression{&ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   79,
																	},
																	File:   "tickscript.flux",
																	Source: "\"_measurement\"",
																	Start: ast.Position{
																		Column: 23,
																		Line:   79,
																	},
																},
															},
															Value: "_measurement",
														}, &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   79,
																	},
																	File:   "tickscript.flux",
																	Source: "\"_time\"",
																	Start: ast.Position{
																		Column: 39,
																		Line:   79,
																	},
																},
															},
															Value: "_time",
														}},
														Lbrack: nil,
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   79,
													},
													File:   "tickscript.flux",
													Source: "keep(columns: [\"_measurement\", \"_time\"])",
													Start: ast.Position{
														Column: 8,
														Line:   79,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   79,
														},
														File:   "tickscript.flux",
														Source: "keep",
														Start: ast.Position{
															Column: 8,
															Line:   79,
														},
													},
												},
												Name: "keep",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   80,
											},
											File:   "tickscript.flux",
											Source: "union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\")",
											Start: ast.Position{
												Column: 13,
												Line:   78,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   80,
													},
													File:   "tickscript.flux",
													Source: "column: \"_measurement\", as: \"__value__\"",
													Start: ast.Position{
														Column: 18,
														Line:   80,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   80,
														},
														File:   "tickscript.flux",
														Source: "column: \"_measurement\"",
														Start: ast.Position{
															Column: 18,
															Line:   80,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   80,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 18,
																Line:   80,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   80,
															},
															File:   "tickscript.flux",
															Source: "\"_measurement\"",
															Start: ast.Position{
																Column: 26,
																Line:   80,
															},
														},
													},
													Value: "_measurement",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   80,
														},
														File:   "tickscript.flux",
														Source: "as: \"__value__\"",
														Start: ast.Position{
															Column: 42,
															Line:   80,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   80,
															},
															File:   "tickscript.flux",
															Source: "as",
															Start: ast.Position{
																Column: 42,
																Line:   80,
															},
														},
													},
													Name: "as",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 57,
																Line:   80,
															},
															File:   "tickscript.flux",
															Source: "\"__value__\"",
															Start: ast.Position{
																Column: 46,
																Line:   80,
															},
														},
													},
													Value: "__value__",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   80,
												},
												File:   "tickscript.flux",
												Source: "duplicate(column: \"_measurement\", as: \"__value__\")",
												Start: ast.Position{
													Column: 8,
													Line:   80,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   80,
													},
													File:   "tickscript.flux",
													Source: "duplicate",
													Start: ast.Position{
														Column: 8,
														Line:   80,
													},
												},
											},
											Name: "duplicate",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "// _measurement column is always present\n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   81,
										},
										File:   "tickscript.flux",
										Source: "union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")",
										Start: ast.Position{
											Column: 13,
											Line:   78,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   81,
												},
												File:   "tickscript.flux",
												Source: "column: \"__value__\"",
												Start: ast.Position{
													Column: 14,
													Line:   81,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   81,
													},
													File:   "tickscript.flux",
													Source: "column: \"__value__\"",
													Start: ast.Position{
														Column: 14,
														Line:   81,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   81,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 14,
															Line:   81,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   81,
														},
														File:   "tickscript.flux",
														Source: "\"__value__\"",
														Start: ast.Position{
															Column: 22,
															Line:   81,
														},
													},
												},
												Value: "__value__",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   81,
											},
											File:   "tickscript.flux",
											Source: "count(column: \"__value__\")",
											Start: ast.Position{
												Column: 8,
												Line:   81,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   81,
												},
												File:   "tickscript.flux",
												Source: "count",
												Start: ast.Position{
													Column: 8,
													Line:   81,
												},
											},
										},
										Name: "count",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   82,
									},
									File:   "tickscript.flux",
									Source: "union(tables: [_dummy, tables])\n    |> keep(columns: [\"_measurement\", \"_time\"])\n    |> duplicate(column: \"_measurement\", as: \"__value__\") // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")",
									Start: ast.Position{
										Column: 13,
										Line:   78,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   82,
											},
											File:   "tickscript.flux",
											Source: "fn: (key) => key._measurement == measurement, column: \"__value__\"",
											Start: ast.Position{
												Column: 19,
												Line:   82,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   82,
												},
												File:   "tickscript.flux",
												Source: "fn: (key) => key._measurement == measurement",
												Start: ast.Position{
													Column: 19,
													Line:   82,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   82,
													},
													File:   "tickscript.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   82,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   82,
													},
													File:   "tickscript.flux",
													Source: "(key) => key._measurement == measurement",
													Start: ast.Position{
														Column: 23,
														Line:   82,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   82,
														},
														File:   "tickscript.flux",
														Source: "key._measurement == measurement",
														Start: ast.Position{
															Column: 32,
															Line:   82,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 48,
																Line:   82,
															},
															File:   "tickscript.flux",
															Source: "key._measurement",
															Start: ast.Position{
																Column: 32,
																Line:   82,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   82,
																},
																File:   "tickscript.flux",
																Source: "key",
																Start: ast.Position{
																	Column: 32,
																	Line:   82,
																},
															},
														},
														Name: "key",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   82,
																},
																File:   "tickscript.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 36,
																	Line:   82,
																},
															},
														},
														Name: "_measurement",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   82,
															},
															File:   "tickscript.flux",
															Source: "measurement",
															Start: ast.Position{
																Column: 52,
																Line:   82,
															},
														},
													},
													Name: "measurement",
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   82,
														},
														File:   "tickscript.flux",
														Source: "key",
														Start: ast.Position{
															Column: 24,
															Line:   82,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   82,
															},
															File:   "tickscript.flux",
															Source: "key",
															Start: ast.Position{
																Column: 24,
																Line:   82,
															},
														},
													},
													Name: "key",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   82,
												},
												File:   "tickscript.flux",
												Source: "column: \"__value__\"",
												Start: ast.Position{
													Column: 65,
													Line:   82,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   82,
													},
													File:   "tickscript.flux",
													Source: "column",
													Start: ast.Position{
														Column: 65,
														Line:   82,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   82,
													},
													File:   "tickscript.flux",
													Source: "\"__value__\"",
													Start: ast.Position{
														Column: 73,
														Line:   82,
													},
												},
											},
											Value: "__value__",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   82,
										},
										File:   "tickscript.flux",
										Source: "findColumn(fn: (key) => key._measurement == measurement, column: \"__value__\")",
										Start: ast.Position{
											Column: 8,
											Line:   82,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   82,
											},
											File:   "tickscript.flux",
											Source: "findColumn",
											Start: ast.Position{
												Column: 8,
												Line:   82,
											},
										},
									},
									Name: "findColumn",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   90,
								},
								File:   "tickscript.flux",
								Source: "_tables =\n    if _counts[0] == 1 then // only dummy table is in the concatenated stream\n      _dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0) // need empty table\n    else\n      tables",
								Start: ast.Position{
									Column: 3,
									Line:   84,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   84,
									},
									File:   "tickscript.flux",
									Source: "_tables",
									Start: ast.Position{
										Column: 3,
										Line:   84,
									},
								},
							},
							Name: "_tables",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   90,
										},
										File:   "tickscript.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 7,
											Line:   90,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   90,
									},
									File:   "tickscript.flux",
									Source: "if _counts[0] == 1 then // only dummy table is in the concatenated stream\n      _dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0) // need empty table\n    else\n      tables",
									Start: ast.Position{
										Column: 5,
										Line:   85,
									},
								},
							},
							Consequent: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: []ast.Comment{ast.Comment{Text: "// only dummy table is in the concatenated stream\n"}},
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   86,
												},
												File:   "tickscript.flux",
												Source: "_dummy",
												Start: ast.Position{
													Column: 7,
													Line:   86,
												},
											},
										},
										Name: "_dummy",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   87,
											},
											File:   "tickscript.flux",
											Source: "_dummy\n        |> drop(columns: [\"unknown\"])",
											Start: ast.Position{
												Column: 7,
												Line:   86,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   87,
													},
													File:   "tickscript.flux",
													Source: "columns: [\"unknown\"]",
													Start: ast.Position{
														Column: 17,
														Line:   87,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   87,
														},
														File:   "tickscript.flux",
														Source: "columns: [\"unknown\"]",
														Start: ast.Position{
															Column: 17,
															Line:   87,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   87,
															},
															File:   "tickscript.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 17,
																Line:   87,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   87,
															},
															File:   "tickscript.flux",
															Source: "[\"unknown\"]",
															Start: ast.Position{
																Column: 26,
																Line:   87,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   87,
																},
																File:   "tickscript.flux",
																Source: "\"unknown\"",
																Start: ast.Position{
																	Column: 27,
																	Line:   87,
																},
															},
														},
														Value: "unknown",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   87,
												},
												File:   "tickscript.flux",
												Source: "drop(columns: [\"unknown\"])",
												Start: ast.Position{
													Column: 12,
													Line:   87,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   87,
													},
													File:   "tickscript.flux",
													Source: "drop",
													Start: ast.Position{
														Column: 12,
														Line:   87,
													},
												},
											},
											Name: "drop",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   88,
										},
										File:   "tickscript.flux",
										Source: "_dummy\n        |> drop(columns: [\"unknown\"])\n        |> limit(n: 0)",
										Start: ast.Position{
											Column: 7,
											Line:   86,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   88,
												},
												File:   "tickscript.flux",
												Source: "n: 0",
												Start: ast.Position{
													Column: 18,
													Line:   88,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   88,
													},
													File:   "tickscript.flux",
													Source: "n: 0",
													Start: ast.Position{
														Column: 18,
														Line:   88,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   88,
														},
														File:   "tickscript.flux",
														Source: "n",
														Start: ast.Position{
															Column: 18,
															Line:   88,
														},
													},
												},
												Name: "n",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   88,
														},
														File:   "tickscript.flux",
														Source: "0",
														Start: ast.Position{
															Column: 21,
															Line:   88,
														},
													},
												},
												Value: int64(0),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   88,
											},
											File:   "tickscript.flux",
											Source: "limit(n: 0)",
											Start: ast.Position{
												Column: 12,
												Line:   88,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   88,
												},
												File:   "tickscript.flux",
												Source: "limit",
												Start: ast.Position{
													Column: 12,
													Line:   88,
												},
											},
										},
										Name: "limit",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   85,
										},
										File:   "tickscript.flux",
										Source: "_counts[0] == 1",
										Start: ast.Position{
											Column: 8,
											Line:   85,
										},
									},
								},
								Left: &ast.IndexExpression{
									Array: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   85,
												},
												File:   "tickscript.flux",
												Source: "_counts",
												Start: ast.Position{
													Column: 8,
													Line:   85,
												},
											},
										},
										Name: "_counts",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   85,
											},
											File:   "tickscript.flux",
											Source: "_counts[0]",
											Start: ast.Position{
												Column: 8,
												Line:   85,
											},
										},
									},
									Index: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   85,
												},
												File:   "tickscript.flux",
												Source: "0",
												Start: ast.Position{
													Column: 16,
													Line:   85,
												},
											},
										},
										Value: int64(0),
									},
									Lbrack: nil,
									Rbrack: nil,
								},
								Operator: 17,
								Right: &ast.IntegerLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   85,
											},
											File:   "tickscript.flux",
											Source: "1",
											Start: ast.Position{
												Column: 22,
												Line:   85,
											},
										},
									},
									Value: int64(1),
								},
							},
							Tk_else: []ast.Comment{ast.Comment{Text: "// need empty table\n"}},
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   92,
															},
															File:   "tickscript.flux",
															Source: "_tables",
															Start: ast.Position{
																Column: 10,
																Line:   92,
															},
														},
													},
													Name: "_tables",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   93,
														},
														File:   "tickscript.flux",
														Source: "_tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")",
														Start: ast.Position{
															Column: 10,
															Line:   92,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   93,
																},
																File:   "tickscript.flux",
																Source: "column: \"_measurement\", as: \"__value__\"",
																Start: ast.Position{
																	Column: 18,
																	Line:   93,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   93,
																	},
																	File:   "tickscript.flux",
																	Source: "column: \"_measurement\"",
																	Start: ast.Position{
																		Column: 18,
																		Line:   93,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   93,
																		},
																		File:   "tickscript.flux",
																		Source: "column",
																		Start: ast.Position{
																			Column: 18,
																			Line:   93,
																		},
																	},
																},
																Name: "column",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   93,
																		},
																		File:   "tickscript.flux",
																		Source: "\"_measurement\"",
																		Start: ast.Position{
																			Column: 26,
																			Line:   93,
																		},
																	},
																},
																Value: "_measurement",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   93,
																	},
																	File:   "tickscript.flux",
																	Source: "as: \"__value__\"",
																	Start: ast.Position{
																		Column: 42,
																		Line:   93,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 44,
																			Line:   93,
																		},
																		File:   "tickscript.flux",
																		Source: "as",
																		Start: ast.Position{
																			Column: 42,
																			Line:   93,
																		},
																	},
																},
																Name: "as",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   93,
																		},
																		File:   "tickscript.flux",
																		Source: "\"__value__\"",
																		Start: ast.Position{
																			Column: 46,
																			Line:   93,
																		},
																	},
																},
																Value: "__value__",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   93,
															},
															File:   "tickscript.flux",
															Source: "duplicate(column: \"_measurement\", as: \"__value__\")",
															Start: ast.Position{
																Column: 8,
																Line:   93,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   93,
																},
																File:   "tickscript.flux",
																Source: "duplicate",
																Start: ast.Position{
																	Column: 8,
																	Line:   93,
																},
															},
														},
														Name: "duplicate",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: []ast.Comment{ast.Comment{Text: "// _measurement column is always present\n"}},
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   94,
													},
													File:   "tickscript.flux",
													Source: "_tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")",
													Start: ast.Position{
														Column: 10,
														Line:   92,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   94,
															},
															File:   "tickscript.flux",
															Source: "column: \"__value__\"",
															Start: ast.Position{
																Column: 14,
																Line:   94,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   94,
																},
																File:   "tickscript.flux",
																Source: "column: \"__value__\"",
																Start: ast.Position{
																	Column: 14,
																	Line:   94,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 20,
																		Line:   94,
																	},
																	File:   "tickscript.flux",
																	Source: "column",
																	Start: ast.Position{
																		Column: 14,
																		Line:   94,
																	},
																},
															},
															Name: "column",
														},
														Separator: nil,
														Value: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   94,
																	},
																	File:   "tickscript.flux",
																	Source: "\"__value__\"",
																	Start: ast.Position{
																		Column: 22,
																		Line:   94,
																	},
																},
															},
															Value: "__value__",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   94,
														},
														File:   "tickscript.flux",
														Source: "count(column: \"__value__\")",
														Start: ast.Position{
															Column: 8,
															Line:   94,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 13,
																Line:   94,
															},
															File:   "tickscript.flux",
															Source: "count",
															Start: ast.Position{
																Column: 8,
																Line:   94,
															},
														},
													},
													Name: "count",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   95,
												},
												File:   "tickscript.flux",
												Source: "_tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))",
												Start: ast.Position{
													Column: 10,
													Line:   92,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   95,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({r with _time: now()})",
														Start: ast.Position{
															Column: 12,
															Line:   95,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   95,
															},
															File:   "tickscript.flux",
															Source: "fn: (r) => ({r with _time: now()})",
															Start: ast.Position{
																Column: 12,
																Line:   95,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   95,
																},
																File:   "tickscript.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 12,
																	Line:   95,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.FunctionExpression{
														Arrow: nil,
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   95,
																},
																File:   "tickscript.flux",
																Source: "(r) => ({r with _time: now()})",
																Start: ast.Position{
																	Column: 16,
																	Line:   95,
																},
															},
														},
														Body: &ast.ParenExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   95,
																	},
																	File:   "tickscript.flux",
																	Source: "({r with _time: now()})",
																	Start: ast.Position{
																		Column: 23,
																		Line:   95,
																	},
																},
															},
															Expression: &ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   95,
																		},
																		File:   "tickscript.flux",
																		Source: "{r with _time: now()}",
																		Start: ast.Position{
																			Column: 24,
																			Line:   95,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 44,
																				Line:   95,
																			},
																			File:   "tickscript.flux",
																			Source: "_time: now()",
																			Start: ast.Position{
																				Column: 32,
																				Line:   95,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   95,
																				},
																				File:   "tickscript.flux",
																				Source: "_time",
																				Start: ast.Position{
																					Column: 32,
																					Line:   95,
																				},
																			},
																		},
																		Name: "_time",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: nil,
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 44,
																					Line:   95,
																				},
																				File:   "tickscript.flux",
																				Source: "now()",
																				Start: ast.Position{
																					Column: 39,
																					Line:   95,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 42,
																						Line:   95,
																					},
																					File:   "tickscript.flux",
																					Source: "now",
																					Start: ast.Position{
																						Column: 39,
																						Line:   95,
																					},
																				},
																			},
																			Name: "now",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   95,
																			},
																			File:   "tickscript.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   95,
																			},
																		},
																	},
																	Name: "r",
																},
															},
															Lparen: nil,
															Rparen: nil,
														},
														Lparen: nil,
														Params: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   95,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   95,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   95,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 17,
																			Line:   95,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rparan: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   95,
													},
													File:   "tickscript.flux",
													Source: "map(fn: (r) => ({r with _time: now()}))",
													Start: ast.Position{
														Column: 8,
														Line:   95,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   95,
														},
														File:   "tickscript.flux",
														Source: "map",
														Start: ast.Position{
															Column: 8,
															Line:   95,
														},
													},
												},
												Name: "map",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: []ast.Comment{ast.Comment{Text: "// recreate _time column after aggregation\n"}},
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   96,
											},
											File:   "tickscript.flux",
											Source: "_tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold}))",
											Start: ast.Position{
												Column: 10,
												Line:   92,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   96,
													},
													File:   "tickscript.flux",
													Source: "fn: (r) => ({r with dead: r.__value__ <= threshold})",
													Start: ast.Position{
														Column: 12,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   96,
														},
														File:   "tickscript.flux",
														Source: "fn: (r) => ({r with dead: r.__value__ <= threshold})",
														Start: ast.Position{
															Column: 12,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   96,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 12,
																Line:   96,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   96,
															},
															File:   "tickscript.flux",
															Source: "(r) => ({r with dead: r.__value__ <= threshold})",
															Start: ast.Position{
																Column: 16,
																Line:   96,
															},
														},
													},
													Body: &ast.ParenExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   96,
																},
																File:   "tickscript.flux",
																Source: "({r with dead: r.__value__ <= threshold})",
																Start: ast.Position{
																	Column: 23,
																	Line:   96,
																},
															},
														},
														Expression: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 63,
																		Line:   96,
																	},
																	File:   "tickscript.flux",
																	Source: "{r with dead: r.__value__ <= threshold}",
																	Start: ast.Position{
																		Column: 24,
																		Line:   96,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   96,
																		},
																		File:   "tickscript.flux",
																		Source: "dead: r.__value__ <= threshold",
																		Start: ast.Position{
																			Column: 32,
																			Line:   96,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   96,
																			},
																			File:   "tickscript.flux",
																			Source: "dead",
																			Start: ast.Position{
																				Column: 32,
																				Line:   96,
																			},
																		},
																	},
																	Name: "dead",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   96,
																			},
																			File:   "tickscript.flux",
																			Source: "r.__value__ <= threshold",
																			Start: ast.Position{
																				Column: 38,
																				Line:   96,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   96,
																				},
																				File:   "tickscript.flux",
																				Source: "r.__value__",
																				Start: ast.Position{
																					Column: 38,
																					Line:   96,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 39,
																						Line:   96,
																					},
																					File:   "tickscript.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 38,
																						Line:   96,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 49,
																						Line:   96,
																					},
																					File:   "tickscript.flux",
																					Source: "__value__",
																					Start: ast.Position{
																						Column: 40,
																						Line:   96,
																					},
																				},
																			},
																			Name: "__value__",
																		},
																		Rbrack: nil,
																	},
																	Operator: 7,
																	Right: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 62,
																					Line:   96,
																				},
																				File:   "tickscript.flux",
																				Source: "threshold",
																				Start: ast.Position{
																					Column: 53,
																					Line:   96,
																				},
																			},
																		},
																		Name: "threshold",
																	},
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 26,
																			Line:   96,
																		},
																		File:   "tickscript.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   96,
																		},
																	},
																},
																Name: "r",
															},
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   96,
																},
																File:   "tickscript.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   96,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   96,
																	},
																	File:   "tickscript.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 17,
																		Line:   96,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   96,
												},
												File:   "tickscript.flux",
												Source: "map(fn: (r) => ({r with dead: r.__value__ <= threshold}))",
												Start: ast.Position{
													Column: 8,
													Line:   96,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   96,
													},
													File:   "tickscript.flux",
													Source: "map",
													Start: ast.Position{
														Column: 8,
														Line:   96,
													},
												},
											},
											Name: "map",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: []ast.Comment{ast.Comment{Text: "// same tag that monitor.deadman() adds\n"}},
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   97,
										},
										File:   "tickscript.flux",
										Source: "_tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])",
										Start: ast.Position{
											Column: 10,
											Line:   92,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   97,
												},
												File:   "tickscript.flux",
												Source: "columns: [\"__value__\"]",
												Start: ast.Position{
													Column: 13,
													Line:   97,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   97,
													},
													File:   "tickscript.flux",
													Source: "columns: [\"__value__\"]",
													Start: ast.Position{
														Column: 13,
														Line:   97,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   97,
														},
														File:   "tickscript.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 13,
															Line:   97,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   97,
														},
														File:   "tickscript.flux",
														Source: "[\"__value__\"]",
														Start: ast.Position{
															Column: 22,
															Line:   97,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   97,
															},
															File:   "tickscript.flux",
															Source: "\"__value__\"",
															Start: ast.Position{
																Column: 23,
																Line:   97,
															},
														},
													},
													Value: "__value__",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   97,
											},
											File:   "tickscript.flux",
											Source: "drop(columns: [\"__value__\"])",
											Start: ast.Position{
												Column: 8,
												Line:   97,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   97,
												},
												File:   "tickscript.flux",
												Source: "drop",
												Start: ast.Position{
													Column: 8,
													Line:   97,
												},
											},
										},
										Name: "drop",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// drop dummy field\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   104,
									},
									File:   "tickscript.flux",
									Source: "_tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])                              // drop dummy field\n    |> alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )",
									Start: ast.Position{
										Column: 10,
										Line:   92,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   103,
											},
											File:   "tickscript.flux",
											Source: "check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic",
											Start: ast.Position{
												Column: 7,
												Line:   99,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   99,
												},
												File:   "tickscript.flux",
												Source: "check: check",
												Start: ast.Position{
													Column: 7,
													Line:   99,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   99,
													},
													File:   "tickscript.flux",
													Source: "check",
													Start: ast.Position{
														Column: 7,
														Line:   99,
													},
												},
											},
											Name: "check",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   99,
													},
													File:   "tickscript.flux",
													Source: "check",
													Start: ast.Position{
														Column: 14,
														Line:   99,
													},
												},
											},
											Name: "check",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   100,
												},
												File:   "tickscript.flux",
												Source: "id: id",
												Start: ast.Position{
													Column: 7,
													Line:   100,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   100,
													},
													File:   "tickscript.flux",
													Source: "id",
													Start: ast.Position{
														Column: 7,
														Line:   100,
													},
												},
											},
											Name: "id",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   100,
													},
													File:   "tickscript.flux",
													Source: "id",
													Start: ast.Position{
														Column: 11,
														Line:   100,
													},
												},
											},
											Name: "id",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   101,
												},
												File:   "tickscript.flux",
												Source: "message: message",
												Start: ast.Position{
													Column: 7,
													Line:   101,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   101,
													},
													File:   "tickscript.flux",
													Source: "message",
													Start: ast.Position{
														Column: 7,
														Line:   101,
													},
												},
											},
											Name: "message",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   101,
													},
													File:   "tickscript.flux",
													Source: "message",
													Start: ast.Position{
														Column: 16,
														Line:   101,
													},
												},
											},
											Name: "message",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   102,
												},
												File:   "tickscript.flux",
												Source: "crit: (r) => r.dead",
												Start: ast.Position{
													Column: 7,
													Line:   102,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   102,
													},
													File:   "tickscript.flux",
													Source: "crit",
													Start: ast.Position{
														Column: 7,
														Line:   102,
													},
												},
											},
											Name: "crit",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   102,
													},
													File:   "tickscript.flux",
													Source: "(r) => r.dead",
													Start: ast.Position{
														Column: 13,
														Line:   102,
													},
												},
											},
											Body: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   102,
														},
														File:   "tickscript.flux",
														Source: "r.dead",
														Start: ast.Position{
															Column: 20,
															Line:   102,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   102,
															},
															File:   "tickscript.flux",
															Source: "r",
															Start: ast.Position{
																Column: 20,
																Line:   102,
															},
														},
													},
													Name: "r",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   102,
															},
															File:   "tickscript.flux",
															Source: "dead",
															Start: ast.Position{
																Column: 22,
																Line:   102,
															},
														},
													},
													Name: "dead",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   102,
														},
														File:   "tickscript.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   102,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   102,
															},
															File:   "tickscript.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   102,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   103,
												},
												File:   "tickscript.flux",
												Source: "topic: topic",
												Start: ast.Position{
													Column: 7,
													Line:   103,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   103,
													},
													File:   "tickscript.flux",
													Source: "topic",
													Start: ast.Position{
														Column: 7,
														Line:   103,
													},
												},
											},
											Name: "topic",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   103,
													},
													File:   "tickscript.flux",
													Source: "topic",
													Start: ast.Position{
														Column: 14,
														Line:   103,
													},
												},
											},
											Name: "topic",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   104,
										},
										File:   "tickscript.flux",
										Source: "alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   98,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   98,
											},
											File:   "tickscript.flux",
											Source: "alert",
											Start: ast.Position{
												Column: 8,
												Line:   98,
											},
										},
									},
									Name: "alert",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   104,
								},
								File:   "tickscript.flux",
								Source: "return _tables\n    |> duplicate(column: \"_measurement\", as: \"__value__\")        // _measurement column is always present\n    |> count(column: \"__value__\")\n    |> map(fn: (r) => ({r with _time: now()}))                   // recreate _time column after aggregation\n    |> map(fn: (r) => ({r with dead: r.__value__ <= threshold})) // same tag that monitor.deadman() adds\n    |> drop(columns: [\"__value__\"])                              // drop dummy field\n    |> alert(\n      check: check,\n      id: id,\n      message: message,\n      crit: (r) => r.dead,\n      topic: topic\n    )",
								Start: ast.Position{
									Column: 3,
									Line:   92,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   62,
							},
							File:   "tickscript.flux",
							Source: "check",
							Start: ast.Position{
								Column: 5,
								Line:   62,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   62,
								},
								File:   "tickscript.flux",
								Source: "check",
								Start: ast.Position{
									Column: 5,
									Line:   62,
								},
							},
						},
						Name: "check",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   63,
							},
							File:   "tickscript.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 5,
								Line:   63,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   63,
								},
								File:   "tickscript.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 5,
									Line:   63,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   63,
							},
							File:   "tickscript.flux",
							Source: "threshold=0",
							Start: ast.Position{
								Column: 18,
								Line:   63,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   63,
								},
								File:   "tickscript.flux",
								Source: "threshold",
								Start: ast.Position{
									Column: 18,
									Line:   63,
								},
							},
						},
						Name: "threshold",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   63,
								},
								File:   "tickscript.flux",
								Source: "0",
								Start: ast.Position{
									Column: 28,
									Line:   63,
								},
							},
						},
						Value: int64(0),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   64,
							},
							File:   "tickscript.flux",
							Source: "id=(r)=>\"${r._check_id}\"",
							Start: ast.Position{
								Column: 5,
								Line:   64,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   64,
								},
								File:   "tickscript.flux",
								Source: "id",
								Start: ast.Position{
									Column: 5,
									Line:   64,
								},
							},
						},
						Name: "id",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   64,
								},
								File:   "tickscript.flux",
								Source: "(r)=>\"${r._check_id}\"",
								Start: ast.Position{
									Column: 8,
									Line:   64,
								},
							},
						},
						Body: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   64,
									},
									File:   "tickscript.flux",
									Source: "\"${r._check_id}\"",
									Start: ast.Position{
										Column: 13,
										Line:   64,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   64,
										},
										File:   "tickscript.flux",
										Source: "${r._check_id}",
										Start: ast.Position{
											Column: 14,
											Line:   64,
										},
									},
								},
								Expression: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   64,
											},
											File:   "tickscript.flux",
											Source: "r._check_id",
											Start: ast.Position{
												Column: 16,
												Line:   64,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   64,
												},
												File:   "tickscript.flux",
												Source: "r",
												Start: ast.Position{
													Column: 16,
													Line:   64,
												},
											},
										},
										Name: "r",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   64,
												},
												File:   "tickscript.flux",
												Source: "_check_id",
												Start: ast.Position{
													Column: 18,
													Line:   64,
												},
											},
										},
										Name: "_check_id",
									},
									Rbrack: nil,
								},
							}},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   64,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 9,
										Line:   64,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   64,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 9,
											Line:   64,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   65,
							},
							File:   "tickscript.flux",
							Source: "message=(r)=>\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\")",
							Start: ast.Position{
								Column: 5,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   65,
								},
								File:   "tickscript.flux",
								Source: "message",
								Start: ast.Position{
									Column: 5,
									Line:   65,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   65,
								},
								File:   "tickscript.flux",
								Source: "(r)=>\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\")",
								Start: ast.Position{
									Column: 13,
									Line:   65,
								},
							},
						},
						Body: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   65,
									},
									File:   "tickscript.flux",
									Source: "\"Deadman Check: ${r._check_name} is: \" + (if r.dead then \"dead\" else \"alive\")",
									Start: ast.Position{
										Column: 18,
										Line:   65,
									},
								},
							},
							Left: &ast.StringExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   65,
										},
										File:   "tickscript.flux",
										Source: "\"Deadman Check: ${r._check_name} is: \"",
										Start: ast.Position{
											Column: 18,
											Line:   65,
										},
									},
								},
								Parts: []ast.StringExpressionPart{&ast.TextPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   65,
											},
											File:   "tickscript.flux",
											Source: "Deadman Check: ",
											Start: ast.Position{
												Column: 19,
												Line:   65,
											},
										},
									},
									Value: "Deadman Check: ",
								}, &ast.InterpolatedPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   65,
											},
											File:   "tickscript.flux",
											Source: "${r._check_name}",
											Start: ast.Position{
												Column: 34,
												Line:   65,
											},
										},
									},
									Expression: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   65,
												},
												File:   "tickscript.flux",
												Source: "r._check_name",
												Start: ast.Position{
													Column: 36,
													Line:   65,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   65,
													},
													File:   "tickscript.flux",
													Source: "r",
													Start: ast.Position{
														Column: 36,
														Line:   65,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   65,
													},
													File:   "tickscript.flux",
													Source: "_check_name",
													Start: ast.Position{
														Column: 38,
														Line:   65,
													},
												},
											},
											Name: "_check_name",
										},
										Rbrack: nil,
									},
								}, &ast.TextPart{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   65,
											},
											File:   "tickscript.flux",
											Source: " is: ",
											Start: ast.Position{
												Column: 50,
												Line:   65,
											},
										},
									},
									Value: " is: ",
								}},
							},
							Operator: 5,
							Right: &ast.ParenExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   65,
										},
										File:   "tickscript.flux",
										Source: "(if r.dead then \"dead\" else \"alive\")",
										Start: ast.Position{
											Column: 59,
											Line:   65,
										},
									},
								},
								Expression: &ast.ConditionalExpression{
									Alternate: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   65,
												},
												File:   "tickscript.flux",
												Source: "\"alive\"",
												Start: ast.Position{
													Column: 87,
													Line:   65,
												},
											},
										},
										Value: "alive",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 94,
												Line:   65,
											},
											File:   "tickscript.flux",
											Source: "if r.dead then \"dead\" else \"alive\"",
											Start: ast.Position{
												Column: 60,
												Line:   65,
											},
										},
									},
									Consequent: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 81,
													Line:   65,
												},
												File:   "tickscript.flux",
												Source: "\"dead\"",
												Start: ast.Position{
													Column: 75,
													Line:   65,
												},
											},
										},
										Value: "dead",
									},
									Test: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   65,
												},
												File:   "tickscript.flux",
												Source: "r.dead",
												Start: ast.Position{
													Column: 63,
													Line:   65,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   65,
													},
													File:   "tickscript.flux",
													Source: "r",
													Start: ast.Position{
														Column: 63,
														Line:   65,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   65,
													},
													File:   "tickscript.flux",
													Source: "dead",
													Start: ast.Position{
														Column: 65,
														Line:   65,
													},
												},
											},
											Name: "dead",
										},
										Rbrack: nil,
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   65,
									},
									File:   "tickscript.flux",
									Source: "r",
									Start: ast.Position{
										Column: 14,
										Line:   65,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   65,
										},
										File:   "tickscript.flux",
										Source: "r",
										Start: ast.Position{
											Column: 14,
											Line:   65,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   66,
							},
							File:   "tickscript.flux",
							Source: "topic=\"\"",
							Start: ast.Position{
								Column: 5,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   66,
								},
								File:   "tickscript.flux",
								Source: "topic",
								Start: ast.Position{
									Column: 5,
									Line:   66,
								},
							},
						},
						Name: "topic",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   66,
								},
								File:   "tickscript.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 11,
									Line:   66,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   67,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 5,
								Line:   67,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   67,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   67,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 12,
								Line:   67,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   120,
					},
					File:   "tickscript.flux",
					Source: "select = (column=\"_value\", fn=(column, tables=<-) => tables, as, tables=<-) => {\n  _column = column\n  _as = as\n  return\n    tables\n      |> fn(column: _column)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   113,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// select selects a column and optionally computes aggregated value.\n"}, ast.Comment{Text: "// It is meant to be a convenience function to be used for:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   query(\"SELECT x AS y\")\n"}, ast.Comment{Text: "//   query(\"SELECT f(x) AS y\") without time grouping\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   113,
						},
						File:   "tickscript.flux",
						Source: "select",
						Start: ast.Position{
							Column: 1,
							Line:   113,
						},
					},
				},
				Name: "select",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   120,
						},
						File:   "tickscript.flux",
						Source: "(column=\"_value\", fn=(column, tables=<-) => tables, as, tables=<-) => {\n  _column = column\n  _as = as\n  return\n    tables\n      |> fn(column: _column)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}",
						Start: ast.Position{
							Column: 10,
							Line:   113,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   120,
							},
							File:   "tickscript.flux",
							Source: "{\n  _column = column\n  _as = as\n  return\n    tables\n      |> fn(column: _column)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}",
							Start: ast.Position{
								Column: 80,
								Line:   113,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   114,
								},
								File:   "tickscript.flux",
								Source: "_column = column",
								Start: ast.Position{
									Column: 3,
									Line:   114,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   114,
									},
									File:   "tickscript.flux",
									Source: "_column",
									Start: ast.Position{
										Column: 3,
										Line:   114,
									},
								},
							},
							Name: "_column",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   114,
									},
									File:   "tickscript.flux",
									Source: "column",
									Start: ast.Position{
										Column: 13,
										Line:   114,
									},
								},
							},
							Name: "column",
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   115,
								},
								File:   "tickscript.flux",
								Source: "_as = as",
								Start: ast.Position{
									Column: 3,
									Line:   115,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   115,
									},
									File:   "tickscript.flux",
									Source: "_as",
									Start: ast.Position{
										Column: 3,
										Line:   115,
									},
								},
							},
							Name: "_as",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   115,
									},
									File:   "tickscript.flux",
									Source: "as",
									Start: ast.Position{
										Column: 9,
										Line:   115,
									},
								},
							},
							Name: "as",
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   117,
											},
											File:   "tickscript.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   117,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   118,
										},
										File:   "tickscript.flux",
										Source: "tables\n      |> fn(column: _column)",
										Start: ast.Position{
											Column: 5,
											Line:   117,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   118,
												},
												File:   "tickscript.flux",
												Source: "column: _column",
												Start: ast.Position{
													Column: 13,
													Line:   118,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   118,
													},
													File:   "tickscript.flux",
													Source: "column: _column",
													Start: ast.Position{
														Column: 13,
														Line:   118,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   118,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 13,
															Line:   118,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   118,
														},
														File:   "tickscript.flux",
														Source: "_column",
														Start: ast.Position{
															Column: 21,
															Line:   118,
														},
													},
												},
												Name: "_column",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   118,
											},
											File:   "tickscript.flux",
											Source: "fn(column: _column)",
											Start: ast.Position{
												Column: 10,
												Line:   118,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   118,
												},
												File:   "tickscript.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 10,
													Line:   118,
												},
											},
										},
										Name: "fn",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   119,
									},
									File:   "tickscript.flux",
									Source: "tables\n      |> fn(column: _column)\n      |> rename(fn: (column) => if column == _column then _as else column)",
									Start: ast.Position{
										Column: 5,
										Line:   117,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   119,
											},
											File:   "tickscript.flux",
											Source: "fn: (column) => if column == _column then _as else column",
											Start: ast.Position{
												Column: 17,
												Line:   119,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   119,
												},
												File:   "tickscript.flux",
												Source: "fn: (column) => if column == _column then _as else column",
												Start: ast.Position{
													Column: 17,
													Line:   119,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   119,
													},
													File:   "tickscript.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 17,
														Line:   119,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   119,
													},
													File:   "tickscript.flux",
													Source: "(column) => if column == _column then _as else column",
													Start: ast.Position{
														Column: 21,
														Line:   119,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 74,
																Line:   119,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 68,
																Line:   119,
															},
														},
													},
													Name: "column",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   119,
														},
														File:   "tickscript.flux",
														Source: "if column == _column then _as else column",
														Start: ast.Position{
															Column: 33,
															Line:   119,
														},
													},
												},
												Consequent: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   119,
															},
															File:   "tickscript.flux",
															Source: "_as",
															Start: ast.Position{
																Column: 59,
																Line:   119,
															},
														},
													},
													Name: "_as",
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   119,
															},
															File:   "tickscript.flux",
															Source: "column == _column",
															Start: ast.Position{
																Column: 36,
																Line:   119,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   119,
																},
																File:   "tickscript.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 36,
																	Line:   119,
																},
															},
														},
														Name: "column",
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   119,
																},
																File:   "tickscript.flux",
																Source: "_column",
																Start: ast.Position{
																	Column: 46,
																	Line:   119,
																},
															},
														},
														Name: "_column",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   119,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 22,
															Line:   119,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   119,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 22,
																Line:   119,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   119,
										},
										File:   "tickscript.flux",
										Source: "rename(fn: (column) => if column == _column then _as else column)",
										Start: ast.Position{
											Column: 10,
											Line:   119,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   119,
											},
											File:   "tickscript.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 10,
												Line:   119,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   119,
								},
								File:   "tickscript.flux",
								Source: "return\n    tables\n      |> fn(column: _column)\n      |> rename(fn: (column) => if column == _column then _as else column)",
								Start: ast.Position{
									Column: 3,
									Line:   116,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   113,
							},
							File:   "tickscript.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 11,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "column",
								Start: ast.Position{
									Column: 11,
									Line:   113,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 18,
									Line:   113,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   113,
							},
							File:   "tickscript.flux",
							Source: "fn=(column, tables=<-) => tables",
							Start: ast.Position{
								Column: 28,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 28,
									Line:   113,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "(column, tables=<-) => tables",
								Start: ast.Position{
									Column: 31,
									Line:   113,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   113,
									},
									File:   "tickscript.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 54,
										Line:   113,
									},
								},
							},
							Name: "tables",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   113,
									},
									File:   "tickscript.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   113,
										},
										File:   "tickscript.flux",
										Source: "column",
										Start: ast.Position{
											Column: 32,
											Line:   113,
										},
									},
								},
								Name: "column",
							},
							Separator: nil,
							Value:     nil,
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   113,
									},
									File:   "tickscript.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 40,
										Line:   113,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   113,
										},
										File:   "tickscript.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 40,
											Line:   113,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   113,
									},
									File:   "tickscript.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 47,
										Line:   113,
									},
								},
							}},
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   113,
							},
							File:   "tickscript.flux",
							Source: "as",
							Start: ast.Position{
								Column: 62,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "as",
								Start: ast.Position{
									Column: 62,
									Line:   113,
								},
							},
						},
						Name: "as",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   113,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 66,
								Line:   113,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   113,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 66,
									Line:   113,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   113,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 73,
								Line:   113,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   136,
					},
					File:   "tickscript.flux",
					Source: "selectWindow = (column=\"_value\", fn, as, every, defaultValue, tables=<-) => {\n  _column = column\n  _as = as\n  return\n    tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   128,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// selectWindow selects a column with time grouping and computes aggregated values.\n"}, ast.Comment{Text: "// It is a convenience function to be used as\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   query(\"SELECT f(x) AS y\")\n"}, ast.Comment{Text: "//     .groupBy(time(t), ...)\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   128,
						},
						File:   "tickscript.flux",
						Source: "selectWindow",
						Start: ast.Position{
							Column: 1,
							Line:   128,
						},
					},
				},
				Name: "selectWindow",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   136,
						},
						File:   "tickscript.flux",
						Source: "(column=\"_value\", fn, as, every, defaultValue, tables=<-) => {\n  _column = column\n  _as = as\n  return\n    tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}",
						Start: ast.Position{
							Column: 16,
							Line:   128,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   136,
							},
							File:   "tickscript.flux",
							Source: "{\n  _column = column\n  _as = as\n  return\n    tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)\n      |> rename(fn: (column) => if column == _column then _as else column)\n}",
							Start: ast.Position{
								Column: 77,
								Line:   128,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   129,
								},
								File:   "tickscript.flux",
								Source: "_column = column",
								Start: ast.Position{
									Column: 3,
									Line:   129,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   129,
									},
									File:   "tickscript.flux",
									Source: "_column",
									Start: ast.Position{
										Column: 3,
										Line:   129,
									},
								},
							},
							Name: "_column",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   129,
									},
									File:   "tickscript.flux",
									Source: "column",
									Start: ast.Position{
										Column: 13,
										Line:   129,
									},
								},
							},
							Name: "column",
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   130,
								},
								File:   "tickscript.flux",
								Source: "_as = as",
								Start: ast.Position{
									Column: 3,
									Line:   130,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   130,
									},
									File:   "tickscript.flux",
									Source: "_as",
									Start: ast.Position{
										Column: 3,
										Line:   130,
									},
								},
							},
							Name: "_as",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   130,
									},
									File:   "tickscript.flux",
									Source: "as",
									Start: ast.Position{
										Column: 9,
										Line:   130,
									},
								},
							},
							Name: "as",
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   132,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 5,
													Line:   132,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   133,
											},
											File:   "tickscript.flux",
											Source: "tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)",
											Start: ast.Position{
												Column: 5,
												Line:   132,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   133,
													},
													File:   "tickscript.flux",
													Source: "every: every, fn: fn, column: _column, createEmpty: true",
													Start: ast.Position{
														Column: 26,
														Line:   133,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   133,
														},
														File:   "tickscript.flux",
														Source: "every: every",
														Start: ast.Position{
															Column: 26,
															Line:   133,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "every",
															Start: ast.Position{
																Column: 26,
																Line:   133,
															},
														},
													},
													Name: "every",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "every",
															Start: ast.Position{
																Column: 33,
																Line:   133,
															},
														},
													},
													Name: "every",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   133,
														},
														File:   "tickscript.flux",
														Source: "fn: fn",
														Start: ast.Position{
															Column: 40,
															Line:   133,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 40,
																Line:   133,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 44,
																Line:   133,
															},
														},
													},
													Name: "fn",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   133,
														},
														File:   "tickscript.flux",
														Source: "column: _column",
														Start: ast.Position{
															Column: 48,
															Line:   133,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 48,
																Line:   133,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "_column",
															Start: ast.Position{
																Column: 56,
																Line:   133,
															},
														},
													},
													Name: "_column",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   133,
														},
														File:   "tickscript.flux",
														Source: "createEmpty: true",
														Start: ast.Position{
															Column: 65,
															Line:   133,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "createEmpty",
															Start: ast.Position{
																Column: 65,
																Line:   133,
															},
														},
													},
													Name: "createEmpty",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   133,
															},
															File:   "tickscript.flux",
															Source: "true",
															Start: ast.Position{
																Column: 78,
																Line:   133,
															},
														},
													},
													Name: "true",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   133,
												},
												File:   "tickscript.flux",
												Source: "aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)",
												Start: ast.Position{
													Column: 10,
													Line:   133,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   133,
													},
													File:   "tickscript.flux",
													Source: "aggregateWindow",
													Start: ast.Position{
														Column: 10,
														Line:   133,
													},
												},
											},
											Name: "aggregateWindow",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   134,
										},
										File:   "tickscript.flux",
										Source: "tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)",
										Start: ast.Position{
											Column: 5,
											Line:   132,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   134,
												},
												File:   "tickscript.flux",
												Source: "column: _column, value: defaultValue",
												Start: ast.Position{
													Column: 15,
													Line:   134,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   134,
													},
													File:   "tickscript.flux",
													Source: "column: _column",
													Start: ast.Position{
														Column: 15,
														Line:   134,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   134,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 15,
															Line:   134,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   134,
														},
														File:   "tickscript.flux",
														Source: "_column",
														Start: ast.Position{
															Column: 23,
															Line:   134,
														},
													},
												},
												Name: "_column",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   134,
													},
													File:   "tickscript.flux",
													Source: "value: defaultValue",
													Start: ast.Position{
														Column: 32,
														Line:   134,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   134,
														},
														File:   "tickscript.flux",
														Source: "value",
														Start: ast.Position{
															Column: 32,
															Line:   134,
														},
													},
												},
												Name: "value",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   134,
														},
														File:   "tickscript.flux",
														Source: "defaultValue",
														Start: ast.Position{
															Column: 39,
															Line:   134,
														},
													},
												},
												Name: "defaultValue",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   134,
											},
											File:   "tickscript.flux",
											Source: "fill(column: _column, value: defaultValue)",
											Start: ast.Position{
												Column: 10,
												Line:   134,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   134,
												},
												File:   "tickscript.flux",
												Source: "fill",
												Start: ast.Position{
													Column: 10,
													Line:   134,
												},
											},
										},
										Name: "fill",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   135,
									},
									File:   "tickscript.flux",
									Source: "tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)\n      |> rename(fn: (column) => if column == _column then _as else column)",
									Start: ast.Position{
										Column: 5,
										Line:   132,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   135,
											},
											File:   "tickscript.flux",
											Source: "fn: (column) => if column == _column then _as else column",
											Start: ast.Position{
												Column: 17,
												Line:   135,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   135,
												},
												File:   "tickscript.flux",
												Source: "fn: (column) => if column == _column then _as else column",
												Start: ast.Position{
													Column: 17,
													Line:   135,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   135,
													},
													File:   "tickscript.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 17,
														Line:   135,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   135,
													},
													File:   "tickscript.flux",
													Source: "(column) => if column == _column then _as else column",
													Start: ast.Position{
														Column: 21,
														Line:   135,
													},
												},
											},
											Body: &ast.ConditionalExpression{
												Alternate: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 74,
																Line:   135,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 68,
																Line:   135,
															},
														},
													},
													Name: "column",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   135,
														},
														File:   "tickscript.flux",
														Source: "if column == _column then _as else column",
														Start: ast.Position{
															Column: 33,
															Line:   135,
														},
													},
												},
												Consequent: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   135,
															},
															File:   "tickscript.flux",
															Source: "_as",
															Start: ast.Position{
																Column: 59,
																Line:   135,
															},
														},
													},
													Name: "_as",
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   135,
															},
															File:   "tickscript.flux",
															Source: "column == _column",
															Start: ast.Position{
																Column: 36,
																Line:   135,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   135,
																},
																File:   "tickscript.flux",
																Source: "column",
																Start: ast.Position{
																	Column: 36,
																	Line:   135,
																},
															},
														},
														Name: "column",
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   135,
																},
																File:   "tickscript.flux",
																Source: "_column",
																Start: ast.Position{
																	Column: 46,
																	Line:   135,
																},
															},
														},
														Name: "_column",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   135,
														},
														File:   "tickscript.flux",
														Source: "column",
														Start: ast.Position{
															Column: 22,
															Line:   135,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   135,
															},
															File:   "tickscript.flux",
															Source: "column",
															Start: ast.Position{
																Column: 22,
																Line:   135,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   135,
										},
										File:   "tickscript.flux",
										Source: "rename(fn: (column) => if column == _column then _as else column)",
										Start: ast.Position{
											Column: 10,
											Line:   135,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   135,
											},
											File:   "tickscript.flux",
											Source: "rename",
											Start: ast.Position{
												Column: 10,
												Line:   135,
											},
										},
									},
									Name: "rename",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   135,
								},
								File:   "tickscript.flux",
								Source: "return\n    tables\n      |> aggregateWindow(every: every, fn: fn, column: _column, createEmpty: true)\n      |> fill(column: _column, value: defaultValue)\n      |> rename(fn: (column) => if column == _column then _as else column)",
								Start: ast.Position{
									Column: 3,
									Line:   131,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 17,
								Line:   128,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "column",
								Start: ast.Position{
									Column: 17,
									Line:   128,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 24,
									Line:   128,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 34,
								Line:   128,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 34,
									Line:   128,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "as",
							Start: ast.Position{
								Column: 38,
								Line:   128,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "as",
								Start: ast.Position{
									Column: 38,
									Line:   128,
								},
							},
						},
						Name: "as",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "every",
							Start: ast.Position{
								Column: 42,
								Line:   128,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "every",
								Start: ast.Position{
									Column: 42,
									Line:   128,
								},
							},
						},
						Name: "every",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "defaultValue",
							Start: ast.Position{
								Column: 49,
								Line:   128,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "defaultValue",
								Start: ast.Position{
									Column: 49,
									Line:   128,
								},
							},
						},
						Name: "defaultValue",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 63,
								Line:   128,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   128,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 63,
									Line:   128,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   128,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 70,
								Line:   128,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   144,
					},
					File:   "tickscript.flux",
					Source: "compute = select",
					Start: ast.Position{
						Column: 1,
						Line:   144,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// compute computes aggregated value of the input data.\n"}, ast.Comment{Text: "// It is a convenience function to be used as\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   |median('x)'\n"}, ast.Comment{Text: "//      .as(y)\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   144,
						},
						File:   "tickscript.flux",
						Source: "compute",
						Start: ast.Position{
							Column: 1,
							Line:   144,
						},
					},
				},
				Name: "compute",
			},
			Init: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   144,
						},
						File:   "tickscript.flux",
						Source: "select",
						Start: ast.Position{
							Column: 11,
							Line:   144,
						},
					},
				},
				Name: "select",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   151,
					},
					File:   "tickscript.flux",
					Source: "groupBy = (columns, tables=<-) =>\n  tables\n    |> group(columns: columns)\n    |> experimental.group(columns: [\"_measurement\"], mode:\"extend\")",
					Start: ast.Position{
						Column: 1,
						Line:   148,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// groupBy groups by specified columns.\n"}, ast.Comment{Text: "// It is a convenience function, it adds _measurement column which is required by monitor.check().\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   148,
						},
						File:   "tickscript.flux",
						Source: "groupBy",
						Start: ast.Position{
							Column: 1,
							Line:   148,
						},
					},
				},
				Name: "groupBy",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   151,
						},
						File:   "tickscript.flux",
						Source: "(columns, tables=<-) =>\n  tables\n    |> group(columns: columns)\n    |> experimental.group(columns: [\"_measurement\"], mode:\"extend\")",
						Start: ast.Position{
							Column: 11,
							Line:   148,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   149,
									},
									File:   "tickscript.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 3,
										Line:   149,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   150,
								},
								File:   "tickscript.flux",
								Source: "tables\n    |> group(columns: columns)",
								Start: ast.Position{
									Column: 3,
									Line:   149,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   150,
										},
										File:   "tickscript.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 14,
											Line:   150,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   150,
											},
											File:   "tickscript.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 14,
												Line:   150,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   150,
												},
												File:   "tickscript.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   150,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   150,
												},
												File:   "tickscript.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 23,
													Line:   150,
												},
											},
										},
										Name: "columns",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   150,
									},
									File:   "tickscript.flux",
									Source: "group(columns: columns)",
									Start: ast.Position{
										Column: 8,
										Line:   150,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   150,
										},
										File:   "tickscript.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   150,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   151,
							},
							File:   "tickscript.flux",
							Source: "tables\n    |> group(columns: columns)\n    |> experimental.group(columns: [\"_measurement\"], mode:\"extend\")",
							Start: ast.Position{
								Column: 3,
								Line:   149,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   151,
									},
									File:   "tickscript.flux",
									Source: "columns: [\"_measurement\"], mode:\"extend\"",
									Start: ast.Position{
										Column: 27,
										Line:   151,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   151,
										},
										File:   "tickscript.flux",
										Source: "columns: [\"_measurement\"]",
										Start: ast.Position{
											Column: 27,
											Line:   151,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   151,
											},
											File:   "tickscript.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 27,
												Line:   151,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   151,
											},
											File:   "tickscript.flux",
											Source: "[\"_measurement\"]",
											Start: ast.Position{
												Column: 36,
												Line:   151,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   151,
												},
												File:   "tickscript.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 37,
													Line:   151,
												},
											},
										},
										Value: "_measurement",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   151,
										},
										File:   "tickscript.flux",
										Source: "mode:\"extend\"",
										Start: ast.Position{
											Column: 54,
											Line:   151,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   151,
											},
											File:   "tickscript.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 54,
												Line:   151,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   151,
											},
											File:   "tickscript.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 59,
												Line:   151,
											},
										},
									},
									Value: "extend",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   151,
								},
								File:   "tickscript.flux",
								Source: "experimental.group(columns: [\"_measurement\"], mode:\"extend\")",
								Start: ast.Position{
									Column: 8,
									Line:   151,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   151,
									},
									File:   "tickscript.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 8,
										Line:   151,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   151,
										},
										File:   "tickscript.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 8,
											Line:   151,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   151,
										},
										File:   "tickscript.flux",
										Source: "group",
										Start: ast.Position{
											Column: 21,
											Line:   151,
										},
									},
								},
								Name: "group",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   148,
							},
							File:   "tickscript.flux",
							Source: "columns",
							Start: ast.Position{
								Column: 12,
								Line:   148,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   148,
								},
								File:   "tickscript.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 12,
									Line:   148,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   148,
							},
							File:   "tickscript.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 21,
								Line:   148,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   148,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 21,
									Line:   148,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   148,
							},
							File:   "tickscript.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   148,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 71,
						Line:   158,
					},
					File:   "tickscript.flux",
					Source: "join = (tables, on=[\"_time\"], measurement) =>\n    universe.join(tables: tables, on: on)\n      |> map(fn: (r) => ({ r with _measurement: measurement }))\n      |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
					Start: ast.Position{
						Column: 1,
						Line:   155,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// required by monitor.check\n"}, ast.Comment{Text: "// join merges two streams using standard join().\n"}, ast.Comment{Text: "// It is meant a convenience function, it ensures _measurement column exists and is in the group key.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   155,
						},
						File:   "tickscript.flux",
						Source: "join",
						Start: ast.Position{
							Column: 1,
							Line:   155,
						},
					},
				},
				Name: "join",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   158,
						},
						File:   "tickscript.flux",
						Source: "(tables, on=[\"_time\"], measurement) =>\n    universe.join(tables: tables, on: on)\n      |> map(fn: (r) => ({ r with _measurement: measurement }))\n      |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
						Start: ast.Position{
							Column: 8,
							Line:   155,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   156,
										},
										File:   "tickscript.flux",
										Source: "tables: tables, on: on",
										Start: ast.Position{
											Column: 19,
											Line:   156,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   156,
											},
											File:   "tickscript.flux",
											Source: "tables: tables",
											Start: ast.Position{
												Column: 19,
												Line:   156,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   156,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 19,
													Line:   156,
												},
											},
										},
										Name: "tables",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   156,
												},
												File:   "tickscript.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 27,
													Line:   156,
												},
											},
										},
										Name: "tables",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   156,
											},
											File:   "tickscript.flux",
											Source: "on: on",
											Start: ast.Position{
												Column: 35,
												Line:   156,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   156,
												},
												File:   "tickscript.flux",
												Source: "on",
												Start: ast.Position{
													Column: 35,
													Line:   156,
												},
											},
										},
										Name: "on",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   156,
												},
												File:   "tickscript.flux",
												Source: "on",
												Start: ast.Position{
													Column: 39,
													Line:   156,
												},
											},
										},
										Name: "on",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   156,
									},
									File:   "tickscript.flux",
									Source: "universe.join(tables: tables, on: on)",
									Start: ast.Position{
										Column: 5,
										Line:   156,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   156,
										},
										File:   "tickscript.flux",
										Source: "universe.join",
										Start: ast.Position{
											Column: 5,
											Line:   156,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   156,
											},
											File:   "tickscript.flux",
											Source: "universe",
											Start: ast.Position{
												Column: 5,
												Line:   156,
											},
										},
									},
									Name: "universe",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   156,
											},
											File:   "tickscript.flux",
											Source: "join",
											Start: ast.Position{
												Column: 14,
												Line:   156,
											},
										},
									},
									Name: "join",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   157,
								},
								File:   "tickscript.flux",
								Source: "universe.join(tables: tables, on: on)\n      |> map(fn: (r) => ({ r with _measurement: measurement }))",
								Start: ast.Position{
									Column: 5,
									Line:   156,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   157,
										},
										File:   "tickscript.flux",
										Source: "fn: (r) => ({ r with _measurement: measurement })",
										Start: ast.Position{
											Column: 14,
											Line:   157,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   157,
											},
											File:   "tickscript.flux",
											Source: "fn: (r) => ({ r with _measurement: measurement })",
											Start: ast.Position{
												Column: 14,
												Line:   157,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   157,
												},
												File:   "tickscript.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 14,
													Line:   157,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   157,
												},
												File:   "tickscript.flux",
												Source: "(r) => ({ r with _measurement: measurement })",
												Start: ast.Position{
													Column: 18,
													Line:   157,
												},
											},
										},
										Body: &ast.ParenExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   157,
													},
													File:   "tickscript.flux",
													Source: "({ r with _measurement: measurement })",
													Start: ast.Position{
														Column: 25,
														Line:   157,
													},
												},
											},
											Expression: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   157,
														},
														File:   "tickscript.flux",
														Source: "{ r with _measurement: measurement }",
														Start: ast.Position{
															Column: 26,
															Line:   157,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   157,
															},
															File:   "tickscript.flux",
															Source: "_measurement: measurement",
															Start: ast.Position{
																Column: 35,
																Line:   157,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   157,
																},
																File:   "tickscript.flux",
																Source: "_measurement",
																Start: ast.Position{
																	Column: 35,
																	Line:   157,
																},
															},
														},
														Name: "_measurement",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   157,
																},
																File:   "tickscript.flux",
																Source: "measurement",
																Start: ast.Position{
																	Column: 49,
																	Line:   157,
																},
															},
														},
														Name: "measurement",
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   157,
															},
															File:   "tickscript.flux",
															Source: "r",
															Start: ast.Position{
																Column: 28,
																Line:   157,
															},
														},
													},
													Name: "r",
												},
											},
											Lparen: nil,
											Rparen: nil,
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   157,
													},
													File:   "tickscript.flux",
													Source: "r",
													Start: ast.Position{
														Column: 19,
														Line:   157,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   157,
														},
														File:   "tickscript.flux",
														Source: "r",
														Start: ast.Position{
															Column: 19,
															Line:   157,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   157,
									},
									File:   "tickscript.flux",
									Source: "map(fn: (r) => ({ r with _measurement: measurement }))",
									Start: ast.Position{
										Column: 10,
										Line:   157,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   157,
										},
										File:   "tickscript.flux",
										Source: "map",
										Start: ast.Position{
											Column: 10,
											Line:   157,
										},
									},
								},
								Name: "map",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   158,
							},
							File:   "tickscript.flux",
							Source: "universe.join(tables: tables, on: on)\n      |> map(fn: (r) => ({ r with _measurement: measurement }))\n      |> experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
							Start: ast.Position{
								Column: 5,
								Line:   156,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   158,
									},
									File:   "tickscript.flux",
									Source: "columns: [\"_measurement\"], mode: \"extend\"",
									Start: ast.Position{
										Column: 29,
										Line:   158,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   158,
										},
										File:   "tickscript.flux",
										Source: "columns: [\"_measurement\"]",
										Start: ast.Position{
											Column: 29,
											Line:   158,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   158,
											},
											File:   "tickscript.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 29,
												Line:   158,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   158,
											},
											File:   "tickscript.flux",
											Source: "[\"_measurement\"]",
											Start: ast.Position{
												Column: 38,
												Line:   158,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   158,
												},
												File:   "tickscript.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 39,
													Line:   158,
												},
											},
										},
										Value: "_measurement",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   158,
										},
										File:   "tickscript.flux",
										Source: "mode: \"extend\"",
										Start: ast.Position{
											Column: 56,
											Line:   158,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   158,
											},
											File:   "tickscript.flux",
											Source: "mode",
											Start: ast.Position{
												Column: 56,
												Line:   158,
											},
										},
									},
									Name: "mode",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   158,
											},
											File:   "tickscript.flux",
											Source: "\"extend\"",
											Start: ast.Position{
												Column: 62,
												Line:   158,
											},
										},
									},
									Value: "extend",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   158,
								},
								File:   "tickscript.flux",
								Source: "experimental.group(columns: [\"_measurement\"], mode: \"extend\")",
								Start: ast.Position{
									Column: 10,
									Line:   158,
								},
							},
						},
						Callee: &ast.MemberExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   158,
									},
									File:   "tickscript.flux",
									Source: "experimental.group",
									Start: ast.Position{
										Column: 10,
										Line:   158,
									},
								},
							},
							Lbrack: nil,
							Object: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   158,
										},
										File:   "tickscript.flux",
										Source: "experimental",
										Start: ast.Position{
											Column: 10,
											Line:   158,
										},
									},
								},
								Name: "experimental",
							},
							Property: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   158,
										},
										File:   "tickscript.flux",
										Source: "group",
										Start: ast.Position{
											Column: 23,
											Line:   158,
										},
									},
								},
								Name: "group",
							},
							Rbrack: nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   155,
							},
							File:   "tickscript.flux",
							Source: "tables",
							Start: ast.Position{
								Column: 9,
								Line:   155,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   155,
								},
								File:   "tickscript.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   155,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   155,
							},
							File:   "tickscript.flux",
							Source: "on=[\"_time\"]",
							Start: ast.Position{
								Column: 17,
								Line:   155,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   155,
								},
								File:   "tickscript.flux",
								Source: "on",
								Start: ast.Position{
									Column: 17,
									Line:   155,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   155,
								},
								File:   "tickscript.flux",
								Source: "[\"_time\"]",
								Start: ast.Position{
									Column: 20,
									Line:   155,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   155,
									},
									File:   "tickscript.flux",
									Source: "\"_time\"",
									Start: ast.Position{
										Column: 21,
										Line:   155,
									},
								},
							},
							Value: "_time",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   155,
							},
							File:   "tickscript.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 31,
								Line:   155,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   155,
								},
								File:   "tickscript.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 31,
									Line:   155,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: []ast.Comment{ast.Comment{Text: "// required by monitor.check\n"}},
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   3,
					},
					File:   "tickscript.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   3,
						},
						File:   "tickscript.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "experimental",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   4,
					},
					File:   "tickscript.flux",
					Source: "import \"experimental/array\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   4,
						},
						File:   "tickscript.flux",
						Source: "\"experimental/array\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental/array",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   5,
					},
					File:   "tickscript.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   5,
						},
						File:   "tickscript.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 37,
						Line:   6,
					},
					File:   "tickscript.flux",
					Source: "import \"influxdata/influxdb/monitor\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   6,
						},
						File:   "tickscript.flux",
						Source: "\"influxdata/influxdb/monitor\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "influxdata/influxdb/monitor",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   7,
					},
					File:   "tickscript.flux",
					Source: "import \"influxdata/influxdb/schema\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   7,
						},
						File:   "tickscript.flux",
						Source: "\"influxdata/influxdb/schema\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "influxdata/influxdb/schema",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   8,
					},
					File:   "tickscript.flux",
					Source: "import \"universe\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   8,
						},
						File:   "tickscript.flux",
						Source: "\"universe\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				Value: "universe",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "tickscript.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   1,
					},
					File:   "tickscript.flux",
					Source: "package tickscript",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   1,
						},
						File:   "tickscript.flux",
						Source: "tickscript",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "tickscript",
			},
		},
	}},
	Package: "tickscript",
	Path:    "contrib/bonitoo-io/tickscript",
}
