// DO NOT EDIT: This file is autogenerated via the builtin command.

package discord

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   47,
				},
				File:   "discord.flux",
				Source: "package discord\n\nimport \"http\"\nimport \"json\"\n\noption discordURL = \"https://discordapp.com/api/webhooks/\"\n \n// `webhookToken` - string - the secure token of the webhook.\n// `webhookID` - string - the ID of the webhook.\n// `username` - string - username posting the message.\n// `content` - string - the text to display in discord.\n// `avatar_url` -  override the default avatar of the webhook.\nsend = (webhookToken, webhookID, username, content, avatar_url=\"\") => {\n  data = {\n      username: username,\n      content: content,\n      avatar_url: avatar_url\n    }\n\n  headers = {\n      \"Content-Type\": \"application/json\"\n    }\n  encode = json.encode(v:data)\n\n  return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send messages to discord for each table row.\n// `webhookToken` - string - the secure token of the webhook.\n// `webhookID` - string - the ID of the webhook.\n// `username` - string - username posting the message.\n// `avatar_url` -  override the default avatar of the webhook.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `content`, as defined in the `send` function arguments.\nendpoint = (webhookToken, webhookID, username, avatar_url=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   6,
						},
						File:   "discord.flux",
						Source: "discordURL = \"https://discordapp.com/api/webhooks/\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   6,
							},
							File:   "discord.flux",
							Source: "discordURL",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "discordURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   6,
							},
							File:   "discord.flux",
							Source: "\"https://discordapp.com/api/webhooks/\"",
							Start: ast.Position{
								Column: 21,
								Line:   6,
							},
						},
					},
					Value: "https://discordapp.com/api/webhooks/",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 59,
						Line:   6,
					},
					File:   "discord.flux",
					Source: "option discordURL = \"https://discordapp.com/api/webhooks/\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "discord.flux",
					Source: "send = (webhookToken, webhookID, username, content, avatar_url=\"\") => {\n  data = {\n      username: username,\n      content: content,\n      avatar_url: avatar_url\n    }\n\n  headers = {\n      \"Content-Type\": \"application/json\"\n    }\n  encode = json.encode(v:data)\n\n  return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `webhookToken` - string - the secure token of the webhook.\n"}, ast.Comment{Text: "// `webhookID` - string - the ID of the webhook.\n"}, ast.Comment{Text: "// `username` - string - username posting the message.\n"}, ast.Comment{Text: "// `content` - string - the text to display in discord.\n"}, ast.Comment{Text: "// `avatar_url` -  override the default avatar of the webhook.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   13,
						},
						File:   "discord.flux",
						Source: "send",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "send",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "discord.flux",
						Source: "(webhookToken, webhookID, username, content, avatar_url=\"\") => {\n  data = {\n      username: username,\n      content: content,\n      avatar_url: avatar_url\n    }\n\n  headers = {\n      \"Content-Type\": \"application/json\"\n    }\n  encode = json.encode(v:data)\n\n  return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}",
						Start: ast.Position{
							Column: 8,
							Line:   13,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   26,
							},
							File:   "discord.flux",
							Source: "{\n  data = {\n      username: username,\n      content: content,\n      avatar_url: avatar_url\n    }\n\n  headers = {\n      \"Content-Type\": \"application/json\"\n    }\n  encode = json.encode(v:data)\n\n  return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)\n}",
							Start: ast.Position{
								Column: 71,
								Line:   13,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   18,
								},
								File:   "discord.flux",
								Source: "data = {\n      username: username,\n      content: content,\n      avatar_url: avatar_url\n    }",
								Start: ast.Position{
									Column: 3,
									Line:   14,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   14,
									},
									File:   "discord.flux",
									Source: "data",
									Start: ast.Position{
										Column: 3,
										Line:   14,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   18,
									},
									File:   "discord.flux",
									Source: "{\n      username: username,\n      content: content,\n      avatar_url: avatar_url\n    }",
									Start: ast.Position{
										Column: 10,
										Line:   14,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   15,
										},
										File:   "discord.flux",
										Source: "username: username",
										Start: ast.Position{
											Column: 7,
											Line:   15,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   15,
											},
											File:   "discord.flux",
											Source: "username",
											Start: ast.Position{
												Column: 7,
												Line:   15,
											},
										},
									},
									Name: "username",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   15,
											},
											File:   "discord.flux",
											Source: "username",
											Start: ast.Position{
												Column: 17,
												Line:   15,
											},
										},
									},
									Name: "username",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   16,
										},
										File:   "discord.flux",
										Source: "content: content",
										Start: ast.Position{
											Column: 7,
											Line:   16,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   16,
											},
											File:   "discord.flux",
											Source: "content",
											Start: ast.Position{
												Column: 7,
												Line:   16,
											},
										},
									},
									Name: "content",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   16,
											},
											File:   "discord.flux",
											Source: "content",
											Start: ast.Position{
												Column: 16,
												Line:   16,
											},
										},
									},
									Name: "content",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   17,
										},
										File:   "discord.flux",
										Source: "avatar_url: avatar_url",
										Start: ast.Position{
											Column: 7,
											Line:   17,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   17,
											},
											File:   "discord.flux",
											Source: "avatar_url",
											Start: ast.Position{
												Column: 7,
												Line:   17,
											},
										},
									},
									Name: "avatar_url",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   17,
											},
											File:   "discord.flux",
											Source: "avatar_url",
											Start: ast.Position{
												Column: 19,
												Line:   17,
											},
										},
									},
									Name: "avatar_url",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   22,
								},
								File:   "discord.flux",
								Source: "headers = {\n      \"Content-Type\": \"application/json\"\n    }",
								Start: ast.Position{
									Column: 3,
									Line:   20,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   20,
									},
									File:   "discord.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 3,
										Line:   20,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   22,
									},
									File:   "discord.flux",
									Source: "{\n      \"Content-Type\": \"application/json\"\n    }",
									Start: ast.Position{
										Column: 13,
										Line:   20,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   21,
										},
										File:   "discord.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 7,
											Line:   21,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   21,
											},
											File:   "discord.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 7,
												Line:   21,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   21,
											},
											File:   "discord.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 23,
												Line:   21,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   23,
								},
								File:   "discord.flux",
								Source: "encode = json.encode(v:data)",
								Start: ast.Position{
									Column: 3,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   23,
									},
									File:   "discord.flux",
									Source: "encode",
									Start: ast.Position{
										Column: 3,
										Line:   23,
									},
								},
							},
							Name: "encode",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   23,
										},
										File:   "discord.flux",
										Source: "v:data",
										Start: ast.Position{
											Column: 24,
											Line:   23,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   23,
											},
											File:   "discord.flux",
											Source: "v:data",
											Start: ast.Position{
												Column: 24,
												Line:   23,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   23,
												},
												File:   "discord.flux",
												Source: "v",
												Start: ast.Position{
													Column: 24,
													Line:   23,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   23,
												},
												File:   "discord.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   23,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   23,
									},
									File:   "discord.flux",
									Source: "json.encode(v:data)",
									Start: ast.Position{
										Column: 12,
										Line:   23,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   23,
										},
										File:   "discord.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 12,
											Line:   23,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   23,
											},
											File:   "discord.flux",
											Source: "json",
											Start: ast.Position{
												Column: 12,
												Line:   23,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   23,
											},
											File:   "discord.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 17,
												Line:   23,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   25,
										},
										File:   "discord.flux",
										Source: "headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode",
										Start: ast.Position{
											Column: 20,
											Line:   25,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   25,
											},
											File:   "discord.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 20,
												Line:   25,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   25,
												},
												File:   "discord.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 20,
													Line:   25,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   25,
												},
												File:   "discord.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 29,
													Line:   25,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   25,
											},
											File:   "discord.flux",
											Source: "url: discordURL + webhookID + \"/\" + webhookToken",
											Start: ast.Position{
												Column: 38,
												Line:   25,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   25,
												},
												File:   "discord.flux",
												Source: "url",
												Start: ast.Position{
													Column: 38,
													Line:   25,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   25,
												},
												File:   "discord.flux",
												Source: "discordURL + webhookID + \"/\" + webhookToken",
												Start: ast.Position{
													Column: 43,
													Line:   25,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   25,
													},
													File:   "discord.flux",
													Source: "discordURL + webhookID + \"/\"",
													Start: ast.Position{
														Column: 43,
														Line:   25,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   25,
														},
														File:   "discord.flux",
														Source: "discordURL + webhookID",
														Start: ast.Position{
															Column: 43,
															Line:   25,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   25,
															},
															File:   "discord.flux",
															Source: "discordURL",
															Start: ast.Position{
																Column: 43,
																Line:   25,
															},
														},
													},
													Name: "discordURL",
												},
												Operator: 5,
												Right: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   25,
															},
															File:   "discord.flux",
															Source: "webhookID",
															Start: ast.Position{
																Column: 56,
																Line:   25,
															},
														},
													},
													Name: "webhookID",
												},
											},
											Operator: 5,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   25,
														},
														File:   "discord.flux",
														Source: "\"/\"",
														Start: ast.Position{
															Column: 68,
															Line:   25,
														},
													},
												},
												Value: "/",
											},
										},
										Operator: 5,
										Right: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   25,
													},
													File:   "discord.flux",
													Source: "webhookToken",
													Start: ast.Position{
														Column: 74,
														Line:   25,
													},
												},
											},
											Name: "webhookToken",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   25,
											},
											File:   "discord.flux",
											Source: "data: encode",
											Start: ast.Position{
												Column: 88,
												Line:   25,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 92,
													Line:   25,
												},
												File:   "discord.flux",
												Source: "data",
												Start: ast.Position{
													Column: 88,
													Line:   25,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   25,
												},
												File:   "discord.flux",
												Source: "encode",
												Start: ast.Position{
													Column: 94,
													Line:   25,
												},
											},
										},
										Name: "encode",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   25,
									},
									File:   "discord.flux",
									Source: "http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)",
									Start: ast.Position{
										Column: 10,
										Line:   25,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   25,
										},
										File:   "discord.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 10,
											Line:   25,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   25,
											},
											File:   "discord.flux",
											Source: "http",
											Start: ast.Position{
												Column: 10,
												Line:   25,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   25,
											},
											File:   "discord.flux",
											Source: "post",
											Start: ast.Position{
												Column: 15,
												Line:   25,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   25,
								},
								File:   "discord.flux",
								Source: "return http.post(headers: headers, url: discordURL + webhookID + \"/\" + webhookToken, data: encode)",
								Start: ast.Position{
									Column: 3,
									Line:   25,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   13,
							},
							File:   "discord.flux",
							Source: "webhookToken",
							Start: ast.Position{
								Column: 9,
								Line:   13,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   13,
								},
								File:   "discord.flux",
								Source: "webhookToken",
								Start: ast.Position{
									Column: 9,
									Line:   13,
								},
							},
						},
						Name: "webhookToken",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   13,
							},
							File:   "discord.flux",
							Source: "webhookID",
							Start: ast.Position{
								Column: 23,
								Line:   13,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   13,
								},
								File:   "discord.flux",
								Source: "webhookID",
								Start: ast.Position{
									Column: 23,
									Line:   13,
								},
							},
						},
						Name: "webhookID",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   13,
							},
							File:   "discord.flux",
							Source: "username",
							Start: ast.Position{
								Column: 34,
								Line:   13,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   13,
								},
								File:   "discord.flux",
								Source: "username",
								Start: ast.Position{
									Column: 34,
									Line:   13,
								},
							},
						},
						Name: "username",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   13,
							},
							File:   "discord.flux",
							Source: "content",
							Start: ast.Position{
								Column: 44,
								Line:   13,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   13,
								},
								File:   "discord.flux",
								Source: "content",
								Start: ast.Position{
									Column: 44,
									Line:   13,
								},
							},
						},
						Name: "content",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   13,
							},
							File:   "discord.flux",
							Source: "avatar_url=\"\"",
							Start: ast.Position{
								Column: 53,
								Line:   13,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   13,
								},
								File:   "discord.flux",
								Source: "avatar_url",
								Start: ast.Position{
									Column: 53,
									Line:   13,
								},
							},
						},
						Name: "avatar_url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   13,
								},
								File:   "discord.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 64,
									Line:   13,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   47,
					},
					File:   "discord.flux",
					Source: "endpoint = (webhookToken, webhookID, username, avatar_url=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send messages to discord for each table row.\n"}, ast.Comment{Text: "// `webhookToken` - string - the secure token of the webhook.\n"}, ast.Comment{Text: "// `webhookID` - string - the ID of the webhook.\n"}, ast.Comment{Text: "// `username` - string - username posting the message.\n"}, ast.Comment{Text: "// `avatar_url` -  override the default avatar of the webhook.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `content`, as defined in the `send` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   35,
						},
						File:   "discord.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   47,
						},
						File:   "discord.flux",
						Source: "(webhookToken, webhookID, username, avatar_url=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   35,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   47,
							},
							File:   "discord.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   36,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   47,
								},
								File:   "discord.flux",
								Source: "(tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   37,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   37,
										},
										File:   "discord.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 24,
											Line:   37,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   47,
									},
									File:   "discord.flux",
									Source: "tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   37,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   47,
											},
											File:   "discord.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   38,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   47,
												},
												File:   "discord.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   38,
													},
													File:   "discord.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   38,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   47,
													},
													File:   "discord.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   38,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   47,
														},
														File:   "discord.flux",
														Source: "{\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   38,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   39,
															},
															File:   "discord.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   39,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   39,
																},
																File:   "discord.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   39,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   39,
																	},
																	File:   "discord.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   39,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   39,
																		},
																		File:   "discord.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   39,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   39,
																			},
																			File:   "discord.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   39,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   39,
																			},
																			File:   "discord.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   39,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   39,
																},
																File:   "discord.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   39,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   39,
																	},
																	File:   "discord.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   39,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   46,
																},
																File:   "discord.flux",
																Source: "{r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}",
																Start: ast.Position{
																	Column: 24,
																	Line:   40,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   46,
																	},
																	File:   "discord.flux",
																	Source: "_sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)",
																	Start: ast.Position{
																		Column: 32,
																		Line:   40,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   40,
																		},
																		File:   "discord.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   40,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   46,
																			},
																			File:   "discord.flux",
																			Source: "v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100",
																			Start: ast.Position{
																				Column: 46,
																				Line:   40,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   46,
																				},
																				File:   "discord.flux",
																				Source: "v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100",
																				Start: ast.Position{
																					Column: 46,
																					Line:   40,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   40,
																					},
																					File:   "discord.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   40,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   46,
																					},
																					File:   "discord.flux",
																					Source: "2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100",
																					Start: ast.Position{
																						Column: 49,
																						Line:   40,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   40,
																						},
																						File:   "discord.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   40,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   46,
																						},
																						File:   "discord.flux",
																						Source: "send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100",
																						Start: ast.Position{
																							Column: 54,
																							Line:   40,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 41,
																									Line:   45,
																								},
																								File:   "discord.flux",
																								Source: "webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content",
																								Start: ast.Position{
																									Column: 21,
																									Line:   41,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   41,
																									},
																									File:   "discord.flux",
																									Source: "webhookToken: webhookToken",
																									Start: ast.Position{
																										Column: 21,
																										Line:   41,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   41,
																										},
																										File:   "discord.flux",
																										Source: "webhookToken",
																										Start: ast.Position{
																											Column: 21,
																											Line:   41,
																										},
																									},
																								},
																								Name: "webhookToken",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   41,
																										},
																										File:   "discord.flux",
																										Source: "webhookToken",
																										Start: ast.Position{
																											Column: 35,
																											Line:   41,
																										},
																									},
																								},
																								Name: "webhookToken",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   42,
																									},
																									File:   "discord.flux",
																									Source: "webhookID: webhookID",
																									Start: ast.Position{
																										Column: 21,
																										Line:   42,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   42,
																										},
																										File:   "discord.flux",
																										Source: "webhookID",
																										Start: ast.Position{
																											Column: 21,
																											Line:   42,
																										},
																									},
																								},
																								Name: "webhookID",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   42,
																										},
																										File:   "discord.flux",
																										Source: "webhookID",
																										Start: ast.Position{
																											Column: 32,
																											Line:   42,
																										},
																									},
																								},
																								Name: "webhookID",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   43,
																									},
																									File:   "discord.flux",
																									Source: "username: username",
																									Start: ast.Position{
																										Column: 21,
																										Line:   43,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   43,
																										},
																										File:   "discord.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 21,
																											Line:   43,
																										},
																									},
																								},
																								Name: "username",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   43,
																										},
																										File:   "discord.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 31,
																											Line:   43,
																										},
																									},
																								},
																								Name: "username",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   44,
																									},
																									File:   "discord.flux",
																									Source: "avatar_url: avatar_url",
																									Start: ast.Position{
																										Column: 21,
																										Line:   44,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   44,
																										},
																										File:   "discord.flux",
																										Source: "avatar_url",
																										Start: ast.Position{
																											Column: 21,
																											Line:   44,
																										},
																									},
																								},
																								Name: "avatar_url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   44,
																										},
																										File:   "discord.flux",
																										Source: "avatar_url",
																										Start: ast.Position{
																											Column: 33,
																											Line:   44,
																										},
																									},
																								},
																								Name: "avatar_url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   45,
																									},
																									File:   "discord.flux",
																									Source: "content: obj.content",
																									Start: ast.Position{
																										Column: 21,
																										Line:   45,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   45,
																										},
																										File:   "discord.flux",
																										Source: "content",
																										Start: ast.Position{
																											Column: 21,
																											Line:   45,
																										},
																									},
																								},
																								Name: "content",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   45,
																										},
																										File:   "discord.flux",
																										Source: "obj.content",
																										Start: ast.Position{
																											Column: 30,
																											Line:   45,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 33,
																												Line:   45,
																											},
																											File:   "discord.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 30,
																												Line:   45,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   45,
																											},
																											File:   "discord.flux",
																											Source: "content",
																											Start: ast.Position{
																												Column: 34,
																												Line:   45,
																											},
																										},
																									},
																									Name: "content",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 18,
																								Line:   46,
																							},
																							File:   "discord.flux",
																							Source: "send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                )",
																							Start: ast.Position{
																								Column: 54,
																								Line:   40,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 58,
																									Line:   40,
																								},
																								File:   "discord.flux",
																								Source: "send",
																								Start: ast.Position{
																									Column: 54,
																									Line:   40,
																								},
																							},
																						},
																						Name: "send",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   46,
																							},
																							File:   "discord.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 21,
																								Line:   46,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   46,
																		},
																		File:   "discord.flux",
																		Source: "string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)",
																		Start: ast.Position{
																			Column: 39,
																			Line:   40,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   40,
																			},
																			File:   "discord.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   40,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   40,
																	},
																	File:   "discord.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   40,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   46,
															},
															File:   "discord.flux",
															Source: "return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}",
															Start: ast.Position{
																Column: 17,
																Line:   40,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   38,
														},
														File:   "discord.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   38,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   38,
															},
															File:   "discord.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   38,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   47,
										},
										File:   "discord.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == send(\n                    webhookToken: webhookToken,\n                    webhookID: webhookID,\n                    username: username,\n                    avatar_url: avatar_url,\n                    content: obj.content,\n                ) / 100)}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   38,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   38,
											},
											File:   "discord.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   38,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   37,
									},
									File:   "discord.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   37,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   37,
										},
										File:   "discord.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   37,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   37,
									},
									File:   "discord.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   37,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   36,
								},
								File:   "discord.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   36,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   36,
									},
									File:   "discord.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   36,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   35,
							},
							File:   "discord.flux",
							Source: "webhookToken",
							Start: ast.Position{
								Column: 13,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   35,
								},
								File:   "discord.flux",
								Source: "webhookToken",
								Start: ast.Position{
									Column: 13,
									Line:   35,
								},
							},
						},
						Name: "webhookToken",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   35,
							},
							File:   "discord.flux",
							Source: "webhookID",
							Start: ast.Position{
								Column: 27,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   35,
								},
								File:   "discord.flux",
								Source: "webhookID",
								Start: ast.Position{
									Column: 27,
									Line:   35,
								},
							},
						},
						Name: "webhookID",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   35,
							},
							File:   "discord.flux",
							Source: "username",
							Start: ast.Position{
								Column: 38,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   35,
								},
								File:   "discord.flux",
								Source: "username",
								Start: ast.Position{
									Column: 38,
									Line:   35,
								},
							},
						},
						Name: "username",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   35,
							},
							File:   "discord.flux",
							Source: "avatar_url=\"\"",
							Start: ast.Position{
								Column: 48,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   35,
								},
								File:   "discord.flux",
								Source: "avatar_url",
								Start: ast.Position{
									Column: 48,
									Line:   35,
								},
							},
						},
						Name: "avatar_url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   35,
								},
								File:   "discord.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 59,
									Line:   35,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "discord.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "discord.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "discord.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "discord.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "discord.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   1,
					},
					File:   "discord.flux",
					Source: "package discord",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   1,
						},
						File:   "discord.flux",
						Source: "discord",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "discord",
			},
		},
	}},
	Package: "discord",
	Path:    "contrib/chobbs/discord",
}
