// DO NOT EDIT: This file is autogenerated via the builtin command.

package opsgenie

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   74,
				},
				File:   "opsgenie.flux",
				Source: "package opsgenie\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// respondersToJSON converts an array of responder strings to JSON array that can be embedded into an alert message\nbuiltin respondersToJSON : (v: [string]) => string\n\n// `sendAlert` sends a message that creates an alert in Opsgenie. See https://docs.opsgenie.com/docs/alert-api#create-alert for details.\n// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n// `apiKey`      - string - API Authorization key. \n// `message`     - string - Alert message text, at most 130 characters. \n// `alias`       - string - Opsgenie alias, at most 250 characters that are used to de-deduplicate alerts. Defaults to message. \n// `description` - string - Description field of an alert, at most 15000 characters. Optional. \n// `priority`    - string - \"P1\", \"P2\", \"P3\", \"P4\" or \"P5\". Defaults to \"P3\". \n// `responders`  - array  - Array of strings to identify responder teams or teams, a 'user:' prefix is used for users, 'teams:' prefix for teams. \n// `tags`        - array  - Array of string tags. Optional. \n// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n// `actions`     - array  - Array of strings that specifies actions that will be available for the alert. \n// `details`     - string - Additional details of an alert, it must be a JSON-encoded map of key-value string pairs. \n// `visibleTo`   - array  - Arrays of teams and users that the alert will become visible to without sending any notification. Optional. \nsendAlert = (url=\"https://api.opsgenie.com/v2/alerts\", apiKey, message, alias=\"\", description=\"\", priority=\"P3\", responders=[], tags=[], entity=\"\", actions=[], visibleTo=[], details=\"{}\") => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey\n    }\n    cutEncode = (v, max, defV = \"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v:message,max:130)},\n\\\"alias\\\": ${cutEncode(v:alias,max:512,defV: message)},\n\\\"description\\\": ${cutEncode(v:description,max:15000)},\n\\\"responders\\\": ${respondersToJSON(v:responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v:visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v:actions))},\n\\\"tags\\\": ${string(v: json.encode(v:tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v:entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v:priority, max: 2)}\n}\"\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send alerts to opsgenie for each table row.\n// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n// `apiKey`      - string - API Authorization key. \n// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with all properties defined in the `sendAlert` function arguments (except url, apiKey and entity).\nendpoint = (url=\"https://api.opsgenie.com/v2/alerts\", apiKey, entity = \"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// respondersToJSON converts an array of responder strings to JSON array that can be embedded into an alert message\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   8,
					},
					File:   "opsgenie.flux",
					Source: "builtin respondersToJSON",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   8,
						},
						File:   "opsgenie.flux",
						Source: "respondersToJSON",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Name: "respondersToJSON",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   8,
						},
						File:   "opsgenie.flux",
						Source: "(v: [string]) => string",
						Start: ast.Position{
							Column: 28,
							Line:   8,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   8,
							},
							File:   "opsgenie.flux",
							Source: "(v: [string]) => string",
							Start: ast.Position{
								Column: 28,
								Line:   8,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "opsgenie.flux",
								Source: "v: [string]",
								Start: ast.Position{
									Column: 29,
									Line:   8,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   8,
									},
									File:   "opsgenie.flux",
									Source: "v",
									Start: ast.Position{
										Column: 29,
										Line:   8,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   8,
									},
									File:   "opsgenie.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 32,
										Line:   8,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   8,
										},
										File:   "opsgenie.flux",
										Source: "string",
										Start: ast.Position{
											Column: 33,
											Line:   8,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   8,
											},
											File:   "opsgenie.flux",
											Source: "string",
											Start: ast.Position{
												Column: 33,
												Line:   8,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   8,
								},
								File:   "opsgenie.flux",
								Source: "string",
								Start: ast.Position{
									Column: 45,
									Line:   8,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   8,
									},
									File:   "opsgenie.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   8,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   47,
					},
					File:   "opsgenie.flux",
					Source: "sendAlert = (url=\"https://api.opsgenie.com/v2/alerts\", apiKey, message, alias=\"\", description=\"\", priority=\"P3\", responders=[], tags=[], entity=\"\", actions=[], visibleTo=[], details=\"{}\") => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey\n    }\n    cutEncode = (v, max, defV = \"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v:message,max:130)},\n\\\"alias\\\": ${cutEncode(v:alias,max:512,defV: message)},\n\\\"description\\\": ${cutEncode(v:description,max:15000)},\n\\\"responders\\\": ${respondersToJSON(v:responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v:visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v:actions))},\n\\\"tags\\\": ${string(v: json.encode(v:tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v:entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v:priority, max: 2)}\n}\"\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `sendAlert` sends a message that creates an alert in Opsgenie. See https://docs.opsgenie.com/docs/alert-api#create-alert for details.\n"}, ast.Comment{Text: "// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n"}, ast.Comment{Text: "// `apiKey`      - string - API Authorization key. \n"}, ast.Comment{Text: "// `message`     - string - Alert message text, at most 130 characters. \n"}, ast.Comment{Text: "// `alias`       - string - Opsgenie alias, at most 250 characters that are used to de-deduplicate alerts. Defaults to message. \n"}, ast.Comment{Text: "// `description` - string - Description field of an alert, at most 15000 characters. Optional. \n"}, ast.Comment{Text: "// `priority`    - string - \"P1\", \"P2\", \"P3\", \"P4\" or \"P5\". Defaults to \"P3\". \n"}, ast.Comment{Text: "// `responders`  - array  - Array of strings to identify responder teams or teams, a 'user:' prefix is used for users, 'teams:' prefix for teams. \n"}, ast.Comment{Text: "// `tags`        - array  - Array of string tags. Optional. \n"}, ast.Comment{Text: "// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n"}, ast.Comment{Text: "// `actions`     - array  - Array of strings that specifies actions that will be available for the alert. \n"}, ast.Comment{Text: "// `details`     - string - Additional details of an alert, it must be a JSON-encoded map of key-value string pairs. \n"}, ast.Comment{Text: "// `visibleTo`   - array  - Arrays of teams and users that the alert will become visible to without sending any notification. Optional. \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   23,
						},
						File:   "opsgenie.flux",
						Source: "sendAlert",
						Start: ast.Position{
							Column: 1,
							Line:   23,
						},
					},
				},
				Name: "sendAlert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   47,
						},
						File:   "opsgenie.flux",
						Source: "(url=\"https://api.opsgenie.com/v2/alerts\", apiKey, message, alias=\"\", description=\"\", priority=\"P3\", responders=[], tags=[], entity=\"\", actions=[], visibleTo=[], details=\"{}\") => {\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey\n    }\n    cutEncode = (v, max, defV = \"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v:message,max:130)},\n\\\"alias\\\": ${cutEncode(v:alias,max:512,defV: message)},\n\\\"description\\\": ${cutEncode(v:description,max:15000)},\n\\\"responders\\\": ${respondersToJSON(v:responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v:visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v:actions))},\n\\\"tags\\\": ${string(v: json.encode(v:tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v:entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v:priority, max: 2)}\n}\"\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
						Start: ast.Position{
							Column: 13,
							Line:   23,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   47,
							},
							File:   "opsgenie.flux",
							Source: "{\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey\n    }\n    cutEncode = (v, max, defV = \"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }\n    body = \"{\n\\\"message\\\": ${cutEncode(v:message,max:130)},\n\\\"alias\\\": ${cutEncode(v:alias,max:512,defV: message)},\n\\\"description\\\": ${cutEncode(v:description,max:15000)},\n\\\"responders\\\": ${respondersToJSON(v:responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v:visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v:actions))},\n\\\"tags\\\": ${string(v: json.encode(v:tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v:entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v:priority, max: 2)}\n}\"\n    return http.post(headers: headers, url: url, data: bytes(v: body))\n}",
							Start: ast.Position{
								Column: 192,
								Line:   23,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   27,
								},
								File:   "opsgenie.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   24,
									},
									File:   "opsgenie.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   24,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   27,
									},
									File:   "opsgenie.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n        \"Authorization\": \"GenieKey \" + apiKey\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   24,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   25,
										},
										File:   "opsgenie.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   25,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   25,
											},
											File:   "opsgenie.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   25,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   25,
											},
											File:   "opsgenie.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   25,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   26,
										},
										File:   "opsgenie.flux",
										Source: "\"Authorization\": \"GenieKey \" + apiKey",
										Start: ast.Position{
											Column: 9,
											Line:   26,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   26,
											},
											File:   "opsgenie.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   26,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   26,
											},
											File:   "opsgenie.flux",
											Source: "\"GenieKey \" + apiKey",
											Start: ast.Position{
												Column: 26,
												Line:   26,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   26,
												},
												File:   "opsgenie.flux",
												Source: "\"GenieKey \"",
												Start: ast.Position{
													Column: 26,
													Line:   26,
												},
											},
										},
										Value: "GenieKey ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   26,
												},
												File:   "opsgenie.flux",
												Source: "apiKey",
												Start: ast.Position{
													Column: 40,
													Line:   26,
												},
											},
										},
										Name: "apiKey",
									},
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   33,
								},
								File:   "opsgenie.flux",
								Source: "cutEncode = (v, max, defV = \"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   28,
									},
									File:   "opsgenie.flux",
									Source: "cutEncode",
									Start: ast.Position{
										Column: 5,
										Line:   28,
									},
								},
							},
							Name: "cutEncode",
						},
						Init: &ast.FunctionExpression{
							Arrow: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   33,
									},
									File:   "opsgenie.flux",
									Source: "(v, max, defV = \"\") => {\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }",
									Start: ast.Position{
										Column: 17,
										Line:   28,
									},
								},
							},
							Body: &ast.Block{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   33,
										},
										File:   "opsgenie.flux",
										Source: "{\n        v2 = if strings.strlen(v: v) != 0 then v else defV\n        return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))\n    }",
										Start: ast.Position{
											Column: 40,
											Line:   28,
										},
									},
								},
								Body: []ast.Statement{&ast.VariableAssignment{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   29,
											},
											File:   "opsgenie.flux",
											Source: "v2 = if strings.strlen(v: v) != 0 then v else defV",
											Start: ast.Position{
												Column: 9,
												Line:   29,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   29,
												},
												File:   "opsgenie.flux",
												Source: "v2",
												Start: ast.Position{
													Column: 9,
													Line:   29,
												},
											},
										},
										Name: "v2",
									},
									Init: &ast.ConditionalExpression{
										Alternate: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   29,
													},
													File:   "opsgenie.flux",
													Source: "defV",
													Start: ast.Position{
														Column: 55,
														Line:   29,
													},
												},
											},
											Name: "defV",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   29,
												},
												File:   "opsgenie.flux",
												Source: "if strings.strlen(v: v) != 0 then v else defV",
												Start: ast.Position{
													Column: 14,
													Line:   29,
												},
											},
										},
										Consequent: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   29,
													},
													File:   "opsgenie.flux",
													Source: "v",
													Start: ast.Position{
														Column: 48,
														Line:   29,
													},
												},
											},
											Name: "v",
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   29,
													},
													File:   "opsgenie.flux",
													Source: "strings.strlen(v: v) != 0",
													Start: ast.Position{
														Column: 17,
														Line:   29,
													},
												},
											},
											Left: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   29,
															},
															File:   "opsgenie.flux",
															Source: "v: v",
															Start: ast.Position{
																Column: 32,
																Line:   29,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   29,
																},
																File:   "opsgenie.flux",
																Source: "v: v",
																Start: ast.Position{
																	Column: 32,
																	Line:   29,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   29,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 32,
																		Line:   29,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   29,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 35,
																		Line:   29,
																	},
																},
															},
															Name: "v",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   29,
														},
														File:   "opsgenie.flux",
														Source: "strings.strlen(v: v)",
														Start: ast.Position{
															Column: 17,
															Line:   29,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   29,
															},
															File:   "opsgenie.flux",
															Source: "strings.strlen",
															Start: ast.Position{
																Column: 17,
																Line:   29,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   29,
																},
																File:   "opsgenie.flux",
																Source: "strings",
																Start: ast.Position{
																	Column: 17,
																	Line:   29,
																},
															},
														},
														Name: "strings",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   29,
																},
																File:   "opsgenie.flux",
																Source: "strlen",
																Start: ast.Position{
																	Column: 25,
																	Line:   29,
																},
															},
														},
														Name: "strlen",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Operator: 18,
											Right: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   29,
														},
														File:   "opsgenie.flux",
														Source: "0",
														Start: ast.Position{
															Column: 41,
															Line:   29,
														},
													},
												},
												Value: int64(0),
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
								}, &ast.ReturnStatement{
									Argument: &ast.ConditionalExpression{
										Alternate: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   32,
														},
														File:   "opsgenie.flux",
														Source: "v: json.encode(v:v2)",
														Start: ast.Position{
															Column: 29,
															Line:   32,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   32,
															},
															File:   "opsgenie.flux",
															Source: "v: json.encode(v:v2)",
															Start: ast.Position{
																Column: 29,
																Line:   32,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   32,
																},
																File:   "opsgenie.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 29,
																	Line:   32,
																},
															},
														},
														Name: "v",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   32,
																	},
																	File:   "opsgenie.flux",
																	Source: "v:v2",
																	Start: ast.Position{
																		Column: 44,
																		Line:   32,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   32,
																		},
																		File:   "opsgenie.flux",
																		Source: "v:v2",
																		Start: ast.Position{
																			Column: 44,
																			Line:   32,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   32,
																			},
																			File:   "opsgenie.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 44,
																				Line:   32,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 48,
																				Line:   32,
																			},
																			File:   "opsgenie.flux",
																			Source: "v2",
																			Start: ast.Position{
																				Column: 46,
																				Line:   32,
																			},
																		},
																	},
																	Name: "v2",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   32,
																},
																File:   "opsgenie.flux",
																Source: "json.encode(v:v2)",
																Start: ast.Position{
																	Column: 32,
																	Line:   32,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   32,
																	},
																	File:   "opsgenie.flux",
																	Source: "json.encode",
																	Start: ast.Position{
																		Column: 32,
																		Line:   32,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   32,
																		},
																		File:   "opsgenie.flux",
																		Source: "json",
																		Start: ast.Position{
																			Column: 32,
																			Line:   32,
																		},
																	},
																},
																Name: "json",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   32,
																		},
																		File:   "opsgenie.flux",
																		Source: "encode",
																		Start: ast.Position{
																			Column: 37,
																			Line:   32,
																		},
																	},
																},
																Name: "encode",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   32,
													},
													File:   "opsgenie.flux",
													Source: "string(v: json.encode(v:v2))",
													Start: ast.Position{
														Column: 22,
														Line:   32,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   32,
														},
														File:   "opsgenie.flux",
														Source: "string",
														Start: ast.Position{
															Column: 22,
															Line:   32,
														},
													},
												},
												Name: "string",
											},
											Lparen: nil,
											Rparen: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   32,
												},
												File:   "opsgenie.flux",
												Source: "if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))",
												Start: ast.Position{
													Column: 16,
													Line:   30,
												},
											},
										},
										Consequent: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   31,
														},
														File:   "opsgenie.flux",
														Source: "v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\")",
														Start: ast.Position{
															Column: 29,
															Line:   31,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 97,
																Line:   31,
															},
															File:   "opsgenie.flux",
															Source: "v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\")",
															Start: ast.Position{
																Column: 29,
																Line:   31,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   31,
																},
																File:   "opsgenie.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 29,
																	Line:   31,
																},
															},
														},
														Name: "v",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 96,
																		Line:   31,
																	},
																	File:   "opsgenie.flux",
																	Source: "v: \"${strings.substring(v: v2, start: 0, end: max)}\"",
																	Start: ast.Position{
																		Column: 44,
																		Line:   31,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 96,
																			Line:   31,
																		},
																		File:   "opsgenie.flux",
																		Source: "v: \"${strings.substring(v: v2, start: 0, end: max)}\"",
																		Start: ast.Position{
																			Column: 44,
																			Line:   31,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   31,
																			},
																			File:   "opsgenie.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 44,
																				Line:   31,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.StringExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 96,
																				Line:   31,
																			},
																			File:   "opsgenie.flux",
																			Source: "\"${strings.substring(v: v2, start: 0, end: max)}\"",
																			Start: ast.Position{
																				Column: 47,
																				Line:   31,
																			},
																		},
																	},
																	Parts: []ast.StringExpressionPart{&ast.InterpolatedPart{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 95,
																					Line:   31,
																				},
																				File:   "opsgenie.flux",
																				Source: "${strings.substring(v: v2, start: 0, end: max)}",
																				Start: ast.Position{
																					Column: 48,
																					Line:   31,
																				},
																			},
																		},
																		Expression: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 93,
																							Line:   31,
																						},
																						File:   "opsgenie.flux",
																						Source: "v: v2, start: 0, end: max",
																						Start: ast.Position{
																							Column: 68,
																							Line:   31,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 73,
																								Line:   31,
																							},
																							File:   "opsgenie.flux",
																							Source: "v: v2",
																							Start: ast.Position{
																								Column: 68,
																								Line:   31,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 69,
																									Line:   31,
																								},
																								File:   "opsgenie.flux",
																								Source: "v",
																								Start: ast.Position{
																									Column: 68,
																									Line:   31,
																								},
																							},
																						},
																						Name: "v",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 73,
																									Line:   31,
																								},
																								File:   "opsgenie.flux",
																								Source: "v2",
																								Start: ast.Position{
																									Column: 71,
																									Line:   31,
																								},
																							},
																						},
																						Name: "v2",
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 83,
																								Line:   31,
																							},
																							File:   "opsgenie.flux",
																							Source: "start: 0",
																							Start: ast.Position{
																								Column: 75,
																								Line:   31,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 80,
																									Line:   31,
																								},
																								File:   "opsgenie.flux",
																								Source: "start",
																								Start: ast.Position{
																									Column: 75,
																									Line:   31,
																								},
																							},
																						},
																						Name: "start",
																					},
																					Separator: nil,
																					Value: &ast.IntegerLiteral{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 83,
																									Line:   31,
																								},
																								File:   "opsgenie.flux",
																								Source: "0",
																								Start: ast.Position{
																									Column: 82,
																									Line:   31,
																								},
																							},
																						},
																						Value: int64(0),
																					},
																				}, &ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 93,
																								Line:   31,
																							},
																							File:   "opsgenie.flux",
																							Source: "end: max",
																							Start: ast.Position{
																								Column: 85,
																								Line:   31,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 88,
																									Line:   31,
																								},
																								File:   "opsgenie.flux",
																								Source: "end",
																								Start: ast.Position{
																									Column: 85,
																									Line:   31,
																								},
																							},
																						},
																						Name: "end",
																					},
																					Separator: nil,
																					Value: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 93,
																									Line:   31,
																								},
																								File:   "opsgenie.flux",
																								Source: "max",
																								Start: ast.Position{
																									Column: 90,
																									Line:   31,
																								},
																							},
																						},
																						Name: "max",
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 94,
																						Line:   31,
																					},
																					File:   "opsgenie.flux",
																					Source: "strings.substring(v: v2, start: 0, end: max)",
																					Start: ast.Position{
																						Column: 50,
																						Line:   31,
																					},
																				},
																			},
																			Callee: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 67,
																							Line:   31,
																						},
																						File:   "opsgenie.flux",
																						Source: "strings.substring",
																						Start: ast.Position{
																							Column: 50,
																							Line:   31,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 57,
																								Line:   31,
																							},
																							File:   "opsgenie.flux",
																							Source: "strings",
																							Start: ast.Position{
																								Column: 50,
																								Line:   31,
																							},
																						},
																					},
																					Name: "strings",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 67,
																								Line:   31,
																							},
																							File:   "opsgenie.flux",
																							Source: "substring",
																							Start: ast.Position{
																								Column: 58,
																								Line:   31,
																							},
																						},
																					},
																					Name: "substring",
																				},
																				Rbrack: nil,
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	}},
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 97,
																	Line:   31,
																},
																File:   "opsgenie.flux",
																Source: "json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\")",
																Start: ast.Position{
																	Column: 32,
																	Line:   31,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   31,
																	},
																	File:   "opsgenie.flux",
																	Source: "json.encode",
																	Start: ast.Position{
																		Column: 32,
																		Line:   31,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   31,
																		},
																		File:   "opsgenie.flux",
																		Source: "json",
																		Start: ast.Position{
																			Column: 32,
																			Line:   31,
																		},
																	},
																},
																Name: "json",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   31,
																		},
																		File:   "opsgenie.flux",
																		Source: "encode",
																		Start: ast.Position{
																			Column: 37,
																			Line:   31,
																		},
																	},
																},
																Name: "encode",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   31,
													},
													File:   "opsgenie.flux",
													Source: "string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))",
													Start: ast.Position{
														Column: 22,
														Line:   31,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   31,
														},
														File:   "opsgenie.flux",
														Source: "string",
														Start: ast.Position{
															Column: 22,
															Line:   31,
														},
													},
												},
												Name: "string",
											},
											Lparen: nil,
											Rparen: nil,
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   30,
													},
													File:   "opsgenie.flux",
													Source: "strings.strlen(v: v2) > max",
													Start: ast.Position{
														Column: 19,
														Line:   30,
													},
												},
											},
											Left: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   30,
															},
															File:   "opsgenie.flux",
															Source: "v: v2",
															Start: ast.Position{
																Column: 34,
																Line:   30,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   30,
																},
																File:   "opsgenie.flux",
																Source: "v: v2",
																Start: ast.Position{
																	Column: 34,
																	Line:   30,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   30,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 34,
																		Line:   30,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   30,
																	},
																	File:   "opsgenie.flux",
																	Source: "v2",
																	Start: ast.Position{
																		Column: 37,
																		Line:   30,
																	},
																},
															},
															Name: "v2",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   30,
														},
														File:   "opsgenie.flux",
														Source: "strings.strlen(v: v2)",
														Start: ast.Position{
															Column: 19,
															Line:   30,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   30,
															},
															File:   "opsgenie.flux",
															Source: "strings.strlen",
															Start: ast.Position{
																Column: 19,
																Line:   30,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   30,
																},
																File:   "opsgenie.flux",
																Source: "strings",
																Start: ast.Position{
																	Column: 19,
																	Line:   30,
																},
															},
														},
														Name: "strings",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   30,
																},
																File:   "opsgenie.flux",
																Source: "strlen",
																Start: ast.Position{
																	Column: 27,
																	Line:   30,
																},
															},
														},
														Name: "strlen",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Operator: 10,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   30,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 43,
															Line:   30,
														},
													},
												},
												Name: "max",
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   32,
											},
											File:   "opsgenie.flux",
											Source: "return if strings.strlen(v: v2) > max \n                then string(v: json.encode(v: \"${strings.substring(v: v2, start: 0, end: max)}\"))\n                else string(v: json.encode(v:v2))",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
								}},
								Lbrace: nil,
								Rbrace: nil,
							},
							Lparen: nil,
							Params: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   28,
										},
										File:   "opsgenie.flux",
										Source: "v",
										Start: ast.Position{
											Column: 18,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   28,
											},
											File:   "opsgenie.flux",
											Source: "v",
											Start: ast.Position{
												Column: 18,
												Line:   28,
											},
										},
									},
									Name: "v",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   28,
										},
										File:   "opsgenie.flux",
										Source: "max",
										Start: ast.Position{
											Column: 21,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   28,
											},
											File:   "opsgenie.flux",
											Source: "max",
											Start: ast.Position{
												Column: 21,
												Line:   28,
											},
										},
									},
									Name: "max",
								},
								Separator: nil,
								Value:     nil,
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   28,
										},
										File:   "opsgenie.flux",
										Source: "defV = \"\"",
										Start: ast.Position{
											Column: 26,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   28,
											},
											File:   "opsgenie.flux",
											Source: "defV",
											Start: ast.Position{
												Column: 26,
												Line:   28,
											},
										},
									},
									Name: "defV",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   28,
											},
											File:   "opsgenie.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 33,
												Line:   28,
											},
										},
									},
									Value: "",
								},
							}},
							Rparan: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   45,
								},
								File:   "opsgenie.flux",
								Source: "body = \"{\n\\\"message\\\": ${cutEncode(v:message,max:130)},\n\\\"alias\\\": ${cutEncode(v:alias,max:512,defV: message)},\n\\\"description\\\": ${cutEncode(v:description,max:15000)},\n\\\"responders\\\": ${respondersToJSON(v:responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v:visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v:actions))},\n\\\"tags\\\": ${string(v: json.encode(v:tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v:entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v:priority, max: 2)}\n}\"",
								Start: ast.Position{
									Column: 5,
									Line:   34,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   34,
									},
									File:   "opsgenie.flux",
									Source: "body",
									Start: ast.Position{
										Column: 5,
										Line:   34,
									},
								},
							},
							Name: "body",
						},
						Init: &ast.StringExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   45,
									},
									File:   "opsgenie.flux",
									Source: "\"{\n\\\"message\\\": ${cutEncode(v:message,max:130)},\n\\\"alias\\\": ${cutEncode(v:alias,max:512,defV: message)},\n\\\"description\\\": ${cutEncode(v:description,max:15000)},\n\\\"responders\\\": ${respondersToJSON(v:responders)},\n\\\"visibleTo\\\": ${respondersToJSON(v:visibleTo)},\n\\\"actions\\\": ${string(v: json.encode(v:actions))},\n\\\"tags\\\": ${string(v: json.encode(v:tags))},\n\\\"details\\\": ${details},\n\\\"entity\\\": ${cutEncode(v:entity, max: 512)},\n\\\"priority\\\": ${cutEncode(v:priority, max: 2)}\n}\"",
									Start: ast.Position{
										Column: 12,
										Line:   34,
									},
								},
							},
							Parts: []ast.StringExpressionPart{&ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   35,
										},
										File:   "opsgenie.flux",
										Source: "{\n\\\"message\\\": ",
										Start: ast.Position{
											Column: 13,
											Line:   34,
										},
									},
								},
								Value: "{\n\"message\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   35,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v:message,max:130)}",
										Start: ast.Position{
											Column: 14,
											Line:   35,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   35,
												},
												File:   "opsgenie.flux",
												Source: "v:message,max:130",
												Start: ast.Position{
													Column: 26,
													Line:   35,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   35,
													},
													File:   "opsgenie.flux",
													Source: "v:message",
													Start: ast.Position{
														Column: 26,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   35,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 26,
															Line:   35,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   35,
														},
														File:   "opsgenie.flux",
														Source: "message",
														Start: ast.Position{
															Column: 28,
															Line:   35,
														},
													},
												},
												Name: "message",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   35,
													},
													File:   "opsgenie.flux",
													Source: "max:130",
													Start: ast.Position{
														Column: 36,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   35,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 36,
															Line:   35,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   35,
														},
														File:   "opsgenie.flux",
														Source: "130",
														Start: ast.Position{
															Column: 40,
															Line:   35,
														},
													},
												},
												Value: int64(130),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   35,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v:message,max:130)",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   35,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 16,
													Line:   35,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   36,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"alias\\\": ",
										Start: ast.Position{
											Column: 45,
											Line:   35,
										},
									},
								},
								Value: ",\n\"alias\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   36,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v:alias,max:512,defV: message)}",
										Start: ast.Position{
											Column: 12,
											Line:   36,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   36,
												},
												File:   "opsgenie.flux",
												Source: "v:alias,max:512,defV: message",
												Start: ast.Position{
													Column: 24,
													Line:   36,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   36,
													},
													File:   "opsgenie.flux",
													Source: "v:alias",
													Start: ast.Position{
														Column: 24,
														Line:   36,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   36,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 24,
															Line:   36,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   36,
														},
														File:   "opsgenie.flux",
														Source: "alias",
														Start: ast.Position{
															Column: 26,
															Line:   36,
														},
													},
												},
												Name: "alias",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   36,
													},
													File:   "opsgenie.flux",
													Source: "max:512",
													Start: ast.Position{
														Column: 32,
														Line:   36,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   36,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 32,
															Line:   36,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   36,
														},
														File:   "opsgenie.flux",
														Source: "512",
														Start: ast.Position{
															Column: 36,
															Line:   36,
														},
													},
												},
												Value: int64(512),
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   36,
													},
													File:   "opsgenie.flux",
													Source: "defV: message",
													Start: ast.Position{
														Column: 40,
														Line:   36,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   36,
														},
														File:   "opsgenie.flux",
														Source: "defV",
														Start: ast.Position{
															Column: 40,
															Line:   36,
														},
													},
												},
												Name: "defV",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   36,
														},
														File:   "opsgenie.flux",
														Source: "message",
														Start: ast.Position{
															Column: 46,
															Line:   36,
														},
													},
												},
												Name: "message",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   36,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v:alias,max:512,defV: message)",
											Start: ast.Position{
												Column: 14,
												Line:   36,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   36,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   37,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"description\\\": ",
										Start: ast.Position{
											Column: 55,
											Line:   36,
										},
									},
								},
								Value: ",\n\"description\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   37,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v:description,max:15000)}",
										Start: ast.Position{
											Column: 18,
											Line:   37,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   37,
												},
												File:   "opsgenie.flux",
												Source: "v:description,max:15000",
												Start: ast.Position{
													Column: 30,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   37,
													},
													File:   "opsgenie.flux",
													Source: "v:description",
													Start: ast.Position{
														Column: 30,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   37,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 30,
															Line:   37,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   37,
														},
														File:   "opsgenie.flux",
														Source: "description",
														Start: ast.Position{
															Column: 32,
															Line:   37,
														},
													},
												},
												Name: "description",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   37,
													},
													File:   "opsgenie.flux",
													Source: "max:15000",
													Start: ast.Position{
														Column: 44,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   37,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 44,
															Line:   37,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   37,
														},
														File:   "opsgenie.flux",
														Source: "15000",
														Start: ast.Position{
															Column: 48,
															Line:   37,
														},
													},
												},
												Value: int64(15000),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   37,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v:description,max:15000)",
											Start: ast.Position{
												Column: 20,
												Line:   37,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   37,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 20,
													Line:   37,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   38,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"responders\\\": ",
										Start: ast.Position{
											Column: 55,
											Line:   37,
										},
									},
								},
								Value: ",\n\"responders\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   38,
										},
										File:   "opsgenie.flux",
										Source: "${respondersToJSON(v:responders)}",
										Start: ast.Position{
											Column: 17,
											Line:   38,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   38,
												},
												File:   "opsgenie.flux",
												Source: "v:responders",
												Start: ast.Position{
													Column: 36,
													Line:   38,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   38,
													},
													File:   "opsgenie.flux",
													Source: "v:responders",
													Start: ast.Position{
														Column: 36,
														Line:   38,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   38,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 36,
															Line:   38,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   38,
														},
														File:   "opsgenie.flux",
														Source: "responders",
														Start: ast.Position{
															Column: 38,
															Line:   38,
														},
													},
												},
												Name: "responders",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   38,
											},
											File:   "opsgenie.flux",
											Source: "respondersToJSON(v:responders)",
											Start: ast.Position{
												Column: 19,
												Line:   38,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   38,
												},
												File:   "opsgenie.flux",
												Source: "respondersToJSON",
												Start: ast.Position{
													Column: 19,
													Line:   38,
												},
											},
										},
										Name: "respondersToJSON",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   39,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"visibleTo\\\": ",
										Start: ast.Position{
											Column: 50,
											Line:   38,
										},
									},
								},
								Value: ",\n\"visibleTo\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   39,
										},
										File:   "opsgenie.flux",
										Source: "${respondersToJSON(v:visibleTo)}",
										Start: ast.Position{
											Column: 16,
											Line:   39,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   39,
												},
												File:   "opsgenie.flux",
												Source: "v:visibleTo",
												Start: ast.Position{
													Column: 35,
													Line:   39,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   39,
													},
													File:   "opsgenie.flux",
													Source: "v:visibleTo",
													Start: ast.Position{
														Column: 35,
														Line:   39,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   39,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 35,
															Line:   39,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   39,
														},
														File:   "opsgenie.flux",
														Source: "visibleTo",
														Start: ast.Position{
															Column: 37,
															Line:   39,
														},
													},
												},
												Name: "visibleTo",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   39,
											},
											File:   "opsgenie.flux",
											Source: "respondersToJSON(v:visibleTo)",
											Start: ast.Position{
												Column: 18,
												Line:   39,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   39,
												},
												File:   "opsgenie.flux",
												Source: "respondersToJSON",
												Start: ast.Position{
													Column: 18,
													Line:   39,
												},
											},
										},
										Name: "respondersToJSON",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   40,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"actions\\\": ",
										Start: ast.Position{
											Column: 48,
											Line:   39,
										},
									},
								},
								Value: ",\n\"actions\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   40,
										},
										File:   "opsgenie.flux",
										Source: "${string(v: json.encode(v:actions))}",
										Start: ast.Position{
											Column: 14,
											Line:   40,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   40,
												},
												File:   "opsgenie.flux",
												Source: "v: json.encode(v:actions)",
												Start: ast.Position{
													Column: 23,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   40,
													},
													File:   "opsgenie.flux",
													Source: "v: json.encode(v:actions)",
													Start: ast.Position{
														Column: 23,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   40,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 23,
															Line:   40,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 47,
																Line:   40,
															},
															File:   "opsgenie.flux",
															Source: "v:actions",
															Start: ast.Position{
																Column: 38,
																Line:   40,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 47,
																	Line:   40,
																},
																File:   "opsgenie.flux",
																Source: "v:actions",
																Start: ast.Position{
																	Column: 38,
																	Line:   40,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 39,
																		Line:   40,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 38,
																		Line:   40,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   40,
																	},
																	File:   "opsgenie.flux",
																	Source: "actions",
																	Start: ast.Position{
																		Column: 40,
																		Line:   40,
																	},
																},
															},
															Name: "actions",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   40,
														},
														File:   "opsgenie.flux",
														Source: "json.encode(v:actions)",
														Start: ast.Position{
															Column: 26,
															Line:   40,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   40,
															},
															File:   "opsgenie.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 26,
																Line:   40,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   40,
																},
																File:   "opsgenie.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 26,
																	Line:   40,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   40,
																},
																File:   "opsgenie.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 31,
																	Line:   40,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   40,
											},
											File:   "opsgenie.flux",
											Source: "string(v: json.encode(v:actions))",
											Start: ast.Position{
												Column: 16,
												Line:   40,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   40,
												},
												File:   "opsgenie.flux",
												Source: "string",
												Start: ast.Position{
													Column: 16,
													Line:   40,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   41,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"tags\\\": ",
										Start: ast.Position{
											Column: 50,
											Line:   40,
										},
									},
								},
								Value: ",\n\"tags\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   41,
										},
										File:   "opsgenie.flux",
										Source: "${string(v: json.encode(v:tags))}",
										Start: ast.Position{
											Column: 11,
											Line:   41,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   41,
												},
												File:   "opsgenie.flux",
												Source: "v: json.encode(v:tags)",
												Start: ast.Position{
													Column: 20,
													Line:   41,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   41,
													},
													File:   "opsgenie.flux",
													Source: "v: json.encode(v:tags)",
													Start: ast.Position{
														Column: 20,
														Line:   41,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   41,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 20,
															Line:   41,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   41,
															},
															File:   "opsgenie.flux",
															Source: "v:tags",
															Start: ast.Position{
																Column: 35,
																Line:   41,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   41,
																},
																File:   "opsgenie.flux",
																Source: "v:tags",
																Start: ast.Position{
																	Column: 35,
																	Line:   41,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   41,
																	},
																	File:   "opsgenie.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 35,
																		Line:   41,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   41,
																	},
																	File:   "opsgenie.flux",
																	Source: "tags",
																	Start: ast.Position{
																		Column: 37,
																		Line:   41,
																	},
																},
															},
															Name: "tags",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   41,
														},
														File:   "opsgenie.flux",
														Source: "json.encode(v:tags)",
														Start: ast.Position{
															Column: 23,
															Line:   41,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   41,
															},
															File:   "opsgenie.flux",
															Source: "json.encode",
															Start: ast.Position{
																Column: 23,
																Line:   41,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   41,
																},
																File:   "opsgenie.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 23,
																	Line:   41,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   41,
																},
																File:   "opsgenie.flux",
																Source: "encode",
																Start: ast.Position{
																	Column: 28,
																	Line:   41,
																},
															},
														},
														Name: "encode",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   41,
											},
											File:   "opsgenie.flux",
											Source: "string(v: json.encode(v:tags))",
											Start: ast.Position{
												Column: 13,
												Line:   41,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   41,
												},
												File:   "opsgenie.flux",
												Source: "string",
												Start: ast.Position{
													Column: 13,
													Line:   41,
												},
											},
										},
										Name: "string",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   42,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"details\\\": ",
										Start: ast.Position{
											Column: 44,
											Line:   41,
										},
									},
								},
								Value: ",\n\"details\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   42,
										},
										File:   "opsgenie.flux",
										Source: "${details}",
										Start: ast.Position{
											Column: 14,
											Line:   42,
										},
									},
								},
								Expression: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   42,
											},
											File:   "opsgenie.flux",
											Source: "details",
											Start: ast.Position{
												Column: 16,
												Line:   42,
											},
										},
									},
									Name: "details",
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   43,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"entity\\\": ",
										Start: ast.Position{
											Column: 24,
											Line:   42,
										},
									},
								},
								Value: ",\n\"entity\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   43,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v:entity, max: 512)}",
										Start: ast.Position{
											Column: 13,
											Line:   43,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   43,
												},
												File:   "opsgenie.flux",
												Source: "v:entity, max: 512",
												Start: ast.Position{
													Column: 25,
													Line:   43,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   43,
													},
													File:   "opsgenie.flux",
													Source: "v:entity",
													Start: ast.Position{
														Column: 25,
														Line:   43,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   43,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 25,
															Line:   43,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   43,
														},
														File:   "opsgenie.flux",
														Source: "entity",
														Start: ast.Position{
															Column: 27,
															Line:   43,
														},
													},
												},
												Name: "entity",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   43,
													},
													File:   "opsgenie.flux",
													Source: "max: 512",
													Start: ast.Position{
														Column: 35,
														Line:   43,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   43,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 35,
															Line:   43,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   43,
														},
														File:   "opsgenie.flux",
														Source: "512",
														Start: ast.Position{
															Column: 40,
															Line:   43,
														},
													},
												},
												Value: int64(512),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   43,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v:entity, max: 512)",
											Start: ast.Position{
												Column: 15,
												Line:   43,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   43,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 15,
													Line:   43,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   44,
										},
										File:   "opsgenie.flux",
										Source: ",\n\\\"priority\\\": ",
										Start: ast.Position{
											Column: 45,
											Line:   43,
										},
									},
								},
								Value: ",\n\"priority\": ",
							}, &ast.InterpolatedPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   44,
										},
										File:   "opsgenie.flux",
										Source: "${cutEncode(v:priority, max: 2)}",
										Start: ast.Position{
											Column: 15,
											Line:   44,
										},
									},
								},
								Expression: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   44,
												},
												File:   "opsgenie.flux",
												Source: "v:priority, max: 2",
												Start: ast.Position{
													Column: 27,
													Line:   44,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   44,
													},
													File:   "opsgenie.flux",
													Source: "v:priority",
													Start: ast.Position{
														Column: 27,
														Line:   44,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   44,
														},
														File:   "opsgenie.flux",
														Source: "v",
														Start: ast.Position{
															Column: 27,
															Line:   44,
														},
													},
												},
												Name: "v",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   44,
														},
														File:   "opsgenie.flux",
														Source: "priority",
														Start: ast.Position{
															Column: 29,
															Line:   44,
														},
													},
												},
												Name: "priority",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   44,
													},
													File:   "opsgenie.flux",
													Source: "max: 2",
													Start: ast.Position{
														Column: 39,
														Line:   44,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   44,
														},
														File:   "opsgenie.flux",
														Source: "max",
														Start: ast.Position{
															Column: 39,
															Line:   44,
														},
													},
												},
												Name: "max",
											},
											Separator: nil,
											Value: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   44,
														},
														File:   "opsgenie.flux",
														Source: "2",
														Start: ast.Position{
															Column: 44,
															Line:   44,
														},
													},
												},
												Value: int64(2),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   44,
											},
											File:   "opsgenie.flux",
											Source: "cutEncode(v:priority, max: 2)",
											Start: ast.Position{
												Column: 17,
												Line:   44,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   44,
												},
												File:   "opsgenie.flux",
												Source: "cutEncode",
												Start: ast.Position{
													Column: 17,
													Line:   44,
												},
											},
										},
										Name: "cutEncode",
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.TextPart{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 2,
											Line:   45,
										},
										File:   "opsgenie.flux",
										Source: "\n}",
										Start: ast.Position{
											Column: 47,
											Line:   44,
										},
									},
								},
								Value: "\n}",
							}},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   46,
										},
										File:   "opsgenie.flux",
										Source: "headers: headers, url: url, data: bytes(v: body)",
										Start: ast.Position{
											Column: 22,
											Line:   46,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   46,
											},
											File:   "opsgenie.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   46,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   46,
												},
												File:   "opsgenie.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   46,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   46,
												},
												File:   "opsgenie.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   46,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   46,
											},
											File:   "opsgenie.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   46,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   46,
												},
												File:   "opsgenie.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   46,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   46,
												},
												File:   "opsgenie.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   46,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   46,
											},
											File:   "opsgenie.flux",
											Source: "data: bytes(v: body)",
											Start: ast.Position{
												Column: 50,
												Line:   46,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   46,
												},
												File:   "opsgenie.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   46,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   46,
													},
													File:   "opsgenie.flux",
													Source: "v: body",
													Start: ast.Position{
														Column: 62,
														Line:   46,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   46,
														},
														File:   "opsgenie.flux",
														Source: "v: body",
														Start: ast.Position{
															Column: 62,
															Line:   46,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   46,
															},
															File:   "opsgenie.flux",
															Source: "v",
															Start: ast.Position{
																Column: 62,
																Line:   46,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   46,
															},
															File:   "opsgenie.flux",
															Source: "body",
															Start: ast.Position{
																Column: 65,
																Line:   46,
															},
														},
													},
													Name: "body",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   46,
												},
												File:   "opsgenie.flux",
												Source: "bytes(v: body)",
												Start: ast.Position{
													Column: 56,
													Line:   46,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   46,
													},
													File:   "opsgenie.flux",
													Source: "bytes",
													Start: ast.Position{
														Column: 56,
														Line:   46,
													},
												},
											},
											Name: "bytes",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   46,
									},
									File:   "opsgenie.flux",
									Source: "http.post(headers: headers, url: url, data: bytes(v: body))",
									Start: ast.Position{
										Column: 12,
										Line:   46,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   46,
										},
										File:   "opsgenie.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   46,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   46,
											},
											File:   "opsgenie.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   46,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   46,
											},
											File:   "opsgenie.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   46,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   46,
								},
								File:   "opsgenie.flux",
								Source: "return http.post(headers: headers, url: url, data: bytes(v: body))",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "url=\"https://api.opsgenie.com/v2/alerts\"",
							Start: ast.Position{
								Column: 14,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "url",
								Start: ast.Position{
									Column: 14,
									Line:   23,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "\"https://api.opsgenie.com/v2/alerts\"",
								Start: ast.Position{
									Column: 18,
									Line:   23,
								},
							},
						},
						Value: "https://api.opsgenie.com/v2/alerts",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 62,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 56,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 56,
									Line:   23,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "message",
							Start: ast.Position{
								Column: 64,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "message",
								Start: ast.Position{
									Column: 64,
									Line:   23,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "alias=\"\"",
							Start: ast.Position{
								Column: 73,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "alias",
								Start: ast.Position{
									Column: 73,
									Line:   23,
								},
							},
						},
						Name: "alias",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 79,
									Line:   23,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "description=\"\"",
							Start: ast.Position{
								Column: 83,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "description",
								Start: ast.Position{
									Column: 83,
									Line:   23,
								},
							},
						},
						Name: "description",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 95,
									Line:   23,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "priority=\"P3\"",
							Start: ast.Position{
								Column: 99,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "priority",
								Start: ast.Position{
									Column: 99,
									Line:   23,
								},
							},
						},
						Name: "priority",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "\"P3\"",
								Start: ast.Position{
									Column: 108,
									Line:   23,
								},
							},
						},
						Value: "P3",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 127,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "responders=[]",
							Start: ast.Position{
								Column: 114,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "responders",
								Start: ast.Position{
									Column: 114,
									Line:   23,
								},
							},
						},
						Name: "responders",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 125,
									Line:   23,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "tags=[]",
							Start: ast.Position{
								Column: 129,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 133,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 129,
									Line:   23,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 134,
									Line:   23,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 147,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "entity=\"\"",
							Start: ast.Position{
								Column: 138,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 144,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "entity",
								Start: ast.Position{
									Column: 138,
									Line:   23,
								},
							},
						},
						Name: "entity",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 147,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 145,
									Line:   23,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 159,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "actions=[]",
							Start: ast.Position{
								Column: 149,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 156,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "actions",
								Start: ast.Position{
									Column: 149,
									Line:   23,
								},
							},
						},
						Name: "actions",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 159,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 157,
									Line:   23,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 173,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "visibleTo=[]",
							Start: ast.Position{
								Column: 161,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 170,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "visibleTo",
								Start: ast.Position{
									Column: 161,
									Line:   23,
								},
							},
						},
						Name: "visibleTo",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 173,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 171,
									Line:   23,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 187,
								Line:   23,
							},
							File:   "opsgenie.flux",
							Source: "details=\"{}\"",
							Start: ast.Position{
								Column: 175,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 182,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "details",
								Start: ast.Position{
									Column: 175,
									Line:   23,
								},
							},
						},
						Name: "details",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 187,
									Line:   23,
								},
								File:   "opsgenie.flux",
								Source: "\"{}\"",
								Start: ast.Position{
									Column: 183,
									Line:   23,
								},
							},
						},
						Value: "{}",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   74,
					},
					File:   "opsgenie.flux",
					Source: "endpoint = (url=\"https://api.opsgenie.com/v2/alerts\", apiKey, entity = \"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send alerts to opsgenie for each table row.\n"}, ast.Comment{Text: "// `url`         - string - Opsgenie API URL. Defaults to \"https://api.opsgenie.com/v2/alerts\". \n"}, ast.Comment{Text: "// `apiKey`      - string - API Authorization key. \n"}, ast.Comment{Text: "// `entity`      - string - Entity of the alert, used to specify domain of the alert. Optional. \n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with all properties defined in the `sendAlert` function arguments (except url, apiKey and entity).\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   55,
						},
						File:   "opsgenie.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   55,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   74,
						},
						File:   "opsgenie.flux",
						Source: "(url=\"https://api.opsgenie.com/v2/alerts\", apiKey, entity = \"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   55,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   74,
							},
							File:   "opsgenie.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   56,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   74,
								},
								File:   "opsgenie.flux",
								Source: "(tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   57,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   57,
										},
										File:   "opsgenie.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 24,
											Line:   57,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   74,
									},
									File:   "opsgenie.flux",
									Source: "tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   57,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   74,
											},
											File:   "opsgenie.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   58,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   74,
												},
												File:   "opsgenie.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   58,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   58,
													},
													File:   "opsgenie.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   58,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   74,
													},
													File:   "opsgenie.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   58,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   74,
														},
														File:   "opsgenie.flux",
														Source: "{\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   58,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   59,
															},
															File:   "opsgenie.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   59,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   59,
																},
																File:   "opsgenie.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   59,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   59,
																	},
																	File:   "opsgenie.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   59,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   59,
																		},
																		File:   "opsgenie.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   59,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   59,
																			},
																			File:   "opsgenie.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   59,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   59,
																			},
																			File:   "opsgenie.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   59,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   59,
																},
																File:   "opsgenie.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   59,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   59,
																	},
																	File:   "opsgenie.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   59,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   73,
																},
																File:   "opsgenie.flux",
																Source: "{r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}",
																Start: ast.Position{
																	Column: 24,
																	Line:   60,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   73,
																	},
																	File:   "opsgenie.flux",
																	Source: "_sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)",
																	Start: ast.Position{
																		Column: 32,
																		Line:   60,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   60,
																		},
																		File:   "opsgenie.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   60,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   73,
																			},
																			File:   "opsgenie.flux",
																			Source: "v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100",
																			Start: ast.Position{
																				Column: 46,
																				Line:   60,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   73,
																				},
																				File:   "opsgenie.flux",
																				Source: "v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100",
																				Start: ast.Position{
																					Column: 46,
																					Line:   60,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   60,
																					},
																					File:   "opsgenie.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   60,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   73,
																					},
																					File:   "opsgenie.flux",
																					Source: "2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100",
																					Start: ast.Position{
																						Column: 49,
																						Line:   60,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   60,
																						},
																						File:   "opsgenie.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   60,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   73,
																						},
																						File:   "opsgenie.flux",
																						Source: "sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100",
																						Start: ast.Position{
																							Column: 54,
																							Line:   60,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 41,
																									Line:   72,
																								},
																								File:   "opsgenie.flux",
																								Source: "url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details",
																								Start: ast.Position{
																									Column: 21,
																									Line:   61,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 29,
																										Line:   61,
																									},
																									File:   "opsgenie.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 21,
																										Line:   61,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 24,
																											Line:   61,
																										},
																										File:   "opsgenie.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 21,
																											Line:   61,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   61,
																										},
																										File:   "opsgenie.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 26,
																											Line:   61,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   62,
																									},
																									File:   "opsgenie.flux",
																									Source: "apiKey: apiKey",
																									Start: ast.Position{
																										Column: 21,
																										Line:   62,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 27,
																											Line:   62,
																										},
																										File:   "opsgenie.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 21,
																											Line:   62,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   62,
																										},
																										File:   "opsgenie.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 29,
																											Line:   62,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   63,
																									},
																									File:   "opsgenie.flux",
																									Source: "entity: entity",
																									Start: ast.Position{
																										Column: 21,
																										Line:   63,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 27,
																											Line:   63,
																										},
																										File:   "opsgenie.flux",
																										Source: "entity",
																										Start: ast.Position{
																											Column: 21,
																											Line:   63,
																										},
																									},
																								},
																								Name: "entity",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   63,
																										},
																										File:   "opsgenie.flux",
																										Source: "entity",
																										Start: ast.Position{
																											Column: 29,
																											Line:   63,
																										},
																									},
																								},
																								Name: "entity",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   64,
																									},
																									File:   "opsgenie.flux",
																									Source: "message: obj.message",
																									Start: ast.Position{
																										Column: 21,
																										Line:   64,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   64,
																										},
																										File:   "opsgenie.flux",
																										Source: "message",
																										Start: ast.Position{
																											Column: 21,
																											Line:   64,
																										},
																									},
																								},
																								Name: "message",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   64,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.message",
																										Start: ast.Position{
																											Column: 30,
																											Line:   64,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 33,
																												Line:   64,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 30,
																												Line:   64,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   64,
																											},
																											File:   "opsgenie.flux",
																											Source: "message",
																											Start: ast.Position{
																												Column: 34,
																												Line:   64,
																											},
																										},
																									},
																									Name: "message",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   65,
																									},
																									File:   "opsgenie.flux",
																									Source: "alias: obj.alias",
																									Start: ast.Position{
																										Column: 21,
																										Line:   65,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 26,
																											Line:   65,
																										},
																										File:   "opsgenie.flux",
																										Source: "alias",
																										Start: ast.Position{
																											Column: 21,
																											Line:   65,
																										},
																									},
																								},
																								Name: "alias",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   65,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.alias",
																										Start: ast.Position{
																											Column: 28,
																											Line:   65,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 31,
																												Line:   65,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 28,
																												Line:   65,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   65,
																											},
																											File:   "opsgenie.flux",
																											Source: "alias",
																											Start: ast.Position{
																												Column: 32,
																												Line:   65,
																											},
																										},
																									},
																									Name: "alias",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   66,
																									},
																									File:   "opsgenie.flux",
																									Source: "description: obj.description",
																									Start: ast.Position{
																										Column: 21,
																										Line:   66,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   66,
																										},
																										File:   "opsgenie.flux",
																										Source: "description",
																										Start: ast.Position{
																											Column: 21,
																											Line:   66,
																										},
																									},
																								},
																								Name: "description",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   66,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.description",
																										Start: ast.Position{
																											Column: 34,
																											Line:   66,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   66,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   66,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   66,
																											},
																											File:   "opsgenie.flux",
																											Source: "description",
																											Start: ast.Position{
																												Column: 38,
																												Line:   66,
																											},
																										},
																									},
																									Name: "description",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   67,
																									},
																									File:   "opsgenie.flux",
																									Source: "priority: obj.priority",
																									Start: ast.Position{
																										Column: 21,
																										Line:   67,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   67,
																										},
																										File:   "opsgenie.flux",
																										Source: "priority",
																										Start: ast.Position{
																											Column: 21,
																											Line:   67,
																										},
																									},
																								},
																								Name: "priority",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   67,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.priority",
																										Start: ast.Position{
																											Column: 31,
																											Line:   67,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   67,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   67,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   67,
																											},
																											File:   "opsgenie.flux",
																											Source: "priority",
																											Start: ast.Position{
																												Column: 35,
																												Line:   67,
																											},
																										},
																									},
																									Name: "priority",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   68,
																									},
																									File:   "opsgenie.flux",
																									Source: "responders: obj.responders",
																									Start: ast.Position{
																										Column: 21,
																										Line:   68,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   68,
																										},
																										File:   "opsgenie.flux",
																										Source: "responders",
																										Start: ast.Position{
																											Column: 21,
																											Line:   68,
																										},
																									},
																								},
																								Name: "responders",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   68,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.responders",
																										Start: ast.Position{
																											Column: 33,
																											Line:   68,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   68,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   68,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   68,
																											},
																											File:   "opsgenie.flux",
																											Source: "responders",
																											Start: ast.Position{
																												Column: 37,
																												Line:   68,
																											},
																										},
																									},
																									Name: "responders",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   69,
																									},
																									File:   "opsgenie.flux",
																									Source: "tags: obj.tags",
																									Start: ast.Position{
																										Column: 21,
																										Line:   69,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 25,
																											Line:   69,
																										},
																										File:   "opsgenie.flux",
																										Source: "tags",
																										Start: ast.Position{
																											Column: 21,
																											Line:   69,
																										},
																									},
																								},
																								Name: "tags",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   69,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.tags",
																										Start: ast.Position{
																											Column: 27,
																											Line:   69,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   69,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 27,
																												Line:   69,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   69,
																											},
																											File:   "opsgenie.flux",
																											Source: "tags",
																											Start: ast.Position{
																												Column: 31,
																												Line:   69,
																											},
																										},
																									},
																									Name: "tags",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   70,
																									},
																									File:   "opsgenie.flux",
																									Source: "actions: obj.actions",
																									Start: ast.Position{
																										Column: 21,
																										Line:   70,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   70,
																										},
																										File:   "opsgenie.flux",
																										Source: "actions",
																										Start: ast.Position{
																											Column: 21,
																											Line:   70,
																										},
																									},
																								},
																								Name: "actions",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   70,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.actions",
																										Start: ast.Position{
																											Column: 30,
																											Line:   70,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 33,
																												Line:   70,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 30,
																												Line:   70,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   70,
																											},
																											File:   "opsgenie.flux",
																											Source: "actions",
																											Start: ast.Position{
																												Column: 34,
																												Line:   70,
																											},
																										},
																									},
																									Name: "actions",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   71,
																									},
																									File:   "opsgenie.flux",
																									Source: "visibleTo: obj.visibleTo",
																									Start: ast.Position{
																										Column: 21,
																										Line:   71,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   71,
																										},
																										File:   "opsgenie.flux",
																										Source: "visibleTo",
																										Start: ast.Position{
																											Column: 21,
																											Line:   71,
																										},
																									},
																								},
																								Name: "visibleTo",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   71,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.visibleTo",
																										Start: ast.Position{
																											Column: 32,
																											Line:   71,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   71,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   71,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   71,
																											},
																											File:   "opsgenie.flux",
																											Source: "visibleTo",
																											Start: ast.Position{
																												Column: 36,
																												Line:   71,
																											},
																										},
																									},
																									Name: "visibleTo",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   72,
																									},
																									File:   "opsgenie.flux",
																									Source: "details: obj.details",
																									Start: ast.Position{
																										Column: 21,
																										Line:   72,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   72,
																										},
																										File:   "opsgenie.flux",
																										Source: "details",
																										Start: ast.Position{
																											Column: 21,
																											Line:   72,
																										},
																									},
																								},
																								Name: "details",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   72,
																										},
																										File:   "opsgenie.flux",
																										Source: "obj.details",
																										Start: ast.Position{
																											Column: 30,
																											Line:   72,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 33,
																												Line:   72,
																											},
																											File:   "opsgenie.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 30,
																												Line:   72,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   72,
																											},
																											File:   "opsgenie.flux",
																											Source: "details",
																											Start: ast.Position{
																												Column: 34,
																												Line:   72,
																											},
																										},
																									},
																									Name: "details",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 18,
																								Line:   73,
																							},
																							File:   "opsgenie.flux",
																							Source: "sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                )",
																							Start: ast.Position{
																								Column: 54,
																								Line:   60,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 63,
																									Line:   60,
																								},
																								File:   "opsgenie.flux",
																								Source: "sendAlert",
																								Start: ast.Position{
																									Column: 54,
																									Line:   60,
																								},
																							},
																						},
																						Name: "sendAlert",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   73,
																							},
																							File:   "opsgenie.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 21,
																								Line:   73,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   73,
																		},
																		File:   "opsgenie.flux",
																		Source: "string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)",
																		Start: ast.Position{
																			Column: 39,
																			Line:   60,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   60,
																			},
																			File:   "opsgenie.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   60,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   60,
																	},
																	File:   "opsgenie.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   60,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   73,
															},
															File:   "opsgenie.flux",
															Source: "return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}",
															Start: ast.Position{
																Column: 17,
																Line:   60,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   58,
														},
														File:   "opsgenie.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   58,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   58,
															},
															File:   "opsgenie.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   58,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   74,
										},
										File:   "opsgenie.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == sendAlert(\n                    url: url,\n                    apiKey: apiKey,\n                    entity: entity,\n                    message: obj.message,\n                    alias: obj.alias,\n                    description: obj.description,\n                    priority: obj.priority,\n                    responders: obj.responders,\n                    tags: obj.tags,\n                    actions: obj.actions,\n                    visibleTo: obj.visibleTo,\n                    details: obj.details,\n                ) / 100)}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   58,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   58,
											},
											File:   "opsgenie.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   58,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   57,
									},
									File:   "opsgenie.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   57,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   57,
										},
										File:   "opsgenie.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   57,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   57,
									},
									File:   "opsgenie.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   57,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   56,
								},
								File:   "opsgenie.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   56,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   56,
									},
									File:   "opsgenie.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   56,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   55,
							},
							File:   "opsgenie.flux",
							Source: "url=\"https://api.opsgenie.com/v2/alerts\"",
							Start: ast.Position{
								Column: 13,
								Line:   55,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   55,
								},
								File:   "opsgenie.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   55,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   55,
								},
								File:   "opsgenie.flux",
								Source: "\"https://api.opsgenie.com/v2/alerts\"",
								Start: ast.Position{
									Column: 17,
									Line:   55,
								},
							},
						},
						Value: "https://api.opsgenie.com/v2/alerts",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   55,
							},
							File:   "opsgenie.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 55,
								Line:   55,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   55,
								},
								File:   "opsgenie.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 55,
									Line:   55,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   55,
							},
							File:   "opsgenie.flux",
							Source: "entity = \"\"",
							Start: ast.Position{
								Column: 63,
								Line:   55,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   55,
								},
								File:   "opsgenie.flux",
								Source: "entity",
								Start: ast.Position{
									Column: 63,
									Line:   55,
								},
							},
						},
						Name: "entity",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   55,
								},
								File:   "opsgenie.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 72,
									Line:   55,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "opsgenie.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "opsgenie.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "opsgenie.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "opsgenie.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "opsgenie.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "opsgenie.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "opsgenie.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "opsgenie.flux",
					Source: "package opsgenie",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "opsgenie.flux",
						Source: "opsgenie",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "opsgenie",
			},
		},
	}},
	Package: "opsgenie",
	Path:    "contrib/sranka/opsgenie",
}
