// DO NOT EDIT: This file is autogenerated via the builtin command.

package dict

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   65,
				},
				File:   "dict_insert_remove_test.flux",
				Source: "package dict_test\n\nimport \"testing\"\nimport \"dict\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ncodes1 = dict.fromList(pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unknown\", value: 3},\n])\ncodes2 = dict.remove(dict: codes1, key: \"unknown\")\ncodes3 = dict.insert(dict: codes2, key: \"unimplemented\", value: 2)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long,long,long\n#group,false,false,false,true,true,true,false,false,false,false\n#default,_result,,,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code1,error_code2,error_code3\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0,0,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0,0,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1,1,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1,1,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,-1,-1,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,-1,-1,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,3,-1,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,3,-1,-1\n\"\n\nt_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  })\n\ntest _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   12,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "codes1 = dict.fromList(pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unknown\", value: 3},\n])",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "codes1",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "codes1",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   12,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unknown\", value: 3},\n]",
							Start: ast.Position{
								Column: 24,
								Line:   8,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   12,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unknown\", value: 3},\n]",
								Start: ast.Position{
									Column: 24,
									Line:   8,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   8,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "pairs",
									Start: ast.Position{
										Column: 24,
										Line:   8,
									},
								},
							},
							Name: "pairs",
						},
						Separator: nil,
						Value: &ast.ArrayExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   12,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "[\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unknown\", value: 3},\n]",
									Start: ast.Position{
										Column: 31,
										Line:   8,
									},
								},
							},
							Elements: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   9,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "{key: \"internal\", value: 0}",
										Start: ast.Position{
											Column: 3,
											Line:   9,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   9,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "key: \"internal\"",
											Start: ast.Position{
												Column: 4,
												Line:   9,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 7,
													Line:   9,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "key",
												Start: ast.Position{
													Column: 4,
													Line:   9,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   9,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "\"internal\"",
												Start: ast.Position{
													Column: 9,
													Line:   9,
												},
											},
										},
										Value: "internal",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   9,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "value: 0",
											Start: ast.Position{
												Column: 21,
												Line:   9,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   9,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 21,
													Line:   9,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   9,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "0",
												Start: ast.Position{
													Column: 28,
													Line:   9,
												},
											},
										},
										Value: int64(0),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}, &ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   10,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "{key: \"invalid\", value: 1}",
										Start: ast.Position{
											Column: 3,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   10,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "key: \"invalid\"",
											Start: ast.Position{
												Column: 4,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 7,
													Line:   10,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "key",
												Start: ast.Position{
													Column: 4,
													Line:   10,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   10,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "\"invalid\"",
												Start: ast.Position{
													Column: 9,
													Line:   10,
												},
											},
										},
										Value: "invalid",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   10,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "value: 1",
											Start: ast.Position{
												Column: 20,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   10,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 20,
													Line:   10,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   10,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "1",
												Start: ast.Position{
													Column: 27,
													Line:   10,
												},
											},
										},
										Value: int64(1),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}, &ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   11,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "{key: \"unknown\", value: 3}",
										Start: ast.Position{
											Column: 3,
											Line:   11,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   11,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "key: \"unknown\"",
											Start: ast.Position{
												Column: 4,
												Line:   11,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 7,
													Line:   11,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "key",
												Start: ast.Position{
													Column: 4,
													Line:   11,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   11,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "\"unknown\"",
												Start: ast.Position{
													Column: 9,
													Line:   11,
												},
											},
										},
										Value: "unknown",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   11,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "value: 3",
											Start: ast.Position{
												Column: 20,
												Line:   11,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   11,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 20,
													Line:   11,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   11,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "3",
												Start: ast.Position{
													Column: 27,
													Line:   11,
												},
											},
										},
										Value: int64(3),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							Lbrack: nil,
							Rbrack: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   12,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "dict.fromList(pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unknown\", value: 3},\n])",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   8,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "dict.fromList",
							Start: ast.Position{
								Column: 10,
								Line:   8,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   8,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "dict",
								Start: ast.Position{
									Column: 10,
									Line:   8,
								},
							},
						},
						Name: "dict",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   8,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "fromList",
								Start: ast.Position{
									Column: 15,
									Line:   8,
								},
							},
						},
						Name: "fromList",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 51,
						Line:   13,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "codes2 = dict.remove(dict: codes1, key: \"unknown\")",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   13,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "codes2",
						Start: ast.Position{
							Column: 1,
							Line:   13,
						},
					},
				},
				Name: "codes2",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   13,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "dict: codes1, key: \"unknown\"",
							Start: ast.Position{
								Column: 22,
								Line:   13,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   13,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "dict: codes1",
								Start: ast.Position{
									Column: 22,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   13,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "dict",
									Start: ast.Position{
										Column: 22,
										Line:   13,
									},
								},
							},
							Name: "dict",
						},
						Separator: nil,
						Value: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   13,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "codes1",
									Start: ast.Position{
										Column: 28,
										Line:   13,
									},
								},
							},
							Name: "codes1",
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   13,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "key: \"unknown\"",
								Start: ast.Position{
									Column: 36,
									Line:   13,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   13,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "key",
									Start: ast.Position{
										Column: 36,
										Line:   13,
									},
								},
							},
							Name: "key",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   13,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "\"unknown\"",
									Start: ast.Position{
										Column: 41,
										Line:   13,
									},
								},
							},
							Value: "unknown",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   13,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "dict.remove(dict: codes1, key: \"unknown\")",
						Start: ast.Position{
							Column: 10,
							Line:   13,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   13,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "dict.remove",
							Start: ast.Position{
								Column: 10,
								Line:   13,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   13,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "dict",
								Start: ast.Position{
									Column: 10,
									Line:   13,
								},
							},
						},
						Name: "dict",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   13,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "remove",
								Start: ast.Position{
									Column: 15,
									Line:   13,
								},
							},
						},
						Name: "remove",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 67,
						Line:   14,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "codes3 = dict.insert(dict: codes2, key: \"unimplemented\", value: 2)",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   14,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "codes3",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "codes3",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   14,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "dict: codes2, key: \"unimplemented\", value: 2",
							Start: ast.Position{
								Column: 22,
								Line:   14,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   14,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "dict: codes2",
								Start: ast.Position{
									Column: 22,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   14,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "dict",
									Start: ast.Position{
										Column: 22,
										Line:   14,
									},
								},
							},
							Name: "dict",
						},
						Separator: nil,
						Value: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   14,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "codes2",
									Start: ast.Position{
										Column: 28,
										Line:   14,
									},
								},
							},
							Name: "codes2",
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   14,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "key: \"unimplemented\"",
								Start: ast.Position{
									Column: 36,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   14,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "key",
									Start: ast.Position{
										Column: 36,
										Line:   14,
									},
								},
							},
							Name: "key",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   14,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "\"unimplemented\"",
									Start: ast.Position{
										Column: 41,
										Line:   14,
									},
								},
							},
							Value: "unimplemented",
						},
					}, &ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   14,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "value: 2",
								Start: ast.Position{
									Column: 58,
									Line:   14,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   14,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "value",
									Start: ast.Position{
										Column: 58,
										Line:   14,
									},
								},
							},
							Name: "value",
						},
						Separator: nil,
						Value: &ast.IntegerLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   14,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "2",
									Start: ast.Position{
										Column: 65,
										Line:   14,
									},
								},
							},
							Value: int64(2),
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 67,
							Line:   14,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "dict.insert(dict: codes2, key: \"unimplemented\", value: 2)",
						Start: ast.Position{
							Column: 10,
							Line:   14,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   14,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "dict.insert",
							Start: ast.Position{
								Column: 10,
								Line:   14,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   14,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "dict",
								Start: ast.Position{
									Column: 10,
									Line:   14,
								},
							},
						},
						Name: "dict",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   14,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "insert",
								Start: ast.Position{
									Column: 15,
									Line:   14,
								},
							},
						},
						Name: "insert",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   29,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   16,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   29,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   16,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long,long,long\n#group,false,false,false,true,true,true,false,false,false,false\n#default,_result,,,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code1,error_code2,error_code3\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0,0,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0,0,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1,1,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1,1,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,-1,-1,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,-1,-1,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,3,-1,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,3,-1,-1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   31,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   31,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long,long,long\n#group,false,false,false,true,true,true,false,false,false,false\n#default,_result,,,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code1,error_code2,error_code3\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0,0,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0,0,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1,1,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1,1,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,-1,-1,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,-1,-1,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,3,-1,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,3,-1,-1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   31,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long,long,long\n#group,false,false,false,true,true,true,false,false,false,false\n#default,_result,,,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code1,error_code2,error_code3\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0,0,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0,0,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1,1,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1,1,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,-1,-1,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,-1,-1,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,3,-1,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,3,-1,-1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 5,
						Line:   59,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "t_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  })",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   46,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "t_dict",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "t_dict",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   59,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "(table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  })",
						Start: ast.Position{
							Column: 10,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   47,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   47,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   48,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   47,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   48,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   48,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   48,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   48,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   48,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   48,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   48,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   48,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   49,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   47,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   49,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 11,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   49,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 11,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   49,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   49,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 20,
													Line:   49,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   49,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 21,
														Line:   49,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   49,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 31,
														Line:   49,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   49,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   49,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   49,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 5,
								Line:   59,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  })",
							Start: ast.Position{
								Column: 3,
								Line:   47,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   59,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  }",
									Start: ast.Position{
										Column: 10,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   59,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  }",
										Start: ast.Position{
											Column: 10,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   50,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   50,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   59,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "(r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  }",
											Start: ast.Position{
												Column: 14,
												Line:   50,
											},
										},
									},
									Body: &ast.Block{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 4,
													Line:   59,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "{\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  }",
												Start: ast.Position{
													Column: 21,
													Line:   50,
												},
											},
										},
										Body: []ast.Statement{&ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   51,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)",
													Start: ast.Position{
														Column: 5,
														Line:   51,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   51,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "error_code1",
														Start: ast.Position{
															Column: 5,
															Line:   51,
														},
													},
												},
												Name: "error_code1",
											},
											Init: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   51,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "dict: codes1, key: r.error_type, default: -1",
															Start: ast.Position{
																Column: 28,
																Line:   51,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   51,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "dict: codes1",
																Start: ast.Position{
																	Column: 28,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   51,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "dict",
																	Start: ast.Position{
																		Column: 28,
																		Line:   51,
																	},
																},
															},
															Name: "dict",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   51,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "codes1",
																	Start: ast.Position{
																		Column: 34,
																		Line:   51,
																	},
																},
															},
															Name: "codes1",
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   51,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "key: r.error_type",
																Start: ast.Position{
																	Column: 42,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   51,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 42,
																		Line:   51,
																	},
																},
															},
															Name: "key",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   51,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "r.error_type",
																	Start: ast.Position{
																		Column: 47,
																		Line:   51,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   51,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 47,
																			Line:   51,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   51,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "error_type",
																		Start: ast.Position{
																			Column: 49,
																			Line:   51,
																		},
																	},
																},
																Name: "error_type",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   51,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "default: -1",
																Start: ast.Position{
																	Column: 61,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   51,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "default",
																	Start: ast.Position{
																		Column: 61,
																		Line:   51,
																	},
																},
															},
															Name: "default",
														},
														Separator: nil,
														Value: &ast.UnaryExpression{
															Argument: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   51,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 71,
																			Line:   51,
																		},
																	},
																},
																Value: int64(1),
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   51,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "-1",
																	Start: ast.Position{
																		Column: 70,
																		Line:   51,
																	},
																},
															},
															Operator: 6,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   51,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "dict.get(dict: codes1, key: r.error_type, default: -1)",
														Start: ast.Position{
															Column: 19,
															Line:   51,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   51,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "dict.get",
															Start: ast.Position{
																Column: 19,
																Line:   51,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   51,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "dict",
																Start: ast.Position{
																	Column: 19,
																	Line:   51,
																},
															},
														},
														Name: "dict",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   51,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "get",
																Start: ast.Position{
																	Column: 24,
																	Line:   51,
																},
															},
														},
														Name: "get",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   52,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)",
													Start: ast.Position{
														Column: 5,
														Line:   52,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   52,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "error_code2",
														Start: ast.Position{
															Column: 5,
															Line:   52,
														},
													},
												},
												Name: "error_code2",
											},
											Init: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   52,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "dict: codes2, key: r.error_type, default: -1",
															Start: ast.Position{
																Column: 28,
																Line:   52,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   52,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "dict: codes2",
																Start: ast.Position{
																	Column: 28,
																	Line:   52,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   52,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "dict",
																	Start: ast.Position{
																		Column: 28,
																		Line:   52,
																	},
																},
															},
															Name: "dict",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   52,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "codes2",
																	Start: ast.Position{
																		Column: 34,
																		Line:   52,
																	},
																},
															},
															Name: "codes2",
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   52,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "key: r.error_type",
																Start: ast.Position{
																	Column: 42,
																	Line:   52,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   52,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 42,
																		Line:   52,
																	},
																},
															},
															Name: "key",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   52,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "r.error_type",
																	Start: ast.Position{
																		Column: 47,
																		Line:   52,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   52,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 47,
																			Line:   52,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   52,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "error_type",
																		Start: ast.Position{
																			Column: 49,
																			Line:   52,
																		},
																	},
																},
																Name: "error_type",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   52,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "default: -1",
																Start: ast.Position{
																	Column: 61,
																	Line:   52,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   52,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "default",
																	Start: ast.Position{
																		Column: 61,
																		Line:   52,
																	},
																},
															},
															Name: "default",
														},
														Separator: nil,
														Value: &ast.UnaryExpression{
															Argument: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   52,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 71,
																			Line:   52,
																		},
																	},
																},
																Value: int64(1),
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   52,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "-1",
																	Start: ast.Position{
																		Column: 70,
																		Line:   52,
																	},
																},
															},
															Operator: 6,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   52,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "dict.get(dict: codes2, key: r.error_type, default: -1)",
														Start: ast.Position{
															Column: 19,
															Line:   52,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   52,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "dict.get",
															Start: ast.Position{
																Column: 19,
																Line:   52,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   52,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "dict",
																Start: ast.Position{
																	Column: 19,
																	Line:   52,
																},
															},
														},
														Name: "dict",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   52,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "get",
																Start: ast.Position{
																	Column: 24,
																	Line:   52,
																},
															},
														},
														Name: "get",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   53,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)",
													Start: ast.Position{
														Column: 5,
														Line:   53,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   53,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "error_code3",
														Start: ast.Position{
															Column: 5,
															Line:   53,
														},
													},
												},
												Name: "error_code3",
											},
											Init: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   53,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "dict: codes3, key: r.error_type, default: -1",
															Start: ast.Position{
																Column: 28,
																Line:   53,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 40,
																	Line:   53,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "dict: codes3",
																Start: ast.Position{
																	Column: 28,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 32,
																		Line:   53,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "dict",
																	Start: ast.Position{
																		Column: 28,
																		Line:   53,
																	},
																},
															},
															Name: "dict",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   53,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "codes3",
																	Start: ast.Position{
																		Column: 34,
																		Line:   53,
																	},
																},
															},
															Name: "codes3",
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   53,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "key: r.error_type",
																Start: ast.Position{
																	Column: 42,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   53,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 42,
																		Line:   53,
																	},
																},
															},
															Name: "key",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   53,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "r.error_type",
																	Start: ast.Position{
																		Column: 47,
																		Line:   53,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   53,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 47,
																			Line:   53,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   53,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "error_type",
																		Start: ast.Position{
																			Column: 49,
																			Line:   53,
																		},
																	},
																},
																Name: "error_type",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   53,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "default: -1",
																Start: ast.Position{
																	Column: 61,
																	Line:   53,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   53,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "default",
																	Start: ast.Position{
																		Column: 61,
																		Line:   53,
																	},
																},
															},
															Name: "default",
														},
														Separator: nil,
														Value: &ast.UnaryExpression{
															Argument: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   53,
																		},
																		File:   "dict_insert_remove_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 71,
																			Line:   53,
																		},
																	},
																},
																Value: int64(1),
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   53,
																	},
																	File:   "dict_insert_remove_test.flux",
																	Source: "-1",
																	Start: ast.Position{
																		Column: 70,
																		Line:   53,
																	},
																},
															},
															Operator: 6,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   53,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "dict.get(dict: codes3, key: r.error_type, default: -1)",
														Start: ast.Position{
															Column: 19,
															Line:   53,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   53,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "dict.get",
															Start: ast.Position{
																Column: 19,
																Line:   53,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   53,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "dict",
																Start: ast.Position{
																	Column: 19,
																	Line:   53,
																},
															},
														},
														Name: "dict",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   53,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "get",
																Start: ast.Position{
																	Column: 24,
																	Line:   53,
																},
															},
														},
														Name: "get",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.ReturnStatement{
											Argument: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 6,
															Line:   58,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "{r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }",
														Start: ast.Position{
															Column: 12,
															Line:   54,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   55,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "error_code1: error_code1",
															Start: ast.Position{
																Column: 7,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   55,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "error_code1",
																Start: ast.Position{
																	Column: 7,
																	Line:   55,
																},
															},
														},
														Name: "error_code1",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   55,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "error_code1",
																Start: ast.Position{
																	Column: 20,
																	Line:   55,
																},
															},
														},
														Name: "error_code1",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   56,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "error_code2: error_code2",
															Start: ast.Position{
																Column: 7,
																Line:   56,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   56,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "error_code2",
																Start: ast.Position{
																	Column: 7,
																	Line:   56,
																},
															},
														},
														Name: "error_code2",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   56,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "error_code2",
																Start: ast.Position{
																	Column: 20,
																	Line:   56,
																},
															},
														},
														Name: "error_code2",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   57,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "error_code3: error_code3",
															Start: ast.Position{
																Column: 7,
																Line:   57,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   57,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "error_code3",
																Start: ast.Position{
																	Column: 7,
																	Line:   57,
																},
															},
														},
														Name: "error_code3",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   57,
																},
																File:   "dict_insert_remove_test.flux",
																Source: "error_code3",
																Start: ast.Position{
																	Column: 20,
																	Line:   57,
																},
															},
														},
														Name: "error_code3",
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   54,
															},
															File:   "dict_insert_remove_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 13,
																Line:   54,
															},
														},
													},
													Name: "r",
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 6,
														Line:   58,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }",
													Start: ast.Position{
														Column: 5,
														Line:   54,
													},
												},
											},
										}},
										Lbrace: nil,
										Rbrace: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   50,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   50,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   50,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 5,
									Line:   59,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "map(fn: (r) => {\n    error_code1 = dict.get(dict: codes1, key: r.error_type, default: -1)\n    error_code2 = dict.get(dict: codes2, key: r.error_type, default: -1)\n    error_code3 = dict.get(dict: codes3, key: r.error_type, default: -1)\n    return {r with\n      error_code1: error_code1,\n      error_code2: error_code2,\n      error_code3: error_code3,\n    }\n  })",
								Start: ast.Position{
									Column: 6,
									Line:   50,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   50,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   50,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   46,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   46,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   46,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   46,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   65,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "_dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   61,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   61,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "_dict",
							Start: ast.Position{
								Column: 6,
								Line:   61,
							},
						},
					},
					Name: "_dict",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   65,
							},
							File:   "dict_insert_remove_test.flux",
							Source: "() => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
							Start: ast.Position{
								Column: 14,
								Line:   61,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   65,
								},
								File:   "dict_insert_remove_test.flux",
								Source: "({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
								Start: ast.Position{
									Column: 20,
									Line:   61,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   65,
									},
									File:   "dict_insert_remove_test.flux",
									Source: "{\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n}",
									Start: ast.Position{
										Column: 21,
										Line:   61,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   62,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 3,
											Line:   62,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   62,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   62,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   62,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 30,
													Line:   62,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   62,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 30,
														Line:   62,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   62,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   62,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   62,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 35,
															Line:   62,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   62,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 10,
												Line:   62,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   62,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   62,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   62,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   62,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   62,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   62,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   63,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 3,
											Line:   63,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   63,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   63,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   63,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 25,
													Line:   63,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   63,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 25,
														Line:   63,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   63,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   63,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   63,
														},
														File:   "dict_insert_remove_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 30,
															Line:   63,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   63,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 9,
												Line:   63,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   63,
												},
												File:   "dict_insert_remove_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   63,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   63,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   63,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   63,
													},
													File:   "dict_insert_remove_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   63,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   64,
										},
										File:   "dict_insert_remove_test.flux",
										Source: "fn: t_dict",
										Start: ast.Position{
											Column: 3,
											Line:   64,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   64,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   64,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   64,
											},
											File:   "dict_insert_remove_test.flux",
											Source: "t_dict",
											Start: ast.Position{
												Column: 7,
												Line:   64,
											},
										},
									},
									Name: "t_dict",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   65,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "test _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   61,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "dict",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "dict_insert_remove_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "dict_insert_remove_test.flux",
					Source: "package dict_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "dict_insert_remove_test.flux",
						Source: "dict_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "dict_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   39,
				},
				File:   "dict_lit_lambda_test.flux",
				Source: "package dict_test\n\nimport \"testing\"\nimport \"dict\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n\"\n\nt_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  })\n\ntest _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   14,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   14,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   16,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   16,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 5,
						Line:   33,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "t_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  })",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   26,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "t_dict",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "t_dict",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   33,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "(table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  })",
						Start: ast.Position{
							Column: 10,
							Line:   26,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   27,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   27,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   28,
									},
									File:   "dict_lit_lambda_test.flux",
									Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   27,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   28,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   28,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   28,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   28,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   28,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   28,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   28,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   28,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   28,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   28,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   29,
								},
								File:   "dict_lit_lambda_test.flux",
								Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   27,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   29,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 11,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   29,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 11,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   29,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   29,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   29,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 20,
													Line:   29,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   29,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 21,
														Line:   29,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   29,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 31,
														Line:   29,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   29,
									},
									File:   "dict_lit_lambda_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   29,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   29,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 5,
								Line:   33,
							},
							File:   "dict_lit_lambda_test.flux",
							Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  })",
							Start: ast.Position{
								Column: 3,
								Line:   27,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   33,
									},
									File:   "dict_lit_lambda_test.flux",
									Source: "fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  }",
									Start: ast.Position{
										Column: 10,
										Line:   30,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   33,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  }",
										Start: ast.Position{
											Column: 10,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   30,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   30,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   33,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "(r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  }",
											Start: ast.Position{
												Column: 14,
												Line:   30,
											},
										},
									},
									Body: &ast.Block{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 4,
													Line:   33,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "{\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  }",
												Start: ast.Position{
													Column: 21,
													Line:   30,
												},
											},
										},
										Body: []ast.Statement{&ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   31,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "codes = [0: \"a\", 1: \"b\"]",
													Start: ast.Position{
														Column: 5,
														Line:   31,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   31,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "codes",
														Start: ast.Position{
															Column: 5,
															Line:   31,
														},
													},
												},
												Name: "codes",
											},
											Init: &ast.DictExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   31,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "[0: \"a\", 1: \"b\"]",
														Start: ast.Position{
															Column: 13,
															Line:   31,
														},
													},
												},
												Elements: []*ast.DictItem{&ast.DictItem{
													Comma: nil,
													Key: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   31,
																},
																File:   "dict_lit_lambda_test.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 14,
																	Line:   31,
																},
															},
														},
														Value: int64(0),
													},
													Val: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   31,
																},
																File:   "dict_lit_lambda_test.flux",
																Source: "\"a\"",
																Start: ast.Position{
																	Column: 17,
																	Line:   31,
																},
															},
														},
														Value: "a",
													},
												}, &ast.DictItem{
													Comma: nil,
													Key: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   31,
																},
																File:   "dict_lit_lambda_test.flux",
																Source: "1",
																Start: ast.Position{
																	Column: 22,
																	Line:   31,
																},
															},
														},
														Value: int64(1),
													},
													Val: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 28,
																	Line:   31,
																},
																File:   "dict_lit_lambda_test.flux",
																Source: "\"b\"",
																Start: ast.Position{
																	Column: 25,
																	Line:   31,
																},
															},
														},
														Value: "b",
													},
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}, &ast.ReturnStatement{
											Argument: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   32,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "{r with code: dict.get(dict: codes, key: r._value, default: \"c\")}",
														Start: ast.Position{
															Column: 12,
															Line:   32,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   32,
															},
															File:   "dict_lit_lambda_test.flux",
															Source: "code: dict.get(dict: codes, key: r._value, default: \"c\")",
															Start: ast.Position{
																Column: 20,
																Line:   32,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   32,
																},
																File:   "dict_lit_lambda_test.flux",
																Source: "code",
																Start: ast.Position{
																	Column: 20,
																	Line:   32,
																},
															},
														},
														Name: "code",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   32,
																	},
																	File:   "dict_lit_lambda_test.flux",
																	Source: "dict: codes, key: r._value, default: \"c\"",
																	Start: ast.Position{
																		Column: 35,
																		Line:   32,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   32,
																		},
																		File:   "dict_lit_lambda_test.flux",
																		Source: "dict: codes",
																		Start: ast.Position{
																			Column: 35,
																			Line:   32,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   32,
																			},
																			File:   "dict_lit_lambda_test.flux",
																			Source: "dict",
																			Start: ast.Position{
																				Column: 35,
																				Line:   32,
																			},
																		},
																	},
																	Name: "dict",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   32,
																			},
																			File:   "dict_lit_lambda_test.flux",
																			Source: "codes",
																			Start: ast.Position{
																				Column: 41,
																				Line:   32,
																			},
																		},
																	},
																	Name: "codes",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   32,
																		},
																		File:   "dict_lit_lambda_test.flux",
																		Source: "key: r._value",
																		Start: ast.Position{
																			Column: 48,
																			Line:   32,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   32,
																			},
																			File:   "dict_lit_lambda_test.flux",
																			Source: "key",
																			Start: ast.Position{
																				Column: 48,
																				Line:   32,
																			},
																		},
																	},
																	Name: "key",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   32,
																			},
																			File:   "dict_lit_lambda_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 53,
																				Line:   32,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   32,
																				},
																				File:   "dict_lit_lambda_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 53,
																					Line:   32,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   32,
																				},
																				File:   "dict_lit_lambda_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 55,
																					Line:   32,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   32,
																		},
																		File:   "dict_lit_lambda_test.flux",
																		Source: "default: \"c\"",
																		Start: ast.Position{
																			Column: 63,
																			Line:   32,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   32,
																			},
																			File:   "dict_lit_lambda_test.flux",
																			Source: "default",
																			Start: ast.Position{
																				Column: 63,
																				Line:   32,
																			},
																		},
																	},
																	Name: "default",
																},
																Separator: nil,
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   32,
																			},
																			File:   "dict_lit_lambda_test.flux",
																			Source: "\"c\"",
																			Start: ast.Position{
																				Column: 72,
																				Line:   32,
																			},
																		},
																	},
																	Value: "c",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   32,
																},
																File:   "dict_lit_lambda_test.flux",
																Source: "dict.get(dict: codes, key: r._value, default: \"c\")",
																Start: ast.Position{
																	Column: 26,
																	Line:   32,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   32,
																	},
																	File:   "dict_lit_lambda_test.flux",
																	Source: "dict.get",
																	Start: ast.Position{
																		Column: 26,
																		Line:   32,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   32,
																		},
																		File:   "dict_lit_lambda_test.flux",
																		Source: "dict",
																		Start: ast.Position{
																			Column: 26,
																			Line:   32,
																		},
																	},
																},
																Name: "dict",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   32,
																		},
																		File:   "dict_lit_lambda_test.flux",
																		Source: "get",
																		Start: ast.Position{
																			Column: 31,
																			Line:   32,
																		},
																	},
																},
																Name: "get",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   32,
															},
															File:   "dict_lit_lambda_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 13,
																Line:   32,
															},
														},
													},
													Name: "r",
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   32,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}",
													Start: ast.Position{
														Column: 5,
														Line:   32,
													},
												},
											},
										}},
										Lbrace: nil,
										Rbrace: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   30,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   30,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   30,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 5,
									Line:   33,
								},
								File:   "dict_lit_lambda_test.flux",
								Source: "map(fn: (r) => {\n    codes = [0: \"a\", 1: \"b\"]\n    return {r with code: dict.get(dict: codes, key: r._value, default: \"c\")}\n  })",
								Start: ast.Position{
									Column: 6,
									Line:   30,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   30,
									},
									File:   "dict_lit_lambda_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   30,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   26,
							},
							File:   "dict_lit_lambda_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   26,
								},
								File:   "dict_lit_lambda_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   26,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   26,
							},
							File:   "dict_lit_lambda_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   26,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   39,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "_dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   35,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   35,
							},
							File:   "dict_lit_lambda_test.flux",
							Source: "_dict",
							Start: ast.Position{
								Column: 6,
								Line:   35,
							},
						},
					},
					Name: "_dict",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   39,
							},
							File:   "dict_lit_lambda_test.flux",
							Source: "() => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
							Start: ast.Position{
								Column: 14,
								Line:   35,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   39,
								},
								File:   "dict_lit_lambda_test.flux",
								Source: "({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
								Start: ast.Position{
									Column: 20,
									Line:   35,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   39,
									},
									File:   "dict_lit_lambda_test.flux",
									Source: "{\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n}",
									Start: ast.Position{
										Column: 21,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   36,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 3,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   36,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   36,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   36,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 30,
													Line:   36,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   36,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 30,
														Line:   36,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   36,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   36,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   36,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 35,
															Line:   36,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   36,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 10,
												Line:   36,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   36,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   36,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   36,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   36,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   36,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   36,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   37,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 3,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   37,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   37,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 25,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   37,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 25,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   37,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   37,
														},
														File:   "dict_lit_lambda_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 30,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   37,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 9,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   37,
												},
												File:   "dict_lit_lambda_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   37,
													},
													File:   "dict_lit_lambda_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   38,
										},
										File:   "dict_lit_lambda_test.flux",
										Source: "fn: t_dict",
										Start: ast.Position{
											Column: 3,
											Line:   38,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   38,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   38,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   38,
											},
											File:   "dict_lit_lambda_test.flux",
											Source: "t_dict",
											Start: ast.Position{
												Column: 7,
												Line:   38,
											},
										},
									},
									Name: "t_dict",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   39,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "test _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "dict",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "dict_lit_lambda_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "dict_lit_lambda_test.flux",
					Source: "package dict_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "dict_lit_lambda_test.flux",
						Source: "dict_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "dict_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   38,
				},
				File:   "dict_lit_test.flux",
				Source: "package dict_test\n\nimport \"testing\"\nimport \"dict\"\n\ncodes = [0: \"a\", 1: \"b\"]\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n\"\n\nt_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")}))\n\ntest _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   6,
					},
					File:   "dict_lit_test.flux",
					Source: "codes = [0: \"a\", 1: \"b\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   6,
						},
						File:   "dict_lit_test.flux",
						Source: "codes",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "codes",
			},
			Init: &ast.DictExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   6,
						},
						File:   "dict_lit_test.flux",
						Source: "[0: \"a\", 1: \"b\"]",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Elements: []*ast.DictItem{&ast.DictItem{
					Comma: nil,
					Key: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   6,
								},
								File:   "dict_lit_test.flux",
								Source: "0",
								Start: ast.Position{
									Column: 10,
									Line:   6,
								},
							},
						},
						Value: int64(0),
					},
					Val: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   6,
								},
								File:   "dict_lit_test.flux",
								Source: "\"a\"",
								Start: ast.Position{
									Column: 13,
									Line:   6,
								},
							},
						},
						Value: "a",
					},
				}, &ast.DictItem{
					Comma: nil,
					Key: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   6,
								},
								File:   "dict_lit_test.flux",
								Source: "1",
								Start: ast.Position{
									Column: 18,
									Line:   6,
								},
							},
						},
						Value: int64(1),
					},
					Val: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   6,
								},
								File:   "dict_lit_test.flux",
								Source: "\"b\"",
								Start: ast.Position{
									Column: 21,
									Line:   6,
								},
							},
						},
						Value: "b",
					},
				}},
				Lbrack: nil,
				Rbrack: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   16,
					},
					File:   "dict_lit_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "dict_lit_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   16,
						},
						File:   "dict_lit_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,1\n,,0,2018-05-22T19:53:46Z,_m,_f,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "dict_lit_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   18,
						},
						File:   "dict_lit_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   18,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "dict_lit_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   18,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long,string\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,a\n,,0,2018-05-22T19:53:36Z,_m,_f,1,b\n,,0,2018-05-22T19:53:46Z,_m,_f,2,c\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   32,
					},
					File:   "dict_lit_test.flux",
					Source: "t_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")}))",
					Start: ast.Position{
						Column: 1,
						Line:   28,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   28,
						},
						File:   "dict_lit_test.flux",
						Source: "t_dict",
						Start: ast.Position{
							Column: 1,
							Line:   28,
						},
					},
				},
				Name: "t_dict",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   32,
						},
						File:   "dict_lit_test.flux",
						Source: "(table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")}))",
						Start: ast.Position{
							Column: 10,
							Line:   28,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   29,
										},
										File:   "dict_lit_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   29,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   30,
									},
									File:   "dict_lit_test.flux",
									Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   29,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   30,
											},
											File:   "dict_lit_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   30,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   30,
												},
												File:   "dict_lit_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   30,
													},
													File:   "dict_lit_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   30,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   30,
													},
													File:   "dict_lit_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   30,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   30,
										},
										File:   "dict_lit_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   30,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   30,
											},
											File:   "dict_lit_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   30,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   31,
								},
								File:   "dict_lit_test.flux",
								Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   29,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   31,
										},
										File:   "dict_lit_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 11,
											Line:   31,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   31,
											},
											File:   "dict_lit_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 11,
												Line:   31,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   31,
												},
												File:   "dict_lit_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   31,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   31,
												},
												File:   "dict_lit_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 20,
													Line:   31,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   31,
													},
													File:   "dict_lit_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 21,
														Line:   31,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   31,
													},
													File:   "dict_lit_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 31,
														Line:   31,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   31,
									},
									File:   "dict_lit_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   31,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   31,
										},
										File:   "dict_lit_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   31,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   32,
							},
							File:   "dict_lit_test.flux",
							Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")}))",
							Start: ast.Position{
								Column: 3,
								Line:   29,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   32,
									},
									File:   "dict_lit_test.flux",
									Source: "fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")})",
									Start: ast.Position{
										Column: 10,
										Line:   32,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   32,
										},
										File:   "dict_lit_test.flux",
										Source: "fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")})",
										Start: ast.Position{
											Column: 10,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   32,
											},
											File:   "dict_lit_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   32,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   32,
											},
											File:   "dict_lit_test.flux",
											Source: "(r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")})",
											Start: ast.Position{
												Column: 14,
												Line:   32,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   32,
												},
												File:   "dict_lit_test.flux",
												Source: "({r with code: dict.get(dict: codes, key: r._value, default: \"c\")})",
												Start: ast.Position{
													Column: 21,
													Line:   32,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   32,
													},
													File:   "dict_lit_test.flux",
													Source: "{r with code: dict.get(dict: codes, key: r._value, default: \"c\")}",
													Start: ast.Position{
														Column: 22,
														Line:   32,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 86,
															Line:   32,
														},
														File:   "dict_lit_test.flux",
														Source: "code: dict.get(dict: codes, key: r._value, default: \"c\")",
														Start: ast.Position{
															Column: 30,
															Line:   32,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   32,
															},
															File:   "dict_lit_test.flux",
															Source: "code",
															Start: ast.Position{
																Column: 30,
																Line:   32,
															},
														},
													},
													Name: "code",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 85,
																	Line:   32,
																},
																File:   "dict_lit_test.flux",
																Source: "dict: codes, key: r._value, default: \"c\"",
																Start: ast.Position{
																	Column: 45,
																	Line:   32,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   32,
																	},
																	File:   "dict_lit_test.flux",
																	Source: "dict: codes",
																	Start: ast.Position{
																		Column: 45,
																		Line:   32,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   32,
																		},
																		File:   "dict_lit_test.flux",
																		Source: "dict",
																		Start: ast.Position{
																			Column: 45,
																			Line:   32,
																		},
																	},
																},
																Name: "dict",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   32,
																		},
																		File:   "dict_lit_test.flux",
																		Source: "codes",
																		Start: ast.Position{
																			Column: 51,
																			Line:   32,
																		},
																	},
																},
																Name: "codes",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 71,
																		Line:   32,
																	},
																	File:   "dict_lit_test.flux",
																	Source: "key: r._value",
																	Start: ast.Position{
																		Column: 58,
																		Line:   32,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   32,
																		},
																		File:   "dict_lit_test.flux",
																		Source: "key",
																		Start: ast.Position{
																			Column: 58,
																			Line:   32,
																		},
																	},
																},
																Name: "key",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 71,
																			Line:   32,
																		},
																		File:   "dict_lit_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 63,
																			Line:   32,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   32,
																			},
																			File:   "dict_lit_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 63,
																				Line:   32,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 71,
																				Line:   32,
																			},
																			File:   "dict_lit_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 65,
																				Line:   32,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   32,
																	},
																	File:   "dict_lit_test.flux",
																	Source: "default: \"c\"",
																	Start: ast.Position{
																		Column: 73,
																		Line:   32,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   32,
																		},
																		File:   "dict_lit_test.flux",
																		Source: "default",
																		Start: ast.Position{
																			Column: 73,
																			Line:   32,
																		},
																	},
																},
																Name: "default",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   32,
																		},
																		File:   "dict_lit_test.flux",
																		Source: "\"c\"",
																		Start: ast.Position{
																			Column: 82,
																			Line:   32,
																		},
																	},
																},
																Value: "c",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 86,
																Line:   32,
															},
															File:   "dict_lit_test.flux",
															Source: "dict.get(dict: codes, key: r._value, default: \"c\")",
															Start: ast.Position{
																Column: 36,
																Line:   32,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   32,
																},
																File:   "dict_lit_test.flux",
																Source: "dict.get",
																Start: ast.Position{
																	Column: 36,
																	Line:   32,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   32,
																	},
																	File:   "dict_lit_test.flux",
																	Source: "dict",
																	Start: ast.Position{
																		Column: 36,
																		Line:   32,
																	},
																},
															},
															Name: "dict",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   32,
																	},
																	File:   "dict_lit_test.flux",
																	Source: "get",
																	Start: ast.Position{
																		Column: 41,
																		Line:   32,
																	},
																},
															},
															Name: "get",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   32,
														},
														File:   "dict_lit_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 23,
															Line:   32,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   32,
												},
												File:   "dict_lit_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   32,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   32,
													},
													File:   "dict_lit_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   32,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   32,
								},
								File:   "dict_lit_test.flux",
								Source: "map(fn: (r) => ({r with code: dict.get(dict: codes, key: r._value, default: \"c\")}))",
								Start: ast.Position{
									Column: 6,
									Line:   32,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   32,
									},
									File:   "dict_lit_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   32,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   28,
							},
							File:   "dict_lit_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   28,
								},
								File:   "dict_lit_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   28,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   28,
							},
							File:   "dict_lit_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   28,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   38,
						},
						File:   "dict_lit_test.flux",
						Source: "_dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   34,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   34,
							},
							File:   "dict_lit_test.flux",
							Source: "_dict",
							Start: ast.Position{
								Column: 6,
								Line:   34,
							},
						},
					},
					Name: "_dict",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   38,
							},
							File:   "dict_lit_test.flux",
							Source: "() => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
							Start: ast.Position{
								Column: 14,
								Line:   34,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   38,
								},
								File:   "dict_lit_test.flux",
								Source: "({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
								Start: ast.Position{
									Column: 20,
									Line:   34,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   38,
									},
									File:   "dict_lit_test.flux",
									Source: "{\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n}",
									Start: ast.Position{
										Column: 21,
										Line:   34,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   35,
										},
										File:   "dict_lit_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   35,
											},
											File:   "dict_lit_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   35,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   35,
												},
												File:   "dict_lit_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 30,
													Line:   35,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   35,
													},
													File:   "dict_lit_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 30,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   35,
														},
														File:   "dict_lit_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   35,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   35,
														},
														File:   "dict_lit_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 35,
															Line:   35,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   35,
											},
											File:   "dict_lit_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 10,
												Line:   35,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   35,
												},
												File:   "dict_lit_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   35,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   35,
													},
													File:   "dict_lit_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   35,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   35,
													},
													File:   "dict_lit_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   35,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   36,
										},
										File:   "dict_lit_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 3,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   36,
											},
											File:   "dict_lit_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   36,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   36,
												},
												File:   "dict_lit_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 25,
													Line:   36,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   36,
													},
													File:   "dict_lit_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 25,
														Line:   36,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   36,
														},
														File:   "dict_lit_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   36,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   36,
														},
														File:   "dict_lit_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 30,
															Line:   36,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   36,
											},
											File:   "dict_lit_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 9,
												Line:   36,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   36,
												},
												File:   "dict_lit_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   36,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   36,
													},
													File:   "dict_lit_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   36,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   36,
													},
													File:   "dict_lit_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   36,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   37,
										},
										File:   "dict_lit_test.flux",
										Source: "fn: t_dict",
										Start: ast.Position{
											Column: 3,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   37,
											},
											File:   "dict_lit_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   37,
											},
											File:   "dict_lit_test.flux",
											Source: "t_dict",
											Start: ast.Position{
												Column: 7,
												Line:   37,
											},
										},
									},
									Name: "t_dict",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   38,
					},
					File:   "dict_lit_test.flux",
					Source: "test _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "dict_lit_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "dict_lit_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "dict_lit_test.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "dict_lit_test.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "dict",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "dict_lit_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "dict_lit_test.flux",
					Source: "package dict_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "dict_lit_test.flux",
						Source: "dict_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "dict_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   57,
				},
				File:   "dict_test.flux",
				Source: "package dict_test\n\nimport \"testing\"\nimport \"dict\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ncodes = dict.fromList(pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unimplemented\", value: 2},\n])\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,false,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,-1\n\"\n\nt_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  })\n\ntest _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "dict_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "dict_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "dict_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "dict_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "dict_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "dict_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   12,
					},
					File:   "dict_test.flux",
					Source: "codes = dict.fromList(pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unimplemented\", value: 2},\n])",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   8,
						},
						File:   "dict_test.flux",
						Source: "codes",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "codes",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   12,
							},
							File:   "dict_test.flux",
							Source: "pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unimplemented\", value: 2},\n]",
							Start: ast.Position{
								Column: 23,
								Line:   8,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   12,
								},
								File:   "dict_test.flux",
								Source: "pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unimplemented\", value: 2},\n]",
								Start: ast.Position{
									Column: 23,
									Line:   8,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   8,
									},
									File:   "dict_test.flux",
									Source: "pairs",
									Start: ast.Position{
										Column: 23,
										Line:   8,
									},
								},
							},
							Name: "pairs",
						},
						Separator: nil,
						Value: &ast.ArrayExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   12,
									},
									File:   "dict_test.flux",
									Source: "[\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unimplemented\", value: 2},\n]",
									Start: ast.Position{
										Column: 30,
										Line:   8,
									},
								},
							},
							Elements: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   9,
										},
										File:   "dict_test.flux",
										Source: "{key: \"internal\", value: 0}",
										Start: ast.Position{
											Column: 3,
											Line:   9,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   9,
											},
											File:   "dict_test.flux",
											Source: "key: \"internal\"",
											Start: ast.Position{
												Column: 4,
												Line:   9,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 7,
													Line:   9,
												},
												File:   "dict_test.flux",
												Source: "key",
												Start: ast.Position{
													Column: 4,
													Line:   9,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   9,
												},
												File:   "dict_test.flux",
												Source: "\"internal\"",
												Start: ast.Position{
													Column: 9,
													Line:   9,
												},
											},
										},
										Value: "internal",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   9,
											},
											File:   "dict_test.flux",
											Source: "value: 0",
											Start: ast.Position{
												Column: 21,
												Line:   9,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   9,
												},
												File:   "dict_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 21,
													Line:   9,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   9,
												},
												File:   "dict_test.flux",
												Source: "0",
												Start: ast.Position{
													Column: 28,
													Line:   9,
												},
											},
										},
										Value: int64(0),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}, &ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   10,
										},
										File:   "dict_test.flux",
										Source: "{key: \"invalid\", value: 1}",
										Start: ast.Position{
											Column: 3,
											Line:   10,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   10,
											},
											File:   "dict_test.flux",
											Source: "key: \"invalid\"",
											Start: ast.Position{
												Column: 4,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 7,
													Line:   10,
												},
												File:   "dict_test.flux",
												Source: "key",
												Start: ast.Position{
													Column: 4,
													Line:   10,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   10,
												},
												File:   "dict_test.flux",
												Source: "\"invalid\"",
												Start: ast.Position{
													Column: 9,
													Line:   10,
												},
											},
										},
										Value: "invalid",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   10,
											},
											File:   "dict_test.flux",
											Source: "value: 1",
											Start: ast.Position{
												Column: 20,
												Line:   10,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   10,
												},
												File:   "dict_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 20,
													Line:   10,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   10,
												},
												File:   "dict_test.flux",
												Source: "1",
												Start: ast.Position{
													Column: 27,
													Line:   10,
												},
											},
										},
										Value: int64(1),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}, &ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   11,
										},
										File:   "dict_test.flux",
										Source: "{key: \"unimplemented\", value: 2}",
										Start: ast.Position{
											Column: 3,
											Line:   11,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   11,
											},
											File:   "dict_test.flux",
											Source: "key: \"unimplemented\"",
											Start: ast.Position{
												Column: 4,
												Line:   11,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 7,
													Line:   11,
												},
												File:   "dict_test.flux",
												Source: "key",
												Start: ast.Position{
													Column: 4,
													Line:   11,
												},
											},
										},
										Name: "key",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   11,
												},
												File:   "dict_test.flux",
												Source: "\"unimplemented\"",
												Start: ast.Position{
													Column: 9,
													Line:   11,
												},
											},
										},
										Value: "unimplemented",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   11,
											},
											File:   "dict_test.flux",
											Source: "value: 2",
											Start: ast.Position{
												Column: 26,
												Line:   11,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   11,
												},
												File:   "dict_test.flux",
												Source: "value",
												Start: ast.Position{
													Column: 26,
													Line:   11,
												},
											},
										},
										Name: "value",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   11,
												},
												File:   "dict_test.flux",
												Source: "2",
												Start: ast.Position{
													Column: 33,
													Line:   11,
												},
											},
										},
										Value: int64(2),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							Lbrack: nil,
							Rbrack: nil,
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   12,
						},
						File:   "dict_test.flux",
						Source: "dict.fromList(pairs: [\n  {key: \"internal\", value: 0},\n  {key: \"invalid\", value: 1},\n  {key: \"unimplemented\", value: 2},\n])",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   8,
							},
							File:   "dict_test.flux",
							Source: "dict.fromList",
							Start: ast.Position{
								Column: 9,
								Line:   8,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   8,
								},
								File:   "dict_test.flux",
								Source: "dict",
								Start: ast.Position{
									Column: 9,
									Line:   8,
								},
							},
						},
						Name: "dict",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   8,
								},
								File:   "dict_test.flux",
								Source: "fromList",
								Start: ast.Position{
									Column: 14,
									Line:   8,
								},
							},
						},
						Name: "fromList",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   27,
					},
					File:   "dict_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   14,
						},
						File:   "dict_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   14,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   27,
						},
						File:   "dict_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   14,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "dict_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,false,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,-1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   29,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   29,
						},
						File:   "dict_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   29,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "dict_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,false,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,-1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   29,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,long\n#group,false,false,false,true,true,true,false,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,_field,error_type,_value,error_code\n,,0,2018-05-22T19:53:26Z,requests,error,internal,some internal error,0\n,,0,2018-05-22T19:53:36Z,requests,error,internal,another internal error,0\n,,1,2018-05-22T19:53:46Z,requests,error,invalid,unknown parameter,1\n,,1,2018-05-22T19:53:56Z,requests,error,invalid,cannot use duration as value,1\n,,2,2018-05-22T19:54:06Z,requests,error,unimplemented,implement me,2\n,,2,2018-05-22T19:54:16Z,requests,error,unimplemented,not implemented,2\n,,3,2018-05-22T19:53:26Z,requests,error,unknown,unknown error,-1\n,,3,2018-05-22T19:53:36Z,requests,error,unknown,network error,-1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 5,
						Line:   51,
					},
					File:   "dict_test.flux",
					Source: "t_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  })",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   44,
						},
						File:   "dict_test.flux",
						Source: "t_dict",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "t_dict",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   51,
						},
						File:   "dict_test.flux",
						Source: "(table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  })",
						Start: ast.Position{
							Column: 10,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   45,
										},
										File:   "dict_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   45,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   46,
									},
									File:   "dict_test.flux",
									Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   45,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   46,
											},
											File:   "dict_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   46,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   46,
												},
												File:   "dict_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   46,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   46,
													},
													File:   "dict_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   46,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   46,
													},
													File:   "dict_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   46,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   46,
										},
										File:   "dict_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   46,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   46,
											},
											File:   "dict_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   46,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   47,
								},
								File:   "dict_test.flux",
								Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   45,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   47,
										},
										File:   "dict_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 11,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   47,
											},
											File:   "dict_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 11,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   47,
												},
												File:   "dict_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   47,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   47,
												},
												File:   "dict_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 20,
													Line:   47,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   47,
													},
													File:   "dict_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 21,
														Line:   47,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   47,
													},
													File:   "dict_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 31,
														Line:   47,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   47,
									},
									File:   "dict_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   47,
										},
										File:   "dict_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   47,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 5,
								Line:   51,
							},
							File:   "dict_test.flux",
							Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  })",
							Start: ast.Position{
								Column: 3,
								Line:   45,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   51,
									},
									File:   "dict_test.flux",
									Source: "fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  }",
									Start: ast.Position{
										Column: 10,
										Line:   48,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   51,
										},
										File:   "dict_test.flux",
										Source: "fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  }",
										Start: ast.Position{
											Column: 10,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   48,
											},
											File:   "dict_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   48,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   51,
											},
											File:   "dict_test.flux",
											Source: "(r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  }",
											Start: ast.Position{
												Column: 14,
												Line:   48,
											},
										},
									},
									Body: &ast.Block{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 4,
													Line:   51,
												},
												File:   "dict_test.flux",
												Source: "{\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  }",
												Start: ast.Position{
													Column: 21,
													Line:   48,
												},
											},
										},
										Body: []ast.Statement{&ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   49,
													},
													File:   "dict_test.flux",
													Source: "error_code = dict.get(dict: codes, key: r.error_type, default: -1)",
													Start: ast.Position{
														Column: 5,
														Line:   49,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   49,
														},
														File:   "dict_test.flux",
														Source: "error_code",
														Start: ast.Position{
															Column: 5,
															Line:   49,
														},
													},
												},
												Name: "error_code",
											},
											Init: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   49,
															},
															File:   "dict_test.flux",
															Source: "dict: codes, key: r.error_type, default: -1",
															Start: ast.Position{
																Column: 27,
																Line:   49,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   49,
																},
																File:   "dict_test.flux",
																Source: "dict: codes",
																Start: ast.Position{
																	Column: 27,
																	Line:   49,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   49,
																	},
																	File:   "dict_test.flux",
																	Source: "dict",
																	Start: ast.Position{
																		Column: 27,
																		Line:   49,
																	},
																},
															},
															Name: "dict",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 38,
																		Line:   49,
																	},
																	File:   "dict_test.flux",
																	Source: "codes",
																	Start: ast.Position{
																		Column: 33,
																		Line:   49,
																	},
																},
															},
															Name: "codes",
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   49,
																},
																File:   "dict_test.flux",
																Source: "key: r.error_type",
																Start: ast.Position{
																	Column: 40,
																	Line:   49,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 43,
																		Line:   49,
																	},
																	File:   "dict_test.flux",
																	Source: "key",
																	Start: ast.Position{
																		Column: 40,
																		Line:   49,
																	},
																},
															},
															Name: "key",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   49,
																	},
																	File:   "dict_test.flux",
																	Source: "r.error_type",
																	Start: ast.Position{
																		Column: 45,
																		Line:   49,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   49,
																		},
																		File:   "dict_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 45,
																			Line:   49,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   49,
																		},
																		File:   "dict_test.flux",
																		Source: "error_type",
																		Start: ast.Position{
																			Column: 47,
																			Line:   49,
																		},
																	},
																},
																Name: "error_type",
															},
															Rbrack: nil,
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 70,
																	Line:   49,
																},
																File:   "dict_test.flux",
																Source: "default: -1",
																Start: ast.Position{
																	Column: 59,
																	Line:   49,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   49,
																	},
																	File:   "dict_test.flux",
																	Source: "default",
																	Start: ast.Position{
																		Column: 59,
																		Line:   49,
																	},
																},
															},
															Name: "default",
														},
														Separator: nil,
														Value: &ast.UnaryExpression{
															Argument: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   49,
																		},
																		File:   "dict_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 69,
																			Line:   49,
																		},
																	},
																},
																Value: int64(1),
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 70,
																		Line:   49,
																	},
																	File:   "dict_test.flux",
																	Source: "-1",
																	Start: ast.Position{
																		Column: 68,
																		Line:   49,
																	},
																},
															},
															Operator: 6,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   49,
														},
														File:   "dict_test.flux",
														Source: "dict.get(dict: codes, key: r.error_type, default: -1)",
														Start: ast.Position{
															Column: 18,
															Line:   49,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   49,
															},
															File:   "dict_test.flux",
															Source: "dict.get",
															Start: ast.Position{
																Column: 18,
																Line:   49,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   49,
																},
																File:   "dict_test.flux",
																Source: "dict",
																Start: ast.Position{
																	Column: 18,
																	Line:   49,
																},
															},
														},
														Name: "dict",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   49,
																},
																File:   "dict_test.flux",
																Source: "get",
																Start: ast.Position{
																	Column: 23,
																	Line:   49,
																},
															},
														},
														Name: "get",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.ReturnStatement{
											Argument: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   50,
														},
														File:   "dict_test.flux",
														Source: "{r with error_code: error_code}",
														Start: ast.Position{
															Column: 12,
															Line:   50,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   50,
															},
															File:   "dict_test.flux",
															Source: "error_code: error_code",
															Start: ast.Position{
																Column: 20,
																Line:   50,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   50,
																},
																File:   "dict_test.flux",
																Source: "error_code",
																Start: ast.Position{
																	Column: 20,
																	Line:   50,
																},
															},
														},
														Name: "error_code",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   50,
																},
																File:   "dict_test.flux",
																Source: "error_code",
																Start: ast.Position{
																	Column: 32,
																	Line:   50,
																},
															},
														},
														Name: "error_code",
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   50,
															},
															File:   "dict_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 13,
																Line:   50,
															},
														},
													},
													Name: "r",
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   50,
													},
													File:   "dict_test.flux",
													Source: "return {r with error_code: error_code}",
													Start: ast.Position{
														Column: 5,
														Line:   50,
													},
												},
											},
										}},
										Lbrace: nil,
										Rbrace: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   48,
												},
												File:   "dict_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   48,
													},
													File:   "dict_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   48,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 5,
									Line:   51,
								},
								File:   "dict_test.flux",
								Source: "map(fn: (r) => {\n    error_code = dict.get(dict: codes, key: r.error_type, default: -1)\n    return {r with error_code: error_code}\n  })",
								Start: ast.Position{
									Column: 6,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   48,
									},
									File:   "dict_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   48,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   44,
							},
							File:   "dict_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   44,
								},
								File:   "dict_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   44,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   44,
							},
							File:   "dict_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   57,
						},
						File:   "dict_test.flux",
						Source: "_dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   53,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   53,
							},
							File:   "dict_test.flux",
							Source: "_dict",
							Start: ast.Position{
								Column: 6,
								Line:   53,
							},
						},
					},
					Name: "_dict",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   57,
							},
							File:   "dict_test.flux",
							Source: "() => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
							Start: ast.Position{
								Column: 14,
								Line:   53,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   57,
								},
								File:   "dict_test.flux",
								Source: "({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
								Start: ast.Position{
									Column: 20,
									Line:   53,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   57,
									},
									File:   "dict_test.flux",
									Source: "{\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n}",
									Start: ast.Position{
										Column: 21,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   54,
										},
										File:   "dict_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 3,
											Line:   54,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   54,
											},
											File:   "dict_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   54,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   54,
												},
												File:   "dict_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 30,
													Line:   54,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   54,
													},
													File:   "dict_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 30,
														Line:   54,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   54,
														},
														File:   "dict_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   54,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   54,
														},
														File:   "dict_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 35,
															Line:   54,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   54,
											},
											File:   "dict_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 10,
												Line:   54,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   54,
												},
												File:   "dict_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   54,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "dict_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   54,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   54,
													},
													File:   "dict_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   54,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   55,
										},
										File:   "dict_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 3,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   55,
											},
											File:   "dict_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   55,
												},
												File:   "dict_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 25,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   55,
													},
													File:   "dict_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 25,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   55,
														},
														File:   "dict_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   55,
														},
														File:   "dict_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 30,
															Line:   55,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   55,
											},
											File:   "dict_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 9,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   55,
												},
												File:   "dict_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   55,
													},
													File:   "dict_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   55,
													},
													File:   "dict_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   56,
										},
										File:   "dict_test.flux",
										Source: "fn: t_dict",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   56,
											},
											File:   "dict_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   56,
											},
											File:   "dict_test.flux",
											Source: "t_dict",
											Start: ast.Position{
												Column: 7,
												Line:   56,
											},
										},
									},
									Name: "t_dict",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   57,
					},
					File:   "dict_test.flux",
					Source: "test _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "dict_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "dict_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "dict_test.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "dict_test.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "dict",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "dict_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "dict_test.flux",
					Source: "package dict_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "dict_test.flux",
						Source: "dict_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "dict_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   37,
				},
				File:   "empty_dict_lambda_test.flux",
				Source: "package dict_test\n\nimport \"testing\"\nimport \"dict\"\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n\"\n\nt_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  })\n\ntest _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   13,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   6,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   13,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   22,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   15,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   22,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   15,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 5,
						Line:   31,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "t_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  })",
					Start: ast.Position{
						Column: 1,
						Line:   24,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   24,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "t_dict",
						Start: ast.Position{
							Column: 1,
							Line:   24,
						},
					},
				},
				Name: "t_dict",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   31,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "(table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  })",
						Start: ast.Position{
							Column: 10,
							Line:   24,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   25,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   25,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   26,
									},
									File:   "empty_dict_lambda_test.flux",
									Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   25,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   26,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   26,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   26,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   26,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   26,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   26,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   26,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   26,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   26,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   26,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   26,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   26,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   27,
								},
								File:   "empty_dict_lambda_test.flux",
								Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   25,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   27,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 11,
											Line:   27,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   27,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 11,
												Line:   27,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   27,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   27,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   27,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 20,
													Line:   27,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   27,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 21,
														Line:   27,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   27,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 31,
														Line:   27,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   27,
									},
									File:   "empty_dict_lambda_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   27,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   27,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   27,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 5,
								Line:   31,
							},
							File:   "empty_dict_lambda_test.flux",
							Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  })",
							Start: ast.Position{
								Column: 3,
								Line:   25,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 4,
										Line:   31,
									},
									File:   "empty_dict_lambda_test.flux",
									Source: "fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  }",
									Start: ast.Position{
										Column: 10,
										Line:   28,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 4,
											Line:   31,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  }",
										Start: ast.Position{
											Column: 10,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   28,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   28,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   31,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "(r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  }",
											Start: ast.Position{
												Column: 14,
												Line:   28,
											},
										},
									},
									Body: &ast.Block{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 4,
													Line:   31,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "{\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  }",
												Start: ast.Position{
													Column: 21,
													Line:   28,
												},
											},
										},
										Body: []ast.Statement{&ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   29,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "codes = [:]",
													Start: ast.Position{
														Column: 5,
														Line:   29,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   29,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "codes",
														Start: ast.Position{
															Column: 5,
															Line:   29,
														},
													},
												},
												Name: "codes",
											},
											Init: &ast.DictExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   29,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "[:]",
														Start: ast.Position{
															Column: 13,
															Line:   29,
														},
													},
												},
												Elements: []*ast.DictItem{},
												Lbrack:   nil,
												Rbrack:   nil,
											},
										}, &ast.ReturnStatement{
											Argument: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   30,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "{r with code: dict.get(dict: codes, key: 0, default: 2)}",
														Start: ast.Position{
															Column: 12,
															Line:   30,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   30,
															},
															File:   "empty_dict_lambda_test.flux",
															Source: "code: dict.get(dict: codes, key: 0, default: 2)",
															Start: ast.Position{
																Column: 20,
																Line:   30,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   30,
																},
																File:   "empty_dict_lambda_test.flux",
																Source: "code",
																Start: ast.Position{
																	Column: 20,
																	Line:   30,
																},
															},
														},
														Name: "code",
													},
													Separator: nil,
													Value: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   30,
																	},
																	File:   "empty_dict_lambda_test.flux",
																	Source: "dict: codes, key: 0, default: 2",
																	Start: ast.Position{
																		Column: 35,
																		Line:   30,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 46,
																			Line:   30,
																		},
																		File:   "empty_dict_lambda_test.flux",
																		Source: "dict: codes",
																		Start: ast.Position{
																			Column: 35,
																			Line:   30,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 39,
																				Line:   30,
																			},
																			File:   "empty_dict_lambda_test.flux",
																			Source: "dict",
																			Start: ast.Position{
																				Column: 35,
																				Line:   30,
																			},
																		},
																	},
																	Name: "dict",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 46,
																				Line:   30,
																			},
																			File:   "empty_dict_lambda_test.flux",
																			Source: "codes",
																			Start: ast.Position{
																				Column: 41,
																				Line:   30,
																			},
																		},
																	},
																	Name: "codes",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   30,
																		},
																		File:   "empty_dict_lambda_test.flux",
																		Source: "key: 0",
																		Start: ast.Position{
																			Column: 48,
																			Line:   30,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 51,
																				Line:   30,
																			},
																			File:   "empty_dict_lambda_test.flux",
																			Source: "key",
																			Start: ast.Position{
																				Column: 48,
																				Line:   30,
																			},
																		},
																	},
																	Name: "key",
																},
																Separator: nil,
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   30,
																			},
																			File:   "empty_dict_lambda_test.flux",
																			Source: "0",
																			Start: ast.Position{
																				Column: 53,
																				Line:   30,
																			},
																		},
																	},
																	Value: int64(0),
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   30,
																		},
																		File:   "empty_dict_lambda_test.flux",
																		Source: "default: 2",
																		Start: ast.Position{
																			Column: 56,
																			Line:   30,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 63,
																				Line:   30,
																			},
																			File:   "empty_dict_lambda_test.flux",
																			Source: "default",
																			Start: ast.Position{
																				Column: 56,
																				Line:   30,
																			},
																		},
																	},
																	Name: "default",
																},
																Separator: nil,
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   30,
																			},
																			File:   "empty_dict_lambda_test.flux",
																			Source: "2",
																			Start: ast.Position{
																				Column: 65,
																				Line:   30,
																			},
																		},
																	},
																	Value: int64(2),
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   30,
																},
																File:   "empty_dict_lambda_test.flux",
																Source: "dict.get(dict: codes, key: 0, default: 2)",
																Start: ast.Position{
																	Column: 26,
																	Line:   30,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   30,
																	},
																	File:   "empty_dict_lambda_test.flux",
																	Source: "dict.get",
																	Start: ast.Position{
																		Column: 26,
																		Line:   30,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   30,
																		},
																		File:   "empty_dict_lambda_test.flux",
																		Source: "dict",
																		Start: ast.Position{
																			Column: 26,
																			Line:   30,
																		},
																	},
																},
																Name: "dict",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   30,
																		},
																		File:   "empty_dict_lambda_test.flux",
																		Source: "get",
																		Start: ast.Position{
																			Column: 31,
																			Line:   30,
																		},
																	},
																},
																Name: "get",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
												}},
												Rbrace: nil,
												With: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   30,
															},
															File:   "empty_dict_lambda_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 13,
																Line:   30,
															},
														},
													},
													Name: "r",
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   30,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "return {r with code: dict.get(dict: codes, key: 0, default: 2)}",
													Start: ast.Position{
														Column: 5,
														Line:   30,
													},
												},
											},
										}},
										Lbrace: nil,
										Rbrace: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   28,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   28,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   28,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 5,
									Line:   31,
								},
								File:   "empty_dict_lambda_test.flux",
								Source: "map(fn: (r) => {\n    codes = [:]\n    return {r with code: dict.get(dict: codes, key: 0, default: 2)}\n  })",
								Start: ast.Position{
									Column: 6,
									Line:   28,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   28,
									},
									File:   "empty_dict_lambda_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   28,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   24,
							},
							File:   "empty_dict_lambda_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   24,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   24,
								},
								File:   "empty_dict_lambda_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   24,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   24,
							},
							File:   "empty_dict_lambda_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   24,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   37,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "_dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   33,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   33,
							},
							File:   "empty_dict_lambda_test.flux",
							Source: "_dict",
							Start: ast.Position{
								Column: 6,
								Line:   33,
							},
						},
					},
					Name: "_dict",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   37,
							},
							File:   "empty_dict_lambda_test.flux",
							Source: "() => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
							Start: ast.Position{
								Column: 14,
								Line:   33,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   37,
								},
								File:   "empty_dict_lambda_test.flux",
								Source: "({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
								Start: ast.Position{
									Column: 20,
									Line:   33,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   37,
									},
									File:   "empty_dict_lambda_test.flux",
									Source: "{\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n}",
									Start: ast.Position{
										Column: 21,
										Line:   33,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   34,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   34,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   34,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 30,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   34,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 30,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   34,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   34,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   34,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 35,
															Line:   34,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   34,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 10,
												Line:   34,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   34,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   34,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   34,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   34,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   34,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   35,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   35,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   35,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   35,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 25,
													Line:   35,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   35,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 25,
														Line:   35,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   35,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   35,
														},
														File:   "empty_dict_lambda_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 30,
															Line:   35,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   35,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 9,
												Line:   35,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   35,
												},
												File:   "empty_dict_lambda_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   35,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   35,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   35,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   35,
													},
													File:   "empty_dict_lambda_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   36,
										},
										File:   "empty_dict_lambda_test.flux",
										Source: "fn: t_dict",
										Start: ast.Position{
											Column: 3,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   36,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   36,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   36,
											},
											File:   "empty_dict_lambda_test.flux",
											Source: "t_dict",
											Start: ast.Position{
												Column: 7,
												Line:   36,
											},
										},
									},
									Name: "t_dict",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   37,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "test _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "dict",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "empty_dict_lambda_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "empty_dict_lambda_test.flux",
					Source: "package dict_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "empty_dict_lambda_test.flux",
						Source: "dict_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "dict_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   36,
				},
				File:   "empty_dict_lit_test.flux",
				Source: "package dict_test\n\nimport \"testing\"\nimport \"dict\"\n\ncodes = [:]\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n\"\n\nt_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)}))\n\ntest _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   6,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "codes = [:]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   6,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "codes",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "codes",
			},
			Init: &ast.DictExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   6,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "[:]",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Elements: []*ast.DictItem{},
				Lbrack:   nil,
				Rbrack:   nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   15,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   8,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   15,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:26Z,_m,_f,0\n,,0,2018-05-22T19:53:36Z,_m,_f,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   17,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   17,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   17,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long,long\n#group,false,false,false,true,true,false,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,_field,_value,code\n,,0,2018-05-22T19:53:26Z,_m,_f,0,2\n,,0,2018-05-22T19:53:36Z,_m,_f,0,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 80,
						Line:   30,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "t_dict = (table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)}))",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   26,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "t_dict",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "t_dict",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 80,
							Line:   30,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "(table=<-) =>\n  table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)}))",
						Start: ast.Position{
							Column: 10,
							Line:   26,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   27,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   27,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   28,
									},
									File:   "empty_dict_lit_test.flux",
									Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   27,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   28,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   28,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   28,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   28,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   28,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   28,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   28,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   28,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   28,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   28,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   29,
								},
								File:   "empty_dict_lit_test.flux",
								Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 3,
									Line:   27,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   29,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 11,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   29,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 11,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   29,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 11,
													Line:   29,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   29,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 20,
													Line:   29,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   29,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 21,
														Line:   29,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   29,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 31,
														Line:   29,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   29,
									},
									File:   "empty_dict_lit_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   29,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 6,
											Line:   29,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 80,
								Line:   30,
							},
							File:   "empty_dict_lit_test.flux",
							Source: "table\n  |> range(start: 2018-05-22T19:53:26Z)\n  |> drop(columns: [\"_start\", \"_stop\"])\n  |> map(fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)}))",
							Start: ast.Position{
								Column: 3,
								Line:   27,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   30,
									},
									File:   "empty_dict_lit_test.flux",
									Source: "fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)})",
									Start: ast.Position{
										Column: 10,
										Line:   30,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   30,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)})",
										Start: ast.Position{
											Column: 10,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   30,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 10,
												Line:   30,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   30,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "(r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)})",
											Start: ast.Position{
												Column: 14,
												Line:   30,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   30,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "({r with code: dict.get(dict: codes, key: 1, default: 2)})",
												Start: ast.Position{
													Column: 21,
													Line:   30,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   30,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "{r with code: dict.get(dict: codes, key: 1, default: 2)}",
													Start: ast.Position{
														Column: 22,
														Line:   30,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   30,
														},
														File:   "empty_dict_lit_test.flux",
														Source: "code: dict.get(dict: codes, key: 1, default: 2)",
														Start: ast.Position{
															Column: 30,
															Line:   30,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   30,
															},
															File:   "empty_dict_lit_test.flux",
															Source: "code",
															Start: ast.Position{
																Column: 30,
																Line:   30,
															},
														},
													},
													Name: "code",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   30,
																},
																File:   "empty_dict_lit_test.flux",
																Source: "dict: codes, key: 1, default: 2",
																Start: ast.Position{
																	Column: 45,
																	Line:   30,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   30,
																	},
																	File:   "empty_dict_lit_test.flux",
																	Source: "dict: codes",
																	Start: ast.Position{
																		Column: 45,
																		Line:   30,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   30,
																		},
																		File:   "empty_dict_lit_test.flux",
																		Source: "dict",
																		Start: ast.Position{
																			Column: 45,
																			Line:   30,
																		},
																	},
																},
																Name: "dict",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   30,
																		},
																		File:   "empty_dict_lit_test.flux",
																		Source: "codes",
																		Start: ast.Position{
																			Column: 51,
																			Line:   30,
																		},
																	},
																},
																Name: "codes",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   30,
																	},
																	File:   "empty_dict_lit_test.flux",
																	Source: "key: 1",
																	Start: ast.Position{
																		Column: 58,
																		Line:   30,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   30,
																		},
																		File:   "empty_dict_lit_test.flux",
																		Source: "key",
																		Start: ast.Position{
																			Column: 58,
																			Line:   30,
																		},
																	},
																},
																Name: "key",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   30,
																		},
																		File:   "empty_dict_lit_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 63,
																			Line:   30,
																		},
																	},
																},
																Value: int64(1),
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   30,
																	},
																	File:   "empty_dict_lit_test.flux",
																	Source: "default: 2",
																	Start: ast.Position{
																		Column: 66,
																		Line:   30,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   30,
																		},
																		File:   "empty_dict_lit_test.flux",
																		Source: "default",
																		Start: ast.Position{
																			Column: 66,
																			Line:   30,
																		},
																	},
																},
																Name: "default",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   30,
																		},
																		File:   "empty_dict_lit_test.flux",
																		Source: "2",
																		Start: ast.Position{
																			Column: 75,
																			Line:   30,
																		},
																	},
																},
																Value: int64(2),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   30,
															},
															File:   "empty_dict_lit_test.flux",
															Source: "dict.get(dict: codes, key: 1, default: 2)",
															Start: ast.Position{
																Column: 36,
																Line:   30,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   30,
																},
																File:   "empty_dict_lit_test.flux",
																Source: "dict.get",
																Start: ast.Position{
																	Column: 36,
																	Line:   30,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 40,
																		Line:   30,
																	},
																	File:   "empty_dict_lit_test.flux",
																	Source: "dict",
																	Start: ast.Position{
																		Column: 36,
																		Line:   30,
																	},
																},
															},
															Name: "dict",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   30,
																	},
																	File:   "empty_dict_lit_test.flux",
																	Source: "get",
																	Start: ast.Position{
																		Column: 41,
																		Line:   30,
																	},
																},
															},
															Name: "get",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   30,
														},
														File:   "empty_dict_lit_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 23,
															Line:   30,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   30,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 15,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   30,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 15,
														Line:   30,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   30,
								},
								File:   "empty_dict_lit_test.flux",
								Source: "map(fn: (r) => ({r with code: dict.get(dict: codes, key: 1, default: 2)}))",
								Start: ast.Position{
									Column: 6,
									Line:   30,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   30,
									},
									File:   "empty_dict_lit_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 6,
										Line:   30,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   26,
							},
							File:   "empty_dict_lit_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 11,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   26,
								},
								File:   "empty_dict_lit_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 11,
									Line:   26,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   26,
							},
							File:   "empty_dict_lit_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 17,
								Line:   26,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   36,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "_dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   32,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   32,
							},
							File:   "empty_dict_lit_test.flux",
							Source: "_dict",
							Start: ast.Position{
								Column: 6,
								Line:   32,
							},
						},
					},
					Name: "_dict",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   36,
							},
							File:   "empty_dict_lit_test.flux",
							Source: "() => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
							Start: ast.Position{
								Column: 14,
								Line:   32,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   36,
								},
								File:   "empty_dict_lit_test.flux",
								Source: "({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
								Start: ast.Position{
									Column: 20,
									Line:   32,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   36,
									},
									File:   "empty_dict_lit_test.flux",
									Source: "{\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n}",
									Start: ast.Position{
										Column: 21,
										Line:   32,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   33,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 3,
											Line:   33,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   33,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   33,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   33,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 30,
													Line:   33,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   33,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 30,
														Line:   33,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   33,
														},
														File:   "empty_dict_lit_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   33,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   33,
														},
														File:   "empty_dict_lit_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 35,
															Line:   33,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   33,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 10,
												Line:   33,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   33,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   33,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   33,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   33,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   33,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   33,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   34,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 3,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   34,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   34,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   34,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 25,
													Line:   34,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   34,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 25,
														Line:   34,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   34,
														},
														File:   "empty_dict_lit_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   34,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   34,
														},
														File:   "empty_dict_lit_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 30,
															Line:   34,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   34,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 9,
												Line:   34,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   34,
												},
												File:   "empty_dict_lit_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   34,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   34,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   34,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   34,
													},
													File:   "empty_dict_lit_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   34,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   35,
										},
										File:   "empty_dict_lit_test.flux",
										Source: "fn: t_dict",
										Start: ast.Position{
											Column: 3,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   35,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   35,
											},
											File:   "empty_dict_lit_test.flux",
											Source: "t_dict",
											Start: ast.Position{
												Column: 7,
												Line:   35,
											},
										},
									},
									Name: "t_dict",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   36,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "test _dict = () => ({\n  input: testing.loadStorage(csv: inData),\n  want: testing.loadMem(csv: outData),\n  fn: t_dict,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "import \"dict\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "\"dict\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "dict",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "empty_dict_lit_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "empty_dict_lit_test.flux",
					Source: "package dict_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "empty_dict_lit_test.flux",
						Source: "dict_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "dict_test",
			},
		},
	}},
	Package: "dict_test",
	Path:    "dict",
}}
