// DO NOT EDIT: This file is autogenerated via the builtin command.

package schema

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 51,
					Line:   49,
				},
				File:   "schema.flux",
				Source: "package schema\n\n// fieldsAsCols is a special application of pivot that will automatically align fields within each measurement that have the same timestamp.\nfieldsAsCols = (tables=<-) =>\n    tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")\n\n// TagValues returns the unique values for a given tag.\n// The return value is always a single table with a single column \"_value\".\ntagValues = (bucket, tag, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)\n\n// MeasurementTagValues returns a single table with a single column \"_value\" that contains the\n// The return value is always a single table with a single column \"_value\".\nmeasurementTagValues = (bucket, measurement, tag) =>\n    tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)\n\n// TagKeys returns the list of tag keys for all series that match the predicate.\n// The return value is always a single table with a single column \"_value\".\ntagKeys = (bucket, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()\n\n// MeasurementTagKeys returns the list of tag keys for a specific measurement.\nmeasurementTagKeys = (bucket, measurement) =>\n    tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)\n\n// FieldKeys is a special application of tagValues that returns field keys in a given bucket.\n// The return value is always a single table with a single column, \"_value\".\nfieldKeys = (bucket, predicate=(r) => true, start=-30d) =>\n    tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)\n\n// MeasurementFieldKeys returns field keys in a given measurement.\n// The return value is always a single table with a single column, \"_value\".\nmeasurementFieldKeys = (bucket, measurement, start=-30d) =>\n    fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)\n\n// Measurements returns the list of measurements in a specific bucket.\nmeasurements = (bucket) =>\n    tagValues(bucket: bucket, tag: \"_measurement\")",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   6,
					},
					File:   "schema.flux",
					Source: "fieldsAsCols = (tables=<-) =>\n    tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// fieldsAsCols is a special application of pivot that will automatically align fields within each measurement that have the same timestamp.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "schema.flux",
						Source: "fieldsAsCols",
						Start: ast.Position{
							Column: 1,
							Line:   4,
						},
					},
				},
				Name: "fieldsAsCols",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   6,
						},
						File:   "schema.flux",
						Source: "(tables=<-) =>\n    tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
						Start: ast.Position{
							Column: 16,
							Line:   4,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   5,
								},
								File:   "schema.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   5,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   6,
							},
							File:   "schema.flux",
							Source: "tables\n        |> pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
							Start: ast.Position{
								Column: 5,
								Line:   5,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   6,
									},
									File:   "schema.flux",
									Source: "rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\"",
									Start: ast.Position{
										Column: 18,
										Line:   6,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   6,
										},
										File:   "schema.flux",
										Source: "rowKey:[\"_time\"]",
										Start: ast.Position{
											Column: 18,
											Line:   6,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   6,
											},
											File:   "schema.flux",
											Source: "rowKey",
											Start: ast.Position{
												Column: 18,
												Line:   6,
											},
										},
									},
									Name: "rowKey",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   6,
											},
											File:   "schema.flux",
											Source: "[\"_time\"]",
											Start: ast.Position{
												Column: 25,
												Line:   6,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   6,
												},
												File:   "schema.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 26,
													Line:   6,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   6,
										},
										File:   "schema.flux",
										Source: "columnKey: [\"_field\"]",
										Start: ast.Position{
											Column: 36,
											Line:   6,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   6,
											},
											File:   "schema.flux",
											Source: "columnKey",
											Start: ast.Position{
												Column: 36,
												Line:   6,
											},
										},
									},
									Name: "columnKey",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   6,
											},
											File:   "schema.flux",
											Source: "[\"_field\"]",
											Start: ast.Position{
												Column: 47,
												Line:   6,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   6,
												},
												File:   "schema.flux",
												Source: "\"_field\"",
												Start: ast.Position{
													Column: 48,
													Line:   6,
												},
											},
										},
										Value: "_field",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   6,
										},
										File:   "schema.flux",
										Source: "valueColumn: \"_value\"",
										Start: ast.Position{
											Column: 59,
											Line:   6,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   6,
											},
											File:   "schema.flux",
											Source: "valueColumn",
											Start: ast.Position{
												Column: 59,
												Line:   6,
											},
										},
									},
									Name: "valueColumn",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   6,
											},
											File:   "schema.flux",
											Source: "\"_value\"",
											Start: ast.Position{
												Column: 72,
												Line:   6,
											},
										},
									},
									Value: "_value",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   6,
								},
								File:   "schema.flux",
								Source: "pivot(rowKey:[\"_time\"], columnKey: [\"_field\"], valueColumn: \"_value\")",
								Start: ast.Position{
									Column: 12,
									Line:   6,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   6,
									},
									File:   "schema.flux",
									Source: "pivot",
									Start: ast.Position{
										Column: 12,
										Line:   6,
									},
								},
							},
							Name: "pivot",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   4,
							},
							File:   "schema.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   4,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   4,
								},
								File:   "schema.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   4,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   4,
							},
							File:   "schema.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   4,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 31,
						Line:   16,
					},
					File:   "schema.flux",
					Source: "tagValues = (bucket, tag, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// TagValues returns the unique values for a given tag.\n"}, ast.Comment{Text: "// The return value is always a single table with a single column \"_value\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   10,
						},
						File:   "schema.flux",
						Source: "tagValues",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "tagValues",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 31,
							Line:   16,
						},
						File:   "schema.flux",
						Source: "(bucket, tag, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)",
						Start: ast.Position{
							Column: 13,
							Line:   10,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   11,
													},
													File:   "schema.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 10,
														Line:   11,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   11,
														},
														File:   "schema.flux",
														Source: "bucket: bucket",
														Start: ast.Position{
															Column: 10,
															Line:   11,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   11,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 10,
																Line:   11,
															},
														},
													},
													Name: "bucket",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   11,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 18,
																Line:   11,
															},
														},
													},
													Name: "bucket",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   11,
												},
												File:   "schema.flux",
												Source: "from(bucket: bucket)",
												Start: ast.Position{
													Column: 5,
													Line:   11,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   11,
													},
													File:   "schema.flux",
													Source: "from",
													Start: ast.Position{
														Column: 5,
														Line:   11,
													},
												},
											},
											Name: "from",
										},
										Lparen: nil,
										Rparen: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   12,
											},
											File:   "schema.flux",
											Source: "from(bucket: bucket)\n      |> range(start: start)",
											Start: ast.Position{
												Column: 5,
												Line:   11,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   12,
													},
													File:   "schema.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 16,
														Line:   12,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   12,
														},
														File:   "schema.flux",
														Source: "start: start",
														Start: ast.Position{
															Column: 16,
															Line:   12,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   12,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 16,
																Line:   12,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   12,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 23,
																Line:   12,
															},
														},
													},
													Name: "start",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   12,
												},
												File:   "schema.flux",
												Source: "range(start: start)",
												Start: ast.Position{
													Column: 10,
													Line:   12,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   12,
													},
													File:   "schema.flux",
													Source: "range",
													Start: ast.Position{
														Column: 10,
														Line:   12,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   13,
										},
										File:   "schema.flux",
										Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)",
										Start: ast.Position{
											Column: 5,
											Line:   11,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   13,
												},
												File:   "schema.flux",
												Source: "fn: predicate",
												Start: ast.Position{
													Column: 17,
													Line:   13,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   13,
													},
													File:   "schema.flux",
													Source: "fn: predicate",
													Start: ast.Position{
														Column: 17,
														Line:   13,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   13,
														},
														File:   "schema.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 17,
															Line:   13,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   13,
														},
														File:   "schema.flux",
														Source: "predicate",
														Start: ast.Position{
															Column: 21,
															Line:   13,
														},
													},
												},
												Name: "predicate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   13,
											},
											File:   "schema.flux",
											Source: "filter(fn: predicate)",
											Start: ast.Position{
												Column: 10,
												Line:   13,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   13,
												},
												File:   "schema.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 10,
													Line:   13,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   14,
									},
									File:   "schema.flux",
									Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])",
									Start: ast.Position{
										Column: 5,
										Line:   11,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   14,
											},
											File:   "schema.flux",
											Source: "columns: [tag]",
											Start: ast.Position{
												Column: 15,
												Line:   14,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   14,
												},
												File:   "schema.flux",
												Source: "columns: [tag]",
												Start: ast.Position{
													Column: 15,
													Line:   14,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   14,
													},
													File:   "schema.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 15,
														Line:   14,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   14,
													},
													File:   "schema.flux",
													Source: "[tag]",
													Start: ast.Position{
														Column: 24,
														Line:   14,
													},
												},
											},
											Elements: []ast.Expression{&ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   14,
														},
														File:   "schema.flux",
														Source: "tag",
														Start: ast.Position{
															Column: 25,
															Line:   14,
														},
													},
												},
												Name: "tag",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   14,
										},
										File:   "schema.flux",
										Source: "keep(columns: [tag])",
										Start: ast.Position{
											Column: 10,
											Line:   14,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   14,
											},
											File:   "schema.flux",
											Source: "keep",
											Start: ast.Position{
												Column: 10,
												Line:   14,
											},
										},
									},
									Name: "keep",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   15,
								},
								File:   "schema.flux",
								Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()",
								Start: ast.Position{
									Column: 5,
									Line:   11,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   15,
									},
									File:   "schema.flux",
									Source: "group()",
									Start: ast.Position{
										Column: 10,
										Line:   15,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   15,
										},
										File:   "schema.flux",
										Source: "group",
										Start: ast.Position{
											Column: 10,
											Line:   15,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   16,
							},
							File:   "schema.flux",
							Source: "from(bucket: bucket)\n      |> range(start: start)\n      |> filter(fn: predicate)\n      |> keep(columns: [tag])\n      |> group()\n      |> distinct(column: tag)",
							Start: ast.Position{
								Column: 5,
								Line:   11,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   16,
									},
									File:   "schema.flux",
									Source: "column: tag",
									Start: ast.Position{
										Column: 19,
										Line:   16,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   16,
										},
										File:   "schema.flux",
										Source: "column: tag",
										Start: ast.Position{
											Column: 19,
											Line:   16,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   16,
											},
											File:   "schema.flux",
											Source: "column",
											Start: ast.Position{
												Column: 19,
												Line:   16,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   16,
											},
											File:   "schema.flux",
											Source: "tag",
											Start: ast.Position{
												Column: 27,
												Line:   16,
											},
										},
									},
									Name: "tag",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   16,
								},
								File:   "schema.flux",
								Source: "distinct(column: tag)",
								Start: ast.Position{
									Column: 10,
									Line:   16,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   16,
									},
									File:   "schema.flux",
									Source: "distinct",
									Start: ast.Position{
										Column: 10,
										Line:   16,
									},
								},
							},
							Name: "distinct",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   10,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 14,
								Line:   10,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   10,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 14,
									Line:   10,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   10,
							},
							File:   "schema.flux",
							Source: "tag",
							Start: ast.Position{
								Column: 22,
								Line:   10,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   10,
								},
								File:   "schema.flux",
								Source: "tag",
								Start: ast.Position{
									Column: 22,
									Line:   10,
								},
							},
						},
						Name: "tag",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   10,
							},
							File:   "schema.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 27,
								Line:   10,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   10,
								},
								File:   "schema.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 27,
									Line:   10,
								},
							},
						},
						Name: "predicate",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   10,
								},
								File:   "schema.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 37,
									Line:   10,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   10,
									},
									File:   "schema.flux",
									Source: "true",
									Start: ast.Position{
										Column: 44,
										Line:   10,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   10,
									},
									File:   "schema.flux",
									Source: "r",
									Start: ast.Position{
										Column: 38,
										Line:   10,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   10,
										},
										File:   "schema.flux",
										Source: "r",
										Start: ast.Position{
											Column: 38,
											Line:   10,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   10,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 50,
								Line:   10,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   10,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 50,
									Line:   10,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   10,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 57,
										Line:   10,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   10,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 56,
									Line:   10,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 89,
						Line:   21,
					},
					File:   "schema.flux",
					Source: "measurementTagValues = (bucket, measurement, tag) =>\n    tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// MeasurementTagValues returns a single table with a single column \"_value\" that contains the\n"}, ast.Comment{Text: "// The return value is always a single table with a single column \"_value\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   20,
						},
						File:   "schema.flux",
						Source: "measurementTagValues",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "measurementTagValues",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 89,
							Line:   21,
						},
						File:   "schema.flux",
						Source: "(bucket, measurement, tag) =>\n    tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
						Start: ast.Position{
							Column: 24,
							Line:   20,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   21,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement",
								Start: ast.Position{
									Column: 15,
									Line:   21,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   21,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 15,
										Line:   21,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   21,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 15,
											Line:   21,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   21,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 23,
											Line:   21,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   21,
									},
									File:   "schema.flux",
									Source: "tag: tag",
									Start: ast.Position{
										Column: 31,
										Line:   21,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   21,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 31,
											Line:   21,
										},
									},
								},
								Name: "tag",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   21,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 36,
											Line:   21,
										},
									},
								},
								Name: "tag",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   21,
									},
									File:   "schema.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 41,
										Line:   21,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   21,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 41,
											Line:   21,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   21,
										},
										File:   "schema.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 52,
											Line:   21,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   21,
											},
											File:   "schema.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 59,
												Line:   21,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   21,
												},
												File:   "schema.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 59,
													Line:   21,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   21,
													},
													File:   "schema.flux",
													Source: "r",
													Start: ast.Position{
														Column: 59,
														Line:   21,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   21,
													},
													File:   "schema.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 61,
														Line:   21,
													},
												},
											},
											Name: "_measurement",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   21,
												},
												File:   "schema.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 77,
													Line:   21,
												},
											},
										},
										Name: "measurement",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   21,
											},
											File:   "schema.flux",
											Source: "r",
											Start: ast.Position{
												Column: 53,
												Line:   21,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   21,
												},
												File:   "schema.flux",
												Source: "r",
												Start: ast.Position{
													Column: 53,
													Line:   21,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   21,
							},
							File:   "schema.flux",
							Source: "tagValues(bucket: bucket, tag: tag, predicate: (r) => r._measurement == measurement)",
							Start: ast.Position{
								Column: 5,
								Line:   21,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   21,
								},
								File:   "schema.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 5,
									Line:   21,
								},
							},
						},
						Name: "tagValues",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   20,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 25,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   20,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 25,
									Line:   20,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   20,
							},
							File:   "schema.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 33,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   20,
								},
								File:   "schema.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 33,
									Line:   20,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   20,
							},
							File:   "schema.flux",
							Source: "tag",
							Start: ast.Position{
								Column: 46,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   20,
								},
								File:   "schema.flux",
								Source: "tag",
								Start: ast.Position{
									Column: 46,
									Line:   20,
								},
							},
						},
						Name: "tag",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   31,
					},
					File:   "schema.flux",
					Source: "tagKeys = (bucket, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// TagKeys returns the list of tag keys for all series that match the predicate.\n"}, ast.Comment{Text: "// The return value is always a single table with a single column \"_value\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   25,
						},
						File:   "schema.flux",
						Source: "tagKeys",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "tagKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   31,
						},
						File:   "schema.flux",
						Source: "(bucket, predicate=(r) => true, start=-30d) =>\n    from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()",
						Start: ast.Position{
							Column: 11,
							Line:   25,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   26,
													},
													File:   "schema.flux",
													Source: "bucket: bucket",
													Start: ast.Position{
														Column: 10,
														Line:   26,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   26,
														},
														File:   "schema.flux",
														Source: "bucket: bucket",
														Start: ast.Position{
															Column: 10,
															Line:   26,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   26,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 10,
																Line:   26,
															},
														},
													},
													Name: "bucket",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   26,
															},
															File:   "schema.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 18,
																Line:   26,
															},
														},
													},
													Name: "bucket",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   26,
												},
												File:   "schema.flux",
												Source: "from(bucket: bucket)",
												Start: ast.Position{
													Column: 5,
													Line:   26,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 9,
														Line:   26,
													},
													File:   "schema.flux",
													Source: "from",
													Start: ast.Position{
														Column: 5,
														Line:   26,
													},
												},
											},
											Name: "from",
										},
										Lparen: nil,
										Rparen: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   27,
											},
											File:   "schema.flux",
											Source: "from(bucket: bucket)\n        |> range(start: start)",
											Start: ast.Position{
												Column: 5,
												Line:   26,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   27,
													},
													File:   "schema.flux",
													Source: "start: start",
													Start: ast.Position{
														Column: 18,
														Line:   27,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   27,
														},
														File:   "schema.flux",
														Source: "start: start",
														Start: ast.Position{
															Column: 18,
															Line:   27,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   27,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 18,
																Line:   27,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   27,
															},
															File:   "schema.flux",
															Source: "start",
															Start: ast.Position{
																Column: 25,
																Line:   27,
															},
														},
													},
													Name: "start",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   27,
												},
												File:   "schema.flux",
												Source: "range(start: start)",
												Start: ast.Position{
													Column: 12,
													Line:   27,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   27,
													},
													File:   "schema.flux",
													Source: "range",
													Start: ast.Position{
														Column: 12,
														Line:   27,
													},
												},
											},
											Name: "range",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   28,
										},
										File:   "schema.flux",
										Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)",
										Start: ast.Position{
											Column: 5,
											Line:   26,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   28,
												},
												File:   "schema.flux",
												Source: "fn: predicate",
												Start: ast.Position{
													Column: 19,
													Line:   28,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   28,
													},
													File:   "schema.flux",
													Source: "fn: predicate",
													Start: ast.Position{
														Column: 19,
														Line:   28,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   28,
														},
														File:   "schema.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   28,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   28,
														},
														File:   "schema.flux",
														Source: "predicate",
														Start: ast.Position{
															Column: 23,
															Line:   28,
														},
													},
												},
												Name: "predicate",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   28,
											},
											File:   "schema.flux",
											Source: "filter(fn: predicate)",
											Start: ast.Position{
												Column: 12,
												Line:   28,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   28,
												},
												File:   "schema.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 12,
													Line:   28,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   29,
									},
									File:   "schema.flux",
									Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()",
									Start: ast.Position{
										Column: 5,
										Line:   26,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   29,
										},
										File:   "schema.flux",
										Source: "keys()",
										Start: ast.Position{
											Column: 12,
											Line:   29,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   29,
											},
											File:   "schema.flux",
											Source: "keys",
											Start: ast.Position{
												Column: 12,
												Line:   29,
											},
										},
									},
									Name: "keys",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   30,
								},
								File:   "schema.flux",
								Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])",
								Start: ast.Position{
									Column: 5,
									Line:   26,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   30,
										},
										File:   "schema.flux",
										Source: "columns: [\"_value\"]",
										Start: ast.Position{
											Column: 17,
											Line:   30,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   30,
											},
											File:   "schema.flux",
											Source: "columns: [\"_value\"]",
											Start: ast.Position{
												Column: 17,
												Line:   30,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   30,
												},
												File:   "schema.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   30,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   30,
												},
												File:   "schema.flux",
												Source: "[\"_value\"]",
												Start: ast.Position{
													Column: 26,
													Line:   30,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   30,
													},
													File:   "schema.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 27,
														Line:   30,
													},
												},
											},
											Value: "_value",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   30,
									},
									File:   "schema.flux",
									Source: "keep(columns: [\"_value\"])",
									Start: ast.Position{
										Column: 12,
										Line:   30,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   30,
										},
										File:   "schema.flux",
										Source: "keep",
										Start: ast.Position{
											Column: 12,
											Line:   30,
										},
									},
								},
								Name: "keep",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   31,
							},
							File:   "schema.flux",
							Source: "from(bucket: bucket)\n        |> range(start: start)\n        |> filter(fn: predicate)\n        |> keys()\n        |> keep(columns: [\"_value\"])\n        |> distinct()",
							Start: ast.Position{
								Column: 5,
								Line:   26,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   31,
								},
								File:   "schema.flux",
								Source: "distinct()",
								Start: ast.Position{
									Column: 12,
									Line:   31,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   31,
									},
									File:   "schema.flux",
									Source: "distinct",
									Start: ast.Position{
										Column: 12,
										Line:   31,
									},
								},
							},
							Name: "distinct",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   25,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 12,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   25,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 12,
									Line:   25,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   25,
							},
							File:   "schema.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 20,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   25,
								},
								File:   "schema.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 20,
									Line:   25,
								},
							},
						},
						Name: "predicate",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   25,
								},
								File:   "schema.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 30,
									Line:   25,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   25,
									},
									File:   "schema.flux",
									Source: "true",
									Start: ast.Position{
										Column: 37,
										Line:   25,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   25,
									},
									File:   "schema.flux",
									Source: "r",
									Start: ast.Position{
										Column: 31,
										Line:   25,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   25,
										},
										File:   "schema.flux",
										Source: "r",
										Start: ast.Position{
											Column: 31,
											Line:   25,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   25,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 43,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   25,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 43,
									Line:   25,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   25,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 50,
										Line:   25,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   25,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 49,
									Line:   25,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 77,
						Line:   35,
					},
					File:   "schema.flux",
					Source: "measurementTagKeys = (bucket, measurement) =>\n    tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// MeasurementTagKeys returns the list of tag keys for a specific measurement.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   34,
						},
						File:   "schema.flux",
						Source: "measurementTagKeys",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "measurementTagKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 77,
							Line:   35,
						},
						File:   "schema.flux",
						Source: "(bucket, measurement) =>\n    tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
						Start: ast.Position{
							Column: 22,
							Line:   34,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   35,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, predicate: (r) => r._measurement == measurement",
								Start: ast.Position{
									Column: 13,
									Line:   35,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   35,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 13,
										Line:   35,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   35,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 13,
											Line:   35,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   35,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 21,
											Line:   35,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   35,
									},
									File:   "schema.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 29,
										Line:   35,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   35,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 29,
											Line:   35,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   35,
										},
										File:   "schema.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 40,
											Line:   35,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   35,
											},
											File:   "schema.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 47,
												Line:   35,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   35,
												},
												File:   "schema.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 47,
													Line:   35,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   35,
													},
													File:   "schema.flux",
													Source: "r",
													Start: ast.Position{
														Column: 47,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   35,
													},
													File:   "schema.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 49,
														Line:   35,
													},
												},
											},
											Name: "_measurement",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   35,
												},
												File:   "schema.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 65,
													Line:   35,
												},
											},
										},
										Name: "measurement",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   35,
											},
											File:   "schema.flux",
											Source: "r",
											Start: ast.Position{
												Column: 41,
												Line:   35,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   35,
												},
												File:   "schema.flux",
												Source: "r",
												Start: ast.Position{
													Column: 41,
													Line:   35,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 77,
								Line:   35,
							},
							File:   "schema.flux",
							Source: "tagKeys(bucket: bucket, predicate: (r) => r._measurement == measurement)",
							Start: ast.Position{
								Column: 5,
								Line:   35,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   35,
								},
								File:   "schema.flux",
								Source: "tagKeys",
								Start: ast.Position{
									Column: 5,
									Line:   35,
								},
							},
						},
						Name: "tagKeys",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   34,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 23,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   34,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 23,
									Line:   34,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   34,
							},
							File:   "schema.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 31,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "schema.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 31,
									Line:   34,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   40,
					},
					File:   "schema.flux",
					Source: "fieldKeys = (bucket, predicate=(r) => true, start=-30d) =>\n    tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// FieldKeys is a special application of tagValues that returns field keys in a given bucket.\n"}, ast.Comment{Text: "// The return value is always a single table with a single column, \"_value\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   39,
						},
						File:   "schema.flux",
						Source: "fieldKeys",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "fieldKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   40,
						},
						File:   "schema.flux",
						Source: "(bucket, predicate=(r) => true, start=-30d) =>\n    tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)",
						Start: ast.Position{
							Column: 13,
							Line:   39,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   40,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, tag: \"_field\", predicate: predicate, start: start",
								Start: ast.Position{
									Column: 15,
									Line:   40,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   40,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 15,
										Line:   40,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 15,
											Line:   40,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 23,
											Line:   40,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   40,
									},
									File:   "schema.flux",
									Source: "tag: \"_field\"",
									Start: ast.Position{
										Column: 31,
										Line:   40,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 31,
											Line:   40,
										},
									},
								},
								Name: "tag",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "\"_field\"",
										Start: ast.Position{
											Column: 36,
											Line:   40,
										},
									},
								},
								Value: "_field",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   40,
									},
									File:   "schema.flux",
									Source: "predicate: predicate",
									Start: ast.Position{
										Column: 46,
										Line:   40,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 46,
											Line:   40,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 57,
											Line:   40,
										},
									},
								},
								Name: "predicate",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   40,
									},
									File:   "schema.flux",
									Source: "start: start",
									Start: ast.Position{
										Column: 68,
										Line:   40,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 68,
											Line:   40,
										},
									},
								},
								Name: "start",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   40,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 75,
											Line:   40,
										},
									},
								},
								Name: "start",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   40,
							},
							File:   "schema.flux",
							Source: "tagValues(bucket: bucket, tag: \"_field\", predicate: predicate, start: start)",
							Start: ast.Position{
								Column: 5,
								Line:   40,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   40,
								},
								File:   "schema.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						Name: "tagValues",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   39,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 14,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   39,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 14,
									Line:   39,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   39,
							},
							File:   "schema.flux",
							Source: "predicate=(r) => true",
							Start: ast.Position{
								Column: 22,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   39,
								},
								File:   "schema.flux",
								Source: "predicate",
								Start: ast.Position{
									Column: 22,
									Line:   39,
								},
							},
						},
						Name: "predicate",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   39,
								},
								File:   "schema.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 32,
									Line:   39,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   39,
									},
									File:   "schema.flux",
									Source: "true",
									Start: ast.Position{
										Column: 39,
										Line:   39,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   39,
									},
									File:   "schema.flux",
									Source: "r",
									Start: ast.Position{
										Column: 33,
										Line:   39,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   39,
										},
										File:   "schema.flux",
										Source: "r",
										Start: ast.Position{
											Column: 33,
											Line:   39,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   39,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 45,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   39,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 45,
									Line:   39,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   39,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 52,
										Line:   39,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   39,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 51,
									Line:   39,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 93,
						Line:   45,
					},
					File:   "schema.flux",
					Source: "measurementFieldKeys = (bucket, measurement, start=-30d) =>\n    fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// MeasurementFieldKeys returns field keys in a given measurement.\n"}, ast.Comment{Text: "// The return value is always a single table with a single column, \"_value\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   44,
						},
						File:   "schema.flux",
						Source: "measurementFieldKeys",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "measurementFieldKeys",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 93,
							Line:   45,
						},
						File:   "schema.flux",
						Source: "(bucket, measurement, start=-30d) =>\n    fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)",
						Start: ast.Position{
							Column: 24,
							Line:   44,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   45,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, predicate: (r) => r._measurement == measurement, start: start",
								Start: ast.Position{
									Column: 15,
									Line:   45,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   45,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 15,
										Line:   45,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 15,
											Line:   45,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 23,
											Line:   45,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   45,
									},
									File:   "schema.flux",
									Source: "predicate: (r) => r._measurement == measurement",
									Start: ast.Position{
										Column: 31,
										Line:   45,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "predicate",
										Start: ast.Position{
											Column: 31,
											Line:   45,
										},
									},
								},
								Name: "predicate",
							},
							Separator: nil,
							Value: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "(r) => r._measurement == measurement",
										Start: ast.Position{
											Column: 42,
											Line:   45,
										},
									},
								},
								Body: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   45,
											},
											File:   "schema.flux",
											Source: "r._measurement == measurement",
											Start: ast.Position{
												Column: 49,
												Line:   45,
											},
										},
									},
									Left: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   45,
												},
												File:   "schema.flux",
												Source: "r._measurement",
												Start: ast.Position{
													Column: 49,
													Line:   45,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   45,
													},
													File:   "schema.flux",
													Source: "r",
													Start: ast.Position{
														Column: 49,
														Line:   45,
													},
												},
											},
											Name: "r",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   45,
													},
													File:   "schema.flux",
													Source: "_measurement",
													Start: ast.Position{
														Column: 51,
														Line:   45,
													},
												},
											},
											Name: "_measurement",
										},
										Rbrack: nil,
									},
									Operator: 17,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   45,
												},
												File:   "schema.flux",
												Source: "measurement",
												Start: ast.Position{
													Column: 67,
													Line:   45,
												},
											},
										},
										Name: "measurement",
									},
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   45,
											},
											File:   "schema.flux",
											Source: "r",
											Start: ast.Position{
												Column: 43,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   45,
												},
												File:   "schema.flux",
												Source: "r",
												Start: ast.Position{
													Column: 43,
													Line:   45,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   45,
									},
									File:   "schema.flux",
									Source: "start: start",
									Start: ast.Position{
										Column: 80,
										Line:   45,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 80,
											Line:   45,
										},
									},
								},
								Name: "start",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   45,
										},
										File:   "schema.flux",
										Source: "start",
										Start: ast.Position{
											Column: 87,
											Line:   45,
										},
									},
								},
								Name: "start",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   45,
							},
							File:   "schema.flux",
							Source: "fieldKeys(bucket: bucket, predicate: (r) => r._measurement == measurement, start: start)",
							Start: ast.Position{
								Column: 5,
								Line:   45,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   45,
								},
								File:   "schema.flux",
								Source: "fieldKeys",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Name: "fieldKeys",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   44,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 25,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   44,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 25,
									Line:   44,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   44,
							},
							File:   "schema.flux",
							Source: "measurement",
							Start: ast.Position{
								Column: 33,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   44,
								},
								File:   "schema.flux",
								Source: "measurement",
								Start: ast.Position{
									Column: 33,
									Line:   44,
								},
							},
						},
						Name: "measurement",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   44,
							},
							File:   "schema.flux",
							Source: "start=-30d",
							Start: ast.Position{
								Column: 46,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   44,
								},
								File:   "schema.flux",
								Source: "start",
								Start: ast.Position{
									Column: 46,
									Line:   44,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value: &ast.UnaryExpression{
						Argument: &ast.DurationLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   44,
									},
									File:   "schema.flux",
									Source: "30d",
									Start: ast.Position{
										Column: 53,
										Line:   44,
									},
								},
							},
							Values: []ast.Duration{ast.Duration{
								Magnitude: int64(30),
								Unit:      "d",
							}},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   44,
								},
								File:   "schema.flux",
								Source: "-30d",
								Start: ast.Position{
									Column: 52,
									Line:   44,
								},
							},
						},
						Operator: 6,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 51,
						Line:   49,
					},
					File:   "schema.flux",
					Source: "measurements = (bucket) =>\n    tagValues(bucket: bucket, tag: \"_measurement\")",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Measurements returns the list of measurements in a specific bucket.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "schema.flux",
						Source: "measurements",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "measurements",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   49,
						},
						File:   "schema.flux",
						Source: "(bucket) =>\n    tagValues(bucket: bucket, tag: \"_measurement\")",
						Start: ast.Position{
							Column: 16,
							Line:   48,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   49,
								},
								File:   "schema.flux",
								Source: "bucket: bucket, tag: \"_measurement\"",
								Start: ast.Position{
									Column: 15,
									Line:   49,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   49,
									},
									File:   "schema.flux",
									Source: "bucket: bucket",
									Start: ast.Position{
										Column: 15,
										Line:   49,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   49,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 15,
											Line:   49,
										},
									},
								},
								Name: "bucket",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   49,
										},
										File:   "schema.flux",
										Source: "bucket",
										Start: ast.Position{
											Column: 23,
											Line:   49,
										},
									},
								},
								Name: "bucket",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   49,
									},
									File:   "schema.flux",
									Source: "tag: \"_measurement\"",
									Start: ast.Position{
										Column: 31,
										Line:   49,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   49,
										},
										File:   "schema.flux",
										Source: "tag",
										Start: ast.Position{
											Column: 31,
											Line:   49,
										},
									},
								},
								Name: "tag",
							},
							Separator: nil,
							Value: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   49,
										},
										File:   "schema.flux",
										Source: "\"_measurement\"",
										Start: ast.Position{
											Column: 36,
											Line:   49,
										},
									},
								},
								Value: "_measurement",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   49,
							},
							File:   "schema.flux",
							Source: "tagValues(bucket: bucket, tag: \"_measurement\")",
							Start: ast.Position{
								Column: 5,
								Line:   49,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   49,
								},
								File:   "schema.flux",
								Source: "tagValues",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Name: "tagValues",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   48,
							},
							File:   "schema.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 17,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   48,
								},
								File:   "schema.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 17,
									Line:   48,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "schema.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   1,
					},
					File:   "schema.flux",
					Source: "package schema",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   1,
						},
						File:   "schema.flux",
						Source: "schema",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "schema",
			},
		},
	}},
	Package: "schema",
	Path:    "influxdata/influxdb/schema",
}
