// DO NOT EDIT: This file is autogenerated via the builtin command.

package planner

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   56,
				},
				File:   "aggregate_window_max_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption planner.disablePhysicalRules = [\"PushDownWindowAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"\n\naggregate_window_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)\n\ntest aggregate_window_max_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   6,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownWindowAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   6,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "[\"PushDownWindowAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   6,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   6,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "\"PushDownWindowAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   6,
								},
							},
						},
						Value: "PushDownWindowAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   6,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   6,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   6,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   6,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   6,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownWindowAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   8,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   49,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   35,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   49,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   35,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 44,
						Line:   53,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "aggregate_window_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   51,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "aggregate_window_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "aggregate_window_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   53,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)",
						Start: ast.Position{
							Column: 27,
							Line:   51,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   51,
									},
									File:   "aggregate_window_max_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   51,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   52,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
								Start: ast.Position{
									Column: 42,
									Line:   51,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   52,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z",
										Start: ast.Position{
											Column: 14,
											Line:   52,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "start: 2018-05-22T19:53:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   52,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "2018-05-22T19:53:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   52,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "stop: 2018-05-22T19:54:20Z",
											Start: ast.Position{
												Column: 43,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   52,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 43,
													Line:   52,
												},
											},
										},
										Name: "stop",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   52,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "2018-05-22T19:54:20Z",
												Start: ast.Position{
													Column: 49,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:54:20Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   52,
									},
									File:   "aggregate_window_max_eval_test.flux",
									Source: "range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   52,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   52,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   53,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)",
							Start: ast.Position{
								Column: 42,
								Line:   51,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   53,
									},
									File:   "aggregate_window_max_eval_test.flux",
									Source: "every: 20s, fn: max",
									Start: ast.Position{
										Column: 24,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   53,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "every: 20s",
										Start: ast.Position{
											Column: 24,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   53,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   53,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   53,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "20s",
											Start: ast.Position{
												Column: 31,
												Line:   53,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(20),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   53,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "fn: max",
										Start: ast.Position{
											Column: 36,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   53,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   53,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "max",
											Start: ast.Position{
												Column: 40,
												Line:   53,
											},
										},
									},
									Name: "max",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   53,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "aggregateWindow(every: 20s, fn: max)",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   53,
									},
									File:   "aggregate_window_max_eval_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   53,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   51,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 28,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   51,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 28,
									Line:   51,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   51,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 35,
								Line:   51,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   56,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "aggregate_window_max_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   55,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "aggregate_window_max_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "aggregate_window_max_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   56,
							},
							File:   "aggregate_window_max_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
							Start: ast.Position{
								Column: 38,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   56,
								},
								File:   "aggregate_window_max_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   56,
									},
									File:   "aggregate_window_max_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   56,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   56,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   56,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   56,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   56,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   56,
													},
													File:   "aggregate_window_max_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   56,
														},
														File:   "aggregate_window_max_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   56,
														},
														File:   "aggregate_window_max_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   56,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   56,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   56,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   56,
													},
													File:   "aggregate_window_max_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   56,
													},
													File:   "aggregate_window_max_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   56,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   56,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   56,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   56,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   56,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   56,
													},
													File:   "aggregate_window_max_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   56,
														},
														File:   "aggregate_window_max_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   56,
														},
														File:   "aggregate_window_max_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   56,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   56,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   56,
												},
												File:   "aggregate_window_max_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   56,
													},
													File:   "aggregate_window_max_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   56,
													},
													File:   "aggregate_window_max_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   56,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   56,
										},
										File:   "aggregate_window_max_eval_test.flux",
										Source: "fn: aggregate_window_max_fn",
										Start: ast.Position{
											Column: 83,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   56,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   56,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   56,
											},
											File:   "aggregate_window_max_eval_test.flux",
											Source: "aggregate_window_max_fn",
											Start: ast.Position{
												Column: 87,
												Line:   56,
											},
										},
									},
									Name: "aggregate_window_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   56,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "test aggregate_window_max_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_max_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "aggregate_window_max_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "aggregate_window_max_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   53,
				},
				File:   "aggregate_window_max_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"\n\naggregate_window_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)\n\ntest aggregate_window_max_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   30,
					},
					File:   "aggregate_window_max_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   5,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   30,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   5,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "aggregate_window_max_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   32,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   32,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.91\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.99\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 44,
						Line:   50,
					},
					File:   "aggregate_window_max_push_test.flux",
					Source: "aggregate_window_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   48,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "aggregate_window_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "aggregate_window_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   50,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)",
						Start: ast.Position{
							Column: 27,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   48,
									},
									File:   "aggregate_window_max_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   48,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   49,
								},
								File:   "aggregate_window_max_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
								Start: ast.Position{
									Column: 42,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   49,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z",
										Start: ast.Position{
											Column: 14,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   49,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "start: 2018-05-22T19:53:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   49,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "2018-05-22T19:53:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   49,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   49,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "stop: 2018-05-22T19:54:20Z",
											Start: ast.Position{
												Column: 43,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   49,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 43,
													Line:   49,
												},
											},
										},
										Name: "stop",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   49,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "2018-05-22T19:54:20Z",
												Start: ast.Position{
													Column: 49,
													Line:   49,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:54:20Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   49,
									},
									File:   "aggregate_window_max_push_test.flux",
									Source: "range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
									Start: ast.Position{
										Column: 8,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   49,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   50,
							},
							File:   "aggregate_window_max_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: max)",
							Start: ast.Position{
								Column: 42,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   50,
									},
									File:   "aggregate_window_max_push_test.flux",
									Source: "every: 20s, fn: max",
									Start: ast.Position{
										Column: 24,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   50,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "every: 20s",
										Start: ast.Position{
											Column: 24,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   50,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   50,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   50,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "20s",
											Start: ast.Position{
												Column: 31,
												Line:   50,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(20),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   50,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "fn: max",
										Start: ast.Position{
											Column: 36,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   50,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   50,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   50,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "max",
											Start: ast.Position{
												Column: 40,
												Line:   50,
											},
										},
									},
									Name: "max",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   50,
								},
								File:   "aggregate_window_max_push_test.flux",
								Source: "aggregateWindow(every: 20s, fn: max)",
								Start: ast.Position{
									Column: 8,
									Line:   50,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   50,
									},
									File:   "aggregate_window_max_push_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   48,
							},
							File:   "aggregate_window_max_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 28,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   48,
								},
								File:   "aggregate_window_max_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 28,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   48,
							},
							File:   "aggregate_window_max_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 35,
								Line:   48,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   53,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "aggregate_window_max_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   52,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   52,
							},
							File:   "aggregate_window_max_push_test.flux",
							Source: "aggregate_window_max_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   52,
							},
						},
					},
					Name: "aggregate_window_max_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   53,
							},
							File:   "aggregate_window_max_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
							Start: ast.Position{
								Column: 38,
								Line:   52,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   53,
								},
								File:   "aggregate_window_max_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   53,
									},
									File:   "aggregate_window_max_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   53,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   53,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   53,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   53,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   53,
													},
													File:   "aggregate_window_max_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   53,
														},
														File:   "aggregate_window_max_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   53,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   53,
														},
														File:   "aggregate_window_max_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   53,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   53,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   53,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   53,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   53,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   53,
													},
													File:   "aggregate_window_max_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   53,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   53,
													},
													File:   "aggregate_window_max_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   53,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   53,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   53,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   53,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   53,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   53,
													},
													File:   "aggregate_window_max_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   53,
														},
														File:   "aggregate_window_max_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   53,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   53,
														},
														File:   "aggregate_window_max_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   53,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   53,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   53,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   53,
												},
												File:   "aggregate_window_max_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   53,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   53,
													},
													File:   "aggregate_window_max_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   53,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   53,
													},
													File:   "aggregate_window_max_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   53,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   53,
										},
										File:   "aggregate_window_max_push_test.flux",
										Source: "fn: aggregate_window_max_fn",
										Start: ast.Position{
											Column: 83,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   53,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   53,
											},
											File:   "aggregate_window_max_push_test.flux",
											Source: "aggregate_window_max_fn",
											Start: ast.Position{
												Column: 87,
												Line:   53,
											},
										},
									},
									Name: "aggregate_window_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   53,
					},
					File:   "aggregate_window_max_push_test.flux",
					Source: "test aggregate_window_max_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_max_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_max_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_max_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "aggregate_window_max_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "aggregate_window_max_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   56,
				},
				File:   "aggregate_window_min_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption planner.disablePhysicalRules = [\"PushDownWindowAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"\n\naggregate_window_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)\n\ntest aggregate_window_min_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   6,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownWindowAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   6,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "[\"PushDownWindowAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   6,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   6,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "\"PushDownWindowAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   6,
								},
							},
						},
						Value: "PushDownWindowAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   6,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   6,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   6,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   6,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   6,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownWindowAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   8,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   49,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   35,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   49,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   35,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 44,
						Line:   53,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "aggregate_window_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   51,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "aggregate_window_min_fn",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "aggregate_window_min_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   53,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)",
						Start: ast.Position{
							Column: 27,
							Line:   51,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   51,
									},
									File:   "aggregate_window_min_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   51,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   52,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
								Start: ast.Position{
									Column: 42,
									Line:   51,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   52,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z",
										Start: ast.Position{
											Column: 14,
											Line:   52,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "start: 2018-05-22T19:53:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   52,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "2018-05-22T19:53:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   52,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "stop: 2018-05-22T19:54:20Z",
											Start: ast.Position{
												Column: 43,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   52,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 43,
													Line:   52,
												},
											},
										},
										Name: "stop",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   52,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "2018-05-22T19:54:20Z",
												Start: ast.Position{
													Column: 49,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:54:20Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   52,
									},
									File:   "aggregate_window_min_eval_test.flux",
									Source: "range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   52,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   52,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   53,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)",
							Start: ast.Position{
								Column: 42,
								Line:   51,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   53,
									},
									File:   "aggregate_window_min_eval_test.flux",
									Source: "every: 20s, fn: min",
									Start: ast.Position{
										Column: 24,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   53,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "every: 20s",
										Start: ast.Position{
											Column: 24,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   53,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   53,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   53,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "20s",
											Start: ast.Position{
												Column: 31,
												Line:   53,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(20),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   53,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "fn: min",
										Start: ast.Position{
											Column: 36,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   53,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   53,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "min",
											Start: ast.Position{
												Column: 40,
												Line:   53,
											},
										},
									},
									Name: "min",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   53,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "aggregateWindow(every: 20s, fn: min)",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   53,
									},
									File:   "aggregate_window_min_eval_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   53,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   51,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 28,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   51,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 28,
									Line:   51,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   51,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 35,
								Line:   51,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   56,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "aggregate_window_min_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   55,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "aggregate_window_min_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "aggregate_window_min_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   56,
							},
							File:   "aggregate_window_min_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
							Start: ast.Position{
								Column: 38,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   56,
								},
								File:   "aggregate_window_min_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   56,
									},
									File:   "aggregate_window_min_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   56,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   56,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   56,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   56,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   56,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   56,
													},
													File:   "aggregate_window_min_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   56,
														},
														File:   "aggregate_window_min_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   56,
														},
														File:   "aggregate_window_min_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   56,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   56,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   56,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   56,
													},
													File:   "aggregate_window_min_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   56,
													},
													File:   "aggregate_window_min_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   56,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   56,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   56,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   56,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   56,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   56,
													},
													File:   "aggregate_window_min_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   56,
														},
														File:   "aggregate_window_min_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   56,
														},
														File:   "aggregate_window_min_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   56,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   56,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   56,
												},
												File:   "aggregate_window_min_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   56,
													},
													File:   "aggregate_window_min_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   56,
													},
													File:   "aggregate_window_min_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   56,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   56,
										},
										File:   "aggregate_window_min_eval_test.flux",
										Source: "fn: aggregate_window_min_fn",
										Start: ast.Position{
											Column: 83,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   56,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   56,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   56,
											},
											File:   "aggregate_window_min_eval_test.flux",
											Source: "aggregate_window_min_fn",
											Start: ast.Position{
												Column: 87,
												Line:   56,
											},
										},
									},
									Name: "aggregate_window_min_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   56,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "test aggregate_window_min_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_min_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "aggregate_window_min_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "aggregate_window_min_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   53,
				},
				File:   "aggregate_window_min_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"\n\naggregate_window_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)\n\ntest aggregate_window_min_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   30,
					},
					File:   "aggregate_window_min_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   5,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   30,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   5,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "aggregate_window_min_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   32,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   32,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load1,1.84\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load3,1.97\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:53:40Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:00Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:53:00Z,2018-05-22T19:54:20Z,2018-05-22T19:54:20Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 44,
						Line:   50,
					},
					File:   "aggregate_window_min_push_test.flux",
					Source: "aggregate_window_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   48,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "aggregate_window_min_fn",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "aggregate_window_min_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   50,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)",
						Start: ast.Position{
							Column: 27,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   48,
									},
									File:   "aggregate_window_min_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   48,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   49,
								},
								File:   "aggregate_window_min_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
								Start: ast.Position{
									Column: 42,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   49,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z",
										Start: ast.Position{
											Column: 14,
											Line:   49,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   49,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "start: 2018-05-22T19:53:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   49,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "2018-05-22T19:53:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   49,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   49,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "stop: 2018-05-22T19:54:20Z",
											Start: ast.Position{
												Column: 43,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   49,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 43,
													Line:   49,
												},
											},
										},
										Name: "stop",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   49,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "2018-05-22T19:54:20Z",
												Start: ast.Position{
													Column: 49,
													Line:   49,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:54:20Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   49,
									},
									File:   "aggregate_window_min_push_test.flux",
									Source: "range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)",
									Start: ast.Position{
										Column: 8,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   49,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   50,
							},
							File:   "aggregate_window_min_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:54:20Z)\n    |> aggregateWindow(every: 20s, fn: min)",
							Start: ast.Position{
								Column: 42,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   50,
									},
									File:   "aggregate_window_min_push_test.flux",
									Source: "every: 20s, fn: min",
									Start: ast.Position{
										Column: 24,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   50,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "every: 20s",
										Start: ast.Position{
											Column: 24,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   50,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   50,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   50,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "20s",
											Start: ast.Position{
												Column: 31,
												Line:   50,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(20),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   50,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "fn: min",
										Start: ast.Position{
											Column: 36,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   50,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   50,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   50,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "min",
											Start: ast.Position{
												Column: 40,
												Line:   50,
											},
										},
									},
									Name: "min",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   50,
								},
								File:   "aggregate_window_min_push_test.flux",
								Source: "aggregateWindow(every: 20s, fn: min)",
								Start: ast.Position{
									Column: 8,
									Line:   50,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   50,
									},
									File:   "aggregate_window_min_push_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   48,
							},
							File:   "aggregate_window_min_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 28,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   48,
								},
								File:   "aggregate_window_min_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 28,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   48,
							},
							File:   "aggregate_window_min_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 35,
								Line:   48,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   53,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "aggregate_window_min_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   52,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   52,
							},
							File:   "aggregate_window_min_push_test.flux",
							Source: "aggregate_window_min_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   52,
							},
						},
					},
					Name: "aggregate_window_min_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   53,
							},
							File:   "aggregate_window_min_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
							Start: ast.Position{
								Column: 38,
								Line:   52,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   53,
								},
								File:   "aggregate_window_min_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   53,
									},
									File:   "aggregate_window_min_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   53,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   53,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   53,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   53,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   53,
													},
													File:   "aggregate_window_min_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   53,
														},
														File:   "aggregate_window_min_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   53,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   53,
														},
														File:   "aggregate_window_min_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   53,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   53,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   53,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   53,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   53,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   53,
													},
													File:   "aggregate_window_min_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   53,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   53,
													},
													File:   "aggregate_window_min_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   53,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   53,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   53,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   53,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   53,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   53,
													},
													File:   "aggregate_window_min_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   53,
														},
														File:   "aggregate_window_min_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   53,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   53,
														},
														File:   "aggregate_window_min_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   53,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   53,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   53,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   53,
												},
												File:   "aggregate_window_min_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   53,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   53,
													},
													File:   "aggregate_window_min_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   53,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   53,
													},
													File:   "aggregate_window_min_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   53,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   53,
										},
										File:   "aggregate_window_min_push_test.flux",
										Source: "fn: aggregate_window_min_fn",
										Start: ast.Position{
											Column: 83,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   53,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   53,
											},
											File:   "aggregate_window_min_push_test.flux",
											Source: "aggregate_window_min_fn",
											Start: ast.Position{
												Column: 87,
												Line:   53,
											},
										},
									},
									Name: "aggregate_window_min_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   53,
					},
					File:   "aggregate_window_min_push_test.flux",
					Source: "test aggregate_window_min_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: aggregate_window_min_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_min_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_min_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "aggregate_window_min_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "aggregate_window_min_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 102,
					Line:   51,
				},
				File:   "bare_count_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption now = () => (2030-01-01T00:00:00Z)\noption planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n\"\n\nbare_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()\n\ntest bare_count_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "bare_count_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "bare_count_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "bare_count_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "bare_count_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "bare_count_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "bare_count_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   7,
						},
						File:   "bare_count_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   7,
							},
							File:   "bare_count_eval_test.flux",
							Source: "[\"PushDownBareAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   7,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   7,
								},
								File:   "bare_count_eval_test.flux",
								Source: "\"PushDownBareAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   7,
								},
							},
						},
						Value: "PushDownBareAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   7,
							},
							File:   "bare_count_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   7,
								},
								File:   "bare_count_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   7,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   7,
								},
								File:   "bare_count_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   7,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   7,
					},
					File:   "bare_count_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "bare_count_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   9,
						},
						File:   "bare_count_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "bare_count_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "bare_count_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "bare_count_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "bare_count_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   48,
					},
					File:   "bare_count_eval_test.flux",
					Source: "bare_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   46,
						},
						File:   "bare_count_eval_test.flux",
						Source: "bare_count_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "bare_count_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   48,
						},
						File:   "bare_count_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()",
						Start: ast.Position{
							Column: 17,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   46,
									},
									File:   "bare_count_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 32,
										Line:   46,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   47,
								},
								File:   "bare_count_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 32,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   47,
										},
										File:   "bare_count_eval_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   47,
											},
											File:   "bare_count_eval_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "bare_count_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "bare_count_eval_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   47,
									},
									File:   "bare_count_eval_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "bare_count_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   48,
							},
							File:   "bare_count_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()",
							Start: ast.Position{
								Column: 32,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   48,
								},
								File:   "bare_count_eval_test.flux",
								Source: "count()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   48,
									},
									File:   "bare_count_eval_test.flux",
									Source: "count",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "count",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   46,
							},
							File:   "bare_count_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 18,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   46,
								},
								File:   "bare_count_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 18,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   46,
							},
							File:   "bare_count_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 102,
							Line:   51,
						},
						File:   "bare_count_eval_test.flux",
						Source: "bare_count_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   50,
							},
							File:   "bare_count_eval_test.flux",
							Source: "bare_count_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "bare_count_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   51,
							},
							File:   "bare_count_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
							Start: ast.Position{
								Column: 28,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   51,
								},
								File:   "bare_count_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   51,
									},
									File:   "bare_count_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   51,
										},
										File:   "bare_count_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   51,
											},
											File:   "bare_count_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   51,
												},
												File:   "bare_count_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   51,
													},
													File:   "bare_count_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   51,
														},
														File:   "bare_count_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   51,
														},
														File:   "bare_count_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   51,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   51,
											},
											File:   "bare_count_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   51,
												},
												File:   "bare_count_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   51,
													},
													File:   "bare_count_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   51,
													},
													File:   "bare_count_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   51,
										},
										File:   "bare_count_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   51,
											},
											File:   "bare_count_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   51,
												},
												File:   "bare_count_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   51,
													},
													File:   "bare_count_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   51,
														},
														File:   "bare_count_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   51,
														},
														File:   "bare_count_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   51,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   51,
											},
											File:   "bare_count_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   51,
												},
												File:   "bare_count_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   51,
													},
													File:   "bare_count_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   51,
													},
													File:   "bare_count_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   51,
										},
										File:   "bare_count_eval_test.flux",
										Source: "fn: bare_count_fn",
										Start: ast.Position{
											Column: 83,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   51,
											},
											File:   "bare_count_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   51,
											},
											File:   "bare_count_eval_test.flux",
											Source: "bare_count_fn",
											Start: ast.Position{
												Column: 87,
												Line:   51,
											},
										},
									},
									Name: "bare_count_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 102,
						Line:   51,
					},
					File:   "bare_count_eval_test.flux",
					Source: "test bare_count_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_count_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_count_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "bare_count_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "bare_count_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_count_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_count_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_count_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 102,
					Line:   49,
				},
				File:   "bare_count_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n\"\n\nbare_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()\n\ntest bare_count_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "bare_count_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "bare_count_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "bare_count_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "bare_count_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "bare_count_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "bare_count_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "bare_count_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "bare_count_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "bare_count_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "bare_count_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   34,
						},
						File:   "bare_count_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "bare_count_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   34,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,long\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,6\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,6\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   46,
					},
					File:   "bare_count_push_test.flux",
					Source: "bare_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   44,
						},
						File:   "bare_count_push_test.flux",
						Source: "bare_count_fn",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "bare_count_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   46,
						},
						File:   "bare_count_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()",
						Start: ast.Position{
							Column: 17,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   44,
									},
									File:   "bare_count_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 32,
										Line:   44,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   45,
								},
								File:   "bare_count_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 32,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   45,
										},
										File:   "bare_count_push_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   45,
											},
											File:   "bare_count_push_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   45,
												},
												File:   "bare_count_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   45,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   45,
												},
												File:   "bare_count_push_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   45,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   45,
									},
									File:   "bare_count_push_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   45,
										},
										File:   "bare_count_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   45,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   46,
							},
							File:   "bare_count_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> count()",
							Start: ast.Position{
								Column: 32,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   46,
								},
								File:   "bare_count_push_test.flux",
								Source: "count()",
								Start: ast.Position{
									Column: 8,
									Line:   46,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   46,
									},
									File:   "bare_count_push_test.flux",
									Source: "count",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Name: "count",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   44,
							},
							File:   "bare_count_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 18,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   44,
								},
								File:   "bare_count_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 18,
									Line:   44,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   44,
							},
							File:   "bare_count_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 102,
							Line:   49,
						},
						File:   "bare_count_push_test.flux",
						Source: "bare_count_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   48,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   48,
							},
							File:   "bare_count_push_test.flux",
							Source: "bare_count_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   48,
							},
						},
					},
					Name: "bare_count_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   49,
							},
							File:   "bare_count_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
							Start: ast.Position{
								Column: 28,
								Line:   48,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   49,
								},
								File:   "bare_count_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   49,
									},
									File:   "bare_count_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   49,
										},
										File:   "bare_count_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   49,
											},
											File:   "bare_count_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   49,
												},
												File:   "bare_count_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   49,
													},
													File:   "bare_count_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   49,
														},
														File:   "bare_count_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   49,
														},
														File:   "bare_count_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   49,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   49,
											},
											File:   "bare_count_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   49,
												},
												File:   "bare_count_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   49,
													},
													File:   "bare_count_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   49,
													},
													File:   "bare_count_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   49,
										},
										File:   "bare_count_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   49,
											},
											File:   "bare_count_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   49,
												},
												File:   "bare_count_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   49,
													},
													File:   "bare_count_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   49,
														},
														File:   "bare_count_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   49,
														},
														File:   "bare_count_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   49,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   49,
											},
											File:   "bare_count_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   49,
												},
												File:   "bare_count_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   49,
													},
													File:   "bare_count_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   49,
													},
													File:   "bare_count_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   49,
										},
										File:   "bare_count_push_test.flux",
										Source: "fn: bare_count_fn",
										Start: ast.Position{
											Column: 83,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   49,
											},
											File:   "bare_count_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 100,
												Line:   49,
											},
											File:   "bare_count_push_test.flux",
											Source: "bare_count_fn",
											Start: ast.Position{
												Column: 87,
												Line:   49,
											},
										},
									},
									Name: "bare_count_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 102,
						Line:   49,
					},
					File:   "bare_count_push_test.flux",
					Source: "test bare_count_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_count_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_count_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_count_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_count_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_count_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_count_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 101,
					Line:   28,
				},
				File:   "bare_last_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2020-10-30T00:00:01Z,m,f,1\n,,0,2020-10-30T00:00:09Z,m,f,9\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string\n#group,false,false,true,true,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement\n,,0,2020-10-30T00:00:01Z,2020-10-30T00:00:09Z,2020-10-30T00:00:01Z,1,f,m\n\"\n\nbare_last_fn = (tables=<-) => tables\n    |> range(start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z)\n    |> last()\n\ntest bare_last = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_last_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   13,
					},
					File:   "bare_last_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2020-10-30T00:00:01Z,m,f,1\n,,0,2020-10-30T00:00:09Z,m,f,9\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   6,
						},
						File:   "bare_last_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   13,
						},
						File:   "bare_last_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2020-10-30T00:00:01Z,m,f,1\n,,0,2020-10-30T00:00:09Z,m,f,9\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2020-10-30T00:00:01Z,m,f,1\n,,0,2020-10-30T00:00:09Z,m,f,9\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "bare_last_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string\n#group,false,false,true,true,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement\n,,0,2020-10-30T00:00:01Z,2020-10-30T00:00:09Z,2020-10-30T00:00:01Z,1,f,m\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   15,
						},
						File:   "bare_last_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "bare_last_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string\n#group,false,false,true,true,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement\n,,0,2020-10-30T00:00:01Z,2020-10-30T00:00:09Z,2020-10-30T00:00:01Z,1,f,m\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   15,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string\n#group,false,false,true,true,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement\n,,0,2020-10-30T00:00:01Z,2020-10-30T00:00:09Z,2020-10-30T00:00:01Z,1,f,m\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   25,
					},
					File:   "bare_last_test.flux",
					Source: "bare_last_fn = (tables=<-) => tables\n    |> range(start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z)\n    |> last()",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   23,
						},
						File:   "bare_last_test.flux",
						Source: "bare_last_fn",
						Start: ast.Position{
							Column: 1,
							Line:   23,
						},
					},
				},
				Name: "bare_last_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   25,
						},
						File:   "bare_last_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z)\n    |> last()",
						Start: ast.Position{
							Column: 16,
							Line:   23,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   23,
									},
									File:   "bare_last_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   23,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   24,
								},
								File:   "bare_last_test.flux",
								Source: "tables\n    |> range(start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z)",
								Start: ast.Position{
									Column: 31,
									Line:   23,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   24,
										},
										File:   "bare_last_test.flux",
										Source: "start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z",
										Start: ast.Position{
											Column: 14,
											Line:   24,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   24,
											},
											File:   "bare_last_test.flux",
											Source: "start: 2020-10-30T00:00:01Z",
											Start: ast.Position{
												Column: 14,
												Line:   24,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   24,
												},
												File:   "bare_last_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   24,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   24,
												},
												File:   "bare_last_test.flux",
												Source: "2020-10-30T00:00:01Z",
												Start: ast.Position{
													Column: 21,
													Line:   24,
												},
											},
										},
										Value: parser.MustParseTime("2020-10-30T00:00:01Z"),
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   24,
											},
											File:   "bare_last_test.flux",
											Source: "stop: 2020-10-30T00:00:09Z",
											Start: ast.Position{
												Column: 43,
												Line:   24,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   24,
												},
												File:   "bare_last_test.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 43,
													Line:   24,
												},
											},
										},
										Name: "stop",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   24,
												},
												File:   "bare_last_test.flux",
												Source: "2020-10-30T00:00:09Z",
												Start: ast.Position{
													Column: 49,
													Line:   24,
												},
											},
										},
										Value: parser.MustParseTime("2020-10-30T00:00:09Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   24,
									},
									File:   "bare_last_test.flux",
									Source: "range(start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z)",
									Start: ast.Position{
										Column: 8,
										Line:   24,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   24,
										},
										File:   "bare_last_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   24,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   25,
							},
							File:   "bare_last_test.flux",
							Source: "tables\n    |> range(start: 2020-10-30T00:00:01Z, stop: 2020-10-30T00:00:09Z)\n    |> last()",
							Start: ast.Position{
								Column: 31,
								Line:   23,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   25,
								},
								File:   "bare_last_test.flux",
								Source: "last()",
								Start: ast.Position{
									Column: 8,
									Line:   25,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   25,
									},
									File:   "bare_last_test.flux",
									Source: "last",
									Start: ast.Position{
										Column: 8,
										Line:   25,
									},
								},
							},
							Name: "last",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   23,
							},
							File:   "bare_last_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   23,
								},
								File:   "bare_last_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   23,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   23,
							},
							File:   "bare_last_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   23,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   28,
						},
						File:   "bare_last_test.flux",
						Source: "bare_last = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_last_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   27,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   27,
							},
							File:   "bare_last_test.flux",
							Source: "bare_last",
							Start: ast.Position{
								Column: 6,
								Line:   27,
							},
						},
					},
					Name: "bare_last",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   28,
							},
							File:   "bare_last_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_last_fn})",
							Start: ast.Position{
								Column: 18,
								Line:   27,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   28,
								},
								File:   "bare_last_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_last_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   28,
									},
									File:   "bare_last_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_last_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   28,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   28,
										},
										File:   "bare_last_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   28,
											},
											File:   "bare_last_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   28,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   28,
												},
												File:   "bare_last_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   28,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   28,
													},
													File:   "bare_last_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   28,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   28,
														},
														File:   "bare_last_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   28,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   28,
														},
														File:   "bare_last_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   28,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   28,
											},
											File:   "bare_last_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   28,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   28,
												},
												File:   "bare_last_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   28,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   28,
													},
													File:   "bare_last_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   28,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   28,
													},
													File:   "bare_last_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   28,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   28,
										},
										File:   "bare_last_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   28,
											},
											File:   "bare_last_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   28,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   28,
												},
												File:   "bare_last_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   28,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   28,
													},
													File:   "bare_last_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   28,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   28,
														},
														File:   "bare_last_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   28,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   28,
														},
														File:   "bare_last_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   28,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   28,
											},
											File:   "bare_last_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   28,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   28,
												},
												File:   "bare_last_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   28,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   28,
													},
													File:   "bare_last_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   28,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   28,
													},
													File:   "bare_last_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   28,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   28,
										},
										File:   "bare_last_test.flux",
										Source: "fn: bare_last_fn",
										Start: ast.Position{
											Column: 83,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   28,
											},
											File:   "bare_last_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   28,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   28,
											},
											File:   "bare_last_test.flux",
											Source: "bare_last_fn",
											Start: ast.Position{
												Column: 87,
												Line:   28,
											},
										},
									},
									Name: "bare_last_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   28,
					},
					File:   "bare_last_test.flux",
					Source: "test bare_last = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_last_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_last_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_last_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "bare_last_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "bare_last_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_last_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_last_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_last_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   51,
				},
				File:   "bare_max_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption now = () => (2030-01-01T00:00:00Z)\noption planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n\"\n\nbare_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()\n\ntest bare_max_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "bare_max_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "bare_max_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "bare_max_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "bare_max_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "bare_max_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "bare_max_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   7,
						},
						File:   "bare_max_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   7,
							},
							File:   "bare_max_eval_test.flux",
							Source: "[\"PushDownBareAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   7,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   7,
								},
								File:   "bare_max_eval_test.flux",
								Source: "\"PushDownBareAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   7,
								},
							},
						},
						Value: "PushDownBareAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   7,
							},
							File:   "bare_max_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   7,
								},
								File:   "bare_max_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   7,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   7,
								},
								File:   "bare_max_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   7,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   7,
					},
					File:   "bare_max_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "bare_max_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   9,
						},
						File:   "bare_max_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "bare_max_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "bare_max_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "bare_max_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "bare_max_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   48,
					},
					File:   "bare_max_eval_test.flux",
					Source: "bare_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   46,
						},
						File:   "bare_max_eval_test.flux",
						Source: "bare_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "bare_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "bare_max_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()",
						Start: ast.Position{
							Column: 15,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   46,
									},
									File:   "bare_max_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 30,
										Line:   46,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   47,
								},
								File:   "bare_max_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   47,
										},
										File:   "bare_max_eval_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   47,
											},
											File:   "bare_max_eval_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "bare_max_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "bare_max_eval_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   47,
									},
									File:   "bare_max_eval_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "bare_max_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   48,
							},
							File:   "bare_max_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()",
							Start: ast.Position{
								Column: 30,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   48,
								},
								File:   "bare_max_eval_test.flux",
								Source: "max()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   48,
									},
									File:   "bare_max_eval_test.flux",
									Source: "max",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "max",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "bare_max_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   46,
								},
								File:   "bare_max_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "bare_max_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   51,
						},
						File:   "bare_max_eval_test.flux",
						Source: "bare_max_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   50,
							},
							File:   "bare_max_eval_test.flux",
							Source: "bare_max_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "bare_max_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   51,
							},
							File:   "bare_max_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   51,
								},
								File:   "bare_max_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   51,
									},
									File:   "bare_max_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   51,
										},
										File:   "bare_max_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   51,
											},
											File:   "bare_max_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   51,
												},
												File:   "bare_max_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   51,
													},
													File:   "bare_max_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   51,
														},
														File:   "bare_max_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   51,
														},
														File:   "bare_max_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   51,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   51,
											},
											File:   "bare_max_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   51,
												},
												File:   "bare_max_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   51,
													},
													File:   "bare_max_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   51,
													},
													File:   "bare_max_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   51,
										},
										File:   "bare_max_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   51,
											},
											File:   "bare_max_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   51,
												},
												File:   "bare_max_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   51,
													},
													File:   "bare_max_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   51,
														},
														File:   "bare_max_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   51,
														},
														File:   "bare_max_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   51,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   51,
											},
											File:   "bare_max_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   51,
												},
												File:   "bare_max_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   51,
													},
													File:   "bare_max_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   51,
													},
													File:   "bare_max_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   51,
										},
										File:   "bare_max_eval_test.flux",
										Source: "fn: bare_max_fn",
										Start: ast.Position{
											Column: 83,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   51,
											},
											File:   "bare_max_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   51,
											},
											File:   "bare_max_eval_test.flux",
											Source: "bare_max_fn",
											Start: ast.Position{
												Column: 87,
												Line:   51,
											},
										},
									},
									Name: "bare_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   51,
					},
					File:   "bare_max_eval_test.flux",
					Source: "test bare_max_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_max_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_max_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "bare_max_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "bare_max_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_max_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_max_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_max_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   49,
				},
				File:   "bare_max_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n\"\n\nbare_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()\n\ntest bare_max_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "bare_max_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "bare_max_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "bare_max_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "bare_max_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "bare_max_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "bare_max_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "bare_max_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "bare_max_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "bare_max_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "bare_max_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   34,
						},
						File:   "bare_max_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "bare_max_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   34,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,system,host.local,load3,1.99\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   46,
					},
					File:   "bare_max_push_test.flux",
					Source: "bare_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   44,
						},
						File:   "bare_max_push_test.flux",
						Source: "bare_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "bare_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "bare_max_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()",
						Start: ast.Position{
							Column: 15,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   44,
									},
									File:   "bare_max_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 30,
										Line:   44,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   45,
								},
								File:   "bare_max_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   45,
										},
										File:   "bare_max_push_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   45,
											},
											File:   "bare_max_push_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   45,
												},
												File:   "bare_max_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   45,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   45,
												},
												File:   "bare_max_push_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   45,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   45,
									},
									File:   "bare_max_push_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   45,
										},
										File:   "bare_max_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   45,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   46,
							},
							File:   "bare_max_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> max()",
							Start: ast.Position{
								Column: 30,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   46,
								},
								File:   "bare_max_push_test.flux",
								Source: "max()",
								Start: ast.Position{
									Column: 8,
									Line:   46,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   46,
									},
									File:   "bare_max_push_test.flux",
									Source: "max",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Name: "max",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   44,
							},
							File:   "bare_max_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   44,
								},
								File:   "bare_max_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   44,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   44,
							},
							File:   "bare_max_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   49,
						},
						File:   "bare_max_push_test.flux",
						Source: "bare_max_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   48,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   48,
							},
							File:   "bare_max_push_test.flux",
							Source: "bare_max_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   48,
							},
						},
					},
					Name: "bare_max_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   49,
							},
							File:   "bare_max_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   48,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   49,
								},
								File:   "bare_max_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   49,
									},
									File:   "bare_max_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   49,
										},
										File:   "bare_max_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   49,
											},
											File:   "bare_max_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   49,
												},
												File:   "bare_max_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   49,
													},
													File:   "bare_max_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   49,
														},
														File:   "bare_max_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   49,
														},
														File:   "bare_max_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   49,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   49,
											},
											File:   "bare_max_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   49,
												},
												File:   "bare_max_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   49,
													},
													File:   "bare_max_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   49,
													},
													File:   "bare_max_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   49,
										},
										File:   "bare_max_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   49,
											},
											File:   "bare_max_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   49,
												},
												File:   "bare_max_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   49,
													},
													File:   "bare_max_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   49,
														},
														File:   "bare_max_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   49,
														},
														File:   "bare_max_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   49,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   49,
											},
											File:   "bare_max_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   49,
												},
												File:   "bare_max_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   49,
													},
													File:   "bare_max_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   49,
													},
													File:   "bare_max_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   49,
										},
										File:   "bare_max_push_test.flux",
										Source: "fn: bare_max_fn",
										Start: ast.Position{
											Column: 83,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   49,
											},
											File:   "bare_max_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   49,
											},
											File:   "bare_max_push_test.flux",
											Source: "bare_max_fn",
											Start: ast.Position{
												Column: 87,
												Line:   49,
											},
										},
									},
									Name: "bare_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   49,
					},
					File:   "bare_max_push_test.flux",
					Source: "test bare_max_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_max_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_max_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_max_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_max_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_max_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_max_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 101,
					Line:   51,
				},
				File:   "bare_mean_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption now = () => (2030-01-01T00:00:00Z)\noption planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n\"\n\nbare_mean_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()\n\ntest bare_mean_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "bare_mean_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   7,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   7,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "[\"PushDownBareAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   7,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   7,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "\"PushDownBareAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   7,
								},
							},
						},
						Value: "PushDownBareAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   7,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   7,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   7,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   7,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   7,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   7,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   9,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   48,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "bare_mean_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "bare_mean_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "bare_mean_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   48,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()",
						Start: ast.Position{
							Column: 16,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   46,
									},
									File:   "bare_mean_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   46,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   47,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 31,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   47,
										},
										File:   "bare_mean_eval_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   47,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "bare_mean_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "bare_mean_eval_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   47,
									},
									File:   "bare_mean_eval_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "bare_mean_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   48,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()",
							Start: ast.Position{
								Column: 31,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   48,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "mean()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   48,
									},
									File:   "bare_mean_eval_test.flux",
									Source: "mean",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "mean",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   46,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   51,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "bare_mean_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   50,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "bare_mean_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "bare_mean_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   51,
							},
							File:   "bare_mean_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
							Start: ast.Position{
								Column: 27,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   51,
								},
								File:   "bare_mean_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   51,
									},
									File:   "bare_mean_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   51,
										},
										File:   "bare_mean_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   51,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   51,
												},
												File:   "bare_mean_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   51,
													},
													File:   "bare_mean_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   51,
														},
														File:   "bare_mean_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   51,
														},
														File:   "bare_mean_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   51,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   51,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   51,
												},
												File:   "bare_mean_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   51,
													},
													File:   "bare_mean_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   51,
													},
													File:   "bare_mean_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   51,
										},
										File:   "bare_mean_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   51,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   51,
												},
												File:   "bare_mean_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   51,
													},
													File:   "bare_mean_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   51,
														},
														File:   "bare_mean_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   51,
														},
														File:   "bare_mean_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   51,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   51,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   51,
												},
												File:   "bare_mean_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   51,
													},
													File:   "bare_mean_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   51,
													},
													File:   "bare_mean_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   51,
										},
										File:   "bare_mean_eval_test.flux",
										Source: "fn: bare_mean_fn",
										Start: ast.Position{
											Column: 83,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   51,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   51,
											},
											File:   "bare_mean_eval_test.flux",
											Source: "bare_mean_fn",
											Start: ast.Position{
												Column: 87,
												Line:   51,
											},
										},
									},
									Name: "bare_mean_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   51,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "test bare_mean_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_mean_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_mean_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_mean_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 101,
					Line:   49,
				},
				File:   "bare_mean_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n\"\n\nbare_mean_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()\n\ntest bare_mean_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "bare_mean_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "bare_mean_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "bare_mean_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "bare_mean_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "bare_mean_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "bare_mean_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "bare_mean_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "bare_mean_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "bare_mean_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,3.00\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,2.00\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,3.00\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,4.00\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,3.00\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,4.00\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,5.00\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,4.00\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,5.00\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "bare_mean_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   34,
						},
						File:   "bare_mean_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "bare_mean_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   34,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,2.5\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,3.5\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,4.5\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   46,
					},
					File:   "bare_mean_push_test.flux",
					Source: "bare_mean_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   44,
						},
						File:   "bare_mean_push_test.flux",
						Source: "bare_mean_fn",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "bare_mean_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   46,
						},
						File:   "bare_mean_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()",
						Start: ast.Position{
							Column: 16,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   44,
									},
									File:   "bare_mean_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   44,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   45,
								},
								File:   "bare_mean_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 31,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   45,
										},
										File:   "bare_mean_push_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   45,
											},
											File:   "bare_mean_push_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   45,
												},
												File:   "bare_mean_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   45,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   45,
												},
												File:   "bare_mean_push_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   45,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   45,
									},
									File:   "bare_mean_push_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   45,
										},
										File:   "bare_mean_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   45,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   46,
							},
							File:   "bare_mean_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> mean()",
							Start: ast.Position{
								Column: 31,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   46,
								},
								File:   "bare_mean_push_test.flux",
								Source: "mean()",
								Start: ast.Position{
									Column: 8,
									Line:   46,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   46,
									},
									File:   "bare_mean_push_test.flux",
									Source: "mean",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Name: "mean",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   44,
							},
							File:   "bare_mean_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   44,
								},
								File:   "bare_mean_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   44,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   44,
							},
							File:   "bare_mean_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   49,
						},
						File:   "bare_mean_push_test.flux",
						Source: "bare_mean_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   48,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   48,
							},
							File:   "bare_mean_push_test.flux",
							Source: "bare_mean_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   48,
							},
						},
					},
					Name: "bare_mean_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   49,
							},
							File:   "bare_mean_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
							Start: ast.Position{
								Column: 27,
								Line:   48,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   49,
								},
								File:   "bare_mean_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   49,
									},
									File:   "bare_mean_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   49,
										},
										File:   "bare_mean_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   49,
											},
											File:   "bare_mean_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   49,
												},
												File:   "bare_mean_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   49,
													},
													File:   "bare_mean_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   49,
														},
														File:   "bare_mean_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   49,
														},
														File:   "bare_mean_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   49,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   49,
											},
											File:   "bare_mean_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   49,
												},
												File:   "bare_mean_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   49,
													},
													File:   "bare_mean_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   49,
													},
													File:   "bare_mean_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   49,
										},
										File:   "bare_mean_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   49,
											},
											File:   "bare_mean_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   49,
												},
												File:   "bare_mean_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   49,
													},
													File:   "bare_mean_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   49,
														},
														File:   "bare_mean_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   49,
														},
														File:   "bare_mean_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   49,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   49,
											},
											File:   "bare_mean_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   49,
												},
												File:   "bare_mean_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   49,
													},
													File:   "bare_mean_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   49,
													},
													File:   "bare_mean_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   49,
										},
										File:   "bare_mean_push_test.flux",
										Source: "fn: bare_mean_fn",
										Start: ast.Position{
											Column: 83,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   49,
											},
											File:   "bare_mean_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   49,
											},
											File:   "bare_mean_push_test.flux",
											Source: "bare_mean_fn",
											Start: ast.Position{
												Column: 87,
												Line:   49,
											},
										},
									},
									Name: "bare_mean_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 101,
						Line:   49,
					},
					File:   "bare_mean_push_test.flux",
					Source: "test bare_mean_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_mean_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_mean_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_mean_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_mean_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_mean_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_mean_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   51,
				},
				File:   "bare_min_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption now = () => (2030-01-01T00:00:00Z)\noption planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n\"\n\nbare_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()\n\ntest bare_min_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "bare_min_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "bare_min_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "bare_min_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "bare_min_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "bare_min_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "bare_min_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   7,
						},
						File:   "bare_min_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   7,
							},
							File:   "bare_min_eval_test.flux",
							Source: "[\"PushDownBareAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   7,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   7,
								},
								File:   "bare_min_eval_test.flux",
								Source: "\"PushDownBareAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   7,
								},
							},
						},
						Value: "PushDownBareAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   7,
							},
							File:   "bare_min_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   7,
								},
								File:   "bare_min_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   7,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   7,
								},
								File:   "bare_min_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   7,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   7,
					},
					File:   "bare_min_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "bare_min_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   9,
						},
						File:   "bare_min_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "bare_min_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "bare_min_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "bare_min_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "bare_min_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   48,
					},
					File:   "bare_min_eval_test.flux",
					Source: "bare_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   46,
						},
						File:   "bare_min_eval_test.flux",
						Source: "bare_min_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "bare_min_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "bare_min_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()",
						Start: ast.Position{
							Column: 15,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   46,
									},
									File:   "bare_min_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 30,
										Line:   46,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   47,
								},
								File:   "bare_min_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   47,
										},
										File:   "bare_min_eval_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   47,
											},
											File:   "bare_min_eval_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "bare_min_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "bare_min_eval_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   47,
									},
									File:   "bare_min_eval_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "bare_min_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   48,
							},
							File:   "bare_min_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()",
							Start: ast.Position{
								Column: 30,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   48,
								},
								File:   "bare_min_eval_test.flux",
								Source: "min()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   48,
									},
									File:   "bare_min_eval_test.flux",
									Source: "min",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "min",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "bare_min_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   46,
								},
								File:   "bare_min_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "bare_min_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   51,
						},
						File:   "bare_min_eval_test.flux",
						Source: "bare_min_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   50,
							},
							File:   "bare_min_eval_test.flux",
							Source: "bare_min_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "bare_min_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   51,
							},
							File:   "bare_min_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   51,
								},
								File:   "bare_min_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   51,
									},
									File:   "bare_min_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   51,
										},
										File:   "bare_min_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   51,
											},
											File:   "bare_min_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   51,
												},
												File:   "bare_min_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   51,
													},
													File:   "bare_min_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   51,
														},
														File:   "bare_min_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   51,
														},
														File:   "bare_min_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   51,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   51,
											},
											File:   "bare_min_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   51,
												},
												File:   "bare_min_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   51,
													},
													File:   "bare_min_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   51,
													},
													File:   "bare_min_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   51,
										},
										File:   "bare_min_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   51,
											},
											File:   "bare_min_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   51,
												},
												File:   "bare_min_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   51,
													},
													File:   "bare_min_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   51,
														},
														File:   "bare_min_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   51,
														},
														File:   "bare_min_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   51,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   51,
											},
											File:   "bare_min_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   51,
												},
												File:   "bare_min_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   51,
													},
													File:   "bare_min_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   51,
													},
													File:   "bare_min_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   51,
										},
										File:   "bare_min_eval_test.flux",
										Source: "fn: bare_min_fn",
										Start: ast.Position{
											Column: 83,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   51,
											},
											File:   "bare_min_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   51,
											},
											File:   "bare_min_eval_test.flux",
											Source: "bare_min_fn",
											Start: ast.Position{
												Column: 87,
												Line:   51,
											},
										},
									},
									Name: "bare_min_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   51,
					},
					File:   "bare_min_eval_test.flux",
					Source: "test bare_min_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_min_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_min_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "bare_min_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "bare_min_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_min_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_min_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_min_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   49,
				},
				File:   "bare_min_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n\"\n\nbare_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()\n\ntest bare_min_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "bare_min_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "bare_min_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "bare_min_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "bare_min_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "bare_min_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "bare_min_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "bare_min_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "bare_min_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "bare_min_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "bare_min_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   34,
						},
						File:   "bare_min_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "bare_min_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   34,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,false,true,true,true,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   46,
					},
					File:   "bare_min_push_test.flux",
					Source: "bare_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   44,
						},
						File:   "bare_min_push_test.flux",
						Source: "bare_min_fn",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "bare_min_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "bare_min_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()",
						Start: ast.Position{
							Column: 15,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   44,
									},
									File:   "bare_min_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 30,
										Line:   44,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   45,
								},
								File:   "bare_min_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   45,
										},
										File:   "bare_min_push_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   45,
											},
											File:   "bare_min_push_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   45,
												},
												File:   "bare_min_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   45,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   45,
												},
												File:   "bare_min_push_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   45,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   45,
									},
									File:   "bare_min_push_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   45,
										},
										File:   "bare_min_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   45,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   46,
							},
							File:   "bare_min_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> min()",
							Start: ast.Position{
								Column: 30,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   46,
								},
								File:   "bare_min_push_test.flux",
								Source: "min()",
								Start: ast.Position{
									Column: 8,
									Line:   46,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   46,
									},
									File:   "bare_min_push_test.flux",
									Source: "min",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Name: "min",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   44,
							},
							File:   "bare_min_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   44,
								},
								File:   "bare_min_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   44,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   44,
							},
							File:   "bare_min_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   49,
						},
						File:   "bare_min_push_test.flux",
						Source: "bare_min_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   48,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   48,
							},
							File:   "bare_min_push_test.flux",
							Source: "bare_min_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   48,
							},
						},
					},
					Name: "bare_min_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   49,
							},
							File:   "bare_min_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   48,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   49,
								},
								File:   "bare_min_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   49,
									},
									File:   "bare_min_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   49,
										},
										File:   "bare_min_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   49,
											},
											File:   "bare_min_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   49,
												},
												File:   "bare_min_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   49,
													},
													File:   "bare_min_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   49,
														},
														File:   "bare_min_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   49,
														},
														File:   "bare_min_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   49,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   49,
											},
											File:   "bare_min_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   49,
												},
												File:   "bare_min_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   49,
													},
													File:   "bare_min_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   49,
													},
													File:   "bare_min_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   49,
										},
										File:   "bare_min_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   49,
											},
											File:   "bare_min_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   49,
												},
												File:   "bare_min_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   49,
													},
													File:   "bare_min_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   49,
														},
														File:   "bare_min_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   49,
														},
														File:   "bare_min_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   49,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   49,
											},
											File:   "bare_min_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   49,
												},
												File:   "bare_min_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   49,
													},
													File:   "bare_min_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   49,
													},
													File:   "bare_min_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   49,
										},
										File:   "bare_min_push_test.flux",
										Source: "fn: bare_min_fn",
										Start: ast.Position{
											Column: 83,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   49,
											},
											File:   "bare_min_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   49,
											},
											File:   "bare_min_push_test.flux",
											Source: "bare_min_fn",
											Start: ast.Position{
												Column: 87,
												Line:   49,
											},
										},
									},
									Name: "bare_min_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   49,
					},
					File:   "bare_min_push_test.flux",
					Source: "test bare_min_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_min_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_min_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_min_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_min_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_min_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_min_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   51,
				},
				File:   "bare_sum_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption now = () => (2030-01-01T00:00:00Z)\noption planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n\"\n\nbare_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()\n\ntest bare_sum_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "bare_sum_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   7,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   7,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "[\"PushDownBareAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   7,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   7,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "\"PushDownBareAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   7,
								},
							},
						},
						Value: "PushDownBareAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   7,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   7,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   7,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   7,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   7,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   7,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownBareAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   9,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   48,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "bare_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   46,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "bare_sum_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "bare_sum_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()",
						Start: ast.Position{
							Column: 15,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   46,
									},
									File:   "bare_sum_eval_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 30,
										Line:   46,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   47,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   47,
										},
										File:   "bare_sum_eval_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   47,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   47,
												},
												File:   "bare_sum_eval_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "bare_sum_eval_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   47,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   47,
									},
									File:   "bare_sum_eval_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "bare_sum_eval_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   48,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()",
							Start: ast.Position{
								Column: 30,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   48,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "sum()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   48,
									},
									File:   "bare_sum_eval_test.flux",
									Source: "sum",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "sum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   46,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   46,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   51,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "bare_sum_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   50,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "bare_sum_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "bare_sum_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   51,
							},
							File:   "bare_sum_eval_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   51,
								},
								File:   "bare_sum_eval_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   51,
									},
									File:   "bare_sum_eval_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   51,
										},
										File:   "bare_sum_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   51,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   51,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   51,
												},
												File:   "bare_sum_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   51,
													},
													File:   "bare_sum_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   51,
														},
														File:   "bare_sum_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   51,
														},
														File:   "bare_sum_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   51,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   51,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   51,
												},
												File:   "bare_sum_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   51,
													},
													File:   "bare_sum_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   51,
													},
													File:   "bare_sum_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   51,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   51,
										},
										File:   "bare_sum_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   51,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   51,
												},
												File:   "bare_sum_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   51,
													},
													File:   "bare_sum_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   51,
														},
														File:   "bare_sum_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   51,
														},
														File:   "bare_sum_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   51,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   51,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   51,
												},
												File:   "bare_sum_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   51,
													},
													File:   "bare_sum_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   51,
													},
													File:   "bare_sum_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   51,
										},
										File:   "bare_sum_eval_test.flux",
										Source: "fn: bare_sum_fn",
										Start: ast.Position{
											Column: 83,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   51,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   51,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   51,
											},
											File:   "bare_sum_eval_test.flux",
											Source: "bare_sum_fn",
											Start: ast.Position{
												Column: 87,
												Line:   51,
											},
										},
									},
									Name: "bare_sum_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   51,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "test bare_sum_evaluate = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_sum_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_sum_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_sum_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   49,
				},
				File:   "bare_sum_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n\"\n\nbare_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()\n\ntest bare_sum_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "bare_sum_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "bare_sum_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "bare_sum_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "bare_sum_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "bare_sum_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "bare_sum_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "bare_sum_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "bare_sum_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "bare_sum_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,host.local,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,host.local,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,host.local,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,host.local,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,host.local,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,host.local,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,host.local,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,host.local,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,host.local,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,host.local,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,host.local,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,host.local,load5,1.91\n,,2,2018-05-22T19:53:46Z,system,host.local,load5,1.92\n,,2,2018-05-22T19:53:56Z,system,host.local,load5,1.89\n,,2,2018-05-22T19:54:16Z,system,host.local,load5,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "bare_sum_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   34,
						},
						File:   "bare_sum_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "bare_sum_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   34,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_measurement,host,_field,_value\n,,0,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load1,10.7\n,,1,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load3,11.83\n,,2,2018-05-01T00:00:00Z,2030-01-01T00:00:00Z,system,host.local,load5,11.52\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   46,
					},
					File:   "bare_sum_push_test.flux",
					Source: "bare_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   44,
						},
						File:   "bare_sum_push_test.flux",
						Source: "bare_sum_fn",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "bare_sum_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "bare_sum_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()",
						Start: ast.Position{
							Column: 15,
							Line:   44,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   44,
									},
									File:   "bare_sum_push_test.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 30,
										Line:   44,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   45,
								},
								File:   "bare_sum_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   44,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   45,
										},
										File:   "bare_sum_push_test.flux",
										Source: "start: 2018-05-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   45,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   45,
											},
											File:   "bare_sum_push_test.flux",
											Source: "start: 2018-05-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   45,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   45,
												},
												File:   "bare_sum_push_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   45,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   45,
												},
												File:   "bare_sum_push_test.flux",
												Source: "2018-05-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   45,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   45,
									},
									File:   "bare_sum_push_test.flux",
									Source: "range(start: 2018-05-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   45,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   45,
										},
										File:   "bare_sum_push_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   45,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   46,
							},
							File:   "bare_sum_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-01T00:00:00Z)\n    |> sum()",
							Start: ast.Position{
								Column: 30,
								Line:   44,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   46,
								},
								File:   "bare_sum_push_test.flux",
								Source: "sum()",
								Start: ast.Position{
									Column: 8,
									Line:   46,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   46,
									},
									File:   "bare_sum_push_test.flux",
									Source: "sum",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Name: "sum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   44,
							},
							File:   "bare_sum_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   44,
								},
								File:   "bare_sum_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   44,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   44,
							},
							File:   "bare_sum_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   44,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   49,
						},
						File:   "bare_sum_push_test.flux",
						Source: "bare_sum_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
						Start: ast.Position{
							Column: 6,
							Line:   48,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   48,
							},
							File:   "bare_sum_push_test.flux",
							Source: "bare_sum_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   48,
							},
						},
					},
					Name: "bare_sum_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   49,
							},
							File:   "bare_sum_push_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
							Start: ast.Position{
								Column: 26,
								Line:   48,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   49,
								},
								File:   "bare_sum_push_test.flux",
								Source: "({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   49,
									},
									File:   "bare_sum_push_test.flux",
									Source: "{input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn}",
									Start: ast.Position{
										Column: 6,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   49,
										},
										File:   "bare_sum_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 7,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   49,
											},
											File:   "bare_sum_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   49,
												},
												File:   "bare_sum_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 34,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   49,
													},
													File:   "bare_sum_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 34,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   49,
														},
														File:   "bare_sum_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   49,
														},
														File:   "bare_sum_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 39,
															Line:   49,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   49,
											},
											File:   "bare_sum_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   49,
												},
												File:   "bare_sum_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   49,
													},
													File:   "bare_sum_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   49,
													},
													File:   "bare_sum_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   49,
										},
										File:   "bare_sum_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 47,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   49,
											},
											File:   "bare_sum_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 47,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   49,
												},
												File:   "bare_sum_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 69,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   49,
													},
													File:   "bare_sum_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 69,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   49,
														},
														File:   "bare_sum_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 69,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 80,
															Line:   49,
														},
														File:   "bare_sum_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 74,
															Line:   49,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   49,
											},
											File:   "bare_sum_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 53,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   49,
												},
												File:   "bare_sum_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 53,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   49,
													},
													File:   "bare_sum_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 53,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   49,
													},
													File:   "bare_sum_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 61,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   49,
										},
										File:   "bare_sum_push_test.flux",
										Source: "fn: bare_sum_fn",
										Start: ast.Position{
											Column: 83,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   49,
											},
											File:   "bare_sum_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 83,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   49,
											},
											File:   "bare_sum_push_test.flux",
											Source: "bare_sum_fn",
											Start: ast.Position{
												Column: 87,
												Line:   49,
											},
										},
									},
									Name: "bare_sum_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   49,
					},
					File:   "bare_sum_push_test.flux",
					Source: "test bare_sum_pushdown = () =>\n    ({input: testing.loadStorage(csv: input), want: testing.loadMem(csv: output), fn: bare_sum_fn})",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "bare_sum_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "bare_sum_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "bare_sum_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "bare_sum_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "bare_sum_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   68,
				},
				File:   "group_agg_uneven_keys_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,host,other,_field,_value\n,,2,2018-05-22T19:53:26Z,system,hostC,o1,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,o1,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,o1,load5,1.91\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,false,false,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,host,other,_field,_value\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,o1,load5,1.95\n\"\n\ngroup_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])\n\ntest group_max_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   4,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   8,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   8,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   8,
								},
								File:   "group_agg_uneven_keys_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   8,
									},
									File:   "group_agg_uneven_keys_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   8,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   8,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   40,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,host,other,_field,_value\n,,2,2018-05-22T19:53:26Z,system,hostC,o1,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,o1,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,o1,load5,1.91\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   10,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   40,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,host,other,_field,_value\n,,2,2018-05-22T19:53:26Z,system,hostC,o1,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,o1,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,o1,load5,1.91\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,double\n#group,false,false,false,true,true,true,true,false\n#default,_result,,,,,,,\n,result,table,_time,_measurement,host,other,_field,_value\n,,2,2018-05-22T19:53:26Z,system,hostC,o1,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,o1,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,o1,load5,1.91\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   55,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,false,false,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,host,other,_field,_value\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,o1,load5,1.95\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   42,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   42,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   55,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,false,false,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,host,other,_field,_value\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,o1,load5,1.95\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   42,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double\n#group,false,false,true,true,true,false,false,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,host,other,_field,_value\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,o1,load5,1.95\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 48,
						Line:   61,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "group_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   57,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "group_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   57,
						},
					},
				},
				Name: "group_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   61,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
						Start: ast.Position{
							Column: 16,
							Line:   57,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   57,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 31,
												Line:   57,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   58,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 31,
											Line:   57,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   58,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   58,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   58,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "start: 2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   58,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   58,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   58,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   58,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "2018-05-22T19:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   58,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   58,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "range(start: 2018-05-22T19:00:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   58,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   58,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   58,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   59,
									},
									File:   "group_agg_uneven_keys_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])",
									Start: ast.Position{
										Column: 31,
										Line:   57,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   59,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "columns:[\"_start\", \"_stop\",\"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   59,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   59,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "columns:[\"_start\", \"_stop\",\"host\"]",
												Start: ast.Position{
													Column: 14,
													Line:   59,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   59,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   59,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   59,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "[\"_start\", \"_stop\",\"host\"]",
													Start: ast.Position{
														Column: 22,
														Line:   59,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   59,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   59,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   59,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   59,
														},
													},
												},
												Value: "_stop",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   59,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 41,
															Line:   59,
														},
													},
												},
												Value: "host",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   59,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "group(columns:[\"_start\", \"_stop\",\"host\"])",
										Start: ast.Position{
											Column: 8,
											Line:   59,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   59,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 8,
												Line:   59,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   60,
								},
								File:   "group_agg_uneven_keys_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()",
								Start: ast.Position{
									Column: 31,
									Line:   57,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   60,
									},
									File:   "group_agg_uneven_keys_test.flux",
									Source: "max()",
									Start: ast.Position{
										Column: 8,
										Line:   60,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   60,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "max",
										Start: ast.Position{
											Column: 8,
											Line:   60,
										},
									},
								},
								Name: "max",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   61,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
							Start: ast.Position{
								Column: 31,
								Line:   57,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   61,
									},
									File:   "group_agg_uneven_keys_test.flux",
									Source: "columns: [\"_measurement\", \"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   61,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   61,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "columns: [\"_measurement\", \"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   61,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   61,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   61,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "[\"_measurement\", \"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   61,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   61,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 23,
													Line:   61,
												},
											},
										},
										Value: "_measurement",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   61,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   61,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   61,
								},
								File:   "group_agg_uneven_keys_test.flux",
								Source: "drop(columns: [\"_measurement\", \"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   61,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   61,
									},
									File:   "group_agg_uneven_keys_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   61,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   57,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   57,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   57,
								},
								File:   "group_agg_uneven_keys_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   57,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   57,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   57,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   68,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "group_max_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   63,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   63,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "group_max_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   63,
							},
						},
					},
					Name: "group_max_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   68,
							},
							File:   "group_agg_uneven_keys_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
							Start: ast.Position{
								Column: 27,
								Line:   63,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   68,
								},
								File:   "group_agg_uneven_keys_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   64,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   68,
									},
									File:   "group_agg_uneven_keys_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   64,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   65,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   65,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   65,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   65,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   65,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   65,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   65,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   65,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   65,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   65,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   65,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   65,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   65,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   65,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   65,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   65,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   65,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   65,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   65,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   65,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   66,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   66,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   66,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   66,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   66,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   66,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   66,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   66,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   66,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   66,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   66,
														},
														File:   "group_agg_uneven_keys_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   66,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   66,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   66,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   66,
												},
												File:   "group_agg_uneven_keys_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   66,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   66,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   66,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   66,
													},
													File:   "group_agg_uneven_keys_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   66,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   67,
										},
										File:   "group_agg_uneven_keys_test.flux",
										Source: "fn: group_max_fn",
										Start: ast.Position{
											Column: 3,
											Line:   67,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   67,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   67,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   67,
											},
											File:   "group_agg_uneven_keys_test.flux",
											Source: "group_max_fn",
											Start: ast.Position{
												Column: 7,
												Line:   67,
											},
										},
									},
									Name: "group_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   68,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "test group_max_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_agg_uneven_keys_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// The goal of this test is to send an uneven tag key list in input rows that\n"}, ast.Comment{Text: "// are grouped together and selected.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   4,
					},
					File:   "group_agg_uneven_keys_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   4,
						},
						File:   "group_agg_uneven_keys_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   4,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   58,
				},
				File:   "group_count_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n\"\n\ngroup_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()\n\ntest group_count_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   6,
						},
						File:   "group_count_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   6,
							},
							File:   "group_count_eval_test.flux",
							Source: "[\"PushDownGroupAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   6,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   6,
								},
								File:   "group_count_eval_test.flux",
								Source: "\"PushDownGroupAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   6,
								},
							},
						},
						Value: "PushDownGroupAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   6,
							},
							File:   "group_count_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   6,
								},
								File:   "group_count_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   6,
								},
								File:   "group_count_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   6,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   6,
					},
					File:   "group_count_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   8,
						},
						File:   "group_count_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "group_count_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   8,
							},
							File:   "group_count_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   8,
								},
								File:   "group_count_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   8,
									},
									File:   "group_count_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   8,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   8,
					},
					File:   "group_count_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "group_count_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   10,
						},
						File:   "group_count_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "group_count_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "group_count_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   38,
						},
						File:   "group_count_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "group_count_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   38,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   51,
					},
					File:   "group_count_eval_test.flux",
					Source: "group_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   48,
						},
						File:   "group_count_eval_test.flux",
						Source: "group_count_fn",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "group_count_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   51,
						},
						File:   "group_count_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()",
						Start: ast.Position{
							Column: 18,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   48,
										},
										File:   "group_count_eval_test.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 33,
											Line:   48,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   49,
									},
									File:   "group_count_eval_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
									Start: ast.Position{
										Column: 33,
										Line:   48,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   49,
											},
											File:   "group_count_eval_test.flux",
											Source: "start: 2018-05-22T19:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "group_count_eval_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   49,
													},
													File:   "group_count_eval_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   49,
													},
													File:   "group_count_eval_test.flux",
													Source: "2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   49,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   49,
										},
										File:   "group_count_eval_test.flux",
										Source: "range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   49,
											},
											File:   "group_count_eval_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   50,
								},
								File:   "group_count_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])",
								Start: ast.Position{
									Column: 33,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   50,
										},
										File:   "group_count_eval_test.flux",
										Source: "columns:[\"_start\", \"_stop\", \"host\"]",
										Start: ast.Position{
											Column: 14,
											Line:   50,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   50,
											},
											File:   "group_count_eval_test.flux",
											Source: "columns:[\"_start\", \"_stop\", \"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   50,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   50,
												},
												File:   "group_count_eval_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   50,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   50,
												},
												File:   "group_count_eval_test.flux",
												Source: "[\"_start\", \"_stop\", \"host\"]",
												Start: ast.Position{
													Column: 22,
													Line:   50,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   50,
													},
													File:   "group_count_eval_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   50,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   50,
													},
													File:   "group_count_eval_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   50,
													},
												},
											},
											Value: "_stop",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   50,
													},
													File:   "group_count_eval_test.flux",
													Source: "\"host\"",
													Start: ast.Position{
														Column: 42,
														Line:   50,
													},
												},
											},
											Value: "host",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   50,
									},
									File:   "group_count_eval_test.flux",
									Source: "group(columns:[\"_start\", \"_stop\", \"host\"])",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   50,
										},
										File:   "group_count_eval_test.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   50,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   51,
							},
							File:   "group_count_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()",
							Start: ast.Position{
								Column: 33,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   51,
								},
								File:   "group_count_eval_test.flux",
								Source: "count()",
								Start: ast.Position{
									Column: 8,
									Line:   51,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   51,
									},
									File:   "group_count_eval_test.flux",
									Source: "count",
									Start: ast.Position{
										Column: 8,
										Line:   51,
									},
								},
							},
							Name: "count",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   48,
							},
							File:   "group_count_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 19,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   48,
								},
								File:   "group_count_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 19,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   48,
							},
							File:   "group_count_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   48,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   58,
						},
						File:   "group_count_eval_test.flux",
						Source: "group_count_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   53,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   53,
							},
							File:   "group_count_eval_test.flux",
							Source: "group_count_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   53,
							},
						},
					},
					Name: "group_count_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   58,
							},
							File:   "group_count_eval_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
							Start: ast.Position{
								Column: 29,
								Line:   53,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   58,
								},
								File:   "group_count_eval_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   54,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   58,
									},
									File:   "group_count_eval_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   54,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   55,
										},
										File:   "group_count_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   55,
											},
											File:   "group_count_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   55,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   55,
												},
												File:   "group_count_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   55,
													},
													File:   "group_count_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   55,
														},
														File:   "group_count_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   55,
														},
														File:   "group_count_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   55,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   55,
											},
											File:   "group_count_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   55,
												},
												File:   "group_count_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   55,
													},
													File:   "group_count_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   55,
													},
													File:   "group_count_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   55,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   56,
										},
										File:   "group_count_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   56,
											},
											File:   "group_count_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   56,
												},
												File:   "group_count_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   56,
													},
													File:   "group_count_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   56,
														},
														File:   "group_count_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   56,
														},
														File:   "group_count_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   56,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   56,
											},
											File:   "group_count_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   56,
												},
												File:   "group_count_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   56,
													},
													File:   "group_count_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   56,
													},
													File:   "group_count_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   56,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   57,
										},
										File:   "group_count_eval_test.flux",
										Source: "fn: group_count_fn",
										Start: ast.Position{
											Column: 3,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   57,
											},
											File:   "group_count_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   57,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   57,
											},
											File:   "group_count_eval_test.flux",
											Source: "group_count_fn",
											Start: ast.Position{
												Column: 7,
												Line:   57,
											},
										},
									},
									Name: "group_count_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   58,
					},
					File:   "group_count_eval_test.flux",
					Source: "test group_count_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_count_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_count_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "group_count_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "group_count_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_count_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_count_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_count_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   55,
				},
				File:   "group_count_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n\"\n\ngroup_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()\n\ntest group_count_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "group_count_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "group_count_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "group_count_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "group_count_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "group_count_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "group_count_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "group_count_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "group_count_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "group_count_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   43,
					},
					File:   "group_count_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   35,
						},
						File:   "group_count_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   43,
						},
						File:   "group_count_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   35,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,long\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,6\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,6\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   48,
					},
					File:   "group_count_push_test.flux",
					Source: "group_count_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   45,
						},
						File:   "group_count_push_test.flux",
						Source: "group_count_fn",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "group_count_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   48,
						},
						File:   "group_count_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()",
						Start: ast.Position{
							Column: 18,
							Line:   45,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   45,
										},
										File:   "group_count_push_test.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 33,
											Line:   45,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   46,
									},
									File:   "group_count_push_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
									Start: ast.Position{
										Column: 33,
										Line:   45,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   46,
											},
											File:   "group_count_push_test.flux",
											Source: "start: 2018-05-22T19:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   46,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   46,
												},
												File:   "group_count_push_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   46,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   46,
													},
													File:   "group_count_push_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   46,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   46,
													},
													File:   "group_count_push_test.flux",
													Source: "2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   46,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   46,
										},
										File:   "group_count_push_test.flux",
										Source: "range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   46,
											},
											File:   "group_count_push_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   46,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   47,
								},
								File:   "group_count_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])",
								Start: ast.Position{
									Column: 33,
									Line:   45,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   47,
										},
										File:   "group_count_push_test.flux",
										Source: "columns:[\"_start\", \"_stop\", \"host\"]",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   47,
											},
											File:   "group_count_push_test.flux",
											Source: "columns:[\"_start\", \"_stop\", \"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   47,
												},
												File:   "group_count_push_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   47,
												},
												File:   "group_count_push_test.flux",
												Source: "[\"_start\", \"_stop\", \"host\"]",
												Start: ast.Position{
													Column: 22,
													Line:   47,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   47,
													},
													File:   "group_count_push_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   47,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   47,
													},
													File:   "group_count_push_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   47,
													},
												},
											},
											Value: "_stop",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   47,
													},
													File:   "group_count_push_test.flux",
													Source: "\"host\"",
													Start: ast.Position{
														Column: 42,
														Line:   47,
													},
												},
											},
											Value: "host",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   47,
									},
									File:   "group_count_push_test.flux",
									Source: "group(columns:[\"_start\", \"_stop\", \"host\"])",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "group_count_push_test.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   48,
							},
							File:   "group_count_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> count()",
							Start: ast.Position{
								Column: 33,
								Line:   45,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   48,
								},
								File:   "group_count_push_test.flux",
								Source: "count()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   48,
									},
									File:   "group_count_push_test.flux",
									Source: "count",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "count",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   45,
							},
							File:   "group_count_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 19,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   45,
								},
								File:   "group_count_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 19,
									Line:   45,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   45,
							},
							File:   "group_count_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   55,
						},
						File:   "group_count_push_test.flux",
						Source: "group_count_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   50,
							},
							File:   "group_count_push_test.flux",
							Source: "group_count_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "group_count_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   55,
							},
							File:   "group_count_push_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
							Start: ast.Position{
								Column: 29,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   55,
								},
								File:   "group_count_push_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   55,
									},
									File:   "group_count_push_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   52,
										},
										File:   "group_count_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   52,
											},
											File:   "group_count_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   52,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   52,
												},
												File:   "group_count_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   52,
													},
													File:   "group_count_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   52,
														},
														File:   "group_count_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   52,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   52,
														},
														File:   "group_count_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   52,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "group_count_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   52,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   52,
												},
												File:   "group_count_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   52,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   52,
													},
													File:   "group_count_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   52,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   52,
													},
													File:   "group_count_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   52,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   53,
										},
										File:   "group_count_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   53,
											},
											File:   "group_count_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   53,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   53,
												},
												File:   "group_count_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   53,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   53,
													},
													File:   "group_count_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   53,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   53,
														},
														File:   "group_count_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   53,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   53,
														},
														File:   "group_count_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   53,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   53,
											},
											File:   "group_count_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   53,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   53,
												},
												File:   "group_count_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   53,
													},
													File:   "group_count_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   53,
													},
													File:   "group_count_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   53,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   54,
										},
										File:   "group_count_push_test.flux",
										Source: "fn: group_count_fn",
										Start: ast.Position{
											Column: 3,
											Line:   54,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   54,
											},
											File:   "group_count_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   54,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   54,
											},
											File:   "group_count_push_test.flux",
											Source: "group_count_fn",
											Start: ast.Position{
												Column: 7,
												Line:   54,
											},
										},
									},
									Name: "group_count_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   55,
					},
					File:   "group_count_push_test.flux",
					Source: "test group_count_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_count_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_count_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_count_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_count_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_count_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_count_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   59,
				},
				File:   "group_max_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n\"\n\ngroup_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])\n\ntest group_max_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   6,
						},
						File:   "group_max_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   6,
							},
							File:   "group_max_eval_test.flux",
							Source: "[\"PushDownGroupAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   6,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   6,
								},
								File:   "group_max_eval_test.flux",
								Source: "\"PushDownGroupAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   6,
								},
							},
						},
						Value: "PushDownGroupAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   6,
							},
							File:   "group_max_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   6,
								},
								File:   "group_max_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   6,
								},
								File:   "group_max_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   6,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   6,
					},
					File:   "group_max_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   8,
						},
						File:   "group_max_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "group_max_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   8,
							},
							File:   "group_max_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   8,
								},
								File:   "group_max_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   8,
									},
									File:   "group_max_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   8,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   8,
					},
					File:   "group_max_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "group_max_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   10,
						},
						File:   "group_max_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "group_max_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "group_max_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   38,
						},
						File:   "group_max_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "group_max_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   38,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 48,
						Line:   52,
					},
					File:   "group_max_eval_test.flux",
					Source: "group_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "group_max_eval_test.flux",
						Source: "group_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "group_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   52,
						},
						File:   "group_max_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
						Start: ast.Position{
							Column: 16,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   48,
											},
											File:   "group_max_eval_test.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 31,
												Line:   48,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   49,
										},
										File:   "group_max_eval_test.flux",
										Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 31,
											Line:   48,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "group_max_eval_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   49,
													},
													File:   "group_max_eval_test.flux",
													Source: "start: 2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   49,
														},
														File:   "group_max_eval_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   49,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   49,
														},
														File:   "group_max_eval_test.flux",
														Source: "2018-05-22T19:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   49,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   49,
											},
											File:   "group_max_eval_test.flux",
											Source: "range(start: 2018-05-22T19:00:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   49,
												},
												File:   "group_max_eval_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   50,
									},
									File:   "group_max_eval_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])",
									Start: ast.Position{
										Column: 31,
										Line:   48,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   50,
											},
											File:   "group_max_eval_test.flux",
											Source: "columns:[\"_start\", \"_stop\",\"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   50,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   50,
												},
												File:   "group_max_eval_test.flux",
												Source: "columns:[\"_start\", \"_stop\",\"host\"]",
												Start: ast.Position{
													Column: 14,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   50,
													},
													File:   "group_max_eval_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   50,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   50,
													},
													File:   "group_max_eval_test.flux",
													Source: "[\"_start\", \"_stop\",\"host\"]",
													Start: ast.Position{
														Column: 22,
														Line:   50,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   50,
														},
														File:   "group_max_eval_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   50,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   50,
														},
														File:   "group_max_eval_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   50,
														},
													},
												},
												Value: "_stop",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   50,
														},
														File:   "group_max_eval_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 41,
															Line:   50,
														},
													},
												},
												Value: "host",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   50,
										},
										File:   "group_max_eval_test.flux",
										Source: "group(columns:[\"_start\", \"_stop\",\"host\"])",
										Start: ast.Position{
											Column: 8,
											Line:   50,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   50,
											},
											File:   "group_max_eval_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 8,
												Line:   50,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   51,
								},
								File:   "group_max_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()",
								Start: ast.Position{
									Column: 31,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   51,
									},
									File:   "group_max_eval_test.flux",
									Source: "max()",
									Start: ast.Position{
										Column: 8,
										Line:   51,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   51,
										},
										File:   "group_max_eval_test.flux",
										Source: "max",
										Start: ast.Position{
											Column: 8,
											Line:   51,
										},
									},
								},
								Name: "max",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   52,
							},
							File:   "group_max_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
							Start: ast.Position{
								Column: 31,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   52,
									},
									File:   "group_max_eval_test.flux",
									Source: "columns: [\"_measurement\", \"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   52,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   52,
										},
										File:   "group_max_eval_test.flux",
										Source: "columns: [\"_measurement\", \"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   52,
											},
											File:   "group_max_eval_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   52,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   52,
											},
											File:   "group_max_eval_test.flux",
											Source: "[\"_measurement\", \"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   52,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   52,
												},
												File:   "group_max_eval_test.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 23,
													Line:   52,
												},
											},
										},
										Value: "_measurement",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   52,
												},
												File:   "group_max_eval_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   52,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   52,
								},
								File:   "group_max_eval_test.flux",
								Source: "drop(columns: [\"_measurement\", \"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   52,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   52,
									},
									File:   "group_max_eval_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   48,
							},
							File:   "group_max_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   48,
								},
								File:   "group_max_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   48,
							},
							File:   "group_max_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   48,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   59,
						},
						File:   "group_max_eval_test.flux",
						Source: "group_max_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   54,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   54,
							},
							File:   "group_max_eval_test.flux",
							Source: "group_max_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   54,
							},
						},
					},
					Name: "group_max_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   59,
							},
							File:   "group_max_eval_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
							Start: ast.Position{
								Column: 27,
								Line:   54,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   59,
								},
								File:   "group_max_eval_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   55,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   59,
									},
									File:   "group_max_eval_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   56,
										},
										File:   "group_max_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   56,
											},
											File:   "group_max_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   56,
												},
												File:   "group_max_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   56,
													},
													File:   "group_max_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   56,
														},
														File:   "group_max_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   56,
														},
														File:   "group_max_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   56,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   56,
											},
											File:   "group_max_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   56,
												},
												File:   "group_max_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   56,
													},
													File:   "group_max_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   56,
													},
													File:   "group_max_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   56,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   57,
										},
										File:   "group_max_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   57,
											},
											File:   "group_max_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   57,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   57,
												},
												File:   "group_max_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   57,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   57,
													},
													File:   "group_max_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   57,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   57,
														},
														File:   "group_max_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   57,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   57,
														},
														File:   "group_max_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   57,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   57,
											},
											File:   "group_max_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   57,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   57,
												},
												File:   "group_max_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   57,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   57,
													},
													File:   "group_max_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   57,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   57,
													},
													File:   "group_max_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   57,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   58,
										},
										File:   "group_max_eval_test.flux",
										Source: "fn: group_max_fn",
										Start: ast.Position{
											Column: 3,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   58,
											},
											File:   "group_max_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   58,
											},
											File:   "group_max_eval_test.flux",
											Source: "group_max_fn",
											Start: ast.Position{
												Column: 7,
												Line:   58,
											},
										},
									},
									Name: "group_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   59,
					},
					File:   "group_max_eval_test.flux",
					Source: "test group_max_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_max_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_max_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "group_max_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "group_max_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_max_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_max_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_max_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   57,
				},
				File:   "group_max_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n\"\n\ngroup_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])\n\ntest group_max_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "group_max_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "group_max_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "group_max_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "group_max_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "group_max_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "group_max_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "group_max_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   8,
						},
						File:   "group_max_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "group_max_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "group_max_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "group_max_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "group_max_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.91\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.98\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load5,1.95\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 48,
						Line:   50,
					},
					File:   "group_max_push_test.flux",
					Source: "group_max_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "group_max_push_test.flux",
						Source: "group_max_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "group_max_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   50,
						},
						File:   "group_max_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
						Start: ast.Position{
							Column: 16,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   46,
											},
											File:   "group_max_push_test.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 31,
												Line:   46,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   47,
										},
										File:   "group_max_push_test.flux",
										Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 31,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "group_max_push_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   47,
													},
													File:   "group_max_push_test.flux",
													Source: "start: 2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   47,
														},
														File:   "group_max_push_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   47,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   47,
														},
														File:   "group_max_push_test.flux",
														Source: "2018-05-22T19:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   47,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   47,
											},
											File:   "group_max_push_test.flux",
											Source: "range(start: 2018-05-22T19:00:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   47,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   47,
												},
												File:   "group_max_push_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   47,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   48,
									},
									File:   "group_max_push_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])",
									Start: ast.Position{
										Column: 31,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   48,
											},
											File:   "group_max_push_test.flux",
											Source: "columns:[\"_start\", \"_stop\",\"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   48,
												},
												File:   "group_max_push_test.flux",
												Source: "columns:[\"_start\", \"_stop\",\"host\"]",
												Start: ast.Position{
													Column: 14,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   48,
													},
													File:   "group_max_push_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   48,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   48,
													},
													File:   "group_max_push_test.flux",
													Source: "[\"_start\", \"_stop\",\"host\"]",
													Start: ast.Position{
														Column: 22,
														Line:   48,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   48,
														},
														File:   "group_max_push_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   48,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   48,
														},
														File:   "group_max_push_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   48,
														},
													},
												},
												Value: "_stop",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   48,
														},
														File:   "group_max_push_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 41,
															Line:   48,
														},
													},
												},
												Value: "host",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   48,
										},
										File:   "group_max_push_test.flux",
										Source: "group(columns:[\"_start\", \"_stop\",\"host\"])",
										Start: ast.Position{
											Column: 8,
											Line:   48,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   48,
											},
											File:   "group_max_push_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 8,
												Line:   48,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   49,
								},
								File:   "group_max_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()",
								Start: ast.Position{
									Column: 31,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   49,
									},
									File:   "group_max_push_test.flux",
									Source: "max()",
									Start: ast.Position{
										Column: 8,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   49,
										},
										File:   "group_max_push_test.flux",
										Source: "max",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Name: "max",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   50,
							},
							File:   "group_max_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> max()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
							Start: ast.Position{
								Column: 31,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   50,
									},
									File:   "group_max_push_test.flux",
									Source: "columns: [\"_measurement\", \"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   50,
										},
										File:   "group_max_push_test.flux",
										Source: "columns: [\"_measurement\", \"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   50,
											},
											File:   "group_max_push_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   50,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   50,
											},
											File:   "group_max_push_test.flux",
											Source: "[\"_measurement\", \"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   50,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   50,
												},
												File:   "group_max_push_test.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 23,
													Line:   50,
												},
											},
										},
										Value: "_measurement",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   50,
												},
												File:   "group_max_push_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   50,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   50,
								},
								File:   "group_max_push_test.flux",
								Source: "drop(columns: [\"_measurement\", \"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   50,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   50,
									},
									File:   "group_max_push_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "group_max_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   46,
								},
								File:   "group_max_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "group_max_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   57,
						},
						File:   "group_max_push_test.flux",
						Source: "group_max_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   52,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   52,
							},
							File:   "group_max_push_test.flux",
							Source: "group_max_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   52,
							},
						},
					},
					Name: "group_max_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   57,
							},
							File:   "group_max_push_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
							Start: ast.Position{
								Column: 27,
								Line:   52,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   57,
								},
								File:   "group_max_push_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   53,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   57,
									},
									File:   "group_max_push_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   54,
										},
										File:   "group_max_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   54,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   54,
											},
											File:   "group_max_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   54,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   54,
												},
												File:   "group_max_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   54,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   54,
													},
													File:   "group_max_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   54,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   54,
														},
														File:   "group_max_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   54,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   54,
														},
														File:   "group_max_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   54,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   54,
											},
											File:   "group_max_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   54,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   54,
												},
												File:   "group_max_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   54,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "group_max_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   54,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   54,
													},
													File:   "group_max_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   54,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   55,
										},
										File:   "group_max_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   55,
											},
											File:   "group_max_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   55,
												},
												File:   "group_max_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   55,
													},
													File:   "group_max_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   55,
														},
														File:   "group_max_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   55,
														},
														File:   "group_max_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   55,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   55,
											},
											File:   "group_max_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   55,
												},
												File:   "group_max_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   55,
													},
													File:   "group_max_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   55,
													},
													File:   "group_max_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   56,
										},
										File:   "group_max_push_test.flux",
										Source: "fn: group_max_fn",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   56,
											},
											File:   "group_max_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   56,
											},
											File:   "group_max_push_test.flux",
											Source: "group_max_fn",
											Start: ast.Position{
												Column: 7,
												Line:   56,
											},
										},
									},
									Name: "group_max_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   57,
					},
					File:   "group_max_push_test.flux",
					Source: "test group_max_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_max_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_max_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_max_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_max_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_max_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_max_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   59,
				},
				File:   "group_min_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n\"\n\ngroup_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])\n\ntest group_min_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   6,
						},
						File:   "group_min_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   6,
							},
							File:   "group_min_eval_test.flux",
							Source: "[\"PushDownGroupAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   6,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   6,
								},
								File:   "group_min_eval_test.flux",
								Source: "\"PushDownGroupAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   6,
								},
							},
						},
						Value: "PushDownGroupAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   6,
							},
							File:   "group_min_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   6,
								},
								File:   "group_min_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   6,
								},
								File:   "group_min_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   6,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   6,
					},
					File:   "group_min_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   8,
						},
						File:   "group_min_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "group_min_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   8,
							},
							File:   "group_min_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   8,
								},
								File:   "group_min_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   8,
									},
									File:   "group_min_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   8,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   8,
					},
					File:   "group_min_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "group_min_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   10,
						},
						File:   "group_min_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "group_min_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "group_min_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   38,
						},
						File:   "group_min_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "group_min_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   38,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 48,
						Line:   52,
					},
					File:   "group_min_eval_test.flux",
					Source: "group_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "group_min_eval_test.flux",
						Source: "group_min_fn",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "group_min_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   52,
						},
						File:   "group_min_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
						Start: ast.Position{
							Column: 16,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   48,
											},
											File:   "group_min_eval_test.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 31,
												Line:   48,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   49,
										},
										File:   "group_min_eval_test.flux",
										Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 31,
											Line:   48,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "group_min_eval_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   49,
													},
													File:   "group_min_eval_test.flux",
													Source: "start: 2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   49,
														},
														File:   "group_min_eval_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   49,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   49,
														},
														File:   "group_min_eval_test.flux",
														Source: "2018-05-22T19:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   49,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   49,
											},
											File:   "group_min_eval_test.flux",
											Source: "range(start: 2018-05-22T19:00:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   49,
												},
												File:   "group_min_eval_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   49,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   50,
									},
									File:   "group_min_eval_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])",
									Start: ast.Position{
										Column: 31,
										Line:   48,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   50,
											},
											File:   "group_min_eval_test.flux",
											Source: "columns:[\"_start\", \"_stop\",\"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   50,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   50,
												},
												File:   "group_min_eval_test.flux",
												Source: "columns:[\"_start\", \"_stop\",\"host\"]",
												Start: ast.Position{
													Column: 14,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   50,
													},
													File:   "group_min_eval_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   50,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   50,
													},
													File:   "group_min_eval_test.flux",
													Source: "[\"_start\", \"_stop\",\"host\"]",
													Start: ast.Position{
														Column: 22,
														Line:   50,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   50,
														},
														File:   "group_min_eval_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   50,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   50,
														},
														File:   "group_min_eval_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   50,
														},
													},
												},
												Value: "_stop",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   50,
														},
														File:   "group_min_eval_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 41,
															Line:   50,
														},
													},
												},
												Value: "host",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   50,
										},
										File:   "group_min_eval_test.flux",
										Source: "group(columns:[\"_start\", \"_stop\",\"host\"])",
										Start: ast.Position{
											Column: 8,
											Line:   50,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   50,
											},
											File:   "group_min_eval_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 8,
												Line:   50,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   51,
								},
								File:   "group_min_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()",
								Start: ast.Position{
									Column: 31,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   51,
									},
									File:   "group_min_eval_test.flux",
									Source: "min()",
									Start: ast.Position{
										Column: 8,
										Line:   51,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   51,
										},
										File:   "group_min_eval_test.flux",
										Source: "min",
										Start: ast.Position{
											Column: 8,
											Line:   51,
										},
									},
								},
								Name: "min",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   52,
							},
							File:   "group_min_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
							Start: ast.Position{
								Column: 31,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   52,
									},
									File:   "group_min_eval_test.flux",
									Source: "columns: [\"_measurement\", \"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   52,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   52,
										},
										File:   "group_min_eval_test.flux",
										Source: "columns: [\"_measurement\", \"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   52,
											},
											File:   "group_min_eval_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   52,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   52,
											},
											File:   "group_min_eval_test.flux",
											Source: "[\"_measurement\", \"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   52,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   52,
												},
												File:   "group_min_eval_test.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 23,
													Line:   52,
												},
											},
										},
										Value: "_measurement",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   52,
												},
												File:   "group_min_eval_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   52,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   52,
								},
								File:   "group_min_eval_test.flux",
								Source: "drop(columns: [\"_measurement\", \"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   52,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   52,
									},
									File:   "group_min_eval_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   48,
							},
							File:   "group_min_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   48,
								},
								File:   "group_min_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   48,
							},
							File:   "group_min_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   48,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   59,
						},
						File:   "group_min_eval_test.flux",
						Source: "group_min_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   54,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   54,
							},
							File:   "group_min_eval_test.flux",
							Source: "group_min_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   54,
							},
						},
					},
					Name: "group_min_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   59,
							},
							File:   "group_min_eval_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
							Start: ast.Position{
								Column: 27,
								Line:   54,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   59,
								},
								File:   "group_min_eval_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   55,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   59,
									},
									File:   "group_min_eval_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   56,
										},
										File:   "group_min_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   56,
											},
											File:   "group_min_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   56,
												},
												File:   "group_min_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   56,
													},
													File:   "group_min_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   56,
														},
														File:   "group_min_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   56,
														},
														File:   "group_min_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   56,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   56,
											},
											File:   "group_min_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   56,
												},
												File:   "group_min_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   56,
													},
													File:   "group_min_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   56,
													},
													File:   "group_min_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   56,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   57,
										},
										File:   "group_min_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   57,
											},
											File:   "group_min_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   57,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   57,
												},
												File:   "group_min_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   57,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   57,
													},
													File:   "group_min_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   57,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   57,
														},
														File:   "group_min_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   57,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   57,
														},
														File:   "group_min_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   57,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   57,
											},
											File:   "group_min_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   57,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   57,
												},
												File:   "group_min_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   57,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   57,
													},
													File:   "group_min_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   57,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   57,
													},
													File:   "group_min_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   57,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   58,
										},
										File:   "group_min_eval_test.flux",
										Source: "fn: group_min_fn",
										Start: ast.Position{
											Column: 3,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   58,
											},
											File:   "group_min_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   58,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   58,
											},
											File:   "group_min_eval_test.flux",
											Source: "group_min_fn",
											Start: ast.Position{
												Column: 7,
												Line:   58,
											},
										},
									},
									Name: "group_min_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   59,
					},
					File:   "group_min_eval_test.flux",
					Source: "test group_min_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   54,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_min_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_min_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "group_min_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "group_min_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_min_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_min_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_min_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   57,
				},
				File:   "group_min_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n\"\n\ngroup_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])\n\ntest group_min_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   6,
						},
						File:   "group_min_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   6,
							},
							File:   "group_min_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   6,
							},
							File:   "group_min_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   6,
								},
								File:   "group_min_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   6,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   6,
									},
									File:   "group_min_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   6,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   6,
					},
					File:   "group_min_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "group_min_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   8,
						},
						File:   "group_min_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   8,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "group_min_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "group_min_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   36,
						},
						File:   "group_min_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "group_min_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,_field,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,load1,1.63\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,load3,1.96\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,load1,1.89\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 48,
						Line:   50,
					},
					File:   "group_min_push_test.flux",
					Source: "group_min_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   46,
						},
						File:   "group_min_push_test.flux",
						Source: "group_min_fn",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "group_min_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   50,
						},
						File:   "group_min_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
						Start: ast.Position{
							Column: 16,
							Line:   46,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   46,
											},
											File:   "group_min_push_test.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 31,
												Line:   46,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   47,
										},
										File:   "group_min_push_test.flux",
										Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 31,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   47,
												},
												File:   "group_min_push_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   47,
													},
													File:   "group_min_push_test.flux",
													Source: "start: 2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 14,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   47,
														},
														File:   "group_min_push_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 14,
															Line:   47,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   47,
														},
														File:   "group_min_push_test.flux",
														Source: "2018-05-22T19:00:00Z",
														Start: ast.Position{
															Column: 21,
															Line:   47,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   47,
											},
											File:   "group_min_push_test.flux",
											Source: "range(start: 2018-05-22T19:00:00Z)",
											Start: ast.Position{
												Column: 8,
												Line:   47,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   47,
												},
												File:   "group_min_push_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 8,
													Line:   47,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   48,
									},
									File:   "group_min_push_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])",
									Start: ast.Position{
										Column: 31,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   48,
											},
											File:   "group_min_push_test.flux",
											Source: "columns:[\"_start\", \"_stop\",\"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   48,
												},
												File:   "group_min_push_test.flux",
												Source: "columns:[\"_start\", \"_stop\",\"host\"]",
												Start: ast.Position{
													Column: 14,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   48,
													},
													File:   "group_min_push_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 14,
														Line:   48,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   48,
													},
													File:   "group_min_push_test.flux",
													Source: "[\"_start\", \"_stop\",\"host\"]",
													Start: ast.Position{
														Column: 22,
														Line:   48,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   48,
														},
														File:   "group_min_push_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   48,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   48,
														},
														File:   "group_min_push_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   48,
														},
													},
												},
												Value: "_stop",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   48,
														},
														File:   "group_min_push_test.flux",
														Source: "\"host\"",
														Start: ast.Position{
															Column: 41,
															Line:   48,
														},
													},
												},
												Value: "host",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   48,
										},
										File:   "group_min_push_test.flux",
										Source: "group(columns:[\"_start\", \"_stop\",\"host\"])",
										Start: ast.Position{
											Column: 8,
											Line:   48,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   48,
											},
											File:   "group_min_push_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 8,
												Line:   48,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   49,
								},
								File:   "group_min_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()",
								Start: ast.Position{
									Column: 31,
									Line:   46,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   49,
									},
									File:   "group_min_push_test.flux",
									Source: "min()",
									Start: ast.Position{
										Column: 8,
										Line:   49,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   49,
										},
										File:   "group_min_push_test.flux",
										Source: "min",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Name: "min",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   50,
							},
							File:   "group_min_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\",\"host\"])\n    |> min()\n    |> drop(columns: [\"_measurement\", \"_time\"])",
							Start: ast.Position{
								Column: 31,
								Line:   46,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   50,
									},
									File:   "group_min_push_test.flux",
									Source: "columns: [\"_measurement\", \"_time\"]",
									Start: ast.Position{
										Column: 13,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   50,
										},
										File:   "group_min_push_test.flux",
										Source: "columns: [\"_measurement\", \"_time\"]",
										Start: ast.Position{
											Column: 13,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   50,
											},
											File:   "group_min_push_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 13,
												Line:   50,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   50,
											},
											File:   "group_min_push_test.flux",
											Source: "[\"_measurement\", \"_time\"]",
											Start: ast.Position{
												Column: 22,
												Line:   50,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   50,
												},
												File:   "group_min_push_test.flux",
												Source: "\"_measurement\"",
												Start: ast.Position{
													Column: 23,
													Line:   50,
												},
											},
										},
										Value: "_measurement",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   50,
												},
												File:   "group_min_push_test.flux",
												Source: "\"_time\"",
												Start: ast.Position{
													Column: 39,
													Line:   50,
												},
											},
										},
										Value: "_time",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   50,
								},
								File:   "group_min_push_test.flux",
								Source: "drop(columns: [\"_measurement\", \"_time\"])",
								Start: ast.Position{
									Column: 8,
									Line:   50,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   50,
									},
									File:   "group_min_push_test.flux",
									Source: "drop",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Name: "drop",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "group_min_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   46,
								},
								File:   "group_min_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   46,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   46,
							},
							File:   "group_min_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   46,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   57,
						},
						File:   "group_min_push_test.flux",
						Source: "group_min_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   52,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   52,
							},
							File:   "group_min_push_test.flux",
							Source: "group_min_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   52,
							},
						},
					},
					Name: "group_min_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   57,
							},
							File:   "group_min_push_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
							Start: ast.Position{
								Column: 27,
								Line:   52,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   57,
								},
								File:   "group_min_push_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   53,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   57,
									},
									File:   "group_min_push_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   54,
										},
										File:   "group_min_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   54,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   54,
											},
											File:   "group_min_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   54,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   54,
												},
												File:   "group_min_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   54,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   54,
													},
													File:   "group_min_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   54,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   54,
														},
														File:   "group_min_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   54,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   54,
														},
														File:   "group_min_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   54,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   54,
											},
											File:   "group_min_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   54,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   54,
												},
												File:   "group_min_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   54,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   54,
													},
													File:   "group_min_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   54,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   54,
													},
													File:   "group_min_push_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   54,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   55,
										},
										File:   "group_min_push_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   55,
											},
											File:   "group_min_push_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   55,
												},
												File:   "group_min_push_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   55,
													},
													File:   "group_min_push_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   55,
														},
														File:   "group_min_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   55,
														},
														File:   "group_min_push_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   55,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   55,
											},
											File:   "group_min_push_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   55,
												},
												File:   "group_min_push_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   55,
													},
													File:   "group_min_push_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   55,
													},
													File:   "group_min_push_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   56,
										},
										File:   "group_min_push_test.flux",
										Source: "fn: group_min_fn",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   56,
											},
											File:   "group_min_push_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   56,
											},
											File:   "group_min_push_test.flux",
											Source: "group_min_fn",
											Start: ast.Position{
												Column: 7,
												Line:   56,
											},
										},
									},
									Name: "group_min_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   57,
					},
					File:   "group_min_push_test.flux",
					Source: "test group_min_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_min_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_min_push_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_min_push_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_min_push_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_min_push_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_min_push_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   58,
				},
				File:   "group_sum_eval_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\nimport \"planner\"\n\noption planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n\"\n\ngroup_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()\n\ntest group_sum_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.MemberAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   6,
						},
						File:   "group_sum_eval_test.flux",
						Source: "planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Init: &ast.ArrayExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   6,
							},
							File:   "group_sum_eval_test.flux",
							Source: "[\"PushDownGroupAggregateRule\"]",
							Start: ast.Position{
								Column: 39,
								Line:   6,
							},
						},
					},
					Elements: []ast.Expression{&ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   6,
								},
								File:   "group_sum_eval_test.flux",
								Source: "\"PushDownGroupAggregateRule\"",
								Start: ast.Position{
									Column: 40,
									Line:   6,
								},
							},
						},
						Value: "PushDownGroupAggregateRule",
					}},
					Lbrack: nil,
					Rbrack: nil,
				},
				Member: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   6,
							},
							File:   "group_sum_eval_test.flux",
							Source: "planner.disablePhysicalRules",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   6,
								},
								File:   "group_sum_eval_test.flux",
								Source: "planner",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "planner",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   6,
								},
								File:   "group_sum_eval_test.flux",
								Source: "disablePhysicalRules",
								Start: ast.Position{
									Column: 16,
									Line:   6,
								},
							},
						},
						Name: "disablePhysicalRules",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   6,
					},
					File:   "group_sum_eval_test.flux",
					Source: "option planner.disablePhysicalRules = [\"PushDownGroupAggregateRule\"]",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   8,
						},
						File:   "group_sum_eval_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "group_sum_eval_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   8,
							},
							File:   "group_sum_eval_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   8,
								},
								File:   "group_sum_eval_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   8,
									},
									File:   "group_sum_eval_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   8,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   8,
					},
					File:   "group_sum_eval_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "group_sum_eval_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   10,
						},
						File:   "group_sum_eval_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "group_sum_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   46,
					},
					File:   "group_sum_eval_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   38,
						},
						File:   "group_sum_eval_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   38,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   46,
						},
						File:   "group_sum_eval_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   38,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   51,
					},
					File:   "group_sum_eval_test.flux",
					Source: "group_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "group_sum_eval_test.flux",
						Source: "group_sum_fn",
						Start: ast.Position{
							Column: 1,
							Line:   48,
						},
					},
				},
				Name: "group_sum_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   51,
						},
						File:   "group_sum_eval_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()",
						Start: ast.Position{
							Column: 16,
							Line:   48,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   48,
										},
										File:   "group_sum_eval_test.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 31,
											Line:   48,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   49,
									},
									File:   "group_sum_eval_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
									Start: ast.Position{
										Column: 31,
										Line:   48,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   49,
											},
											File:   "group_sum_eval_test.flux",
											Source: "start: 2018-05-22T19:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   49,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "group_sum_eval_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   49,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   49,
													},
													File:   "group_sum_eval_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   49,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   49,
													},
													File:   "group_sum_eval_test.flux",
													Source: "2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   49,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   49,
										},
										File:   "group_sum_eval_test.flux",
										Source: "range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   49,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   49,
											},
											File:   "group_sum_eval_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   49,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   50,
								},
								File:   "group_sum_eval_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])",
								Start: ast.Position{
									Column: 31,
									Line:   48,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   50,
										},
										File:   "group_sum_eval_test.flux",
										Source: "columns:[\"_start\", \"_stop\", \"host\"]",
										Start: ast.Position{
											Column: 14,
											Line:   50,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   50,
											},
											File:   "group_sum_eval_test.flux",
											Source: "columns:[\"_start\", \"_stop\", \"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   50,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   50,
												},
												File:   "group_sum_eval_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   50,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   50,
												},
												File:   "group_sum_eval_test.flux",
												Source: "[\"_start\", \"_stop\", \"host\"]",
												Start: ast.Position{
													Column: 22,
													Line:   50,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   50,
													},
													File:   "group_sum_eval_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   50,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   50,
													},
													File:   "group_sum_eval_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   50,
													},
												},
											},
											Value: "_stop",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   50,
													},
													File:   "group_sum_eval_test.flux",
													Source: "\"host\"",
													Start: ast.Position{
														Column: 42,
														Line:   50,
													},
												},
											},
											Value: "host",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   50,
									},
									File:   "group_sum_eval_test.flux",
									Source: "group(columns:[\"_start\", \"_stop\", \"host\"])",
									Start: ast.Position{
										Column: 8,
										Line:   50,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   50,
										},
										File:   "group_sum_eval_test.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   50,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   51,
							},
							File:   "group_sum_eval_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()",
							Start: ast.Position{
								Column: 31,
								Line:   48,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   51,
								},
								File:   "group_sum_eval_test.flux",
								Source: "sum()",
								Start: ast.Position{
									Column: 8,
									Line:   51,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   51,
									},
									File:   "group_sum_eval_test.flux",
									Source: "sum",
									Start: ast.Position{
										Column: 8,
										Line:   51,
									},
								},
							},
							Name: "sum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   48,
							},
							File:   "group_sum_eval_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   48,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   48,
								},
								File:   "group_sum_eval_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   48,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   48,
							},
							File:   "group_sum_eval_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   48,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   58,
						},
						File:   "group_sum_eval_test.flux",
						Source: "group_sum_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   53,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   53,
							},
							File:   "group_sum_eval_test.flux",
							Source: "group_sum_evaluate",
							Start: ast.Position{
								Column: 6,
								Line:   53,
							},
						},
					},
					Name: "group_sum_evaluate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   58,
							},
							File:   "group_sum_eval_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
							Start: ast.Position{
								Column: 27,
								Line:   53,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   58,
								},
								File:   "group_sum_eval_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   54,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   58,
									},
									File:   "group_sum_eval_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   54,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   55,
										},
										File:   "group_sum_eval_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   55,
											},
											File:   "group_sum_eval_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   55,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   55,
												},
												File:   "group_sum_eval_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   55,
													},
													File:   "group_sum_eval_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   55,
														},
														File:   "group_sum_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   55,
														},
														File:   "group_sum_eval_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   55,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   55,
											},
											File:   "group_sum_eval_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   55,
												},
												File:   "group_sum_eval_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   55,
													},
													File:   "group_sum_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 10,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   55,
													},
													File:   "group_sum_eval_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 18,
														Line:   55,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   56,
										},
										File:   "group_sum_eval_test.flux",
										Source: "want: testing.loadMem(csv: output)",
										Start: ast.Position{
											Column: 3,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   56,
											},
											File:   "group_sum_eval_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 3,
												Line:   56,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   56,
												},
												File:   "group_sum_eval_test.flux",
												Source: "csv: output",
												Start: ast.Position{
													Column: 25,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   56,
													},
													File:   "group_sum_eval_test.flux",
													Source: "csv: output",
													Start: ast.Position{
														Column: 25,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   56,
														},
														File:   "group_sum_eval_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 25,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   56,
														},
														File:   "group_sum_eval_test.flux",
														Source: "output",
														Start: ast.Position{
															Column: 30,
															Line:   56,
														},
													},
												},
												Name: "output",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   56,
											},
											File:   "group_sum_eval_test.flux",
											Source: "testing.loadMem(csv: output)",
											Start: ast.Position{
												Column: 9,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   56,
												},
												File:   "group_sum_eval_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 9,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   56,
													},
													File:   "group_sum_eval_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   56,
													},
													File:   "group_sum_eval_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 17,
														Line:   56,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   57,
										},
										File:   "group_sum_eval_test.flux",
										Source: "fn: group_sum_fn",
										Start: ast.Position{
											Column: 3,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 5,
												Line:   57,
											},
											File:   "group_sum_eval_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 3,
												Line:   57,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   57,
											},
											File:   "group_sum_eval_test.flux",
											Source: "group_sum_fn",
											Start: ast.Position{
												Column: 7,
												Line:   57,
											},
										},
									},
									Name: "group_sum_fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 4,
						Line:   58,
					},
					File:   "group_sum_eval_test.flux",
					Source: "test group_sum_evaluate = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "group_sum_eval_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "group_sum_eval_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "group_sum_eval_test.flux",
					Source: "import \"planner\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "group_sum_eval_test.flux",
						Source: "\"planner\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "planner",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "group_sum_eval_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   1,
					},
					File:   "group_sum_eval_test.flux",
					Source: "package planner_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   1,
						},
						File:   "group_sum_eval_test.flux",
						Source: "planner_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "planner_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 4,
					Line:   55,
				},
				File:   "group_sum_push_test.flux",
				Source: "package planner_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninput = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"\n\noutput = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n\"\n\ngroup_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()\n\ntest group_count_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "group_sum_push_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "group_sum_push_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "group_sum_push_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "group_sum_push_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "group_sum_push_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "group_sum_push_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "group_sum_push_test.flux",
					Source: "input = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   7,
						},
						File:   "group_sum_push_test.flux",
						Source: "input",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "input",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "group_sum_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n\"",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,double\n#group,false,false,false,true,true,true,false\n#default,_result,,,,,,\n,result,table,_time,_measurement,host,_field,_value\n,,0,2018-05-22T19:53:26Z,system,hostA,load1,1.83\n,,0,2018-05-22T19:53:36Z,system,hostA,load1,1.72\n,,0,2018-05-22T19:53:37Z,system,hostA,load1,1.77\n,,0,2018-05-22T19:53:56Z,system,hostA,load1,1.63\n,,0,2018-05-22T19:54:06Z,system,hostA,load1,1.91\n,,0,2018-05-22T19:54:16Z,system,hostA,load1,1.84\n\n,,1,2018-05-22T19:53:26Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:53:36Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:46Z,system,hostB,load3,1.97\n,,1,2018-05-22T19:53:56Z,system,hostB,load3,1.96\n,,1,2018-05-22T19:54:06Z,system,hostB,load3,1.98\n,,1,2018-05-22T19:54:16Z,system,hostB,load3,1.97\n\n,,2,2018-05-22T19:53:26Z,system,hostC,load5,1.95\n,,2,2018-05-22T19:53:36Z,system,hostC,load5,1.92\n,,2,2018-05-22T19:53:41Z,system,hostC,load5,1.91\n\n,,3,2018-05-22T19:53:46Z,system,hostC,load1,1.92\n,,3,2018-05-22T19:53:56Z,system,hostC,load1,1.89\n,,3,2018-05-22T19:54:16Z,system,hostC,load1,1.93\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   43,
					},
					File:   "group_sum_push_test.flux",
					Source: "output = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   35,
						},
						File:   "group_sum_push_test.flux",
						Source: "output",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "output",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   43,
						},
						File:   "group_sum_push_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   35,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double\n#group,false,false,true,true,true,false\n#default,_result,,,,,\n,result,table,_start,_stop,host,_value\n,,0,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostA,10.7\n,,1,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostB,11.83\n,,2,2018-05-22T19:00:00Z,2030-01-01T00:00:00Z,hostC,11.52\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   48,
					},
					File:   "group_sum_push_test.flux",
					Source: "group_sum_fn = (tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   45,
						},
						File:   "group_sum_push_test.flux",
						Source: "group_sum_fn",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "group_sum_fn",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   48,
						},
						File:   "group_sum_push_test.flux",
						Source: "(tables=<-) => tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()",
						Start: ast.Position{
							Column: 16,
							Line:   45,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   45,
										},
										File:   "group_sum_push_test.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 31,
											Line:   45,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   46,
									},
									File:   "group_sum_push_test.flux",
									Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)",
									Start: ast.Position{
										Column: 31,
										Line:   45,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   46,
											},
											File:   "group_sum_push_test.flux",
											Source: "start: 2018-05-22T19:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   46,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   46,
												},
												File:   "group_sum_push_test.flux",
												Source: "start: 2018-05-22T19:00:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   46,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   46,
													},
													File:   "group_sum_push_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   46,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   46,
													},
													File:   "group_sum_push_test.flux",
													Source: "2018-05-22T19:00:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   46,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   46,
										},
										File:   "group_sum_push_test.flux",
										Source: "range(start: 2018-05-22T19:00:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   46,
											},
											File:   "group_sum_push_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   46,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   47,
								},
								File:   "group_sum_push_test.flux",
								Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])",
								Start: ast.Position{
									Column: 31,
									Line:   45,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   47,
										},
										File:   "group_sum_push_test.flux",
										Source: "columns:[\"_start\", \"_stop\", \"host\"]",
										Start: ast.Position{
											Column: 14,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   47,
											},
											File:   "group_sum_push_test.flux",
											Source: "columns:[\"_start\", \"_stop\", \"host\"]",
											Start: ast.Position{
												Column: 14,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   47,
												},
												File:   "group_sum_push_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   47,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   47,
												},
												File:   "group_sum_push_test.flux",
												Source: "[\"_start\", \"_stop\", \"host\"]",
												Start: ast.Position{
													Column: 22,
													Line:   47,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   47,
													},
													File:   "group_sum_push_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   47,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   47,
													},
													File:   "group_sum_push_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   47,
													},
												},
											},
											Value: "_stop",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   47,
													},
													File:   "group_sum_push_test.flux",
													Source: "\"host\"",
													Start: ast.Position{
														Column: 42,
														Line:   47,
													},
												},
											},
											Value: "host",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   47,
									},
									File:   "group_sum_push_test.flux",
									Source: "group(columns:[\"_start\", \"_stop\", \"host\"])",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   47,
										},
										File:   "group_sum_push_test.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   48,
							},
							File:   "group_sum_push_test.flux",
							Source: "tables\n    |> range(start: 2018-05-22T19:00:00Z)\n    |> group(columns:[\"_start\", \"_stop\", \"host\"])\n    |> sum()",
							Start: ast.Position{
								Column: 31,
								Line:   45,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   48,
								},
								File:   "group_sum_push_test.flux",
								Source: "sum()",
								Start: ast.Position{
									Column: 8,
									Line:   48,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   48,
									},
									File:   "group_sum_push_test.flux",
									Source: "sum",
									Start: ast.Position{
										Column: 8,
										Line:   48,
									},
								},
							},
							Name: "sum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   45,
							},
							File:   "group_sum_push_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   45,
								},
								File:   "group_sum_push_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   45,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   45,
							},
							File:   "group_sum_push_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   55,
						},
						File:   "group_sum_push_test.flux",
						Source: "group_count_pushdown = () =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
						Start: ast.Position{
							Column: 6,
							Line:   50,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   50,
							},
							File:   "group_sum_push_test.flux",
							Source: "group_count_pushdown",
							Start: ast.Position{
								Column: 6,
								Line:   50,
							},
						},
					},
					Name: "group_count_pushdown",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 4,
								Line:   55,
							},
							File:   "group_sum_push_test.flux",
							Source: "() =>\n\t({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
							Start: ast.Position{
								Column: 29,
								Line:   50,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 4,
									Line:   55,
								},
								File:   "group_sum_push_test.flux",
								Source: "({\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t})",
								Start: ast.Position{
									Column: 2,
									Line:   51,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 3,
										Line:   55,
									},
									File:   "group_sum_push_test.flux",
									Source: "{\n\t\tinput: testing.loadStorage(csv: input),\n\t\twant: testing.loadMem(csv: output),\n\t\tfn: group_sum_fn\n\t}",
									Start: ast.Position{
										Column: 3,
										Line:   51,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   52,
										},
										File:   "group_sum_push_test.flux",
										Source: "input: testing.loadStorage(csv: input)",
										Start: ast.Position{
											Column: 3,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   52,
											},
											File:   "group_sum_push_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 3,
												Line:   52,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   52,
												},
												File:   "group_sum_push_test.flux",
												Source: "csv: input",
												Start: ast.Position{
													Column: 30,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   52,
													},
													File:   "group_sum_push_test.flux",
													Source: "csv: input",
													Start: ast.Position{
														Column: 30,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 33,
															Line:   52,
														},
														File:   "group_sum_push_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 30,
															Line:   52,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   52,
														},
														File:   "group_sum_push_test.flux",
														Source: "input",
														Start: ast.Position{
															Column: 35,
															Line:   52,
														},
													},
												},
												Name: "input",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "group_sum_push_test.flux",
											Source: "testing.loadStorage(csv: input)",
											Start: ast.Position{
												Column: 10,
												Line:   52,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   52,
												},
												File:   "group_sum_push_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 10,
													Line:   52,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   52,
													},
													File:   "group_sum_push_test.flux",
													Source: "test