// DO NOT EDIT: This file is autogenerated via the builtin command.

package universe

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
	"regexp"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   56,
				},
				File:   "aggregate_empty_window_count_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,1\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,3\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,2\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,1\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,3\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,2\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,1\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,3\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,2\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n\"\r\n\r\ntest aggregate_window_empty_count = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_count_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   47,
					},
					File:   "aggregate_empty_window_count_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,1\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,3\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,2\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,1\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,3\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,2\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,1\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,3\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,2\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   47,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,1\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,3\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,2\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,1\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,3\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,2\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,1\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,3\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,2\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,long\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,1\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,3\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,2\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,1\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,3\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,2\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,1\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,3\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,2\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   56,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "aggregate_window_empty_count = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   49,
							},
							File:   "aggregate_empty_window_count_test.flux",
							Source: "aggregate_window_empty_count",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "aggregate_window_empty_count",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   56,
							},
							File:   "aggregate_empty_window_count_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count),\r\n})",
							Start: ast.Position{
								Column: 37,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   56,
								},
								File:   "aggregate_empty_window_count_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count),\r\n})",
								Start: ast.Position{
									Column: 43,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   56,
									},
									File:   "aggregate_empty_window_count_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count),\r\n}",
									Start: ast.Position{
										Column: 44,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   50,
										},
										File:   "aggregate_empty_window_count_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   50,
											},
											File:   "aggregate_empty_window_count_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   50,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   50,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   50,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   50,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   50,
											},
											File:   "aggregate_empty_window_count_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   50,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   50,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   50,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   51,
										},
										File:   "aggregate_empty_window_count_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   51,
											},
											File:   "aggregate_empty_window_count_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   51,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   51,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   51,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   51,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   51,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   51,
											},
											File:   "aggregate_empty_window_count_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   51,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   51,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   55,
										},
										File:   "aggregate_empty_window_count_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count)",
										Start: ast.Position{
											Column: 5,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   52,
											},
											File:   "aggregate_empty_window_count_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   52,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   55,
											},
											File:   "aggregate_empty_window_count_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count)",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   53,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   53,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   54,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   54,
															},
															File:   "aggregate_empty_window_count_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   54,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   54,
																},
																File:   "aggregate_empty_window_count_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_count_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   54,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_count_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   54,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   54,
																},
																File:   "aggregate_empty_window_count_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_count_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   54,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_count_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   54,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   54,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   54,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   54,
															},
															File:   "aggregate_empty_window_count_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   54,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   55,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count)",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   55,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "every: 30s, fn: count",
														Start: ast.Position{
															Column: 32,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   55,
															},
															File:   "aggregate_empty_window_count_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   55,
																},
																File:   "aggregate_empty_window_count_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   55,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   55,
																},
																File:   "aggregate_empty_window_count_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   55,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   55,
															},
															File:   "aggregate_empty_window_count_test.flux",
															Source: "fn: count",
															Start: ast.Position{
																Column: 44,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   55,
																},
																File:   "aggregate_empty_window_count_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   55,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   55,
																},
																File:   "aggregate_empty_window_count_test.flux",
																Source: "count",
																Start: ast.Position{
																	Column: 48,
																	Line:   55,
																},
															},
														},
														Name: "count",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   55,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "aggregateWindow(every: 30s, fn: count)",
													Start: ast.Position{
														Column: 16,
														Line:   55,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   55,
														},
														File:   "aggregate_empty_window_count_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   55,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   52,
													},
													File:   "aggregate_empty_window_count_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   52,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_empty_window_count_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   52,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   56,
					},
					File:   "aggregate_empty_window_count_test.flux",
					Source: "test aggregate_window_empty_count = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: count),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_count_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_count_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_count_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_count_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   53,
				},
				File:   "aggregate_empty_window_first_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n\"\r\n\r\ntest aggregate_window_empty_first = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_first_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "aggregate_empty_window_first_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   53,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "aggregate_window_empty_first = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   46,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   46,
							},
							File:   "aggregate_empty_window_first_test.flux",
							Source: "aggregate_window_empty_first",
							Start: ast.Position{
								Column: 6,
								Line:   46,
							},
						},
					},
					Name: "aggregate_window_empty_first",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   53,
							},
							File:   "aggregate_empty_window_first_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first),\r\n})",
							Start: ast.Position{
								Column: 37,
								Line:   46,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   53,
								},
								File:   "aggregate_empty_window_first_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first),\r\n})",
								Start: ast.Position{
									Column: 43,
									Line:   46,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   53,
									},
									File:   "aggregate_empty_window_first_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first),\r\n}",
									Start: ast.Position{
										Column: 44,
										Line:   46,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   47,
										},
										File:   "aggregate_empty_window_first_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   47,
											},
											File:   "aggregate_empty_window_first_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   47,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   47,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   47,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   47,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   47,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   47,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   47,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   47,
											},
											File:   "aggregate_empty_window_first_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   47,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   47,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   47,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   47,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   47,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   48,
										},
										File:   "aggregate_empty_window_first_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   48,
											},
											File:   "aggregate_empty_window_first_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   48,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   48,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   48,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   48,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   48,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   48,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   48,
											},
											File:   "aggregate_empty_window_first_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   48,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   48,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   52,
										},
										File:   "aggregate_empty_window_first_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first)",
										Start: ast.Position{
											Column: 5,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   49,
											},
											File:   "aggregate_empty_window_first_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   52,
											},
											File:   "aggregate_empty_window_first_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first)",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   50,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   50,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   51,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   51,
															},
															File:   "aggregate_empty_window_first_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   51,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   51,
																},
																File:   "aggregate_empty_window_first_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_first_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   51,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_first_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   51,
																},
																File:   "aggregate_empty_window_first_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_first_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   51,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_first_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   51,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   51,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   51,
															},
															File:   "aggregate_empty_window_first_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   51,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   52,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first)",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 53,
															Line:   52,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "every: 30s, fn: first",
														Start: ast.Position{
															Column: 32,
															Line:   52,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   52,
															},
															File:   "aggregate_empty_window_first_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   52,
																},
																File:   "aggregate_empty_window_first_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   52,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   52,
																},
																File:   "aggregate_empty_window_first_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   52,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 53,
																Line:   52,
															},
															File:   "aggregate_empty_window_first_test.flux",
															Source: "fn: first",
															Start: ast.Position{
																Column: 44,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   52,
																},
																File:   "aggregate_empty_window_first_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   52,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   52,
																},
																File:   "aggregate_empty_window_first_test.flux",
																Source: "first",
																Start: ast.Position{
																	Column: 48,
																	Line:   52,
																},
															},
														},
														Name: "first",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   52,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "aggregateWindow(every: 30s, fn: first)",
													Start: ast.Position{
														Column: 16,
														Line:   52,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   52,
														},
														File:   "aggregate_empty_window_first_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   52,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   49,
													},
													File:   "aggregate_empty_window_first_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   49,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_first_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   49,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   53,
					},
					File:   "aggregate_empty_window_first_test.flux",
					Source: "test aggregate_window_empty_first = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: first),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_first_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_first_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_first_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_first_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   53,
				},
				File:   "aggregate_empty_window_last_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.02836436336374\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n\"\r\n\r\ntest aggregate_window_empty_last = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_last_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "aggregate_empty_window_last_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.02836436336374\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.02836436336374\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.02836436336374\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   53,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "aggregate_window_empty_last = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   46,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   46,
							},
							File:   "aggregate_empty_window_last_test.flux",
							Source: "aggregate_window_empty_last",
							Start: ast.Position{
								Column: 6,
								Line:   46,
							},
						},
					},
					Name: "aggregate_window_empty_last",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   53,
							},
							File:   "aggregate_empty_window_last_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last),\r\n})",
							Start: ast.Position{
								Column: 36,
								Line:   46,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   53,
								},
								File:   "aggregate_empty_window_last_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last),\r\n})",
								Start: ast.Position{
									Column: 42,
									Line:   46,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   53,
									},
									File:   "aggregate_empty_window_last_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last),\r\n}",
									Start: ast.Position{
										Column: 43,
										Line:   46,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   47,
										},
										File:   "aggregate_empty_window_last_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   47,
											},
											File:   "aggregate_empty_window_last_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   47,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   47,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   47,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   47,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   47,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   47,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   47,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   47,
											},
											File:   "aggregate_empty_window_last_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   47,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   47,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   47,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   47,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   47,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   48,
										},
										File:   "aggregate_empty_window_last_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   48,
											},
											File:   "aggregate_empty_window_last_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   48,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   48,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   48,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   48,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   48,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   48,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   48,
											},
											File:   "aggregate_empty_window_last_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   48,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   48,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   52,
										},
										File:   "aggregate_empty_window_last_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last)",
										Start: ast.Position{
											Column: 5,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   49,
											},
											File:   "aggregate_empty_window_last_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   52,
											},
											File:   "aggregate_empty_window_last_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last)",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   50,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   50,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   51,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   51,
															},
															File:   "aggregate_empty_window_last_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   51,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   51,
																},
																File:   "aggregate_empty_window_last_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_last_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   51,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_last_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   51,
																},
																File:   "aggregate_empty_window_last_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_last_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   51,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_last_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   51,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   51,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   51,
															},
															File:   "aggregate_empty_window_last_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   51,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   52,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last)",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   52,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "every: 30s, fn: last",
														Start: ast.Position{
															Column: 32,
															Line:   52,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   52,
															},
															File:   "aggregate_empty_window_last_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   52,
																},
																File:   "aggregate_empty_window_last_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   52,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   52,
																},
																File:   "aggregate_empty_window_last_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   52,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   52,
															},
															File:   "aggregate_empty_window_last_test.flux",
															Source: "fn: last",
															Start: ast.Position{
																Column: 44,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   52,
																},
																File:   "aggregate_empty_window_last_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   52,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 52,
																	Line:   52,
																},
																File:   "aggregate_empty_window_last_test.flux",
																Source: "last",
																Start: ast.Position{
																	Column: 48,
																	Line:   52,
																},
															},
														},
														Name: "last",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   52,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "aggregateWindow(every: 30s, fn: last)",
													Start: ast.Position{
														Column: 16,
														Line:   52,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   52,
														},
														File:   "aggregate_empty_window_last_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   52,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   49,
													},
													File:   "aggregate_empty_window_last_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   49,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_last_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   49,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   53,
					},
					File:   "aggregate_empty_window_last_test.flux",
					Source: "test aggregate_window_empty_last = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: last),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_last_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_last_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_last_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_last_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   53,
				},
				File:   "aggregate_empty_window_max_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.0977744436109\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n\"\r\n\r\ntest aggregate_window_empty_max = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_max_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "aggregate_empty_window_max_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.0977744436109\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.0977744436109\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,91.0977744436109\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,87.88598574821853\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   53,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "aggregate_window_empty_max = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   46,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   46,
							},
							File:   "aggregate_empty_window_max_test.flux",
							Source: "aggregate_window_empty_max",
							Start: ast.Position{
								Column: 6,
								Line:   46,
							},
						},
					},
					Name: "aggregate_window_empty_max",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   53,
							},
							File:   "aggregate_empty_window_max_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max),\r\n})",
							Start: ast.Position{
								Column: 35,
								Line:   46,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   53,
								},
								File:   "aggregate_empty_window_max_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max),\r\n})",
								Start: ast.Position{
									Column: 41,
									Line:   46,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   53,
									},
									File:   "aggregate_empty_window_max_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max),\r\n}",
									Start: ast.Position{
										Column: 42,
										Line:   46,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   47,
										},
										File:   "aggregate_empty_window_max_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   47,
											},
											File:   "aggregate_empty_window_max_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   47,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   47,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   47,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   47,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   47,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   47,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   47,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   47,
											},
											File:   "aggregate_empty_window_max_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   47,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   47,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   47,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   47,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   47,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   48,
										},
										File:   "aggregate_empty_window_max_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   48,
											},
											File:   "aggregate_empty_window_max_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   48,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   48,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   48,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   48,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   48,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   48,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   48,
											},
											File:   "aggregate_empty_window_max_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   48,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   48,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   52,
										},
										File:   "aggregate_empty_window_max_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max)",
										Start: ast.Position{
											Column: 5,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   49,
											},
											File:   "aggregate_empty_window_max_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   52,
											},
											File:   "aggregate_empty_window_max_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max)",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   50,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   50,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   51,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   51,
															},
															File:   "aggregate_empty_window_max_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   51,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   51,
																},
																File:   "aggregate_empty_window_max_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_max_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   51,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_max_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   51,
																},
																File:   "aggregate_empty_window_max_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_max_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   51,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_max_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   51,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   51,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   51,
															},
															File:   "aggregate_empty_window_max_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   51,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   52,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max)",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   52,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "every: 30s, fn: max",
														Start: ast.Position{
															Column: 32,
															Line:   52,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   52,
															},
															File:   "aggregate_empty_window_max_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   52,
																},
																File:   "aggregate_empty_window_max_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   52,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   52,
																},
																File:   "aggregate_empty_window_max_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   52,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   52,
															},
															File:   "aggregate_empty_window_max_test.flux",
															Source: "fn: max",
															Start: ast.Position{
																Column: 44,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   52,
																},
																File:   "aggregate_empty_window_max_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   52,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   52,
																},
																File:   "aggregate_empty_window_max_test.flux",
																Source: "max",
																Start: ast.Position{
																	Column: 48,
																	Line:   52,
																},
															},
														},
														Name: "max",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   52,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "aggregateWindow(every: 30s, fn: max)",
													Start: ast.Position{
														Column: 16,
														Line:   52,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   52,
														},
														File:   "aggregate_empty_window_max_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   52,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   49,
													},
													File:   "aggregate_empty_window_max_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   49,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_max_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   49,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   53,
					},
					File:   "aggregate_empty_window_max_test.flux",
					Source: "test aggregate_window_empty_max = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: max),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_max_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_max_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_max_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_max_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   56,
				},
				File:   "aggregate_empty_window_mean_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,90.54577590186233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,78.09528094612728\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n\"\r\n\r\ntest aggregate_window_empty_mean = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_mean_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   47,
					},
					File:   "aggregate_empty_window_mean_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,90.54577590186233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,78.09528094612728\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   47,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,90.54577590186233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,78.09528094612728\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,90.54577590186233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,78.09528094612728\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   56,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "aggregate_window_empty_mean = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   49,
							},
							File:   "aggregate_empty_window_mean_test.flux",
							Source: "aggregate_window_empty_mean",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "aggregate_window_empty_mean",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   56,
							},
							File:   "aggregate_empty_window_mean_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean),\r\n})",
							Start: ast.Position{
								Column: 36,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   56,
								},
								File:   "aggregate_empty_window_mean_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean),\r\n})",
								Start: ast.Position{
									Column: 42,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   56,
									},
									File:   "aggregate_empty_window_mean_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean),\r\n}",
									Start: ast.Position{
										Column: 43,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   50,
										},
										File:   "aggregate_empty_window_mean_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   50,
											},
											File:   "aggregate_empty_window_mean_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   50,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   50,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   50,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   50,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   50,
											},
											File:   "aggregate_empty_window_mean_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   50,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   50,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   50,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   51,
										},
										File:   "aggregate_empty_window_mean_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   51,
											},
											File:   "aggregate_empty_window_mean_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   51,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   51,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   51,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   51,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   51,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   51,
											},
											File:   "aggregate_empty_window_mean_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   51,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   51,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   55,
										},
										File:   "aggregate_empty_window_mean_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean)",
										Start: ast.Position{
											Column: 5,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   52,
											},
											File:   "aggregate_empty_window_mean_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   52,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   55,
											},
											File:   "aggregate_empty_window_mean_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean)",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   53,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   53,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   54,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   54,
															},
															File:   "aggregate_empty_window_mean_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   54,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   54,
																},
																File:   "aggregate_empty_window_mean_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_mean_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   54,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_mean_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   54,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   54,
																},
																File:   "aggregate_empty_window_mean_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_mean_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   54,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_mean_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   54,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   54,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   54,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   54,
															},
															File:   "aggregate_empty_window_mean_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   54,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   55,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean)",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   55,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "every: 30s, fn: mean",
														Start: ast.Position{
															Column: 32,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   55,
															},
															File:   "aggregate_empty_window_mean_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   55,
																},
																File:   "aggregate_empty_window_mean_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   55,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   55,
																},
																File:   "aggregate_empty_window_mean_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   55,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   55,
															},
															File:   "aggregate_empty_window_mean_test.flux",
															Source: "fn: mean",
															Start: ast.Position{
																Column: 44,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   55,
																},
																File:   "aggregate_empty_window_mean_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   55,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 52,
																	Line:   55,
																},
																File:   "aggregate_empty_window_mean_test.flux",
																Source: "mean",
																Start: ast.Position{
																	Column: 48,
																	Line:   55,
																},
															},
														},
														Name: "mean",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   55,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "aggregateWindow(every: 30s, fn: mean)",
													Start: ast.Position{
														Column: 16,
														Line:   55,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   55,
														},
														File:   "aggregate_empty_window_mean_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   55,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   52,
													},
													File:   "aggregate_empty_window_mean_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   52,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_empty_window_mean_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   52,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   56,
					},
					File:   "aggregate_empty_window_mean_test.flux",
					Source: "test aggregate_window_empty_mean = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: mean),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_mean_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_mean_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_mean_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_mean_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   53,
				},
				File:   "aggregate_empty_window_min_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n\"\r\n\r\ntest aggregate_window_empty_min = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_min_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "aggregate_empty_window_min_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,89.51118889861233\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,68.304576144036\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   53,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "aggregate_window_empty_min = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   46,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   46,
							},
							File:   "aggregate_empty_window_min_test.flux",
							Source: "aggregate_window_empty_min",
							Start: ast.Position{
								Column: 6,
								Line:   46,
							},
						},
					},
					Name: "aggregate_window_empty_min",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   53,
							},
							File:   "aggregate_empty_window_min_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min),\r\n})",
							Start: ast.Position{
								Column: 35,
								Line:   46,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   53,
								},
								File:   "aggregate_empty_window_min_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min),\r\n})",
								Start: ast.Position{
									Column: 41,
									Line:   46,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   53,
									},
									File:   "aggregate_empty_window_min_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min),\r\n}",
									Start: ast.Position{
										Column: 42,
										Line:   46,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   47,
										},
										File:   "aggregate_empty_window_min_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   47,
											},
											File:   "aggregate_empty_window_min_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   47,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   47,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   47,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   47,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   47,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   47,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   47,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   47,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   47,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   47,
											},
											File:   "aggregate_empty_window_min_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   47,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   47,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   47,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   47,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   47,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   47,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   48,
										},
										File:   "aggregate_empty_window_min_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   48,
											},
											File:   "aggregate_empty_window_min_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   48,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   48,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   48,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   48,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   48,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   48,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   48,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   48,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   48,
											},
											File:   "aggregate_empty_window_min_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   48,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   48,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   48,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   48,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   48,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   48,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   48,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   52,
										},
										File:   "aggregate_empty_window_min_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min)",
										Start: ast.Position{
											Column: 5,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   49,
											},
											File:   "aggregate_empty_window_min_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   52,
											},
											File:   "aggregate_empty_window_min_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min)",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   50,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   50,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   51,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   50,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   51,
															},
															File:   "aggregate_empty_window_min_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   51,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   51,
																},
																File:   "aggregate_empty_window_min_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_min_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   51,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_min_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   51,
																},
																File:   "aggregate_empty_window_min_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   51,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_min_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   51,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   51,
																	},
																	File:   "aggregate_empty_window_min_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   51,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   51,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   51,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   51,
															},
															File:   "aggregate_empty_window_min_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   51,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   52,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min)",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   52,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "every: 30s, fn: min",
														Start: ast.Position{
															Column: 32,
															Line:   52,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   52,
															},
															File:   "aggregate_empty_window_min_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   52,
																},
																File:   "aggregate_empty_window_min_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   52,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   52,
																},
																File:   "aggregate_empty_window_min_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   52,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   52,
															},
															File:   "aggregate_empty_window_min_test.flux",
															Source: "fn: min",
															Start: ast.Position{
																Column: 44,
																Line:   52,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   52,
																},
																File:   "aggregate_empty_window_min_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   52,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   52,
																},
																File:   "aggregate_empty_window_min_test.flux",
																Source: "min",
																Start: ast.Position{
																	Column: 48,
																	Line:   52,
																},
															},
														},
														Name: "min",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   52,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "aggregateWindow(every: 30s, fn: min)",
													Start: ast.Position{
														Column: 16,
														Line:   52,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   52,
														},
														File:   "aggregate_empty_window_min_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   52,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   49,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   49,
													},
													File:   "aggregate_empty_window_min_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   49,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   49,
												},
												File:   "aggregate_empty_window_min_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   49,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   53,
					},
					File:   "aggregate_empty_window_min_test.flux",
					Source: "test aggregate_window_empty_min = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: min),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_min_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_min_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_min_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_min_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   56,
				},
				File:   "aggregate_empty_window_sum_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n\"\r\n\r\ntest aggregate_window_empty_sum = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_empty_window_sum_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   47,
					},
					File:   "aggregate_empty_window_sum_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   47,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   56,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "aggregate_window_empty_sum = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   49,
							},
							File:   "aggregate_empty_window_sum_test.flux",
							Source: "aggregate_window_empty_sum",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "aggregate_window_empty_sum",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   56,
							},
							File:   "aggregate_empty_window_sum_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum),\r\n})",
							Start: ast.Position{
								Column: 35,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   56,
								},
								File:   "aggregate_empty_window_sum_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum),\r\n})",
								Start: ast.Position{
									Column: 41,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   56,
									},
									File:   "aggregate_empty_window_sum_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum),\r\n}",
									Start: ast.Position{
										Column: 42,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   50,
										},
										File:   "aggregate_empty_window_sum_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   50,
											},
											File:   "aggregate_empty_window_sum_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   50,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   50,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   50,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   50,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   50,
											},
											File:   "aggregate_empty_window_sum_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   50,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   50,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   50,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   51,
										},
										File:   "aggregate_empty_window_sum_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   51,
											},
											File:   "aggregate_empty_window_sum_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   51,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   51,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   51,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   51,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   51,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   51,
											},
											File:   "aggregate_empty_window_sum_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   51,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   51,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   55,
										},
										File:   "aggregate_empty_window_sum_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)",
										Start: ast.Position{
											Column: 5,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   52,
											},
											File:   "aggregate_empty_window_sum_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   52,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   55,
											},
											File:   "aggregate_empty_window_sum_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   53,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "table",
														Start: ast.Position{
															Column: 9,
															Line:   53,
														},
													},
												},
												Name: "table",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   54,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   54,
															},
															File:   "aggregate_empty_window_sum_test.flux",
															Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 22,
																Line:   54,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   54,
																},
																File:   "aggregate_empty_window_sum_test.flux",
																Source: "start: 2018-05-22T19:53:26Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_sum_test.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 22,
																		Line:   54,
																	},
																},
															},
															Name: "start",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_sum_test.flux",
																	Source: "2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 29,
																		Line:   54,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   54,
																},
																File:   "aggregate_empty_window_sum_test.flux",
																Source: "stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 51,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_sum_test.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 51,
																		Line:   54,
																	},
																},
															},
															Name: "stop",
														},
														Separator: nil,
														Value: &ast.DateTimeLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   54,
																	},
																	File:   "aggregate_empty_window_sum_test.flux",
																	Source: "2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 57,
																		Line:   54,
																	},
																},
															},
															Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   54,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 16,
															Line:   54,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   54,
															},
															File:   "aggregate_empty_window_sum_test.flux",
															Source: "range",
															Start: ast.Position{
																Column: 16,
																Line:   54,
															},
														},
													},
													Name: "range",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   55,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   55,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "every: 30s, fn: sum",
														Start: ast.Position{
															Column: 32,
															Line:   55,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   55,
															},
															File:   "aggregate_empty_window_sum_test.flux",
															Source: "every: 30s",
															Start: ast.Position{
																Column: 32,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   55,
																},
																File:   "aggregate_empty_window_sum_test.flux",
																Source: "every",
																Start: ast.Position{
																	Column: 32,
																	Line:   55,
																},
															},
														},
														Name: "every",
													},
													Separator: nil,
													Value: &ast.DurationLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   55,
																},
																File:   "aggregate_empty_window_sum_test.flux",
																Source: "30s",
																Start: ast.Position{
																	Column: 39,
																	Line:   55,
																},
															},
														},
														Values: []ast.Duration{ast.Duration{
															Magnitude: int64(30),
															Unit:      "s",
														}},
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   55,
															},
															File:   "aggregate_empty_window_sum_test.flux",
															Source: "fn: sum",
															Start: ast.Position{
																Column: 44,
																Line:   55,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   55,
																},
																File:   "aggregate_empty_window_sum_test.flux",
																Source: "fn",
																Start: ast.Position{
																	Column: 44,
																	Line:   55,
																},
															},
														},
														Name: "fn",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   55,
																},
																File:   "aggregate_empty_window_sum_test.flux",
																Source: "sum",
																Start: ast.Position{
																	Column: 48,
																	Line:   55,
																},
															},
														},
														Name: "sum",
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   55,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "aggregateWindow(every: 30s, fn: sum)",
													Start: ast.Position{
														Column: 16,
														Line:   55,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   55,
														},
														File:   "aggregate_empty_window_sum_test.flux",
														Source: "aggregateWindow",
														Start: ast.Position{
															Column: 16,
															Line:   55,
														},
													},
												},
												Name: "aggregateWindow",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   52,
													},
													File:   "aggregate_empty_window_sum_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   52,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_empty_window_sum_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   52,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   56,
					},
					File:   "aggregate_empty_window_sum_test.flux",
					Source: "test aggregate_window_empty_sum = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_empty_window_sum_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_empty_window_sum_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_empty_window_sum_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_empty_window_sum_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   57,
				},
				File:   "aggregate_fill_window_test.flux",
				Source: "package universe_test\r\n \r\nimport \"testing\"\r\n\r\ninData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"\r\n\r\noutData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n\"\r\n\r\ntest aggregate_window_fill = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0),\r\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "aggregate_fill_window_test.flux",
					Source: "inData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   5,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   5,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   5,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string\r\n#group,false,false,false,false,false,false,true,true,true,true\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_value,_field,_measurement,cpu,host\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,0,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,1,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,0,usage_guest_nice,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:26Z,91.7364670583823,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:36Z,89.51118889861233,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:46Z,91.0977744436109,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:53:56Z,91.02836436336374,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:06Z,68.304576144036,usage_idle,cpu,cpu-total,host.local\r\n,,2,2018-05-22T19:53:24.421470485Z,2018-05-22T19:54:24.421470485Z,2018-05-22T19:54:16Z,87.88598574821853,usage_idle,cpu,cpu-total,host.local\r\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   47,
					},
					File:   "aggregate_fill_window_test.flux",
					Source: "outData = \"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   47,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "\"\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\r\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,double\r\n#group,false,false,true,true,false,true,true,true,true,false\r\n#default,_result,,,,,,,,,\r\n,result,table,_start,_stop,_time,_field,_measurement,cpu,host,_value\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,0,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,1,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_guest_nice,cpu,cpu-total,host.local,0\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:53:30Z,usage_idle,cpu,cpu-total,host.local,91.7364670583823\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:00Z,usage_idle,cpu,cpu-total,host.local,271.637327705587\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:54:30Z,usage_idle,cpu,cpu-total,host.local,156.19056189225455\r\n,,2,2018-05-22T19:53:26Z,2018-05-22T19:55:00Z,2018-05-22T19:55:00Z,usage_idle,cpu,cpu-total,host.local,0\r\n",
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   57,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "aggregate_window_fill = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0),\r\n})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   49,
							},
							File:   "aggregate_fill_window_test.flux",
							Source: "aggregate_window_fill",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "aggregate_window_fill",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   57,
							},
							File:   "aggregate_fill_window_test.flux",
							Source: "() => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0),\r\n})",
							Start: ast.Position{
								Column: 30,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   57,
								},
								File:   "aggregate_fill_window_test.flux",
								Source: "({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0),\r\n})",
								Start: ast.Position{
									Column: 36,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   57,
									},
									File:   "aggregate_fill_window_test.flux",
									Source: "{\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0),\r\n}",
									Start: ast.Position{
										Column: 37,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   50,
										},
										File:   "aggregate_fill_window_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 5,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   50,
											},
											File:   "aggregate_fill_window_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 5,
												Line:   50,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   50,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 32,
													Line:   50,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   50,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 32,
														Line:   50,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   50,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 32,
															Line:   50,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   50,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 37,
															Line:   50,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   50,
											},
											File:   "aggregate_fill_window_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 31,
													Line:   50,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 12,
													Line:   50,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   50,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 12,
														Line:   50,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   50,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 20,
														Line:   50,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   51,
										},
										File:   "aggregate_fill_window_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 5,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   51,
											},
											File:   "aggregate_fill_window_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 5,
												Line:   51,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   51,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 27,
													Line:   51,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   51,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 27,
														Line:   51,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   51,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 27,
															Line:   51,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   51,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 32,
															Line:   51,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   51,
											},
											File:   "aggregate_fill_window_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 11,
												Line:   51,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   51,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 11,
													Line:   51,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   51,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   51,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   51,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 19,
														Line:   51,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   56,
										},
										File:   "aggregate_fill_window_test.flux",
										Source: "fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0)",
										Start: ast.Position{
											Column: 5,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   52,
											},
											File:   "aggregate_fill_window_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 5,
												Line:   52,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   56,
											},
											File:   "aggregate_fill_window_test.flux",
											Source: "(table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0)",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Body: &ast.PipeExpression{
										Argument: &ast.PipeExpression{
											Argument: &ast.PipeExpression{
												Argument: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   53,
															},
															File:   "aggregate_fill_window_test.flux",
															Source: "table",
															Start: ast.Position{
																Column: 9,
																Line:   53,
															},
														},
													},
													Name: "table",
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   54,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
														Start: ast.Position{
															Column: 9,
															Line:   53,
														},
													},
												},
												Call: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   54,
																},
																File:   "aggregate_fill_window_test.flux",
																Source: "start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 22,
																	Line:   54,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   54,
																	},
																	File:   "aggregate_fill_window_test.flux",
																	Source: "start: 2018-05-22T19:53:26Z",
																	Start: ast.Position{
																		Column: 22,
																		Line:   54,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 27,
																			Line:   54,
																		},
																		File:   "aggregate_fill_window_test.flux",
																		Source: "start",
																		Start: ast.Position{
																			Column: 22,
																			Line:   54,
																		},
																	},
																},
																Name: "start",
															},
															Separator: nil,
															Value: &ast.DateTimeLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   54,
																		},
																		File:   "aggregate_fill_window_test.flux",
																		Source: "2018-05-22T19:53:26Z",
																		Start: ast.Position{
																			Column: 29,
																			Line:   54,
																		},
																	},
																},
																Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   54,
																	},
																	File:   "aggregate_fill_window_test.flux",
																	Source: "stop: 2018-05-22T19:55:00Z",
																	Start: ast.Position{
																		Column: 51,
																		Line:   54,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   54,
																		},
																		File:   "aggregate_fill_window_test.flux",
																		Source: "stop",
																		Start: ast.Position{
																			Column: 51,
																			Line:   54,
																		},
																	},
																},
																Name: "stop",
															},
															Separator: nil,
															Value: &ast.DateTimeLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   54,
																		},
																		File:   "aggregate_fill_window_test.flux",
																		Source: "2018-05-22T19:55:00Z",
																		Start: ast.Position{
																			Column: 57,
																			Line:   54,
																		},
																	},
																},
																Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   54,
															},
															File:   "aggregate_fill_window_test.flux",
															Source: "range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)",
															Start: ast.Position{
																Column: 16,
																Line:   54,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 21,
																	Line:   54,
																},
																File:   "aggregate_fill_window_test.flux",
																Source: "range",
																Start: ast.Position{
																	Column: 16,
																	Line:   54,
																},
															},
														},
														Name: "range",
													},
													Lparen: nil,
													Rparen: nil,
												},
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   55,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Call: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 51,
																Line:   55,
															},
															File:   "aggregate_fill_window_test.flux",
															Source: "every: 30s, fn: sum",
															Start: ast.Position{
																Column: 32,
																Line:   55,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   55,
																},
																File:   "aggregate_fill_window_test.flux",
																Source: "every: 30s",
																Start: ast.Position{
																	Column: 32,
																	Line:   55,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   55,
																	},
																	File:   "aggregate_fill_window_test.flux",
																	Source: "every",
																	Start: ast.Position{
																		Column: 32,
																		Line:   55,
																	},
																},
															},
															Name: "every",
														},
														Separator: nil,
														Value: &ast.DurationLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 42,
																		Line:   55,
																	},
																	File:   "aggregate_fill_window_test.flux",
																	Source: "30s",
																	Start: ast.Position{
																		Column: 39,
																		Line:   55,
																	},
																},
															},
															Values: []ast.Duration{ast.Duration{
																Magnitude: int64(30),
																Unit:      "s",
															}},
														},
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   55,
																},
																File:   "aggregate_fill_window_test.flux",
																Source: "fn: sum",
																Start: ast.Position{
																	Column: 44,
																	Line:   55,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   55,
																	},
																	File:   "aggregate_fill_window_test.flux",
																	Source: "fn",
																	Start: ast.Position{
																		Column: 44,
																		Line:   55,
																	},
																},
															},
															Name: "fn",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   55,
																	},
																	File:   "aggregate_fill_window_test.flux",
																	Source: "sum",
																	Start: ast.Position{
																		Column: 48,
																		Line:   55,
																	},
																},
															},
															Name: "sum",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   55,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "aggregateWindow(every: 30s, fn: sum)",
														Start: ast.Position{
															Column: 16,
															Line:   55,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   55,
															},
															File:   "aggregate_fill_window_test.flux",
															Source: "aggregateWindow",
															Start: ast.Position{
																Column: 16,
																Line:   55,
															},
														},
													},
													Name: "aggregateWindow",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   56,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0)",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   56,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "value: 0.0",
														Start: ast.Position{
															Column: 21,
															Line:   56,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   56,
															},
															File:   "aggregate_fill_window_test.flux",
															Source: "value: 0.0",
															Start: ast.Position{
																Column: 21,
																Line:   56,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   56,
																},
																File:   "aggregate_fill_window_test.flux",
																Source: "value",
																Start: ast.Position{
																	Column: 21,
																	Line:   56,
																},
															},
														},
														Name: "value",
													},
													Separator: nil,
													Value: &ast.FloatLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   56,
																},
																File:   "aggregate_fill_window_test.flux",
																Source: "0.0",
																Start: ast.Position{
																	Column: 28,
																	Line:   56,
																},
															},
														},
														Value: 0.0,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   56,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "fill(value: 0.0)",
													Start: ast.Position{
														Column: 16,
														Line:   56,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   56,
														},
														File:   "aggregate_fill_window_test.flux",
														Source: "fill",
														Start: ast.Position{
															Column: 16,
															Line:   56,
														},
													},
												},
												Name: "fill",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "table=<-",
												Start: ast.Position{
													Column: 10,
													Line:   52,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   52,
													},
													File:   "aggregate_fill_window_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   52,
													},
												},
											},
											Name: "table",
										},
										Separator: nil,
										Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   52,
												},
												File:   "aggregate_fill_window_test.flux",
												Source: "<-",
												Start: ast.Position{
													Column: 16,
													Line:   52,
												},
											},
										}},
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   57,
					},
					File:   "aggregate_fill_window_test.flux",
					Source: "test aggregate_window_fill = () => ({\r\n    input: testing.loadStorage(csv: inData),\r\n    want: testing.loadMem(csv: outData),\r\n    fn: (table=<-) =>\r\n        table\r\n            |> range(start: 2018-05-22T19:53:26Z, stop: 2018-05-22T19:55:00Z)\r\n            |> aggregateWindow(every: 30s, fn: sum)\r\n            |> fill(value: 0.0),\r\n})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_fill_window_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_fill_window_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_fill_window_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_fill_window_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   42,
				},
				File:   "aggregate_window_max_test.flux",
				Source: "package universe_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n\"\naggregate_window = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: max))\n\ntest _aggregate_window = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "aggregate_window_max_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "aggregate_window_max_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   39,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "aggregate_window = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: max))",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   36,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "aggregate_window",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "aggregate_window",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   39,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: max))",
						Start: ast.Position{
							Column: 20,
							Line:   36,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   39,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: max))",
							Start: ast.Position{
								Column: 2,
								Line:   37,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   37,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   37,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   38,
									},
									File:   "aggregate_window_max_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   37,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   38,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   38,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   38,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "start: 2018-05-22T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   38,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   38,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   38,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   38,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   38,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "stop: 2018-05-22T00:01:00Z",
												Start: ast.Position{
													Column: 41,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   38,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 41,
														Line:   38,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   38,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "2018-05-22T00:01:00Z",
													Start: ast.Position{
														Column: 47,
														Line:   38,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:01:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   38,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   38,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   38,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   38,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   39,
								},
								File:   "aggregate_window_max_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: max)",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   39,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "every: 30s, fn: max",
										Start: ast.Position{
											Column: 22,
											Line:   39,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   39,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "every: 30s",
											Start: ast.Position{
												Column: 22,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   39,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "every",
												Start: ast.Position{
													Column: 22,
													Line:   39,
												},
											},
										},
										Name: "every",
									},
									Separator: nil,
									Value: &ast.DurationLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   39,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "30s",
												Start: ast.Position{
													Column: 29,
													Line:   39,
												},
											},
										},
										Values: []ast.Duration{ast.Duration{
											Magnitude: int64(30),
											Unit:      "s",
										}},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   39,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "fn: max",
											Start: ast.Position{
												Column: 34,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   39,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 34,
													Line:   39,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   39,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "max",
												Start: ast.Position{
													Column: 38,
													Line:   39,
												},
											},
										},
										Name: "max",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   39,
									},
									File:   "aggregate_window_max_test.flux",
									Source: "aggregateWindow(every: 30s, fn: max)",
									Start: ast.Position{
										Column: 6,
										Line:   39,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   39,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "aggregateWindow",
										Start: ast.Position{
											Column: 6,
											Line:   39,
										},
									},
								},
								Name: "aggregateWindow",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   36,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   36,
								},
								File:   "aggregate_window_max_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   36,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   36,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   36,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   42,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "_aggregate_window = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
						Start: ast.Position{
							Column: 6,
							Line:   41,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   41,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "_aggregate_window",
							Start: ast.Position{
								Column: 6,
								Line:   41,
							},
						},
					},
					Name: "_aggregate_window",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   42,
							},
							File:   "aggregate_window_max_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
							Start: ast.Position{
								Column: 26,
								Line:   41,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   42,
								},
								File:   "aggregate_window_max_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
								Start: ast.Position{
									Column: 2,
									Line:   42,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   42,
									},
									File:   "aggregate_window_max_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window}",
									Start: ast.Position{
										Column: 3,
										Line:   42,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   42,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   42,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   42,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   42,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   42,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   42,
														},
														File:   "aggregate_window_max_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   42,
														},
														File:   "aggregate_window_max_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   42,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   42,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   42,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   42,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   42,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   42,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   42,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   42,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   42,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   42,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   42,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   42,
														},
														File:   "aggregate_window_max_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   42,
														},
														File:   "aggregate_window_max_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   42,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   42,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   42,
												},
												File:   "aggregate_window_max_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   42,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   42,
													},
													File:   "aggregate_window_max_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   42,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   42,
										},
										File:   "aggregate_window_max_test.flux",
										Source: "fn: aggregate_window",
										Start: ast.Position{
											Column: 82,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   42,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   42,
											},
											File:   "aggregate_window_max_test.flux",
											Source: "aggregate_window",
											Start: ast.Position{
												Column: 86,
												Line:   42,
											},
										},
									},
									Name: "aggregate_window",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   42,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "test _aggregate_window = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_max_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_window_max_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_window_max_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 3,
					Line:   48,
				},
				File:   "aggregate_window_median_test.flux",
				Source: "package universe_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:44:58Z,7.940387008821781\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:08Z,49.460104214779086\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:18Z,-36.564150808873954\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:28Z,34.319039251798635\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:38Z,79.27019811403116\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:48Z,41.91029522104053\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:44:58Z,-61.68790887989735\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:08Z,-6.3173755351186465\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:18Z,-26.049728557657513\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:28Z,114.285955884979\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:38Z,16.140262630578995\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:48Z,29.50336437998469\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:00Z,7.940387008821781\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:30Z,34.319039251798635\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:46:00Z,60.590246667535845\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:00Z,-61.68790887989735\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:30Z,-6.3173755351186465\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:46:00Z,22.821813505281843\n\"\n\nt_aggregate_window_median = (table=<-) =>\n\ttable\n\t\t|> range(start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z)\n    |> aggregateWindow(every: 30s, fn: median)\n\ntest _aggregate_window_median = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_window_median,\n})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:44:58Z,7.940387008821781\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:08Z,49.460104214779086\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:18Z,-36.564150808873954\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:28Z,34.319039251798635\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:38Z,79.27019811403116\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:48Z,41.91029522104053\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:44:58Z,-61.68790887989735\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:08Z,-6.3173755351186465\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:18Z,-26.049728557657513\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:28Z,114.285955884979\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:38Z,16.140262630578995\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:48Z,29.50336437998469\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "\"\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:44:58Z,7.940387008821781\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:08Z,49.460104214779086\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:18Z,-36.564150808873954\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:28Z,34.319039251798635\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:38Z,79.27019811403116\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:48Z,41.91029522104053\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:44:58Z,-61.68790887989735\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:08Z,-6.3173755351186465\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:18Z,-26.049728557657513\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:28Z,114.285955884979\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:38Z,16.140262630578995\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:48Z,29.50336437998469\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,false,false\n#default,_result,,,,,,\n,result,table,_measurement,_field,t0,_time,_value\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:44:58Z,7.940387008821781\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:08Z,49.460104214779086\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:18Z,-36.564150808873954\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:28Z,34.319039251798635\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:38Z,79.27019811403116\n,,0,Reiva,OAOJWe7,BnR,2019-01-09T19:45:48Z,41.91029522104053\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:44:58Z,-61.68790887989735\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:08Z,-6.3173755351186465\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:18Z,-26.049728557657513\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:28Z,114.285955884979\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:38Z,16.140262630578995\n,,1,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:48Z,29.50336437998469\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:00Z,7.940387008821781\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:30Z,34.319039251798635\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:46:00Z,60.590246667535845\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:00Z,-61.68790887989735\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:30Z,-6.3173755351186465\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:46:00Z,22.821813505281843\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:00Z,7.940387008821781\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:30Z,34.319039251798635\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:46:00Z,60.590246667535845\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:00Z,-61.68790887989735\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:30Z,-6.3173755351186465\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:46:00Z,22.821813505281843\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,true,true,true,false,false\n#default,_result,,,,,,,,\n,result,table,_start,_stop,_measurement,_field,t0,_time,_value\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:00Z,7.940387008821781\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:45:30Z,34.319039251798635\n,,0,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,BnR,2019-01-09T19:46:00Z,60.590246667535845\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:00Z,-61.68790887989735\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:45:30Z,-6.3173755351186465\n,,1,2019-01-09T19:44:30Z,2019-01-09T19:46:00Z,Reiva,OAOJWe7,qCnJDC,2019-01-09T19:46:00Z,22.821813505281843\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 47,
						Line:   42,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "t_aggregate_window_median = (table=<-) =>\n\ttable\n\t\t|> range(start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z)\n    |> aggregateWindow(every: 30s, fn: median)",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   39,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "t_aggregate_window_median",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "t_aggregate_window_median",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   42,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "(table=<-) =>\n\ttable\n\t\t|> range(start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z)\n    |> aggregateWindow(every: 30s, fn: median)",
						Start: ast.Position{
							Column: 29,
							Line:   39,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   40,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 2,
										Line:   40,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   41,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "table\n\t\t|> range(start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z)",
								Start: ast.Position{
									Column: 2,
									Line:   40,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   41,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   41,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "start: 2019-01-09T19:44:30Z",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   41,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 12,
													Line:   41,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   41,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "2019-01-09T19:44:30Z",
												Start: ast.Position{
													Column: 19,
													Line:   41,
												},
											},
										},
										Value: parser.MustParseTime("2019-01-09T19:44:30Z"),
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   41,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "stop: 2019-01-09T19:46:00Z",
											Start: ast.Position{
												Column: 41,
												Line:   41,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   41,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 41,
													Line:   41,
												},
											},
										},
										Name: "stop",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   41,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "2019-01-09T19:46:00Z",
												Start: ast.Position{
													Column: 47,
													Line:   41,
												},
											},
										},
										Value: parser.MustParseTime("2019-01-09T19:46:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   41,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "range(start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z)",
									Start: ast.Position{
										Column: 6,
										Line:   41,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   41,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 6,
											Line:   41,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   42,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "table\n\t\t|> range(start: 2019-01-09T19:44:30Z, stop: 2019-01-09T19:46:00Z)\n    |> aggregateWindow(every: 30s, fn: median)",
							Start: ast.Position{
								Column: 2,
								Line:   40,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   42,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "every: 30s, fn: median",
									Start: ast.Position{
										Column: 24,
										Line:   42,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   42,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "every: 30s",
										Start: ast.Position{
											Column: 24,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   42,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "every",
											Start: ast.Position{
												Column: 24,
												Line:   42,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.DurationLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   42,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "30s",
											Start: ast.Position{
												Column: 31,
												Line:   42,
											},
										},
									},
									Values: []ast.Duration{ast.Duration{
										Magnitude: int64(30),
										Unit:      "s",
									}},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   42,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "fn: median",
										Start: ast.Position{
											Column: 36,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   42,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 36,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   42,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "median",
											Start: ast.Position{
												Column: 40,
												Line:   42,
											},
										},
									},
									Name: "median",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   42,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "aggregateWindow(every: 30s, fn: median)",
								Start: ast.Position{
									Column: 8,
									Line:   42,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   42,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "aggregateWindow",
									Start: ast.Position{
										Column: 8,
										Line:   42,
									},
								},
							},
							Name: "aggregateWindow",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   39,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 30,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   39,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 30,
									Line:   39,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   39,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 36,
								Line:   39,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   48,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "_aggregate_window_median = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_window_median,\n})",
						Start: ast.Position{
							Column: 6,
							Line:   44,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   44,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "_aggregate_window_median",
							Start: ast.Position{
								Column: 6,
								Line:   44,
							},
						},
					},
					Name: "_aggregate_window_median",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   48,
							},
							File:   "aggregate_window_median_test.flux",
							Source: "() => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_window_median,\n})",
							Start: ast.Position{
								Column: 33,
								Line:   44,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   48,
								},
								File:   "aggregate_window_median_test.flux",
								Source: "({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_window_median,\n})",
								Start: ast.Position{
									Column: 39,
									Line:   44,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   48,
									},
									File:   "aggregate_window_median_test.flux",
									Source: "{\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_window_median,\n}",
									Start: ast.Position{
										Column: 40,
										Line:   44,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   45,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 2,
											Line:   45,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   45,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 2,
												Line:   45,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   45,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 29,
													Line:   45,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   45,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 29,
														Line:   45,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   45,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 29,
															Line:   45,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   45,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 34,
															Line:   45,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   45,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 9,
												Line:   45,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   45,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 9,
													Line:   45,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   45,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 9,
														Line:   45,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   45,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 17,
														Line:   45,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   46,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 2,
											Line:   46,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   46,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 2,
												Line:   46,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   46,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 24,
													Line:   46,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   46,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 24,
														Line:   46,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   46,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 24,
															Line:   46,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   46,
														},
														File:   "aggregate_window_median_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 29,
															Line:   46,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   46,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 8,
												Line:   46,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   46,
												},
												File:   "aggregate_window_median_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 8,
													Line:   46,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   46,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 8,
														Line:   46,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 23,
														Line:   46,
													},
													File:   "aggregate_window_median_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 16,
														Line:   46,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   47,
										},
										File:   "aggregate_window_median_test.flux",
										Source: "fn: t_aggregate_window_median",
										Start: ast.Position{
											Column: 2,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 4,
												Line:   47,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 2,
												Line:   47,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   47,
											},
											File:   "aggregate_window_median_test.flux",
											Source: "t_aggregate_window_median",
											Start: ast.Position{
												Column: 6,
												Line:   47,
											},
										},
									},
									Name: "t_aggregate_window_median",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 3,
						Line:   48,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "test _aggregate_window_median = () => ({\n\tinput: testing.loadStorage(csv: inData),\n\twant: testing.loadMem(csv: outData),\n\tfn: t_aggregate_window_median,\n})",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_median_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_window_median_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_window_median_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   42,
				},
				File:   "aggregate_window_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n\"\naggregate_window = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: mean))\n\ntest _aggregate_window = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "aggregate_window_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "aggregate_window_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "aggregate_window_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "aggregate_window_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "aggregate_window_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "aggregate_window_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "aggregate_window_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "aggregate_window_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "aggregate_window_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,30,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,1,2018-05-22T00:00:00Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:10Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:20Z,35,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:30Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:40Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n,,1,2018-05-22T00:00:50Z,45,used_percent,disk,disk1s1,apfs,host.local,/tmp\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   35,
					},
					File:   "aggregate_window_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "aggregate_window_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   35,
						},
						File:   "aggregate_window_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,double\n#group,false,false,true,true,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_field,_measurement,device,fstype,host,path,_value\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/,30\n,,0,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/,40\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:00:30Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,35\n,,1,2018-05-22T00:00:00Z,2018-05-22T00:01:00Z,2018-05-22T00:01:00Z,used_percent,disk,disk1s1,apfs,host.local,/tmp,45\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 44,
						Line:   39,
					},
					File:   "aggregate_window_test.flux",
					Source: "aggregate_window = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: mean))",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   36,
						},
						File:   "aggregate_window_test.flux",
						Source: "aggregate_window",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "aggregate_window",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   39,
						},
						File:   "aggregate_window_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: mean))",
						Start: ast.Position{
							Column: 20,
							Line:   36,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   39,
							},
							File:   "aggregate_window_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: mean))",
							Start: ast.Position{
								Column: 2,
								Line:   37,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   37,
										},
										File:   "aggregate_window_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   37,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   38,
									},
									File:   "aggregate_window_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   37,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   38,
											},
											File:   "aggregate_window_test.flux",
											Source: "start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   38,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   38,
												},
												File:   "aggregate_window_test.flux",
												Source: "start: 2018-05-22T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   38,
													},
													File:   "aggregate_window_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   38,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   38,
													},
													File:   "aggregate_window_test.flux",
													Source: "2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   38,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   38,
												},
												File:   "aggregate_window_test.flux",
												Source: "stop: 2018-05-22T00:01:00Z",
												Start: ast.Position{
													Column: 41,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   38,
													},
													File:   "aggregate_window_test.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 41,
														Line:   38,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   38,
													},
													File:   "aggregate_window_test.flux",
													Source: "2018-05-22T00:01:00Z",
													Start: ast.Position{
														Column: 47,
														Line:   38,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T00:01:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   38,
										},
										File:   "aggregate_window_test.flux",
										Source: "range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   38,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   38,
											},
											File:   "aggregate_window_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   38,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   39,
								},
								File:   "aggregate_window_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T00:00:00Z, stop: 2018-05-22T00:01:00Z)\n\t\t|> aggregateWindow(every: 30s, fn: mean)",
								Start: ast.Position{
									Column: 3,
									Line:   37,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   39,
										},
										File:   "aggregate_window_test.flux",
										Source: "every: 30s, fn: mean",
										Start: ast.Position{
											Column: 22,
											Line:   39,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   39,
											},
											File:   "aggregate_window_test.flux",
											Source: "every: 30s",
											Start: ast.Position{
												Column: 22,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   39,
												},
												File:   "aggregate_window_test.flux",
												Source: "every",
												Start: ast.Position{
													Column: 22,
													Line:   39,
												},
											},
										},
										Name: "every",
									},
									Separator: nil,
									Value: &ast.DurationLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   39,
												},
												File:   "aggregate_window_test.flux",
												Source: "30s",
												Start: ast.Position{
													Column: 29,
													Line:   39,
												},
											},
										},
										Values: []ast.Duration{ast.Duration{
											Magnitude: int64(30),
											Unit:      "s",
										}},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   39,
											},
											File:   "aggregate_window_test.flux",
											Source: "fn: mean",
											Start: ast.Position{
												Column: 34,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   39,
												},
												File:   "aggregate_window_test.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 34,
													Line:   39,
												},
											},
										},
										Name: "fn",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   39,
												},
												File:   "aggregate_window_test.flux",
												Source: "mean",
												Start: ast.Position{
													Column: 38,
													Line:   39,
												},
											},
										},
										Name: "mean",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   39,
									},
									File:   "aggregate_window_test.flux",
									Source: "aggregateWindow(every: 30s, fn: mean)",
									Start: ast.Position{
										Column: 6,
										Line:   39,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   39,
										},
										File:   "aggregate_window_test.flux",
										Source: "aggregateWindow",
										Start: ast.Position{
											Column: 6,
											Line:   39,
										},
									},
								},
								Name: "aggregateWindow",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   36,
							},
							File:   "aggregate_window_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   36,
								},
								File:   "aggregate_window_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   36,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   36,
							},
							File:   "aggregate_window_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   36,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 104,
							Line:   42,
						},
						File:   "aggregate_window_test.flux",
						Source: "_aggregate_window = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
						Start: ast.Position{
							Column: 6,
							Line:   41,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   41,
							},
							File:   "aggregate_window_test.flux",
							Source: "_aggregate_window",
							Start: ast.Position{
								Column: 6,
								Line:   41,
							},
						},
					},
					Name: "_aggregate_window",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 104,
								Line:   42,
							},
							File:   "aggregate_window_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
							Start: ast.Position{
								Column: 26,
								Line:   41,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 104,
									Line:   42,
								},
								File:   "aggregate_window_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
								Start: ast.Position{
									Column: 2,
									Line:   42,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   42,
									},
									File:   "aggregate_window_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window}",
									Start: ast.Position{
										Column: 3,
										Line:   42,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   42,
										},
										File:   "aggregate_window_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   42,
											},
											File:   "aggregate_window_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   42,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   42,
												},
												File:   "aggregate_window_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   42,
													},
													File:   "aggregate_window_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   42,
														},
														File:   "aggregate_window_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   42,
														},
														File:   "aggregate_window_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   42,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   42,
											},
											File:   "aggregate_window_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   42,
												},
												File:   "aggregate_window_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   42,
													},
													File:   "aggregate_window_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   42,
													},
													File:   "aggregate_window_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   42,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   42,
										},
										File:   "aggregate_window_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   42,
											},
											File:   "aggregate_window_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   42,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   42,
												},
												File:   "aggregate_window_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   42,
													},
													File:   "aggregate_window_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   42,
														},
														File:   "aggregate_window_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   42,
														},
														File:   "aggregate_window_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   42,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   42,
											},
											File:   "aggregate_window_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   42,
												},
												File:   "aggregate_window_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   42,
													},
													File:   "aggregate_window_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   42,
													},
													File:   "aggregate_window_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   42,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   42,
										},
										File:   "aggregate_window_test.flux",
										Source: "fn: aggregate_window",
										Start: ast.Position{
											Column: 82,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   42,
											},
											File:   "aggregate_window_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   42,
											},
											File:   "aggregate_window_test.flux",
											Source: "aggregate_window",
											Start: ast.Position{
												Column: 86,
												Line:   42,
											},
										},
									},
									Name: "aggregate_window",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 104,
						Line:   42,
					},
					File:   "aggregate_window_test.flux",
					Source: "test _aggregate_window = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: aggregate_window})",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "aggregate_window_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "aggregate_window_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "aggregate_window_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "aggregate_window_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "aggregate_window_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 94,
					Line:   76,
				},
				File:   "cmo_test.flux",
				Source: "package universe_test\n\nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:00Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:10Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:30Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:40Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,15,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:01:40Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,0,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,-20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,-40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,-60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,-80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n\"\n\ncmo = (table=<-) =>\n    (table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> chandeMomentumOscillator(n:10))\n\ntest _cmo = () =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: cmo})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "cmo_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "cmo_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "cmo_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "cmo_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "cmo_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "cmo_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   41,
					},
					File:   "cmo_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:00Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:10Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:30Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:40Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,15,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "cmo_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   41,
						},
						File:   "cmo_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:00Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:10Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:30Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:40Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,15,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:00:00Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:10Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:30Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:40Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:00:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:00Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:10Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:30Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:40Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,15,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,14,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,13,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,12,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,11,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,10,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,9,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,8,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,7,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,6,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,5,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,4,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,3,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,2,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,1,used_percent,disk,disk1s1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   67,
					},
					File:   "cmo_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:01:40Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,0,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,-20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,-40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,-60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,-80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   43,
						},
						File:   "cmo_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   43,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   67,
						},
						File:   "cmo_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:01:40Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,0,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,-20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,-40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,-60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,-80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   43,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T00:01:40Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:01:50Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:00Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:10Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:20Z,100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:30Z,80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:40Z,60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:02:50Z,40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:00Z,20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:10Z,0,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:20Z,-20,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:30Z,-40,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:40Z,-60,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:03:50Z,-80,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:00Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:10Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:20Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:30Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n,,0,2018-05-22T00:04:40Z,-100,used_percent,disk,disk1s1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   73,
					},
					File:   "cmo_test.flux",
					Source: "cmo = (table=<-) =>\n    (table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> chandeMomentumOscillator(n:10))",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   69,
						},
						File:   "cmo_test.flux",
						Source: "cmo",
						Start: ast.Position{
							Column: 1,
							Line:   69,
						},
					},
				},
				Name: "cmo",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   73,
						},
						File:   "cmo_test.flux",
						Source: "(table=<-) =>\n    (table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> chandeMomentumOscillator(n:10))",
						Start: ast.Position{
							Column: 7,
							Line:   69,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   73,
							},
							File:   "cmo_test.flux",
							Source: "(table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> chandeMomentumOscillator(n:10))",
							Start: ast.Position{
								Column: 5,
								Line:   70,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   70,
											},
											File:   "cmo_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 6,
												Line:   70,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   71,
										},
										File:   "cmo_test.flux",
										Source: "table\n        |> range(start:2018-05-22T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   70,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   71,
												},
												File:   "cmo_test.flux",
												Source: "start:2018-05-22T00:00:00Z",
												Start: ast.Position{
													Column: 18,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   71,
													},
													File:   "cmo_test.flux",
													Source: "start:2018-05-22T00:00:00Z",
													Start: ast.Position{
														Column: 18,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   71,
														},
														File:   "cmo_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 18,
															Line:   71,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   71,
														},
														File:   "cmo_test.flux",
														Source: "2018-05-22T00:00:00Z",
														Start: ast.Position{
															Column: 24,
															Line:   71,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T00:00:00Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   71,
											},
											File:   "cmo_test.flux",
											Source: "range(start:2018-05-22T00:00:00Z)",
											Start: ast.Position{
												Column: 12,
												Line:   71,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   71,
												},
												File:   "cmo_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 12,
													Line:   71,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   72,
									},
									File:   "cmo_test.flux",
									Source: "table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 6,
										Line:   70,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   72,
											},
											File:   "cmo_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 17,
												Line:   72,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   72,
												},
												File:   "cmo_test.flux",
												Source: "columns: [\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 17,
													Line:   72,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   72,
													},
													File:   "cmo_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 17,
														Line:   72,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   72,
													},
													File:   "cmo_test.flux",
													Source: "[\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 26,
														Line:   72,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   72,
														},
														File:   "cmo_test.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 27,
															Line:   72,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   72,
														},
														File:   "cmo_test.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 37,
															Line:   72,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   72,
										},
										File:   "cmo_test.flux",
										Source: "drop(columns: [\"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 12,
											Line:   72,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   72,
											},
											File:   "cmo_test.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 12,
												Line:   72,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   73,
								},
								File:   "cmo_test.flux",
								Source: "table\n        |> range(start:2018-05-22T00:00:00Z)\n        |> drop(columns: [\"_start\", \"_stop\"])\n        |> chandeMomentumOscillator(n:10)",
								Start: ast.Position{
									Column: 6,
									Line:   70,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   73,
										},
										File:   "cmo_test.flux",
										Source: "n:10",
										Start: ast.Position{
											Column: 37,
											Line:   73,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   73,
											},
											File:   "cmo_test.flux",
											Source: "n:10",
											Start: ast.Position{
												Column: 37,
												Line:   73,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   73,
												},
												File:   "cmo_test.flux",
												Source: "n",
												Start: ast.Position{
													Column: 37,
													Line:   73,
												},
											},
										},
										Name: "n",
									},
									Separator: nil,
									Value: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   73,
												},
												File:   "cmo_test.flux",
												Source: "10",
												Start: ast.Position{
													Column: 39,
													Line:   73,
												},
											},
										},
										Value: int64(10),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   73,
									},
									File:   "cmo_test.flux",
									Source: "chandeMomentumOscillator(n:10)",
									Start: ast.Position{
										Column: 12,
										Line:   73,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   73,
										},
										File:   "cmo_test.flux",
										Source: "chandeMomentumOscillator",
										Start: ast.Position{
											Column: 12,
											Line:   73,
										},
									},
								},
								Name: "chandeMomentumOscillator",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   69,
							},
							File:   "cmo_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 8,
								Line:   69,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   69,
								},
								File:   "cmo_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 8,
									Line:   69,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   69,
							},
							File:   "cmo_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 14,
								Line:   69,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   76,
						},
						File:   "cmo_test.flux",
						Source: "_cmo = () =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: cmo})",
						Start: ast.Position{
							Column: 6,
							Line:   75,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   75,
							},
							File:   "cmo_test.flux",
							Source: "_cmo",
							Start: ast.Position{
								Column: 6,
								Line:   75,
							},
						},
					},
					Name: "_cmo",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   76,
							},
							File:   "cmo_test.flux",
							Source: "() =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: cmo})",
							Start: ast.Position{
								Column: 13,
								Line:   75,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   76,
								},
								File:   "cmo_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: cmo})",
								Start: ast.Position{
									Column: 5,
									Line:   76,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 93,
										Line:   76,
									},
									File:   "cmo_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: cmo}",
									Start: ast.Position{
										Column: 6,
										Line:   76,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   76,
										},
										File:   "cmo_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 7,
											Line:   76,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   76,
											},
											File:   "cmo_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 7,
												Line:   76,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   76,
												},
												File:   "cmo_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 34,
													Line:   76,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   76,
													},
													File:   "cmo_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 34,
														Line:   76,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   76,
														},
														File:   "cmo_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 34,
															Line:   76,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 45,
															Line:   76,
														},
														File:   "cmo_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 39,
															Line:   76,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   76,
											},
											File:   "cmo_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 14,
												Line:   76,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   76,
												},
												File:   "cmo_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 14,
													Line:   76,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   76,
													},
													File:   "cmo_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 14,
														Line:   76,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   76,
													},
													File:   "cmo_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 22,
														Line:   76,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   76,
										},
										File:   "cmo_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 48,
											Line:   76,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   76,
											},
											File:   "cmo_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 48,
												Line:   76,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   76,
												},
												File:   "cmo_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 70,
													Line:   76,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   76,
													},
													File:   "cmo_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 70,
														Line:   76,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   76,
														},
														File:   "cmo_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 70,
															Line:   76,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   76,
														},
														File:   "cmo_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 75,
															Line:   76,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   76,
											},
											File:   "cmo_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 54,
												Line:   76,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   76,
												},
												File:   "cmo_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 54,
													Line:   76,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   76,
													},
													File:   "cmo_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 54,
														Line:   76,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   76,
													},
													File:   "cmo_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 62,
														Line:   76,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   76,
										},
										File:   "cmo_test.flux",
										Source: "fn: cmo",
										Start: ast.Position{
											Column: 85,
											Line:   76,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   76,
											},
											File:   "cmo_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 85,
												Line:   76,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   76,
											},
											File:   "cmo_test.flux",
											Source: "cmo",
											Start: ast.Position{
												Column: 89,
												Line:   76,
											},
										},
									},
									Name: "cmo",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 94,
						Line:   76,
					},
					File:   "cmo_test.flux",
					Source: "test _cmo = () =>\n    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: cmo})",
					Start: ast.Position{
						Column: 1,
						Line:   75,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "cmo_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "cmo_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "cmo_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "cmo_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "cmo_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 97,
					Line:   57,
				},
				File:   "columns_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,name,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_field\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_measurement\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_start\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_stop\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_time\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,host\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,name\n\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_field\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_measurement\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_start\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_stop\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_time\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_value\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,host\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,name\n\"\n\nt_columns = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-20T19:53:26Z)\n\t\t|> columns())\n\t\t|> sort()\n\ntest _columns = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_columns})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "columns_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "columns_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "columns_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "columns_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "columns_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "columns_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "columns_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "columns_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "columns_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,false,false,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   48,
					},
					File:   "columns_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,name,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_field\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_measurement\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_start\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_stop\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_time\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,host\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,name\n\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_field\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_measurement\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_start\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_stop\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_time\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_value\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,host\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,name\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   26,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   26,
						},
						File:   "columns_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   26,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   48,
						},
						File:   "columns_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,name,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_field\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_measurement\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_start\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_stop\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_time\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,host\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,name\n\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_field\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_measurement\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_start\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_stop\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_time\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_value\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,host\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,name\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   26,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,string\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,host,name,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_field\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_measurement\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_start\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_stop\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_time\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,_value\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,host\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk0,name\n\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_field\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_measurement\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_start\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_stop\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_time\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,_value\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,host\n,,1,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,host.local,disk2,name\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   54,
					},
					File:   "columns_test.flux",
					Source: "t_columns = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-20T19:53:26Z)\n\t\t|> columns())\n\t\t|> sort()",
					Start: ast.Position{
						Column: 1,
						Line:   50,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   50,
						},
						File:   "columns_test.flux",
						Source: "t_columns",
						Start: ast.Position{
							Column: 1,
							Line:   50,
						},
					},
				},
				Name: "t_columns",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   54,
						},
						File:   "columns_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-20T19:53:26Z)\n\t\t|> columns())\n\t\t|> sort()",
						Start: ast.Position{
							Column: 13,
							Line:   50,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   53,
								},
								File:   "columns_test.flux",
								Source: "(table\n\t\t|> range(start: 2018-05-20T19:53:26Z)\n\t\t|> columns())",
								Start: ast.Position{
									Column: 2,
									Line:   51,
								},
							},
						},
						Expression: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   51,
											},
											File:   "columns_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 3,
												Line:   51,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   52,
										},
										File:   "columns_test.flux",
										Source: "table\n\t\t|> range(start: 2018-05-20T19:53:26Z)",
										Start: ast.Position{
											Column: 3,
											Line:   51,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   52,
												},
												File:   "columns_test.flux",
												Source: "start: 2018-05-20T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   52,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   52,
													},
													File:   "columns_test.flux",
													Source: "start: 2018-05-20T19:53:26Z",
													Start: ast.Position{
														Column: 12,
														Line:   52,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   52,
														},
														File:   "columns_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 12,
															Line:   52,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   52,
														},
														File:   "columns_test.flux",
														Source: "2018-05-20T19:53:26Z",
														Start: ast.Position{
															Column: 19,
															Line:   52,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-20T19:53:26Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   52,
											},
											File:   "columns_test.flux",
											Source: "range(start: 2018-05-20T19:53:26Z)",
											Start: ast.Position{
												Column: 6,
												Line:   52,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   52,
												},
												File:   "columns_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 6,
													Line:   52,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   53,
									},
									File:   "columns_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-20T19:53:26Z)\n\t\t|> columns()",
									Start: ast.Position{
										Column: 3,
										Line:   51,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   53,
										},
										File:   "columns_test.flux",
										Source: "columns()",
										Start: ast.Position{
											Column: 6,
											Line:   53,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   53,
											},
											File:   "columns_test.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 6,
												Line:   53,
											},
										},
									},
									Name: "columns",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Rparen: nil,
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   54,
							},
							File:   "columns_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-20T19:53:26Z)\n\t\t|> columns())\n\t\t|> sort()",
							Start: ast.Position{
								Column: 2,
								Line:   51,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   54,
								},
								File:   "columns_test.flux",
								Source: "sort()",
								Start: ast.Position{
									Column: 6,
									Line:   54,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   54,
									},
									File:   "columns_test.flux",
									Source: "sort",
									Start: ast.Position{
										Column: 6,
										Line:   54,
									},
								},
							},
							Name: "sort",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   50,
							},
							File:   "columns_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 14,
								Line:   50,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   50,
								},
								File:   "columns_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 14,
									Line:   50,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   50,
							},
							File:   "columns_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   50,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   57,
						},
						File:   "columns_test.flux",
						Source: "_columns = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_columns})",
						Start: ast.Position{
							Column: 6,
							Line:   56,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   56,
							},
							File:   "columns_test.flux",
							Source: "_columns",
							Start: ast.Position{
								Column: 6,
								Line:   56,
							},
						},
					},
					Name: "_columns",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   57,
							},
							File:   "columns_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_columns})",
							Start: ast.Position{
								Column: 17,
								Line:   56,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   57,
								},
								File:   "columns_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_columns})",
								Start: ast.Position{
									Column: 2,
									Line:   57,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   57,
									},
									File:   "columns_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_columns}",
									Start: ast.Position{
										Column: 3,
										Line:   57,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   57,
										},
										File:   "columns_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   57,
											},
											File:   "columns_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   57,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   57,
												},
												File:   "columns_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   57,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   57,
													},
													File:   "columns_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   57,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   57,
														},
														File:   "columns_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   57,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   57,
														},
														File:   "columns_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   57,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   57,
											},
											File:   "columns_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   57,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   57,
												},
												File:   "columns_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   57,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   57,
													},
													File:   "columns_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   57,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   57,
													},
													File:   "columns_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   57,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   57,
										},
										File:   "columns_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   57,
											},
											File:   "columns_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   57,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   57,
												},
												File:   "columns_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   57,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   57,
													},
													File:   "columns_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   57,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   57,
														},
														File:   "columns_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   57,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   57,
														},
														File:   "columns_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   57,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   57,
											},
											File:   "columns_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   57,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   57,
												},
												File:   "columns_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   57,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   57,
													},
													File:   "columns_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   57,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   57,
													},
													File:   "columns_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   57,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   57,
										},
										File:   "columns_test.flux",
										Source: "fn: t_columns",
										Start: ast.Position{
											Column: 82,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   57,
											},
											File:   "columns_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   57,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   57,
											},
											File:   "columns_test.flux",
											Source: "t_columns",
											Start: ast.Position{
												Column: 86,
												Line:   57,
											},
										},
									},
									Name: "t_columns",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 97,
						Line:   57,
					},
					File:   "columns_test.flux",
					Source: "test _columns = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_columns})",
					Start: ast.Position{
						Column: 1,
						Line:   56,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "columns_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "columns_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "columns_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "columns_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "columns_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 95,
					Line:   82,
				},
				File:   "count_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,unsignedLong\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,0,iZquGj,Au1iY,2018-12-18T20:52:33Z,7\n,,0,iZquGj,Au1iY,2018-12-18T20:52:43Z,38\n,,0,iZquGj,Au1iY,2018-12-18T20:52:53Z,79\n,,0,iZquGj,Au1iY,2018-12-18T20:53:03Z,51\n,,0,iZquGj,Au1iY,2018-12-18T20:53:13Z,94\n,,0,iZquGj,Au1iY,2018-12-18T20:53:23Z,85\n\n#datatype,string,long,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,1,iZquGj,HSbYC,2018-12-18T20:52:33Z,A9JcEV\n,,1,iZquGj,HSbYC,2018-12-18T20:52:43Z,iNI7Bqy\n,,1,iZquGj,HSbYC,2018-12-18T20:52:53Z,TFIS\n,,1,iZquGj,HSbYC,2018-12-18T20:53:03Z,q6h9yU\n,,1,iZquGj,HSbYC,2018-12-18T20:53:13Z,X8Ks\n,,1,iZquGj,HSbYC,2018-12-18T20:53:23Z,aOMgU\n\n#datatype,string,long,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,2,iZquGj,J1u,2018-12-18T20:52:33Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:43Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:53Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:03Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:13Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:23Z,false\n\n#datatype,string,long,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:33Z,-61.68790887989735\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:43Z,-6.3173755351186465\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:53Z,-26.049728557657513\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:03Z,114.285955884979\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:13Z,16.140262630578995\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:23Z,29.50336437998469\n\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:33Z,-66\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:43Z,59\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:53Z,64\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:03Z,84\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:13Z,68\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:23Z,49\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_field,_value\n,,0,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,Au1iY,6\n,,1,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,HSbYC,6\n,,2,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,J1u,6\n,,3,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ei77f8T,6\n,,4,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ucyoZ,6\n\"\n\nt_count = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-01T00:00:00Z)\n\t\t|> count())\n\ntest _count = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_count})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "count_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "count_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "count_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "count_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "count_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "count_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   62,
					},
					File:   "count_test.flux",
					Source: "inData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,unsignedLong\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,0,iZquGj,Au1iY,2018-12-18T20:52:33Z,7\n,,0,iZquGj,Au1iY,2018-12-18T20:52:43Z,38\n,,0,iZquGj,Au1iY,2018-12-18T20:52:53Z,79\n,,0,iZquGj,Au1iY,2018-12-18T20:53:03Z,51\n,,0,iZquGj,Au1iY,2018-12-18T20:53:13Z,94\n,,0,iZquGj,Au1iY,2018-12-18T20:53:23Z,85\n\n#datatype,string,long,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,1,iZquGj,HSbYC,2018-12-18T20:52:33Z,A9JcEV\n,,1,iZquGj,HSbYC,2018-12-18T20:52:43Z,iNI7Bqy\n,,1,iZquGj,HSbYC,2018-12-18T20:52:53Z,TFIS\n,,1,iZquGj,HSbYC,2018-12-18T20:53:03Z,q6h9yU\n,,1,iZquGj,HSbYC,2018-12-18T20:53:13Z,X8Ks\n,,1,iZquGj,HSbYC,2018-12-18T20:53:23Z,aOMgU\n\n#datatype,string,long,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,2,iZquGj,J1u,2018-12-18T20:52:33Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:43Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:53Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:03Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:13Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:23Z,false\n\n#datatype,string,long,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:33Z,-61.68790887989735\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:43Z,-6.3173755351186465\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:53Z,-26.049728557657513\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:03Z,114.285955884979\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:13Z,16.140262630578995\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:23Z,29.50336437998469\n\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:33Z,-66\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:43Z,59\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:53Z,64\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:03Z,84\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:13Z,68\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:23Z,49\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "count_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   62,
						},
						File:   "count_test.flux",
						Source: "\"\n#datatype,string,long,string,string,dateTime:RFC3339,unsignedLong\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,0,iZquGj,Au1iY,2018-12-18T20:52:33Z,7\n,,0,iZquGj,Au1iY,2018-12-18T20:52:43Z,38\n,,0,iZquGj,Au1iY,2018-12-18T20:52:53Z,79\n,,0,iZquGj,Au1iY,2018-12-18T20:53:03Z,51\n,,0,iZquGj,Au1iY,2018-12-18T20:53:13Z,94\n,,0,iZquGj,Au1iY,2018-12-18T20:53:23Z,85\n\n#datatype,string,long,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,1,iZquGj,HSbYC,2018-12-18T20:52:33Z,A9JcEV\n,,1,iZquGj,HSbYC,2018-12-18T20:52:43Z,iNI7Bqy\n,,1,iZquGj,HSbYC,2018-12-18T20:52:53Z,TFIS\n,,1,iZquGj,HSbYC,2018-12-18T20:53:03Z,q6h9yU\n,,1,iZquGj,HSbYC,2018-12-18T20:53:13Z,X8Ks\n,,1,iZquGj,HSbYC,2018-12-18T20:53:23Z,aOMgU\n\n#datatype,string,long,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,2,iZquGj,J1u,2018-12-18T20:52:33Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:43Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:53Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:03Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:13Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:23Z,false\n\n#datatype,string,long,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:33Z,-61.68790887989735\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:43Z,-6.3173755351186465\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:53Z,-26.049728557657513\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:03Z,114.285955884979\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:13Z,16.140262630578995\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:23Z,29.50336437998469\n\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:33Z,-66\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:43Z,59\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:53Z,64\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:03Z,84\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:13Z,68\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:23Z,49\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,dateTime:RFC3339,unsignedLong\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,0,iZquGj,Au1iY,2018-12-18T20:52:33Z,7\n,,0,iZquGj,Au1iY,2018-12-18T20:52:43Z,38\n,,0,iZquGj,Au1iY,2018-12-18T20:52:53Z,79\n,,0,iZquGj,Au1iY,2018-12-18T20:53:03Z,51\n,,0,iZquGj,Au1iY,2018-12-18T20:53:13Z,94\n,,0,iZquGj,Au1iY,2018-12-18T20:53:23Z,85\n\n#datatype,string,long,string,string,dateTime:RFC3339,string\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,1,iZquGj,HSbYC,2018-12-18T20:52:33Z,A9JcEV\n,,1,iZquGj,HSbYC,2018-12-18T20:52:43Z,iNI7Bqy\n,,1,iZquGj,HSbYC,2018-12-18T20:52:53Z,TFIS\n,,1,iZquGj,HSbYC,2018-12-18T20:53:03Z,q6h9yU\n,,1,iZquGj,HSbYC,2018-12-18T20:53:13Z,X8Ks\n,,1,iZquGj,HSbYC,2018-12-18T20:53:23Z,aOMgU\n\n#datatype,string,long,string,string,dateTime:RFC3339,boolean\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,2,iZquGj,J1u,2018-12-18T20:52:33Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:43Z,false\n,,2,iZquGj,J1u,2018-12-18T20:52:53Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:03Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:13Z,true\n,,2,iZquGj,J1u,2018-12-18T20:53:23Z,false\n\n#datatype,string,long,string,string,dateTime:RFC3339,double\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:33Z,-61.68790887989735\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:43Z,-6.3173755351186465\n,,3,iZquGj,ei77f8T,2018-12-18T20:52:53Z,-26.049728557657513\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:03Z,114.285955884979\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:13Z,16.140262630578995\n,,3,iZquGj,ei77f8T,2018-12-18T20:53:23Z,29.50336437998469\n\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_measurement,_field,_time,_value\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:33Z,-66\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:43Z,59\n,,4,iZquGj,ucyoZ,2018-12-18T20:52:53Z,64\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:03Z,84\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:13Z,68\n,,4,iZquGj,ucyoZ,2018-12-18T20:53:23Z,49\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   74,
					},
					File:   "count_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_field,_value\n,,0,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,Au1iY,6\n,,1,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,HSbYC,6\n,,2,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,J1u,6\n,,3,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ei77f8T,6\n,,4,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ucyoZ,6\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   64,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   64,
						},
						File:   "count_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   64,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   74,
						},
						File:   "count_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_field,_value\n,,0,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,Au1iY,6\n,,1,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,HSbYC,6\n,,2,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,J1u,6\n,,3,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ei77f8T,6\n,,4,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ucyoZ,6\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   64,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,true,true,false\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_field,_value\n,,0,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,Au1iY,6\n,,1,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,HSbYC,6\n,,2,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,J1u,6\n,,3,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ei77f8T,6\n,,4,2018-12-01T00:00:00Z,2030-01-01T00:00:00Z,iZquGj,ucyoZ,6\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   79,
					},
					File:   "count_test.flux",
					Source: "t_count = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-01T00:00:00Z)\n\t\t|> count())",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   76,
						},
						File:   "count_test.flux",
						Source: "t_count",
						Start: ast.Position{
							Column: 1,
							Line:   76,
						},
					},
				},
				Name: "t_count",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   79,
						},
						File:   "count_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-12-01T00:00:00Z)\n\t\t|> count())",
						Start: ast.Position{
							Column: 11,
							Line:   76,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   79,
							},
							File:   "count_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-12-01T00:00:00Z)\n\t\t|> count())",
							Start: ast.Position{
								Column: 2,
								Line:   77,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   77,
										},
										File:   "count_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   77,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   78,
									},
									File:   "count_test.flux",
									Source: "table\n\t\t|> range(start: 2018-12-01T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   77,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   78,
											},
											File:   "count_test.flux",
											Source: "start: 2018-12-01T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   78,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   78,
												},
												File:   "count_test.flux",
												Source: "start: 2018-12-01T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   78,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   78,
													},
													File:   "count_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   78,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   78,
													},
													File:   "count_test.flux",
													Source: "2018-12-01T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   78,
													},
												},
											},
											Value: parser.MustParseTime("2018-12-01T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   78,
										},
										File:   "count_test.flux",
										Source: "range(start: 2018-12-01T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   78,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   78,
											},
											File:   "count_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   78,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   79,
								},
								File:   "count_test.flux",
								Source: "table\n\t\t|> range(start: 2018-12-01T00:00:00Z)\n\t\t|> count()",
								Start: ast.Position{
									Column: 3,
									Line:   77,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   79,
									},
									File:   "count_test.flux",
									Source: "count()",
									Start: ast.Position{
										Column: 6,
										Line:   79,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   79,
										},
										File:   "count_test.flux",
										Source: "count",
										Start: ast.Position{
											Column: 6,
											Line:   79,
										},
									},
								},
								Name: "count",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   76,
							},
							File:   "count_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 12,
								Line:   76,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   76,
								},
								File:   "count_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 12,
									Line:   76,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   76,
							},
							File:   "count_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 18,
								Line:   76,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 95,
							Line:   82,
						},
						File:   "count_test.flux",
						Source: "_count = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_count})",
						Start: ast.Position{
							Column: 6,
							Line:   81,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   81,
							},
							File:   "count_test.flux",
							Source: "_count",
							Start: ast.Position{
								Column: 6,
								Line:   81,
							},
						},
					},
					Name: "_count",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   82,
							},
							File:   "count_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_count})",
							Start: ast.Position{
								Column: 15,
								Line:   81,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   82,
								},
								File:   "count_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_count})",
								Start: ast.Position{
									Column: 2,
									Line:   82,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   82,
									},
									File:   "count_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_count}",
									Start: ast.Position{
										Column: 3,
										Line:   82,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   82,
										},
										File:   "count_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   82,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   82,
											},
											File:   "count_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   82,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   82,
												},
												File:   "count_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   82,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   82,
													},
													File:   "count_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   82,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   82,
														},
														File:   "count_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   82,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   82,
														},
														File:   "count_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   82,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   82,
											},
											File:   "count_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   82,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   82,
												},
												File:   "count_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   82,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   82,
													},
													File:   "count_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   82,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   82,
													},
													File:   "count_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   82,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   82,
										},
										File:   "count_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   82,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   82,
											},
											File:   "count_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   82,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   82,
												},
												File:   "count_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   82,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   82,
													},
													File:   "count_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   82,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   82,
														},
														File:   "count_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   82,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   82,
														},
														File:   "count_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   82,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   82,
											},
											File:   "count_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   82,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   82,
												},
												File:   "count_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   82,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   82,
													},
													File:   "count_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   82,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   82,
													},
													File:   "count_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   82,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 93,
											Line:   82,
										},
										File:   "count_test.flux",
										Source: "fn: t_count",
										Start: ast.Position{
											Column: 82,
											Line:   82,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   82,
											},
											File:   "count_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   82,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 93,
												Line:   82,
											},
											File:   "count_test.flux",
											Source: "t_count",
											Start: ast.Position{
												Column: 86,
												Line:   82,
											},
										},
									},
									Name: "t_count",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 95,
						Line:   82,
					},
					File:   "count_test.flux",
					Source: "test _count = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_count})",
					Start: ast.Position{
						Column: 1,
						Line:   81,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "count_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "count_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "count_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "count_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "count_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 93,
					Line:   56,
				},
				File:   "cov_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_measurement,user,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1,f1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1,f1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2,f1\n,,1,2018-05-22T19:53:36Z,20,CPU,user2,f1\n,,1,2018-05-22T19:53:46Z,7,CPU,user2,f1\n,,1,2018-05-22T19:53:56Z,10,CPU,user2,f1\n,,2,2018-05-22T19:53:26Z,1,RAM,user1,f1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1,f1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1,f1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1,f1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2,f1\n,,3,2018-05-22T19:53:36Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:46Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:56Z,0,RAM,user2,f1\n,,3,2018-05-22T19:54:06Z,2,RAM,user2,f1\n,,3,2018-05-22T19:54:16Z,10,RAM,user2,f1\n\"\n\noutData = \"\n#datatype,string,long,string,double\n#group,false,false,true,false\n#default,_result,,,\n,result,table,_measurement,_value\n,,0,CPU,8\n,,1,RAM,-1.8333333333333333\n\"\n\nt_cov = (table=<-) => {\n    t1 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    t2 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    return cov(x: t1, y: t2, on: [\"_time\", \"_measurement\"])\n}\n\ntest _cov = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cov})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "cov_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "cov_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "cov_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "cov_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "cov_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "cov_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   28,
					},
					File:   "cov_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_measurement,user,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1,f1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1,f1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2,f1\n,,1,2018-05-22T19:53:36Z,20,CPU,user2,f1\n,,1,2018-05-22T19:53:46Z,7,CPU,user2,f1\n,,1,2018-05-22T19:53:56Z,10,CPU,user2,f1\n,,2,2018-05-22T19:53:26Z,1,RAM,user1,f1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1,f1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1,f1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1,f1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2,f1\n,,3,2018-05-22T19:53:36Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:46Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:56Z,0,RAM,user2,f1\n,,3,2018-05-22T19:54:06Z,2,RAM,user2,f1\n,,3,2018-05-22T19:54:16Z,10,RAM,user2,f1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "cov_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   28,
						},
						File:   "cov_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_measurement,user,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1,f1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1,f1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2,f1\n,,1,2018-05-22T19:53:36Z,20,CPU,user2,f1\n,,1,2018-05-22T19:53:46Z,7,CPU,user2,f1\n,,1,2018-05-22T19:53:56Z,10,CPU,user2,f1\n,,2,2018-05-22T19:53:26Z,1,RAM,user1,f1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1,f1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1,f1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1,f1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2,f1\n,,3,2018-05-22T19:53:36Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:46Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:56Z,0,RAM,user2,f1\n,,3,2018-05-22T19:54:06Z,2,RAM,user2,f1\n,,3,2018-05-22T19:54:16Z,10,RAM,user2,f1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string,string,string\n#group,false,false,false,false,true,true,true\n#default,_result,,,,,,\n,result,table,_time,_value,_measurement,user,_field\n,,0,2018-05-22T19:53:26Z,0,CPU,user1,f1\n,,0,2018-05-22T19:53:36Z,1,CPU,user1,f1\n,,1,2018-05-22T19:53:26Z,4,CPU,user2,f1\n,,1,2018-05-22T19:53:36Z,20,CPU,user2,f1\n,,1,2018-05-22T19:53:46Z,7,CPU,user2,f1\n,,1,2018-05-22T19:53:56Z,10,CPU,user2,f1\n,,2,2018-05-22T19:53:26Z,1,RAM,user1,f1\n,,2,2018-05-22T19:53:36Z,2,RAM,user1,f1\n,,2,2018-05-22T19:53:46Z,3,RAM,user1,f1\n,,2,2018-05-22T19:53:56Z,5,RAM,user1,f1\n,,3,2018-05-22T19:53:26Z,2,RAM,user2,f1\n,,3,2018-05-22T19:53:36Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:46Z,4,RAM,user2,f1\n,,3,2018-05-22T19:53:56Z,0,RAM,user2,f1\n,,3,2018-05-22T19:54:06Z,2,RAM,user2,f1\n,,3,2018-05-22T19:54:16Z,10,RAM,user2,f1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   37,
					},
					File:   "cov_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,double\n#group,false,false,true,false\n#default,_result,,,\n,result,table,_measurement,_value\n,,0,CPU,8\n,,1,RAM,-1.8333333333333333\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "cov_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   37,
						},
						File:   "cov_test.flux",
						Source: "\"\n#datatype,string,long,string,double\n#group,false,false,true,false\n#default,_result,,,\n,result,table,_measurement,_value\n,,0,CPU,8\n,,1,RAM,-1.8333333333333333\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#datatype,string,long,string,double\n#group,false,false,true,false\n#default,_result,,,\n,result,table,_measurement,_value\n,,0,CPU,8\n,,1,RAM,-1.8333333333333333\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   53,
					},
					File:   "cov_test.flux",
					Source: "t_cov = (table=<-) => {\n    t1 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    t2 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    return cov(x: t1, y: t2, on: [\"_time\", \"_measurement\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   39,
						},
						File:   "cov_test.flux",
						Source: "t_cov",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "t_cov",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   53,
						},
						File:   "cov_test.flux",
						Source: "(table=<-) => {\n    t1 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    t2 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    return cov(x: t1, y: t2, on: [\"_time\", \"_measurement\"])\n}",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   53,
							},
							File:   "cov_test.flux",
							Source: "{\n    t1 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    t2 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")\n\t\t|> group(columns: [\"_measurement\"])\n\n    return cov(x: t1, y: t2, on: [\"_time\", \"_measurement\"])\n}",
							Start: ast.Position{
								Column: 23,
								Line:   39,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   44,
								},
								File:   "cov_test.flux",
								Source: "t1 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")\n\t\t|> group(columns: [\"_measurement\"])",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   40,
									},
									File:   "cov_test.flux",
									Source: "t1",
									Start: ast.Position{
										Column: 5,
										Line:   40,
									},
								},
							},
							Name: "t1",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   40,
													},
													File:   "cov_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   40,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   41,
												},
												File:   "cov_test.flux",
												Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)",
												Start: ast.Position{
													Column: 10,
													Line:   40,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   41,
														},
														File:   "cov_test.flux",
														Source: "start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z",
														Start: ast.Position{
															Column: 12,
															Line:   41,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   41,
															},
															File:   "cov_test.flux",
															Source: "start: 2018-05-22T19:53:00Z",
															Start: ast.Position{
																Column: 12,
																Line:   41,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   41,
																},
																File:   "cov_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 12,
																	Line:   41,
																},
															},
														},
														Name: "start",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   41,
																},
																File:   "cov_test.flux",
																Source: "2018-05-22T19:53:00Z",
																Start: ast.Position{
																	Column: 19,
																	Line:   41,
																},
															},
														},
														Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   41,
															},
															File:   "cov_test.flux",
															Source: "stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 41,
																Line:   41,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   41,
																},
																File:   "cov_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 41,
																	Line:   41,
																},
															},
														},
														Name: "stop",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   41,
																},
																File:   "cov_test.flux",
																Source: "2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 47,
																	Line:   41,
																},
															},
														},
														Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   41,
													},
													File:   "cov_test.flux",
													Source: "range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 6,
														Line:   41,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   41,
														},
														File:   "cov_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 6,
															Line:   41,
														},
													},
												},
												Name: "range",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   42,
											},
											File:   "cov_test.flux",
											Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])",
											Start: ast.Position{
												Column: 10,
												Line:   40,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   42,
													},
													File:   "cov_test.flux",
													Source: "columns: [\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 11,
														Line:   42,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   42,
														},
														File:   "cov_test.flux",
														Source: "columns: [\"_start\", \"_stop\"]",
														Start: ast.Position{
															Column: 11,
															Line:   42,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   42,
															},
															File:   "cov_test.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 11,
																Line:   42,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   42,
															},
															File:   "cov_test.flux",
															Source: "[\"_start\", \"_stop\"]",
															Start: ast.Position{
																Column: 20,
																Line:   42,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   42,
																},
																File:   "cov_test.flux",
																Source: "\"_start\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   42,
																},
															},
														},
														Value: "_start",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   42,
																},
																File:   "cov_test.flux",
																Source: "\"_stop\"",
																Start: ast.Position{
																	Column: 31,
																	Line:   42,
																},
															},
														},
														Value: "_stop",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   42,
												},
												File:   "cov_test.flux",
												Source: "drop(columns: [\"_start\", \"_stop\"])",
												Start: ast.Position{
													Column: 6,
													Line:   42,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   42,
													},
													File:   "cov_test.flux",
													Source: "drop",
													Start: ast.Position{
														Column: 6,
														Line:   42,
													},
												},
											},
											Name: "drop",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   43,
										},
										File:   "cov_test.flux",
										Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")",
										Start: ast.Position{
											Column: 10,
											Line:   40,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   43,
												},
												File:   "cov_test.flux",
												Source: "fn: (r) => r.user == \"user1\"",
												Start: ast.Position{
													Column: 13,
													Line:   43,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   43,
													},
													File:   "cov_test.flux",
													Source: "fn: (r) => r.user == \"user1\"",
													Start: ast.Position{
														Column: 13,
														Line:   43,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   43,
														},
														File:   "cov_test.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 13,
															Line:   43,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   43,
														},
														File:   "cov_test.flux",
														Source: "(r) => r.user == \"user1\"",
														Start: ast.Position{
															Column: 17,
															Line:   43,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   43,
															},
															File:   "cov_test.flux",
															Source: "r.user == \"user1\"",
															Start: ast.Position{
																Column: 24,
																Line:   43,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   43,
																},
																File:   "cov_test.flux",
																Source: "r.user",
																Start: ast.Position{
																	Column: 24,
																	Line:   43,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   43,
																	},
																	File:   "cov_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   43,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   43,
																	},
																	File:   "cov_test.flux",
																	Source: "user",
																	Start: ast.Position{
																		Column: 26,
																		Line:   43,
																	},
																},
															},
															Name: "user",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   43,
																},
																File:   "cov_test.flux",
																Source: "\"user1\"",
																Start: ast.Position{
																	Column: 34,
																	Line:   43,
																},
															},
														},
														Value: "user1",
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   43,
															},
															File:   "cov_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 18,
																Line:   43,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   43,
																},
																File:   "cov_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 18,
																	Line:   43,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   43,
											},
											File:   "cov_test.flux",
											Source: "filter(fn: (r) => r.user == \"user1\")",
											Start: ast.Position{
												Column: 6,
												Line:   43,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   43,
												},
												File:   "cov_test.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 6,
													Line:   43,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   44,
									},
									File:   "cov_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user1\")\n\t\t|> group(columns: [\"_measurement\"])",
									Start: ast.Position{
										Column: 10,
										Line:   40,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   44,
											},
											File:   "cov_test.flux",
											Source: "columns: [\"_measurement\"]",
											Start: ast.Position{
												Column: 12,
												Line:   44,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   44,
												},
												File:   "cov_test.flux",
												Source: "columns: [\"_measurement\"]",
												Start: ast.Position{
													Column: 12,
													Line:   44,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   44,
													},
													File:   "cov_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 12,
														Line:   44,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   44,
													},
													File:   "cov_test.flux",
													Source: "[\"_measurement\"]",
													Start: ast.Position{
														Column: 21,
														Line:   44,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   44,
														},
														File:   "cov_test.flux",
														Source: "\"_measurement\"",
														Start: ast.Position{
															Column: 22,
															Line:   44,
														},
													},
												},
												Value: "_measurement",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   44,
										},
										File:   "cov_test.flux",
										Source: "group(columns: [\"_measurement\"])",
										Start: ast.Position{
											Column: 6,
											Line:   44,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   44,
											},
											File:   "cov_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 6,
												Line:   44,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   50,
								},
								File:   "cov_test.flux",
								Source: "t2 = table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")\n\t\t|> group(columns: [\"_measurement\"])",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   46,
									},
									File:   "cov_test.flux",
									Source: "t2",
									Start: ast.Position{
										Column: 5,
										Line:   46,
									},
								},
							},
							Name: "t2",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.PipeExpression{
										Argument: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   46,
													},
													File:   "cov_test.flux",
													Source: "table",
													Start: ast.Position{
														Column: 10,
														Line:   46,
													},
												},
											},
											Name: "table",
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   47,
												},
												File:   "cov_test.flux",
												Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)",
												Start: ast.Position{
													Column: 10,
													Line:   46,
												},
											},
										},
										Call: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   47,
														},
														File:   "cov_test.flux",
														Source: "start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z",
														Start: ast.Position{
															Column: 12,
															Line:   47,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   47,
															},
															File:   "cov_test.flux",
															Source: "start: 2018-05-22T19:53:00Z",
															Start: ast.Position{
																Column: 12,
																Line:   47,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   47,
																},
																File:   "cov_test.flux",
																Source: "start",
																Start: ast.Position{
																	Column: 12,
																	Line:   47,
																},
															},
														},
														Name: "start",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 39,
																	Line:   47,
																},
																File:   "cov_test.flux",
																Source: "2018-05-22T19:53:00Z",
																Start: ast.Position{
																	Column: 19,
																	Line:   47,
																},
															},
														},
														Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   47,
															},
															File:   "cov_test.flux",
															Source: "stop: 2018-05-22T19:55:00Z",
															Start: ast.Position{
																Column: 41,
																Line:   47,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 45,
																	Line:   47,
																},
																File:   "cov_test.flux",
																Source: "stop",
																Start: ast.Position{
																	Column: 41,
																	Line:   47,
																},
															},
														},
														Name: "stop",
													},
													Separator: nil,
													Value: &ast.DateTimeLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   47,
																},
																File:   "cov_test.flux",
																Source: "2018-05-22T19:55:00Z",
																Start: ast.Position{
																	Column: 47,
																	Line:   47,
																},
															},
														},
														Value: parser.MustParseTime("2018-05-22T19:55:00Z"),
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   47,
													},
													File:   "cov_test.flux",
													Source: "range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)",
													Start: ast.Position{
														Column: 6,
														Line:   47,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   47,
														},
														File:   "cov_test.flux",
														Source: "range",
														Start: ast.Position{
															Column: 6,
															Line:   47,
														},
													},
												},
												Name: "range",
											},
											Lparen: nil,
											Rparen: nil,
										},
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   48,
											},
											File:   "cov_test.flux",
											Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])",
											Start: ast.Position{
												Column: 10,
												Line:   46,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   48,
													},
													File:   "cov_test.flux",
													Source: "columns: [\"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 11,
														Line:   48,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   48,
														},
														File:   "cov_test.flux",
														Source: "columns: [\"_start\", \"_stop\"]",
														Start: ast.Position{
															Column: 11,
															Line:   48,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   48,
															},
															File:   "cov_test.flux",
															Source: "columns",
															Start: ast.Position{
																Column: 11,
																Line:   48,
															},
														},
													},
													Name: "columns",
												},
												Separator: nil,
												Value: &ast.ArrayExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   48,
															},
															File:   "cov_test.flux",
															Source: "[\"_start\", \"_stop\"]",
															Start: ast.Position{
																Column: 20,
																Line:   48,
															},
														},
													},
													Elements: []ast.Expression{&ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   48,
																},
																File:   "cov_test.flux",
																Source: "\"_start\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   48,
																},
															},
														},
														Value: "_start",
													}, &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   48,
																},
																File:   "cov_test.flux",
																Source: "\"_stop\"",
																Start: ast.Position{
																	Column: 31,
																	Line:   48,
																},
															},
														},
														Value: "_stop",
													}},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   48,
												},
												File:   "cov_test.flux",
												Source: "drop(columns: [\"_start\", \"_stop\"])",
												Start: ast.Position{
													Column: 6,
													Line:   48,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   48,
													},
													File:   "cov_test.flux",
													Source: "drop",
													Start: ast.Position{
														Column: 6,
														Line:   48,
													},
												},
											},
											Name: "drop",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   49,
										},
										File:   "cov_test.flux",
										Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")",
										Start: ast.Position{
											Column: 10,
											Line:   46,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   49,
												},
												File:   "cov_test.flux",
												Source: "fn: (r) => r.user == \"user2\"",
												Start: ast.Position{
													Column: 13,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   49,
													},
													File:   "cov_test.flux",
													Source: "fn: (r) => r.user == \"user2\"",
													Start: ast.Position{
														Column: 13,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   49,
														},
														File:   "cov_test.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 13,
															Line:   49,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   49,
														},
														File:   "cov_test.flux",
														Source: "(r) => r.user == \"user2\"",
														Start: ast.Position{
															Column: 17,
															Line:   49,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   49,
															},
															File:   "cov_test.flux",
															Source: "r.user == \"user2\"",
															Start: ast.Position{
																Column: 24,
																Line:   49,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   49,
																},
																File:   "cov_test.flux",
																Source: "r.user",
																Start: ast.Position{
																	Column: 24,
																	Line:   49,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   49,
																	},
																	File:   "cov_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   49,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   49,
																	},
																	File:   "cov_test.flux",
																	Source: "user",
																	Start: ast.Position{
																		Column: 26,
																		Line:   49,
																	},
																},
															},
															Name: "user",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   49,
																},
																File:   "cov_test.flux",
																Source: "\"user2\"",
																Start: ast.Position{
																	Column: 34,
																	Line:   49,
																},
															},
														},
														Value: "user2",
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 19,
																Line:   49,
															},
															File:   "cov_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 18,
																Line:   49,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 19,
																	Line:   49,
																},
																File:   "cov_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 18,
																	Line:   49,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   49,
											},
											File:   "cov_test.flux",
											Source: "filter(fn: (r) => r.user == \"user2\")",
											Start: ast.Position{
												Column: 6,
												Line:   49,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   49,
												},
												File:   "cov_test.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 6,
													Line:   49,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   50,
									},
									File:   "cov_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:00Z, stop: 2018-05-22T19:55:00Z)\n\t\t|> drop(columns: [\"_start\", \"_stop\"])\n\t\t|> filter(fn: (r) => r.user == \"user2\")\n\t\t|> group(columns: [\"_measurement\"])",
									Start: ast.Position{
										Column: 10,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   50,
											},
											File:   "cov_test.flux",
											Source: "columns: [\"_measurement\"]",
											Start: ast.Position{
												Column: 12,
												Line:   50,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   50,
												},
												File:   "cov_test.flux",
												Source: "columns: [\"_measurement\"]",
												Start: ast.Position{
													Column: 12,
													Line:   50,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   50,
													},
													File:   "cov_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 12,
														Line:   50,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   50,
													},
													File:   "cov_test.flux",
													Source: "[\"_measurement\"]",
													Start: ast.Position{
														Column: 21,
														Line:   50,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   50,
														},
														File:   "cov_test.flux",
														Source: "\"_measurement\"",
														Start: ast.Position{
															Column: 22,
															Line:   50,
														},
													},
												},
												Value: "_measurement",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   50,
										},
										File:   "cov_test.flux",
										Source: "group(columns: [\"_measurement\"])",
										Start: ast.Position{
											Column: 6,
											Line:   50,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   50,
											},
											File:   "cov_test.flux",
											Source: "group",
											Start: ast.Position{
												Column: 6,
												Line:   50,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   52,
										},
										File:   "cov_test.flux",
										Source: "x: t1, y: t2, on: [\"_time\", \"_measurement\"]",
										Start: ast.Position{
											Column: 16,
											Line:   52,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   52,
											},
											File:   "cov_test.flux",
											Source: "x: t1",
											Start: ast.Position{
												Column: 16,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   52,
												},
												File:   "cov_test.flux",
												Source: "x",
												Start: ast.Position{
													Column: 16,
													Line:   52,
												},
											},
										},
										Name: "x",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   52,
												},
												File:   "cov_test.flux",
												Source: "t1",
												Start: ast.Position{
													Column: 19,
													Line:   52,
												},
											},
										},
										Name: "t1",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   52,
											},
											File:   "cov_test.flux",
											Source: "y: t2",
											Start: ast.Position{
												Column: 23,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   52,
												},
												File:   "cov_test.flux",
												Source: "y",
												Start: ast.Position{
													Column: 23,
													Line:   52,
												},
											},
										},
										Name: "y",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   52,
												},
												File:   "cov_test.flux",
												Source: "t2",
												Start: ast.Position{
													Column: 26,
													Line:   52,
												},
											},
										},
										Name: "t2",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   52,
											},
											File:   "cov_test.flux",
											Source: "on: [\"_time\", \"_measurement\"]",
											Start: ast.Position{
												Column: 30,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   52,
												},
												File:   "cov_test.flux",
												Source: "on",
												Start: ast.Position{
													Column: 30,
													Line:   52,
												},
											},
										},
										Name: "on",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   52,
												},
												File:   "cov_test.flux",
												Source: "[\"_time\", \"_measurement\"]",
												Start: ast.Position{
													Column: 34,
													Line:   52,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   52,
													},
													File:   "cov_test.flux",
													Source: "\"_time\"",
													Start: ast.Position{
														Column: 35,
														Line:   52,
													},
												},
											},
											Value: "_time",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   52,
													},
													File:   "cov_test.flux",
													Source: "\"_measurement\"",
													Start: ast.Position{
														Column: 44,
														Line:   52,
													},
												},
											},
											Value: "_measurement",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   52,
									},
									File:   "cov_test.flux",
									Source: "cov(x: t1, y: t2, on: [\"_time\", \"_measurement\"])",
									Start: ast.Position{
										Column: 12,
										Line:   52,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   52,
										},
										File:   "cov_test.flux",
										Source: "cov",
										Start: ast.Position{
											Column: 12,
											Line:   52,
										},
									},
								},
								Name: "cov",
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   52,
								},
								File:   "cov_test.flux",
								Source: "return cov(x: t1, y: t2, on: [\"_time\", \"_measurement\"])",
								Start: ast.Position{
									Column: 5,
									Line:   52,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   39,
							},
							File:   "cov_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   39,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   39,
								},
								File:   "cov_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   39,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   39,
							},
							File:   "cov_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   39,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 93,
							Line:   56,
						},
						File:   "cov_test.flux",
						Source: "_cov = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cov})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   55,
							},
							File:   "cov_test.flux",
							Source: "_cov",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "_cov",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   56,
							},
							File:   "cov_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cov})",
							Start: ast.Position{
								Column: 13,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   56,
								},
								File:   "cov_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cov})",
								Start: ast.Position{
									Column: 2,
									Line:   56,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   56,
									},
									File:   "cov_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cov}",
									Start: ast.Position{
										Column: 3,
										Line:   56,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   56,
										},
										File:   "cov_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   56,
											},
											File:   "cov_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   56,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   56,
												},
												File:   "cov_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   56,
													},
													File:   "cov_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   56,
														},
														File:   "cov_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   56,
														},
														File:   "cov_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   56,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   56,
											},
											File:   "cov_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   56,
												},
												File:   "cov_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   56,
													},
													File:   "cov_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   56,
													},
													File:   "cov_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   56,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   56,
										},
										File:   "cov_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   56,
											},
											File:   "cov_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   56,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   56,
												},
												File:   "cov_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   56,
													},
													File:   "cov_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   56,
														},
														File:   "cov_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   56,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   56,
														},
														File:   "cov_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   56,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   56,
											},
											File:   "cov_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   56,
												},
												File:   "cov_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   56,
													},
													File:   "cov_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   56,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   56,
													},
													File:   "cov_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   56,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   56,
										},
										File:   "cov_test.flux",
										Source: "fn: t_cov",
										Start: ast.Position{
											Column: 82,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   56,
											},
											File:   "cov_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   56,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   56,
											},
											File:   "cov_test.flux",
											Source: "t_cov",
											Start: ast.Position{
												Column: 86,
												Line:   56,
											},
										},
									},
									Name: "t_cov",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 93,
						Line:   56,
					},
					File:   "cov_test.flux",
					Source: "test _cov = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cov})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "cov_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "cov_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "cov_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "cov_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "cov_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 115,
					Line:   32,
				},
				File:   "covariance_missing_column_1_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,x,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n\"\n\noutData = \"\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: y,\n\"\ncovariance_missing_column_1 = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"r\"])\n\t\t|> yield(name: \"0\"))\n\ntest _covariance_missing_column_1 = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_1})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "covariance_missing_column_1_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "covariance_missing_column_1_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   16,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,x,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   16,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,x,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,x,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "outData = \"\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: y,\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   18,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   18,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "\"\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: y,\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   18,
						},
					},
				},
				Value: "\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: y,\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 23,
						Line:   29,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "covariance_missing_column_1 = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"r\"])\n\t\t|> yield(name: \"0\"))",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   25,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "covariance_missing_column_1",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "covariance_missing_column_1",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   29,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"r\"])\n\t\t|> yield(name: \"0\"))",
						Start: ast.Position{
							Column: 31,
							Line:   25,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   29,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"r\"])\n\t\t|> yield(name: \"0\"))",
							Start: ast.Position{
								Column: 2,
								Line:   26,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   26,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 3,
												Line:   26,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   27,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 3,
											Line:   26,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   27,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   27,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   27,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "start: 2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 12,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   27,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 12,
															Line:   27,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   27,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "2018-05-22T19:53:26Z",
														Start: ast.Position{
															Column: 19,
															Line:   27,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   27,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "range(start: 2018-05-22T19:53:26Z)",
											Start: ast.Position{
												Column: 6,
												Line:   27,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   27,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 6,
													Line:   27,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   28,
									},
									File:   "covariance_missing_column_1_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"r\"])",
									Start: ast.Position{
										Column: 3,
										Line:   26,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   28,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "columns: [\"x\", \"r\"]",
											Start: ast.Position{
												Column: 17,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   28,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "columns: [\"x\", \"r\"]",
												Start: ast.Position{
													Column: 17,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   28,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 17,
														Line:   28,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   28,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "[\"x\", \"r\"]",
													Start: ast.Position{
														Column: 26,
														Line:   28,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   28,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "\"x\"",
														Start: ast.Position{
															Column: 27,
															Line:   28,
														},
													},
												},
												Value: "x",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   28,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "\"r\"",
														Start: ast.Position{
															Column: 32,
															Line:   28,
														},
													},
												},
												Value: "r",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   28,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "covariance(columns: [\"x\", \"r\"])",
										Start: ast.Position{
											Column: 6,
											Line:   28,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   28,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "covariance",
											Start: ast.Position{
												Column: 6,
												Line:   28,
											},
										},
									},
									Name: "covariance",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   29,
								},
								File:   "covariance_missing_column_1_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"r\"])\n\t\t|> yield(name: \"0\")",
								Start: ast.Position{
									Column: 3,
									Line:   26,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   29,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "name: \"0\"",
										Start: ast.Position{
											Column: 12,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   29,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "name: \"0\"",
											Start: ast.Position{
												Column: 12,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   29,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "name",
												Start: ast.Position{
													Column: 12,
													Line:   29,
												},
											},
										},
										Name: "name",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   29,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "\"0\"",
												Start: ast.Position{
													Column: 18,
													Line:   29,
												},
											},
										},
										Value: "0",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   29,
									},
									File:   "covariance_missing_column_1_test.flux",
									Source: "yield(name: \"0\")",
									Start: ast.Position{
										Column: 6,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   29,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "yield",
										Start: ast.Position{
											Column: 6,
											Line:   29,
										},
									},
								},
								Name: "yield",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   25,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 32,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   25,
								},
								File:   "covariance_missing_column_1_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 32,
									Line:   25,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   25,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   25,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 115,
							Line:   32,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "_covariance_missing_column_1 = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_1})",
						Start: ast.Position{
							Column: 6,
							Line:   31,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   31,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "_covariance_missing_column_1",
							Start: ast.Position{
								Column: 6,
								Line:   31,
							},
						},
					},
					Name: "_covariance_missing_column_1",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   32,
							},
							File:   "covariance_missing_column_1_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_1})",
							Start: ast.Position{
								Column: 37,
								Line:   31,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   32,
								},
								File:   "covariance_missing_column_1_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_1})",
								Start: ast.Position{
									Column: 2,
									Line:   32,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 114,
										Line:   32,
									},
									File:   "covariance_missing_column_1_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_1}",
									Start: ast.Position{
										Column: 3,
										Line:   32,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   32,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   32,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   32,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   32,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   32,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   32,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   32,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   32,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   32,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   32,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   32,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   32,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   32,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   32,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   32,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   32,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   32,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   32,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   32,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   32,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   32,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   32,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   32,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   32,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   32,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   32,
														},
														File:   "covariance_missing_column_1_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   32,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   32,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   32,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   32,
												},
												File:   "covariance_missing_column_1_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   32,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   32,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   32,
													},
													File:   "covariance_missing_column_1_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   32,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 113,
											Line:   32,
										},
										File:   "covariance_missing_column_1_test.flux",
										Source: "fn: covariance_missing_column_1",
										Start: ast.Position{
											Column: 82,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   32,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   32,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   32,
											},
											File:   "covariance_missing_column_1_test.flux",
											Source: "covariance_missing_column_1",
											Start: ast.Position{
												Column: 86,
												Line:   32,
											},
										},
									},
									Name: "covariance_missing_column_1",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 115,
						Line:   32,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "test _covariance_missing_column_1 = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_1})",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "covariance_missing_column_1_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "covariance_missing_column_1_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "covariance_missing_column_1_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 115,
					Line:   32,
				},
				File:   "covariance_missing_column_2_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,y,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n\"\n\noutData = \"\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: x,\n\"\ncovariance_missing_column_2 = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])\n\t\t|> yield(name: \"0\"))\n\ntest _covariance_missing_column_2 = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_2})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "covariance_missing_column_2_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "covariance_missing_column_2_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   16,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,y,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   16,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,y,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,string\n#group,false,false,false,false,true\n#default,_result,,,,\n,result,table,_time,y,_measurement\n,,0,2018-05-22T19:53:26Z,0,cpu\n,,0,2018-05-22T19:53:36Z,0,cpu\n,,0,2018-05-22T19:53:46Z,2,cpu\n,,0,2018-05-22T19:53:56Z,7,cpu\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   24,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "outData = \"\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: x,\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   18,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   18,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   24,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "\"\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: x,\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   18,
						},
					},
				},
				Value: "\n#datatype,string,string\n#group,true,true\n#default,,\n,error,reference\n,specified column does not exist in table: x,\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 23,
						Line:   29,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "covariance_missing_column_2 = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])\n\t\t|> yield(name: \"0\"))",
					Start: ast.Position{
						Column: 1,
						Line:   25,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   25,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "covariance_missing_column_2",
						Start: ast.Position{
							Column: 1,
							Line:   25,
						},
					},
				},
				Name: "covariance_missing_column_2",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   29,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])\n\t\t|> yield(name: \"0\"))",
						Start: ast.Position{
							Column: 31,
							Line:   25,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   29,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])\n\t\t|> yield(name: \"0\"))",
							Start: ast.Position{
								Column: 2,
								Line:   26,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 8,
												Line:   26,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "table",
											Start: ast.Position{
												Column: 3,
												Line:   26,
											},
										},
									},
									Name: "table",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   27,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 3,
											Line:   26,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   27,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   27,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   27,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "start: 2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 12,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   27,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "start",
														Start: ast.Position{
															Column: 12,
															Line:   27,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value: &ast.DateTimeLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   27,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "2018-05-22T19:53:26Z",
														Start: ast.Position{
															Column: 19,
															Line:   27,
														},
													},
												},
												Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   27,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "range(start: 2018-05-22T19:53:26Z)",
											Start: ast.Position{
												Column: 6,
												Line:   27,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   27,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "range",
												Start: ast.Position{
													Column: 6,
													Line:   27,
												},
											},
										},
										Name: "range",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   28,
									},
									File:   "covariance_missing_column_2_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])",
									Start: ast.Position{
										Column: 3,
										Line:   26,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   28,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "columns: [\"x\", \"y\"]",
											Start: ast.Position{
												Column: 17,
												Line:   28,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   28,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "columns: [\"x\", \"y\"]",
												Start: ast.Position{
													Column: 17,
													Line:   28,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   28,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 17,
														Line:   28,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   28,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "[\"x\", \"y\"]",
													Start: ast.Position{
														Column: 26,
														Line:   28,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   28,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "\"x\"",
														Start: ast.Position{
															Column: 27,
															Line:   28,
														},
													},
												},
												Value: "x",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   28,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "\"y\"",
														Start: ast.Position{
															Column: 32,
															Line:   28,
														},
													},
												},
												Value: "y",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   28,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "covariance(columns: [\"x\", \"y\"])",
										Start: ast.Position{
											Column: 6,
											Line:   28,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   28,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "covariance",
											Start: ast.Position{
												Column: 6,
												Line:   28,
											},
										},
									},
									Name: "covariance",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   29,
								},
								File:   "covariance_missing_column_2_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])\n\t\t|> yield(name: \"0\")",
								Start: ast.Position{
									Column: 3,
									Line:   26,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   29,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "name: \"0\"",
										Start: ast.Position{
											Column: 12,
											Line:   29,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   29,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "name: \"0\"",
											Start: ast.Position{
												Column: 12,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   29,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "name",
												Start: ast.Position{
													Column: 12,
													Line:   29,
												},
											},
										},
										Name: "name",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   29,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "\"0\"",
												Start: ast.Position{
													Column: 18,
													Line:   29,
												},
											},
										},
										Value: "0",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   29,
									},
									File:   "covariance_missing_column_2_test.flux",
									Source: "yield(name: \"0\")",
									Start: ast.Position{
										Column: 6,
										Line:   29,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   29,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "yield",
										Start: ast.Position{
											Column: 6,
											Line:   29,
										},
									},
								},
								Name: "yield",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   25,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 32,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   25,
								},
								File:   "covariance_missing_column_2_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 32,
									Line:   25,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   25,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   25,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 115,
							Line:   32,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "_covariance_missing_column_2 = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_2})",
						Start: ast.Position{
							Column: 6,
							Line:   31,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   31,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "_covariance_missing_column_2",
							Start: ast.Position{
								Column: 6,
								Line:   31,
							},
						},
					},
					Name: "_covariance_missing_column_2",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   32,
							},
							File:   "covariance_missing_column_2_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_2})",
							Start: ast.Position{
								Column: 37,
								Line:   31,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   32,
								},
								File:   "covariance_missing_column_2_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_2})",
								Start: ast.Position{
									Column: 2,
									Line:   32,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 114,
										Line:   32,
									},
									File:   "covariance_missing_column_2_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_2}",
									Start: ast.Position{
										Column: 3,
										Line:   32,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   32,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   32,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   32,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   32,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   32,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   32,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   32,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   32,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   32,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   32,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   32,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   32,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   32,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   32,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   32,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   32,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   32,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   32,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   32,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   32,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   32,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   32,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   32,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   32,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   32,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   32,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   32,
														},
														File:   "covariance_missing_column_2_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   32,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   32,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   32,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   32,
												},
												File:   "covariance_missing_column_2_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   32,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   32,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   32,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   32,
													},
													File:   "covariance_missing_column_2_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   32,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 113,
											Line:   32,
										},
										File:   "covariance_missing_column_2_test.flux",
										Source: "fn: covariance_missing_column_2",
										Start: ast.Position{
											Column: 82,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   32,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   32,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   32,
											},
											File:   "covariance_missing_column_2_test.flux",
											Source: "covariance_missing_column_2",
											Start: ast.Position{
												Column: 86,
												Line:   32,
											},
										},
									},
									Name: "covariance_missing_column_2",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 115,
						Line:   32,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "test _covariance_missing_column_2 = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: covariance_missing_column_2})",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "covariance_missing_column_2_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "covariance_missing_column_2_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "covariance_missing_column_2_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 100,
					Line:   37,
				},
				File:   "covariance_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,double,double,string,string\n#group,false,false,false,false,false,true,true\n#default,_result,,,,,,\n,result,table,_time,x,y,_measurement,_field\n,,0,2018-05-22T19:53:26Z,1,4,cpu,f0\n,,0,2018-05-22T19:53:36Z,2,3,cpu,f0\n,,0,2018-05-22T19:53:46Z,3,2,cpu,f0\n,,0,2018-05-22T19:53:56Z,4,1,cpu,f0\n,,1,2018-05-22T19:53:26Z,10,40,mem,f1\n,,1,2018-05-22T19:53:36Z,20,30,mem,f1\n,,1,2018-05-22T19:53:46Z,30,20,mem,f1\n,,1,2018-05-22T19:53:56Z,40,10,mem,f1\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double,string\n#group,false,false,true,true,true,false,true\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_value,_field\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,cpu,-1.6666666666666667,f0\n,,1,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,mem,-166.66666666666666,f1\n\"\n\nt_covariance = (tables=<-) =>\n\t(tables\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"]))\n\ntest _t_covariance = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_covariance})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "covariance_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "covariance_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "covariance_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "covariance_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "covariance_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "covariance_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "covariance_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,double,double,string,string\n#group,false,false,false,false,false,true,true\n#default,_result,,,,,,\n,result,table,_time,x,y,_measurement,_field\n,,0,2018-05-22T19:53:26Z,1,4,cpu,f0\n,,0,2018-05-22T19:53:36Z,2,3,cpu,f0\n,,0,2018-05-22T19:53:46Z,3,2,cpu,f0\n,,0,2018-05-22T19:53:56Z,4,1,cpu,f0\n,,1,2018-05-22T19:53:26Z,10,40,mem,f1\n,,1,2018-05-22T19:53:36Z,20,30,mem,f1\n,,1,2018-05-22T19:53:46Z,30,20,mem,f1\n,,1,2018-05-22T19:53:56Z,40,10,mem,f1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "covariance_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "covariance_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,double,string,string\n#group,false,false,false,false,false,true,true\n#default,_result,,,,,,\n,result,table,_time,x,y,_measurement,_field\n,,0,2018-05-22T19:53:26Z,1,4,cpu,f0\n,,0,2018-05-22T19:53:36Z,2,3,cpu,f0\n,,0,2018-05-22T19:53:46Z,3,2,cpu,f0\n,,0,2018-05-22T19:53:56Z,4,1,cpu,f0\n,,1,2018-05-22T19:53:26Z,10,40,mem,f1\n,,1,2018-05-22T19:53:36Z,20,30,mem,f1\n,,1,2018-05-22T19:53:46Z,30,20,mem,f1\n,,1,2018-05-22T19:53:56Z,40,10,mem,f1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,double,string,string\n#group,false,false,false,false,false,true,true\n#default,_result,,,,,,\n,result,table,_time,x,y,_measurement,_field\n,,0,2018-05-22T19:53:26Z,1,4,cpu,f0\n,,0,2018-05-22T19:53:36Z,2,3,cpu,f0\n,,0,2018-05-22T19:53:46Z,3,2,cpu,f0\n,,0,2018-05-22T19:53:56Z,4,1,cpu,f0\n,,1,2018-05-22T19:53:26Z,10,40,mem,f1\n,,1,2018-05-22T19:53:36Z,20,30,mem,f1\n,,1,2018-05-22T19:53:46Z,30,20,mem,f1\n,,1,2018-05-22T19:53:56Z,40,10,mem,f1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   29,
					},
					File:   "covariance_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double,string\n#group,false,false,true,true,true,false,true\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_value,_field\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,cpu,-1.6666666666666667,f0\n,,1,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,mem,-166.66666666666666,f1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "covariance_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   29,
						},
						File:   "covariance_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double,string\n#group,false,false,true,true,true,false,true\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_value,_field\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,cpu,-1.6666666666666667,f0\n,,1,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,mem,-166.66666666666666,f1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,double,string\n#group,false,false,true,true,true,false,true\n#default,_result,,,,,,\n,result,table,_start,_stop,_measurement,_value,_field\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,cpu,-1.6666666666666667,f0\n,,1,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,mem,-166.66666666666666,f1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 38,
						Line:   34,
					},
					File:   "covariance_test.flux",
					Source: "t_covariance = (tables=<-) =>\n\t(tables\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"]))",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   31,
						},
						File:   "covariance_test.flux",
						Source: "t_covariance",
						Start: ast.Position{
							Column: 1,
							Line:   31,
						},
					},
				},
				Name: "t_covariance",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   34,
						},
						File:   "covariance_test.flux",
						Source: "(tables=<-) =>\n\t(tables\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"]))",
						Start: ast.Position{
							Column: 16,
							Line:   31,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   34,
							},
							File:   "covariance_test.flux",
							Source: "(tables\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"]))",
							Start: ast.Position{
								Column: 2,
								Line:   32,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   32,
										},
										File:   "covariance_test.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 3,
											Line:   32,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   33,
									},
									File:   "covariance_test.flux",
									Source: "tables\n\t\t|> range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 3,
										Line:   32,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   33,
											},
											File:   "covariance_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 12,
												Line:   33,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   33,
												},
												File:   "covariance_test.flux",
												Source: "start: 2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 12,
													Line:   33,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   33,
													},
													File:   "covariance_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   33,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   33,
													},
													File:   "covariance_test.flux",
													Source: "2018-05-22T19:53:26Z",
													Start: ast.Position{
														Column: 19,
														Line:   33,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   33,
										},
										File:   "covariance_test.flux",
										Source: "range(start: 2018-05-22T19:53:26Z)",
										Start: ast.Position{
											Column: 6,
											Line:   33,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   33,
											},
											File:   "covariance_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   33,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   34,
								},
								File:   "covariance_test.flux",
								Source: "tables\n\t\t|> range(start: 2018-05-22T19:53:26Z)\n\t\t|> covariance(columns: [\"x\", \"y\"])",
								Start: ast.Position{
									Column: 3,
									Line:   32,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   34,
										},
										File:   "covariance_test.flux",
										Source: "columns: [\"x\", \"y\"]",
										Start: ast.Position{
											Column: 17,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   34,
											},
											File:   "covariance_test.flux",
											Source: "columns: [\"x\", \"y\"]",
											Start: ast.Position{
												Column: 17,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   34,
												},
												File:   "covariance_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 17,
													Line:   34,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   34,
												},
												File:   "covariance_test.flux",
												Source: "[\"x\", \"y\"]",
												Start: ast.Position{
													Column: 26,
													Line:   34,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   34,
													},
													File:   "covariance_test.flux",
													Source: "\"x\"",
													Start: ast.Position{
														Column: 27,
														Line:   34,
													},
												},
											},
											Value: "x",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   34,
													},
													File:   "covariance_test.flux",
													Source: "\"y\"",
													Start: ast.Position{
														Column: 32,
														Line:   34,
													},
												},
											},
											Value: "y",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   34,
									},
									File:   "covariance_test.flux",
									Source: "covariance(columns: [\"x\", \"y\"])",
									Start: ast.Position{
										Column: 6,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   34,
										},
										File:   "covariance_test.flux",
										Source: "covariance",
										Start: ast.Position{
											Column: 6,
											Line:   34,
										},
									},
								},
								Name: "covariance",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   31,
							},
							File:   "covariance_test.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 17,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   31,
								},
								File:   "covariance_test.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 17,
									Line:   31,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   31,
							},
							File:   "covariance_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   31,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   37,
						},
						File:   "covariance_test.flux",
						Source: "_t_covariance = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_covariance})",
						Start: ast.Position{
							Column: 6,
							Line:   36,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   36,
							},
							File:   "covariance_test.flux",
							Source: "_t_covariance",
							Start: ast.Position{
								Column: 6,
								Line:   36,
							},
						},
					},
					Name: "_t_covariance",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   37,
							},
							File:   "covariance_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_covariance})",
							Start: ast.Position{
								Column: 22,
								Line:   36,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   37,
								},
								File:   "covariance_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_covariance})",
								Start: ast.Position{
									Column: 2,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   37,
									},
									File:   "covariance_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_covariance}",
									Start: ast.Position{
										Column: 3,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   37,
										},
										File:   "covariance_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   37,
											},
											File:   "covariance_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   37,
												},
												File:   "covariance_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   37,
													},
													File:   "covariance_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   37,
														},
														File:   "covariance_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   37,
														},
														File:   "covariance_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   37,
											},
											File:   "covariance_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   37,
												},
												File:   "covariance_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   37,
													},
													File:   "covariance_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   37,
													},
													File:   "covariance_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   37,
										},
										File:   "covariance_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   37,
											},
											File:   "covariance_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   37,
												},
												File:   "covariance_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   37,
													},
													File:   "covariance_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "covariance_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   37,
														},
														File:   "covariance_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   37,
											},
											File:   "covariance_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   37,
												},
												File:   "covariance_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   37,
													},
													File:   "covariance_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   37,
													},
													File:   "covariance_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   37,
										},
										File:   "covariance_test.flux",
										Source: "fn: t_covariance",
										Start: ast.Position{
											Column: 82,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   37,
											},
											File:   "covariance_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   37,
											},
											File:   "covariance_test.flux",
											Source: "t_covariance",
											Start: ast.Position{
												Column: 86,
												Line:   37,
											},
										},
									},
									Name: "t_covariance",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   37,
					},
					File:   "covariance_test.flux",
					Source: "test _t_covariance = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_covariance})",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "covariance_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "covariance_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "covariance_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "covariance_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "covariance_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 112,
					Line:   71,
				},
				File:   "cumulative_sum_default_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:30Z,_m,QQ,1\n,,1,2018-05-22T19:54:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,2,2018-05-22T19:54:40Z,_m,RR,1\n,,2,2018-05-22T19:53:50Z,_m,RR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-22T19:54:10Z,_m,SR,1\n,,3,2018-05-22T19:54:20Z,_m,SR,1\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,false,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,_field,_value\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,FF,2\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,FF,3\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,FF,4\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,FF,5\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,FF,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,QQ,2\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,3\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,4\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,QQ,5\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,QQ,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,QQ,7\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,8\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,9\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,RR,2\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,RR,3\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,RR,4\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,SR,2\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,SR,3\n\"\n\nt_cumulative_sum_default = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())\n\ntest _cumulative_sum_default = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_default})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "cumulative_sum_default_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "cumulative_sum_default_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:30Z,_m,QQ,1\n,,1,2018-05-22T19:54:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,2,2018-05-22T19:54:40Z,_m,RR,1\n,,2,2018-05-22T19:53:50Z,_m,RR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-22T19:54:10Z,_m,SR,1\n,,3,2018-05-22T19:54:20Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:30Z,_m,QQ,1\n,,1,2018-05-22T19:54:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,2,2018-05-22T19:54:40Z,_m,RR,1\n,,2,2018-05-22T19:53:50Z,_m,RR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-22T19:54:10Z,_m,SR,1\n,,3,2018-05-22T19:54:20Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:30Z,_m,QQ,1\n,,1,2018-05-22T19:54:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,2,2018-05-22T19:54:40Z,_m,RR,1\n,,2,2018-05-22T19:53:50Z,_m,RR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-22T19:54:10Z,_m,SR,1\n,,3,2018-05-22T19:54:20Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   63,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,false,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,_field,_value\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,FF,2\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,FF,3\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,FF,4\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,FF,5\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,FF,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,QQ,2\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,3\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,4\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,QQ,5\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,QQ,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,QQ,7\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,8\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,9\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,RR,2\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,RR,3\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,RR,4\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,SR,2\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,SR,3\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   36,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   63,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,false,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,_field,_value\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,FF,2\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,FF,3\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,FF,4\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,FF,5\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,FF,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,QQ,2\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,3\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,4\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,QQ,5\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,QQ,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,QQ,7\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,8\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,9\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,RR,2\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,RR,3\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,RR,4\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,SR,2\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,SR,3\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,long\n#group,false,false,true,true,false,true,true,false\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,_field,_value\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,FF,2\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,FF,3\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,FF,4\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,FF,5\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,FF,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,QQ,2\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,3\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,4\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,QQ,5\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,QQ,6\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,QQ,7\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,8\n,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,9\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,RR,2\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,RR,3\n,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,RR,4\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,SR,2\n,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,SR,3\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   68,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "t_cumulative_sum_default = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   65,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "t_cumulative_sum_default",
						Start: ast.Position{
							Column: 1,
							Line:   65,
						},
					},
				},
				Name: "t_cumulative_sum_default",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   68,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())",
						Start: ast.Position{
							Column: 28,
							Line:   65,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   68,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())",
							Start: ast.Position{
								Column: 2,
								Line:   66,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   66,
										},
										File:   "cumulative_sum_default_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   66,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   67,
									},
									File:   "cumulative_sum_default_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-15T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   66,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   67,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "start: 2018-05-15T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   67,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   67,
												},
												File:   "cumulative_sum_default_test.flux",
												Source: "start: 2018-05-15T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   67,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   67,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   67,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "2018-05-15T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   67,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-15T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   67,
										},
										File:   "cumulative_sum_default_test.flux",
										Source: "range(start: 2018-05-15T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   67,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   67,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   67,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   68,
								},
								File:   "cumulative_sum_default_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum()",
								Start: ast.Position{
									Column: 3,
									Line:   66,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   68,
									},
									File:   "cumulative_sum_default_test.flux",
									Source: "cumulativeSum()",
									Start: ast.Position{
										Column: 6,
										Line:   68,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   68,
										},
										File:   "cumulative_sum_default_test.flux",
										Source: "cumulativeSum",
										Start: ast.Position{
											Column: 6,
											Line:   68,
										},
									},
								},
								Name: "cumulativeSum",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   65,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 29,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   65,
								},
								File:   "cumulative_sum_default_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 29,
									Line:   65,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   65,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 35,
								Line:   65,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 112,
							Line:   71,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "_cumulative_sum_default = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_default})",
						Start: ast.Position{
							Column: 6,
							Line:   70,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   70,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "_cumulative_sum_default",
							Start: ast.Position{
								Column: 6,
								Line:   70,
							},
						},
					},
					Name: "_cumulative_sum_default",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 112,
								Line:   71,
							},
							File:   "cumulative_sum_default_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_default})",
							Start: ast.Position{
								Column: 32,
								Line:   70,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 112,
									Line:   71,
								},
								File:   "cumulative_sum_default_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_default})",
								Start: ast.Position{
									Column: 2,
									Line:   71,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 111,
										Line:   71,
									},
									File:   "cumulative_sum_default_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_default}",
									Start: ast.Position{
										Column: 3,
										Line:   71,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   71,
										},
										File:   "cumulative_sum_default_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   71,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   71,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   71,
												},
												File:   "cumulative_sum_default_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   71,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   71,
														},
														File:   "cumulative_sum_default_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   71,
														},
														File:   "cumulative_sum_default_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   71,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   71,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   71,
												},
												File:   "cumulative_sum_default_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   71,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   71,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   71,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   71,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   71,
										},
										File:   "cumulative_sum_default_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   71,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   71,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   71,
												},
												File:   "cumulative_sum_default_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   71,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   71,
														},
														File:   "cumulative_sum_default_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   71,
														},
														File:   "cumulative_sum_default_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   71,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   71,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   71,
												},
												File:   "cumulative_sum_default_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   71,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   71,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   71,
													},
													File:   "cumulative_sum_default_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   71,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   71,
										},
										File:   "cumulative_sum_default_test.flux",
										Source: "fn: t_cumulative_sum_default",
										Start: ast.Position{
											Column: 82,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   71,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   71,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   71,
											},
											File:   "cumulative_sum_default_test.flux",
											Source: "t_cumulative_sum_default",
											Start: ast.Position{
												Column: 86,
												Line:   71,
											},
										},
									},
									Name: "t_cumulative_sum_default",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 112,
						Line:   71,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "test _cumulative_sum_default = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_default})",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "cumulative_sum_default_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "cumulative_sum_default_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "cumulative_sum_default_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 109,
					Line:   71,
				},
				File:   "cumulative_sum_noop_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,long,string\n#group,false,false,false,true,false,true\n#default,_result,,,,,\n,result,table,_time,_measurement,values,_field\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:20Z,_m,1,f0\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,string\n#group,false,false,true,true,false,true,false,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,values,_field\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,1,f0\n\"\n\nt_cumulative_sum_noop = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())\n\ntest _cumulative_sum_noop = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_noop})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "cumulative_sum_noop_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "cumulative_sum_noop_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,long,string\n#group,false,false,false,true,false,true\n#default,_result,,,,,\n,result,table,_time,_measurement,values,_field\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:20Z,_m,1,f0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,long,string\n#group,false,false,false,true,false,true\n#default,_result,,,,,\n,result,table,_time,_measurement,values,_field\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:20Z,_m,1,f0\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,long,string\n#group,false,false,false,true,false,true\n#default,_result,,,,,\n,result,table,_time,_measurement,values,_field\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-22T19:54:20Z,_m,1,f0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   63,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,string\n#group,false,false,true,true,false,true,false,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,values,_field\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,1,f0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   36,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   63,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,string\n#group,false,false,true,true,false,true,false,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,values,_field\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,1,f0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,string\n#group,false,false,true,true,false,true,false,true\n#default,_result,,,,,,,\n,result,table,_start,_stop,_time,_measurement,values,_field\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0\n,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,1,f0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   68,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "t_cumulative_sum_noop = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   65,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "t_cumulative_sum_noop",
						Start: ast.Position{
							Column: 1,
							Line:   65,
						},
					},
				},
				Name: "t_cumulative_sum_noop",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   68,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())",
						Start: ast.Position{
							Column: 25,
							Line:   65,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   68,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum())",
							Start: ast.Position{
								Column: 2,
								Line:   66,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   66,
										},
										File:   "cumulative_sum_noop_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 3,
											Line:   66,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   67,
									},
									File:   "cumulative_sum_noop_test.flux",
									Source: "table\n\t\t|> range(start: 2018-05-15T00:00:00Z)",
									Start: ast.Position{
										Column: 3,
										Line:   66,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   67,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "start: 2018-05-15T00:00:00Z",
											Start: ast.Position{
												Column: 12,
												Line:   67,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   67,
												},
												File:   "cumulative_sum_noop_test.flux",
												Source: "start: 2018-05-15T00:00:00Z",
												Start: ast.Position{
													Column: 12,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   67,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 12,
														Line:   67,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   67,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "2018-05-15T00:00:00Z",
													Start: ast.Position{
														Column: 19,
														Line:   67,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-15T00:00:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   67,
										},
										File:   "cumulative_sum_noop_test.flux",
										Source: "range(start: 2018-05-15T00:00:00Z)",
										Start: ast.Position{
											Column: 6,
											Line:   67,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   67,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 6,
												Line:   67,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   68,
								},
								File:   "cumulative_sum_noop_test.flux",
								Source: "table\n\t\t|> range(start: 2018-05-15T00:00:00Z)\n\t\t|> cumulativeSum()",
								Start: ast.Position{
									Column: 3,
									Line:   66,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   68,
									},
									File:   "cumulative_sum_noop_test.flux",
									Source: "cumulativeSum()",
									Start: ast.Position{
										Column: 6,
										Line:   68,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   68,
										},
										File:   "cumulative_sum_noop_test.flux",
										Source: "cumulativeSum",
										Start: ast.Position{
											Column: 6,
											Line:   68,
										},
									},
								},
								Name: "cumulativeSum",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   65,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 26,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   65,
								},
								File:   "cumulative_sum_noop_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 26,
									Line:   65,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   65,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 32,
								Line:   65,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 109,
							Line:   71,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "_cumulative_sum_noop = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_noop})",
						Start: ast.Position{
							Column: 6,
							Line:   70,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   70,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "_cumulative_sum_noop",
							Start: ast.Position{
								Column: 6,
								Line:   70,
							},
						},
					},
					Name: "_cumulative_sum_noop",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   71,
							},
							File:   "cumulative_sum_noop_test.flux",
							Source: "() =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_noop})",
							Start: ast.Position{
								Column: 29,
								Line:   70,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   71,
								},
								File:   "cumulative_sum_noop_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_noop})",
								Start: ast.Position{
									Column: 2,
									Line:   71,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 108,
										Line:   71,
									},
									File:   "cumulative_sum_noop_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_noop}",
									Start: ast.Position{
										Column: 3,
										Line:   71,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   71,
										},
										File:   "cumulative_sum_noop_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 4,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 9,
												Line:   71,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 4,
												Line:   71,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   71,
												},
												File:   "cumulative_sum_noop_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 31,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   71,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 31,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   71,
														},
														File:   "cumulative_sum_noop_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 31,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   71,
														},
														File:   "cumulative_sum_noop_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 36,
															Line:   71,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   71,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 11,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   71,
												},
												File:   "cumulative_sum_noop_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 11,
													Line:   71,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   71,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 11,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   71,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 19,
														Line:   71,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   71,
										},
										File:   "cumulative_sum_noop_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 45,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   71,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 45,
												Line:   71,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   71,
												},
												File:   "cumulative_sum_noop_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 67,
													Line:   71,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   71,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 67,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   71,
														},
														File:   "cumulative_sum_noop_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 67,
															Line:   71,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   71,
														},
														File:   "cumulative_sum_noop_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 72,
															Line:   71,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   71,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 51,
												Line:   71,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   71,
												},
												File:   "cumulative_sum_noop_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 51,
													Line:   71,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   71,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 51,
														Line:   71,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   71,
													},
													File:   "cumulative_sum_noop_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 59,
														Line:   71,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 107,
											Line:   71,
										},
										File:   "cumulative_sum_noop_test.flux",
										Source: "fn: t_cumulative_sum_noop",
										Start: ast.Position{
											Column: 82,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   71,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 82,
												Line:   71,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   71,
											},
											File:   "cumulative_sum_noop_test.flux",
											Source: "t_cumulative_sum_noop",
											Start: ast.Position{
												Column: 86,
												Line:   71,
											},
										},
									},
									Name: "t_cumulative_sum_noop",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 109,
						Line:   71,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "test _cumulative_sum_noop = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum_noop})",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   3,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   3,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "cumulative_sum_noop_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   1,
					},
					File:   "cumulative_sum_noop_test.flux",
					Source: "package universe_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   1,
						},
						File:   "cumulative_sum_noop_test.flux",
						Source: "universe_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "universe_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 104,
					Line:   71,
				},
				File:   "cumulative_sum_test.flux",
				Source: "package universe_test\n \nimport \"testing\"\n\noption now = () => (2030-01-01T00:00:00Z)\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,false,true,false,false,false,true\n#default,_result,,,,,,,\n,result,table,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:40Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:50Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:00Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:10Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:20Z,_m0,1,10,100,f0\n,,1,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:10Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,2,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:30Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:54:40Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:50Z,_m2,1,10,100,f2\n,,3,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:10Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:20Z,_m3,1,10,100,f3\n\"\n\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,true,true,false,true,false,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m0,2,20,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m0,3,30,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m0,4,40,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m0,5,50,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m0,6,60,100,f0\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m1,2,20,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,3,30,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,4,40,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m1,5,50,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m1,6,60,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m1,7,70,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,8,80,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,9,90,100,f1\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m2,2,20,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m2,3,30,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m2,4,40,100,f2\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m3,2,20,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m3,3,30,100,f3\n\"\n\nt_cumulative_sum = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-20T00:00:00Z)\n\t\t|> cumulativeSum(columns: [\"v0\", \"v1\"]))\n\ntest _cumulative_sum = () =>\n\t({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_cumulative_sum})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   5,
						},
						File:   "cumulative_sum_test.flux",
						Source: "now = () => (2030-01-01T00:00:00Z)",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   5,
							},
							File:   "cumulative_sum_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   5,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   5,
							},
							File:   "cumulative_sum_test.flux",
							Source: "() => (2030-01-01T00:00:00Z)",
							Start: ast.Position{
								Column: 14,
								Line:   5,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   5,
								},
								File:   "cumulative_sum_test.flux",
								Source: "(2030-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 20,
									Line:   5,
								},
							},
						},
						Expression: &ast.DateTimeLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   5,
									},
									File:   "cumulative_sum_test.flux",
									Source: "2030-01-01T00:00:00Z",
									Start: ast.Position{
										Column: 21,
										Line:   5,
									},
								},
							},
							Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 42,
						Line:   5,
					},
					File:   "cumulative_sum_test.flux",
					Source: "option now = () => (2030-01-01T00:00:00Z)",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "cumulative_sum_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,false,true,false,false,false,true\n#default,_result,,,,,,,\n,result,table,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:40Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:50Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:00Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:10Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:20Z,_m0,1,10,100,f0\n,,1,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:10Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,2,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:30Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:54:40Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:50Z,_m2,1,10,100,f2\n,,3,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:10Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:20Z,_m3,1,10,100,f3\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   7,
						},
						File:   "cumulative_sum_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   7,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "cumulative_sum_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,false,true,false,false,false,true\n#default,_result,,,,,,,\n,result,table,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:40Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:50Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:00Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:10Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:20Z,_m0,1,10,100,f0\n,,1,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:10Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,2,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:30Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:54:40Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:50Z,_m2,1,10,100,f2\n,,3,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:10Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:20Z,_m3,1,10,100,f3\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   7,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,false,true,false,false,false,true\n#default,_result,,,,,,,\n,result,table,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:40Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:50Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:00Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:10Z,_m0,1,10,100,f0\n,,0,2018-05-22T19:53:20Z,_m0,1,10,100,f0\n,,1,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:10Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:30Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:40Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1\n,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1\n,,2,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:30Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:54:40Z,_m2,1,10,100,f2\n,,2,2018-05-22T19:53:50Z,_m2,1,10,100,f2\n,,3,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:10Z,_m3,1,10,100,f3\n,,3,2018-05-22T19:54:20Z,_m3,1,10,100,f3\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   63,
					},
					File:   "cumulative_sum_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,true,true,false,true,false,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m0,2,20,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m0,3,30,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m0,4,40,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m0,5,50,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m0,6,60,100,f0\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m1,2,20,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,3,30,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,4,40,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m1,5,50,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m1,6,60,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m1,7,70,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,8,80,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,9,90,100,f1\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m2,2,20,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m2,3,30,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m2,4,40,100,f2\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m3,2,20,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m3,3,30,100,f3\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   36,
						},
						File:   "cumulative_sum_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   36,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   63,
						},
						File:   "cumulative_sum_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,true,true,false,true,false,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m0,2,20,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m0,3,30,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m0,4,40,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m0,5,50,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m0,6,60,100,f0\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m1,2,20,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,3,30,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,4,40,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m1,5,50,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m1,6,60,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m1,7,70,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,8,80,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,9,90,100,f1\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m2,2,20,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m2,3,30,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m2,4,40,100,f2\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m3,2,20,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m3,3,30,100,f3\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   36,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,long,long,string\n#group,false,false,true,true,false,true,false,false,false,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_measurement,v0,v1,v2,_field\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m0,1,10,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m0,2,20,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m0,3,30,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m0,4,40,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m0,5,50,100,f0\n,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m0,6,60,100,f0\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m1,1,10,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m1,2,20,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,3,30,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,4,40,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m1,5,50,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m1,6,60,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m1,7,70,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,8,80,100,f1\n,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,9,90,100,f1\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m2,1,10,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m2,2,20,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m2,3,30,100,f2\n,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m2,4,40,100,f2\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m3,1,10,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m3,2,20,100,f3\n,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m3,3,30,100,f3\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   68,
					},
					File:   "cumulative_sum_test.flux",
					Source: "t_cumulative_sum = (table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-20T00:00:00Z)\n\t\t|> cumulativeSum(columns: [\"v0\", \"v1\"]))",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   65,
						},
						File:   "cumulative_sum_test.flux",
						Source: "t_cumulative_sum",
						Start: ast.Position{
							Column: 1,
							Line:   65,
						},
					},
				},
				Name: "t_cumulative_sum",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   68,
						},
						File:   "cumulative_sum_test.flux",
						Source: "(table=<-) =>\n\t(table\n\t\t|> range(start: 2018-05-20T00:00:00Z)\n\t\t|> cumulativeSum(columns: [\"v0\", \"v1\"]))",
						Start: ast.Position{
							Column: 20,
							Line:   65,
						},
					},
				},
				Body: &ast.ParenExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   68,
							},
							File:   "cumulative_sum_test.flux",
							Source: "(table\n\t\t|> range(start: 2018-05-20T00:00:00Z)\n\t\t|> cumulativeSum(columns: [\"v0\", \"v1\"]))",
							Start: ast.Position{
								Column: 2,
								Line:   66,
							},
						},
					},
					Expression: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   66,
										},
										File:   "cumulative_sum_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 