// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/events/v1beta1/generated.proto

/*
	Package v1beta1 is a generated protocol buffer package.

	It is generated from these files:
		k8s.io/api/events/v1beta1/generated.proto

	It has these top-level messages:
		Event
		EventList
		EventSeries
*/
package v1beta1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import k8s_io_api_core_v1 "github.com/ericchiang/k8s/apis/core/v1"
import k8s_io_apimachinery_pkg_apis_meta_v1 "github.com/ericchiang/k8s/apis/meta/v1"
import _ "github.com/ericchiang/k8s/runtime"
import _ "github.com/ericchiang/k8s/runtime/schema"
import _ "github.com/ericchiang/k8s/util/intstr"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system.
type Event struct {
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Required. Time when this Event was first observed.
	EventTime *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime `protobuf:"bytes,2,opt,name=eventTime" json:"eventTime,omitempty"`
	// Data about the Event series this event represents or nil if it's a singleton Event.
	// +optional
	Series *EventSeries `protobuf:"bytes,3,opt,name=series" json:"series,omitempty"`
	// Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
	// +optional
	ReportingController *string `protobuf:"bytes,4,opt,name=reportingController" json:"reportingController,omitempty"`
	// ID of the controller instance, e.g. `kubelet-xyzf`.
	// +optional
	ReportingInstance *string `protobuf:"bytes,5,opt,name=reportingInstance" json:"reportingInstance,omitempty"`
	// What action was taken/failed regarding to the regarding object.
	// +optional
	Action *string `protobuf:"bytes,6,opt,name=action" json:"action,omitempty"`
	// Why the action was taken.
	Reason *string `protobuf:"bytes,7,opt,name=reason" json:"reason,omitempty"`
	// The object this Event is about. In most cases it's an Object reporting controller implements.
	// E.g. ReplicaSetController implements ReplicaSets and this event is emitted because
	// it acts on some changes in a ReplicaSet object.
	// +optional
	Regarding *k8s_io_api_core_v1.ObjectReference `protobuf:"bytes,8,opt,name=regarding" json:"regarding,omitempty"`
	// Optional secondary object for more complex actions. E.g. when regarding object triggers
	// a creation or deletion of related object.
	// +optional
	Related *k8s_io_api_core_v1.ObjectReference `protobuf:"bytes,9,opt,name=related" json:"related,omitempty"`
	// Optional. A human-readable description of the status of this operation.
	// Maximal length of the note is 1kB, but libraries should be prepared to
	// handle values up to 64kB.
	// +optional
	Note *string `protobuf:"bytes,10,opt,name=note" json:"note,omitempty"`
	// Type of this event (Normal, Warning), new types could be added in the
	// future.
	// +optional
	Type *string `protobuf:"bytes,11,opt,name=type" json:"type,omitempty"`
	// Deprecated field assuring backward compatibility with core.v1 Event type
	// +optional
	DeprecatedSource *k8s_io_api_core_v1.EventSource `protobuf:"bytes,12,opt,name=deprecatedSource" json:"deprecatedSource,omitempty"`
	// Deprecated field assuring backward compatibility with core.v1 Event type
	// +optional
	DeprecatedFirstTimestamp *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,13,opt,name=deprecatedFirstTimestamp" json:"deprecatedFirstTimestamp,omitempty"`
	// Deprecated field assuring backward compatibility with core.v1 Event type
	// +optional
	DeprecatedLastTimestamp *k8s_io_apimachinery_pkg_apis_meta_v1.Time `protobuf:"bytes,14,opt,name=deprecatedLastTimestamp" json:"deprecatedLastTimestamp,omitempty"`
	// Deprecated field assuring backward compatibility with core.v1 Event type
	// +optional
	DeprecatedCount  *int32 `protobuf:"varint,15,opt,name=deprecatedCount" json:"deprecatedCount,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{0} }

func (m *Event) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Event) GetEventTime() *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *Event) GetSeries() *EventSeries {
	if m != nil {
		return m.Series
	}
	return nil
}

func (m *Event) GetReportingController() string {
	if m != nil && m.ReportingController != nil {
		return *m.ReportingController
	}
	return ""
}

func (m *Event) GetReportingInstance() string {
	if m != nil && m.ReportingInstance != nil {
		return *m.ReportingInstance
	}
	return ""
}

func (m *Event) GetAction() string {
	if m != nil && m.Action != nil {
		return *m.Action
	}
	return ""
}

func (m *Event) GetReason() string {
	if m != nil && m.Reason != nil {
		return *m.Reason
	}
	return ""
}

func (m *Event) GetRegarding() *k8s_io_api_core_v1.ObjectReference {
	if m != nil {
		return m.Regarding
	}
	return nil
}

func (m *Event) GetRelated() *k8s_io_api_core_v1.ObjectReference {
	if m != nil {
		return m.Related
	}
	return nil
}

func (m *Event) GetNote() string {
	if m != nil && m.Note != nil {
		return *m.Note
	}
	return ""
}

func (m *Event) GetType() string {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return ""
}

func (m *Event) GetDeprecatedSource() *k8s_io_api_core_v1.EventSource {
	if m != nil {
		return m.DeprecatedSource
	}
	return nil
}

func (m *Event) GetDeprecatedFirstTimestamp() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.DeprecatedFirstTimestamp
	}
	return nil
}

func (m *Event) GetDeprecatedLastTimestamp() *k8s_io_apimachinery_pkg_apis_meta_v1.Time {
	if m != nil {
		return m.DeprecatedLastTimestamp
	}
	return nil
}

func (m *Event) GetDeprecatedCount() int32 {
	if m != nil && m.DeprecatedCount != nil {
		return *m.DeprecatedCount
	}
	return 0
}

// EventList is a list of Event objects.
type EventList struct {
	// Standard list metadata.
	// More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata
	// +optional
	Metadata *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
	// Items is a list of schema objects.
	Items            []*Event `protobuf:"bytes,2,rep,name=items" json:"items,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *EventList) Reset()                    { *m = EventList{} }
func (m *EventList) String() string            { return proto.CompactTextString(m) }
func (*EventList) ProtoMessage()               {}
func (*EventList) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{1} }

func (m *EventList) GetMetadata() *k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EventList) GetItems() []*Event {
	if m != nil {
		return m.Items
	}
	return nil
}

// EventSeries contain information on series of events, i.e. thing that was/is happening
// continuously for some time.
type EventSeries struct {
	// Number of occurrences in this series up to the last heartbeat time
	Count *int32 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	// Time when last Event from the series was seen before last heartbeat.
	LastObservedTime *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime `protobuf:"bytes,2,opt,name=lastObservedTime" json:"lastObservedTime,omitempty"`
	// Information whether this series is ongoing or finished.
	State            *string `protobuf:"bytes,3,opt,name=state" json:"state,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *EventSeries) Reset()                    { *m = EventSeries{} }
func (m *EventSeries) String() string            { return proto.CompactTextString(m) }
func (*EventSeries) ProtoMessage()               {}
func (*EventSeries) Descriptor() ([]byte, []int) { return fileDescriptorGenerated, []int{2} }

func (m *EventSeries) GetCount() int32 {
	if m != nil && m.Count != nil {
		return *m.Count
	}
	return 0
}

func (m *EventSeries) GetLastObservedTime() *k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime {
	if m != nil {
		return m.LastObservedTime
	}
	return nil
}

func (m *EventSeries) GetState() string {
	if m != nil && m.State != nil {
		return *m.State
	}
	return ""
}

func init() {
	proto.RegisterType((*Event)(nil), "k8s.io.api.events.v1beta1.Event")
	proto.RegisterType((*EventList)(nil), "k8s.io.api.events.v1beta1.EventList")
	proto.RegisterType((*EventSeries)(nil), "k8s.io.api.events.v1beta1.EventSeries")
}
func (m *Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n1, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.EventTime != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.EventTime.Size()))
		n2, err := m.EventTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Series != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Series.Size()))
		n3, err := m.Series.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ReportingController != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ReportingController)))
		i += copy(dAtA[i:], *m.ReportingController)
	}
	if m.ReportingInstance != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.ReportingInstance)))
		i += copy(dAtA[i:], *m.ReportingInstance)
	}
	if m.Action != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Action)))
		i += copy(dAtA[i:], *m.Action)
	}
	if m.Reason != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Reason)))
		i += copy(dAtA[i:], *m.Reason)
	}
	if m.Regarding != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Regarding.Size()))
		n4, err := m.Regarding.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Related != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Related.Size()))
		n5, err := m.Related.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Note != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Note)))
		i += copy(dAtA[i:], *m.Note)
	}
	if m.Type != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.Type)))
		i += copy(dAtA[i:], *m.Type)
	}
	if m.DeprecatedSource != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DeprecatedSource.Size()))
		n6, err := m.DeprecatedSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.DeprecatedFirstTimestamp != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DeprecatedFirstTimestamp.Size()))
		n7, err := m.DeprecatedFirstTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.DeprecatedLastTimestamp != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.DeprecatedLastTimestamp.Size()))
		n8, err := m.DeprecatedLastTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.DeprecatedCount != nil {
		dAtA[i] = 0x78
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.DeprecatedCount))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Metadata != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.Metadata.Size()))
		n9, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGenerated(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EventSeries) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EventSeries) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Count != nil {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(*m.Count))
	}
	if m.LastObservedTime != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(m.LastObservedTime.Size()))
		n10, err := m.LastObservedTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.State != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGenerated(dAtA, i, uint64(len(*m.State)))
		i += copy(dAtA[i:], *m.State)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Event) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.EventTime != nil {
		l = m.EventTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReportingController != nil {
		l = len(*m.ReportingController)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.ReportingInstance != nil {
		l = len(*m.ReportingInstance)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Action != nil {
		l = len(*m.Action)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Reason != nil {
		l = len(*m.Reason)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Regarding != nil {
		l = m.Regarding.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Related != nil {
		l = m.Related.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Note != nil {
		l = len(*m.Note)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.Type != nil {
		l = len(*m.Type)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DeprecatedSource != nil {
		l = m.DeprecatedSource.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DeprecatedFirstTimestamp != nil {
		l = m.DeprecatedFirstTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DeprecatedLastTimestamp != nil {
		l = m.DeprecatedLastTimestamp.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.DeprecatedCount != nil {
		n += 1 + sovGenerated(uint64(*m.DeprecatedCount))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventList) Size() (n int) {
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EventSeries) Size() (n int) {
	var l int
	_ = l
	if m.Count != nil {
		n += 1 + sovGenerated(uint64(*m.Count))
	}
	if m.LastObservedTime != nil {
		l = m.LastObservedTime.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.State != nil {
		l = len(*m.State)
		n += 1 + l + sovGenerated(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovGenerated(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ObjectMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EventTime == nil {
				m.EventTime = &k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime{}
			}
			if err := m.EventTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Series == nil {
				m.Series = &EventSeries{}
			}
			if err := m.Series.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingController", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ReportingController = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReportingInstance", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.ReportingInstance = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Action = &s
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Reason = &s
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regarding", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Regarding == nil {
				m.Regarding = &k8s_io_api_core_v1.ObjectReference{}
			}
			if err := m.Regarding.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Related", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Related == nil {
				m.Related = &k8s_io_api_core_v1.ObjectReference{}
			}
			if err := m.Related.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Note", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Note = &s
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Type = &s
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedSource == nil {
				m.DeprecatedSource = &k8s_io_api_core_v1.EventSource{}
			}
			if err := m.DeprecatedSource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedFirstTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedFirstTimestamp == nil {
				m.DeprecatedFirstTimestamp = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.DeprecatedFirstTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedLastTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedLastTimestamp == nil {
				m.DeprecatedLastTimestamp = &k8s_io_apimachinery_pkg_apis_meta_v1.Time{}
			}
			if err := m.DeprecatedLastTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedCount", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DeprecatedCount = &v
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &k8s_io_apimachinery_pkg_apis_meta_v1.ListMeta{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Event{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EventSeries) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EventSeries: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EventSeries: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Count = &v
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastObservedTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastObservedTime == nil {
				m.LastObservedTime = &k8s_io_apimachinery_pkg_apis_meta_v1.MicroTime{}
			}
			if err := m.LastObservedTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.State = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGenerated
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGenerated(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGenerated = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("k8s.io/api/events/v1beta1/generated.proto", fileDescriptorGenerated) }

var fileDescriptorGenerated = []byte{
	// 595 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x53, 0xc1, 0x6e, 0x13, 0x3d,
	0x10, 0xfe, 0xb7, 0x6d, 0xd2, 0xae, 0xf3, 0x43, 0x8b, 0x41, 0xe0, 0xf6, 0x10, 0xa2, 0x20, 0xa1,
	0x80, 0x90, 0xb7, 0x2d, 0xa8, 0xe2, 0x02, 0x12, 0x54, 0x20, 0x01, 0xad, 0x2a, 0x6d, 0x39, 0xc1,
	0xc9, 0xdd, 0x9d, 0x6e, 0x4d, 0xb3, 0xf6, 0xca, 0x9e, 0x44, 0xea, 0x53, 0x70, 0x43, 0x3c, 0x12,
	0x47, 0x1e, 0x01, 0xb5, 0x2f, 0x82, 0xec, 0x0d, 0xd9, 0x28, 0x9b, 0xa8, 0x41, 0xdc, 0x3c, 0xdf,
	0x7c, 0xdf, 0x37, 0x9e, 0xb1, 0x87, 0x3c, 0x3a, 0x7f, 0x6e, 0xb9, 0xd4, 0x91, 0x28, 0x64, 0x04,
	0x43, 0x50, 0x68, 0xa3, 0xe1, 0xce, 0x09, 0xa0, 0xd8, 0x89, 0x32, 0x50, 0x60, 0x04, 0x42, 0xca,
	0x0b, 0xa3, 0x51, 0xd3, 0xcd, 0x92, 0xca, 0x45, 0x21, 0x79, 0x49, 0xe5, 0x23, 0xea, 0x56, 0x77,
	0xc2, 0x25, 0xd1, 0x06, 0xa2, 0x61, 0x4d, 0xbe, 0xf5, 0xac, 0xe2, 0xe4, 0x22, 0x39, 0x93, 0x0a,
	0xcc, 0x45, 0x54, 0x9c, 0x67, 0x0e, 0xb0, 0x51, 0x0e, 0x28, 0x66, 0xa9, 0xa2, 0x79, 0x2a, 0x33,
	0x50, 0x28, 0x73, 0xa8, 0x09, 0xf6, 0xae, 0x13, 0xd8, 0xe4, 0x0c, 0x72, 0x51, 0xd3, 0x3d, 0x9d,
	0xa7, 0x1b, 0xa0, 0xec, 0x47, 0x52, 0xa1, 0x45, 0x33, 0x2d, 0xea, 0x5e, 0x35, 0x49, 0xe3, 0x8d,
	0x1b, 0x05, 0x3d, 0x20, 0x6b, 0xae, 0x85, 0x54, 0xa0, 0x60, 0x41, 0x27, 0xe8, 0xb5, 0x76, 0xb7,
	0x79, 0x35, 0xaf, 0xb1, 0x23, 0x2f, 0xce, 0x33, 0x07, 0x58, 0xee, 0xd8, 0x7c, 0xb8, 0xc3, 0x8f,
	0x4e, 0xbe, 0x40, 0x82, 0x87, 0x80, 0x22, 0x1e, 0x3b, 0xd0, 0x43, 0x12, 0xfa, 0x09, 0x7f, 0x94,
	0x39, 0xb0, 0x25, 0x6f, 0x17, 0x2d, 0x66, 0x77, 0x28, 0x13, 0xa3, 0x9d, 0x2c, 0xae, 0x1c, 0xe8,
	0x4b, 0xd2, 0xb4, 0x60, 0x24, 0x58, 0xb6, 0xec, 0xbd, 0x1e, 0xf2, 0xb9, 0x4f, 0xc9, 0x7d, 0x3b,
	0xc7, 0x9e, 0x1d, 0x8f, 0x54, 0x74, 0x9b, 0xdc, 0x36, 0x50, 0x68, 0x83, 0x52, 0x65, 0xfb, 0x5a,
	0xa1, 0xd1, 0xfd, 0x3e, 0x18, 0xb6, 0xd2, 0x09, 0x7a, 0x61, 0x3c, 0x2b, 0x45, 0x9f, 0x90, 0x5b,
	0x63, 0xf8, 0x9d, 0xb2, 0x28, 0x54, 0x02, 0xac, 0xe1, 0xf9, 0xf5, 0x04, 0xbd, 0x4b, 0x9a, 0x22,
	0x41, 0xa9, 0x15, 0x6b, 0x7a, 0xca, 0x28, 0x72, 0xb8, 0x01, 0x61, 0xb5, 0x62, 0xab, 0x25, 0x5e,
	0x46, 0xf4, 0x15, 0x09, 0x0d, 0x64, 0xc2, 0xa4, 0x52, 0x65, 0x6c, 0xcd, 0xb7, 0xf4, 0x60, 0xb2,
	0x25, 0xf7, 0x05, 0xab, 0xd9, 0xc6, 0x70, 0x0a, 0x06, 0x54, 0x02, 0x71, 0xa5, 0xa2, 0x2f, 0xc8,
	0xaa, 0x81, 0xbe, 0x7b, 0x4a, 0x16, 0x2e, 0x6e, 0xf0, 0x47, 0x43, 0x29, 0x59, 0x51, 0x1a, 0x81,
	0x11, 0x7f, 0x2f, 0x7f, 0x76, 0x18, 0x5e, 0x14, 0xc0, 0x5a, 0x25, 0xe6, 0xce, 0xf4, 0x03, 0xd9,
	0x48, 0xa1, 0x30, 0x90, 0x38, 0xd5, 0xb1, 0x1e, 0x98, 0x04, 0xd8, 0xff, 0xbe, 0xde, 0xfd, 0x59,
	0xf5, 0xca, 0xe1, 0x7b, 0x5a, 0x5c, 0x13, 0xd2, 0x53, 0xc2, 0x2a, 0xec, 0xad, 0x34, 0xd6, 0xbf,
	0xae, 0x45, 0x91, 0x17, 0xec, 0x86, 0x37, 0x7d, 0xbc, 0xd8, 0x27, 0xf1, 0xff, 0x63, 0xae, 0x17,
	0x4d, 0xc9, 0xbd, 0x2a, 0x77, 0x20, 0x26, 0xcb, 0xdc, 0xfc, 0xeb, 0x32, 0xf3, 0xac, 0x68, 0x8f,
	0xac, 0x57, 0xa9, 0x7d, 0x3d, 0x50, 0xc8, 0xd6, 0x3b, 0x41, 0xaf, 0x11, 0x4f, 0xc3, 0xdd, 0xaf,
	0x01, 0x09, 0xfd, 0x64, 0x0e, 0xa4, 0x45, 0xfa, 0xbe, 0xb6, 0x69, 0x7c, 0xb1, 0xeb, 0x38, 0xf5,
	0xd4, 0x9e, 0xed, 0x91, 0x86, 0x44, 0xc8, 0x2d, 0x5b, 0xea, 0x2c, 0xf7, 0x5a, 0xbb, 0x9d, 0xeb,
	0xf6, 0x22, 0x2e, 0xe9, 0xdd, 0x6f, 0x01, 0x69, 0x4d, 0x2c, 0x0a, 0xbd, 0x43, 0x1a, 0x89, 0xef,
	0x20, 0xf0, 0x1d, 0x94, 0x01, 0xfd, 0x4c, 0x36, 0xfa, 0xc2, 0xe2, 0xd1, 0x89, 0x05, 0x33, 0x84,
	0xf4, 0x5f, 0x96, 0xb9, 0x66, 0xe4, 0x4a, 0x5a, 0x14, 0x08, 0x7e, 0xa5, 0xc3, 0xb8, 0x0c, 0x5e,
	0x6f, 0xfe, 0xb8, 0x6c, 0x07, 0x3f, 0x2f, 0xdb, 0xc1, 0xaf, 0xcb, 0x76, 0xf0, 0xfd, 0xaa, 0xfd,
	0xdf, 0xa7, 0xd5, 0x51, 0x03, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xf2, 0xc1, 0x8f, 0xb7, 0xea,
	0x05, 0x00, 0x00,
}
