// Package domain provides primitives to interact the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen DO NOT EDIT.
package domain

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"

	"gopkg.in/yaml.v2"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	ihttp "github.com/influxdata/influxdb-client-go/v2/api/http"
)

// Client which conforms to the OpenAPI3 specification for this service.
type Client struct {
	service ihttp.Service
}

// Creates a new Client, with reasonable defaults
func NewClient(service ihttp.Service) *Client {
	// create a client with sane default values
	client := Client{
		service: service,
	}
	return &client
}

// The interface specification for the client above.
type ClientInterface interface {
	// GetRoutes request
	GetRoutes(ctx context.Context, params *GetRoutesParams) (*http.Response, error)

	// GetAuthorizations request
	GetAuthorizations(ctx context.Context, params *GetAuthorizationsParams) (*http.Response, error)

	// PostAuthorizations request  with any body
	PostAuthorizationsWithBody(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*http.Response, error)

	PostAuthorizations(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*http.Response, error)

	// DeleteAuthorizationsID request
	DeleteAuthorizationsID(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*http.Response, error)

	// GetAuthorizationsID request
	GetAuthorizationsID(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*http.Response, error)

	// PatchAuthorizationsID request  with any body
	PatchAuthorizationsIDWithBody(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchAuthorizationsID(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*http.Response, error)

	// GetBuckets request
	GetBuckets(ctx context.Context, params *GetBucketsParams) (*http.Response, error)

	// PostBuckets request  with any body
	PostBucketsWithBody(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*http.Response, error)

	PostBuckets(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*http.Response, error)

	// DeleteBucketsID request
	DeleteBucketsID(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*http.Response, error)

	// GetBucketsID request
	GetBucketsID(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*http.Response, error)

	// PatchBucketsID request  with any body
	PatchBucketsIDWithBody(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchBucketsID(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*http.Response, error)

	// GetBucketsIDLabels request
	GetBucketsIDLabels(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*http.Response, error)

	// PostBucketsIDLabels request  with any body
	PostBucketsIDLabelsWithBody(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostBucketsIDLabels(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteBucketsIDLabelsID request
	DeleteBucketsIDLabelsID(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*http.Response, error)

	// GetBucketsIDMembers request
	GetBucketsIDMembers(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*http.Response, error)

	// PostBucketsIDMembers request  with any body
	PostBucketsIDMembersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostBucketsIDMembers(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteBucketsIDMembersID request
	DeleteBucketsIDMembersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*http.Response, error)

	// GetBucketsIDOwners request
	GetBucketsIDOwners(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*http.Response, error)

	// PostBucketsIDOwners request  with any body
	PostBucketsIDOwnersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostBucketsIDOwners(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteBucketsIDOwnersID request
	DeleteBucketsIDOwnersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*http.Response, error)

	// GetChecks request
	GetChecks(ctx context.Context, params *GetChecksParams) (*http.Response, error)

	// CreateCheck request  with any body
	CreateCheckWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateCheck(ctx context.Context, body CreateCheckJSONRequestBody) (*http.Response, error)

	// DeleteChecksID request
	DeleteChecksID(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*http.Response, error)

	// GetChecksID request
	GetChecksID(ctx context.Context, checkID string, params *GetChecksIDParams) (*http.Response, error)

	// PatchChecksID request  with any body
	PatchChecksIDWithBody(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchChecksID(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*http.Response, error)

	// PutChecksID request  with any body
	PutChecksIDWithBody(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutChecksID(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*http.Response, error)

	// GetChecksIDLabels request
	GetChecksIDLabels(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*http.Response, error)

	// PostChecksIDLabels request  with any body
	PostChecksIDLabelsWithBody(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostChecksIDLabels(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteChecksIDLabelsID request
	DeleteChecksIDLabelsID(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*http.Response, error)

	// GetChecksIDQuery request
	GetChecksIDQuery(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*http.Response, error)

	// GetDashboards request
	GetDashboards(ctx context.Context, params *GetDashboardsParams) (*http.Response, error)

	// PostDashboards request  with any body
	PostDashboardsWithBody(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboards(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsID request
	DeleteDashboardsID(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*http.Response, error)

	// GetDashboardsID request
	GetDashboardsID(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*http.Response, error)

	// PatchDashboardsID request  with any body
	PatchDashboardsIDWithBody(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDashboardsID(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*http.Response, error)

	// PostDashboardsIDCells request  with any body
	PostDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDCells(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*http.Response, error)

	// PutDashboardsIDCells request  with any body
	PutDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error)

	PutDashboardsIDCells(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDCellsID request
	DeleteDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*http.Response, error)

	// PatchDashboardsIDCellsID request  with any body
	PatchDashboardsIDCellsIDWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*http.Response, error)

	// GetDashboardsIDCellsIDView request
	GetDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*http.Response, error)

	// PatchDashboardsIDCellsIDView request  with any body
	PatchDashboardsIDCellsIDViewWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*http.Response, error)

	// GetDashboardsIDLabels request
	GetDashboardsIDLabels(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*http.Response, error)

	// PostDashboardsIDLabels request  with any body
	PostDashboardsIDLabelsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDLabels(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDLabelsID request
	DeleteDashboardsIDLabelsID(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*http.Response, error)

	// GetDashboardsIDMembers request
	GetDashboardsIDMembers(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*http.Response, error)

	// PostDashboardsIDMembers request  with any body
	PostDashboardsIDMembersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDMembers(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDMembersID request
	DeleteDashboardsIDMembersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*http.Response, error)

	// GetDashboardsIDOwners request
	GetDashboardsIDOwners(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*http.Response, error)

	// PostDashboardsIDOwners request  with any body
	PostDashboardsIDOwnersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostDashboardsIDOwners(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteDashboardsIDOwnersID request
	DeleteDashboardsIDOwnersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*http.Response, error)

	// GetDBRPs request
	GetDBRPs(ctx context.Context, params *GetDBRPsParams) (*http.Response, error)

	// PostDBRP request  with any body
	PostDBRPWithBody(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*http.Response, error)

	PostDBRP(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*http.Response, error)

	// DeleteDBRPID request
	DeleteDBRPID(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*http.Response, error)

	// GetDBRPsID request
	GetDBRPsID(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*http.Response, error)

	// PatchDBRPID request  with any body
	PatchDBRPIDWithBody(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchDBRPID(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*http.Response, error)

	// PostDelete request  with any body
	PostDeleteWithBody(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*http.Response, error)

	PostDelete(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*http.Response, error)

	// GetDocumentsTemplates request
	GetDocumentsTemplates(ctx context.Context, params *GetDocumentsTemplatesParams) (*http.Response, error)

	// PostDocumentsTemplates request  with any body
	PostDocumentsTemplatesWithBody(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*http.Response, error)

	PostDocumentsTemplates(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*http.Response, error)

	// DeleteDocumentsTemplatesID request
	DeleteDocumentsTemplatesID(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*http.Response, error)

	// GetDocumentsTemplatesID request
	GetDocumentsTemplatesID(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*http.Response, error)

	// PutDocumentsTemplatesID request  with any body
	PutDocumentsTemplatesIDWithBody(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutDocumentsTemplatesID(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*http.Response, error)

	// GetDocumentsTemplatesIDLabels request
	GetDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*http.Response, error)

	// PostDocumentsTemplatesIDLabels request  with any body
	PostDocumentsTemplatesIDLabelsWithBody(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteDocumentsTemplatesIDLabelsID request
	DeleteDocumentsTemplatesIDLabelsID(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*http.Response, error)

	// GetFlags request
	GetFlags(ctx context.Context, params *GetFlagsParams) (*http.Response, error)

	// GetHealth request
	GetHealth(ctx context.Context, params *GetHealthParams) (*http.Response, error)

	// GetLabels request
	GetLabels(ctx context.Context, params *GetLabelsParams) (*http.Response, error)

	// PostLabels request  with any body
	PostLabelsWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	PostLabels(ctx context.Context, body PostLabelsJSONRequestBody) (*http.Response, error)

	// DeleteLabelsID request
	DeleteLabelsID(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*http.Response, error)

	// GetLabelsID request
	GetLabelsID(ctx context.Context, labelID string, params *GetLabelsIDParams) (*http.Response, error)

	// PatchLabelsID request  with any body
	PatchLabelsIDWithBody(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchLabelsID(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*http.Response, error)

	// GetMe request
	GetMe(ctx context.Context, params *GetMeParams) (*http.Response, error)

	// PutMePassword request  with any body
	PutMePasswordWithBody(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*http.Response, error)

	PutMePassword(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*http.Response, error)

	// GetNotificationEndpoints request
	GetNotificationEndpoints(ctx context.Context, params *GetNotificationEndpointsParams) (*http.Response, error)

	// CreateNotificationEndpoint request  with any body
	CreateNotificationEndpointWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateNotificationEndpoint(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*http.Response, error)

	// DeleteNotificationEndpointsID request
	DeleteNotificationEndpointsID(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*http.Response, error)

	// GetNotificationEndpointsID request
	GetNotificationEndpointsID(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*http.Response, error)

	// PatchNotificationEndpointsID request  with any body
	PatchNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchNotificationEndpointsID(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*http.Response, error)

	// PutNotificationEndpointsID request  with any body
	PutNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutNotificationEndpointsID(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*http.Response, error)

	// GetNotificationEndpointsIDLabels request
	GetNotificationEndpointsIDLabels(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*http.Response, error)

	// PostNotificationEndpointIDLabels request  with any body
	PostNotificationEndpointIDLabelsWithBody(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostNotificationEndpointIDLabels(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteNotificationEndpointsIDLabelsID request
	DeleteNotificationEndpointsIDLabelsID(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*http.Response, error)

	// GetNotificationRules request
	GetNotificationRules(ctx context.Context, params *GetNotificationRulesParams) (*http.Response, error)

	// CreateNotificationRule request  with any body
	CreateNotificationRuleWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateNotificationRule(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*http.Response, error)

	// DeleteNotificationRulesID request
	DeleteNotificationRulesID(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*http.Response, error)

	// GetNotificationRulesID request
	GetNotificationRulesID(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*http.Response, error)

	// PatchNotificationRulesID request  with any body
	PatchNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchNotificationRulesID(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*http.Response, error)

	// PutNotificationRulesID request  with any body
	PutNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutNotificationRulesID(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*http.Response, error)

	// GetNotificationRulesIDLabels request
	GetNotificationRulesIDLabels(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*http.Response, error)

	// PostNotificationRuleIDLabels request  with any body
	PostNotificationRuleIDLabelsWithBody(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostNotificationRuleIDLabels(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteNotificationRulesIDLabelsID request
	DeleteNotificationRulesIDLabelsID(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*http.Response, error)

	// GetNotificationRulesIDQuery request
	GetNotificationRulesIDQuery(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*http.Response, error)

	// GetOrgs request
	GetOrgs(ctx context.Context, params *GetOrgsParams) (*http.Response, error)

	// PostOrgs request  with any body
	PostOrgsWithBody(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgs(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*http.Response, error)

	// DeleteOrgsID request
	DeleteOrgsID(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*http.Response, error)

	// GetOrgsID request
	GetOrgsID(ctx context.Context, orgID string, params *GetOrgsIDParams) (*http.Response, error)

	// PatchOrgsID request  with any body
	PatchOrgsIDWithBody(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchOrgsID(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*http.Response, error)

	// GetOrgsIDMembers request
	GetOrgsIDMembers(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*http.Response, error)

	// PostOrgsIDMembers request  with any body
	PostOrgsIDMembersWithBody(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgsIDMembers(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteOrgsIDMembersID request
	DeleteOrgsIDMembersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*http.Response, error)

	// GetOrgsIDOwners request
	GetOrgsIDOwners(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*http.Response, error)

	// PostOrgsIDOwners request  with any body
	PostOrgsIDOwnersWithBody(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgsIDOwners(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteOrgsIDOwnersID request
	DeleteOrgsIDOwnersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*http.Response, error)

	// GetOrgsIDSecrets request
	GetOrgsIDSecrets(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*http.Response, error)

	// PatchOrgsIDSecrets request  with any body
	PatchOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error)

	PatchOrgsIDSecrets(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*http.Response, error)

	// PostOrgsIDSecrets request  with any body
	PostOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error)

	PostOrgsIDSecrets(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*http.Response, error)

	// PostQuery request  with any body
	PostQueryWithBody(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*http.Response, error)

	PostQuery(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*http.Response, error)

	// PostQueryAnalyze request  with any body
	PostQueryAnalyzeWithBody(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*http.Response, error)

	PostQueryAnalyze(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*http.Response, error)

	// PostQueryAst request  with any body
	PostQueryAstWithBody(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*http.Response, error)

	PostQueryAst(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*http.Response, error)

	// GetQuerySuggestions request
	GetQuerySuggestions(ctx context.Context, params *GetQuerySuggestionsParams) (*http.Response, error)

	// GetQuerySuggestionsName request
	GetQuerySuggestionsName(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*http.Response, error)

	// GetReady request
	GetReady(ctx context.Context, params *GetReadyParams) (*http.Response, error)

	// GetScrapers request
	GetScrapers(ctx context.Context, params *GetScrapersParams) (*http.Response, error)

	// PostScrapers request  with any body
	PostScrapersWithBody(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapers(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*http.Response, error)

	// DeleteScrapersID request
	DeleteScrapersID(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*http.Response, error)

	// GetScrapersID request
	GetScrapersID(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*http.Response, error)

	// PatchScrapersID request  with any body
	PatchScrapersIDWithBody(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchScrapersID(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*http.Response, error)

	// GetScrapersIDLabels request
	GetScrapersIDLabels(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*http.Response, error)

	// PostScrapersIDLabels request  with any body
	PostScrapersIDLabelsWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapersIDLabels(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteScrapersIDLabelsID request
	DeleteScrapersIDLabelsID(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*http.Response, error)

	// GetScrapersIDMembers request
	GetScrapersIDMembers(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*http.Response, error)

	// PostScrapersIDMembers request  with any body
	PostScrapersIDMembersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapersIDMembers(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteScrapersIDMembersID request
	DeleteScrapersIDMembersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*http.Response, error)

	// GetScrapersIDOwners request
	GetScrapersIDOwners(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*http.Response, error)

	// PostScrapersIDOwners request  with any body
	PostScrapersIDOwnersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostScrapersIDOwners(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteScrapersIDOwnersID request
	DeleteScrapersIDOwnersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*http.Response, error)

	// GetSetup request
	GetSetup(ctx context.Context, params *GetSetupParams) (*http.Response, error)

	// PostSetup request  with any body
	PostSetupWithBody(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*http.Response, error)

	PostSetup(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*http.Response, error)

	// PostSetupUser request  with any body
	PostSetupUserWithBody(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*http.Response, error)

	PostSetupUser(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*http.Response, error)

	// PostSignin request
	PostSignin(ctx context.Context, params *PostSigninParams) (*http.Response, error)

	// PostSignout request
	PostSignout(ctx context.Context, params *PostSignoutParams) (*http.Response, error)

	// GetSources request
	GetSources(ctx context.Context, params *GetSourcesParams) (*http.Response, error)

	// PostSources request  with any body
	PostSourcesWithBody(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*http.Response, error)

	PostSources(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*http.Response, error)

	// DeleteSourcesID request
	DeleteSourcesID(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*http.Response, error)

	// GetSourcesID request
	GetSourcesID(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*http.Response, error)

	// PatchSourcesID request  with any body
	PatchSourcesIDWithBody(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchSourcesID(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*http.Response, error)

	// GetSourcesIDBuckets request
	GetSourcesIDBuckets(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*http.Response, error)

	// GetSourcesIDHealth request
	GetSourcesIDHealth(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*http.Response, error)

	// ListStacks request
	ListStacks(ctx context.Context, params *ListStacksParams) (*http.Response, error)

	// CreateStack request  with any body
	CreateStackWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	CreateStack(ctx context.Context, body CreateStackJSONRequestBody) (*http.Response, error)

	// DeleteStack request
	DeleteStack(ctx context.Context, stackId string, params *DeleteStackParams) (*http.Response, error)

	// ReadStack request
	ReadStack(ctx context.Context, stackId string) (*http.Response, error)

	// UpdateStack request  with any body
	UpdateStackWithBody(ctx context.Context, stackId string, contentType string, body io.Reader) (*http.Response, error)

	UpdateStack(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*http.Response, error)

	// UninstallStack request
	UninstallStack(ctx context.Context, stackId string) (*http.Response, error)

	// GetTasks request
	GetTasks(ctx context.Context, params *GetTasksParams) (*http.Response, error)

	// PostTasks request  with any body
	PostTasksWithBody(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasks(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*http.Response, error)

	// DeleteTasksID request
	DeleteTasksID(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*http.Response, error)

	// GetTasksID request
	GetTasksID(ctx context.Context, taskID string, params *GetTasksIDParams) (*http.Response, error)

	// PatchTasksID request  with any body
	PatchTasksIDWithBody(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchTasksID(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*http.Response, error)

	// GetTasksIDLabels request
	GetTasksIDLabels(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*http.Response, error)

	// PostTasksIDLabels request  with any body
	PostTasksIDLabelsWithBody(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDLabels(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDLabelsID request
	DeleteTasksIDLabelsID(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*http.Response, error)

	// GetTasksIDLogs request
	GetTasksIDLogs(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*http.Response, error)

	// GetTasksIDMembers request
	GetTasksIDMembers(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*http.Response, error)

	// PostTasksIDMembers request  with any body
	PostTasksIDMembersWithBody(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDMembers(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDMembersID request
	DeleteTasksIDMembersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*http.Response, error)

	// GetTasksIDOwners request
	GetTasksIDOwners(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*http.Response, error)

	// PostTasksIDOwners request  with any body
	PostTasksIDOwnersWithBody(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDOwners(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDOwnersID request
	DeleteTasksIDOwnersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*http.Response, error)

	// GetTasksIDRuns request
	GetTasksIDRuns(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*http.Response, error)

	// PostTasksIDRuns request  with any body
	PostTasksIDRunsWithBody(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTasksIDRuns(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*http.Response, error)

	// DeleteTasksIDRunsID request
	DeleteTasksIDRunsID(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*http.Response, error)

	// GetTasksIDRunsID request
	GetTasksIDRunsID(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*http.Response, error)

	// GetTasksIDRunsIDLogs request
	GetTasksIDRunsIDLogs(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*http.Response, error)

	// PostTasksIDRunsIDRetry request
	PostTasksIDRunsIDRetry(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*http.Response, error)

	// GetTelegrafPlugins request
	GetTelegrafPlugins(ctx context.Context, params *GetTelegrafPluginsParams) (*http.Response, error)

	// GetTelegrafs request
	GetTelegrafs(ctx context.Context, params *GetTelegrafsParams) (*http.Response, error)

	// PostTelegrafs request  with any body
	PostTelegrafsWithBody(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafs(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsID request
	DeleteTelegrafsID(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*http.Response, error)

	// GetTelegrafsID request
	GetTelegrafsID(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*http.Response, error)

	// PutTelegrafsID request  with any body
	PutTelegrafsIDWithBody(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutTelegrafsID(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*http.Response, error)

	// GetTelegrafsIDLabels request
	GetTelegrafsIDLabels(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*http.Response, error)

	// PostTelegrafsIDLabels request  with any body
	PostTelegrafsIDLabelsWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafsIDLabels(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsIDLabelsID request
	DeleteTelegrafsIDLabelsID(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*http.Response, error)

	// GetTelegrafsIDMembers request
	GetTelegrafsIDMembers(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*http.Response, error)

	// PostTelegrafsIDMembers request  with any body
	PostTelegrafsIDMembersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafsIDMembers(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsIDMembersID request
	DeleteTelegrafsIDMembersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*http.Response, error)

	// GetTelegrafsIDOwners request
	GetTelegrafsIDOwners(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*http.Response, error)

	// PostTelegrafsIDOwners request  with any body
	PostTelegrafsIDOwnersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error)

	PostTelegrafsIDOwners(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*http.Response, error)

	// DeleteTelegrafsIDOwnersID request
	DeleteTelegrafsIDOwnersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*http.Response, error)

	// ApplyTemplate request  with any body
	ApplyTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	ApplyTemplate(ctx context.Context, body ApplyTemplateJSONRequestBody) (*http.Response, error)

	// ExportTemplate request  with any body
	ExportTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error)

	ExportTemplate(ctx context.Context, body ExportTemplateJSONRequestBody) (*http.Response, error)

	// GetUsers request
	GetUsers(ctx context.Context, params *GetUsersParams) (*http.Response, error)

	// PostUsers request  with any body
	PostUsersWithBody(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*http.Response, error)

	PostUsers(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*http.Response, error)

	// DeleteUsersID request
	DeleteUsersID(ctx context.Context, userID string, params *DeleteUsersIDParams) (*http.Response, error)

	// GetUsersID request
	GetUsersID(ctx context.Context, userID string, params *GetUsersIDParams) (*http.Response, error)

	// PatchUsersID request  with any body
	PatchUsersIDWithBody(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchUsersID(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*http.Response, error)

	// PostUsersIDPassword request  with any body
	PostUsersIDPasswordWithBody(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*http.Response, error)

	PostUsersIDPassword(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*http.Response, error)

	// GetVariables request
	GetVariables(ctx context.Context, params *GetVariablesParams) (*http.Response, error)

	// PostVariables request  with any body
	PostVariablesWithBody(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*http.Response, error)

	PostVariables(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*http.Response, error)

	// DeleteVariablesID request
	DeleteVariablesID(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*http.Response, error)

	// GetVariablesID request
	GetVariablesID(ctx context.Context, variableID string, params *GetVariablesIDParams) (*http.Response, error)

	// PatchVariablesID request  with any body
	PatchVariablesIDWithBody(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PatchVariablesID(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*http.Response, error)

	// PutVariablesID request  with any body
	PutVariablesIDWithBody(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*http.Response, error)

	PutVariablesID(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*http.Response, error)

	// GetVariablesIDLabels request
	GetVariablesIDLabels(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*http.Response, error)

	// PostVariablesIDLabels request  with any body
	PostVariablesIDLabelsWithBody(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error)

	PostVariablesIDLabels(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*http.Response, error)

	// DeleteVariablesIDLabelsID request
	DeleteVariablesIDLabelsID(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*http.Response, error)

	// PostWrite request  with any body
	PostWriteWithBody(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*http.Response, error)
}

func (c *Client) GetRoutes(ctx context.Context, params *GetRoutesParams) (*http.Response, error) {
	req, err := NewGetRoutesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetAuthorizations(ctx context.Context, params *GetAuthorizationsParams) (*http.Response, error) {
	req, err := NewGetAuthorizationsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostAuthorizationsWithBody(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostAuthorizationsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostAuthorizations(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostAuthorizationsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteAuthorizationsID(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*http.Response, error) {
	req, err := NewDeleteAuthorizationsIDRequest(c.service.ServerAPIURL(), authID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetAuthorizationsID(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*http.Response, error) {
	req, err := NewGetAuthorizationsIDRequest(c.service.ServerAPIURL(), authID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchAuthorizationsIDWithBody(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchAuthorizationsIDRequestWithBody(c.service.ServerAPIURL(), authID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchAuthorizationsID(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchAuthorizationsIDRequest(c.service.ServerAPIURL(), authID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBuckets(ctx context.Context, params *GetBucketsParams) (*http.Response, error) {
	req, err := NewGetBucketsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsWithBody(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBuckets(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsID(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsID(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*http.Response, error) {
	req, err := NewGetBucketsIDRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchBucketsIDWithBody(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchBucketsIDRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchBucketsID(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchBucketsIDRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsIDLabels(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetBucketsIDLabelsRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDLabelsWithBody(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsIDLabelsRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDLabels(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsIDLabelsRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsIDLabelsID(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDLabelsIDRequest(c.service.ServerAPIURL(), bucketID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsIDMembers(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*http.Response, error) {
	req, err := NewGetBucketsIDMembersRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDMembersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsIDMembersRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDMembers(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsIDMembersRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsIDMembersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDMembersIDRequest(c.service.ServerAPIURL(), bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetBucketsIDOwners(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetBucketsIDOwnersRequest(c.service.ServerAPIURL(), bucketID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDOwnersWithBody(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostBucketsIDOwnersRequestWithBody(c.service.ServerAPIURL(), bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostBucketsIDOwners(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostBucketsIDOwnersRequest(c.service.ServerAPIURL(), bucketID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteBucketsIDOwnersID(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteBucketsIDOwnersIDRequest(c.service.ServerAPIURL(), bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecks(ctx context.Context, params *GetChecksParams) (*http.Response, error) {
	req, err := NewGetChecksRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateCheckWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateCheckRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateCheck(ctx context.Context, body CreateCheckJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateCheckRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteChecksID(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*http.Response, error) {
	req, err := NewDeleteChecksIDRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecksID(ctx context.Context, checkID string, params *GetChecksIDParams) (*http.Response, error) {
	req, err := NewGetChecksIDRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchChecksIDWithBody(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchChecksIDRequestWithBody(c.service.ServerAPIURL(), checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchChecksID(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchChecksIDRequest(c.service.ServerAPIURL(), checkID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutChecksIDWithBody(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutChecksIDRequestWithBody(c.service.ServerAPIURL(), checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutChecksID(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutChecksIDRequest(c.service.ServerAPIURL(), checkID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecksIDLabels(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*http.Response, error) {
	req, err := NewGetChecksIDLabelsRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostChecksIDLabelsWithBody(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostChecksIDLabelsRequestWithBody(c.service.ServerAPIURL(), checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostChecksIDLabels(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostChecksIDLabelsRequest(c.service.ServerAPIURL(), checkID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteChecksIDLabelsID(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteChecksIDLabelsIDRequest(c.service.ServerAPIURL(), checkID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetChecksIDQuery(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*http.Response, error) {
	req, err := NewGetChecksIDQueryRequest(c.service.ServerAPIURL(), checkID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboards(ctx context.Context, params *GetDashboardsParams) (*http.Response, error) {
	req, err := NewGetDashboardsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsWithBody(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboards(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsID(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsID(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDWithBody(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDashboardsIDRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsID(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDashboardsIDRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDCellsRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDCells(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDCellsRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDashboardsIDCellsWithBody(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutDashboardsIDCellsRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDashboardsIDCells(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*http.Response, error) {
	req, err := NewPutDashboardsIDCellsRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDCellsIDRequest(c.service.ServerAPIURL(), dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsIDWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDRequestWithBody(c.service.ServerAPIURL(), dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsID(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDRequest(c.service.ServerAPIURL(), dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDCellsIDViewRequest(c.service.ServerAPIURL(), dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsIDViewWithBody(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDViewRequestWithBody(c.service.ServerAPIURL(), dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDashboardsIDCellsIDView(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDashboardsIDCellsIDViewRequest(c.service.ServerAPIURL(), dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDLabels(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDLabelsRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDLabelsWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDLabelsRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDLabels(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDLabelsRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDLabelsID(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDLabelsIDRequest(c.service.ServerAPIURL(), dashboardID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDMembers(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDMembersRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDMembersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDMembersRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDMembers(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDMembersRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDMembersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDMembersIDRequest(c.service.ServerAPIURL(), dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDashboardsIDOwners(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetDashboardsIDOwnersRequest(c.service.ServerAPIURL(), dashboardID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDOwnersWithBody(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDashboardsIDOwnersRequestWithBody(c.service.ServerAPIURL(), dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDashboardsIDOwners(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDashboardsIDOwnersRequest(c.service.ServerAPIURL(), dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDashboardsIDOwnersID(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteDashboardsIDOwnersIDRequest(c.service.ServerAPIURL(), dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDBRPs(ctx context.Context, params *GetDBRPsParams) (*http.Response, error) {
	req, err := NewGetDBRPsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDBRPWithBody(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDBRPRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDBRP(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDBRPRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDBRPID(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*http.Response, error) {
	req, err := NewDeleteDBRPIDRequest(c.service.ServerAPIURL(), dbrpID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDBRPsID(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*http.Response, error) {
	req, err := NewGetDBRPsIDRequest(c.service.ServerAPIURL(), dbrpID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDBRPIDWithBody(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchDBRPIDRequestWithBody(c.service.ServerAPIURL(), dbrpID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchDBRPID(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchDBRPIDRequest(c.service.ServerAPIURL(), dbrpID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDeleteWithBody(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDeleteRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDelete(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDeleteRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDocumentsTemplates(ctx context.Context, params *GetDocumentsTemplatesParams) (*http.Response, error) {
	req, err := NewGetDocumentsTemplatesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplatesWithBody(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplates(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDocumentsTemplatesID(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*http.Response, error) {
	req, err := NewDeleteDocumentsTemplatesIDRequest(c.service.ServerAPIURL(), templateID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDocumentsTemplatesID(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*http.Response, error) {
	req, err := NewGetDocumentsTemplatesIDRequest(c.service.ServerAPIURL(), templateID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDocumentsTemplatesIDWithBody(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutDocumentsTemplatesIDRequestWithBody(c.service.ServerAPIURL(), templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutDocumentsTemplatesID(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutDocumentsTemplatesIDRequest(c.service.ServerAPIURL(), templateID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*http.Response, error) {
	req, err := NewGetDocumentsTemplatesIDLabelsRequest(c.service.ServerAPIURL(), templateID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplatesIDLabelsWithBody(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesIDLabelsRequestWithBody(c.service.ServerAPIURL(), templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostDocumentsTemplatesIDLabels(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostDocumentsTemplatesIDLabelsRequest(c.service.ServerAPIURL(), templateID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteDocumentsTemplatesIDLabelsID(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteDocumentsTemplatesIDLabelsIDRequest(c.service.ServerAPIURL(), templateID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetFlags(ctx context.Context, params *GetFlagsParams) (*http.Response, error) {
	req, err := NewGetFlagsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetHealth(ctx context.Context, params *GetHealthParams) (*http.Response, error) {
	req, err := NewGetHealthRequest(c.service.ServerURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetLabels(ctx context.Context, params *GetLabelsParams) (*http.Response, error) {
	req, err := NewGetLabelsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostLabelsWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostLabelsRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostLabels(ctx context.Context, body PostLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostLabelsRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteLabelsID(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteLabelsIDRequest(c.service.ServerAPIURL(), labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetLabelsID(ctx context.Context, labelID string, params *GetLabelsIDParams) (*http.Response, error) {
	req, err := NewGetLabelsIDRequest(c.service.ServerAPIURL(), labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchLabelsIDWithBody(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchLabelsIDRequestWithBody(c.service.ServerAPIURL(), labelID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchLabelsID(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchLabelsIDRequest(c.service.ServerAPIURL(), labelID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetMe(ctx context.Context, params *GetMeParams) (*http.Response, error) {
	req, err := NewGetMeRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutMePasswordWithBody(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutMePasswordRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutMePassword(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*http.Response, error) {
	req, err := NewPutMePasswordRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationEndpoints(ctx context.Context, params *GetNotificationEndpointsParams) (*http.Response, error) {
	req, err := NewGetNotificationEndpointsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationEndpointWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateNotificationEndpointRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationEndpoint(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateNotificationEndpointRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationEndpointsID(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationEndpointsID(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*http.Response, error) {
	req, err := NewGetNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchNotificationEndpointsIDRequestWithBody(c.service.ServerAPIURL(), endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationEndpointsID(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationEndpointsIDWithBody(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutNotificationEndpointsIDRequestWithBody(c.service.ServerAPIURL(), endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationEndpointsID(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutNotificationEndpointsIDRequest(c.service.ServerAPIURL(), endpointID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationEndpointsIDLabels(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetNotificationEndpointsIDLabelsRequest(c.service.ServerAPIURL(), endpointID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationEndpointIDLabelsWithBody(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostNotificationEndpointIDLabelsRequestWithBody(c.service.ServerAPIURL(), endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationEndpointIDLabels(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostNotificationEndpointIDLabelsRequest(c.service.ServerAPIURL(), endpointID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationEndpointsIDLabelsID(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationEndpointsIDLabelsIDRequest(c.service.ServerAPIURL(), endpointID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRules(ctx context.Context, params *GetNotificationRulesParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationRuleWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateNotificationRuleRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateNotificationRule(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateNotificationRuleRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationRulesID(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRulesID(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchNotificationRulesIDRequestWithBody(c.service.ServerAPIURL(), ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchNotificationRulesID(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationRulesIDWithBody(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutNotificationRulesIDRequestWithBody(c.service.ServerAPIURL(), ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutNotificationRulesID(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutNotificationRulesIDRequest(c.service.ServerAPIURL(), ruleID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRulesIDLabels(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesIDLabelsRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationRuleIDLabelsWithBody(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostNotificationRuleIDLabelsRequestWithBody(c.service.ServerAPIURL(), ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostNotificationRuleIDLabels(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostNotificationRuleIDLabelsRequest(c.service.ServerAPIURL(), ruleID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteNotificationRulesIDLabelsID(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteNotificationRulesIDLabelsIDRequest(c.service.ServerAPIURL(), ruleID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetNotificationRulesIDQuery(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*http.Response, error) {
	req, err := NewGetNotificationRulesIDQueryRequest(c.service.ServerAPIURL(), ruleID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgs(ctx context.Context, params *GetOrgsParams) (*http.Response, error) {
	req, err := NewGetOrgsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsWithBody(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgs(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteOrgsID(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*http.Response, error) {
	req, err := NewDeleteOrgsIDRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsID(ctx context.Context, orgID string, params *GetOrgsIDParams) (*http.Response, error) {
	req, err := NewGetOrgsIDRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsIDWithBody(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchOrgsIDRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsID(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchOrgsIDRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsIDMembers(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*http.Response, error) {
	req, err := NewGetOrgsIDMembersRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDMembersWithBody(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsIDMembersRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDMembers(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsIDMembersRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteOrgsIDMembersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteOrgsIDMembersIDRequest(c.service.ServerAPIURL(), orgID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsIDOwners(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetOrgsIDOwnersRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDOwnersWithBody(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsIDOwnersRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDOwners(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsIDOwnersRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteOrgsIDOwnersID(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteOrgsIDOwnersIDRequest(c.service.ServerAPIURL(), orgID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetOrgsIDSecrets(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*http.Response, error) {
	req, err := NewGetOrgsIDSecretsRequest(c.service.ServerAPIURL(), orgID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchOrgsIDSecretsRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchOrgsIDSecrets(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchOrgsIDSecretsRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDSecretsWithBody(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostOrgsIDSecretsRequestWithBody(c.service.ServerAPIURL(), orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostOrgsIDSecrets(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostOrgsIDSecretsRequest(c.service.ServerAPIURL(), orgID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryWithBody(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostQueryRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQuery(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*http.Response, error) {
	req, err := NewPostQueryRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAnalyzeWithBody(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostQueryAnalyzeRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAnalyze(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*http.Response, error) {
	req, err := NewPostQueryAnalyzeRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAstWithBody(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostQueryAstRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostQueryAst(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*http.Response, error) {
	req, err := NewPostQueryAstRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetQuerySuggestions(ctx context.Context, params *GetQuerySuggestionsParams) (*http.Response, error) {
	req, err := NewGetQuerySuggestionsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetQuerySuggestionsName(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*http.Response, error) {
	req, err := NewGetQuerySuggestionsNameRequest(c.service.ServerAPIURL(), name, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetReady(ctx context.Context, params *GetReadyParams) (*http.Response, error) {
	req, err := NewGetReadyRequest(c.service.ServerURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapers(ctx context.Context, params *GetScrapersParams) (*http.Response, error) {
	req, err := NewGetScrapersRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersWithBody(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapers(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersID(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersID(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*http.Response, error) {
	req, err := NewGetScrapersIDRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchScrapersIDWithBody(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchScrapersIDRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchScrapersID(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchScrapersIDRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersIDLabels(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*http.Response, error) {
	req, err := NewGetScrapersIDLabelsRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDLabelsWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersIDLabelsRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDLabels(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersIDLabelsRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersIDLabelsID(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDLabelsIDRequest(c.service.ServerAPIURL(), scraperTargetID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersIDMembers(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*http.Response, error) {
	req, err := NewGetScrapersIDMembersRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDMembersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersIDMembersRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDMembers(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersIDMembersRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersIDMembersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDMembersIDRequest(c.service.ServerAPIURL(), scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetScrapersIDOwners(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*http.Response, error) {
	req, err := NewGetScrapersIDOwnersRequest(c.service.ServerAPIURL(), scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDOwnersWithBody(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostScrapersIDOwnersRequestWithBody(c.service.ServerAPIURL(), scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostScrapersIDOwners(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostScrapersIDOwnersRequest(c.service.ServerAPIURL(), scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteScrapersIDOwnersID(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteScrapersIDOwnersIDRequest(c.service.ServerAPIURL(), scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSetup(ctx context.Context, params *GetSetupParams) (*http.Response, error) {
	req, err := NewGetSetupRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetupWithBody(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostSetupRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetup(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*http.Response, error) {
	req, err := NewPostSetupRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetupUserWithBody(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostSetupUserRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSetupUser(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*http.Response, error) {
	req, err := NewPostSetupUserRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSignin(ctx context.Context, params *PostSigninParams) (*http.Response, error) {
	req, err := NewPostSigninRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSignout(ctx context.Context, params *PostSignoutParams) (*http.Response, error) {
	req, err := NewPostSignoutRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSources(ctx context.Context, params *GetSourcesParams) (*http.Response, error) {
	req, err := NewGetSourcesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSourcesWithBody(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostSourcesRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostSources(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*http.Response, error) {
	req, err := NewPostSourcesRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteSourcesID(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*http.Response, error) {
	req, err := NewDeleteSourcesIDRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSourcesID(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*http.Response, error) {
	req, err := NewGetSourcesIDRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchSourcesIDWithBody(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchSourcesIDRequestWithBody(c.service.ServerAPIURL(), sourceID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchSourcesID(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchSourcesIDRequest(c.service.ServerAPIURL(), sourceID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSourcesIDBuckets(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*http.Response, error) {
	req, err := NewGetSourcesIDBucketsRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetSourcesIDHealth(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*http.Response, error) {
	req, err := NewGetSourcesIDHealthRequest(c.service.ServerAPIURL(), sourceID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ListStacks(ctx context.Context, params *ListStacksParams) (*http.Response, error) {
	req, err := NewListStacksRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateStackWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewCreateStackRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) CreateStack(ctx context.Context, body CreateStackJSONRequestBody) (*http.Response, error) {
	req, err := NewCreateStackRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteStack(ctx context.Context, stackId string, params *DeleteStackParams) (*http.Response, error) {
	req, err := NewDeleteStackRequest(c.service.ServerAPIURL(), stackId, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ReadStack(ctx context.Context, stackId string) (*http.Response, error) {
	req, err := NewReadStackRequest(c.service.ServerAPIURL(), stackId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) UpdateStackWithBody(ctx context.Context, stackId string, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewUpdateStackRequestWithBody(c.service.ServerAPIURL(), stackId, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) UpdateStack(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*http.Response, error) {
	req, err := NewUpdateStackRequest(c.service.ServerAPIURL(), stackId, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) UninstallStack(ctx context.Context, stackId string) (*http.Response, error) {
	req, err := NewUninstallStackRequest(c.service.ServerAPIURL(), stackId)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasks(ctx context.Context, params *GetTasksParams) (*http.Response, error) {
	req, err := NewGetTasksRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksWithBody(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasks(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksID(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksID(ctx context.Context, taskID string, params *GetTasksIDParams) (*http.Response, error) {
	req, err := NewGetTasksIDRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchTasksIDWithBody(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchTasksIDRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchTasksID(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchTasksIDRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDLabels(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*http.Response, error) {
	req, err := NewGetTasksIDLabelsRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDLabelsWithBody(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDLabelsRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDLabels(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDLabelsRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDLabelsID(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDLabelsIDRequest(c.service.ServerAPIURL(), taskID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDLogs(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*http.Response, error) {
	req, err := NewGetTasksIDLogsRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDMembers(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*http.Response, error) {
	req, err := NewGetTasksIDMembersRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDMembersWithBody(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDMembersRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDMembers(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDMembersRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDMembersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDMembersIDRequest(c.service.ServerAPIURL(), taskID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDOwners(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*http.Response, error) {
	req, err := NewGetTasksIDOwnersRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDOwnersWithBody(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDOwnersRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDOwners(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDOwnersRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDOwnersID(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDOwnersIDRequest(c.service.ServerAPIURL(), taskID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDRuns(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*http.Response, error) {
	req, err := NewGetTasksIDRunsRequest(c.service.ServerAPIURL(), taskID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDRunsWithBody(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTasksIDRunsRequestWithBody(c.service.ServerAPIURL(), taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDRuns(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTasksIDRunsRequest(c.service.ServerAPIURL(), taskID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTasksIDRunsID(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*http.Response, error) {
	req, err := NewDeleteTasksIDRunsIDRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDRunsID(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*http.Response, error) {
	req, err := NewGetTasksIDRunsIDRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTasksIDRunsIDLogs(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*http.Response, error) {
	req, err := NewGetTasksIDRunsIDLogsRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTasksIDRunsIDRetry(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*http.Response, error) {
	req, err := NewPostTasksIDRunsIDRetryRequest(c.service.ServerAPIURL(), taskID, runID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafPlugins(ctx context.Context, params *GetTelegrafPluginsParams) (*http.Response, error) {
	req, err := NewGetTelegrafPluginsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafs(ctx context.Context, params *GetTelegrafsParams) (*http.Response, error) {
	req, err := NewGetTelegrafsRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsWithBody(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafs(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsID(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsID(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutTelegrafsIDWithBody(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutTelegrafsIDRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutTelegrafsID(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutTelegrafsIDRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsIDLabels(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDLabelsRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDLabelsWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsIDLabelsRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDLabels(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsIDLabelsRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsIDLabelsID(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDLabelsIDRequest(c.service.ServerAPIURL(), telegrafID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsIDMembers(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDMembersRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDMembersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsIDMembersRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDMembers(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsIDMembersRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsIDMembersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDMembersIDRequest(c.service.ServerAPIURL(), telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetTelegrafsIDOwners(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*http.Response, error) {
	req, err := NewGetTelegrafsIDOwnersRequest(c.service.ServerAPIURL(), telegrafID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDOwnersWithBody(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostTelegrafsIDOwnersRequestWithBody(c.service.ServerAPIURL(), telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostTelegrafsIDOwners(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostTelegrafsIDOwnersRequest(c.service.ServerAPIURL(), telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteTelegrafsIDOwnersID(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*http.Response, error) {
	req, err := NewDeleteTelegrafsIDOwnersIDRequest(c.service.ServerAPIURL(), telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ApplyTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewApplyTemplateRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ApplyTemplate(ctx context.Context, body ApplyTemplateJSONRequestBody) (*http.Response, error) {
	req, err := NewApplyTemplateRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ExportTemplateWithBody(ctx context.Context, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewExportTemplateRequestWithBody(c.service.ServerAPIURL(), contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) ExportTemplate(ctx context.Context, body ExportTemplateJSONRequestBody) (*http.Response, error) {
	req, err := NewExportTemplateRequest(c.service.ServerAPIURL(), body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetUsers(ctx context.Context, params *GetUsersParams) (*http.Response, error) {
	req, err := NewGetUsersRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsersWithBody(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostUsersRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsers(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*http.Response, error) {
	req, err := NewPostUsersRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteUsersID(ctx context.Context, userID string, params *DeleteUsersIDParams) (*http.Response, error) {
	req, err := NewDeleteUsersIDRequest(c.service.ServerAPIURL(), userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetUsersID(ctx context.Context, userID string, params *GetUsersIDParams) (*http.Response, error) {
	req, err := NewGetUsersIDRequest(c.service.ServerAPIURL(), userID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchUsersIDWithBody(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchUsersIDRequestWithBody(c.service.ServerAPIURL(), userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchUsersID(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchUsersIDRequest(c.service.ServerAPIURL(), userID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsersIDPasswordWithBody(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostUsersIDPasswordRequestWithBody(c.service.ServerAPIURL(), userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostUsersIDPassword(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*http.Response, error) {
	req, err := NewPostUsersIDPasswordRequest(c.service.ServerAPIURL(), userID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetVariables(ctx context.Context, params *GetVariablesParams) (*http.Response, error) {
	req, err := NewGetVariablesRequest(c.service.ServerAPIURL(), params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariablesWithBody(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostVariablesRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariables(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*http.Response, error) {
	req, err := NewPostVariablesRequest(c.service.ServerAPIURL(), params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteVariablesID(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*http.Response, error) {
	req, err := NewDeleteVariablesIDRequest(c.service.ServerAPIURL(), variableID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetVariablesID(ctx context.Context, variableID string, params *GetVariablesIDParams) (*http.Response, error) {
	req, err := NewGetVariablesIDRequest(c.service.ServerAPIURL(), variableID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchVariablesIDWithBody(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPatchVariablesIDRequestWithBody(c.service.ServerAPIURL(), variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PatchVariablesID(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPatchVariablesIDRequest(c.service.ServerAPIURL(), variableID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutVariablesIDWithBody(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPutVariablesIDRequestWithBody(c.service.ServerAPIURL(), variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PutVariablesID(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*http.Response, error) {
	req, err := NewPutVariablesIDRequest(c.service.ServerAPIURL(), variableID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) GetVariablesIDLabels(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*http.Response, error) {
	req, err := NewGetVariablesIDLabelsRequest(c.service.ServerAPIURL(), variableID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariablesIDLabelsWithBody(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostVariablesIDLabelsRequestWithBody(c.service.ServerAPIURL(), variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostVariablesIDLabels(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*http.Response, error) {
	req, err := NewPostVariablesIDLabelsRequest(c.service.ServerAPIURL(), variableID, params, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) DeleteVariablesIDLabelsID(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*http.Response, error) {
	req, err := NewDeleteVariablesIDLabelsIDRequest(c.service.ServerAPIURL(), variableID, labelID, params)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

func (c *Client) PostWriteWithBody(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*http.Response, error) {
	req, err := NewPostWriteRequestWithBody(c.service.ServerAPIURL(), params, contentType, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return c.service.DoHTTPRequestWithResponse(req, nil)
}

// NewGetRoutesRequest generates requests for GetRoutes
func NewGetRoutesRequest(server string, params *GetRoutesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetAuthorizationsRequest generates requests for GetAuthorizations
func NewGetAuthorizationsRequest(server string, params *GetAuthorizationsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.UserID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "userID", *params.UserID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.User != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "user", *params.User); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostAuthorizationsRequest calls the generic PostAuthorizations builder with application/json body
func NewPostAuthorizationsRequest(server string, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostAuthorizationsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostAuthorizationsRequestWithBody generates requests for PostAuthorizations with any type of body
func NewPostAuthorizationsRequestWithBody(server string, params *PostAuthorizationsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteAuthorizationsIDRequest generates requests for DeleteAuthorizationsID
func NewDeleteAuthorizationsIDRequest(server string, authID string, params *DeleteAuthorizationsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "authID", authID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetAuthorizationsIDRequest generates requests for GetAuthorizationsID
func NewGetAuthorizationsIDRequest(server string, authID string, params *GetAuthorizationsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "authID", authID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchAuthorizationsIDRequest calls the generic PatchAuthorizationsID builder with application/json body
func NewPatchAuthorizationsIDRequest(server string, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchAuthorizationsIDRequestWithBody(server, authID, params, "application/json", bodyReader)
}

// NewPatchAuthorizationsIDRequestWithBody generates requests for PatchAuthorizationsID with any type of body
func NewPatchAuthorizationsIDRequestWithBody(server string, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "authID", authID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/authorizations/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetBucketsRequest generates requests for GetBuckets
func NewGetBucketsRequest(server string, params *GetBucketsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.After != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "after", *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsRequest calls the generic PostBuckets builder with application/json body
func NewPostBucketsRequest(server string, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostBucketsRequestWithBody generates requests for PostBuckets with any type of body
func NewPostBucketsRequestWithBody(server string, params *PostBucketsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDRequest generates requests for DeleteBucketsID
func NewDeleteBucketsIDRequest(server string, bucketID string, params *DeleteBucketsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetBucketsIDRequest generates requests for GetBucketsID
func NewGetBucketsIDRequest(server string, bucketID string, params *GetBucketsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchBucketsIDRequest calls the generic PatchBucketsID builder with application/json body
func NewPatchBucketsIDRequest(server string, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchBucketsIDRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPatchBucketsIDRequestWithBody generates requests for PatchBucketsID with any type of body
func NewPatchBucketsIDRequestWithBody(server string, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetBucketsIDLabelsRequest generates requests for GetBucketsIDLabels
func NewGetBucketsIDLabelsRequest(server string, bucketID string, params *GetBucketsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsIDLabelsRequest calls the generic PostBucketsIDLabels builder with application/json body
func NewPostBucketsIDLabelsRequest(server string, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsIDLabelsRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPostBucketsIDLabelsRequestWithBody generates requests for PostBucketsIDLabels with any type of body
func NewPostBucketsIDLabelsRequestWithBody(server string, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDLabelsIDRequest generates requests for DeleteBucketsIDLabelsID
func NewDeleteBucketsIDLabelsIDRequest(server string, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetBucketsIDMembersRequest generates requests for GetBucketsIDMembers
func NewGetBucketsIDMembersRequest(server string, bucketID string, params *GetBucketsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsIDMembersRequest calls the generic PostBucketsIDMembers builder with application/json body
func NewPostBucketsIDMembersRequest(server string, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsIDMembersRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPostBucketsIDMembersRequestWithBody generates requests for PostBucketsIDMembers with any type of body
func NewPostBucketsIDMembersRequestWithBody(server string, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDMembersIDRequest generates requests for DeleteBucketsIDMembersID
func NewDeleteBucketsIDMembersIDRequest(server string, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetBucketsIDOwnersRequest generates requests for GetBucketsIDOwners
func NewGetBucketsIDOwnersRequest(server string, bucketID string, params *GetBucketsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostBucketsIDOwnersRequest calls the generic PostBucketsIDOwners builder with application/json body
func NewPostBucketsIDOwnersRequest(server string, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostBucketsIDOwnersRequestWithBody(server, bucketID, params, "application/json", bodyReader)
}

// NewPostBucketsIDOwnersRequestWithBody generates requests for PostBucketsIDOwners with any type of body
func NewPostBucketsIDOwnersRequestWithBody(server string, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteBucketsIDOwnersIDRequest generates requests for DeleteBucketsIDOwnersID
func NewDeleteBucketsIDOwnersIDRequest(server string, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "bucketID", bucketID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/buckets/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetChecksRequest generates requests for GetChecks
func NewGetChecksRequest(server string, params *GetChecksParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewCreateCheckRequest calls the generic CreateCheck builder with application/json body
func NewCreateCheckRequest(server string, body CreateCheckJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateCheckRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateCheckRequestWithBody generates requests for CreateCheck with any type of body
func NewCreateCheckRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteChecksIDRequest generates requests for DeleteChecksID
func NewDeleteChecksIDRequest(server string, checkID string, params *DeleteChecksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetChecksIDRequest generates requests for GetChecksID
func NewGetChecksIDRequest(server string, checkID string, params *GetChecksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchChecksIDRequest calls the generic PatchChecksID builder with application/json body
func NewPatchChecksIDRequest(server string, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchChecksIDRequestWithBody(server, checkID, params, "application/json", bodyReader)
}

// NewPatchChecksIDRequestWithBody generates requests for PatchChecksID with any type of body
func NewPatchChecksIDRequestWithBody(server string, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutChecksIDRequest calls the generic PutChecksID builder with application/json body
func NewPutChecksIDRequest(server string, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutChecksIDRequestWithBody(server, checkID, params, "application/json", bodyReader)
}

// NewPutChecksIDRequestWithBody generates requests for PutChecksID with any type of body
func NewPutChecksIDRequestWithBody(server string, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetChecksIDLabelsRequest generates requests for GetChecksIDLabels
func NewGetChecksIDLabelsRequest(server string, checkID string, params *GetChecksIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostChecksIDLabelsRequest calls the generic PostChecksIDLabels builder with application/json body
func NewPostChecksIDLabelsRequest(server string, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostChecksIDLabelsRequestWithBody(server, checkID, params, "application/json", bodyReader)
}

// NewPostChecksIDLabelsRequestWithBody generates requests for PostChecksIDLabels with any type of body
func NewPostChecksIDLabelsRequestWithBody(server string, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteChecksIDLabelsIDRequest generates requests for DeleteChecksIDLabelsID
func NewDeleteChecksIDLabelsIDRequest(server string, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetChecksIDQueryRequest generates requests for GetChecksIDQuery
func NewGetChecksIDQueryRequest(server string, checkID string, params *GetChecksIDQueryParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "checkID", checkID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/checks/%s/query", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsRequest generates requests for GetDashboards
func NewGetDashboardsRequest(server string, params *GetDashboardsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Descending != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "descending", *params.Descending); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Owner != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "owner", *params.Owner); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.SortBy != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "sortBy", *params.SortBy); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "id", *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsRequest calls the generic PostDashboards builder with application/json body
func NewPostDashboardsRequest(server string, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDashboardsRequestWithBody generates requests for PostDashboards with any type of body
func NewPostDashboardsRequestWithBody(server string, params *PostDashboardsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDRequest generates requests for DeleteDashboardsID
func NewDeleteDashboardsIDRequest(server string, dashboardID string, params *DeleteDashboardsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsIDRequest generates requests for GetDashboardsID
func NewGetDashboardsIDRequest(server string, dashboardID string, params *GetDashboardsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Include != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "include", *params.Include); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDashboardsIDRequest calls the generic PatchDashboardsID builder with application/json body
func NewPatchDashboardsIDRequest(server string, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDashboardsIDRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPatchDashboardsIDRequestWithBody generates requests for PatchDashboardsID with any type of body
func NewPatchDashboardsIDRequestWithBody(server string, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostDashboardsIDCellsRequest calls the generic PostDashboardsIDCells builder with application/json body
func NewPostDashboardsIDCellsRequest(server string, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDCellsRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDCellsRequestWithBody generates requests for PostDashboardsIDCells with any type of body
func NewPostDashboardsIDCellsRequestWithBody(server string, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutDashboardsIDCellsRequest calls the generic PutDashboardsIDCells builder with application/json body
func NewPutDashboardsIDCellsRequest(server string, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutDashboardsIDCellsRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPutDashboardsIDCellsRequestWithBody generates requests for PutDashboardsIDCells with any type of body
func NewPutDashboardsIDCellsRequestWithBody(server string, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDCellsIDRequest generates requests for DeleteDashboardsIDCellsID
func NewDeleteDashboardsIDCellsIDRequest(server string, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDashboardsIDCellsIDRequest calls the generic PatchDashboardsIDCellsID builder with application/json body
func NewPatchDashboardsIDCellsIDRequest(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDashboardsIDCellsIDRequestWithBody(server, dashboardID, cellID, params, "application/json", bodyReader)
}

// NewPatchDashboardsIDCellsIDRequestWithBody generates requests for PatchDashboardsIDCellsID with any type of body
func NewPatchDashboardsIDCellsIDRequestWithBody(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDashboardsIDCellsIDViewRequest generates requests for GetDashboardsIDCellsIDView
func NewGetDashboardsIDCellsIDViewRequest(server string, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s/view", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDashboardsIDCellsIDViewRequest calls the generic PatchDashboardsIDCellsIDView builder with application/json body
func NewPatchDashboardsIDCellsIDViewRequest(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDashboardsIDCellsIDViewRequestWithBody(server, dashboardID, cellID, params, "application/json", bodyReader)
}

// NewPatchDashboardsIDCellsIDViewRequestWithBody generates requests for PatchDashboardsIDCellsIDView with any type of body
func NewPatchDashboardsIDCellsIDViewRequestWithBody(server string, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "cellID", cellID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/cells/%s/view", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDashboardsIDLabelsRequest generates requests for GetDashboardsIDLabels
func NewGetDashboardsIDLabelsRequest(server string, dashboardID string, params *GetDashboardsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsIDLabelsRequest calls the generic PostDashboardsIDLabels builder with application/json body
func NewPostDashboardsIDLabelsRequest(server string, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDLabelsRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDLabelsRequestWithBody generates requests for PostDashboardsIDLabels with any type of body
func NewPostDashboardsIDLabelsRequestWithBody(server string, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDLabelsIDRequest generates requests for DeleteDashboardsIDLabelsID
func NewDeleteDashboardsIDLabelsIDRequest(server string, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsIDMembersRequest generates requests for GetDashboardsIDMembers
func NewGetDashboardsIDMembersRequest(server string, dashboardID string, params *GetDashboardsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsIDMembersRequest calls the generic PostDashboardsIDMembers builder with application/json body
func NewPostDashboardsIDMembersRequest(server string, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDMembersRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDMembersRequestWithBody generates requests for PostDashboardsIDMembers with any type of body
func NewPostDashboardsIDMembersRequestWithBody(server string, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDMembersIDRequest generates requests for DeleteDashboardsIDMembersID
func NewDeleteDashboardsIDMembersIDRequest(server string, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDashboardsIDOwnersRequest generates requests for GetDashboardsIDOwners
func NewGetDashboardsIDOwnersRequest(server string, dashboardID string, params *GetDashboardsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDashboardsIDOwnersRequest calls the generic PostDashboardsIDOwners builder with application/json body
func NewPostDashboardsIDOwnersRequest(server string, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDashboardsIDOwnersRequestWithBody(server, dashboardID, params, "application/json", bodyReader)
}

// NewPostDashboardsIDOwnersRequestWithBody generates requests for PostDashboardsIDOwners with any type of body
func NewPostDashboardsIDOwnersRequestWithBody(server string, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDashboardsIDOwnersIDRequest generates requests for DeleteDashboardsIDOwnersID
func NewDeleteDashboardsIDOwnersIDRequest(server string, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dashboardID", dashboardID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dashboards/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDBRPsRequest generates requests for GetDBRPs
func NewGetDBRPsRequest(server string, params *GetDBRPsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "id", *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BucketID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "bucketID", *params.BucketID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Default != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "default", *params.Default); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Db != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "db", *params.Db); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Rp != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "rp", *params.Rp); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDBRPRequest calls the generic PostDBRP builder with application/json body
func NewPostDBRPRequest(server string, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDBRPRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDBRPRequestWithBody generates requests for PostDBRP with any type of body
func NewPostDBRPRequestWithBody(server string, params *PostDBRPParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDBRPIDRequest generates requests for DeleteDBRPID
func NewDeleteDBRPIDRequest(server string, dbrpID string, params *DeleteDBRPIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dbrpID", dbrpID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDBRPsIDRequest generates requests for GetDBRPsID
func NewGetDBRPsIDRequest(server string, dbrpID string, params *GetDBRPsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dbrpID", dbrpID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchDBRPIDRequest calls the generic PatchDBRPID builder with application/json body
func NewPatchDBRPIDRequest(server string, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchDBRPIDRequestWithBody(server, dbrpID, params, "application/json", bodyReader)
}

// NewPatchDBRPIDRequestWithBody generates requests for PatchDBRPID with any type of body
func NewPatchDBRPIDRequestWithBody(server string, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "dbrpID", dbrpID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/dbrps/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostDeleteRequest calls the generic PostDelete builder with application/json body
func NewPostDeleteRequest(server string, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDeleteRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDeleteRequestWithBody generates requests for PostDelete with any type of body
func NewPostDeleteRequestWithBody(server string, params *PostDeleteParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/delete")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Bucket != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "bucket", *params.Bucket); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BucketID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "bucketID", *params.BucketID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDocumentsTemplatesRequest generates requests for GetDocumentsTemplates
func NewGetDocumentsTemplatesRequest(server string, params *GetDocumentsTemplatesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDocumentsTemplatesRequest calls the generic PostDocumentsTemplates builder with application/json body
func NewPostDocumentsTemplatesRequest(server string, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDocumentsTemplatesRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostDocumentsTemplatesRequestWithBody generates requests for PostDocumentsTemplates with any type of body
func NewPostDocumentsTemplatesRequestWithBody(server string, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDocumentsTemplatesIDRequest generates requests for DeleteDocumentsTemplatesID
func NewDeleteDocumentsTemplatesIDRequest(server string, templateID string, params *DeleteDocumentsTemplatesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetDocumentsTemplatesIDRequest generates requests for GetDocumentsTemplatesID
func NewGetDocumentsTemplatesIDRequest(server string, templateID string, params *GetDocumentsTemplatesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPutDocumentsTemplatesIDRequest calls the generic PutDocumentsTemplatesID builder with application/json body
func NewPutDocumentsTemplatesIDRequest(server string, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutDocumentsTemplatesIDRequestWithBody(server, templateID, params, "application/json", bodyReader)
}

// NewPutDocumentsTemplatesIDRequestWithBody generates requests for PutDocumentsTemplatesID with any type of body
func NewPutDocumentsTemplatesIDRequestWithBody(server string, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetDocumentsTemplatesIDLabelsRequest generates requests for GetDocumentsTemplatesIDLabels
func NewGetDocumentsTemplatesIDLabelsRequest(server string, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostDocumentsTemplatesIDLabelsRequest calls the generic PostDocumentsTemplatesIDLabels builder with application/json body
func NewPostDocumentsTemplatesIDLabelsRequest(server string, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostDocumentsTemplatesIDLabelsRequestWithBody(server, templateID, params, "application/json", bodyReader)
}

// NewPostDocumentsTemplatesIDLabelsRequestWithBody generates requests for PostDocumentsTemplatesIDLabels with any type of body
func NewPostDocumentsTemplatesIDLabelsRequestWithBody(server string, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteDocumentsTemplatesIDLabelsIDRequest generates requests for DeleteDocumentsTemplatesIDLabelsID
func NewDeleteDocumentsTemplatesIDLabelsIDRequest(server string, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "templateID", templateID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/documents/templates/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetFlagsRequest generates requests for GetFlags
func NewGetFlagsRequest(server string, params *GetFlagsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/flags")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetHealthRequest generates requests for GetHealth
func NewGetHealthRequest(server string, params *GetHealthParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/health")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetLabelsRequest generates requests for GetLabels
func NewGetLabelsRequest(server string, params *GetLabelsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostLabelsRequest calls the generic PostLabels builder with application/json body
func NewPostLabelsRequest(server string, body PostLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostLabelsRequestWithBody(server, "application/json", bodyReader)
}

// NewPostLabelsRequestWithBody generates requests for PostLabels with any type of body
func NewPostLabelsRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteLabelsIDRequest generates requests for DeleteLabelsID
func NewDeleteLabelsIDRequest(server string, labelID string, params *DeleteLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetLabelsIDRequest generates requests for GetLabelsID
func NewGetLabelsIDRequest(server string, labelID string, params *GetLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchLabelsIDRequest calls the generic PatchLabelsID builder with application/json body
func NewPatchLabelsIDRequest(server string, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchLabelsIDRequestWithBody(server, labelID, params, "application/json", bodyReader)
}

// NewPatchLabelsIDRequestWithBody generates requests for PatchLabelsID with any type of body
func NewPatchLabelsIDRequestWithBody(server string, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/labels/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetMeRequest generates requests for GetMe
func NewGetMeRequest(server string, params *GetMeParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/me")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPutMePasswordRequest calls the generic PutMePassword builder with application/json body
func NewPutMePasswordRequest(server string, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutMePasswordRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPutMePasswordRequestWithBody generates requests for PutMePassword with any type of body
func NewPutMePasswordRequestWithBody(server string, params *PutMePasswordParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/me/password")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetNotificationEndpointsRequest generates requests for GetNotificationEndpoints
func NewGetNotificationEndpointsRequest(server string, params *GetNotificationEndpointsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewCreateNotificationEndpointRequest calls the generic CreateNotificationEndpoint builder with application/json body
func NewCreateNotificationEndpointRequest(server string, body CreateNotificationEndpointJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateNotificationEndpointRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateNotificationEndpointRequestWithBody generates requests for CreateNotificationEndpoint with any type of body
func NewCreateNotificationEndpointRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationEndpointsIDRequest generates requests for DeleteNotificationEndpointsID
func NewDeleteNotificationEndpointsIDRequest(server string, endpointID string, params *DeleteNotificationEndpointsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationEndpointsIDRequest generates requests for GetNotificationEndpointsID
func NewGetNotificationEndpointsIDRequest(server string, endpointID string, params *GetNotificationEndpointsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchNotificationEndpointsIDRequest calls the generic PatchNotificationEndpointsID builder with application/json body
func NewPatchNotificationEndpointsIDRequest(server string, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchNotificationEndpointsIDRequestWithBody(server, endpointID, params, "application/json", bodyReader)
}

// NewPatchNotificationEndpointsIDRequestWithBody generates requests for PatchNotificationEndpointsID with any type of body
func NewPatchNotificationEndpointsIDRequestWithBody(server string, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutNotificationEndpointsIDRequest calls the generic PutNotificationEndpointsID builder with application/json body
func NewPutNotificationEndpointsIDRequest(server string, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutNotificationEndpointsIDRequestWithBody(server, endpointID, params, "application/json", bodyReader)
}

// NewPutNotificationEndpointsIDRequestWithBody generates requests for PutNotificationEndpointsID with any type of body
func NewPutNotificationEndpointsIDRequestWithBody(server string, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetNotificationEndpointsIDLabelsRequest generates requests for GetNotificationEndpointsIDLabels
func NewGetNotificationEndpointsIDLabelsRequest(server string, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostNotificationEndpointIDLabelsRequest calls the generic PostNotificationEndpointIDLabels builder with application/json body
func NewPostNotificationEndpointIDLabelsRequest(server string, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostNotificationEndpointIDLabelsRequestWithBody(server, endpointID, params, "application/json", bodyReader)
}

// NewPostNotificationEndpointIDLabelsRequestWithBody generates requests for PostNotificationEndpointIDLabels with any type of body
func NewPostNotificationEndpointIDLabelsRequestWithBody(server string, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationEndpointsIDLabelsIDRequest generates requests for DeleteNotificationEndpointsIDLabelsID
func NewDeleteNotificationEndpointsIDLabelsIDRequest(server string, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "endpointID", endpointID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationEndpoints/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationRulesRequest generates requests for GetNotificationRules
func NewGetNotificationRulesRequest(server string, params *GetNotificationRulesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.CheckID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "checkID", *params.CheckID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Tag != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "tag", *params.Tag); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewCreateNotificationRuleRequest calls the generic CreateNotificationRule builder with application/json body
func NewCreateNotificationRuleRequest(server string, body CreateNotificationRuleJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateNotificationRuleRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateNotificationRuleRequestWithBody generates requests for CreateNotificationRule with any type of body
func NewCreateNotificationRuleRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationRulesIDRequest generates requests for DeleteNotificationRulesID
func NewDeleteNotificationRulesIDRequest(server string, ruleID string, params *DeleteNotificationRulesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationRulesIDRequest generates requests for GetNotificationRulesID
func NewGetNotificationRulesIDRequest(server string, ruleID string, params *GetNotificationRulesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchNotificationRulesIDRequest calls the generic PatchNotificationRulesID builder with application/json body
func NewPatchNotificationRulesIDRequest(server string, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchNotificationRulesIDRequestWithBody(server, ruleID, params, "application/json", bodyReader)
}

// NewPatchNotificationRulesIDRequestWithBody generates requests for PatchNotificationRulesID with any type of body
func NewPatchNotificationRulesIDRequestWithBody(server string, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutNotificationRulesIDRequest calls the generic PutNotificationRulesID builder with application/json body
func NewPutNotificationRulesIDRequest(server string, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutNotificationRulesIDRequestWithBody(server, ruleID, params, "application/json", bodyReader)
}

// NewPutNotificationRulesIDRequestWithBody generates requests for PutNotificationRulesID with any type of body
func NewPutNotificationRulesIDRequestWithBody(server string, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetNotificationRulesIDLabelsRequest generates requests for GetNotificationRulesIDLabels
func NewGetNotificationRulesIDLabelsRequest(server string, ruleID string, params *GetNotificationRulesIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostNotificationRuleIDLabelsRequest calls the generic PostNotificationRuleIDLabels builder with application/json body
func NewPostNotificationRuleIDLabelsRequest(server string, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostNotificationRuleIDLabelsRequestWithBody(server, ruleID, params, "application/json", bodyReader)
}

// NewPostNotificationRuleIDLabelsRequestWithBody generates requests for PostNotificationRuleIDLabels with any type of body
func NewPostNotificationRuleIDLabelsRequestWithBody(server string, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteNotificationRulesIDLabelsIDRequest generates requests for DeleteNotificationRulesIDLabelsID
func NewDeleteNotificationRulesIDLabelsIDRequest(server string, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetNotificationRulesIDQueryRequest generates requests for GetNotificationRulesIDQuery
func NewGetNotificationRulesIDQueryRequest(server string, ruleID string, params *GetNotificationRulesIDQueryParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "ruleID", ruleID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/notificationRules/%s/query", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsRequest generates requests for GetOrgs
func NewGetOrgsRequest(server string, params *GetOrgsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Offset != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "offset", *params.Offset); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Descending != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "descending", *params.Descending); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.UserID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "userID", *params.UserID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostOrgsRequest calls the generic PostOrgs builder with application/json body
func NewPostOrgsRequest(server string, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostOrgsRequestWithBody generates requests for PostOrgs with any type of body
func NewPostOrgsRequestWithBody(server string, params *PostOrgsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteOrgsIDRequest generates requests for DeleteOrgsID
func NewDeleteOrgsIDRequest(server string, orgID string, params *DeleteOrgsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsIDRequest generates requests for GetOrgsID
func NewGetOrgsIDRequest(server string, orgID string, params *GetOrgsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchOrgsIDRequest calls the generic PatchOrgsID builder with application/json body
func NewPatchOrgsIDRequest(server string, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchOrgsIDRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPatchOrgsIDRequestWithBody generates requests for PatchOrgsID with any type of body
func NewPatchOrgsIDRequestWithBody(server string, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetOrgsIDMembersRequest generates requests for GetOrgsIDMembers
func NewGetOrgsIDMembersRequest(server string, orgID string, params *GetOrgsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostOrgsIDMembersRequest calls the generic PostOrgsIDMembers builder with application/json body
func NewPostOrgsIDMembersRequest(server string, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsIDMembersRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPostOrgsIDMembersRequestWithBody generates requests for PostOrgsIDMembers with any type of body
func NewPostOrgsIDMembersRequestWithBody(server string, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteOrgsIDMembersIDRequest generates requests for DeleteOrgsIDMembersID
func NewDeleteOrgsIDMembersIDRequest(server string, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsIDOwnersRequest generates requests for GetOrgsIDOwners
func NewGetOrgsIDOwnersRequest(server string, orgID string, params *GetOrgsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostOrgsIDOwnersRequest calls the generic PostOrgsIDOwners builder with application/json body
func NewPostOrgsIDOwnersRequest(server string, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsIDOwnersRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPostOrgsIDOwnersRequestWithBody generates requests for PostOrgsIDOwners with any type of body
func NewPostOrgsIDOwnersRequestWithBody(server string, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteOrgsIDOwnersIDRequest generates requests for DeleteOrgsIDOwnersID
func NewDeleteOrgsIDOwnersIDRequest(server string, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetOrgsIDSecretsRequest generates requests for GetOrgsIDSecrets
func NewGetOrgsIDSecretsRequest(server string, orgID string, params *GetOrgsIDSecretsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/secrets", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchOrgsIDSecretsRequest calls the generic PatchOrgsIDSecrets builder with application/json body
func NewPatchOrgsIDSecretsRequest(server string, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchOrgsIDSecretsRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPatchOrgsIDSecretsRequestWithBody generates requests for PatchOrgsIDSecrets with any type of body
func NewPatchOrgsIDSecretsRequestWithBody(server string, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/secrets", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostOrgsIDSecretsRequest calls the generic PostOrgsIDSecrets builder with application/json body
func NewPostOrgsIDSecretsRequest(server string, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostOrgsIDSecretsRequestWithBody(server, orgID, params, "application/json", bodyReader)
}

// NewPostOrgsIDSecretsRequestWithBody generates requests for PostOrgsIDSecrets with any type of body
func NewPostOrgsIDSecretsRequestWithBody(server string, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "orgID", orgID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/orgs/%s/secrets/delete", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostQueryRequest calls the generic PostQuery builder with application/json body
func NewPostQueryRequest(server string, params *PostQueryParams, body PostQueryJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostQueryRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostQueryRequestWithBody generates requests for PostQuery with any type of body
func NewPostQueryRequestWithBody(server string, params *PostQueryParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.AcceptEncoding != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Accept-Encoding", *params.AcceptEncoding)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Accept-Encoding", headerParam1)
	}

	if params.ContentType != nil {
		var headerParam2 string

		headerParam2, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam2)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostQueryAnalyzeRequest calls the generic PostQueryAnalyze builder with application/json body
func NewPostQueryAnalyzeRequest(server string, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostQueryAnalyzeRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostQueryAnalyzeRequestWithBody generates requests for PostQueryAnalyze with any type of body
func NewPostQueryAnalyzeRequestWithBody(server string, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/analyze")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.ContentType != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam1)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostQueryAstRequest calls the generic PostQueryAst builder with application/json body
func NewPostQueryAstRequest(server string, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostQueryAstRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostQueryAstRequestWithBody generates requests for PostQueryAst with any type of body
func NewPostQueryAstRequestWithBody(server string, params *PostQueryAstParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/ast")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.ContentType != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam1)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetQuerySuggestionsRequest generates requests for GetQuerySuggestions
func NewGetQuerySuggestionsRequest(server string, params *GetQuerySuggestionsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/suggestions")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetQuerySuggestionsNameRequest generates requests for GetQuerySuggestionsName
func NewGetQuerySuggestionsNameRequest(server string, name string, params *GetQuerySuggestionsNameParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "name", name)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/query/suggestions/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetReadyRequest generates requests for GetReady
func NewGetReadyRequest(server string, params *GetReadyParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/ready")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersRequest generates requests for GetScrapers
func NewGetScrapersRequest(server string, params *GetScrapersParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Id != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "id", *params.Id); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersRequest calls the generic PostScrapers builder with application/json body
func NewPostScrapersRequest(server string, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostScrapersRequestWithBody generates requests for PostScrapers with any type of body
func NewPostScrapersRequestWithBody(server string, params *PostScrapersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDRequest generates requests for DeleteScrapersID
func NewDeleteScrapersIDRequest(server string, scraperTargetID string, params *DeleteScrapersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersIDRequest generates requests for GetScrapersID
func NewGetScrapersIDRequest(server string, scraperTargetID string, params *GetScrapersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchScrapersIDRequest calls the generic PatchScrapersID builder with application/json body
func NewPatchScrapersIDRequest(server string, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchScrapersIDRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPatchScrapersIDRequestWithBody generates requests for PatchScrapersID with any type of body
func NewPatchScrapersIDRequestWithBody(server string, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetScrapersIDLabelsRequest generates requests for GetScrapersIDLabels
func NewGetScrapersIDLabelsRequest(server string, scraperTargetID string, params *GetScrapersIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersIDLabelsRequest calls the generic PostScrapersIDLabels builder with application/json body
func NewPostScrapersIDLabelsRequest(server string, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersIDLabelsRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPostScrapersIDLabelsRequestWithBody generates requests for PostScrapersIDLabels with any type of body
func NewPostScrapersIDLabelsRequestWithBody(server string, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDLabelsIDRequest generates requests for DeleteScrapersIDLabelsID
func NewDeleteScrapersIDLabelsIDRequest(server string, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersIDMembersRequest generates requests for GetScrapersIDMembers
func NewGetScrapersIDMembersRequest(server string, scraperTargetID string, params *GetScrapersIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersIDMembersRequest calls the generic PostScrapersIDMembers builder with application/json body
func NewPostScrapersIDMembersRequest(server string, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersIDMembersRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPostScrapersIDMembersRequestWithBody generates requests for PostScrapersIDMembers with any type of body
func NewPostScrapersIDMembersRequestWithBody(server string, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDMembersIDRequest generates requests for DeleteScrapersIDMembersID
func NewDeleteScrapersIDMembersIDRequest(server string, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetScrapersIDOwnersRequest generates requests for GetScrapersIDOwners
func NewGetScrapersIDOwnersRequest(server string, scraperTargetID string, params *GetScrapersIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostScrapersIDOwnersRequest calls the generic PostScrapersIDOwners builder with application/json body
func NewPostScrapersIDOwnersRequest(server string, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostScrapersIDOwnersRequestWithBody(server, scraperTargetID, params, "application/json", bodyReader)
}

// NewPostScrapersIDOwnersRequestWithBody generates requests for PostScrapersIDOwners with any type of body
func NewPostScrapersIDOwnersRequestWithBody(server string, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteScrapersIDOwnersIDRequest generates requests for DeleteScrapersIDOwnersID
func NewDeleteScrapersIDOwnersIDRequest(server string, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "scraperTargetID", scraperTargetID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/scrapers/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSetupRequest generates requests for GetSetup
func NewGetSetupRequest(server string, params *GetSetupParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/setup")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostSetupRequest calls the generic PostSetup builder with application/json body
func NewPostSetupRequest(server string, params *PostSetupParams, body PostSetupJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostSetupRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostSetupRequestWithBody generates requests for PostSetup with any type of body
func NewPostSetupRequestWithBody(server string, params *PostSetupParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/setup")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostSetupUserRequest calls the generic PostSetupUser builder with application/json body
func NewPostSetupUserRequest(server string, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostSetupUserRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostSetupUserRequestWithBody generates requests for PostSetupUser with any type of body
func NewPostSetupUserRequestWithBody(server string, params *PostSetupUserParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/setup/user")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostSigninRequest generates requests for PostSignin
func NewPostSigninRequest(server string, params *PostSigninParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/signin")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostSignoutRequest generates requests for PostSignout
func NewPostSignoutRequest(server string, params *PostSignoutParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/signout")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSourcesRequest generates requests for GetSources
func NewGetSourcesRequest(server string, params *GetSourcesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostSourcesRequest calls the generic PostSources builder with application/json body
func NewPostSourcesRequest(server string, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostSourcesRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostSourcesRequestWithBody generates requests for PostSources with any type of body
func NewPostSourcesRequestWithBody(server string, params *PostSourcesParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteSourcesIDRequest generates requests for DeleteSourcesID
func NewDeleteSourcesIDRequest(server string, sourceID string, params *DeleteSourcesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSourcesIDRequest generates requests for GetSourcesID
func NewGetSourcesIDRequest(server string, sourceID string, params *GetSourcesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchSourcesIDRequest calls the generic PatchSourcesID builder with application/json body
func NewPatchSourcesIDRequest(server string, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchSourcesIDRequestWithBody(server, sourceID, params, "application/json", bodyReader)
}

// NewPatchSourcesIDRequestWithBody generates requests for PatchSourcesID with any type of body
func NewPatchSourcesIDRequestWithBody(server string, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetSourcesIDBucketsRequest generates requests for GetSourcesIDBuckets
func NewGetSourcesIDBucketsRequest(server string, sourceID string, params *GetSourcesIDBucketsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s/buckets", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetSourcesIDHealthRequest generates requests for GetSourcesIDHealth
func NewGetSourcesIDHealthRequest(server string, sourceID string, params *GetSourcesIDHealthParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "sourceID", sourceID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/sources/%s/health", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewListStacksRequest generates requests for ListStacks
func NewListStacksRequest(server string, params *ListStacksParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.StackID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "stackID", *params.StackID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewCreateStackRequest calls the generic CreateStack builder with application/json body
func NewCreateStackRequest(server string, body CreateStackJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewCreateStackRequestWithBody(server, "application/json", bodyReader)
}

// NewCreateStackRequestWithBody generates requests for CreateStack with any type of body
func NewCreateStackRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteStackRequest generates requests for DeleteStack
func NewDeleteStackRequest(server string, stackId string, params *DeleteStackParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "orgID", params.OrgID); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewReadStackRequest generates requests for ReadStack
func NewReadStackRequest(server string, stackId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewUpdateStackRequest calls the generic UpdateStack builder with application/json body
func NewUpdateStackRequest(server string, stackId string, body UpdateStackJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewUpdateStackRequestWithBody(server, stackId, "application/json", bodyReader)
}

// NewUpdateStackRequestWithBody generates requests for UpdateStack with any type of body
func NewUpdateStackRequestWithBody(server string, stackId string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewUninstallStackRequest generates requests for UninstallStack
func NewUninstallStackRequest(server string, stackId string) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "stack_id", stackId)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/stacks/%s/uninstall", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	return req, nil
}

// NewGetTasksRequest generates requests for GetTasks
func NewGetTasksRequest(server string, params *GetTasksParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Name != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "name", *params.Name); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.After != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "after", *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.User != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "user", *params.User); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Status != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "status", *params.Status); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksRequest calls the generic PostTasks builder with application/json body
func NewPostTasksRequest(server string, params *PostTasksParams, body PostTasksJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostTasksRequestWithBody generates requests for PostTasks with any type of body
func NewPostTasksRequestWithBody(server string, params *PostTasksParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDRequest generates requests for DeleteTasksID
func NewDeleteTasksIDRequest(server string, taskID string, params *DeleteTasksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRequest generates requests for GetTasksID
func NewGetTasksIDRequest(server string, taskID string, params *GetTasksIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchTasksIDRequest calls the generic PatchTasksID builder with application/json body
func NewPatchTasksIDRequest(server string, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchTasksIDRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPatchTasksIDRequestWithBody generates requests for PatchTasksID with any type of body
func NewPatchTasksIDRequestWithBody(server string, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetTasksIDLabelsRequest generates requests for GetTasksIDLabels
func NewGetTasksIDLabelsRequest(server string, taskID string, params *GetTasksIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDLabelsRequest calls the generic PostTasksIDLabels builder with application/json body
func NewPostTasksIDLabelsRequest(server string, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDLabelsRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDLabelsRequestWithBody generates requests for PostTasksIDLabels with any type of body
func NewPostTasksIDLabelsRequestWithBody(server string, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDLabelsIDRequest generates requests for DeleteTasksIDLabelsID
func NewDeleteTasksIDLabelsIDRequest(server string, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDLogsRequest generates requests for GetTasksIDLogs
func NewGetTasksIDLogsRequest(server string, taskID string, params *GetTasksIDLogsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/logs", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDMembersRequest generates requests for GetTasksIDMembers
func NewGetTasksIDMembersRequest(server string, taskID string, params *GetTasksIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDMembersRequest calls the generic PostTasksIDMembers builder with application/json body
func NewPostTasksIDMembersRequest(server string, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDMembersRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDMembersRequestWithBody generates requests for PostTasksIDMembers with any type of body
func NewPostTasksIDMembersRequestWithBody(server string, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDMembersIDRequest generates requests for DeleteTasksIDMembersID
func NewDeleteTasksIDMembersIDRequest(server string, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDOwnersRequest generates requests for GetTasksIDOwners
func NewGetTasksIDOwnersRequest(server string, taskID string, params *GetTasksIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDOwnersRequest calls the generic PostTasksIDOwners builder with application/json body
func NewPostTasksIDOwnersRequest(server string, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDOwnersRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDOwnersRequestWithBody generates requests for PostTasksIDOwners with any type of body
func NewPostTasksIDOwnersRequestWithBody(server string, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDOwnersIDRequest generates requests for DeleteTasksIDOwnersID
func NewDeleteTasksIDOwnersIDRequest(server string, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRunsRequest generates requests for GetTasksIDRuns
func NewGetTasksIDRunsRequest(server string, taskID string, params *GetTasksIDRunsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.After != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "after", *params.After); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.Limit != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "limit", *params.Limit); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.AfterTime != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "afterTime", *params.AfterTime); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.BeforeTime != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "beforeTime", *params.BeforeTime); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDRunsRequest calls the generic PostTasksIDRuns builder with application/json body
func NewPostTasksIDRunsRequest(server string, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTasksIDRunsRequestWithBody(server, taskID, params, "application/json", bodyReader)
}

// NewPostTasksIDRunsRequestWithBody generates requests for PostTasksIDRuns with any type of body
func NewPostTasksIDRunsRequestWithBody(server string, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTasksIDRunsIDRequest generates requests for DeleteTasksIDRunsID
func NewDeleteTasksIDRunsIDRequest(server string, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRunsIDRequest generates requests for GetTasksIDRunsID
func NewGetTasksIDRunsIDRequest(server string, taskID string, runID string, params *GetTasksIDRunsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTasksIDRunsIDLogsRequest generates requests for GetTasksIDRunsIDLogs
func NewGetTasksIDRunsIDLogsRequest(server string, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s/logs", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTasksIDRunsIDRetryRequest generates requests for PostTasksIDRunsIDRetry
func NewPostTasksIDRunsIDRetryRequest(server string, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "taskID", taskID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "runID", runID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/tasks/%s/runs/%s/retry", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafPluginsRequest generates requests for GetTelegrafPlugins
func NewGetTelegrafPluginsRequest(server string, params *GetTelegrafPluginsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegraf/plugins")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Type != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "type", *params.Type); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsRequest generates requests for GetTelegrafs
func NewGetTelegrafsRequest(server string, params *GetTelegrafsParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsRequest calls the generic PostTelegrafs builder with application/json body
func NewPostTelegrafsRequest(server string, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostTelegrafsRequestWithBody generates requests for PostTelegrafs with any type of body
func NewPostTelegrafsRequestWithBody(server string, params *PostTelegrafsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDRequest generates requests for DeleteTelegrafsID
func NewDeleteTelegrafsIDRequest(server string, telegrafID string, params *DeleteTelegrafsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsIDRequest generates requests for GetTelegrafsID
func NewGetTelegrafsIDRequest(server string, telegrafID string, params *GetTelegrafsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.Accept != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Accept", *params.Accept)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Accept", headerParam1)
	}

	return req, nil
}

// NewPutTelegrafsIDRequest calls the generic PutTelegrafsID builder with application/json body
func NewPutTelegrafsIDRequest(server string, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutTelegrafsIDRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPutTelegrafsIDRequestWithBody generates requests for PutTelegrafsID with any type of body
func NewPutTelegrafsIDRequestWithBody(server string, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetTelegrafsIDLabelsRequest generates requests for GetTelegrafsIDLabels
func NewGetTelegrafsIDLabelsRequest(server string, telegrafID string, params *GetTelegrafsIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsIDLabelsRequest calls the generic PostTelegrafsIDLabels builder with application/json body
func NewPostTelegrafsIDLabelsRequest(server string, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsIDLabelsRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPostTelegrafsIDLabelsRequestWithBody generates requests for PostTelegrafsIDLabels with any type of body
func NewPostTelegrafsIDLabelsRequestWithBody(server string, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDLabelsIDRequest generates requests for DeleteTelegrafsIDLabelsID
func NewDeleteTelegrafsIDLabelsIDRequest(server string, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsIDMembersRequest generates requests for GetTelegrafsIDMembers
func NewGetTelegrafsIDMembersRequest(server string, telegrafID string, params *GetTelegrafsIDMembersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsIDMembersRequest calls the generic PostTelegrafsIDMembers builder with application/json body
func NewPostTelegrafsIDMembersRequest(server string, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsIDMembersRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPostTelegrafsIDMembersRequestWithBody generates requests for PostTelegrafsIDMembers with any type of body
func NewPostTelegrafsIDMembersRequestWithBody(server string, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/members", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDMembersIDRequest generates requests for DeleteTelegrafsIDMembersID
func NewDeleteTelegrafsIDMembersIDRequest(server string, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/members/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetTelegrafsIDOwnersRequest generates requests for GetTelegrafsIDOwners
func NewGetTelegrafsIDOwnersRequest(server string, telegrafID string, params *GetTelegrafsIDOwnersParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostTelegrafsIDOwnersRequest calls the generic PostTelegrafsIDOwners builder with application/json body
func NewPostTelegrafsIDOwnersRequest(server string, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostTelegrafsIDOwnersRequestWithBody(server, telegrafID, params, "application/json", bodyReader)
}

// NewPostTelegrafsIDOwnersRequestWithBody generates requests for PostTelegrafsIDOwners with any type of body
func NewPostTelegrafsIDOwnersRequestWithBody(server string, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/owners", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteTelegrafsIDOwnersIDRequest generates requests for DeleteTelegrafsIDOwnersID
func NewDeleteTelegrafsIDOwnersIDRequest(server string, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "telegrafID", telegrafID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/telegrafs/%s/owners/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewApplyTemplateRequest calls the generic ApplyTemplate builder with application/json body
func NewApplyTemplateRequest(server string, body ApplyTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewApplyTemplateRequestWithBody(server, "application/json", bodyReader)
}

// NewApplyTemplateRequestWithBody generates requests for ApplyTemplate with any type of body
func NewApplyTemplateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/templates/apply")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewExportTemplateRequest calls the generic ExportTemplate builder with application/json body
func NewExportTemplateRequest(server string, body ExportTemplateJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewExportTemplateRequestWithBody(server, "application/json", bodyReader)
}

// NewExportTemplateRequestWithBody generates requests for ExportTemplate with any type of body
func NewExportTemplateRequestWithBody(server string, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/templates/export")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetUsersRequest generates requests for GetUsers
func NewGetUsersRequest(server string, params *GetUsersParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostUsersRequest calls the generic PostUsers builder with application/json body
func NewPostUsersRequest(server string, params *PostUsersParams, body PostUsersJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostUsersRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostUsersRequestWithBody generates requests for PostUsers with any type of body
func NewPostUsersRequestWithBody(server string, params *PostUsersParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteUsersIDRequest generates requests for DeleteUsersID
func NewDeleteUsersIDRequest(server string, userID string, params *DeleteUsersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetUsersIDRequest generates requests for GetUsersID
func NewGetUsersIDRequest(server string, userID string, params *GetUsersIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchUsersIDRequest calls the generic PatchUsersID builder with application/json body
func NewPatchUsersIDRequest(server string, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchUsersIDRequestWithBody(server, userID, params, "application/json", bodyReader)
}

// NewPatchUsersIDRequestWithBody generates requests for PatchUsersID with any type of body
func NewPatchUsersIDRequestWithBody(server string, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPostUsersIDPasswordRequest calls the generic PostUsersIDPassword builder with application/json body
func NewPostUsersIDPasswordRequest(server string, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostUsersIDPasswordRequestWithBody(server, userID, params, "application/json", bodyReader)
}

// NewPostUsersIDPasswordRequestWithBody generates requests for PostUsersIDPassword with any type of body
func NewPostUsersIDPasswordRequestWithBody(server string, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "userID", userID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/users/%s/password", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetVariablesRequest generates requests for GetVariables
func NewGetVariablesRequest(server string, params *GetVariablesParams) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if params.Org != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "org", *params.Org); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostVariablesRequest calls the generic PostVariables builder with application/json body
func NewPostVariablesRequest(server string, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostVariablesRequestWithBody(server, params, "application/json", bodyReader)
}

// NewPostVariablesRequestWithBody generates requests for PostVariables with any type of body
func NewPostVariablesRequestWithBody(server string, params *PostVariablesParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteVariablesIDRequest generates requests for DeleteVariablesID
func NewDeleteVariablesIDRequest(server string, variableID string, params *DeleteVariablesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewGetVariablesIDRequest generates requests for GetVariablesID
func NewGetVariablesIDRequest(server string, variableID string, params *GetVariablesIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPatchVariablesIDRequest calls the generic PatchVariablesID builder with application/json body
func NewPatchVariablesIDRequest(server string, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPatchVariablesIDRequestWithBody(server, variableID, params, "application/json", bodyReader)
}

// NewPatchVariablesIDRequestWithBody generates requests for PatchVariablesID with any type of body
func NewPatchVariablesIDRequestWithBody(server string, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PATCH", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewPutVariablesIDRequest calls the generic PutVariablesID builder with application/json body
func NewPutVariablesIDRequest(server string, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPutVariablesIDRequestWithBody(server, variableID, params, "application/json", bodyReader)
}

// NewPutVariablesIDRequestWithBody generates requests for PutVariablesID with any type of body
func NewPutVariablesIDRequestWithBody(server string, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("PUT", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewGetVariablesIDLabelsRequest generates requests for GetVariablesIDLabels
func NewGetVariablesIDLabelsRequest(server string, variableID string, params *GetVariablesIDLabelsParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("GET", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostVariablesIDLabelsRequest calls the generic PostVariablesIDLabels builder with application/json body
func NewPostVariablesIDLabelsRequest(server string, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*http.Request, error) {
	var bodyReader io.Reader
	buf, err := json.Marshal(body)
	if err != nil {
		return nil, err
	}
	bodyReader = bytes.NewReader(buf)
	return NewPostVariablesIDLabelsRequestWithBody(server, variableID, params, "application/json", bodyReader)
}

// NewPostVariablesIDLabelsRequestWithBody generates requests for PostVariablesIDLabels with any type of body
func NewPostVariablesIDLabelsRequestWithBody(server string, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s/labels", pathParam0)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// NewDeleteVariablesIDLabelsIDRequest generates requests for DeleteVariablesIDLabelsID
func NewDeleteVariablesIDLabelsIDRequest(server string, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*http.Request, error) {
	var err error

	var pathParam0 string

	pathParam0, err = runtime.StyleParam("simple", false, "variableID", variableID)
	if err != nil {
		return nil, err
	}

	var pathParam1 string

	pathParam1, err = runtime.StyleParam("simple", false, "labelID", labelID)
	if err != nil {
		return nil, err
	}

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/variables/%s/labels/%s", pathParam0, pathParam1)
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequest("DELETE", queryURL.String(), nil)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	return req, nil
}

// NewPostWriteRequestWithBody generates requests for PostWrite with any type of body
func NewPostWriteRequestWithBody(server string, params *PostWriteParams, contentType string, body io.Reader) (*http.Request, error) {
	var err error

	queryURL, err := url.Parse(server)
	if err != nil {
		return nil, err
	}

	basePath := fmt.Sprintf("/write")
	if basePath[0] == '/' {
		basePath = basePath[1:]
	}

	queryURL, err = queryURL.Parse(basePath)
	if err != nil {
		return nil, err
	}

	queryValues := queryURL.Query()

	if queryFrag, err := runtime.StyleParam("form", true, "org", params.Org); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.OrgID != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "orgID", *params.OrgID); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	if queryFrag, err := runtime.StyleParam("form", true, "bucket", params.Bucket); err != nil {
		return nil, err
	} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
		return nil, err
	} else {
		for k, v := range parsed {
			for _, v2 := range v {
				queryValues.Add(k, v2)
			}
		}
	}

	if params.Precision != nil {

		if queryFrag, err := runtime.StyleParam("form", true, "precision", *params.Precision); err != nil {
			return nil, err
		} else if parsed, err := url.ParseQuery(queryFrag); err != nil {
			return nil, err
		} else {
			for k, v := range parsed {
				for _, v2 := range v {
					queryValues.Add(k, v2)
				}
			}
		}

	}

	queryURL.RawQuery = queryValues.Encode()

	req, err := http.NewRequest("POST", queryURL.String(), body)
	if err != nil {
		return nil, err
	}

	if params.ZapTraceSpan != nil {
		var headerParam0 string

		headerParam0, err = runtime.StyleParam("simple", false, "Zap-Trace-Span", *params.ZapTraceSpan)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Zap-Trace-Span", headerParam0)
	}

	if params.ContentEncoding != nil {
		var headerParam1 string

		headerParam1, err = runtime.StyleParam("simple", false, "Content-Encoding", *params.ContentEncoding)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Encoding", headerParam1)
	}

	if params.ContentType != nil {
		var headerParam2 string

		headerParam2, err = runtime.StyleParam("simple", false, "Content-Type", *params.ContentType)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Type", headerParam2)
	}

	if params.ContentLength != nil {
		var headerParam3 string

		headerParam3, err = runtime.StyleParam("simple", false, "Content-Length", *params.ContentLength)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Content-Length", headerParam3)
	}

	if params.Accept != nil {
		var headerParam4 string

		headerParam4, err = runtime.StyleParam("simple", false, "Accept", *params.Accept)
		if err != nil {
			return nil, err
		}

		req.Header.Add("Accept", headerParam4)
	}

	req.Header.Add("Content-Type", contentType)
	return req, nil
}

// ClientWithResponses builds on ClientInterface to offer response payloads
type ClientWithResponses struct {
	ClientInterface
}

// NewClientWithResponses creates a new ClientWithResponses, which wraps
// Client with return type handling
func NewClientWithResponses(service ihttp.Service) *ClientWithResponses {
	client := NewClient(service)
	return &ClientWithResponses{client}
}

// ClientWithResponsesInterface is the interface specification for the client with responses above.
type ClientWithResponsesInterface interface {
	// GetRoutes request
	GetRoutesWithResponse(ctx context.Context, params *GetRoutesParams) (*GetRoutesResponse, error)

	// GetAuthorizations request
	GetAuthorizationsWithResponse(ctx context.Context, params *GetAuthorizationsParams) (*GetAuthorizationsResponse, error)

	// PostAuthorizations request  with any body
	PostAuthorizationsWithBodyWithResponse(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*PostAuthorizationsResponse, error)

	PostAuthorizationsWithResponse(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*PostAuthorizationsResponse, error)

	// DeleteAuthorizationsID request
	DeleteAuthorizationsIDWithResponse(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*DeleteAuthorizationsIDResponse, error)

	// GetAuthorizationsID request
	GetAuthorizationsIDWithResponse(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*GetAuthorizationsIDResponse, error)

	// PatchAuthorizationsID request  with any body
	PatchAuthorizationsIDWithBodyWithResponse(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*PatchAuthorizationsIDResponse, error)

	PatchAuthorizationsIDWithResponse(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*PatchAuthorizationsIDResponse, error)

	// GetBuckets request
	GetBucketsWithResponse(ctx context.Context, params *GetBucketsParams) (*GetBucketsResponse, error)

	// PostBuckets request  with any body
	PostBucketsWithBodyWithResponse(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*PostBucketsResponse, error)

	PostBucketsWithResponse(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*PostBucketsResponse, error)

	// DeleteBucketsID request
	DeleteBucketsIDWithResponse(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*DeleteBucketsIDResponse, error)

	// GetBucketsID request
	GetBucketsIDWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*GetBucketsIDResponse, error)

	// PatchBucketsID request  with any body
	PatchBucketsIDWithBodyWithResponse(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*PatchBucketsIDResponse, error)

	PatchBucketsIDWithResponse(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*PatchBucketsIDResponse, error)

	// GetBucketsIDLabels request
	GetBucketsIDLabelsWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*GetBucketsIDLabelsResponse, error)

	// PostBucketsIDLabels request  with any body
	PostBucketsIDLabelsWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*PostBucketsIDLabelsResponse, error)

	PostBucketsIDLabelsWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*PostBucketsIDLabelsResponse, error)

	// DeleteBucketsIDLabelsID request
	DeleteBucketsIDLabelsIDWithResponse(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*DeleteBucketsIDLabelsIDResponse, error)

	// GetBucketsIDMembers request
	GetBucketsIDMembersWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*GetBucketsIDMembersResponse, error)

	// PostBucketsIDMembers request  with any body
	PostBucketsIDMembersWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*PostBucketsIDMembersResponse, error)

	PostBucketsIDMembersWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*PostBucketsIDMembersResponse, error)

	// DeleteBucketsIDMembersID request
	DeleteBucketsIDMembersIDWithResponse(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*DeleteBucketsIDMembersIDResponse, error)

	// GetBucketsIDOwners request
	GetBucketsIDOwnersWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*GetBucketsIDOwnersResponse, error)

	// PostBucketsIDOwners request  with any body
	PostBucketsIDOwnersWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*PostBucketsIDOwnersResponse, error)

	PostBucketsIDOwnersWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*PostBucketsIDOwnersResponse, error)

	// DeleteBucketsIDOwnersID request
	DeleteBucketsIDOwnersIDWithResponse(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*DeleteBucketsIDOwnersIDResponse, error)

	// GetChecks request
	GetChecksWithResponse(ctx context.Context, params *GetChecksParams) (*GetChecksResponse, error)

	// CreateCheck request  with any body
	CreateCheckWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateCheckResponse, error)

	CreateCheckWithResponse(ctx context.Context, body CreateCheckJSONRequestBody) (*CreateCheckResponse, error)

	// DeleteChecksID request
	DeleteChecksIDWithResponse(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*DeleteChecksIDResponse, error)

	// GetChecksID request
	GetChecksIDWithResponse(ctx context.Context, checkID string, params *GetChecksIDParams) (*GetChecksIDResponse, error)

	// PatchChecksID request  with any body
	PatchChecksIDWithBodyWithResponse(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*PatchChecksIDResponse, error)

	PatchChecksIDWithResponse(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*PatchChecksIDResponse, error)

	// PutChecksID request  with any body
	PutChecksIDWithBodyWithResponse(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*PutChecksIDResponse, error)

	PutChecksIDWithResponse(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*PutChecksIDResponse, error)

	// GetChecksIDLabels request
	GetChecksIDLabelsWithResponse(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*GetChecksIDLabelsResponse, error)

	// PostChecksIDLabels request  with any body
	PostChecksIDLabelsWithBodyWithResponse(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*PostChecksIDLabelsResponse, error)

	PostChecksIDLabelsWithResponse(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*PostChecksIDLabelsResponse, error)

	// DeleteChecksIDLabelsID request
	DeleteChecksIDLabelsIDWithResponse(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*DeleteChecksIDLabelsIDResponse, error)

	// GetChecksIDQuery request
	GetChecksIDQueryWithResponse(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*GetChecksIDQueryResponse, error)

	// GetDashboards request
	GetDashboardsWithResponse(ctx context.Context, params *GetDashboardsParams) (*GetDashboardsResponse, error)

	// PostDashboards request  with any body
	PostDashboardsWithBodyWithResponse(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*PostDashboardsResponse, error)

	PostDashboardsWithResponse(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*PostDashboardsResponse, error)

	// DeleteDashboardsID request
	DeleteDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*DeleteDashboardsIDResponse, error)

	// GetDashboardsID request
	GetDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*GetDashboardsIDResponse, error)

	// PatchDashboardsID request  with any body
	PatchDashboardsIDWithBodyWithResponse(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*PatchDashboardsIDResponse, error)

	PatchDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*PatchDashboardsIDResponse, error)

	// PostDashboardsIDCells request  with any body
	PostDashboardsIDCellsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*PostDashboardsIDCellsResponse, error)

	PostDashboardsIDCellsWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*PostDashboardsIDCellsResponse, error)

	// PutDashboardsIDCells request  with any body
	PutDashboardsIDCellsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*PutDashboardsIDCellsResponse, error)

	PutDashboardsIDCellsWithResponse(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*PutDashboardsIDCellsResponse, error)

	// DeleteDashboardsIDCellsID request
	DeleteDashboardsIDCellsIDWithResponse(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*DeleteDashboardsIDCellsIDResponse, error)

	// PatchDashboardsIDCellsID request  with any body
	PatchDashboardsIDCellsIDWithBodyWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*PatchDashboardsIDCellsIDResponse, error)

	PatchDashboardsIDCellsIDWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*PatchDashboardsIDCellsIDResponse, error)

	// GetDashboardsIDCellsIDView request
	GetDashboardsIDCellsIDViewWithResponse(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*GetDashboardsIDCellsIDViewResponse, error)

	// PatchDashboardsIDCellsIDView request  with any body
	PatchDashboardsIDCellsIDViewWithBodyWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*PatchDashboardsIDCellsIDViewResponse, error)

	PatchDashboardsIDCellsIDViewWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*PatchDashboardsIDCellsIDViewResponse, error)

	// GetDashboardsIDLabels request
	GetDashboardsIDLabelsWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*GetDashboardsIDLabelsResponse, error)

	// PostDashboardsIDLabels request  with any body
	PostDashboardsIDLabelsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*PostDashboardsIDLabelsResponse, error)

	PostDashboardsIDLabelsWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*PostDashboardsIDLabelsResponse, error)

	// DeleteDashboardsIDLabelsID request
	DeleteDashboardsIDLabelsIDWithResponse(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*DeleteDashboardsIDLabelsIDResponse, error)

	// GetDashboardsIDMembers request
	GetDashboardsIDMembersWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*GetDashboardsIDMembersResponse, error)

	// PostDashboardsIDMembers request  with any body
	PostDashboardsIDMembersWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*PostDashboardsIDMembersResponse, error)

	PostDashboardsIDMembersWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*PostDashboardsIDMembersResponse, error)

	// DeleteDashboardsIDMembersID request
	DeleteDashboardsIDMembersIDWithResponse(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*DeleteDashboardsIDMembersIDResponse, error)

	// GetDashboardsIDOwners request
	GetDashboardsIDOwnersWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*GetDashboardsIDOwnersResponse, error)

	// PostDashboardsIDOwners request  with any body
	PostDashboardsIDOwnersWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*PostDashboardsIDOwnersResponse, error)

	PostDashboardsIDOwnersWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*PostDashboardsIDOwnersResponse, error)

	// DeleteDashboardsIDOwnersID request
	DeleteDashboardsIDOwnersIDWithResponse(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*DeleteDashboardsIDOwnersIDResponse, error)

	// GetDBRPs request
	GetDBRPsWithResponse(ctx context.Context, params *GetDBRPsParams) (*GetDBRPsResponse, error)

	// PostDBRP request  with any body
	PostDBRPWithBodyWithResponse(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*PostDBRPResponse, error)

	PostDBRPWithResponse(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*PostDBRPResponse, error)

	// DeleteDBRPID request
	DeleteDBRPIDWithResponse(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*DeleteDBRPIDResponse, error)

	// GetDBRPsID request
	GetDBRPsIDWithResponse(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*GetDBRPsIDResponse, error)

	// PatchDBRPID request  with any body
	PatchDBRPIDWithBodyWithResponse(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*PatchDBRPIDResponse, error)

	PatchDBRPIDWithResponse(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*PatchDBRPIDResponse, error)

	// PostDelete request  with any body
	PostDeleteWithBodyWithResponse(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*PostDeleteResponse, error)

	PostDeleteWithResponse(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*PostDeleteResponse, error)

	// GetDocumentsTemplates request
	GetDocumentsTemplatesWithResponse(ctx context.Context, params *GetDocumentsTemplatesParams) (*GetDocumentsTemplatesResponse, error)

	// PostDocumentsTemplates request  with any body
	PostDocumentsTemplatesWithBodyWithResponse(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*PostDocumentsTemplatesResponse, error)

	PostDocumentsTemplatesWithResponse(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*PostDocumentsTemplatesResponse, error)

	// DeleteDocumentsTemplatesID request
	DeleteDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*DeleteDocumentsTemplatesIDResponse, error)

	// GetDocumentsTemplatesID request
	GetDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*GetDocumentsTemplatesIDResponse, error)

	// PutDocumentsTemplatesID request  with any body
	PutDocumentsTemplatesIDWithBodyWithResponse(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*PutDocumentsTemplatesIDResponse, error)

	PutDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*PutDocumentsTemplatesIDResponse, error)

	// GetDocumentsTemplatesIDLabels request
	GetDocumentsTemplatesIDLabelsWithResponse(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*GetDocumentsTemplatesIDLabelsResponse, error)

	// PostDocumentsTemplatesIDLabels request  with any body
	PostDocumentsTemplatesIDLabelsWithBodyWithResponse(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*PostDocumentsTemplatesIDLabelsResponse, error)

	PostDocumentsTemplatesIDLabelsWithResponse(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*PostDocumentsTemplatesIDLabelsResponse, error)

	// DeleteDocumentsTemplatesIDLabelsID request
	DeleteDocumentsTemplatesIDLabelsIDWithResponse(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*DeleteDocumentsTemplatesIDLabelsIDResponse, error)

	// GetFlags request
	GetFlagsWithResponse(ctx context.Context, params *GetFlagsParams) (*GetFlagsResponse, error)

	// GetHealth request
	GetHealthWithResponse(ctx context.Context, params *GetHealthParams) (*GetHealthResponse, error)

	// GetLabels request
	GetLabelsWithResponse(ctx context.Context, params *GetLabelsParams) (*GetLabelsResponse, error)

	// PostLabels request  with any body
	PostLabelsWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*PostLabelsResponse, error)

	PostLabelsWithResponse(ctx context.Context, body PostLabelsJSONRequestBody) (*PostLabelsResponse, error)

	// DeleteLabelsID request
	DeleteLabelsIDWithResponse(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*DeleteLabelsIDResponse, error)

	// GetLabelsID request
	GetLabelsIDWithResponse(ctx context.Context, labelID string, params *GetLabelsIDParams) (*GetLabelsIDResponse, error)

	// PatchLabelsID request  with any body
	PatchLabelsIDWithBodyWithResponse(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*PatchLabelsIDResponse, error)

	PatchLabelsIDWithResponse(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*PatchLabelsIDResponse, error)

	// GetMe request
	GetMeWithResponse(ctx context.Context, params *GetMeParams) (*GetMeResponse, error)

	// PutMePassword request  with any body
	PutMePasswordWithBodyWithResponse(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*PutMePasswordResponse, error)

	PutMePasswordWithResponse(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*PutMePasswordResponse, error)

	// GetNotificationEndpoints request
	GetNotificationEndpointsWithResponse(ctx context.Context, params *GetNotificationEndpointsParams) (*GetNotificationEndpointsResponse, error)

	// CreateNotificationEndpoint request  with any body
	CreateNotificationEndpointWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateNotificationEndpointResponse, error)

	CreateNotificationEndpointWithResponse(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*CreateNotificationEndpointResponse, error)

	// DeleteNotificationEndpointsID request
	DeleteNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*DeleteNotificationEndpointsIDResponse, error)

	// GetNotificationEndpointsID request
	GetNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*GetNotificationEndpointsIDResponse, error)

	// PatchNotificationEndpointsID request  with any body
	PatchNotificationEndpointsIDWithBodyWithResponse(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*PatchNotificationEndpointsIDResponse, error)

	PatchNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*PatchNotificationEndpointsIDResponse, error)

	// PutNotificationEndpointsID request  with any body
	PutNotificationEndpointsIDWithBodyWithResponse(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*PutNotificationEndpointsIDResponse, error)

	PutNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*PutNotificationEndpointsIDResponse, error)

	// GetNotificationEndpointsIDLabels request
	GetNotificationEndpointsIDLabelsWithResponse(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*GetNotificationEndpointsIDLabelsResponse, error)

	// PostNotificationEndpointIDLabels request  with any body
	PostNotificationEndpointIDLabelsWithBodyWithResponse(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*PostNotificationEndpointIDLabelsResponse, error)

	PostNotificationEndpointIDLabelsWithResponse(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*PostNotificationEndpointIDLabelsResponse, error)

	// DeleteNotificationEndpointsIDLabelsID request
	DeleteNotificationEndpointsIDLabelsIDWithResponse(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*DeleteNotificationEndpointsIDLabelsIDResponse, error)

	// GetNotificationRules request
	GetNotificationRulesWithResponse(ctx context.Context, params *GetNotificationRulesParams) (*GetNotificationRulesResponse, error)

	// CreateNotificationRule request  with any body
	CreateNotificationRuleWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateNotificationRuleResponse, error)

	CreateNotificationRuleWithResponse(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*CreateNotificationRuleResponse, error)

	// DeleteNotificationRulesID request
	DeleteNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*DeleteNotificationRulesIDResponse, error)

	// GetNotificationRulesID request
	GetNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*GetNotificationRulesIDResponse, error)

	// PatchNotificationRulesID request  with any body
	PatchNotificationRulesIDWithBodyWithResponse(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*PatchNotificationRulesIDResponse, error)

	PatchNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*PatchNotificationRulesIDResponse, error)

	// PutNotificationRulesID request  with any body
	PutNotificationRulesIDWithBodyWithResponse(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*PutNotificationRulesIDResponse, error)

	PutNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*PutNotificationRulesIDResponse, error)

	// GetNotificationRulesIDLabels request
	GetNotificationRulesIDLabelsWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*GetNotificationRulesIDLabelsResponse, error)

	// PostNotificationRuleIDLabels request  with any body
	PostNotificationRuleIDLabelsWithBodyWithResponse(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*PostNotificationRuleIDLabelsResponse, error)

	PostNotificationRuleIDLabelsWithResponse(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*PostNotificationRuleIDLabelsResponse, error)

	// DeleteNotificationRulesIDLabelsID request
	DeleteNotificationRulesIDLabelsIDWithResponse(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*DeleteNotificationRulesIDLabelsIDResponse, error)

	// GetNotificationRulesIDQuery request
	GetNotificationRulesIDQueryWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*GetNotificationRulesIDQueryResponse, error)

	// GetOrgs request
	GetOrgsWithResponse(ctx context.Context, params *GetOrgsParams) (*GetOrgsResponse, error)

	// PostOrgs request  with any body
	PostOrgsWithBodyWithResponse(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*PostOrgsResponse, error)

	PostOrgsWithResponse(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*PostOrgsResponse, error)

	// DeleteOrgsID request
	DeleteOrgsIDWithResponse(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*DeleteOrgsIDResponse, error)

	// GetOrgsID request
	GetOrgsIDWithResponse(ctx context.Context, orgID string, params *GetOrgsIDParams) (*GetOrgsIDResponse, error)

	// PatchOrgsID request  with any body
	PatchOrgsIDWithBodyWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*PatchOrgsIDResponse, error)

	PatchOrgsIDWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*PatchOrgsIDResponse, error)

	// GetOrgsIDMembers request
	GetOrgsIDMembersWithResponse(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*GetOrgsIDMembersResponse, error)

	// PostOrgsIDMembers request  with any body
	PostOrgsIDMembersWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*PostOrgsIDMembersResponse, error)

	PostOrgsIDMembersWithResponse(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*PostOrgsIDMembersResponse, error)

	// DeleteOrgsIDMembersID request
	DeleteOrgsIDMembersIDWithResponse(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*DeleteOrgsIDMembersIDResponse, error)

	// GetOrgsIDOwners request
	GetOrgsIDOwnersWithResponse(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*GetOrgsIDOwnersResponse, error)

	// PostOrgsIDOwners request  with any body
	PostOrgsIDOwnersWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*PostOrgsIDOwnersResponse, error)

	PostOrgsIDOwnersWithResponse(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*PostOrgsIDOwnersResponse, error)

	// DeleteOrgsIDOwnersID request
	DeleteOrgsIDOwnersIDWithResponse(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*DeleteOrgsIDOwnersIDResponse, error)

	// GetOrgsIDSecrets request
	GetOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*GetOrgsIDSecretsResponse, error)

	// PatchOrgsIDSecrets request  with any body
	PatchOrgsIDSecretsWithBodyWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*PatchOrgsIDSecretsResponse, error)

	PatchOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*PatchOrgsIDSecretsResponse, error)

	// PostOrgsIDSecrets request  with any body
	PostOrgsIDSecretsWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*PostOrgsIDSecretsResponse, error)

	PostOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*PostOrgsIDSecretsResponse, error)

	// PostQuery request  with any body
	PostQueryWithBodyWithResponse(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*PostQueryResponse, error)

	PostQueryWithResponse(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*PostQueryResponse, error)

	// PostQueryAnalyze request  with any body
	PostQueryAnalyzeWithBodyWithResponse(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*PostQueryAnalyzeResponse, error)

	PostQueryAnalyzeWithResponse(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*PostQueryAnalyzeResponse, error)

	// PostQueryAst request  with any body
	PostQueryAstWithBodyWithResponse(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*PostQueryAstResponse, error)

	PostQueryAstWithResponse(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*PostQueryAstResponse, error)

	// GetQuerySuggestions request
	GetQuerySuggestionsWithResponse(ctx context.Context, params *GetQuerySuggestionsParams) (*GetQuerySuggestionsResponse, error)

	// GetQuerySuggestionsName request
	GetQuerySuggestionsNameWithResponse(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*GetQuerySuggestionsNameResponse, error)

	// GetReady request
	GetReadyWithResponse(ctx context.Context, params *GetReadyParams) (*GetReadyResponse, error)

	// GetScrapers request
	GetScrapersWithResponse(ctx context.Context, params *GetScrapersParams) (*GetScrapersResponse, error)

	// PostScrapers request  with any body
	PostScrapersWithBodyWithResponse(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*PostScrapersResponse, error)

	PostScrapersWithResponse(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*PostScrapersResponse, error)

	// DeleteScrapersID request
	DeleteScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*DeleteScrapersIDResponse, error)

	// GetScrapersID request
	GetScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*GetScrapersIDResponse, error)

	// PatchScrapersID request  with any body
	PatchScrapersIDWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*PatchScrapersIDResponse, error)

	PatchScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*PatchScrapersIDResponse, error)

	// GetScrapersIDLabels request
	GetScrapersIDLabelsWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*GetScrapersIDLabelsResponse, error)

	// PostScrapersIDLabels request  with any body
	PostScrapersIDLabelsWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*PostScrapersIDLabelsResponse, error)

	PostScrapersIDLabelsWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*PostScrapersIDLabelsResponse, error)

	// DeleteScrapersIDLabelsID request
	DeleteScrapersIDLabelsIDWithResponse(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*DeleteScrapersIDLabelsIDResponse, error)

	// GetScrapersIDMembers request
	GetScrapersIDMembersWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*GetScrapersIDMembersResponse, error)

	// PostScrapersIDMembers request  with any body
	PostScrapersIDMembersWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*PostScrapersIDMembersResponse, error)

	PostScrapersIDMembersWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*PostScrapersIDMembersResponse, error)

	// DeleteScrapersIDMembersID request
	DeleteScrapersIDMembersIDWithResponse(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*DeleteScrapersIDMembersIDResponse, error)

	// GetScrapersIDOwners request
	GetScrapersIDOwnersWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*GetScrapersIDOwnersResponse, error)

	// PostScrapersIDOwners request  with any body
	PostScrapersIDOwnersWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*PostScrapersIDOwnersResponse, error)

	PostScrapersIDOwnersWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*PostScrapersIDOwnersResponse, error)

	// DeleteScrapersIDOwnersID request
	DeleteScrapersIDOwnersIDWithResponse(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*DeleteScrapersIDOwnersIDResponse, error)

	// GetSetup request
	GetSetupWithResponse(ctx context.Context, params *GetSetupParams) (*GetSetupResponse, error)

	// PostSetup request  with any body
	PostSetupWithBodyWithResponse(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*PostSetupResponse, error)

	PostSetupWithResponse(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*PostSetupResponse, error)

	// PostSetupUser request  with any body
	PostSetupUserWithBodyWithResponse(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*PostSetupUserResponse, error)

	PostSetupUserWithResponse(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*PostSetupUserResponse, error)

	// PostSignin request
	PostSigninWithResponse(ctx context.Context, params *PostSigninParams) (*PostSigninResponse, error)

	// PostSignout request
	PostSignoutWithResponse(ctx context.Context, params *PostSignoutParams) (*PostSignoutResponse, error)

	// GetSources request
	GetSourcesWithResponse(ctx context.Context, params *GetSourcesParams) (*GetSourcesResponse, error)

	// PostSources request  with any body
	PostSourcesWithBodyWithResponse(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*PostSourcesResponse, error)

	PostSourcesWithResponse(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*PostSourcesResponse, error)

	// DeleteSourcesID request
	DeleteSourcesIDWithResponse(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*DeleteSourcesIDResponse, error)

	// GetSourcesID request
	GetSourcesIDWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*GetSourcesIDResponse, error)

	// PatchSourcesID request  with any body
	PatchSourcesIDWithBodyWithResponse(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*PatchSourcesIDResponse, error)

	PatchSourcesIDWithResponse(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*PatchSourcesIDResponse, error)

	// GetSourcesIDBuckets request
	GetSourcesIDBucketsWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*GetSourcesIDBucketsResponse, error)

	// GetSourcesIDHealth request
	GetSourcesIDHealthWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*GetSourcesIDHealthResponse, error)

	// ListStacks request
	ListStacksWithResponse(ctx context.Context, params *ListStacksParams) (*ListStacksResponse, error)

	// CreateStack request  with any body
	CreateStackWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateStackResponse, error)

	CreateStackWithResponse(ctx context.Context, body CreateStackJSONRequestBody) (*CreateStackResponse, error)

	// DeleteStack request
	DeleteStackWithResponse(ctx context.Context, stackId string, params *DeleteStackParams) (*DeleteStackResponse, error)

	// ReadStack request
	ReadStackWithResponse(ctx context.Context, stackId string) (*ReadStackResponse, error)

	// UpdateStack request  with any body
	UpdateStackWithBodyWithResponse(ctx context.Context, stackId string, contentType string, body io.Reader) (*UpdateStackResponse, error)

	UpdateStackWithResponse(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*UpdateStackResponse, error)

	// UninstallStack request
	UninstallStackWithResponse(ctx context.Context, stackId string) (*UninstallStackResponse, error)

	// GetTasks request
	GetTasksWithResponse(ctx context.Context, params *GetTasksParams) (*GetTasksResponse, error)

	// PostTasks request  with any body
	PostTasksWithBodyWithResponse(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*PostTasksResponse, error)

	PostTasksWithResponse(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*PostTasksResponse, error)

	// DeleteTasksID request
	DeleteTasksIDWithResponse(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*DeleteTasksIDResponse, error)

	// GetTasksID request
	GetTasksIDWithResponse(ctx context.Context, taskID string, params *GetTasksIDParams) (*GetTasksIDResponse, error)

	// PatchTasksID request  with any body
	PatchTasksIDWithBodyWithResponse(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*PatchTasksIDResponse, error)

	PatchTasksIDWithResponse(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*PatchTasksIDResponse, error)

	// GetTasksIDLabels request
	GetTasksIDLabelsWithResponse(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*GetTasksIDLabelsResponse, error)

	// PostTasksIDLabels request  with any body
	PostTasksIDLabelsWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*PostTasksIDLabelsResponse, error)

	PostTasksIDLabelsWithResponse(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*PostTasksIDLabelsResponse, error)

	// DeleteTasksIDLabelsID request
	DeleteTasksIDLabelsIDWithResponse(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*DeleteTasksIDLabelsIDResponse, error)

	// GetTasksIDLogs request
	GetTasksIDLogsWithResponse(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*GetTasksIDLogsResponse, error)

	// GetTasksIDMembers request
	GetTasksIDMembersWithResponse(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*GetTasksIDMembersResponse, error)

	// PostTasksIDMembers request  with any body
	PostTasksIDMembersWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*PostTasksIDMembersResponse, error)

	PostTasksIDMembersWithResponse(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*PostTasksIDMembersResponse, error)

	// DeleteTasksIDMembersID request
	DeleteTasksIDMembersIDWithResponse(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*DeleteTasksIDMembersIDResponse, error)

	// GetTasksIDOwners request
	GetTasksIDOwnersWithResponse(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*GetTasksIDOwnersResponse, error)

	// PostTasksIDOwners request  with any body
	PostTasksIDOwnersWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*PostTasksIDOwnersResponse, error)

	PostTasksIDOwnersWithResponse(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*PostTasksIDOwnersResponse, error)

	// DeleteTasksIDOwnersID request
	DeleteTasksIDOwnersIDWithResponse(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*DeleteTasksIDOwnersIDResponse, error)

	// GetTasksIDRuns request
	GetTasksIDRunsWithResponse(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*GetTasksIDRunsResponse, error)

	// PostTasksIDRuns request  with any body
	PostTasksIDRunsWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*PostTasksIDRunsResponse, error)

	PostTasksIDRunsWithResponse(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*PostTasksIDRunsResponse, error)

	// DeleteTasksIDRunsID request
	DeleteTasksIDRunsIDWithResponse(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*DeleteTasksIDRunsIDResponse, error)

	// GetTasksIDRunsID request
	GetTasksIDRunsIDWithResponse(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*GetTasksIDRunsIDResponse, error)

	// GetTasksIDRunsIDLogs request
	GetTasksIDRunsIDLogsWithResponse(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*GetTasksIDRunsIDLogsResponse, error)

	// PostTasksIDRunsIDRetry request
	PostTasksIDRunsIDRetryWithResponse(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*PostTasksIDRunsIDRetryResponse, error)

	// GetTelegrafPlugins request
	GetTelegrafPluginsWithResponse(ctx context.Context, params *GetTelegrafPluginsParams) (*GetTelegrafPluginsResponse, error)

	// GetTelegrafs request
	GetTelegrafsWithResponse(ctx context.Context, params *GetTelegrafsParams) (*GetTelegrafsResponse, error)

	// PostTelegrafs request  with any body
	PostTelegrafsWithBodyWithResponse(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*PostTelegrafsResponse, error)

	PostTelegrafsWithResponse(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*PostTelegrafsResponse, error)

	// DeleteTelegrafsID request
	DeleteTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*DeleteTelegrafsIDResponse, error)

	// GetTelegrafsID request
	GetTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*GetTelegrafsIDResponse, error)

	// PutTelegrafsID request  with any body
	PutTelegrafsIDWithBodyWithResponse(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*PutTelegrafsIDResponse, error)

	PutTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*PutTelegrafsIDResponse, error)

	// GetTelegrafsIDLabels request
	GetTelegrafsIDLabelsWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*GetTelegrafsIDLabelsResponse, error)

	// PostTelegrafsIDLabels request  with any body
	PostTelegrafsIDLabelsWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*PostTelegrafsIDLabelsResponse, error)

	PostTelegrafsIDLabelsWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*PostTelegrafsIDLabelsResponse, error)

	// DeleteTelegrafsIDLabelsID request
	DeleteTelegrafsIDLabelsIDWithResponse(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*DeleteTelegrafsIDLabelsIDResponse, error)

	// GetTelegrafsIDMembers request
	GetTelegrafsIDMembersWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*GetTelegrafsIDMembersResponse, error)

	// PostTelegrafsIDMembers request  with any body
	PostTelegrafsIDMembersWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*PostTelegrafsIDMembersResponse, error)

	PostTelegrafsIDMembersWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*PostTelegrafsIDMembersResponse, error)

	// DeleteTelegrafsIDMembersID request
	DeleteTelegrafsIDMembersIDWithResponse(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*DeleteTelegrafsIDMembersIDResponse, error)

	// GetTelegrafsIDOwners request
	GetTelegrafsIDOwnersWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*GetTelegrafsIDOwnersResponse, error)

	// PostTelegrafsIDOwners request  with any body
	PostTelegrafsIDOwnersWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*PostTelegrafsIDOwnersResponse, error)

	PostTelegrafsIDOwnersWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*PostTelegrafsIDOwnersResponse, error)

	// DeleteTelegrafsIDOwnersID request
	DeleteTelegrafsIDOwnersIDWithResponse(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*DeleteTelegrafsIDOwnersIDResponse, error)

	// ApplyTemplate request  with any body
	ApplyTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*ApplyTemplateResponse, error)

	ApplyTemplateWithResponse(ctx context.Context, body ApplyTemplateJSONRequestBody) (*ApplyTemplateResponse, error)

	// ExportTemplate request  with any body
	ExportTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*ExportTemplateResponse, error)

	ExportTemplateWithResponse(ctx context.Context, body ExportTemplateJSONRequestBody) (*ExportTemplateResponse, error)

	// GetUsers request
	GetUsersWithResponse(ctx context.Context, params *GetUsersParams) (*GetUsersResponse, error)

	// PostUsers request  with any body
	PostUsersWithBodyWithResponse(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*PostUsersResponse, error)

	PostUsersWithResponse(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*PostUsersResponse, error)

	// DeleteUsersID request
	DeleteUsersIDWithResponse(ctx context.Context, userID string, params *DeleteUsersIDParams) (*DeleteUsersIDResponse, error)

	// GetUsersID request
	GetUsersIDWithResponse(ctx context.Context, userID string, params *GetUsersIDParams) (*GetUsersIDResponse, error)

	// PatchUsersID request  with any body
	PatchUsersIDWithBodyWithResponse(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*PatchUsersIDResponse, error)

	PatchUsersIDWithResponse(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*PatchUsersIDResponse, error)

	// PostUsersIDPassword request  with any body
	PostUsersIDPasswordWithBodyWithResponse(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*PostUsersIDPasswordResponse, error)

	PostUsersIDPasswordWithResponse(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*PostUsersIDPasswordResponse, error)

	// GetVariables request
	GetVariablesWithResponse(ctx context.Context, params *GetVariablesParams) (*GetVariablesResponse, error)

	// PostVariables request  with any body
	PostVariablesWithBodyWithResponse(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*PostVariablesResponse, error)

	PostVariablesWithResponse(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*PostVariablesResponse, error)

	// DeleteVariablesID request
	DeleteVariablesIDWithResponse(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*DeleteVariablesIDResponse, error)

	// GetVariablesID request
	GetVariablesIDWithResponse(ctx context.Context, variableID string, params *GetVariablesIDParams) (*GetVariablesIDResponse, error)

	// PatchVariablesID request  with any body
	PatchVariablesIDWithBodyWithResponse(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*PatchVariablesIDResponse, error)

	PatchVariablesIDWithResponse(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*PatchVariablesIDResponse, error)

	// PutVariablesID request  with any body
	PutVariablesIDWithBodyWithResponse(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*PutVariablesIDResponse, error)

	PutVariablesIDWithResponse(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*PutVariablesIDResponse, error)

	// GetVariablesIDLabels request
	GetVariablesIDLabelsWithResponse(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*GetVariablesIDLabelsResponse, error)

	// PostVariablesIDLabels request  with any body
	PostVariablesIDLabelsWithBodyWithResponse(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*PostVariablesIDLabelsResponse, error)

	PostVariablesIDLabelsWithResponse(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*PostVariablesIDLabelsResponse, error)

	// DeleteVariablesIDLabelsID request
	DeleteVariablesIDLabelsIDWithResponse(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*DeleteVariablesIDLabelsIDResponse, error)

	// PostWrite request  with any body
	PostWriteWithBodyWithResponse(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*PostWriteResponse, error)
}

type GetRoutesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Routes
}

// Status returns HTTPResponse.Status
func (r GetRoutesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetRoutesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetAuthorizationsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Authorizations
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetAuthorizationsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetAuthorizationsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostAuthorizationsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Authorization
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostAuthorizationsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostAuthorizationsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteAuthorizationsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteAuthorizationsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteAuthorizationsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetAuthorizationsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Authorization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetAuthorizationsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetAuthorizationsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchAuthorizationsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Authorization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchAuthorizationsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchAuthorizationsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBucketsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Buckets
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetBucketsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBucketsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostBucketsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Bucket
	JSON422      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostBucketsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostBucketsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteBucketsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteBucketsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteBucketsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBucketsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Bucket
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetBucketsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBucketsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchBucketsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Bucket
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchBucketsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchBucketsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBucketsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetBucketsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBucketsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostBucketsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostBucketsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostBucketsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteBucketsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteBucketsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteBucketsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBucketsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetBucketsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBucketsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostBucketsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostBucketsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostBucketsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteBucketsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteBucketsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteBucketsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetBucketsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetBucketsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetBucketsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostBucketsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostBucketsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostBucketsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteBucketsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteBucketsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteBucketsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetChecksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Checks
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetChecksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetChecksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateCheckResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Check
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r CreateCheckResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateCheckResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Check
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Check
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutChecksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Check
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutChecksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutChecksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetChecksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetChecksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetChecksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostChecksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostChecksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostChecksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteChecksIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteChecksIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteChecksIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetChecksIDQueryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxResponse
	JSON400      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetChecksIDQueryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetChecksIDQueryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDashboardsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Dashboards
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDashboardsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDashboardsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDashboardsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *interface{}
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDashboardsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDashboardsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDashboardsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDashboardsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDashboardsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDashboardsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *interface{}
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDashboardsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDashboardsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchDashboardsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Dashboard
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchDashboardsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchDashboardsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDashboardsIDCellsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Cell
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDashboardsIDCellsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDashboardsIDCellsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutDashboardsIDCellsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Dashboard
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutDashboardsIDCellsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutDashboardsIDCellsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDashboardsIDCellsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDashboardsIDCellsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDashboardsIDCellsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchDashboardsIDCellsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Cell
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchDashboardsIDCellsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchDashboardsIDCellsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDashboardsIDCellsIDViewResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *View
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDashboardsIDCellsIDViewResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDashboardsIDCellsIDViewResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchDashboardsIDCellsIDViewResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *View
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchDashboardsIDCellsIDViewResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchDashboardsIDCellsIDViewResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDashboardsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDashboardsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDashboardsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDashboardsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDashboardsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDashboardsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDashboardsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDashboardsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDashboardsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDashboardsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDashboardsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDashboardsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDashboardsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDashboardsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDashboardsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDashboardsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDashboardsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDashboardsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDashboardsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDashboardsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDashboardsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDashboardsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDashboardsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDashboardsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDashboardsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDashboardsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDashboardsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDBRPsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DBRPs
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDBRPsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDBRPsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDBRPResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *DBRP
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDBRPResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDBRPResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDBRPIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDBRPIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDBRPIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDBRPsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DBRP
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDBRPsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDBRPsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchDBRPIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *DBRP
	JSON400      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchDBRPIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchDBRPIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDeleteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON400      *Error
	JSON403      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDeleteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDeleteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDocumentsTemplatesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Documents
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDocumentsTemplatesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDocumentsTemplatesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDocumentsTemplatesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Document
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDocumentsTemplatesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDocumentsTemplatesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDocumentsTemplatesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDocumentsTemplatesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDocumentsTemplatesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDocumentsTemplatesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Document
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDocumentsTemplatesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDocumentsTemplatesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutDocumentsTemplatesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Document
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutDocumentsTemplatesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutDocumentsTemplatesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetDocumentsTemplatesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetDocumentsTemplatesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetDocumentsTemplatesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostDocumentsTemplatesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostDocumentsTemplatesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostDocumentsTemplatesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteDocumentsTemplatesIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteDocumentsTemplatesIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteDocumentsTemplatesIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetFlagsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Flags
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetFlagsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetFlagsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetHealthResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *HealthCheck
	JSON503      *HealthCheck
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetHealthResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetHealthResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelResponse
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetMeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetMeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetMeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutMePasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutMePasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutMePasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationEndpointsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoints
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationEndpointsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationEndpointsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateNotificationEndpointResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *NotificationEndpoint
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r CreateNotificationEndpointResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateNotificationEndpointResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoint
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoint
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutNotificationEndpointsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationEndpoint
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutNotificationEndpointsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutNotificationEndpointsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationEndpointsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationEndpointsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationEndpointsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostNotificationEndpointIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostNotificationEndpointIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostNotificationEndpointIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteNotificationEndpointsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteNotificationEndpointsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteNotificationEndpointsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationRulesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRules
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationRulesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationRulesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateNotificationRuleResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *NotificationRule
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r CreateNotificationRuleResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateNotificationRuleResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRule
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRule
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutNotificationRulesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *NotificationRule
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutNotificationRulesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutNotificationRulesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationRulesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationRulesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationRulesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostNotificationRuleIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostNotificationRuleIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostNotificationRuleIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteNotificationRulesIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteNotificationRulesIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteNotificationRulesIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetNotificationRulesIDQueryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxResponse
	JSON400      *Error
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetNotificationRulesIDQueryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetNotificationRulesIDQueryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOrgsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Organizations
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetOrgsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOrgsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostOrgsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Organization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostOrgsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostOrgsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteOrgsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteOrgsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteOrgsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOrgsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Organization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetOrgsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOrgsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchOrgsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Organization
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchOrgsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchOrgsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOrgsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetOrgsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOrgsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostOrgsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostOrgsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostOrgsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteOrgsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteOrgsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteOrgsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOrgsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetOrgsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOrgsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostOrgsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostOrgsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostOrgsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteOrgsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteOrgsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteOrgsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetOrgsIDSecretsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *SecretKeysResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetOrgsIDSecretsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetOrgsIDSecretsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchOrgsIDSecretsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchOrgsIDSecretsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchOrgsIDSecretsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostOrgsIDSecretsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostOrgsIDSecretsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostOrgsIDSecretsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostQueryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostQueryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostQueryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostQueryAnalyzeResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *AnalyzeQueryResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostQueryAnalyzeResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostQueryAnalyzeResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostQueryAstResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ASTResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostQueryAstResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostQueryAstResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetQuerySuggestionsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxSuggestions
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetQuerySuggestionsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetQuerySuggestionsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetQuerySuggestionsNameResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *FluxSuggestion
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetQuerySuggestionsNameResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetQuerySuggestionsNameResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetReadyResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Ready
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetReadyResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetReadyResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetScrapersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ScraperTargetResponses
}

// Status returns HTTPResponse.Status
func (r GetScrapersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetScrapersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostScrapersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ScraperTargetResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostScrapersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostScrapersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteScrapersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteScrapersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteScrapersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetScrapersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ScraperTargetResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetScrapersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetScrapersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchScrapersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ScraperTargetResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchScrapersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchScrapersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetScrapersIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetScrapersIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetScrapersIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostScrapersIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostScrapersIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostScrapersIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteScrapersIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteScrapersIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteScrapersIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetScrapersIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetScrapersIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetScrapersIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostScrapersIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostScrapersIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostScrapersIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteScrapersIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteScrapersIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteScrapersIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetScrapersIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetScrapersIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetScrapersIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostScrapersIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostScrapersIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostScrapersIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteScrapersIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteScrapersIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteScrapersIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSetupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *IsOnboarding
}

// Status returns HTTPResponse.Status
func (r GetSetupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSetupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostSetupResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *OnboardingResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostSetupResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostSetupResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostSetupUserResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *OnboardingResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostSetupUserResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostSetupUserResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostSigninResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON401      *Error
	JSON403      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostSigninResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostSigninResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostSignoutResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON401      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostSignoutResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostSignoutResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSourcesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Sources
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetSourcesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSourcesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostSourcesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Source
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostSourcesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostSourcesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteSourcesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteSourcesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteSourcesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSourcesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Source
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetSourcesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSourcesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchSourcesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Source
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchSourcesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchSourcesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSourcesIDBucketsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Buckets
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetSourcesIDBucketsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSourcesIDBucketsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetSourcesIDHealthResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *HealthCheck
	JSON503      *HealthCheck
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetSourcesIDHealthResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetSourcesIDHealthResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ListStacksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *struct {
		Stacks *[]Stack `json:"stacks,omitempty"`
	}
	JSONDefault *Error
}

// Status returns HTTPResponse.Status
func (r ListStacksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ListStacksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type CreateStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r CreateStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r CreateStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ReadStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r ReadStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ReadStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UpdateStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r UpdateStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UpdateStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type UninstallStackResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Stack
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r UninstallStackResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r UninstallStackResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Tasks
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTasksResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Task
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTasksResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTasksResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTasksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTasksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTasksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Task
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchTasksIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Task
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchTasksIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchTasksIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTasksIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTasksIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTasksIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTasksIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTasksIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTasksIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDLogsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Logs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDLogsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDLogsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTasksIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTasksIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTasksIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTasksIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTasksIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTasksIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTasksIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTasksIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTasksIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTasksIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTasksIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTasksIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDRunsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Runs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDRunsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDRunsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTasksIDRunsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Run
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTasksIDRunsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTasksIDRunsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTasksIDRunsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTasksIDRunsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTasksIDRunsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDRunsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Run
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDRunsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDRunsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTasksIDRunsIDLogsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Logs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTasksIDRunsIDLogsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTasksIDRunsIDLogsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTasksIDRunsIDRetryResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Run
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTasksIDRunsIDRetryResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTasksIDRunsIDRetryResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTelegrafPluginsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *TelegrafPlugins
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTelegrafPluginsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTelegrafPluginsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTelegrafsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Telegrafs
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTelegrafsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTelegrafsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTelegrafsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Telegraf
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTelegrafsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTelegrafsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTelegrafsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTelegrafsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTelegrafsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTelegrafsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Telegraf
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTelegrafsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTelegrafsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutTelegrafsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Telegraf
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutTelegrafsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutTelegrafsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTelegrafsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTelegrafsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTelegrafsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTelegrafsIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTelegrafsIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTelegrafsIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTelegrafsIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTelegrafsIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTelegrafsIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTelegrafsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceMembers
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTelegrafsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTelegrafsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTelegrafsIDMembersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceMember
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTelegrafsIDMembersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTelegrafsIDMembersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTelegrafsIDMembersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTelegrafsIDMembersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTelegrafsIDMembersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetTelegrafsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *ResourceOwners
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetTelegrafsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetTelegrafsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostTelegrafsIDOwnersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *ResourceOwner
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostTelegrafsIDOwnersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostTelegrafsIDOwnersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteTelegrafsIDOwnersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteTelegrafsIDOwnersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteTelegrafsIDOwnersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ApplyTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *TemplateSummary
	JSON201      *TemplateSummary
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r ApplyTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ApplyTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type ExportTemplateResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Template
	YAML200      *Template
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r ExportTemplateResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r ExportTemplateResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetUsersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Users
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetUsersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetUsersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostUsersResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostUsersResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostUsersResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteUsersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteUsersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteUsersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetUsersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetUsersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetUsersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchUsersIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *User
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchUsersIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchUsersIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostUsersIDPasswordResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostUsersIDPasswordResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostUsersIDPasswordResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetVariablesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variables
	JSON400      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetVariablesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetVariablesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostVariablesResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *Variable
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostVariablesResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostVariablesResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variable
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PatchVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variable
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PatchVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PatchVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PutVariablesIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *Variable
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PutVariablesIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PutVariablesIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type GetVariablesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON200      *LabelsResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r GetVariablesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r GetVariablesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostVariablesIDLabelsResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON201      *LabelResponse
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostVariablesIDLabelsResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostVariablesIDLabelsResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type DeleteVariablesIDLabelsIDResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON404      *Error
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r DeleteVariablesIDLabelsIDResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r DeleteVariablesIDLabelsIDResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

type PostWriteResponse struct {
	Body         []byte
	HTTPResponse *http.Response
	JSON400      *LineProtocolError
	JSON401      *Error
	JSON403      *Error
	JSON413      *LineProtocolLengthError
	JSONDefault  *Error
}

// Status returns HTTPResponse.Status
func (r PostWriteResponse) Status() string {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.Status
	}
	return http.StatusText(0)
}

// StatusCode returns HTTPResponse.StatusCode
func (r PostWriteResponse) StatusCode() int {
	if r.HTTPResponse != nil {
		return r.HTTPResponse.StatusCode
	}
	return 0
}

// GetRoutesWithResponse request returning *GetRoutesResponse
func (c *ClientWithResponses) GetRoutesWithResponse(ctx context.Context, params *GetRoutesParams) (*GetRoutesResponse, error) {
	rsp, err := c.GetRoutes(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetRoutesResponse(rsp)
}

// GetAuthorizationsWithResponse request returning *GetAuthorizationsResponse
func (c *ClientWithResponses) GetAuthorizationsWithResponse(ctx context.Context, params *GetAuthorizationsParams) (*GetAuthorizationsResponse, error) {
	rsp, err := c.GetAuthorizations(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetAuthorizationsResponse(rsp)
}

// PostAuthorizationsWithBodyWithResponse request with arbitrary body returning *PostAuthorizationsResponse
func (c *ClientWithResponses) PostAuthorizationsWithBodyWithResponse(ctx context.Context, params *PostAuthorizationsParams, contentType string, body io.Reader) (*PostAuthorizationsResponse, error) {
	rsp, err := c.PostAuthorizationsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostAuthorizationsResponse(rsp)
}

func (c *ClientWithResponses) PostAuthorizationsWithResponse(ctx context.Context, params *PostAuthorizationsParams, body PostAuthorizationsJSONRequestBody) (*PostAuthorizationsResponse, error) {
	rsp, err := c.PostAuthorizations(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostAuthorizationsResponse(rsp)
}

// DeleteAuthorizationsIDWithResponse request returning *DeleteAuthorizationsIDResponse
func (c *ClientWithResponses) DeleteAuthorizationsIDWithResponse(ctx context.Context, authID string, params *DeleteAuthorizationsIDParams) (*DeleteAuthorizationsIDResponse, error) {
	rsp, err := c.DeleteAuthorizationsID(ctx, authID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteAuthorizationsIDResponse(rsp)
}

// GetAuthorizationsIDWithResponse request returning *GetAuthorizationsIDResponse
func (c *ClientWithResponses) GetAuthorizationsIDWithResponse(ctx context.Context, authID string, params *GetAuthorizationsIDParams) (*GetAuthorizationsIDResponse, error) {
	rsp, err := c.GetAuthorizationsID(ctx, authID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetAuthorizationsIDResponse(rsp)
}

// PatchAuthorizationsIDWithBodyWithResponse request with arbitrary body returning *PatchAuthorizationsIDResponse
func (c *ClientWithResponses) PatchAuthorizationsIDWithBodyWithResponse(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, contentType string, body io.Reader) (*PatchAuthorizationsIDResponse, error) {
	rsp, err := c.PatchAuthorizationsIDWithBody(ctx, authID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchAuthorizationsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchAuthorizationsIDWithResponse(ctx context.Context, authID string, params *PatchAuthorizationsIDParams, body PatchAuthorizationsIDJSONRequestBody) (*PatchAuthorizationsIDResponse, error) {
	rsp, err := c.PatchAuthorizationsID(ctx, authID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchAuthorizationsIDResponse(rsp)
}

// GetBucketsWithResponse request returning *GetBucketsResponse
func (c *ClientWithResponses) GetBucketsWithResponse(ctx context.Context, params *GetBucketsParams) (*GetBucketsResponse, error) {
	rsp, err := c.GetBuckets(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsResponse(rsp)
}

// PostBucketsWithBodyWithResponse request with arbitrary body returning *PostBucketsResponse
func (c *ClientWithResponses) PostBucketsWithBodyWithResponse(ctx context.Context, params *PostBucketsParams, contentType string, body io.Reader) (*PostBucketsResponse, error) {
	rsp, err := c.PostBucketsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsWithResponse(ctx context.Context, params *PostBucketsParams, body PostBucketsJSONRequestBody) (*PostBucketsResponse, error) {
	rsp, err := c.PostBuckets(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsResponse(rsp)
}

// DeleteBucketsIDWithResponse request returning *DeleteBucketsIDResponse
func (c *ClientWithResponses) DeleteBucketsIDWithResponse(ctx context.Context, bucketID string, params *DeleteBucketsIDParams) (*DeleteBucketsIDResponse, error) {
	rsp, err := c.DeleteBucketsID(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDResponse(rsp)
}

// GetBucketsIDWithResponse request returning *GetBucketsIDResponse
func (c *ClientWithResponses) GetBucketsIDWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDParams) (*GetBucketsIDResponse, error) {
	rsp, err := c.GetBucketsID(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDResponse(rsp)
}

// PatchBucketsIDWithBodyWithResponse request with arbitrary body returning *PatchBucketsIDResponse
func (c *ClientWithResponses) PatchBucketsIDWithBodyWithResponse(ctx context.Context, bucketID string, params *PatchBucketsIDParams, contentType string, body io.Reader) (*PatchBucketsIDResponse, error) {
	rsp, err := c.PatchBucketsIDWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchBucketsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchBucketsIDWithResponse(ctx context.Context, bucketID string, params *PatchBucketsIDParams, body PatchBucketsIDJSONRequestBody) (*PatchBucketsIDResponse, error) {
	rsp, err := c.PatchBucketsID(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchBucketsIDResponse(rsp)
}

// GetBucketsIDLabelsWithResponse request returning *GetBucketsIDLabelsResponse
func (c *ClientWithResponses) GetBucketsIDLabelsWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDLabelsParams) (*GetBucketsIDLabelsResponse, error) {
	rsp, err := c.GetBucketsIDLabels(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDLabelsResponse(rsp)
}

// PostBucketsIDLabelsWithBodyWithResponse request with arbitrary body returning *PostBucketsIDLabelsResponse
func (c *ClientWithResponses) PostBucketsIDLabelsWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, contentType string, body io.Reader) (*PostBucketsIDLabelsResponse, error) {
	rsp, err := c.PostBucketsIDLabelsWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsIDLabelsWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDLabelsParams, body PostBucketsIDLabelsJSONRequestBody) (*PostBucketsIDLabelsResponse, error) {
	rsp, err := c.PostBucketsIDLabels(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDLabelsResponse(rsp)
}

// DeleteBucketsIDLabelsIDWithResponse request returning *DeleteBucketsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteBucketsIDLabelsIDWithResponse(ctx context.Context, bucketID string, labelID string, params *DeleteBucketsIDLabelsIDParams) (*DeleteBucketsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteBucketsIDLabelsID(ctx, bucketID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDLabelsIDResponse(rsp)
}

// GetBucketsIDMembersWithResponse request returning *GetBucketsIDMembersResponse
func (c *ClientWithResponses) GetBucketsIDMembersWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDMembersParams) (*GetBucketsIDMembersResponse, error) {
	rsp, err := c.GetBucketsIDMembers(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDMembersResponse(rsp)
}

// PostBucketsIDMembersWithBodyWithResponse request with arbitrary body returning *PostBucketsIDMembersResponse
func (c *ClientWithResponses) PostBucketsIDMembersWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, contentType string, body io.Reader) (*PostBucketsIDMembersResponse, error) {
	rsp, err := c.PostBucketsIDMembersWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsIDMembersWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDMembersParams, body PostBucketsIDMembersJSONRequestBody) (*PostBucketsIDMembersResponse, error) {
	rsp, err := c.PostBucketsIDMembers(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDMembersResponse(rsp)
}

// DeleteBucketsIDMembersIDWithResponse request returning *DeleteBucketsIDMembersIDResponse
func (c *ClientWithResponses) DeleteBucketsIDMembersIDWithResponse(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDMembersIDParams) (*DeleteBucketsIDMembersIDResponse, error) {
	rsp, err := c.DeleteBucketsIDMembersID(ctx, bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDMembersIDResponse(rsp)
}

// GetBucketsIDOwnersWithResponse request returning *GetBucketsIDOwnersResponse
func (c *ClientWithResponses) GetBucketsIDOwnersWithResponse(ctx context.Context, bucketID string, params *GetBucketsIDOwnersParams) (*GetBucketsIDOwnersResponse, error) {
	rsp, err := c.GetBucketsIDOwners(ctx, bucketID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetBucketsIDOwnersResponse(rsp)
}

// PostBucketsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostBucketsIDOwnersResponse
func (c *ClientWithResponses) PostBucketsIDOwnersWithBodyWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, contentType string, body io.Reader) (*PostBucketsIDOwnersResponse, error) {
	rsp, err := c.PostBucketsIDOwnersWithBody(ctx, bucketID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostBucketsIDOwnersWithResponse(ctx context.Context, bucketID string, params *PostBucketsIDOwnersParams, body PostBucketsIDOwnersJSONRequestBody) (*PostBucketsIDOwnersResponse, error) {
	rsp, err := c.PostBucketsIDOwners(ctx, bucketID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostBucketsIDOwnersResponse(rsp)
}

// DeleteBucketsIDOwnersIDWithResponse request returning *DeleteBucketsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteBucketsIDOwnersIDWithResponse(ctx context.Context, bucketID string, userID string, params *DeleteBucketsIDOwnersIDParams) (*DeleteBucketsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteBucketsIDOwnersID(ctx, bucketID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteBucketsIDOwnersIDResponse(rsp)
}

// GetChecksWithResponse request returning *GetChecksResponse
func (c *ClientWithResponses) GetChecksWithResponse(ctx context.Context, params *GetChecksParams) (*GetChecksResponse, error) {
	rsp, err := c.GetChecks(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksResponse(rsp)
}

// CreateCheckWithBodyWithResponse request with arbitrary body returning *CreateCheckResponse
func (c *ClientWithResponses) CreateCheckWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateCheckResponse, error) {
	rsp, err := c.CreateCheckWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateCheckResponse(rsp)
}

func (c *ClientWithResponses) CreateCheckWithResponse(ctx context.Context, body CreateCheckJSONRequestBody) (*CreateCheckResponse, error) {
	rsp, err := c.CreateCheck(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateCheckResponse(rsp)
}

// DeleteChecksIDWithResponse request returning *DeleteChecksIDResponse
func (c *ClientWithResponses) DeleteChecksIDWithResponse(ctx context.Context, checkID string, params *DeleteChecksIDParams) (*DeleteChecksIDResponse, error) {
	rsp, err := c.DeleteChecksID(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteChecksIDResponse(rsp)
}

// GetChecksIDWithResponse request returning *GetChecksIDResponse
func (c *ClientWithResponses) GetChecksIDWithResponse(ctx context.Context, checkID string, params *GetChecksIDParams) (*GetChecksIDResponse, error) {
	rsp, err := c.GetChecksID(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksIDResponse(rsp)
}

// PatchChecksIDWithBodyWithResponse request with arbitrary body returning *PatchChecksIDResponse
func (c *ClientWithResponses) PatchChecksIDWithBodyWithResponse(ctx context.Context, checkID string, params *PatchChecksIDParams, contentType string, body io.Reader) (*PatchChecksIDResponse, error) {
	rsp, err := c.PatchChecksIDWithBody(ctx, checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchChecksIDResponse(rsp)
}

func (c *ClientWithResponses) PatchChecksIDWithResponse(ctx context.Context, checkID string, params *PatchChecksIDParams, body PatchChecksIDJSONRequestBody) (*PatchChecksIDResponse, error) {
	rsp, err := c.PatchChecksID(ctx, checkID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchChecksIDResponse(rsp)
}

// PutChecksIDWithBodyWithResponse request with arbitrary body returning *PutChecksIDResponse
func (c *ClientWithResponses) PutChecksIDWithBodyWithResponse(ctx context.Context, checkID string, params *PutChecksIDParams, contentType string, body io.Reader) (*PutChecksIDResponse, error) {
	rsp, err := c.PutChecksIDWithBody(ctx, checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutChecksIDResponse(rsp)
}

func (c *ClientWithResponses) PutChecksIDWithResponse(ctx context.Context, checkID string, params *PutChecksIDParams, body PutChecksIDJSONRequestBody) (*PutChecksIDResponse, error) {
	rsp, err := c.PutChecksID(ctx, checkID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutChecksIDResponse(rsp)
}

// GetChecksIDLabelsWithResponse request returning *GetChecksIDLabelsResponse
func (c *ClientWithResponses) GetChecksIDLabelsWithResponse(ctx context.Context, checkID string, params *GetChecksIDLabelsParams) (*GetChecksIDLabelsResponse, error) {
	rsp, err := c.GetChecksIDLabels(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksIDLabelsResponse(rsp)
}

// PostChecksIDLabelsWithBodyWithResponse request with arbitrary body returning *PostChecksIDLabelsResponse
func (c *ClientWithResponses) PostChecksIDLabelsWithBodyWithResponse(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, contentType string, body io.Reader) (*PostChecksIDLabelsResponse, error) {
	rsp, err := c.PostChecksIDLabelsWithBody(ctx, checkID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostChecksIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostChecksIDLabelsWithResponse(ctx context.Context, checkID string, params *PostChecksIDLabelsParams, body PostChecksIDLabelsJSONRequestBody) (*PostChecksIDLabelsResponse, error) {
	rsp, err := c.PostChecksIDLabels(ctx, checkID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostChecksIDLabelsResponse(rsp)
}

// DeleteChecksIDLabelsIDWithResponse request returning *DeleteChecksIDLabelsIDResponse
func (c *ClientWithResponses) DeleteChecksIDLabelsIDWithResponse(ctx context.Context, checkID string, labelID string, params *DeleteChecksIDLabelsIDParams) (*DeleteChecksIDLabelsIDResponse, error) {
	rsp, err := c.DeleteChecksIDLabelsID(ctx, checkID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteChecksIDLabelsIDResponse(rsp)
}

// GetChecksIDQueryWithResponse request returning *GetChecksIDQueryResponse
func (c *ClientWithResponses) GetChecksIDQueryWithResponse(ctx context.Context, checkID string, params *GetChecksIDQueryParams) (*GetChecksIDQueryResponse, error) {
	rsp, err := c.GetChecksIDQuery(ctx, checkID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetChecksIDQueryResponse(rsp)
}

// GetDashboardsWithResponse request returning *GetDashboardsResponse
func (c *ClientWithResponses) GetDashboardsWithResponse(ctx context.Context, params *GetDashboardsParams) (*GetDashboardsResponse, error) {
	rsp, err := c.GetDashboards(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsResponse(rsp)
}

// PostDashboardsWithBodyWithResponse request with arbitrary body returning *PostDashboardsResponse
func (c *ClientWithResponses) PostDashboardsWithBodyWithResponse(ctx context.Context, params *PostDashboardsParams, contentType string, body io.Reader) (*PostDashboardsResponse, error) {
	rsp, err := c.PostDashboardsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsWithResponse(ctx context.Context, params *PostDashboardsParams, body PostDashboardsJSONRequestBody) (*PostDashboardsResponse, error) {
	rsp, err := c.PostDashboards(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsResponse(rsp)
}

// DeleteDashboardsIDWithResponse request returning *DeleteDashboardsIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *DeleteDashboardsIDParams) (*DeleteDashboardsIDResponse, error) {
	rsp, err := c.DeleteDashboardsID(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDResponse(rsp)
}

// GetDashboardsIDWithResponse request returning *GetDashboardsIDResponse
func (c *ClientWithResponses) GetDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDParams) (*GetDashboardsIDResponse, error) {
	rsp, err := c.GetDashboardsID(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDResponse(rsp)
}

// PatchDashboardsIDWithBodyWithResponse request with arbitrary body returning *PatchDashboardsIDResponse
func (c *ClientWithResponses) PatchDashboardsIDWithBodyWithResponse(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, contentType string, body io.Reader) (*PatchDashboardsIDResponse, error) {
	rsp, err := c.PatchDashboardsIDWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchDashboardsIDWithResponse(ctx context.Context, dashboardID string, params *PatchDashboardsIDParams, body PatchDashboardsIDJSONRequestBody) (*PatchDashboardsIDResponse, error) {
	rsp, err := c.PatchDashboardsID(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDResponse(rsp)
}

// PostDashboardsIDCellsWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDCellsResponse
func (c *ClientWithResponses) PostDashboardsIDCellsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, contentType string, body io.Reader) (*PostDashboardsIDCellsResponse, error) {
	rsp, err := c.PostDashboardsIDCellsWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDCellsResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDCellsWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDCellsParams, body PostDashboardsIDCellsJSONRequestBody) (*PostDashboardsIDCellsResponse, error) {
	rsp, err := c.PostDashboardsIDCells(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDCellsResponse(rsp)
}

// PutDashboardsIDCellsWithBodyWithResponse request with arbitrary body returning *PutDashboardsIDCellsResponse
func (c *ClientWithResponses) PutDashboardsIDCellsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, contentType string, body io.Reader) (*PutDashboardsIDCellsResponse, error) {
	rsp, err := c.PutDashboardsIDCellsWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDashboardsIDCellsResponse(rsp)
}

func (c *ClientWithResponses) PutDashboardsIDCellsWithResponse(ctx context.Context, dashboardID string, params *PutDashboardsIDCellsParams, body PutDashboardsIDCellsJSONRequestBody) (*PutDashboardsIDCellsResponse, error) {
	rsp, err := c.PutDashboardsIDCells(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDashboardsIDCellsResponse(rsp)
}

// DeleteDashboardsIDCellsIDWithResponse request returning *DeleteDashboardsIDCellsIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDCellsIDWithResponse(ctx context.Context, dashboardID string, cellID string, params *DeleteDashboardsIDCellsIDParams) (*DeleteDashboardsIDCellsIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDCellsID(ctx, dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDCellsIDResponse(rsp)
}

// PatchDashboardsIDCellsIDWithBodyWithResponse request with arbitrary body returning *PatchDashboardsIDCellsIDResponse
func (c *ClientWithResponses) PatchDashboardsIDCellsIDWithBodyWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, contentType string, body io.Reader) (*PatchDashboardsIDCellsIDResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsIDWithBody(ctx, dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchDashboardsIDCellsIDWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDParams, body PatchDashboardsIDCellsIDJSONRequestBody) (*PatchDashboardsIDCellsIDResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsID(ctx, dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDResponse(rsp)
}

// GetDashboardsIDCellsIDViewWithResponse request returning *GetDashboardsIDCellsIDViewResponse
func (c *ClientWithResponses) GetDashboardsIDCellsIDViewWithResponse(ctx context.Context, dashboardID string, cellID string, params *GetDashboardsIDCellsIDViewParams) (*GetDashboardsIDCellsIDViewResponse, error) {
	rsp, err := c.GetDashboardsIDCellsIDView(ctx, dashboardID, cellID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDCellsIDViewResponse(rsp)
}

// PatchDashboardsIDCellsIDViewWithBodyWithResponse request with arbitrary body returning *PatchDashboardsIDCellsIDViewResponse
func (c *ClientWithResponses) PatchDashboardsIDCellsIDViewWithBodyWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, contentType string, body io.Reader) (*PatchDashboardsIDCellsIDViewResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsIDViewWithBody(ctx, dashboardID, cellID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDViewResponse(rsp)
}

func (c *ClientWithResponses) PatchDashboardsIDCellsIDViewWithResponse(ctx context.Context, dashboardID string, cellID string, params *PatchDashboardsIDCellsIDViewParams, body PatchDashboardsIDCellsIDViewJSONRequestBody) (*PatchDashboardsIDCellsIDViewResponse, error) {
	rsp, err := c.PatchDashboardsIDCellsIDView(ctx, dashboardID, cellID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDashboardsIDCellsIDViewResponse(rsp)
}

// GetDashboardsIDLabelsWithResponse request returning *GetDashboardsIDLabelsResponse
func (c *ClientWithResponses) GetDashboardsIDLabelsWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDLabelsParams) (*GetDashboardsIDLabelsResponse, error) {
	rsp, err := c.GetDashboardsIDLabels(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDLabelsResponse(rsp)
}

// PostDashboardsIDLabelsWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDLabelsResponse
func (c *ClientWithResponses) PostDashboardsIDLabelsWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, contentType string, body io.Reader) (*PostDashboardsIDLabelsResponse, error) {
	rsp, err := c.PostDashboardsIDLabelsWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDLabelsWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDLabelsParams, body PostDashboardsIDLabelsJSONRequestBody) (*PostDashboardsIDLabelsResponse, error) {
	rsp, err := c.PostDashboardsIDLabels(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDLabelsResponse(rsp)
}

// DeleteDashboardsIDLabelsIDWithResponse request returning *DeleteDashboardsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDLabelsIDWithResponse(ctx context.Context, dashboardID string, labelID string, params *DeleteDashboardsIDLabelsIDParams) (*DeleteDashboardsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDLabelsID(ctx, dashboardID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDLabelsIDResponse(rsp)
}

// GetDashboardsIDMembersWithResponse request returning *GetDashboardsIDMembersResponse
func (c *ClientWithResponses) GetDashboardsIDMembersWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDMembersParams) (*GetDashboardsIDMembersResponse, error) {
	rsp, err := c.GetDashboardsIDMembers(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDMembersResponse(rsp)
}

// PostDashboardsIDMembersWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDMembersResponse
func (c *ClientWithResponses) PostDashboardsIDMembersWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, contentType string, body io.Reader) (*PostDashboardsIDMembersResponse, error) {
	rsp, err := c.PostDashboardsIDMembersWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDMembersWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDMembersParams, body PostDashboardsIDMembersJSONRequestBody) (*PostDashboardsIDMembersResponse, error) {
	rsp, err := c.PostDashboardsIDMembers(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDMembersResponse(rsp)
}

// DeleteDashboardsIDMembersIDWithResponse request returning *DeleteDashboardsIDMembersIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDMembersIDWithResponse(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDMembersIDParams) (*DeleteDashboardsIDMembersIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDMembersID(ctx, dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDMembersIDResponse(rsp)
}

// GetDashboardsIDOwnersWithResponse request returning *GetDashboardsIDOwnersResponse
func (c *ClientWithResponses) GetDashboardsIDOwnersWithResponse(ctx context.Context, dashboardID string, params *GetDashboardsIDOwnersParams) (*GetDashboardsIDOwnersResponse, error) {
	rsp, err := c.GetDashboardsIDOwners(ctx, dashboardID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDashboardsIDOwnersResponse(rsp)
}

// PostDashboardsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostDashboardsIDOwnersResponse
func (c *ClientWithResponses) PostDashboardsIDOwnersWithBodyWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, contentType string, body io.Reader) (*PostDashboardsIDOwnersResponse, error) {
	rsp, err := c.PostDashboardsIDOwnersWithBody(ctx, dashboardID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostDashboardsIDOwnersWithResponse(ctx context.Context, dashboardID string, params *PostDashboardsIDOwnersParams, body PostDashboardsIDOwnersJSONRequestBody) (*PostDashboardsIDOwnersResponse, error) {
	rsp, err := c.PostDashboardsIDOwners(ctx, dashboardID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDashboardsIDOwnersResponse(rsp)
}

// DeleteDashboardsIDOwnersIDWithResponse request returning *DeleteDashboardsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteDashboardsIDOwnersIDWithResponse(ctx context.Context, dashboardID string, userID string, params *DeleteDashboardsIDOwnersIDParams) (*DeleteDashboardsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteDashboardsIDOwnersID(ctx, dashboardID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDashboardsIDOwnersIDResponse(rsp)
}

// GetDBRPsWithResponse request returning *GetDBRPsResponse
func (c *ClientWithResponses) GetDBRPsWithResponse(ctx context.Context, params *GetDBRPsParams) (*GetDBRPsResponse, error) {
	rsp, err := c.GetDBRPs(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDBRPsResponse(rsp)
}

// PostDBRPWithBodyWithResponse request with arbitrary body returning *PostDBRPResponse
func (c *ClientWithResponses) PostDBRPWithBodyWithResponse(ctx context.Context, params *PostDBRPParams, contentType string, body io.Reader) (*PostDBRPResponse, error) {
	rsp, err := c.PostDBRPWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDBRPResponse(rsp)
}

func (c *ClientWithResponses) PostDBRPWithResponse(ctx context.Context, params *PostDBRPParams, body PostDBRPJSONRequestBody) (*PostDBRPResponse, error) {
	rsp, err := c.PostDBRP(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDBRPResponse(rsp)
}

// DeleteDBRPIDWithResponse request returning *DeleteDBRPIDResponse
func (c *ClientWithResponses) DeleteDBRPIDWithResponse(ctx context.Context, dbrpID string, params *DeleteDBRPIDParams) (*DeleteDBRPIDResponse, error) {
	rsp, err := c.DeleteDBRPID(ctx, dbrpID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDBRPIDResponse(rsp)
}

// GetDBRPsIDWithResponse request returning *GetDBRPsIDResponse
func (c *ClientWithResponses) GetDBRPsIDWithResponse(ctx context.Context, dbrpID string, params *GetDBRPsIDParams) (*GetDBRPsIDResponse, error) {
	rsp, err := c.GetDBRPsID(ctx, dbrpID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDBRPsIDResponse(rsp)
}

// PatchDBRPIDWithBodyWithResponse request with arbitrary body returning *PatchDBRPIDResponse
func (c *ClientWithResponses) PatchDBRPIDWithBodyWithResponse(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, contentType string, body io.Reader) (*PatchDBRPIDResponse, error) {
	rsp, err := c.PatchDBRPIDWithBody(ctx, dbrpID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDBRPIDResponse(rsp)
}

func (c *ClientWithResponses) PatchDBRPIDWithResponse(ctx context.Context, dbrpID string, params *PatchDBRPIDParams, body PatchDBRPIDJSONRequestBody) (*PatchDBRPIDResponse, error) {
	rsp, err := c.PatchDBRPID(ctx, dbrpID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchDBRPIDResponse(rsp)
}

// PostDeleteWithBodyWithResponse request with arbitrary body returning *PostDeleteResponse
func (c *ClientWithResponses) PostDeleteWithBodyWithResponse(ctx context.Context, params *PostDeleteParams, contentType string, body io.Reader) (*PostDeleteResponse, error) {
	rsp, err := c.PostDeleteWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDeleteResponse(rsp)
}

func (c *ClientWithResponses) PostDeleteWithResponse(ctx context.Context, params *PostDeleteParams, body PostDeleteJSONRequestBody) (*PostDeleteResponse, error) {
	rsp, err := c.PostDelete(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDeleteResponse(rsp)
}

// GetDocumentsTemplatesWithResponse request returning *GetDocumentsTemplatesResponse
func (c *ClientWithResponses) GetDocumentsTemplatesWithResponse(ctx context.Context, params *GetDocumentsTemplatesParams) (*GetDocumentsTemplatesResponse, error) {
	rsp, err := c.GetDocumentsTemplates(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDocumentsTemplatesResponse(rsp)
}

// PostDocumentsTemplatesWithBodyWithResponse request with arbitrary body returning *PostDocumentsTemplatesResponse
func (c *ClientWithResponses) PostDocumentsTemplatesWithBodyWithResponse(ctx context.Context, params *PostDocumentsTemplatesParams, contentType string, body io.Reader) (*PostDocumentsTemplatesResponse, error) {
	rsp, err := c.PostDocumentsTemplatesWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesResponse(rsp)
}

func (c *ClientWithResponses) PostDocumentsTemplatesWithResponse(ctx context.Context, params *PostDocumentsTemplatesParams, body PostDocumentsTemplatesJSONRequestBody) (*PostDocumentsTemplatesResponse, error) {
	rsp, err := c.PostDocumentsTemplates(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesResponse(rsp)
}

// DeleteDocumentsTemplatesIDWithResponse request returning *DeleteDocumentsTemplatesIDResponse
func (c *ClientWithResponses) DeleteDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *DeleteDocumentsTemplatesIDParams) (*DeleteDocumentsTemplatesIDResponse, error) {
	rsp, err := c.DeleteDocumentsTemplatesID(ctx, templateID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDocumentsTemplatesIDResponse(rsp)
}

// GetDocumentsTemplatesIDWithResponse request returning *GetDocumentsTemplatesIDResponse
func (c *ClientWithResponses) GetDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDParams) (*GetDocumentsTemplatesIDResponse, error) {
	rsp, err := c.GetDocumentsTemplatesID(ctx, templateID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDocumentsTemplatesIDResponse(rsp)
}

// PutDocumentsTemplatesIDWithBodyWithResponse request with arbitrary body returning *PutDocumentsTemplatesIDResponse
func (c *ClientWithResponses) PutDocumentsTemplatesIDWithBodyWithResponse(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, contentType string, body io.Reader) (*PutDocumentsTemplatesIDResponse, error) {
	rsp, err := c.PutDocumentsTemplatesIDWithBody(ctx, templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDocumentsTemplatesIDResponse(rsp)
}

func (c *ClientWithResponses) PutDocumentsTemplatesIDWithResponse(ctx context.Context, templateID string, params *PutDocumentsTemplatesIDParams, body PutDocumentsTemplatesIDJSONRequestBody) (*PutDocumentsTemplatesIDResponse, error) {
	rsp, err := c.PutDocumentsTemplatesID(ctx, templateID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutDocumentsTemplatesIDResponse(rsp)
}

// GetDocumentsTemplatesIDLabelsWithResponse request returning *GetDocumentsTemplatesIDLabelsResponse
func (c *ClientWithResponses) GetDocumentsTemplatesIDLabelsWithResponse(ctx context.Context, templateID string, params *GetDocumentsTemplatesIDLabelsParams) (*GetDocumentsTemplatesIDLabelsResponse, error) {
	rsp, err := c.GetDocumentsTemplatesIDLabels(ctx, templateID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetDocumentsTemplatesIDLabelsResponse(rsp)
}

// PostDocumentsTemplatesIDLabelsWithBodyWithResponse request with arbitrary body returning *PostDocumentsTemplatesIDLabelsResponse
func (c *ClientWithResponses) PostDocumentsTemplatesIDLabelsWithBodyWithResponse(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, contentType string, body io.Reader) (*PostDocumentsTemplatesIDLabelsResponse, error) {
	rsp, err := c.PostDocumentsTemplatesIDLabelsWithBody(ctx, templateID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostDocumentsTemplatesIDLabelsWithResponse(ctx context.Context, templateID string, params *PostDocumentsTemplatesIDLabelsParams, body PostDocumentsTemplatesIDLabelsJSONRequestBody) (*PostDocumentsTemplatesIDLabelsResponse, error) {
	rsp, err := c.PostDocumentsTemplatesIDLabels(ctx, templateID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostDocumentsTemplatesIDLabelsResponse(rsp)
}

// DeleteDocumentsTemplatesIDLabelsIDWithResponse request returning *DeleteDocumentsTemplatesIDLabelsIDResponse
func (c *ClientWithResponses) DeleteDocumentsTemplatesIDLabelsIDWithResponse(ctx context.Context, templateID string, labelID string, params *DeleteDocumentsTemplatesIDLabelsIDParams) (*DeleteDocumentsTemplatesIDLabelsIDResponse, error) {
	rsp, err := c.DeleteDocumentsTemplatesIDLabelsID(ctx, templateID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteDocumentsTemplatesIDLabelsIDResponse(rsp)
}

// GetFlagsWithResponse request returning *GetFlagsResponse
func (c *ClientWithResponses) GetFlagsWithResponse(ctx context.Context, params *GetFlagsParams) (*GetFlagsResponse, error) {
	rsp, err := c.GetFlags(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetFlagsResponse(rsp)
}

// GetHealthWithResponse request returning *GetHealthResponse
func (c *ClientWithResponses) GetHealthWithResponse(ctx context.Context, params *GetHealthParams) (*GetHealthResponse, error) {
	rsp, err := c.GetHealth(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetHealthResponse(rsp)
}

// GetLabelsWithResponse request returning *GetLabelsResponse
func (c *ClientWithResponses) GetLabelsWithResponse(ctx context.Context, params *GetLabelsParams) (*GetLabelsResponse, error) {
	rsp, err := c.GetLabels(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelsResponse(rsp)
}

// PostLabelsWithBodyWithResponse request with arbitrary body returning *PostLabelsResponse
func (c *ClientWithResponses) PostLabelsWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*PostLabelsResponse, error) {
	rsp, err := c.PostLabelsWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostLabelsWithResponse(ctx context.Context, body PostLabelsJSONRequestBody) (*PostLabelsResponse, error) {
	rsp, err := c.PostLabels(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParsePostLabelsResponse(rsp)
}

// DeleteLabelsIDWithResponse request returning *DeleteLabelsIDResponse
func (c *ClientWithResponses) DeleteLabelsIDWithResponse(ctx context.Context, labelID string, params *DeleteLabelsIDParams) (*DeleteLabelsIDResponse, error) {
	rsp, err := c.DeleteLabelsID(ctx, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteLabelsIDResponse(rsp)
}

// GetLabelsIDWithResponse request returning *GetLabelsIDResponse
func (c *ClientWithResponses) GetLabelsIDWithResponse(ctx context.Context, labelID string, params *GetLabelsIDParams) (*GetLabelsIDResponse, error) {
	rsp, err := c.GetLabelsID(ctx, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetLabelsIDResponse(rsp)
}

// PatchLabelsIDWithBodyWithResponse request with arbitrary body returning *PatchLabelsIDResponse
func (c *ClientWithResponses) PatchLabelsIDWithBodyWithResponse(ctx context.Context, labelID string, params *PatchLabelsIDParams, contentType string, body io.Reader) (*PatchLabelsIDResponse, error) {
	rsp, err := c.PatchLabelsIDWithBody(ctx, labelID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchLabelsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchLabelsIDWithResponse(ctx context.Context, labelID string, params *PatchLabelsIDParams, body PatchLabelsIDJSONRequestBody) (*PatchLabelsIDResponse, error) {
	rsp, err := c.PatchLabelsID(ctx, labelID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchLabelsIDResponse(rsp)
}

// GetMeWithResponse request returning *GetMeResponse
func (c *ClientWithResponses) GetMeWithResponse(ctx context.Context, params *GetMeParams) (*GetMeResponse, error) {
	rsp, err := c.GetMe(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetMeResponse(rsp)
}

// PutMePasswordWithBodyWithResponse request with arbitrary body returning *PutMePasswordResponse
func (c *ClientWithResponses) PutMePasswordWithBodyWithResponse(ctx context.Context, params *PutMePasswordParams, contentType string, body io.Reader) (*PutMePasswordResponse, error) {
	rsp, err := c.PutMePasswordWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutMePasswordResponse(rsp)
}

func (c *ClientWithResponses) PutMePasswordWithResponse(ctx context.Context, params *PutMePasswordParams, body PutMePasswordJSONRequestBody) (*PutMePasswordResponse, error) {
	rsp, err := c.PutMePassword(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutMePasswordResponse(rsp)
}

// GetNotificationEndpointsWithResponse request returning *GetNotificationEndpointsResponse
func (c *ClientWithResponses) GetNotificationEndpointsWithResponse(ctx context.Context, params *GetNotificationEndpointsParams) (*GetNotificationEndpointsResponse, error) {
	rsp, err := c.GetNotificationEndpoints(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationEndpointsResponse(rsp)
}

// CreateNotificationEndpointWithBodyWithResponse request with arbitrary body returning *CreateNotificationEndpointResponse
func (c *ClientWithResponses) CreateNotificationEndpointWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateNotificationEndpointResponse, error) {
	rsp, err := c.CreateNotificationEndpointWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationEndpointResponse(rsp)
}

func (c *ClientWithResponses) CreateNotificationEndpointWithResponse(ctx context.Context, body CreateNotificationEndpointJSONRequestBody) (*CreateNotificationEndpointResponse, error) {
	rsp, err := c.CreateNotificationEndpoint(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationEndpointResponse(rsp)
}

// DeleteNotificationEndpointsIDWithResponse request returning *DeleteNotificationEndpointsIDResponse
func (c *ClientWithResponses) DeleteNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *DeleteNotificationEndpointsIDParams) (*DeleteNotificationEndpointsIDResponse, error) {
	rsp, err := c.DeleteNotificationEndpointsID(ctx, endpointID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationEndpointsIDResponse(rsp)
}

// GetNotificationEndpointsIDWithResponse request returning *GetNotificationEndpointsIDResponse
func (c *ClientWithResponses) GetNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDParams) (*GetNotificationEndpointsIDResponse, error) {
	rsp, err := c.GetNotificationEndpointsID(ctx, endpointID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationEndpointsIDResponse(rsp)
}

// PatchNotificationEndpointsIDWithBodyWithResponse request with arbitrary body returning *PatchNotificationEndpointsIDResponse
func (c *ClientWithResponses) PatchNotificationEndpointsIDWithBodyWithResponse(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, contentType string, body io.Reader) (*PatchNotificationEndpointsIDResponse, error) {
	rsp, err := c.PatchNotificationEndpointsIDWithBody(ctx, endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationEndpointsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *PatchNotificationEndpointsIDParams, body PatchNotificationEndpointsIDJSONRequestBody) (*PatchNotificationEndpointsIDResponse, error) {
	rsp, err := c.PatchNotificationEndpointsID(ctx, endpointID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationEndpointsIDResponse(rsp)
}

// PutNotificationEndpointsIDWithBodyWithResponse request with arbitrary body returning *PutNotificationEndpointsIDResponse
func (c *ClientWithResponses) PutNotificationEndpointsIDWithBodyWithResponse(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, contentType string, body io.Reader) (*PutNotificationEndpointsIDResponse, error) {
	rsp, err := c.PutNotificationEndpointsIDWithBody(ctx, endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationEndpointsIDResponse(rsp)
}

func (c *ClientWithResponses) PutNotificationEndpointsIDWithResponse(ctx context.Context, endpointID string, params *PutNotificationEndpointsIDParams, body PutNotificationEndpointsIDJSONRequestBody) (*PutNotificationEndpointsIDResponse, error) {
	rsp, err := c.PutNotificationEndpointsID(ctx, endpointID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationEndpointsIDResponse(rsp)
}

// GetNotificationEndpointsIDLabelsWithResponse request returning *GetNotificationEndpointsIDLabelsResponse
func (c *ClientWithResponses) GetNotificationEndpointsIDLabelsWithResponse(ctx context.Context, endpointID string, params *GetNotificationEndpointsIDLabelsParams) (*GetNotificationEndpointsIDLabelsResponse, error) {
	rsp, err := c.GetNotificationEndpointsIDLabels(ctx, endpointID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationEndpointsIDLabelsResponse(rsp)
}

// PostNotificationEndpointIDLabelsWithBodyWithResponse request with arbitrary body returning *PostNotificationEndpointIDLabelsResponse
func (c *ClientWithResponses) PostNotificationEndpointIDLabelsWithBodyWithResponse(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, contentType string, body io.Reader) (*PostNotificationEndpointIDLabelsResponse, error) {
	rsp, err := c.PostNotificationEndpointIDLabelsWithBody(ctx, endpointID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationEndpointIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostNotificationEndpointIDLabelsWithResponse(ctx context.Context, endpointID string, params *PostNotificationEndpointIDLabelsParams, body PostNotificationEndpointIDLabelsJSONRequestBody) (*PostNotificationEndpointIDLabelsResponse, error) {
	rsp, err := c.PostNotificationEndpointIDLabels(ctx, endpointID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationEndpointIDLabelsResponse(rsp)
}

// DeleteNotificationEndpointsIDLabelsIDWithResponse request returning *DeleteNotificationEndpointsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteNotificationEndpointsIDLabelsIDWithResponse(ctx context.Context, endpointID string, labelID string, params *DeleteNotificationEndpointsIDLabelsIDParams) (*DeleteNotificationEndpointsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteNotificationEndpointsIDLabelsID(ctx, endpointID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationEndpointsIDLabelsIDResponse(rsp)
}

// GetNotificationRulesWithResponse request returning *GetNotificationRulesResponse
func (c *ClientWithResponses) GetNotificationRulesWithResponse(ctx context.Context, params *GetNotificationRulesParams) (*GetNotificationRulesResponse, error) {
	rsp, err := c.GetNotificationRules(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesResponse(rsp)
}

// CreateNotificationRuleWithBodyWithResponse request with arbitrary body returning *CreateNotificationRuleResponse
func (c *ClientWithResponses) CreateNotificationRuleWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateNotificationRuleResponse, error) {
	rsp, err := c.CreateNotificationRuleWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationRuleResponse(rsp)
}

func (c *ClientWithResponses) CreateNotificationRuleWithResponse(ctx context.Context, body CreateNotificationRuleJSONRequestBody) (*CreateNotificationRuleResponse, error) {
	rsp, err := c.CreateNotificationRule(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateNotificationRuleResponse(rsp)
}

// DeleteNotificationRulesIDWithResponse request returning *DeleteNotificationRulesIDResponse
func (c *ClientWithResponses) DeleteNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *DeleteNotificationRulesIDParams) (*DeleteNotificationRulesIDResponse, error) {
	rsp, err := c.DeleteNotificationRulesID(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationRulesIDResponse(rsp)
}

// GetNotificationRulesIDWithResponse request returning *GetNotificationRulesIDResponse
func (c *ClientWithResponses) GetNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDParams) (*GetNotificationRulesIDResponse, error) {
	rsp, err := c.GetNotificationRulesID(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesIDResponse(rsp)
}

// PatchNotificationRulesIDWithBodyWithResponse request with arbitrary body returning *PatchNotificationRulesIDResponse
func (c *ClientWithResponses) PatchNotificationRulesIDWithBodyWithResponse(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, contentType string, body io.Reader) (*PatchNotificationRulesIDResponse, error) {
	rsp, err := c.PatchNotificationRulesIDWithBody(ctx, ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationRulesIDResponse(rsp)
}

func (c *ClientWithResponses) PatchNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *PatchNotificationRulesIDParams, body PatchNotificationRulesIDJSONRequestBody) (*PatchNotificationRulesIDResponse, error) {
	rsp, err := c.PatchNotificationRulesID(ctx, ruleID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchNotificationRulesIDResponse(rsp)
}

// PutNotificationRulesIDWithBodyWithResponse request with arbitrary body returning *PutNotificationRulesIDResponse
func (c *ClientWithResponses) PutNotificationRulesIDWithBodyWithResponse(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, contentType string, body io.Reader) (*PutNotificationRulesIDResponse, error) {
	rsp, err := c.PutNotificationRulesIDWithBody(ctx, ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationRulesIDResponse(rsp)
}

func (c *ClientWithResponses) PutNotificationRulesIDWithResponse(ctx context.Context, ruleID string, params *PutNotificationRulesIDParams, body PutNotificationRulesIDJSONRequestBody) (*PutNotificationRulesIDResponse, error) {
	rsp, err := c.PutNotificationRulesID(ctx, ruleID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutNotificationRulesIDResponse(rsp)
}

// GetNotificationRulesIDLabelsWithResponse request returning *GetNotificationRulesIDLabelsResponse
func (c *ClientWithResponses) GetNotificationRulesIDLabelsWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDLabelsParams) (*GetNotificationRulesIDLabelsResponse, error) {
	rsp, err := c.GetNotificationRulesIDLabels(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesIDLabelsResponse(rsp)
}

// PostNotificationRuleIDLabelsWithBodyWithResponse request with arbitrary body returning *PostNotificationRuleIDLabelsResponse
func (c *ClientWithResponses) PostNotificationRuleIDLabelsWithBodyWithResponse(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, contentType string, body io.Reader) (*PostNotificationRuleIDLabelsResponse, error) {
	rsp, err := c.PostNotificationRuleIDLabelsWithBody(ctx, ruleID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationRuleIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostNotificationRuleIDLabelsWithResponse(ctx context.Context, ruleID string, params *PostNotificationRuleIDLabelsParams, body PostNotificationRuleIDLabelsJSONRequestBody) (*PostNotificationRuleIDLabelsResponse, error) {
	rsp, err := c.PostNotificationRuleIDLabels(ctx, ruleID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostNotificationRuleIDLabelsResponse(rsp)
}

// DeleteNotificationRulesIDLabelsIDWithResponse request returning *DeleteNotificationRulesIDLabelsIDResponse
func (c *ClientWithResponses) DeleteNotificationRulesIDLabelsIDWithResponse(ctx context.Context, ruleID string, labelID string, params *DeleteNotificationRulesIDLabelsIDParams) (*DeleteNotificationRulesIDLabelsIDResponse, error) {
	rsp, err := c.DeleteNotificationRulesIDLabelsID(ctx, ruleID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteNotificationRulesIDLabelsIDResponse(rsp)
}

// GetNotificationRulesIDQueryWithResponse request returning *GetNotificationRulesIDQueryResponse
func (c *ClientWithResponses) GetNotificationRulesIDQueryWithResponse(ctx context.Context, ruleID string, params *GetNotificationRulesIDQueryParams) (*GetNotificationRulesIDQueryResponse, error) {
	rsp, err := c.GetNotificationRulesIDQuery(ctx, ruleID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetNotificationRulesIDQueryResponse(rsp)
}

// GetOrgsWithResponse request returning *GetOrgsResponse
func (c *ClientWithResponses) GetOrgsWithResponse(ctx context.Context, params *GetOrgsParams) (*GetOrgsResponse, error) {
	rsp, err := c.GetOrgs(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsResponse(rsp)
}

// PostOrgsWithBodyWithResponse request with arbitrary body returning *PostOrgsResponse
func (c *ClientWithResponses) PostOrgsWithBodyWithResponse(ctx context.Context, params *PostOrgsParams, contentType string, body io.Reader) (*PostOrgsResponse, error) {
	rsp, err := c.PostOrgsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsWithResponse(ctx context.Context, params *PostOrgsParams, body PostOrgsJSONRequestBody) (*PostOrgsResponse, error) {
	rsp, err := c.PostOrgs(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsResponse(rsp)
}

// DeleteOrgsIDWithResponse request returning *DeleteOrgsIDResponse
func (c *ClientWithResponses) DeleteOrgsIDWithResponse(ctx context.Context, orgID string, params *DeleteOrgsIDParams) (*DeleteOrgsIDResponse, error) {
	rsp, err := c.DeleteOrgsID(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteOrgsIDResponse(rsp)
}

// GetOrgsIDWithResponse request returning *GetOrgsIDResponse
func (c *ClientWithResponses) GetOrgsIDWithResponse(ctx context.Context, orgID string, params *GetOrgsIDParams) (*GetOrgsIDResponse, error) {
	rsp, err := c.GetOrgsID(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDResponse(rsp)
}

// PatchOrgsIDWithBodyWithResponse request with arbitrary body returning *PatchOrgsIDResponse
func (c *ClientWithResponses) PatchOrgsIDWithBodyWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDParams, contentType string, body io.Reader) (*PatchOrgsIDResponse, error) {
	rsp, err := c.PatchOrgsIDWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDResponse(rsp)
}

func (c *ClientWithResponses) PatchOrgsIDWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDParams, body PatchOrgsIDJSONRequestBody) (*PatchOrgsIDResponse, error) {
	rsp, err := c.PatchOrgsID(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDResponse(rsp)
}

// GetOrgsIDMembersWithResponse request returning *GetOrgsIDMembersResponse
func (c *ClientWithResponses) GetOrgsIDMembersWithResponse(ctx context.Context, orgID string, params *GetOrgsIDMembersParams) (*GetOrgsIDMembersResponse, error) {
	rsp, err := c.GetOrgsIDMembers(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDMembersResponse(rsp)
}

// PostOrgsIDMembersWithBodyWithResponse request with arbitrary body returning *PostOrgsIDMembersResponse
func (c *ClientWithResponses) PostOrgsIDMembersWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, contentType string, body io.Reader) (*PostOrgsIDMembersResponse, error) {
	rsp, err := c.PostOrgsIDMembersWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsIDMembersWithResponse(ctx context.Context, orgID string, params *PostOrgsIDMembersParams, body PostOrgsIDMembersJSONRequestBody) (*PostOrgsIDMembersResponse, error) {
	rsp, err := c.PostOrgsIDMembers(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDMembersResponse(rsp)
}

// DeleteOrgsIDMembersIDWithResponse request returning *DeleteOrgsIDMembersIDResponse
func (c *ClientWithResponses) DeleteOrgsIDMembersIDWithResponse(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDMembersIDParams) (*DeleteOrgsIDMembersIDResponse, error) {
	rsp, err := c.DeleteOrgsIDMembersID(ctx, orgID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteOrgsIDMembersIDResponse(rsp)
}

// GetOrgsIDOwnersWithResponse request returning *GetOrgsIDOwnersResponse
func (c *ClientWithResponses) GetOrgsIDOwnersWithResponse(ctx context.Context, orgID string, params *GetOrgsIDOwnersParams) (*GetOrgsIDOwnersResponse, error) {
	rsp, err := c.GetOrgsIDOwners(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDOwnersResponse(rsp)
}

// PostOrgsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostOrgsIDOwnersResponse
func (c *ClientWithResponses) PostOrgsIDOwnersWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, contentType string, body io.Reader) (*PostOrgsIDOwnersResponse, error) {
	rsp, err := c.PostOrgsIDOwnersWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsIDOwnersWithResponse(ctx context.Context, orgID string, params *PostOrgsIDOwnersParams, body PostOrgsIDOwnersJSONRequestBody) (*PostOrgsIDOwnersResponse, error) {
	rsp, err := c.PostOrgsIDOwners(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDOwnersResponse(rsp)
}

// DeleteOrgsIDOwnersIDWithResponse request returning *DeleteOrgsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteOrgsIDOwnersIDWithResponse(ctx context.Context, orgID string, userID string, params *DeleteOrgsIDOwnersIDParams) (*DeleteOrgsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteOrgsIDOwnersID(ctx, orgID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteOrgsIDOwnersIDResponse(rsp)
}

// GetOrgsIDSecretsWithResponse request returning *GetOrgsIDSecretsResponse
func (c *ClientWithResponses) GetOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *GetOrgsIDSecretsParams) (*GetOrgsIDSecretsResponse, error) {
	rsp, err := c.GetOrgsIDSecrets(ctx, orgID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetOrgsIDSecretsResponse(rsp)
}

// PatchOrgsIDSecretsWithBodyWithResponse request with arbitrary body returning *PatchOrgsIDSecretsResponse
func (c *ClientWithResponses) PatchOrgsIDSecretsWithBodyWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, contentType string, body io.Reader) (*PatchOrgsIDSecretsResponse, error) {
	rsp, err := c.PatchOrgsIDSecretsWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDSecretsResponse(rsp)
}

func (c *ClientWithResponses) PatchOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *PatchOrgsIDSecretsParams, body PatchOrgsIDSecretsJSONRequestBody) (*PatchOrgsIDSecretsResponse, error) {
	rsp, err := c.PatchOrgsIDSecrets(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchOrgsIDSecretsResponse(rsp)
}

// PostOrgsIDSecretsWithBodyWithResponse request with arbitrary body returning *PostOrgsIDSecretsResponse
func (c *ClientWithResponses) PostOrgsIDSecretsWithBodyWithResponse(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, contentType string, body io.Reader) (*PostOrgsIDSecretsResponse, error) {
	rsp, err := c.PostOrgsIDSecretsWithBody(ctx, orgID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDSecretsResponse(rsp)
}

func (c *ClientWithResponses) PostOrgsIDSecretsWithResponse(ctx context.Context, orgID string, params *PostOrgsIDSecretsParams, body PostOrgsIDSecretsJSONRequestBody) (*PostOrgsIDSecretsResponse, error) {
	rsp, err := c.PostOrgsIDSecrets(ctx, orgID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostOrgsIDSecretsResponse(rsp)
}

// PostQueryWithBodyWithResponse request with arbitrary body returning *PostQueryResponse
func (c *ClientWithResponses) PostQueryWithBodyWithResponse(ctx context.Context, params *PostQueryParams, contentType string, body io.Reader) (*PostQueryResponse, error) {
	rsp, err := c.PostQueryWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryResponse(rsp)
}

func (c *ClientWithResponses) PostQueryWithResponse(ctx context.Context, params *PostQueryParams, body PostQueryJSONRequestBody) (*PostQueryResponse, error) {
	rsp, err := c.PostQuery(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryResponse(rsp)
}

// PostQueryAnalyzeWithBodyWithResponse request with arbitrary body returning *PostQueryAnalyzeResponse
func (c *ClientWithResponses) PostQueryAnalyzeWithBodyWithResponse(ctx context.Context, params *PostQueryAnalyzeParams, contentType string, body io.Reader) (*PostQueryAnalyzeResponse, error) {
	rsp, err := c.PostQueryAnalyzeWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAnalyzeResponse(rsp)
}

func (c *ClientWithResponses) PostQueryAnalyzeWithResponse(ctx context.Context, params *PostQueryAnalyzeParams, body PostQueryAnalyzeJSONRequestBody) (*PostQueryAnalyzeResponse, error) {
	rsp, err := c.PostQueryAnalyze(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAnalyzeResponse(rsp)
}

// PostQueryAstWithBodyWithResponse request with arbitrary body returning *PostQueryAstResponse
func (c *ClientWithResponses) PostQueryAstWithBodyWithResponse(ctx context.Context, params *PostQueryAstParams, contentType string, body io.Reader) (*PostQueryAstResponse, error) {
	rsp, err := c.PostQueryAstWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAstResponse(rsp)
}

func (c *ClientWithResponses) PostQueryAstWithResponse(ctx context.Context, params *PostQueryAstParams, body PostQueryAstJSONRequestBody) (*PostQueryAstResponse, error) {
	rsp, err := c.PostQueryAst(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostQueryAstResponse(rsp)
}

// GetQuerySuggestionsWithResponse request returning *GetQuerySuggestionsResponse
func (c *ClientWithResponses) GetQuerySuggestionsWithResponse(ctx context.Context, params *GetQuerySuggestionsParams) (*GetQuerySuggestionsResponse, error) {
	rsp, err := c.GetQuerySuggestions(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetQuerySuggestionsResponse(rsp)
}

// GetQuerySuggestionsNameWithResponse request returning *GetQuerySuggestionsNameResponse
func (c *ClientWithResponses) GetQuerySuggestionsNameWithResponse(ctx context.Context, name string, params *GetQuerySuggestionsNameParams) (*GetQuerySuggestionsNameResponse, error) {
	rsp, err := c.GetQuerySuggestionsName(ctx, name, params)
	if err != nil {
		return nil, err
	}
	return ParseGetQuerySuggestionsNameResponse(rsp)
}

// GetReadyWithResponse request returning *GetReadyResponse
func (c *ClientWithResponses) GetReadyWithResponse(ctx context.Context, params *GetReadyParams) (*GetReadyResponse, error) {
	rsp, err := c.GetReady(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetReadyResponse(rsp)
}

// GetScrapersWithResponse request returning *GetScrapersResponse
func (c *ClientWithResponses) GetScrapersWithResponse(ctx context.Context, params *GetScrapersParams) (*GetScrapersResponse, error) {
	rsp, err := c.GetScrapers(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersResponse(rsp)
}

// PostScrapersWithBodyWithResponse request with arbitrary body returning *PostScrapersResponse
func (c *ClientWithResponses) PostScrapersWithBodyWithResponse(ctx context.Context, params *PostScrapersParams, contentType string, body io.Reader) (*PostScrapersResponse, error) {
	rsp, err := c.PostScrapersWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersWithResponse(ctx context.Context, params *PostScrapersParams, body PostScrapersJSONRequestBody) (*PostScrapersResponse, error) {
	rsp, err := c.PostScrapers(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersResponse(rsp)
}

// DeleteScrapersIDWithResponse request returning *DeleteScrapersIDResponse
func (c *ClientWithResponses) DeleteScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *DeleteScrapersIDParams) (*DeleteScrapersIDResponse, error) {
	rsp, err := c.DeleteScrapersID(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDResponse(rsp)
}

// GetScrapersIDWithResponse request returning *GetScrapersIDResponse
func (c *ClientWithResponses) GetScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDParams) (*GetScrapersIDResponse, error) {
	rsp, err := c.GetScrapersID(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDResponse(rsp)
}

// PatchScrapersIDWithBodyWithResponse request with arbitrary body returning *PatchScrapersIDResponse
func (c *ClientWithResponses) PatchScrapersIDWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, contentType string, body io.Reader) (*PatchScrapersIDResponse, error) {
	rsp, err := c.PatchScrapersIDWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchScrapersIDResponse(rsp)
}

func (c *ClientWithResponses) PatchScrapersIDWithResponse(ctx context.Context, scraperTargetID string, params *PatchScrapersIDParams, body PatchScrapersIDJSONRequestBody) (*PatchScrapersIDResponse, error) {
	rsp, err := c.PatchScrapersID(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchScrapersIDResponse(rsp)
}

// GetScrapersIDLabelsWithResponse request returning *GetScrapersIDLabelsResponse
func (c *ClientWithResponses) GetScrapersIDLabelsWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDLabelsParams) (*GetScrapersIDLabelsResponse, error) {
	rsp, err := c.GetScrapersIDLabels(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDLabelsResponse(rsp)
}

// PostScrapersIDLabelsWithBodyWithResponse request with arbitrary body returning *PostScrapersIDLabelsResponse
func (c *ClientWithResponses) PostScrapersIDLabelsWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, contentType string, body io.Reader) (*PostScrapersIDLabelsResponse, error) {
	rsp, err := c.PostScrapersIDLabelsWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersIDLabelsWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDLabelsParams, body PostScrapersIDLabelsJSONRequestBody) (*PostScrapersIDLabelsResponse, error) {
	rsp, err := c.PostScrapersIDLabels(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDLabelsResponse(rsp)
}

// DeleteScrapersIDLabelsIDWithResponse request returning *DeleteScrapersIDLabelsIDResponse
func (c *ClientWithResponses) DeleteScrapersIDLabelsIDWithResponse(ctx context.Context, scraperTargetID string, labelID string, params *DeleteScrapersIDLabelsIDParams) (*DeleteScrapersIDLabelsIDResponse, error) {
	rsp, err := c.DeleteScrapersIDLabelsID(ctx, scraperTargetID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDLabelsIDResponse(rsp)
}

// GetScrapersIDMembersWithResponse request returning *GetScrapersIDMembersResponse
func (c *ClientWithResponses) GetScrapersIDMembersWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDMembersParams) (*GetScrapersIDMembersResponse, error) {
	rsp, err := c.GetScrapersIDMembers(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDMembersResponse(rsp)
}

// PostScrapersIDMembersWithBodyWithResponse request with arbitrary body returning *PostScrapersIDMembersResponse
func (c *ClientWithResponses) PostScrapersIDMembersWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, contentType string, body io.Reader) (*PostScrapersIDMembersResponse, error) {
	rsp, err := c.PostScrapersIDMembersWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersIDMembersWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDMembersParams, body PostScrapersIDMembersJSONRequestBody) (*PostScrapersIDMembersResponse, error) {
	rsp, err := c.PostScrapersIDMembers(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDMembersResponse(rsp)
}

// DeleteScrapersIDMembersIDWithResponse request returning *DeleteScrapersIDMembersIDResponse
func (c *ClientWithResponses) DeleteScrapersIDMembersIDWithResponse(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDMembersIDParams) (*DeleteScrapersIDMembersIDResponse, error) {
	rsp, err := c.DeleteScrapersIDMembersID(ctx, scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDMembersIDResponse(rsp)
}

// GetScrapersIDOwnersWithResponse request returning *GetScrapersIDOwnersResponse
func (c *ClientWithResponses) GetScrapersIDOwnersWithResponse(ctx context.Context, scraperTargetID string, params *GetScrapersIDOwnersParams) (*GetScrapersIDOwnersResponse, error) {
	rsp, err := c.GetScrapersIDOwners(ctx, scraperTargetID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetScrapersIDOwnersResponse(rsp)
}

// PostScrapersIDOwnersWithBodyWithResponse request with arbitrary body returning *PostScrapersIDOwnersResponse
func (c *ClientWithResponses) PostScrapersIDOwnersWithBodyWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, contentType string, body io.Reader) (*PostScrapersIDOwnersResponse, error) {
	rsp, err := c.PostScrapersIDOwnersWithBody(ctx, scraperTargetID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostScrapersIDOwnersWithResponse(ctx context.Context, scraperTargetID string, params *PostScrapersIDOwnersParams, body PostScrapersIDOwnersJSONRequestBody) (*PostScrapersIDOwnersResponse, error) {
	rsp, err := c.PostScrapersIDOwners(ctx, scraperTargetID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostScrapersIDOwnersResponse(rsp)
}

// DeleteScrapersIDOwnersIDWithResponse request returning *DeleteScrapersIDOwnersIDResponse
func (c *ClientWithResponses) DeleteScrapersIDOwnersIDWithResponse(ctx context.Context, scraperTargetID string, userID string, params *DeleteScrapersIDOwnersIDParams) (*DeleteScrapersIDOwnersIDResponse, error) {
	rsp, err := c.DeleteScrapersIDOwnersID(ctx, scraperTargetID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteScrapersIDOwnersIDResponse(rsp)
}

// GetSetupWithResponse request returning *GetSetupResponse
func (c *ClientWithResponses) GetSetupWithResponse(ctx context.Context, params *GetSetupParams) (*GetSetupResponse, error) {
	rsp, err := c.GetSetup(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSetupResponse(rsp)
}

// PostSetupWithBodyWithResponse request with arbitrary body returning *PostSetupResponse
func (c *ClientWithResponses) PostSetupWithBodyWithResponse(ctx context.Context, params *PostSetupParams, contentType string, body io.Reader) (*PostSetupResponse, error) {
	rsp, err := c.PostSetupWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupResponse(rsp)
}

func (c *ClientWithResponses) PostSetupWithResponse(ctx context.Context, params *PostSetupParams, body PostSetupJSONRequestBody) (*PostSetupResponse, error) {
	rsp, err := c.PostSetup(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupResponse(rsp)
}

// PostSetupUserWithBodyWithResponse request with arbitrary body returning *PostSetupUserResponse
func (c *ClientWithResponses) PostSetupUserWithBodyWithResponse(ctx context.Context, params *PostSetupUserParams, contentType string, body io.Reader) (*PostSetupUserResponse, error) {
	rsp, err := c.PostSetupUserWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupUserResponse(rsp)
}

func (c *ClientWithResponses) PostSetupUserWithResponse(ctx context.Context, params *PostSetupUserParams, body PostSetupUserJSONRequestBody) (*PostSetupUserResponse, error) {
	rsp, err := c.PostSetupUser(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSetupUserResponse(rsp)
}

// PostSigninWithResponse request returning *PostSigninResponse
func (c *ClientWithResponses) PostSigninWithResponse(ctx context.Context, params *PostSigninParams) (*PostSigninResponse, error) {
	rsp, err := c.PostSignin(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsePostSigninResponse(rsp)
}

// PostSignoutWithResponse request returning *PostSignoutResponse
func (c *ClientWithResponses) PostSignoutWithResponse(ctx context.Context, params *PostSignoutParams) (*PostSignoutResponse, error) {
	rsp, err := c.PostSignout(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParsePostSignoutResponse(rsp)
}

// GetSourcesWithResponse request returning *GetSourcesResponse
func (c *ClientWithResponses) GetSourcesWithResponse(ctx context.Context, params *GetSourcesParams) (*GetSourcesResponse, error) {
	rsp, err := c.GetSources(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesResponse(rsp)
}

// PostSourcesWithBodyWithResponse request with arbitrary body returning *PostSourcesResponse
func (c *ClientWithResponses) PostSourcesWithBodyWithResponse(ctx context.Context, params *PostSourcesParams, contentType string, body io.Reader) (*PostSourcesResponse, error) {
	rsp, err := c.PostSourcesWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSourcesResponse(rsp)
}

func (c *ClientWithResponses) PostSourcesWithResponse(ctx context.Context, params *PostSourcesParams, body PostSourcesJSONRequestBody) (*PostSourcesResponse, error) {
	rsp, err := c.PostSources(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostSourcesResponse(rsp)
}

// DeleteSourcesIDWithResponse request returning *DeleteSourcesIDResponse
func (c *ClientWithResponses) DeleteSourcesIDWithResponse(ctx context.Context, sourceID string, params *DeleteSourcesIDParams) (*DeleteSourcesIDResponse, error) {
	rsp, err := c.DeleteSourcesID(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteSourcesIDResponse(rsp)
}

// GetSourcesIDWithResponse request returning *GetSourcesIDResponse
func (c *ClientWithResponses) GetSourcesIDWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDParams) (*GetSourcesIDResponse, error) {
	rsp, err := c.GetSourcesID(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesIDResponse(rsp)
}

// PatchSourcesIDWithBodyWithResponse request with arbitrary body returning *PatchSourcesIDResponse
func (c *ClientWithResponses) PatchSourcesIDWithBodyWithResponse(ctx context.Context, sourceID string, params *PatchSourcesIDParams, contentType string, body io.Reader) (*PatchSourcesIDResponse, error) {
	rsp, err := c.PatchSourcesIDWithBody(ctx, sourceID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchSourcesIDResponse(rsp)
}

func (c *ClientWithResponses) PatchSourcesIDWithResponse(ctx context.Context, sourceID string, params *PatchSourcesIDParams, body PatchSourcesIDJSONRequestBody) (*PatchSourcesIDResponse, error) {
	rsp, err := c.PatchSourcesID(ctx, sourceID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchSourcesIDResponse(rsp)
}

// GetSourcesIDBucketsWithResponse request returning *GetSourcesIDBucketsResponse
func (c *ClientWithResponses) GetSourcesIDBucketsWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDBucketsParams) (*GetSourcesIDBucketsResponse, error) {
	rsp, err := c.GetSourcesIDBuckets(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesIDBucketsResponse(rsp)
}

// GetSourcesIDHealthWithResponse request returning *GetSourcesIDHealthResponse
func (c *ClientWithResponses) GetSourcesIDHealthWithResponse(ctx context.Context, sourceID string, params *GetSourcesIDHealthParams) (*GetSourcesIDHealthResponse, error) {
	rsp, err := c.GetSourcesIDHealth(ctx, sourceID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetSourcesIDHealthResponse(rsp)
}

// ListStacksWithResponse request returning *ListStacksResponse
func (c *ClientWithResponses) ListStacksWithResponse(ctx context.Context, params *ListStacksParams) (*ListStacksResponse, error) {
	rsp, err := c.ListStacks(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseListStacksResponse(rsp)
}

// CreateStackWithBodyWithResponse request with arbitrary body returning *CreateStackResponse
func (c *ClientWithResponses) CreateStackWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*CreateStackResponse, error) {
	rsp, err := c.CreateStackWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateStackResponse(rsp)
}

func (c *ClientWithResponses) CreateStackWithResponse(ctx context.Context, body CreateStackJSONRequestBody) (*CreateStackResponse, error) {
	rsp, err := c.CreateStack(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseCreateStackResponse(rsp)
}

// DeleteStackWithResponse request returning *DeleteStackResponse
func (c *ClientWithResponses) DeleteStackWithResponse(ctx context.Context, stackId string, params *DeleteStackParams) (*DeleteStackResponse, error) {
	rsp, err := c.DeleteStack(ctx, stackId, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteStackResponse(rsp)
}

// ReadStackWithResponse request returning *ReadStackResponse
func (c *ClientWithResponses) ReadStackWithResponse(ctx context.Context, stackId string) (*ReadStackResponse, error) {
	rsp, err := c.ReadStack(ctx, stackId)
	if err != nil {
		return nil, err
	}
	return ParseReadStackResponse(rsp)
}

// UpdateStackWithBodyWithResponse request with arbitrary body returning *UpdateStackResponse
func (c *ClientWithResponses) UpdateStackWithBodyWithResponse(ctx context.Context, stackId string, contentType string, body io.Reader) (*UpdateStackResponse, error) {
	rsp, err := c.UpdateStackWithBody(ctx, stackId, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateStackResponse(rsp)
}

func (c *ClientWithResponses) UpdateStackWithResponse(ctx context.Context, stackId string, body UpdateStackJSONRequestBody) (*UpdateStackResponse, error) {
	rsp, err := c.UpdateStack(ctx, stackId, body)
	if err != nil {
		return nil, err
	}
	return ParseUpdateStackResponse(rsp)
}

// UninstallStackWithResponse request returning *UninstallStackResponse
func (c *ClientWithResponses) UninstallStackWithResponse(ctx context.Context, stackId string) (*UninstallStackResponse, error) {
	rsp, err := c.UninstallStack(ctx, stackId)
	if err != nil {
		return nil, err
	}
	return ParseUninstallStackResponse(rsp)
}

// GetTasksWithResponse request returning *GetTasksResponse
func (c *ClientWithResponses) GetTasksWithResponse(ctx context.Context, params *GetTasksParams) (*GetTasksResponse, error) {
	rsp, err := c.GetTasks(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksResponse(rsp)
}

// PostTasksWithBodyWithResponse request with arbitrary body returning *PostTasksResponse
func (c *ClientWithResponses) PostTasksWithBodyWithResponse(ctx context.Context, params *PostTasksParams, contentType string, body io.Reader) (*PostTasksResponse, error) {
	rsp, err := c.PostTasksWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksResponse(rsp)
}

func (c *ClientWithResponses) PostTasksWithResponse(ctx context.Context, params *PostTasksParams, body PostTasksJSONRequestBody) (*PostTasksResponse, error) {
	rsp, err := c.PostTasks(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksResponse(rsp)
}

// DeleteTasksIDWithResponse request returning *DeleteTasksIDResponse
func (c *ClientWithResponses) DeleteTasksIDWithResponse(ctx context.Context, taskID string, params *DeleteTasksIDParams) (*DeleteTasksIDResponse, error) {
	rsp, err := c.DeleteTasksID(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDResponse(rsp)
}

// GetTasksIDWithResponse request returning *GetTasksIDResponse
func (c *ClientWithResponses) GetTasksIDWithResponse(ctx context.Context, taskID string, params *GetTasksIDParams) (*GetTasksIDResponse, error) {
	rsp, err := c.GetTasksID(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDResponse(rsp)
}

// PatchTasksIDWithBodyWithResponse request with arbitrary body returning *PatchTasksIDResponse
func (c *ClientWithResponses) PatchTasksIDWithBodyWithResponse(ctx context.Context, taskID string, params *PatchTasksIDParams, contentType string, body io.Reader) (*PatchTasksIDResponse, error) {
	rsp, err := c.PatchTasksIDWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchTasksIDResponse(rsp)
}

func (c *ClientWithResponses) PatchTasksIDWithResponse(ctx context.Context, taskID string, params *PatchTasksIDParams, body PatchTasksIDJSONRequestBody) (*PatchTasksIDResponse, error) {
	rsp, err := c.PatchTasksID(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchTasksIDResponse(rsp)
}

// GetTasksIDLabelsWithResponse request returning *GetTasksIDLabelsResponse
func (c *ClientWithResponses) GetTasksIDLabelsWithResponse(ctx context.Context, taskID string, params *GetTasksIDLabelsParams) (*GetTasksIDLabelsResponse, error) {
	rsp, err := c.GetTasksIDLabels(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDLabelsResponse(rsp)
}

// PostTasksIDLabelsWithBodyWithResponse request with arbitrary body returning *PostTasksIDLabelsResponse
func (c *ClientWithResponses) PostTasksIDLabelsWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, contentType string, body io.Reader) (*PostTasksIDLabelsResponse, error) {
	rsp, err := c.PostTasksIDLabelsWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDLabelsWithResponse(ctx context.Context, taskID string, params *PostTasksIDLabelsParams, body PostTasksIDLabelsJSONRequestBody) (*PostTasksIDLabelsResponse, error) {
	rsp, err := c.PostTasksIDLabels(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDLabelsResponse(rsp)
}

// DeleteTasksIDLabelsIDWithResponse request returning *DeleteTasksIDLabelsIDResponse
func (c *ClientWithResponses) DeleteTasksIDLabelsIDWithResponse(ctx context.Context, taskID string, labelID string, params *DeleteTasksIDLabelsIDParams) (*DeleteTasksIDLabelsIDResponse, error) {
	rsp, err := c.DeleteTasksIDLabelsID(ctx, taskID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDLabelsIDResponse(rsp)
}

// GetTasksIDLogsWithResponse request returning *GetTasksIDLogsResponse
func (c *ClientWithResponses) GetTasksIDLogsWithResponse(ctx context.Context, taskID string, params *GetTasksIDLogsParams) (*GetTasksIDLogsResponse, error) {
	rsp, err := c.GetTasksIDLogs(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDLogsResponse(rsp)
}

// GetTasksIDMembersWithResponse request returning *GetTasksIDMembersResponse
func (c *ClientWithResponses) GetTasksIDMembersWithResponse(ctx context.Context, taskID string, params *GetTasksIDMembersParams) (*GetTasksIDMembersResponse, error) {
	rsp, err := c.GetTasksIDMembers(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDMembersResponse(rsp)
}

// PostTasksIDMembersWithBodyWithResponse request with arbitrary body returning *PostTasksIDMembersResponse
func (c *ClientWithResponses) PostTasksIDMembersWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDMembersParams, contentType string, body io.Reader) (*PostTasksIDMembersResponse, error) {
	rsp, err := c.PostTasksIDMembersWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDMembersWithResponse(ctx context.Context, taskID string, params *PostTasksIDMembersParams, body PostTasksIDMembersJSONRequestBody) (*PostTasksIDMembersResponse, error) {
	rsp, err := c.PostTasksIDMembers(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDMembersResponse(rsp)
}

// DeleteTasksIDMembersIDWithResponse request returning *DeleteTasksIDMembersIDResponse
func (c *ClientWithResponses) DeleteTasksIDMembersIDWithResponse(ctx context.Context, taskID string, userID string, params *DeleteTasksIDMembersIDParams) (*DeleteTasksIDMembersIDResponse, error) {
	rsp, err := c.DeleteTasksIDMembersID(ctx, taskID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDMembersIDResponse(rsp)
}

// GetTasksIDOwnersWithResponse request returning *GetTasksIDOwnersResponse
func (c *ClientWithResponses) GetTasksIDOwnersWithResponse(ctx context.Context, taskID string, params *GetTasksIDOwnersParams) (*GetTasksIDOwnersResponse, error) {
	rsp, err := c.GetTasksIDOwners(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDOwnersResponse(rsp)
}

// PostTasksIDOwnersWithBodyWithResponse request with arbitrary body returning *PostTasksIDOwnersResponse
func (c *ClientWithResponses) PostTasksIDOwnersWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, contentType string, body io.Reader) (*PostTasksIDOwnersResponse, error) {
	rsp, err := c.PostTasksIDOwnersWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDOwnersWithResponse(ctx context.Context, taskID string, params *PostTasksIDOwnersParams, body PostTasksIDOwnersJSONRequestBody) (*PostTasksIDOwnersResponse, error) {
	rsp, err := c.PostTasksIDOwners(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDOwnersResponse(rsp)
}

// DeleteTasksIDOwnersIDWithResponse request returning *DeleteTasksIDOwnersIDResponse
func (c *ClientWithResponses) DeleteTasksIDOwnersIDWithResponse(ctx context.Context, taskID string, userID string, params *DeleteTasksIDOwnersIDParams) (*DeleteTasksIDOwnersIDResponse, error) {
	rsp, err := c.DeleteTasksIDOwnersID(ctx, taskID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDOwnersIDResponse(rsp)
}

// GetTasksIDRunsWithResponse request returning *GetTasksIDRunsResponse
func (c *ClientWithResponses) GetTasksIDRunsWithResponse(ctx context.Context, taskID string, params *GetTasksIDRunsParams) (*GetTasksIDRunsResponse, error) {
	rsp, err := c.GetTasksIDRuns(ctx, taskID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDRunsResponse(rsp)
}

// PostTasksIDRunsWithBodyWithResponse request with arbitrary body returning *PostTasksIDRunsResponse
func (c *ClientWithResponses) PostTasksIDRunsWithBodyWithResponse(ctx context.Context, taskID string, params *PostTasksIDRunsParams, contentType string, body io.Reader) (*PostTasksIDRunsResponse, error) {
	rsp, err := c.PostTasksIDRunsWithBody(ctx, taskID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDRunsResponse(rsp)
}

func (c *ClientWithResponses) PostTasksIDRunsWithResponse(ctx context.Context, taskID string, params *PostTasksIDRunsParams, body PostTasksIDRunsJSONRequestBody) (*PostTasksIDRunsResponse, error) {
	rsp, err := c.PostTasksIDRuns(ctx, taskID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDRunsResponse(rsp)
}

// DeleteTasksIDRunsIDWithResponse request returning *DeleteTasksIDRunsIDResponse
func (c *ClientWithResponses) DeleteTasksIDRunsIDWithResponse(ctx context.Context, taskID string, runID string, params *DeleteTasksIDRunsIDParams) (*DeleteTasksIDRunsIDResponse, error) {
	rsp, err := c.DeleteTasksIDRunsID(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTasksIDRunsIDResponse(rsp)
}

// GetTasksIDRunsIDWithResponse request returning *GetTasksIDRunsIDResponse
func (c *ClientWithResponses) GetTasksIDRunsIDWithResponse(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDParams) (*GetTasksIDRunsIDResponse, error) {
	rsp, err := c.GetTasksIDRunsID(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDRunsIDResponse(rsp)
}

// GetTasksIDRunsIDLogsWithResponse request returning *GetTasksIDRunsIDLogsResponse
func (c *ClientWithResponses) GetTasksIDRunsIDLogsWithResponse(ctx context.Context, taskID string, runID string, params *GetTasksIDRunsIDLogsParams) (*GetTasksIDRunsIDLogsResponse, error) {
	rsp, err := c.GetTasksIDRunsIDLogs(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTasksIDRunsIDLogsResponse(rsp)
}

// PostTasksIDRunsIDRetryWithResponse request returning *PostTasksIDRunsIDRetryResponse
func (c *ClientWithResponses) PostTasksIDRunsIDRetryWithResponse(ctx context.Context, taskID string, runID string, params *PostTasksIDRunsIDRetryParams) (*PostTasksIDRunsIDRetryResponse, error) {
	rsp, err := c.PostTasksIDRunsIDRetry(ctx, taskID, runID, params)
	if err != nil {
		return nil, err
	}
	return ParsePostTasksIDRunsIDRetryResponse(rsp)
}

// GetTelegrafPluginsWithResponse request returning *GetTelegrafPluginsResponse
func (c *ClientWithResponses) GetTelegrafPluginsWithResponse(ctx context.Context, params *GetTelegrafPluginsParams) (*GetTelegrafPluginsResponse, error) {
	rsp, err := c.GetTelegrafPlugins(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafPluginsResponse(rsp)
}

// GetTelegrafsWithResponse request returning *GetTelegrafsResponse
func (c *ClientWithResponses) GetTelegrafsWithResponse(ctx context.Context, params *GetTelegrafsParams) (*GetTelegrafsResponse, error) {
	rsp, err := c.GetTelegrafs(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsResponse(rsp)
}

// PostTelegrafsWithBodyWithResponse request with arbitrary body returning *PostTelegrafsResponse
func (c *ClientWithResponses) PostTelegrafsWithBodyWithResponse(ctx context.Context, params *PostTelegrafsParams, contentType string, body io.Reader) (*PostTelegrafsResponse, error) {
	rsp, err := c.PostTelegrafsWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsWithResponse(ctx context.Context, params *PostTelegrafsParams, body PostTelegrafsJSONRequestBody) (*PostTelegrafsResponse, error) {
	rsp, err := c.PostTelegrafs(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsResponse(rsp)
}

// DeleteTelegrafsIDWithResponse request returning *DeleteTelegrafsIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *DeleteTelegrafsIDParams) (*DeleteTelegrafsIDResponse, error) {
	rsp, err := c.DeleteTelegrafsID(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDResponse(rsp)
}

// GetTelegrafsIDWithResponse request returning *GetTelegrafsIDResponse
func (c *ClientWithResponses) GetTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDParams) (*GetTelegrafsIDResponse, error) {
	rsp, err := c.GetTelegrafsID(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDResponse(rsp)
}

// PutTelegrafsIDWithBodyWithResponse request with arbitrary body returning *PutTelegrafsIDResponse
func (c *ClientWithResponses) PutTelegrafsIDWithBodyWithResponse(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, contentType string, body io.Reader) (*PutTelegrafsIDResponse, error) {
	rsp, err := c.PutTelegrafsIDWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutTelegrafsIDResponse(rsp)
}

func (c *ClientWithResponses) PutTelegrafsIDWithResponse(ctx context.Context, telegrafID string, params *PutTelegrafsIDParams, body PutTelegrafsIDJSONRequestBody) (*PutTelegrafsIDResponse, error) {
	rsp, err := c.PutTelegrafsID(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutTelegrafsIDResponse(rsp)
}

// GetTelegrafsIDLabelsWithResponse request returning *GetTelegrafsIDLabelsResponse
func (c *ClientWithResponses) GetTelegrafsIDLabelsWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDLabelsParams) (*GetTelegrafsIDLabelsResponse, error) {
	rsp, err := c.GetTelegrafsIDLabels(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDLabelsResponse(rsp)
}

// PostTelegrafsIDLabelsWithBodyWithResponse request with arbitrary body returning *PostTelegrafsIDLabelsResponse
func (c *ClientWithResponses) PostTelegrafsIDLabelsWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, contentType string, body io.Reader) (*PostTelegrafsIDLabelsResponse, error) {
	rsp, err := c.PostTelegrafsIDLabelsWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsIDLabelsWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDLabelsParams, body PostTelegrafsIDLabelsJSONRequestBody) (*PostTelegrafsIDLabelsResponse, error) {
	rsp, err := c.PostTelegrafsIDLabels(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDLabelsResponse(rsp)
}

// DeleteTelegrafsIDLabelsIDWithResponse request returning *DeleteTelegrafsIDLabelsIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDLabelsIDWithResponse(ctx context.Context, telegrafID string, labelID string, params *DeleteTelegrafsIDLabelsIDParams) (*DeleteTelegrafsIDLabelsIDResponse, error) {
	rsp, err := c.DeleteTelegrafsIDLabelsID(ctx, telegrafID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDLabelsIDResponse(rsp)
}

// GetTelegrafsIDMembersWithResponse request returning *GetTelegrafsIDMembersResponse
func (c *ClientWithResponses) GetTelegrafsIDMembersWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDMembersParams) (*GetTelegrafsIDMembersResponse, error) {
	rsp, err := c.GetTelegrafsIDMembers(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDMembersResponse(rsp)
}

// PostTelegrafsIDMembersWithBodyWithResponse request with arbitrary body returning *PostTelegrafsIDMembersResponse
func (c *ClientWithResponses) PostTelegrafsIDMembersWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, contentType string, body io.Reader) (*PostTelegrafsIDMembersResponse, error) {
	rsp, err := c.PostTelegrafsIDMembersWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDMembersResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsIDMembersWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDMembersParams, body PostTelegrafsIDMembersJSONRequestBody) (*PostTelegrafsIDMembersResponse, error) {
	rsp, err := c.PostTelegrafsIDMembers(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDMembersResponse(rsp)
}

// DeleteTelegrafsIDMembersIDWithResponse request returning *DeleteTelegrafsIDMembersIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDMembersIDWithResponse(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDMembersIDParams) (*DeleteTelegrafsIDMembersIDResponse, error) {
	rsp, err := c.DeleteTelegrafsIDMembersID(ctx, telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDMembersIDResponse(rsp)
}

// GetTelegrafsIDOwnersWithResponse request returning *GetTelegrafsIDOwnersResponse
func (c *ClientWithResponses) GetTelegrafsIDOwnersWithResponse(ctx context.Context, telegrafID string, params *GetTelegrafsIDOwnersParams) (*GetTelegrafsIDOwnersResponse, error) {
	rsp, err := c.GetTelegrafsIDOwners(ctx, telegrafID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetTelegrafsIDOwnersResponse(rsp)
}

// PostTelegrafsIDOwnersWithBodyWithResponse request with arbitrary body returning *PostTelegrafsIDOwnersResponse
func (c *ClientWithResponses) PostTelegrafsIDOwnersWithBodyWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, contentType string, body io.Reader) (*PostTelegrafsIDOwnersResponse, error) {
	rsp, err := c.PostTelegrafsIDOwnersWithBody(ctx, telegrafID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDOwnersResponse(rsp)
}

func (c *ClientWithResponses) PostTelegrafsIDOwnersWithResponse(ctx context.Context, telegrafID string, params *PostTelegrafsIDOwnersParams, body PostTelegrafsIDOwnersJSONRequestBody) (*PostTelegrafsIDOwnersResponse, error) {
	rsp, err := c.PostTelegrafsIDOwners(ctx, telegrafID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostTelegrafsIDOwnersResponse(rsp)
}

// DeleteTelegrafsIDOwnersIDWithResponse request returning *DeleteTelegrafsIDOwnersIDResponse
func (c *ClientWithResponses) DeleteTelegrafsIDOwnersIDWithResponse(ctx context.Context, telegrafID string, userID string, params *DeleteTelegrafsIDOwnersIDParams) (*DeleteTelegrafsIDOwnersIDResponse, error) {
	rsp, err := c.DeleteTelegrafsIDOwnersID(ctx, telegrafID, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteTelegrafsIDOwnersIDResponse(rsp)
}

// ApplyTemplateWithBodyWithResponse request with arbitrary body returning *ApplyTemplateResponse
func (c *ClientWithResponses) ApplyTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*ApplyTemplateResponse, error) {
	rsp, err := c.ApplyTemplateWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseApplyTemplateResponse(rsp)
}

func (c *ClientWithResponses) ApplyTemplateWithResponse(ctx context.Context, body ApplyTemplateJSONRequestBody) (*ApplyTemplateResponse, error) {
	rsp, err := c.ApplyTemplate(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseApplyTemplateResponse(rsp)
}

// ExportTemplateWithBodyWithResponse request with arbitrary body returning *ExportTemplateResponse
func (c *ClientWithResponses) ExportTemplateWithBodyWithResponse(ctx context.Context, contentType string, body io.Reader) (*ExportTemplateResponse, error) {
	rsp, err := c.ExportTemplateWithBody(ctx, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParseExportTemplateResponse(rsp)
}

func (c *ClientWithResponses) ExportTemplateWithResponse(ctx context.Context, body ExportTemplateJSONRequestBody) (*ExportTemplateResponse, error) {
	rsp, err := c.ExportTemplate(ctx, body)
	if err != nil {
		return nil, err
	}
	return ParseExportTemplateResponse(rsp)
}

// GetUsersWithResponse request returning *GetUsersResponse
func (c *ClientWithResponses) GetUsersWithResponse(ctx context.Context, params *GetUsersParams) (*GetUsersResponse, error) {
	rsp, err := c.GetUsers(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetUsersResponse(rsp)
}

// PostUsersWithBodyWithResponse request with arbitrary body returning *PostUsersResponse
func (c *ClientWithResponses) PostUsersWithBodyWithResponse(ctx context.Context, params *PostUsersParams, contentType string, body io.Reader) (*PostUsersResponse, error) {
	rsp, err := c.PostUsersWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersResponse(rsp)
}

func (c *ClientWithResponses) PostUsersWithResponse(ctx context.Context, params *PostUsersParams, body PostUsersJSONRequestBody) (*PostUsersResponse, error) {
	rsp, err := c.PostUsers(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersResponse(rsp)
}

// DeleteUsersIDWithResponse request returning *DeleteUsersIDResponse
func (c *ClientWithResponses) DeleteUsersIDWithResponse(ctx context.Context, userID string, params *DeleteUsersIDParams) (*DeleteUsersIDResponse, error) {
	rsp, err := c.DeleteUsersID(ctx, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteUsersIDResponse(rsp)
}

// GetUsersIDWithResponse request returning *GetUsersIDResponse
func (c *ClientWithResponses) GetUsersIDWithResponse(ctx context.Context, userID string, params *GetUsersIDParams) (*GetUsersIDResponse, error) {
	rsp, err := c.GetUsersID(ctx, userID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetUsersIDResponse(rsp)
}

// PatchUsersIDWithBodyWithResponse request with arbitrary body returning *PatchUsersIDResponse
func (c *ClientWithResponses) PatchUsersIDWithBodyWithResponse(ctx context.Context, userID string, params *PatchUsersIDParams, contentType string, body io.Reader) (*PatchUsersIDResponse, error) {
	rsp, err := c.PatchUsersIDWithBody(ctx, userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchUsersIDResponse(rsp)
}

func (c *ClientWithResponses) PatchUsersIDWithResponse(ctx context.Context, userID string, params *PatchUsersIDParams, body PatchUsersIDJSONRequestBody) (*PatchUsersIDResponse, error) {
	rsp, err := c.PatchUsersID(ctx, userID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchUsersIDResponse(rsp)
}

// PostUsersIDPasswordWithBodyWithResponse request with arbitrary body returning *PostUsersIDPasswordResponse
func (c *ClientWithResponses) PostUsersIDPasswordWithBodyWithResponse(ctx context.Context, userID string, params *PostUsersIDPasswordParams, contentType string, body io.Reader) (*PostUsersIDPasswordResponse, error) {
	rsp, err := c.PostUsersIDPasswordWithBody(ctx, userID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersIDPasswordResponse(rsp)
}

func (c *ClientWithResponses) PostUsersIDPasswordWithResponse(ctx context.Context, userID string, params *PostUsersIDPasswordParams, body PostUsersIDPasswordJSONRequestBody) (*PostUsersIDPasswordResponse, error) {
	rsp, err := c.PostUsersIDPassword(ctx, userID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostUsersIDPasswordResponse(rsp)
}

// GetVariablesWithResponse request returning *GetVariablesResponse
func (c *ClientWithResponses) GetVariablesWithResponse(ctx context.Context, params *GetVariablesParams) (*GetVariablesResponse, error) {
	rsp, err := c.GetVariables(ctx, params)
	if err != nil {
		return nil, err
	}
	return ParseGetVariablesResponse(rsp)
}

// PostVariablesWithBodyWithResponse request with arbitrary body returning *PostVariablesResponse
func (c *ClientWithResponses) PostVariablesWithBodyWithResponse(ctx context.Context, params *PostVariablesParams, contentType string, body io.Reader) (*PostVariablesResponse, error) {
	rsp, err := c.PostVariablesWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesResponse(rsp)
}

func (c *ClientWithResponses) PostVariablesWithResponse(ctx context.Context, params *PostVariablesParams, body PostVariablesJSONRequestBody) (*PostVariablesResponse, error) {
	rsp, err := c.PostVariables(ctx, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesResponse(rsp)
}

// DeleteVariablesIDWithResponse request returning *DeleteVariablesIDResponse
func (c *ClientWithResponses) DeleteVariablesIDWithResponse(ctx context.Context, variableID string, params *DeleteVariablesIDParams) (*DeleteVariablesIDResponse, error) {
	rsp, err := c.DeleteVariablesID(ctx, variableID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteVariablesIDResponse(rsp)
}

// GetVariablesIDWithResponse request returning *GetVariablesIDResponse
func (c *ClientWithResponses) GetVariablesIDWithResponse(ctx context.Context, variableID string, params *GetVariablesIDParams) (*GetVariablesIDResponse, error) {
	rsp, err := c.GetVariablesID(ctx, variableID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetVariablesIDResponse(rsp)
}

// PatchVariablesIDWithBodyWithResponse request with arbitrary body returning *PatchVariablesIDResponse
func (c *ClientWithResponses) PatchVariablesIDWithBodyWithResponse(ctx context.Context, variableID string, params *PatchVariablesIDParams, contentType string, body io.Reader) (*PatchVariablesIDResponse, error) {
	rsp, err := c.PatchVariablesIDWithBody(ctx, variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchVariablesIDResponse(rsp)
}

func (c *ClientWithResponses) PatchVariablesIDWithResponse(ctx context.Context, variableID string, params *PatchVariablesIDParams, body PatchVariablesIDJSONRequestBody) (*PatchVariablesIDResponse, error) {
	rsp, err := c.PatchVariablesID(ctx, variableID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePatchVariablesIDResponse(rsp)
}

// PutVariablesIDWithBodyWithResponse request with arbitrary body returning *PutVariablesIDResponse
func (c *ClientWithResponses) PutVariablesIDWithBodyWithResponse(ctx context.Context, variableID string, params *PutVariablesIDParams, contentType string, body io.Reader) (*PutVariablesIDResponse, error) {
	rsp, err := c.PutVariablesIDWithBody(ctx, variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePutVariablesIDResponse(rsp)
}

func (c *ClientWithResponses) PutVariablesIDWithResponse(ctx context.Context, variableID string, params *PutVariablesIDParams, body PutVariablesIDJSONRequestBody) (*PutVariablesIDResponse, error) {
	rsp, err := c.PutVariablesID(ctx, variableID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePutVariablesIDResponse(rsp)
}

// GetVariablesIDLabelsWithResponse request returning *GetVariablesIDLabelsResponse
func (c *ClientWithResponses) GetVariablesIDLabelsWithResponse(ctx context.Context, variableID string, params *GetVariablesIDLabelsParams) (*GetVariablesIDLabelsResponse, error) {
	rsp, err := c.GetVariablesIDLabels(ctx, variableID, params)
	if err != nil {
		return nil, err
	}
	return ParseGetVariablesIDLabelsResponse(rsp)
}

// PostVariablesIDLabelsWithBodyWithResponse request with arbitrary body returning *PostVariablesIDLabelsResponse
func (c *ClientWithResponses) PostVariablesIDLabelsWithBodyWithResponse(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, contentType string, body io.Reader) (*PostVariablesIDLabelsResponse, error) {
	rsp, err := c.PostVariablesIDLabelsWithBody(ctx, variableID, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesIDLabelsResponse(rsp)
}

func (c *ClientWithResponses) PostVariablesIDLabelsWithResponse(ctx context.Context, variableID string, params *PostVariablesIDLabelsParams, body PostVariablesIDLabelsJSONRequestBody) (*PostVariablesIDLabelsResponse, error) {
	rsp, err := c.PostVariablesIDLabels(ctx, variableID, params, body)
	if err != nil {
		return nil, err
	}
	return ParsePostVariablesIDLabelsResponse(rsp)
}

// DeleteVariablesIDLabelsIDWithResponse request returning *DeleteVariablesIDLabelsIDResponse
func (c *ClientWithResponses) DeleteVariablesIDLabelsIDWithResponse(ctx context.Context, variableID string, labelID string, params *DeleteVariablesIDLabelsIDParams) (*DeleteVariablesIDLabelsIDResponse, error) {
	rsp, err := c.DeleteVariablesIDLabelsID(ctx, variableID, labelID, params)
	if err != nil {
		return nil, err
	}
	return ParseDeleteVariablesIDLabelsIDResponse(rsp)
}

// PostWriteWithBodyWithResponse request with arbitrary body returning *PostWriteResponse
func (c *ClientWithResponses) PostWriteWithBodyWithResponse(ctx context.Context, params *PostWriteParams, contentType string, body io.Reader) (*PostWriteResponse, error) {
	rsp, err := c.PostWriteWithBody(ctx, params, contentType, body)
	if err != nil {
		return nil, err
	}
	return ParsePostWriteResponse(rsp)
}

// ParseGetRoutesResponse parses an HTTP response from a GetRoutesWithResponse call
func ParseGetRoutesResponse(rsp *http.Response) (*GetRoutesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetRoutesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Routes
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetAuthorizationsResponse parses an HTTP response from a GetAuthorizationsWithResponse call
func ParseGetAuthorizationsResponse(rsp *http.Response) (*GetAuthorizationsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetAuthorizationsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Authorizations
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostAuthorizationsResponse parses an HTTP response from a PostAuthorizationsWithResponse call
func ParsePostAuthorizationsResponse(rsp *http.Response) (*PostAuthorizationsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostAuthorizationsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Authorization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteAuthorizationsIDResponse parses an HTTP response from a DeleteAuthorizationsIDWithResponse call
func ParseDeleteAuthorizationsIDResponse(rsp *http.Response) (*DeleteAuthorizationsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteAuthorizationsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetAuthorizationsIDResponse parses an HTTP response from a GetAuthorizationsIDWithResponse call
func ParseGetAuthorizationsIDResponse(rsp *http.Response) (*GetAuthorizationsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetAuthorizationsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Authorization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchAuthorizationsIDResponse parses an HTTP response from a PatchAuthorizationsIDWithResponse call
func ParsePatchAuthorizationsIDResponse(rsp *http.Response) (*PatchAuthorizationsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchAuthorizationsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Authorization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetBucketsResponse parses an HTTP response from a GetBucketsWithResponse call
func ParseGetBucketsResponse(rsp *http.Response) (*GetBucketsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetBucketsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Buckets
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostBucketsResponse parses an HTTP response from a PostBucketsWithResponse call
func ParsePostBucketsResponse(rsp *http.Response) (*PostBucketsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostBucketsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Bucket
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 422:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON422 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteBucketsIDResponse parses an HTTP response from a DeleteBucketsIDWithResponse call
func ParseDeleteBucketsIDResponse(rsp *http.Response) (*DeleteBucketsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteBucketsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetBucketsIDResponse parses an HTTP response from a GetBucketsIDWithResponse call
func ParseGetBucketsIDResponse(rsp *http.Response) (*GetBucketsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetBucketsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Bucket
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchBucketsIDResponse parses an HTTP response from a PatchBucketsIDWithResponse call
func ParsePatchBucketsIDResponse(rsp *http.Response) (*PatchBucketsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchBucketsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Bucket
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetBucketsIDLabelsResponse parses an HTTP response from a GetBucketsIDLabelsWithResponse call
func ParseGetBucketsIDLabelsResponse(rsp *http.Response) (*GetBucketsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetBucketsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostBucketsIDLabelsResponse parses an HTTP response from a PostBucketsIDLabelsWithResponse call
func ParsePostBucketsIDLabelsResponse(rsp *http.Response) (*PostBucketsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostBucketsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteBucketsIDLabelsIDResponse parses an HTTP response from a DeleteBucketsIDLabelsIDWithResponse call
func ParseDeleteBucketsIDLabelsIDResponse(rsp *http.Response) (*DeleteBucketsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteBucketsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetBucketsIDMembersResponse parses an HTTP response from a GetBucketsIDMembersWithResponse call
func ParseGetBucketsIDMembersResponse(rsp *http.Response) (*GetBucketsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetBucketsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostBucketsIDMembersResponse parses an HTTP response from a PostBucketsIDMembersWithResponse call
func ParsePostBucketsIDMembersResponse(rsp *http.Response) (*PostBucketsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostBucketsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteBucketsIDMembersIDResponse parses an HTTP response from a DeleteBucketsIDMembersIDWithResponse call
func ParseDeleteBucketsIDMembersIDResponse(rsp *http.Response) (*DeleteBucketsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteBucketsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetBucketsIDOwnersResponse parses an HTTP response from a GetBucketsIDOwnersWithResponse call
func ParseGetBucketsIDOwnersResponse(rsp *http.Response) (*GetBucketsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetBucketsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostBucketsIDOwnersResponse parses an HTTP response from a PostBucketsIDOwnersWithResponse call
func ParsePostBucketsIDOwnersResponse(rsp *http.Response) (*PostBucketsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostBucketsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteBucketsIDOwnersIDResponse parses an HTTP response from a DeleteBucketsIDOwnersIDWithResponse call
func ParseDeleteBucketsIDOwnersIDResponse(rsp *http.Response) (*DeleteBucketsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteBucketsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetChecksResponse parses an HTTP response from a GetChecksWithResponse call
func ParseGetChecksResponse(rsp *http.Response) (*GetChecksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetChecksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Checks
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseCreateCheckResponse parses an HTTP response from a CreateCheckWithResponse call
func ParseCreateCheckResponse(rsp *http.Response) (*CreateCheckResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateCheckResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteChecksIDResponse parses an HTTP response from a DeleteChecksIDWithResponse call
func ParseDeleteChecksIDResponse(rsp *http.Response) (*DeleteChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetChecksIDResponse parses an HTTP response from a GetChecksIDWithResponse call
func ParseGetChecksIDResponse(rsp *http.Response) (*GetChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchChecksIDResponse parses an HTTP response from a PatchChecksIDWithResponse call
func ParsePatchChecksIDResponse(rsp *http.Response) (*PatchChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutChecksIDResponse parses an HTTP response from a PutChecksIDWithResponse call
func ParsePutChecksIDResponse(rsp *http.Response) (*PutChecksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutChecksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Check
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetChecksIDLabelsResponse parses an HTTP response from a GetChecksIDLabelsWithResponse call
func ParseGetChecksIDLabelsResponse(rsp *http.Response) (*GetChecksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetChecksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostChecksIDLabelsResponse parses an HTTP response from a PostChecksIDLabelsWithResponse call
func ParsePostChecksIDLabelsResponse(rsp *http.Response) (*PostChecksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostChecksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteChecksIDLabelsIDResponse parses an HTTP response from a DeleteChecksIDLabelsIDWithResponse call
func ParseDeleteChecksIDLabelsIDResponse(rsp *http.Response) (*DeleteChecksIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteChecksIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetChecksIDQueryResponse parses an HTTP response from a GetChecksIDQueryWithResponse call
func ParseGetChecksIDQueryResponse(rsp *http.Response) (*GetChecksIDQueryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetChecksIDQueryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDashboardsResponse parses an HTTP response from a GetDashboardsWithResponse call
func ParseGetDashboardsResponse(rsp *http.Response) (*GetDashboardsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDashboardsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Dashboards
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDashboardsResponse parses an HTTP response from a PostDashboardsWithResponse call
func ParsePostDashboardsResponse(rsp *http.Response) (*PostDashboardsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDashboardsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest interface{}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDashboardsIDResponse parses an HTTP response from a DeleteDashboardsIDWithResponse call
func ParseDeleteDashboardsIDResponse(rsp *http.Response) (*DeleteDashboardsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDashboardsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDashboardsIDResponse parses an HTTP response from a GetDashboardsIDWithResponse call
func ParseGetDashboardsIDResponse(rsp *http.Response) (*GetDashboardsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDashboardsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest interface{}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchDashboardsIDResponse parses an HTTP response from a PatchDashboardsIDWithResponse call
func ParsePatchDashboardsIDResponse(rsp *http.Response) (*PatchDashboardsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchDashboardsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Dashboard
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDashboardsIDCellsResponse parses an HTTP response from a PostDashboardsIDCellsWithResponse call
func ParsePostDashboardsIDCellsResponse(rsp *http.Response) (*PostDashboardsIDCellsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDashboardsIDCellsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Cell
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutDashboardsIDCellsResponse parses an HTTP response from a PutDashboardsIDCellsWithResponse call
func ParsePutDashboardsIDCellsResponse(rsp *http.Response) (*PutDashboardsIDCellsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutDashboardsIDCellsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Dashboard
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDashboardsIDCellsIDResponse parses an HTTP response from a DeleteDashboardsIDCellsIDWithResponse call
func ParseDeleteDashboardsIDCellsIDResponse(rsp *http.Response) (*DeleteDashboardsIDCellsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDashboardsIDCellsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchDashboardsIDCellsIDResponse parses an HTTP response from a PatchDashboardsIDCellsIDWithResponse call
func ParsePatchDashboardsIDCellsIDResponse(rsp *http.Response) (*PatchDashboardsIDCellsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchDashboardsIDCellsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Cell
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDashboardsIDCellsIDViewResponse parses an HTTP response from a GetDashboardsIDCellsIDViewWithResponse call
func ParseGetDashboardsIDCellsIDViewResponse(rsp *http.Response) (*GetDashboardsIDCellsIDViewResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDashboardsIDCellsIDViewResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest View
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchDashboardsIDCellsIDViewResponse parses an HTTP response from a PatchDashboardsIDCellsIDViewWithResponse call
func ParsePatchDashboardsIDCellsIDViewResponse(rsp *http.Response) (*PatchDashboardsIDCellsIDViewResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchDashboardsIDCellsIDViewResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest View
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDashboardsIDLabelsResponse parses an HTTP response from a GetDashboardsIDLabelsWithResponse call
func ParseGetDashboardsIDLabelsResponse(rsp *http.Response) (*GetDashboardsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDashboardsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDashboardsIDLabelsResponse parses an HTTP response from a PostDashboardsIDLabelsWithResponse call
func ParsePostDashboardsIDLabelsResponse(rsp *http.Response) (*PostDashboardsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDashboardsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDashboardsIDLabelsIDResponse parses an HTTP response from a DeleteDashboardsIDLabelsIDWithResponse call
func ParseDeleteDashboardsIDLabelsIDResponse(rsp *http.Response) (*DeleteDashboardsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDashboardsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDashboardsIDMembersResponse parses an HTTP response from a GetDashboardsIDMembersWithResponse call
func ParseGetDashboardsIDMembersResponse(rsp *http.Response) (*GetDashboardsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDashboardsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDashboardsIDMembersResponse parses an HTTP response from a PostDashboardsIDMembersWithResponse call
func ParsePostDashboardsIDMembersResponse(rsp *http.Response) (*PostDashboardsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDashboardsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDashboardsIDMembersIDResponse parses an HTTP response from a DeleteDashboardsIDMembersIDWithResponse call
func ParseDeleteDashboardsIDMembersIDResponse(rsp *http.Response) (*DeleteDashboardsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDashboardsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDashboardsIDOwnersResponse parses an HTTP response from a GetDashboardsIDOwnersWithResponse call
func ParseGetDashboardsIDOwnersResponse(rsp *http.Response) (*GetDashboardsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDashboardsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDashboardsIDOwnersResponse parses an HTTP response from a PostDashboardsIDOwnersWithResponse call
func ParsePostDashboardsIDOwnersResponse(rsp *http.Response) (*PostDashboardsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDashboardsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDashboardsIDOwnersIDResponse parses an HTTP response from a DeleteDashboardsIDOwnersIDWithResponse call
func ParseDeleteDashboardsIDOwnersIDResponse(rsp *http.Response) (*DeleteDashboardsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDashboardsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDBRPsResponse parses an HTTP response from a GetDBRPsWithResponse call
func ParseGetDBRPsResponse(rsp *http.Response) (*GetDBRPsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDBRPsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DBRPs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDBRPResponse parses an HTTP response from a PostDBRPWithResponse call
func ParsePostDBRPResponse(rsp *http.Response) (*PostDBRPResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDBRPResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest DBRP
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDBRPIDResponse parses an HTTP response from a DeleteDBRPIDWithResponse call
func ParseDeleteDBRPIDResponse(rsp *http.Response) (*DeleteDBRPIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDBRPIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDBRPsIDResponse parses an HTTP response from a GetDBRPsIDWithResponse call
func ParseGetDBRPsIDResponse(rsp *http.Response) (*GetDBRPsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDBRPsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DBRP
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchDBRPIDResponse parses an HTTP response from a PatchDBRPIDWithResponse call
func ParsePatchDBRPIDResponse(rsp *http.Response) (*PatchDBRPIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchDBRPIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest DBRP
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDeleteResponse parses an HTTP response from a PostDeleteWithResponse call
func ParsePostDeleteResponse(rsp *http.Response) (*PostDeleteResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDeleteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDocumentsTemplatesResponse parses an HTTP response from a GetDocumentsTemplatesWithResponse call
func ParseGetDocumentsTemplatesResponse(rsp *http.Response) (*GetDocumentsTemplatesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDocumentsTemplatesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Documents
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDocumentsTemplatesResponse parses an HTTP response from a PostDocumentsTemplatesWithResponse call
func ParsePostDocumentsTemplatesResponse(rsp *http.Response) (*PostDocumentsTemplatesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDocumentsTemplatesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Document
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDocumentsTemplatesIDResponse parses an HTTP response from a DeleteDocumentsTemplatesIDWithResponse call
func ParseDeleteDocumentsTemplatesIDResponse(rsp *http.Response) (*DeleteDocumentsTemplatesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDocumentsTemplatesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDocumentsTemplatesIDResponse parses an HTTP response from a GetDocumentsTemplatesIDWithResponse call
func ParseGetDocumentsTemplatesIDResponse(rsp *http.Response) (*GetDocumentsTemplatesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDocumentsTemplatesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Document
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutDocumentsTemplatesIDResponse parses an HTTP response from a PutDocumentsTemplatesIDWithResponse call
func ParsePutDocumentsTemplatesIDResponse(rsp *http.Response) (*PutDocumentsTemplatesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutDocumentsTemplatesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Document
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetDocumentsTemplatesIDLabelsResponse parses an HTTP response from a GetDocumentsTemplatesIDLabelsWithResponse call
func ParseGetDocumentsTemplatesIDLabelsResponse(rsp *http.Response) (*GetDocumentsTemplatesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetDocumentsTemplatesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostDocumentsTemplatesIDLabelsResponse parses an HTTP response from a PostDocumentsTemplatesIDLabelsWithResponse call
func ParsePostDocumentsTemplatesIDLabelsResponse(rsp *http.Response) (*PostDocumentsTemplatesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostDocumentsTemplatesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteDocumentsTemplatesIDLabelsIDResponse parses an HTTP response from a DeleteDocumentsTemplatesIDLabelsIDWithResponse call
func ParseDeleteDocumentsTemplatesIDLabelsIDResponse(rsp *http.Response) (*DeleteDocumentsTemplatesIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteDocumentsTemplatesIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetFlagsResponse parses an HTTP response from a GetFlagsWithResponse call
func ParseGetFlagsResponse(rsp *http.Response) (*GetFlagsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetFlagsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Flags
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetHealthResponse parses an HTTP response from a GetHealthWithResponse call
func ParseGetHealthResponse(rsp *http.Response) (*GetHealthResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetHealthResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetLabelsResponse parses an HTTP response from a GetLabelsWithResponse call
func ParseGetLabelsResponse(rsp *http.Response) (*GetLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostLabelsResponse parses an HTTP response from a PostLabelsWithResponse call
func ParsePostLabelsResponse(rsp *http.Response) (*PostLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteLabelsIDResponse parses an HTTP response from a DeleteLabelsIDWithResponse call
func ParseDeleteLabelsIDResponse(rsp *http.Response) (*DeleteLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetLabelsIDResponse parses an HTTP response from a GetLabelsIDWithResponse call
func ParseGetLabelsIDResponse(rsp *http.Response) (*GetLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchLabelsIDResponse parses an HTTP response from a PatchLabelsIDWithResponse call
func ParsePatchLabelsIDResponse(rsp *http.Response) (*PatchLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetMeResponse parses an HTTP response from a GetMeWithResponse call
func ParseGetMeResponse(rsp *http.Response) (*GetMeResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetMeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutMePasswordResponse parses an HTTP response from a PutMePasswordWithResponse call
func ParsePutMePasswordResponse(rsp *http.Response) (*PutMePasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutMePasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationEndpointsResponse parses an HTTP response from a GetNotificationEndpointsWithResponse call
func ParseGetNotificationEndpointsResponse(rsp *http.Response) (*GetNotificationEndpointsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationEndpointsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoints
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseCreateNotificationEndpointResponse parses an HTTP response from a CreateNotificationEndpointWithResponse call
func ParseCreateNotificationEndpointResponse(rsp *http.Response) (*CreateNotificationEndpointResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateNotificationEndpointResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteNotificationEndpointsIDResponse parses an HTTP response from a DeleteNotificationEndpointsIDWithResponse call
func ParseDeleteNotificationEndpointsIDResponse(rsp *http.Response) (*DeleteNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationEndpointsIDResponse parses an HTTP response from a GetNotificationEndpointsIDWithResponse call
func ParseGetNotificationEndpointsIDResponse(rsp *http.Response) (*GetNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchNotificationEndpointsIDResponse parses an HTTP response from a PatchNotificationEndpointsIDWithResponse call
func ParsePatchNotificationEndpointsIDResponse(rsp *http.Response) (*PatchNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutNotificationEndpointsIDResponse parses an HTTP response from a PutNotificationEndpointsIDWithResponse call
func ParsePutNotificationEndpointsIDResponse(rsp *http.Response) (*PutNotificationEndpointsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutNotificationEndpointsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationEndpoint
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationEndpointsIDLabelsResponse parses an HTTP response from a GetNotificationEndpointsIDLabelsWithResponse call
func ParseGetNotificationEndpointsIDLabelsResponse(rsp *http.Response) (*GetNotificationEndpointsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationEndpointsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostNotificationEndpointIDLabelsResponse parses an HTTP response from a PostNotificationEndpointIDLabelsWithResponse call
func ParsePostNotificationEndpointIDLabelsResponse(rsp *http.Response) (*PostNotificationEndpointIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostNotificationEndpointIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteNotificationEndpointsIDLabelsIDResponse parses an HTTP response from a DeleteNotificationEndpointsIDLabelsIDWithResponse call
func ParseDeleteNotificationEndpointsIDLabelsIDResponse(rsp *http.Response) (*DeleteNotificationEndpointsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteNotificationEndpointsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationRulesResponse parses an HTTP response from a GetNotificationRulesWithResponse call
func ParseGetNotificationRulesResponse(rsp *http.Response) (*GetNotificationRulesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationRulesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRules
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseCreateNotificationRuleResponse parses an HTTP response from a CreateNotificationRuleWithResponse call
func ParseCreateNotificationRuleResponse(rsp *http.Response) (*CreateNotificationRuleResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateNotificationRuleResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteNotificationRulesIDResponse parses an HTTP response from a DeleteNotificationRulesIDWithResponse call
func ParseDeleteNotificationRulesIDResponse(rsp *http.Response) (*DeleteNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationRulesIDResponse parses an HTTP response from a GetNotificationRulesIDWithResponse call
func ParseGetNotificationRulesIDResponse(rsp *http.Response) (*GetNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchNotificationRulesIDResponse parses an HTTP response from a PatchNotificationRulesIDWithResponse call
func ParsePatchNotificationRulesIDResponse(rsp *http.Response) (*PatchNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutNotificationRulesIDResponse parses an HTTP response from a PutNotificationRulesIDWithResponse call
func ParsePutNotificationRulesIDResponse(rsp *http.Response) (*PutNotificationRulesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutNotificationRulesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest NotificationRule
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationRulesIDLabelsResponse parses an HTTP response from a GetNotificationRulesIDLabelsWithResponse call
func ParseGetNotificationRulesIDLabelsResponse(rsp *http.Response) (*GetNotificationRulesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationRulesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostNotificationRuleIDLabelsResponse parses an HTTP response from a PostNotificationRuleIDLabelsWithResponse call
func ParsePostNotificationRuleIDLabelsResponse(rsp *http.Response) (*PostNotificationRuleIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostNotificationRuleIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteNotificationRulesIDLabelsIDResponse parses an HTTP response from a DeleteNotificationRulesIDLabelsIDWithResponse call
func ParseDeleteNotificationRulesIDLabelsIDResponse(rsp *http.Response) (*DeleteNotificationRulesIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteNotificationRulesIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetNotificationRulesIDQueryResponse parses an HTTP response from a GetNotificationRulesIDQueryWithResponse call
func ParseGetNotificationRulesIDQueryResponse(rsp *http.Response) (*GetNotificationRulesIDQueryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetNotificationRulesIDQueryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetOrgsResponse parses an HTTP response from a GetOrgsWithResponse call
func ParseGetOrgsResponse(rsp *http.Response) (*GetOrgsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetOrgsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Organizations
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostOrgsResponse parses an HTTP response from a PostOrgsWithResponse call
func ParsePostOrgsResponse(rsp *http.Response) (*PostOrgsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostOrgsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Organization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteOrgsIDResponse parses an HTTP response from a DeleteOrgsIDWithResponse call
func ParseDeleteOrgsIDResponse(rsp *http.Response) (*DeleteOrgsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteOrgsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetOrgsIDResponse parses an HTTP response from a GetOrgsIDWithResponse call
func ParseGetOrgsIDResponse(rsp *http.Response) (*GetOrgsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetOrgsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Organization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchOrgsIDResponse parses an HTTP response from a PatchOrgsIDWithResponse call
func ParsePatchOrgsIDResponse(rsp *http.Response) (*PatchOrgsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchOrgsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Organization
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetOrgsIDMembersResponse parses an HTTP response from a GetOrgsIDMembersWithResponse call
func ParseGetOrgsIDMembersResponse(rsp *http.Response) (*GetOrgsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetOrgsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostOrgsIDMembersResponse parses an HTTP response from a PostOrgsIDMembersWithResponse call
func ParsePostOrgsIDMembersResponse(rsp *http.Response) (*PostOrgsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostOrgsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteOrgsIDMembersIDResponse parses an HTTP response from a DeleteOrgsIDMembersIDWithResponse call
func ParseDeleteOrgsIDMembersIDResponse(rsp *http.Response) (*DeleteOrgsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteOrgsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetOrgsIDOwnersResponse parses an HTTP response from a GetOrgsIDOwnersWithResponse call
func ParseGetOrgsIDOwnersResponse(rsp *http.Response) (*GetOrgsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetOrgsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostOrgsIDOwnersResponse parses an HTTP response from a PostOrgsIDOwnersWithResponse call
func ParsePostOrgsIDOwnersResponse(rsp *http.Response) (*PostOrgsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostOrgsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteOrgsIDOwnersIDResponse parses an HTTP response from a DeleteOrgsIDOwnersIDWithResponse call
func ParseDeleteOrgsIDOwnersIDResponse(rsp *http.Response) (*DeleteOrgsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteOrgsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetOrgsIDSecretsResponse parses an HTTP response from a GetOrgsIDSecretsWithResponse call
func ParseGetOrgsIDSecretsResponse(rsp *http.Response) (*GetOrgsIDSecretsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetOrgsIDSecretsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest SecretKeysResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchOrgsIDSecretsResponse parses an HTTP response from a PatchOrgsIDSecretsWithResponse call
func ParsePatchOrgsIDSecretsResponse(rsp *http.Response) (*PatchOrgsIDSecretsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchOrgsIDSecretsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostOrgsIDSecretsResponse parses an HTTP response from a PostOrgsIDSecretsWithResponse call
func ParsePostOrgsIDSecretsResponse(rsp *http.Response) (*PostOrgsIDSecretsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostOrgsIDSecretsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostQueryResponse parses an HTTP response from a PostQueryWithResponse call
func ParsePostQueryResponse(rsp *http.Response) (*PostQueryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostQueryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostQueryAnalyzeResponse parses an HTTP response from a PostQueryAnalyzeWithResponse call
func ParsePostQueryAnalyzeResponse(rsp *http.Response) (*PostQueryAnalyzeResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostQueryAnalyzeResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest AnalyzeQueryResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostQueryAstResponse parses an HTTP response from a PostQueryAstWithResponse call
func ParsePostQueryAstResponse(rsp *http.Response) (*PostQueryAstResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostQueryAstResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ASTResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetQuerySuggestionsResponse parses an HTTP response from a GetQuerySuggestionsWithResponse call
func ParseGetQuerySuggestionsResponse(rsp *http.Response) (*GetQuerySuggestionsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetQuerySuggestionsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxSuggestions
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetQuerySuggestionsNameResponse parses an HTTP response from a GetQuerySuggestionsNameWithResponse call
func ParseGetQuerySuggestionsNameResponse(rsp *http.Response) (*GetQuerySuggestionsNameResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetQuerySuggestionsNameResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest FluxSuggestion
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetReadyResponse parses an HTTP response from a GetReadyWithResponse call
func ParseGetReadyResponse(rsp *http.Response) (*GetReadyResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetReadyResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Ready
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetScrapersResponse parses an HTTP response from a GetScrapersWithResponse call
func ParseGetScrapersResponse(rsp *http.Response) (*GetScrapersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetScrapersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ScraperTargetResponses
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostScrapersResponse parses an HTTP response from a PostScrapersWithResponse call
func ParsePostScrapersResponse(rsp *http.Response) (*PostScrapersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostScrapersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ScraperTargetResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteScrapersIDResponse parses an HTTP response from a DeleteScrapersIDWithResponse call
func ParseDeleteScrapersIDResponse(rsp *http.Response) (*DeleteScrapersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteScrapersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetScrapersIDResponse parses an HTTP response from a GetScrapersIDWithResponse call
func ParseGetScrapersIDResponse(rsp *http.Response) (*GetScrapersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetScrapersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ScraperTargetResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchScrapersIDResponse parses an HTTP response from a PatchScrapersIDWithResponse call
func ParsePatchScrapersIDResponse(rsp *http.Response) (*PatchScrapersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchScrapersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ScraperTargetResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetScrapersIDLabelsResponse parses an HTTP response from a GetScrapersIDLabelsWithResponse call
func ParseGetScrapersIDLabelsResponse(rsp *http.Response) (*GetScrapersIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetScrapersIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostScrapersIDLabelsResponse parses an HTTP response from a PostScrapersIDLabelsWithResponse call
func ParsePostScrapersIDLabelsResponse(rsp *http.Response) (*PostScrapersIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostScrapersIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteScrapersIDLabelsIDResponse parses an HTTP response from a DeleteScrapersIDLabelsIDWithResponse call
func ParseDeleteScrapersIDLabelsIDResponse(rsp *http.Response) (*DeleteScrapersIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteScrapersIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetScrapersIDMembersResponse parses an HTTP response from a GetScrapersIDMembersWithResponse call
func ParseGetScrapersIDMembersResponse(rsp *http.Response) (*GetScrapersIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetScrapersIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostScrapersIDMembersResponse parses an HTTP response from a PostScrapersIDMembersWithResponse call
func ParsePostScrapersIDMembersResponse(rsp *http.Response) (*PostScrapersIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostScrapersIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteScrapersIDMembersIDResponse parses an HTTP response from a DeleteScrapersIDMembersIDWithResponse call
func ParseDeleteScrapersIDMembersIDResponse(rsp *http.Response) (*DeleteScrapersIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteScrapersIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetScrapersIDOwnersResponse parses an HTTP response from a GetScrapersIDOwnersWithResponse call
func ParseGetScrapersIDOwnersResponse(rsp *http.Response) (*GetScrapersIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetScrapersIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostScrapersIDOwnersResponse parses an HTTP response from a PostScrapersIDOwnersWithResponse call
func ParsePostScrapersIDOwnersResponse(rsp *http.Response) (*PostScrapersIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostScrapersIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteScrapersIDOwnersIDResponse parses an HTTP response from a DeleteScrapersIDOwnersIDWithResponse call
func ParseDeleteScrapersIDOwnersIDResponse(rsp *http.Response) (*DeleteScrapersIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteScrapersIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetSetupResponse parses an HTTP response from a GetSetupWithResponse call
func ParseGetSetupResponse(rsp *http.Response) (*GetSetupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSetupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest IsOnboarding
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostSetupResponse parses an HTTP response from a PostSetupWithResponse call
func ParsePostSetupResponse(rsp *http.Response) (*PostSetupResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostSetupResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest OnboardingResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostSetupUserResponse parses an HTTP response from a PostSetupUserWithResponse call
func ParsePostSetupUserResponse(rsp *http.Response) (*PostSetupUserResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostSetupUserResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest OnboardingResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostSigninResponse parses an HTTP response from a PostSigninWithResponse call
func ParsePostSigninResponse(rsp *http.Response) (*PostSigninResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostSigninResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostSignoutResponse parses an HTTP response from a PostSignoutWithResponse call
func ParsePostSignoutResponse(rsp *http.Response) (*PostSignoutResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostSignoutResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetSourcesResponse parses an HTTP response from a GetSourcesWithResponse call
func ParseGetSourcesResponse(rsp *http.Response) (*GetSourcesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSourcesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Sources
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostSourcesResponse parses an HTTP response from a PostSourcesWithResponse call
func ParsePostSourcesResponse(rsp *http.Response) (*PostSourcesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostSourcesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Source
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteSourcesIDResponse parses an HTTP response from a DeleteSourcesIDWithResponse call
func ParseDeleteSourcesIDResponse(rsp *http.Response) (*DeleteSourcesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteSourcesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetSourcesIDResponse parses an HTTP response from a GetSourcesIDWithResponse call
func ParseGetSourcesIDResponse(rsp *http.Response) (*GetSourcesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSourcesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Source
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchSourcesIDResponse parses an HTTP response from a PatchSourcesIDWithResponse call
func ParsePatchSourcesIDResponse(rsp *http.Response) (*PatchSourcesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchSourcesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Source
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetSourcesIDBucketsResponse parses an HTTP response from a GetSourcesIDBucketsWithResponse call
func ParseGetSourcesIDBucketsResponse(rsp *http.Response) (*GetSourcesIDBucketsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSourcesIDBucketsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Buckets
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetSourcesIDHealthResponse parses an HTTP response from a GetSourcesIDHealthWithResponse call
func ParseGetSourcesIDHealthResponse(rsp *http.Response) (*GetSourcesIDHealthResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetSourcesIDHealthResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 503:
		var dest HealthCheck
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON503 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseListStacksResponse parses an HTTP response from a ListStacksWithResponse call
func ParseListStacksResponse(rsp *http.Response) (*ListStacksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ListStacksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest struct {
			Stacks *[]Stack `json:"stacks,omitempty"`
		}
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseCreateStackResponse parses an HTTP response from a CreateStackWithResponse call
func ParseCreateStackResponse(rsp *http.Response) (*CreateStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &CreateStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteStackResponse parses an HTTP response from a DeleteStackWithResponse call
func ParseDeleteStackResponse(rsp *http.Response) (*DeleteStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseReadStackResponse parses an HTTP response from a ReadStackWithResponse call
func ParseReadStackResponse(rsp *http.Response) (*ReadStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ReadStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseUpdateStackResponse parses an HTTP response from a UpdateStackWithResponse call
func ParseUpdateStackResponse(rsp *http.Response) (*UpdateStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UpdateStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseUninstallStackResponse parses an HTTP response from a UninstallStackWithResponse call
func ParseUninstallStackResponse(rsp *http.Response) (*UninstallStackResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &UninstallStackResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Stack
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksResponse parses an HTTP response from a GetTasksWithResponse call
func ParseGetTasksResponse(rsp *http.Response) (*GetTasksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Tasks
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTasksResponse parses an HTTP response from a PostTasksWithResponse call
func ParsePostTasksResponse(rsp *http.Response) (*PostTasksResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTasksResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Task
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTasksIDResponse parses an HTTP response from a DeleteTasksIDWithResponse call
func ParseDeleteTasksIDResponse(rsp *http.Response) (*DeleteTasksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTasksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDResponse parses an HTTP response from a GetTasksIDWithResponse call
func ParseGetTasksIDResponse(rsp *http.Response) (*GetTasksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Task
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchTasksIDResponse parses an HTTP response from a PatchTasksIDWithResponse call
func ParsePatchTasksIDResponse(rsp *http.Response) (*PatchTasksIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchTasksIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Task
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDLabelsResponse parses an HTTP response from a GetTasksIDLabelsWithResponse call
func ParseGetTasksIDLabelsResponse(rsp *http.Response) (*GetTasksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTasksIDLabelsResponse parses an HTTP response from a PostTasksIDLabelsWithResponse call
func ParsePostTasksIDLabelsResponse(rsp *http.Response) (*PostTasksIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTasksIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTasksIDLabelsIDResponse parses an HTTP response from a DeleteTasksIDLabelsIDWithResponse call
func ParseDeleteTasksIDLabelsIDResponse(rsp *http.Response) (*DeleteTasksIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTasksIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDLogsResponse parses an HTTP response from a GetTasksIDLogsWithResponse call
func ParseGetTasksIDLogsResponse(rsp *http.Response) (*GetTasksIDLogsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDLogsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Logs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDMembersResponse parses an HTTP response from a GetTasksIDMembersWithResponse call
func ParseGetTasksIDMembersResponse(rsp *http.Response) (*GetTasksIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTasksIDMembersResponse parses an HTTP response from a PostTasksIDMembersWithResponse call
func ParsePostTasksIDMembersResponse(rsp *http.Response) (*PostTasksIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTasksIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTasksIDMembersIDResponse parses an HTTP response from a DeleteTasksIDMembersIDWithResponse call
func ParseDeleteTasksIDMembersIDResponse(rsp *http.Response) (*DeleteTasksIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTasksIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDOwnersResponse parses an HTTP response from a GetTasksIDOwnersWithResponse call
func ParseGetTasksIDOwnersResponse(rsp *http.Response) (*GetTasksIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTasksIDOwnersResponse parses an HTTP response from a PostTasksIDOwnersWithResponse call
func ParsePostTasksIDOwnersResponse(rsp *http.Response) (*PostTasksIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTasksIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTasksIDOwnersIDResponse parses an HTTP response from a DeleteTasksIDOwnersIDWithResponse call
func ParseDeleteTasksIDOwnersIDResponse(rsp *http.Response) (*DeleteTasksIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTasksIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDRunsResponse parses an HTTP response from a GetTasksIDRunsWithResponse call
func ParseGetTasksIDRunsResponse(rsp *http.Response) (*GetTasksIDRunsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDRunsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Runs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTasksIDRunsResponse parses an HTTP response from a PostTasksIDRunsWithResponse call
func ParsePostTasksIDRunsResponse(rsp *http.Response) (*PostTasksIDRunsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTasksIDRunsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Run
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTasksIDRunsIDResponse parses an HTTP response from a DeleteTasksIDRunsIDWithResponse call
func ParseDeleteTasksIDRunsIDResponse(rsp *http.Response) (*DeleteTasksIDRunsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTasksIDRunsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDRunsIDResponse parses an HTTP response from a GetTasksIDRunsIDWithResponse call
func ParseGetTasksIDRunsIDResponse(rsp *http.Response) (*GetTasksIDRunsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDRunsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Run
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTasksIDRunsIDLogsResponse parses an HTTP response from a GetTasksIDRunsIDLogsWithResponse call
func ParseGetTasksIDRunsIDLogsResponse(rsp *http.Response) (*GetTasksIDRunsIDLogsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTasksIDRunsIDLogsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Logs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTasksIDRunsIDRetryResponse parses an HTTP response from a PostTasksIDRunsIDRetryWithResponse call
func ParsePostTasksIDRunsIDRetryResponse(rsp *http.Response) (*PostTasksIDRunsIDRetryResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTasksIDRunsIDRetryResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Run
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTelegrafPluginsResponse parses an HTTP response from a GetTelegrafPluginsWithResponse call
func ParseGetTelegrafPluginsResponse(rsp *http.Response) (*GetTelegrafPluginsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTelegrafPluginsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest TelegrafPlugins
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTelegrafsResponse parses an HTTP response from a GetTelegrafsWithResponse call
func ParseGetTelegrafsResponse(rsp *http.Response) (*GetTelegrafsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTelegrafsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Telegrafs
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTelegrafsResponse parses an HTTP response from a PostTelegrafsWithResponse call
func ParsePostTelegrafsResponse(rsp *http.Response) (*PostTelegrafsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTelegrafsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Telegraf
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTelegrafsIDResponse parses an HTTP response from a DeleteTelegrafsIDWithResponse call
func ParseDeleteTelegrafsIDResponse(rsp *http.Response) (*DeleteTelegrafsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTelegrafsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTelegrafsIDResponse parses an HTTP response from a GetTelegrafsIDWithResponse call
func ParseGetTelegrafsIDResponse(rsp *http.Response) (*GetTelegrafsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTelegrafsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Telegraf
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	case rsp.StatusCode == 200:
		// Content-type (application/toml) unsupported

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutTelegrafsIDResponse parses an HTTP response from a PutTelegrafsIDWithResponse call
func ParsePutTelegrafsIDResponse(rsp *http.Response) (*PutTelegrafsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutTelegrafsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Telegraf
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTelegrafsIDLabelsResponse parses an HTTP response from a GetTelegrafsIDLabelsWithResponse call
func ParseGetTelegrafsIDLabelsResponse(rsp *http.Response) (*GetTelegrafsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTelegrafsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTelegrafsIDLabelsResponse parses an HTTP response from a PostTelegrafsIDLabelsWithResponse call
func ParsePostTelegrafsIDLabelsResponse(rsp *http.Response) (*PostTelegrafsIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTelegrafsIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTelegrafsIDLabelsIDResponse parses an HTTP response from a DeleteTelegrafsIDLabelsIDWithResponse call
func ParseDeleteTelegrafsIDLabelsIDResponse(rsp *http.Response) (*DeleteTelegrafsIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTelegrafsIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTelegrafsIDMembersResponse parses an HTTP response from a GetTelegrafsIDMembersWithResponse call
func ParseGetTelegrafsIDMembersResponse(rsp *http.Response) (*GetTelegrafsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTelegrafsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceMembers
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTelegrafsIDMembersResponse parses an HTTP response from a PostTelegrafsIDMembersWithResponse call
func ParsePostTelegrafsIDMembersResponse(rsp *http.Response) (*PostTelegrafsIDMembersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTelegrafsIDMembersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceMember
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTelegrafsIDMembersIDResponse parses an HTTP response from a DeleteTelegrafsIDMembersIDWithResponse call
func ParseDeleteTelegrafsIDMembersIDResponse(rsp *http.Response) (*DeleteTelegrafsIDMembersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTelegrafsIDMembersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetTelegrafsIDOwnersResponse parses an HTTP response from a GetTelegrafsIDOwnersWithResponse call
func ParseGetTelegrafsIDOwnersResponse(rsp *http.Response) (*GetTelegrafsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetTelegrafsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest ResourceOwners
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostTelegrafsIDOwnersResponse parses an HTTP response from a PostTelegrafsIDOwnersWithResponse call
func ParsePostTelegrafsIDOwnersResponse(rsp *http.Response) (*PostTelegrafsIDOwnersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostTelegrafsIDOwnersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest ResourceOwner
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteTelegrafsIDOwnersIDResponse parses an HTTP response from a DeleteTelegrafsIDOwnersIDWithResponse call
func ParseDeleteTelegrafsIDOwnersIDResponse(rsp *http.Response) (*DeleteTelegrafsIDOwnersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteTelegrafsIDOwnersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseApplyTemplateResponse parses an HTTP response from a ApplyTemplateWithResponse call
func ParseApplyTemplateResponse(rsp *http.Response) (*ApplyTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ApplyTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest TemplateSummary
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest TemplateSummary
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseExportTemplateResponse parses an HTTP response from a ExportTemplateWithResponse call
func ParseExportTemplateResponse(rsp *http.Response) (*ExportTemplateResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &ExportTemplateResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Template
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.YAML200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "yaml") && rsp.StatusCode == 200:
		var dest Template
		if err := yaml.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.YAML200 = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetUsersResponse parses an HTTP response from a GetUsersWithResponse call
func ParseGetUsersResponse(rsp *http.Response) (*GetUsersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetUsersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Users
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostUsersResponse parses an HTTP response from a PostUsersWithResponse call
func ParsePostUsersResponse(rsp *http.Response) (*PostUsersResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostUsersResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteUsersIDResponse parses an HTTP response from a DeleteUsersIDWithResponse call
func ParseDeleteUsersIDResponse(rsp *http.Response) (*DeleteUsersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteUsersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetUsersIDResponse parses an HTTP response from a GetUsersIDWithResponse call
func ParseGetUsersIDResponse(rsp *http.Response) (*GetUsersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetUsersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchUsersIDResponse parses an HTTP response from a PatchUsersIDWithResponse call
func ParsePatchUsersIDResponse(rsp *http.Response) (*PatchUsersIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchUsersIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest User
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostUsersIDPasswordResponse parses an HTTP response from a PostUsersIDPasswordWithResponse call
func ParsePostUsersIDPasswordResponse(rsp *http.Response) (*PostUsersIDPasswordResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostUsersIDPasswordResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetVariablesResponse parses an HTTP response from a GetVariablesWithResponse call
func ParseGetVariablesResponse(rsp *http.Response) (*GetVariablesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetVariablesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variables
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostVariablesResponse parses an HTTP response from a PostVariablesWithResponse call
func ParsePostVariablesResponse(rsp *http.Response) (*PostVariablesResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostVariablesResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteVariablesIDResponse parses an HTTP response from a DeleteVariablesIDWithResponse call
func ParseDeleteVariablesIDResponse(rsp *http.Response) (*DeleteVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetVariablesIDResponse parses an HTTP response from a GetVariablesIDWithResponse call
func ParseGetVariablesIDResponse(rsp *http.Response) (*GetVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePatchVariablesIDResponse parses an HTTP response from a PatchVariablesIDWithResponse call
func ParsePatchVariablesIDResponse(rsp *http.Response) (*PatchVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PatchVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePutVariablesIDResponse parses an HTTP response from a PutVariablesIDWithResponse call
func ParsePutVariablesIDResponse(rsp *http.Response) (*PutVariablesIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PutVariablesIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest Variable
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseGetVariablesIDLabelsResponse parses an HTTP response from a GetVariablesIDLabelsWithResponse call
func ParseGetVariablesIDLabelsResponse(rsp *http.Response) (*GetVariablesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &GetVariablesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 200:
		var dest LabelsResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON200 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostVariablesIDLabelsResponse parses an HTTP response from a PostVariablesIDLabelsWithResponse call
func ParsePostVariablesIDLabelsResponse(rsp *http.Response) (*PostVariablesIDLabelsResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostVariablesIDLabelsResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 201:
		var dest LabelResponse
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON201 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParseDeleteVariablesIDLabelsIDResponse parses an HTTP response from a DeleteVariablesIDLabelsIDWithResponse call
func ParseDeleteVariablesIDLabelsIDResponse(rsp *http.Response) (*DeleteVariablesIDLabelsIDResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &DeleteVariablesIDLabelsIDResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 404:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON404 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}

// ParsePostWriteResponse parses an HTTP response from a PostWriteWithResponse call
func ParsePostWriteResponse(rsp *http.Response) (*PostWriteResponse, error) {
	bodyBytes, err := ioutil.ReadAll(rsp.Body)
	defer rsp.Body.Close()
	if err != nil {
		return nil, err
	}

	response := &PostWriteResponse{
		Body:         bodyBytes,
		HTTPResponse: rsp,
	}

	switch {
	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 400:
		var dest LineProtocolError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON400 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 401:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON401 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 403:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON403 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && rsp.StatusCode == 413:
		var dest LineProtocolLengthError
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSON413 = &dest

	case strings.Contains(rsp.Header.Get("Content-Type"), "json") && true:
		var dest Error
		if err := json.Unmarshal(bodyBytes, &dest); err != nil {
			return nil, err
		}
		response.JSONDefault = &dest

	// Fallback for unexpected error
	default:
		if rsp.StatusCode > 299 {
			return nil, &ihttp.Error{StatusCode: rsp.StatusCode, Message: rsp.Status}
		}
	}

	return response, nil
}
