// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package resourcegraph

import original "github.com/Azure/azure-sdk-for-go/services/preview/resourcegraph/mgmt/2021-03-01-preview/resourcegraph"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ChangeCategory = original.ChangeCategory

const (
	ChangeCategorySystem ChangeCategory = original.ChangeCategorySystem
	ChangeCategoryUser   ChangeCategory = original.ChangeCategoryUser
)

type ChangeType = original.ChangeType

const (
	ChangeTypeCreate ChangeType = original.ChangeTypeCreate
	ChangeTypeDelete ChangeType = original.ChangeTypeDelete
	ChangeTypeUpdate ChangeType = original.ChangeTypeUpdate
)

type ColumnDataType = original.ColumnDataType

const (
	ColumnDataTypeBoolean ColumnDataType = original.ColumnDataTypeBoolean
	ColumnDataTypeInteger ColumnDataType = original.ColumnDataTypeInteger
	ColumnDataTypeNumber  ColumnDataType = original.ColumnDataTypeNumber
	ColumnDataTypeObject  ColumnDataType = original.ColumnDataTypeObject
	ColumnDataTypeString  ColumnDataType = original.ColumnDataTypeString
)

type FacetSortOrder = original.FacetSortOrder

const (
	FacetSortOrderAsc  FacetSortOrder = original.FacetSortOrderAsc
	FacetSortOrderDesc FacetSortOrder = original.FacetSortOrderDesc
)

type PropertyChangeType = original.PropertyChangeType

const (
	PropertyChangeTypeInsert PropertyChangeType = original.PropertyChangeTypeInsert
	PropertyChangeTypeRemove PropertyChangeType = original.PropertyChangeTypeRemove
	PropertyChangeTypeUpdate PropertyChangeType = original.PropertyChangeTypeUpdate
)

type ResultFormat = original.ResultFormat

const (
	ResultFormatObjectArray ResultFormat = original.ResultFormatObjectArray
	ResultFormatTable       ResultFormat = original.ResultFormatTable
)

type ResultFormat1 = original.ResultFormat1

const (
	ResultFormat1ObjectArray ResultFormat1 = original.ResultFormat1ObjectArray
	ResultFormat1Table       ResultFormat1 = original.ResultFormat1Table
)

type ResultTruncated = original.ResultTruncated

const (
	ResultTruncatedFalse ResultTruncated = original.ResultTruncatedFalse
	ResultTruncatedTrue  ResultTruncated = original.ResultTruncatedTrue
)

type ResultType = original.ResultType

const (
	ResultTypeFacet       ResultType = original.ResultTypeFacet
	ResultTypeFacetError  ResultType = original.ResultTypeFacetError
	ResultTypeFacetResult ResultType = original.ResultTypeFacetResult
)

type BaseClient = original.BaseClient
type BasicFacet = original.BasicFacet
type Column = original.Column
type DateTimeInterval = original.DateTimeInterval
type Error = original.Error
type ErrorDetails = original.ErrorDetails
type ErrorResponse = original.ErrorResponse
type Facet = original.Facet
type FacetError = original.FacetError
type FacetRequest = original.FacetRequest
type FacetRequestOptions = original.FacetRequestOptions
type FacetResult = original.FacetResult
type ListResourceChangeData = original.ListResourceChangeData
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationsClient = original.OperationsClient
type QueryRequest = original.QueryRequest
type QueryRequestOptions = original.QueryRequestOptions
type QueryResponse = original.QueryResponse
type ResourceChangeData = original.ResourceChangeData
type ResourceChangeDataAfterSnapshot = original.ResourceChangeDataAfterSnapshot
type ResourceChangeDataBeforeSnapshot = original.ResourceChangeDataBeforeSnapshot
type ResourceChangeDetailsRequestParameters = original.ResourceChangeDetailsRequestParameters
type ResourceChangeList = original.ResourceChangeList
type ResourceChangesRequestParameters = original.ResourceChangesRequestParameters
type ResourceChangesRequestParametersInterval = original.ResourceChangesRequestParametersInterval
type ResourcePropertyChange = original.ResourcePropertyChange
type ResourceSnapshotData = original.ResourceSnapshotData
type ResourcesHistoryRequest = original.ResourcesHistoryRequest
type ResourcesHistoryRequestOptions = original.ResourcesHistoryRequestOptions
type SetObject = original.SetObject
type Table = original.Table

func New() BaseClient {
	return original.New()
}
func NewOperationsClient() OperationsClient {
	return original.NewOperationsClient()
}
func NewOperationsClientWithBaseURI(baseURI string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleChangeCategoryValues() []ChangeCategory {
	return original.PossibleChangeCategoryValues()
}
func PossibleChangeTypeValues() []ChangeType {
	return original.PossibleChangeTypeValues()
}
func PossibleColumnDataTypeValues() []ColumnDataType {
	return original.PossibleColumnDataTypeValues()
}
func PossibleFacetSortOrderValues() []FacetSortOrder {
	return original.PossibleFacetSortOrderValues()
}
func PossiblePropertyChangeTypeValues() []PropertyChangeType {
	return original.PossiblePropertyChangeTypeValues()
}
func PossibleResultFormat1Values() []ResultFormat1 {
	return original.PossibleResultFormat1Values()
}
func PossibleResultFormatValues() []ResultFormat {
	return original.PossibleResultFormatValues()
}
func PossibleResultTruncatedValues() []ResultTruncated {
	return original.PossibleResultTruncatedValues()
}
func PossibleResultTypeValues() []ResultType {
	return original.PossibleResultTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
